/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analyzeReport.impexp.handler;

import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.epm.eb.business.analyzeReport.impexp.handler.ARptVarExportHandler;
import kd.epm.eb.business.analyzeReport.service.AnalyseReportUtil;
import kd.epm.eb.common.analysereport.constants.DimGroupTypeEnum;
import kd.epm.eb.common.analysereport.pojo.VarExportContext;
import kd.epm.eb.common.utils.StringUtils;

public class CombinationExportHandler
extends ARptVarExportHandler {
    public CombinationExportHandler(VarExportContext varExportContext) {
        super(varExportContext);
    }

    @Override
    public Set<String> getIgnoreFields() {
        Set<String> ignoreFields = super.getIgnoreFields();
        ignoreFields.add("formula_show");
        return ignoreFields;
    }

    @Override
    public void selOtherInfo(DynamicObject rowObj, Map<String, Object> rowDataMap) {
        this.getVarExportContext().getCombinationIdNumbMap().put(rowObj.getLong("id"), rowObj.getString("number"));
    }

    @Override
    public void handleData(List<Map<String, Object>> allRowData) {
        super.handleData(allRowData);
        allRowData.forEach(row -> {
            String formula;
            if (DimGroupTypeEnum.FORMULA.getIndex().equals(row.get("dimgrouptype")) && StringUtils.isNotEmpty((String)(formula = (String)row.get("formula")))) {
                List<Map<String, String>> nodeList = AnalyseReportUtil.getInstance().parseToFrontNodes(formula);
                boolean hasChange = false;
                for (Map<String, String> nodeData : nodeList) {
                    String dimGroupNumber;
                    if (!"dimGroup".equals(nodeData.get("type")) || (dimGroupNumber = (String)this.getVarExportContext().getCombinationIdNumbMap().get(Long.valueOf(nodeData.get("id")))) == null) continue;
                    nodeData.put("id", dimGroupNumber);
                    hasChange = true;
                }
                if (hasChange) {
                    row.put("formula", AnalyseReportUtil.getInstance().parseToFormulaString(nodeList, null, null));
                }
            }
        });
    }
}

