/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analyzeReport.impexp.handler;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.analyzeReport.impexp.handler.ARptVarImportHandler;
import kd.epm.eb.business.analyzeReport.service.AnalyseReportUtil;
import kd.epm.eb.business.billimpexp.BillColGroup;
import kd.epm.eb.business.quote.CheckQuote;
import kd.epm.eb.business.quote.MemberQuote;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.analysereport.constants.ApplicableObjectEnum;
import kd.epm.eb.common.analysereport.constants.DimGroupTypeEnum;
import kd.epm.eb.common.analysereport.constants.DimMemberTypeEnum;
import kd.epm.eb.common.analysereport.constants.UnitEnum;
import kd.epm.eb.common.analysereport.constants.VariableTypeEnum;
import kd.epm.eb.common.analysereport.pojo.MemberView;
import kd.epm.eb.common.analysereport.pojo.quote.RefDimColInfo;
import kd.epm.eb.common.analysereport.pojo.quote.RefDimStrInfo;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;

public class CombinationImportHandler
extends ARptVarImportHandler {
    @Override
    protected void selectData(List<Map<String, Object>> allRowData) {
        IModelCacheHelper modelCacheHelper = this.getModelCacheHelper();
        Long bizModelId = this.getBizModelId();
        HashSet<String> allCombNumbers = new HashSet<String>(16);
        HashMap<String, Map<String, Set<String>>> allRefData = new HashMap<String, Map<String, Set<String>>>(16);
        HashMap<String, List<Map<String, String>>> formulaNodes = new HashMap<String, List<Map<String, String>>>(16);
        LinkedList<Map<String, Object>> numberCombRowData = new LinkedList<Map<String, Object>>();
        LinkedList<Map<String, Object>> formulaCombRowData = new LinkedList<Map<String, Object>>();
        this.selRefData(allRowData, numberCombRowData, formulaCombRowData, allRefData, formulaNodes, allCombNumbers);
        Map<String, Map<String, Map<String, DynamicObject>>> refDataObjs = this.getAllRefObj(allRefData);
        Map<String, DynamicObject> combObjs = this.getRefValObjs(VariableTypeEnum.Combination, allCombNumbers);
        Set<String> allRefCombNumbers = this.readRefComb(modelCacheHelper.getModelobj().getId(), bizModelId, allCombNumbers, combObjs);
        BillColGroup colConfig = this.getColConfig();
        List dimensionList = modelCacheHelper.getDimensionListByBusModel(bizModelId);
        this.readNumberComb(dimensionList, numberCombRowData, combObjs, allRefCombNumbers, refDataObjs, colConfig);
        this.getNewObjs().forEach(obj -> combObjs.put(obj.getString("number"), (DynamicObject)obj));
        this.readFormulaComb(formulaCombRowData, dimensionList, combObjs, allRefCombNumbers, colConfig, formulaNodes);
        System.out.println("");
    }

    private void selRefData(List<Map<String, Object>> allRowData, List<Map<String, Object>> numberCombRowData, List<Map<String, Object>> formulaCombRowData, Map<String, Map<String, Set<String>>> allRefData, Map<String, List<Map<String, String>>> formulaNodes, Set<String> allCombNumbers) {
        for (Map<String, Object> rowData : allRowData) {
            String number = (String)rowData.get("number");
            allCombNumbers.add(number);
            String type = (String)rowData.get("dimgrouptype");
            if (DimGroupTypeEnum.NUMBER.getIndex().equals(type)) {
                List entryRows = (List)rowData.get("memberentry");
                if (entryRows != null && entryRows.size() > 0) {
                    for (Map row : entryRows) {
                        String baseDataKey = (String)row.get("memberclasstype");
                        String dimNumber = (String)row.get("dimension");
                        if (!"eb_periodvariable".equals(baseDataKey) && !"eb_dimensionparameter".equals(baseDataKey)) continue;
                        allRefData.computeIfAbsent(baseDataKey, key -> new HashMap(16)).computeIfAbsent(dimNumber, key -> new HashSet(16)).add((String)row.get("member"));
                    }
                }
                numberCombRowData.add(rowData);
                continue;
            }
            String formula = (String)rowData.get("formula");
            if (StringUtils.isNotEmpty((String)formula)) {
                List<Map<String, String>> nodeList = AnalyseReportUtil.getInstance().parseToFrontNodes(formula);
                for (Map<String, String> nodeData : nodeList) {
                    if (!"dimGroup".equals(nodeData.get("type"))) continue;
                    allRefData.computeIfAbsent(VariableTypeEnum.Combination.getMetadata(), key -> new HashMap(16)).computeIfAbsent("", key -> new HashSet(16)).add(nodeData.get("id"));
                }
                formulaNodes.put(number, nodeList);
            }
            formulaCombRowData.add(rowData);
        }
    }

    private void readFormulaComb(List<Map<String, Object>> formulaCombRowData, List<Dimension> dimensionList, Map<String, DynamicObject> combObjs, Set<String> refedCombNumbers, BillColGroup colConfig, Map<String, List<Map<String, String>>> formulaNodes) {
        LinkedList<String> errorList = new LinkedList<String>();
        AnalyseReportUtil analyseReportUtil = AnalyseReportUtil.getInstance();
        List<String> dimNums = dimensionList.stream().map(BaseCache::getNumber).collect(Collectors.toList());
        for (Map<String, Object> rowData : formulaCombRowData) {
            errorList.clear();
            String number = this.getNumber(rowData);
            String name = this.getName(rowData);
            DynamicObject cObj = combObjs.get(number);
            if (this.checkNumberAndName(name, number) || this.checkRepObj(cObj, number, name)) continue;
            List<Map<String, String>> nodeList = formulaNodes.get(number);
            if (nodeList == null) {
                this.addRowErrorLog(number, name, ResManager.loadKDString((String)"\u516c\u5f0f\u914d\u7f6e\u4e3a\u7a7a", (String)"CombinationImportHandler_2", (String)"epm-eb-business", (Object[])new Object[0]));
                continue;
            }
            RefDimColInfo refDimColInfo = new RefDimColInfo();
            HashSet<Long> refDimGroupIds = new HashSet<Long>(16);
            for (Map<String, String> nodeData : nodeList) {
                if (!"dimGroup".equals(nodeData.get("type"))) continue;
                String nodeCombNumber = nodeData.get("id");
                DynamicObject nodeCombObj = combObjs.get(nodeCombNumber);
                if (nodeCombObj == null) {
                    errorList.add(ResManager.loadResFormat((String)"\u5f15\u7528\u7684\u6307\u6807%1\u4e0d\u5b58\u5728", (String)"CombinationImportHandler_3", (String)"epm-eb-business", (Object[])new Object[]{nodeCombNumber}));
                    continue;
                }
                if (!MetricDataTypeEnum.isNumber((String)nodeCombObj.getString("metricdatatype"))) {
                    errorList.add(ResManager.loadResFormat((String)"\u5f15\u7528\u7684\u6307\u6807%1\u7684\u5ea6\u91cf\u4e0d\u662f\u6570\u503c\u7c7b\u578b", (String)"CombinationImportHandler_4", (String)"epm-eb-business", (Object[])new Object[]{nodeCombNumber}));
                    continue;
                }
                if (!nodeCombObj.getString("dimgrouptype").equals("1")) {
                    errorList.add(ResManager.loadResFormat((String)"\u5f15\u7528\u7684\u6307\u6807%1\u4e0d\u662f\u6570\u503c\u7c7b\u578b", (String)"CombinationImportHandler_15", (String)"epm-eb-business", (Object[])new Object[]{nodeCombNumber}));
                    continue;
                }
                nodeData.put("id", nodeCombObj.getString("id"));
                nodeData.put("name", nodeCombObj.getString("name"));
                refDimGroupIds.add(nodeCombObj.getLong("id"));
                analyseReportUtil.selRefDimNumOnObj(nodeCombObj, refDimColInfo);
            }
            if (this.isReplace() && errorList.isEmpty() && cObj != null && refedCombNumbers.contains(number)) {
                if (!cObj.getString("dimgrouptype").equals(rowData.get("dimgrouptype"))) {
                    errorList.add(ResManager.loadKDString((String)"\u6307\u6807\u5df2\u88ab\u5f15\u7528\u4e0d\u53ef\u66f4\u6539\u7c7b\u578b", (String)"CombinationImportHandler_5", (String)"epm-eb-business", (Object[])new Object[0]));
                } else {
                    String _formulaStr = cObj.getString("formula");
                    boolean diff = false;
                    if (StringUtils.isNotEmpty((String)_formulaStr)) {
                        List<Map<String, String>> _nodeList = AnalyseReportUtil.getInstance().parseToFrontNodes(_formulaStr);
                        if (_nodeList.size() != nodeList.size()) {
                            diff = true;
                        } else {
                            for (int seq = 0; seq < nodeList.size(); ++seq) {
                                if (this.checkMapSame(nodeList.get(seq), _nodeList.get(seq), "name")) continue;
                                diff = true;
                                break;
                            }
                        }
                    } else {
                        diff = true;
                    }
                    if (diff) {
                        errorList.add(ResManager.loadKDString((String)"\u76ee\u6807\u4e1a\u52a1\u6a21\u578b\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u7801\u7684\u6307\u6807\u88ab\u5f15\u7528\u4e14\u516c\u5f0f\u914d\u7f6e\u4e0d\u4e00\u81f4", (String)"CombinationImportHandler_6", (String)"epm-eb-business", (Object[])new Object[0]));
                    }
                }
            }
            if (errorList.size() > 0) {
                this.addRowErrorLog(number, name, String.join((CharSequence)";", errorList));
                continue;
            }
            RefDimStrInfo refDimNumsStr = analyseReportUtil.getRefDimNumsStr(refDimColInfo, dimNums);
            DynamicObject obj2Save = this.selObj2Save(colConfig, rowData, cObj, refDimNumsStr);
            Long objId = obj2Save.getLong("id");
            if (refDimGroupIds.size() == 0) {
                this.addQuote(new MemberQuoteDao(this.getModelId(), Long.valueOf(0L), Long.valueOf(0L), Long.valueOf(0L), MemberTypeEnum.DIMGROUP, MemberQuoteResourceEnum.DimGroup, objId));
            } else {
                this.addQuote(new MemberQuoteDao(this.getModelId(), Long.valueOf(0L), Long.valueOf(0L), refDimGroupIds, MemberTypeEnum.DIMGROUP, MemberQuoteResourceEnum.DimGroup, objId));
            }
            StringBuilder formulaToShow = new StringBuilder();
            String formulaString = analyseReportUtil.parseToFormulaString(nodeList, formulaToShow, (Pair<String, String>)new Pair((Object)objId.toString(), (Object)name));
            obj2Save.set("formula_show", (Object)formulaToShow.toString());
            obj2Save.set("formula", (Object)formulaString);
        }
    }

    private void readNumberComb(List<Dimension> dimensionList, List<Map<String, Object>> numberCombRowData, Map<String, DynamicObject> combObjs, Set<String> refedCombNumbers, Map<String, Map<String, Map<String, DynamicObject>>> refDataObjs, BillColGroup colConfig) {
        IModelCacheHelper modelCacheHelper = this.getModelCacheHelper();
        HashMap<String, String> dimMemberTypeMap = new HashMap<String, String>(16);
        HashMap dimIndexMap = new HashMap(16);
        HashMap<String, Dimension> dimensionMap = new HashMap<String, Dimension>(dimensionList.size());
        AnalyseReportUtil analyseReportUtil = AnalyseReportUtil.getInstance();
        ArrayList<String> dimNums = new ArrayList<String>(dimensionList.size());
        HashMap<String, MemberView> allNoneMember = new HashMap<String, MemberView>(dimensionList.size());
        Map defaultViews = modelCacheHelper.getViewsByBusModel(this.getBizModelId());
        Map dataSettDimMap = DatasetServiceHelper.getDataSettDimMap((Long)this.getBizModelId());
        HashMap<Long, Set<String>> dataSettDimNumMap = new HashMap<Long, Set<String>>(dataSettDimMap.size());
        HashSet<Long> dataSetIds = new HashSet<Long>(dataSettDimMap.keySet());
        dimensionList.forEach(dim -> {
            dimensionMap.put(dim.getNumber(), (Dimension)dim);
            Long viewId = (Long)defaultViews.get(dim.getNumber());
            Member member = dim.getMember(viewId, dim.getNoneNumber());
            if (member != null) {
                allNoneMember.put(dim.getNumber(), new MemberView(member.getId(), viewId));
            }
            dimNums.add(dim.getNumber());
            dimIndexMap.put(dim.getId(), dimIndexMap.size());
        });
        DynamicObject bizModelObj = BusinessDataServiceHelper.loadSingleFromCache((Object)this.getBizModelId(), (String)"eb_businessmodel");
        Map viewNumIdsByBusinessModel = BusinessModelServiceHelper.getViewGroupViewNumIdsByBusinessModel((DynamicObject)bizModelObj);
        dataSettDimMap.forEach((datasetId, dimIdSet) -> {
            HashSet dimNumbers = new HashSet(dimIdSet.size());
            dimIdSet.forEach(dimId -> {
                Dimension dimension = modelCacheHelper.getDimension(dimId);
                if (dimension != null) {
                    dimNumbers.add(dimension.getNumber());
                }
            });
            dataSettDimNumMap.put((Long)datasetId, dimNumbers);
        });
        for (Map<String, Object> rowData : numberCombRowData) {
            LinkedList<String> errorList = new LinkedList<String>();
            String number = (String)rowData.get("number");
            String name = (String)rowData.get("name");
            DynamicObject cObj = combObjs.get(number);
            if (this.checkNumberAndName(name, number) || this.checkRepObj(cObj, number, name)) continue;
            LinkedList<MemberQuoteDao> quoteDaoList = new LinkedList<MemberQuoteDao>();
            this.validateMember(modelCacheHelper.getDimension(SysDimensionEnum.Account.getNumber()), (String)rowData.get("account"), (Map<String, Map<String, Long>>)viewNumIdsByBusinessModel, rowData, errorList, quoteDaoList, dataSetIds, (Member member) -> {
                rowData.put("account", member.getId());
                rowData.put("dataset", member.getDatasetId());
            });
            this.validateMember(modelCacheHelper.getDimension(SysDimensionEnum.Metric.getNumber()), (String)rowData.get("metric"), (Map<String, Map<String, Long>>)viewNumIdsByBusinessModel, rowData, errorList, quoteDaoList, dataSetIds, (Member member) -> {
                if (!MetricDataTypeEnum.isNumber((String)member.getDatatype()) && !ApplicableObjectEnum.Self.getIndex().equals(rowData.get("suitobject"))) {
                    errorList.add(ResManager.loadKDString((String)"\u76ee\u6807\u4f53\u7cfb\u76f8\u540c\u7f16\u7801\u7684\u5ea6\u91cf\u4e3a\u975e\u6570\u503c\u7c7b\u578b\uff0c\u9002\u7528\u5bf9\u8c61\u975e\u201c\u81ea\u8eab\u201d\u65f6\uff0c\u4e0d\u80fd\u4f7f\u7528\u975e\u6570\u503c\u5ea6\u91cf\u6210\u5458", (String)"CombinationImportHandler_17", (String)"epm-eb-business", (Object[])new Object[0]));
                } else {
                    rowData.put("metricdatatype", member.getDatatype());
                    if (MetricDataTypeEnum.CURRENCY.getIndex().equals(member.getDatatype()) && StringUtils.isEmpty((String)((String)rowData.get("unit")))) {
                        rowData.put("unit", String.valueOf(UnitEnum.TEN_THOUSAND.getUnit()));
                    }
                    rowData.put("metric", member.getId());
                }
            });
            List entryRows = (List)rowData.get("memberentry");
            RefDimColInfo dimColInfo = new RefDimColInfo();
            if (entryRows == null || entryRows.size() <= 0) continue;
            Object datasetId2 = rowData.get("dataset");
            dimMemberTypeMap.clear();
            for (Map row2 : entryRows) {
                String dimNumber = (String)row2.get("dimension");
                Dimension dimension = (Dimension)dimensionMap.get(dimNumber);
                if (dimension == null || datasetId2 instanceof Long && !((Set)dataSettDimNumMap.getOrDefault(datasetId2, new HashSet())).contains(dimNumber)) {
                    errorList.add(ResManager.loadResFormat((String)"\u76ee\u6807\u6570\u636e\u96c6\u4e0d\u5b58\u5728\u6307\u6807\u5f15\u7528\u7684%1\u7ef4\u5ea6", (String)"CombinationImportHandler_7", (String)"epm-eb-business", (Object[])new Object[]{dimNumber}));
                    continue;
                }
                row2.put("dimension", dimension.getId());
                String memberType = (String)row2.get("dimmembertype");
                dimMemberTypeMap.put(dimNumber, memberType);
                String baseDataKey = (String)row2.get("memberclasstype");
                String memberNumber = (String)row2.get("member");
                if (DimMemberTypeEnum.MEMBER.getIndex().equals(memberType)) {
                    this.validateMember(dimension, memberNumber, (Map<String, Map<String, Long>>)viewNumIdsByBusinessModel, (Map<String, Object>)row2, errorList, quoteDaoList, baseDataKey, refDataObjs);
                    continue;
                }
                if (DimMemberTypeEnum.FUNCTION.getIndex().equals(memberType)) {
                    dimColInfo.getRefFunctionDims().add(dimNumber);
                    continue;
                }
                if (!DimMemberTypeEnum.PARAM.getIndex().equals(memberType)) continue;
                dimColInfo.getRefParamDims().add(dimNumber);
                Long paramId = this.validateParam(baseDataKey, dimension, refDataObjs, memberNumber, errorList, quoteDaoList);
                if (paramId == null) continue;
                row2.put("member", paramId);
            }
            this.validateSameSetting(errorList, cObj, refedCombNumbers, number, rowData, dimMemberTypeMap);
            if (errorList.size() > 0) {
                this.addRowErrorLog(number, name, String.join((CharSequence)";", errorList));
                continue;
            }
            this.checkAndFillNewDim(cObj, rowData, entryRows, dimensionMap, dataSettDimNumMap, allNoneMember, dimMemberTypeMap.keySet());
            entryRows.sort(Comparator.comparing(row -> dimIndexMap.getOrDefault(row.get("dimension"), 0)));
            RefDimStrInfo refDimNumsStr = analyseReportUtil.getRefDimNumsStr(dimColInfo, dimNums);
            DynamicObject obj2Save = this.selObj2Save(colConfig, rowData, cObj, refDimNumsStr);
            obj2Save.set("formula_show", (Object)"");
            obj2Save.set("formula", (Object)"");
            Long objId = obj2Save.getLong("id");
            quoteDaoList.forEach(qObj -> {
                qObj.setModelId(this.getModelId());
                qObj.setResourceId(objId);
                this.addQuote((MemberQuoteDao)qObj);
            });
        }
    }

    private void checkAndFillNewDim(DynamicObject cObj, Map<String, Object> rowData, List<Map<String, Object>> entryRows, Map<String, Dimension> dimensionMap, Map<Long, Set<String>> dataSettDimNumMap, Map<String, MemberView> allNoneMember, Set<String> refDimNumSet) {
        block2: {
            Set<String> datasetRefDimNumbers;
            block3: {
                Long datasetId = (Long)rowData.get("dataset");
                datasetRefDimNumbers = dataSettDimNumMap.get(datasetId);
                if (datasetRefDimNumbers == null) break block2;
                if (cObj == null) break block3;
                DynamicObjectCollection memberEntry = cObj.getDynamicObjectCollection("memberentry");
                if (memberEntry == null) break block2;
                for (DynamicObject row : memberEntry) {
                    String dimNumber = row.getString("dimension.number");
                    if (!datasetRefDimNumbers.contains(dimNumber) || refDimNumSet.contains(dimNumber)) continue;
                    HashMap<String, Object> memberRow = new HashMap<String, Object>(4);
                    memberRow.put("dimmembertype", row.getString("dimmembertype"));
                    memberRow.put("member", row.getLong("member.id"));
                    memberRow.put("dimview", row.getLong("dimview.id"));
                    memberRow.put("memberclasstype", row.getString("memberclasstype"));
                    memberRow.put("dimension", row.getLong("dimension.id"));
                    entryRows.add(memberRow);
                }
                break block2;
            }
            for (String dimNum : datasetRefDimNumbers) {
                Dimension dimension;
                MemberView memberView;
                if (refDimNumSet.contains(dimNum) || (memberView = allNoneMember.get(dimNum)) == null || (dimension = dimensionMap.get(dimNum)) == null) continue;
                HashMap<String, Object> memberRow = new HashMap<String, Object>(4);
                memberRow.put("dimmembertype", "1");
                memberRow.put("member", memberView.getMemberId());
                memberRow.put("dimview", memberView.getViewId());
                memberRow.put("memberclasstype", dimension.getMemberModel());
                memberRow.put("dimension", dimension.getId());
                entryRows.add(memberRow);
            }
        }
    }

    private void validateSameSetting(List<String> errorList, DynamicObject cObj, Set<String> refedCombNumbers, String number, Map<String, Object> rowData, Map<String, String> dimMemberTypeMap) {
        if (errorList.isEmpty() && cObj != null && this.isReplace() && refedCombNumbers.contains(number)) {
            if (!cObj.getString("dimgrouptype").equals(rowData.get("dimgrouptype"))) {
                errorList.add(ResManager.loadKDString((String)"\u6307\u6807\u5df2\u88ab\u5f15\u7528\u4e0d\u53ef\u66f4\u6539\u7c7b\u578b", (String)"CombinationImportHandler_5", (String)"epm-eb-business", (Object[])new Object[0]));
            } else {
                DynamicObjectCollection memberEntry = cObj.getDynamicObjectCollection("memberentry");
                boolean hasError = false;
                HashSet<String> nowDimSet = new HashSet<String>(memberEntry.size());
                for (DynamicObject row : memberEntry) {
                    String _dimNumber = row.getString("dimension.number");
                    String _dimMemberType = row.getString("dimmembertype");
                    String dimMemberType = dimMemberTypeMap.get(_dimNumber);
                    nowDimSet.add(_dimNumber);
                    if ((dimMemberType != null || "1".equals(_dimMemberType)) && (dimMemberType == null || dimMemberType.equals(_dimMemberType))) continue;
                    hasError = true;
                    break;
                }
                if (!hasError) {
                    for (Map.Entry<String, String> entry : dimMemberTypeMap.entrySet()) {
                        if (nowDimSet.contains(entry.getKey()) || "1".equals(entry.getValue())) continue;
                        hasError = true;
                        break;
                    }
                }
                if (hasError || !cObj.getString("metricdatatype").equals(rowData.get("metricdatatype"))) {
                    errorList.add(ResManager.loadKDString((String)"\u76ee\u6807\u4e1a\u52a1\u6a21\u578b\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u7801\u7684\u6307\u6807\u88ab\u5f15\u7528\u4e14\u4e0e\u5f53\u524d\u914d\u7f6e\u4e0d\u4e00\u81f4", (String)"CombinationImportHandler_9", (String)"epm-eb-business", (Object[])new Object[0]));
                }
            }
        }
    }

    private Long validateParam(String baseDataKey, Dimension dimension, Map<String, Map<String, Map<String, DynamicObject>>> refDataObjs, String memberNumber, List<String> errorList, List<MemberQuoteDao> quoteDaoList) {
        Long memberId = null;
        String dimNumber = dimension.getNumber();
        String dimName = dimension.getName();
        if (StringUtils.isNotEmpty((String)memberNumber) && "eb_dimensionparameter".equals(baseDataKey) && SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber)) {
            DynamicObject refDataObj = (DynamicObject)((Map)((Map)refDataObjs.getOrDefault(baseDataKey, new HashMap(16))).getOrDefault(dimNumber, new HashMap(16))).get(memberNumber);
            if (refDataObj == null || !dimNumber.equals(refDataObj.getString("dimension.number"))) {
                errorList.add(ResManager.loadResFormat((String)"\u76ee\u6807\u4e1a\u52a1\u6a21\u578b\u4e0d\u5b58\u5728\u6307\u6807\u5f15\u7528\u7684%1\u7ef4\u5ea6\u53c2\u6570", (String)"CombinationImportHandler_10", (String)"epm-eb-business", (Object[])new Object[]{memberNumber + dimName}));
            } else {
                memberId = refDataObj.getLong("id");
                quoteDaoList.add(new MemberQuoteDao(Long.valueOf(0L), Long.valueOf(0L), Long.valueOf(0L), memberId, MemberTypeEnum.DIMENSIONPARAM, MemberQuoteResourceEnum.DimGroup, Long.valueOf(0L)));
            }
        }
        return memberId;
    }

    private void validateMember(Dimension dimension, String memberNumber, Map<String, Map<String, Long>> viewNumIdsByBusinessModel, Map<String, Object> row, List<String> errorList, List<MemberQuoteDao> quoteList, String baseDataKey, Map<String, Map<String, Map<String, DynamicObject>>> refDataObjs) {
        String dimName = dimension.getName();
        String dimNumber = dimension.getNumber();
        if ("eb_periodvariable".equals(baseDataKey)) {
            DynamicObject refDataObj = (DynamicObject)((Map)((Map)refDataObjs.getOrDefault(baseDataKey, new HashMap(16))).getOrDefault(dimension.getNumber(), new HashMap(16))).get(memberNumber);
            if (refDataObj == null || !dimNumber.equals(refDataObj.getString("dimension.number"))) {
                errorList.add(ResManager.loadResFormat((String)"\u76ee\u6807\u4e1a\u52a1\u6a21\u578b\u4e0d\u5b58\u5728\u6307\u6807\u5f15\u7528\u7684%1\u6210\u5458\u53d8\u91cf", (String)"CombinationImportHandler_11", (String)"epm-eb-business", (Object[])new Object[]{memberNumber + dimName}));
            } else {
                Long memberId = refDataObj.getLong("id");
                quoteList.add(new MemberQuoteDao(Long.valueOf(0L), Long.valueOf(0L), dimension.getId(), memberId, MemberTypeEnum.VARIABLE, MemberQuoteResourceEnum.DimGroup, Long.valueOf(0L)));
                row.put("member", memberId);
            }
        } else {
            this.validateMember(dimension, memberNumber, viewNumIdsByBusinessModel, row, errorList, quoteList, null, (Member member) -> row.put("member", member.getId()));
        }
    }

    private void validateMember(Dimension dimension, String memberNumber, Map<String, Map<String, Long>> viewNumIdsByBusinessModel, Map<String, Object> row, List<String> errorList, List<MemberQuoteDao> quoteList, Set<Long> dataSetIds, Consumer<Member> memberConsumer) {
        Map<String, Long> viewNumIdMapOnBizModel = viewNumIdsByBusinessModel.get(dimension.getNumber());
        Member member = null;
        String dimName = dimension.getName();
        String dimNumber = dimension.getNumber();
        if (viewNumIdMapOnBizModel != null) {
            String view = (String)row.get("dimview");
            Long viewId = viewNumIdMapOnBizModel.get(view);
            if (viewId == null && view != null) {
                errorList.add(ResManager.loadResFormat((String)"\u76ee\u6807\u4e1a\u52a1\u6a21\u578b\u4e0d\u5b58\u5728\u6307\u6807\u5f15\u7528\u7684%1\u7ef4\u5ea6\u89c6\u56fe", (String)"CombinationImportHandler_12", (String)"epm-eb-business", (Object[])new Object[]{view + dimName}));
            } else {
                member = dimension.getMember(viewId, memberNumber);
                if (view != null) {
                    row.put("dimview", viewId);
                }
                if (member == null) {
                    errorList.add(ResManager.loadResFormat((String)"\u76ee\u6807\u4e1a\u52a1\u6a21\u578b%1\u7ef4\u5ea6%2\u89c6\u56fe\u4e0d\u5b58\u5728\u6307\u6807\u5f15\u7528\u7684%3\u6210\u5458", (String)"CombinationImportHandler_16", (String)"epm-eb-business", (Object[])new Object[]{dimName, view, memberNumber}));
                } else if (IDUtils.isNotNull((Long)viewId)) {
                    quoteList.add(new MemberQuoteDao(Long.valueOf(0L), Long.valueOf(0L), dimension.getId(), viewId, MemberTypeEnum.VIEW, MemberQuoteResourceEnum.DimGroup, Long.valueOf(0L)));
                }
            }
        } else {
            member = dimension.getMember(null, memberNumber);
            if (member == null) {
                errorList.add(ResManager.loadResFormat((String)"\u76ee\u6807\u4e1a\u52a1\u6a21\u578b\u4e0d\u5b58\u5728\u6307\u6807\u5f15\u7528\u7684%1\u6210\u5458", (String)"CombinationImportHandler_13", (String)"epm-eb-business", (Object[])new Object[]{memberNumber + dimName}));
            }
        }
        if (member != null) {
            if (SysDimensionEnum.Account.getNumber().equals(dimNumber) && !dataSetIds.contains(member.getDatasetId())) {
                errorList.add(ResManager.loadResFormat((String)"\u6307\u6807\u5f15\u7528\u7684%1\u79d1\u76ee\u6210\u5458\u5173\u8054\u7684\u6570\u636e\u96c6\u4e0d\u914d", (String)"CombinationImportHandler_14", (String)"epm-eb-business", (Object[])new Object[]{memberNumber}));
            } else {
                memberConsumer.accept(member);
                if (errorList.isEmpty()) {
                    Long memberId = member.getId();
                    Long datasetId = member.getDatasetId();
                    if (datasetId == null) {
                        datasetId = 0L;
                    }
                    quoteList.add(new MemberQuoteDao(Long.valueOf(0L), datasetId, dimension.getId(), memberId, MemberTypeEnum.MEMBER, MemberQuoteResourceEnum.DimGroup, Long.valueOf(0L)));
                }
            }
        }
    }

    private boolean checkMapSame(Map<String, String> sourceMap, Map<String, String> targetMap, String ignoreKey) {
        boolean same = true;
        if (sourceMap.size() != targetMap.size()) {
            same = false;
        } else {
            for (Map.Entry<String, String> entry : sourceMap.entrySet()) {
                if (entry.getKey().equals(ignoreKey) || StringUtils.equals((String)entry.getValue(), (String)targetMap.get(entry.getKey()))) continue;
                same = false;
                break;
            }
        }
        return same;
    }

    private Set<String> readRefComb(Long modelId, Long bizModelId, Set<String> targetNumbers, Map<String, DynamicObject> combObjs) {
        HashSet<String> result = new HashSet<String>(16);
        HashMap targetIdNumberMap = new HashMap(targetNumbers.size());
        targetNumbers.forEach(num -> {
            DynamicObject object = (DynamicObject)combObjs.get(num);
            if (object != null) {
                targetIdNumberMap.put(object.getLong("id"), num);
            }
        });
        CheckQuote checkQuote = new CheckQuote(modelId, 0L, targetIdNumberMap.keySet(), MemberTypeEnum.DIMGROUP);
        Set<Long> ref = MemberQuote.get().checkQuote(checkQuote);
        ref.forEach(id -> result.add((String)targetIdNumberMap.get(id)));
        return result;
    }

    private void addChangeTypeViewInfo(Dimension changeTypeDim, Map<String, Long> dimViewIdMap, Map<Long, Map<String, Long>> allAnalyseView) {
        if (changeTypeDim == null) {
            return;
        }
        QFBuilder qb = new QFBuilder();
        qb.add("model", "=", (Object)this.getModelId());
        qb.add("dimension", "=", (Object)changeTypeDim.getId());
        DynamicObjectCollection viewObj = QueryServiceHelper.query((String)"eb_dimensionview", (String)"id,number,source", (QFilter[])qb.toArrays());
        if (viewObj != null) {
            HashMap<String, Long> refViewInfo = new HashMap<String, Long>(viewObj.size());
            for (DynamicObject obj : viewObj) {
                String number = obj.getString("number");
                Long id = obj.getLong("id");
                refViewInfo.put(number, id);
                if (!"1".equals(obj.getString("source"))) continue;
                allAnalyseView.put(id, refViewInfo);
                dimViewIdMap.put(changeTypeDim.getNumber(), id);
            }
        }
    }
}

