/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analyzeReport.impexp.handler;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.epm.eb.business.analyzeReport.impexp.handler.ARptVarImportHandler;
import kd.epm.eb.business.analyzeReport.service.AnalyseReportUtil;
import kd.epm.eb.business.billimpexp.BillColGroup;
import kd.epm.eb.business.quote.CheckQuote;
import kd.epm.eb.business.quote.QuoteCheck;
import kd.epm.eb.common.analysereport.constants.VariableTypeEnum;
import kd.epm.eb.common.analysereport.pojo.quote.RefDimColInfo;
import kd.epm.eb.common.analysereport.pojo.quote.RefDimStrInfo;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.common.utils.StringUtils;

public class ConditionImportHandler
extends ARptVarImportHandler {
    @Override
    protected void selectData(List<Map<String, Object>> allRowData) {
        String number;
        HashSet<String> combNumbers = new HashSet<String>(16);
        HashSet<String> conditionNumbers = new HashSet<String>(16);
        for (Map<String, Object> rowData : allRowData) {
            number = (String)rowData.get("number");
            conditionNumbers.add(number);
            List entryRowsData = (List)rowData.get("entryentity");
            for (Map entryData : entryRowsData) {
                combNumbers.add((String)entryData.get("source"));
                combNumbers.add((String)entryData.get("compare"));
            }
        }
        combNumbers.remove(null);
        combNumbers.remove("");
        Map<String, DynamicObject> refCombObjs = this.getRefValObjs(VariableTypeEnum.Combination, combNumbers);
        Map<String, DynamicObject> refConditionObjs = this.getRefValObjs(VariableTypeEnum.Condition, conditionNumbers);
        HashSet<Long> conditionIds = new HashSet<Long>(16);
        refConditionObjs.values().forEach(obj -> conditionIds.add(obj.getLong("id")));
        CheckQuote checkQuote = new CheckQuote(this.getModelId(), 0L, 0L, conditionIds, MemberTypeEnum.JUDGECONDITION);
        Set<Long> refConditions = QuoteCheck.get().checkQuote(checkQuote);
        AnalyseReportUtil analyseReportUtil = AnalyseReportUtil.getInstance();
        List<String> dimNums = this.getModelCacheHelper().getDimensionListByBusModel(this.getBizModelId()).stream().map(BaseCache::getNumber).collect(Collectors.toList());
        BillColGroup colConfig = this.getColConfig();
        block2: for (Map<String, Object> rowData : allRowData) {
            number = (String)rowData.get("number");
            String name = (String)rowData.get("name");
            DynamicObject conditionObj = refConditionObjs.get(number);
            if (this.checkNumberAndName(name, number) || this.checkRepObj(conditionObj, number, name)) continue;
            List entryRowsData = (List)rowData.get("entryentity");
            HashSet<Long> refDimGroupIds = new HashSet<Long>(16);
            RefDimColInfo refDimColInfo = new RefDimColInfo();
            for (Map entryData : entryRowsData) {
                String sourceCombNumber = (String)entryData.get("source");
                String compareCombNumber = (String)entryData.get("compare");
                DynamicObject refCombObj = refCombObjs.get(sourceCombNumber);
                if (refCombObj == null) {
                    this.addRowErrorLog(number, name, ResManager.loadResFormat((String)"\u5f15\u7528\u7684\u6307\u6807%1\u4e0d\u5b58\u5728", (String)"ConditionImportHandler_2", (String)"epm-eb-business", (Object[])new Object[]{sourceCombNumber}));
                    continue block2;
                }
                if (!MetricDataTypeEnum.isNumber((String)refCombObj.getString("metricdatatype"))) {
                    this.addRowErrorLog(number, name, ResManager.loadResFormat((String)"\u5f15\u7528\u7684\u6307\u6807%1\u4e0d\u662f\u6570\u503c\u7c7b\u578b", (String)"ConditionImportHandler_3", (String)"epm-eb-business", (Object[])new Object[]{sourceCombNumber}));
                    continue block2;
                }
                entryData.put("source", refCombObj.getLong("id"));
                analyseReportUtil.selRefDimNumOnObj(refCombObj, refDimColInfo);
                refDimGroupIds.add(refCombObj.getLong("id"));
                if (!StringUtils.isNotEmpty((String)compareCombNumber)) continue;
                refCombObj = refCombObjs.get(compareCombNumber);
                if (refCombObj == null) {
                    this.addRowErrorLog(number, name, ResManager.loadResFormat((String)"\u5f15\u7528\u7684\u6307\u6807%1\u4e0d\u5b58\u5728", (String)"ConditionImportHandler_2", (String)"epm-eb-business", (Object[])new Object[]{compareCombNumber}));
                    continue block2;
                }
                if (!MetricDataTypeEnum.isNumber((String)refCombObj.getString("metricdatatype"))) {
                    this.addRowErrorLog(number, name, ResManager.loadResFormat((String)"\u5f15\u7528\u7684\u6307\u6807%1\u4e0d\u662f\u6570\u503c\u7c7b\u578b", (String)"ConditionImportHandler_3", (String)"epm-eb-business", (Object[])new Object[]{compareCombNumber}));
                    continue block2;
                }
                entryData.put("compare", refCombObj.getLong("id"));
                analyseReportUtil.selRefDimNumOnObj(refCombObj, refDimColInfo);
                refDimGroupIds.add(refCombObj.getLong("id"));
            }
            RefDimStrInfo refDimNumsStr = analyseReportUtil.getRefDimNumsStr(refDimColInfo, dimNums);
            if (this.isReplace() && conditionObj != null && refConditions.contains(conditionObj.getLong("id"))) {
                if (!refDimNumsStr.getRefFunctionDims().equals(conditionObj.getString("reffunctiondimnums"))) {
                    this.addRowErrorLog(number, name, ResManager.loadResFormat((String)"\u76ee\u6807\u4e1a\u52a1\u6a21\u578b\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u7801\u7684\u5224\u65ad\u6761\u4ef6\u5df2\u88ab\u5f15\u7528\u4e14\u51fd\u6570\u5165\u53c2\u7ef4\u5ea6\u53d1\u751f\u4e86\u53d8\u5316:%1->%2", (String)"ConditionImportHandler_4", (String)"epm-eb-business", (Object[])new Object[]{conditionObj.getString("reffunctiondimnums"), refDimNumsStr.getRefFunctionDims()}));
                    continue;
                }
                if (!refDimNumsStr.getRefParamDims().equals(conditionObj.getString("refparamdimnums"))) {
                    this.addRowErrorLog(number, name, ResManager.loadResFormat((String)"\u76ee\u6807\u4e1a\u52a1\u6a21\u578b\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u7801\u7684\u5224\u65ad\u6761\u4ef6\u5df2\u88ab\u5f15\u7528\u4e14\u53c2\u6570\u5165\u53c2\u7ef4\u5ea6\u53d1\u751f\u4e86\u53d8\u5316:%1->%2", (String)"ConditionImportHandler_5", (String)"epm-eb-business", (Object[])new Object[]{conditionObj.getString("refparamdimnums"), refDimNumsStr.getRefParamDims()}));
                    continue;
                }
            }
            conditionObj = this.selObj2Save(colConfig, rowData, conditionObj, refDimNumsStr);
            this.addQuote(new MemberQuoteDao(this.getModelId(), Long.valueOf(0L), Long.valueOf(0L), refDimGroupIds, MemberTypeEnum.DIMGROUP, MemberQuoteResourceEnum.JudgeCondition, Long.valueOf(conditionObj.getLong("id"))));
        }
        System.out.println("");
    }
}

