/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analyzeReport.impexp.handler;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.analyzeReport.impexp.handler.ARptVarImportHandler;
import kd.epm.eb.business.analyzeReport.service.AnalyseReportUtil;
import kd.epm.eb.business.analyzeReport.service.AnalyseRptFuncUtil;
import kd.epm.eb.business.billimpexp.BillColGroup;
import kd.epm.eb.common.analysereport.constants.FieldTypeEnum;
import kd.epm.eb.common.analysereport.constants.VariableTypeEnum;
import kd.epm.eb.common.analysereport.pojo.VarImportContext;
import kd.epm.eb.common.analysereport.pojo.condition.Condition;
import kd.epm.eb.common.analysereport.pojo.condition.JudgeCondition;
import kd.epm.eb.common.analysereport.pojo.functions.OrderFunction;
import kd.epm.eb.common.analysereport.pojo.functions.steps.FieldLayout;
import kd.epm.eb.common.analysereport.pojo.functions.steps.MemberFilter;
import kd.epm.eb.common.analysereport.pojo.functions.steps.MemberInfo;
import kd.epm.eb.common.analysereport.pojo.functions.steps.MemberRange;
import kd.epm.eb.common.analysereport.pojo.functions.steps.ShowLayout;
import kd.epm.eb.common.analysereport.pojo.functions.steps.SortWay;
import kd.epm.eb.common.analysereport.pojo.quote.RefDimColInfo;
import kd.epm.eb.common.analysereport.pojo.quote.RefDimStrInfo;
import kd.epm.eb.common.analysereport.pojo.quote.VarQuoteInfo;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.CommonUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;

public class FunctionImportHandler
extends ARptVarImportHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void selectData(List<Map<String, Object>> allRowData) {
        CommonUtils.putVarImportContext((VarImportContext)this.getImportContext());
        try {
            HashMap<String, Map<String, DynamicObject>> allRefObj = new HashMap<String, Map<String, DynamicObject>>(16);
            HashMap<String, OrderFunction> functionData = new HashMap<String, OrderFunction>(16);
            this.selRefInfo(allRowData, allRefObj, functionData);
            this.validateDataAndBuildObj(allRowData, allRefObj, functionData);
            this.selOtherInfo(allRefObj, functionData);
        }
        finally {
            CommonUtils.removeVarImportContext();
        }
    }

    private void selRefInfo(List<Map<String, Object>> allRowData, Map<String, Map<String, DynamicObject>> allRefObj, Map<String, OrderFunction> functionData) {
        HashMap<String, Set<String>> refDataNumbers = new HashMap<String, Set<String>>(16);
        VarImportContext importContext = this.getImportContext();
        for (Map<String, Object> rowData : allRowData) {
            String number = (String)rowData.get("number");
            String stepStr = (String)rowData.get("allstepdata_tag");
            OrderFunction function = new OrderFunction();
            function.setStepData(stepStr);
            ShowLayout showLayout = function.getShowLayout();
            showLayout.getFieldLayoutList().forEach(fieldLayout -> {
                String fieldType = fieldLayout.getFieldType();
                String fieldValNumber = fieldLayout.getShowField();
                if (FieldTypeEnum.DIMGROUP.getValue().equals(fieldType)) {
                    fieldValNumber = String.valueOf(importContext.putFieldNumber(VariableTypeEnum.Combination.getMetadata(), fieldValNumber));
                } else if (FieldTypeEnum.CONDITION.getValue().equals(fieldType)) {
                    fieldValNumber = String.valueOf(importContext.putFieldNumber(VariableTypeEnum.Condition.getMetadata(), fieldValNumber));
                }
                fieldLayout.setShowField(fieldValNumber);
            });
            functionData.put(number, function);
            refDataNumbers.computeIfAbsent(VariableTypeEnum.Function.getMetadata(), key -> new HashSet(16)).add(number);
        }
        Map indexNumberMap = importContext.getIndexNumberMap();
        indexNumberMap.forEach((entryKey, indexNumbMap) -> refDataNumbers.computeIfAbsent((String)entryKey, key -> new HashSet(16)).addAll(indexNumbMap.values()));
        allRefObj.putAll(this.getAllRefObject(refDataNumbers));
    }

    private void validateDataAndBuildObj(List<Map<String, Object>> allRowData, Map<String, Map<String, DynamicObject>> allRefObj, Map<String, OrderFunction> functionData) {
        Long bizModelId = this.getBizModelId();
        List dimensionList = this.getModelCacheHelper().getDimensionListByBusModel(bizModelId);
        DynamicObject bizModelObj = BusinessDataServiceHelper.loadSingleFromCache((Object)this.getBizModelId(), (String)"eb_businessmodel");
        Map viewNumIdsByBusinessModel = BusinessModelServiceHelper.getViewGroupViewNumIdsByBusinessModel((DynamicObject)bizModelObj);
        Map<String, Dimension> dimensionMap = dimensionList.stream().collect(Collectors.toMap(BaseCache::getNumber, d2 -> d2));
        HashSet<String> refDimNums = new HashSet<String>(16);
        Set<String> dimNumsOnFuncDimGroup = AnalyseRptFuncUtil.getDimNumsOnFuncDimGroup(bizModelId);
        BillColGroup colConfig = this.getColConfig();
        Map refFunctionObj = allRefObj.getOrDefault(VariableTypeEnum.Function.getMetadata(), new HashMap(16));
        Map refCombObjs = allRefObj.getOrDefault(VariableTypeEnum.Combination.getMetadata(), new HashMap(16));
        Map refConditionObjs = allRefObj.getOrDefault(VariableTypeEnum.Condition.getMetadata(), new HashMap(16));
        for (Map<String, Object> rowData : allRowData) {
            refDimNums.clear();
            String number = this.getNumber(rowData);
            String name = this.getName(rowData);
            DynamicObject functionObj = (DynamicObject)refFunctionObj.get(number);
            if (this.checkNumberAndName(name, number) || this.checkRepObj(functionObj, number, name)) continue;
            OrderFunction function = functionData.get(number);
            String errorInfo = this.checkMemberFilter(function.getMemberFilter(), dimensionMap, viewNumIdsByBusinessModel, dimNumsOnFuncDimGroup, refDimNums, refCombObjs);
            if (errorInfo != null) {
                this.addRowErrorLog(number, name, errorInfo);
                continue;
            }
            errorInfo = this.checkSortWay(function.getSortWay(), refDimNums, refCombObjs);
            if (errorInfo != null) {
                this.addRowErrorLog(number, name, errorInfo);
                continue;
            }
            errorInfo = this.checkShowLayout(function.getShowLayout(), refConditionObjs, refCombObjs, refDimNums);
            if (errorInfo != null) {
                this.addRowErrorLog(number, name, errorInfo);
                continue;
            }
            this.selObj2Save(colConfig, rowData, functionObj, null);
        }
    }

    private void selOtherInfo(Map<String, Map<String, DynamicObject>> allRefObj, Map<String, OrderFunction> functionData) {
        LinkedList<DynamicObject> allFunctionObjs = new LinkedList<DynamicObject>();
        allFunctionObjs.addAll(this.getUpdateObjs());
        allFunctionObjs.addAll(this.getNewObjs());
        if (allFunctionObjs.size() > 0) {
            Map refCombObjs = allRefObj.getOrDefault(VariableTypeEnum.Combination.getMetadata(), new HashMap(16));
            Map refConditionObjs = allRefObj.getOrDefault(VariableTypeEnum.Condition.getMetadata(), new HashMap(16));
            List<String> dimNums = this.getModelCacheHelper().getDimensionListByBusModel(this.getBizModelId()).stream().map(BaseCache::getNumber).collect(Collectors.toList());
            AnalyseReportUtil analyseReportUtil = AnalyseReportUtil.getInstance();
            LinkedList<MemberQuoteDao> memberQuoteList = new LinkedList<MemberQuoteDao>();
            Map<Long, DynamicObject> refCombObjs4Id = refCombObjs.values().stream().collect(Collectors.toMap(o1 -> o1.getLong("id"), o2 -> o2));
            Map<Long, DynamicObject> refConditionObjs4Id = refConditionObjs.values().stream().collect(Collectors.toMap(o1 -> o1.getLong("id"), o2 -> o2));
            for (DynamicObject obj : allFunctionObjs) {
                Long id = obj.getLong("id");
                String number = obj.getString("number");
                OrderFunction function = functionData.get(number);
                RefDimColInfo refDimColInfo = new RefDimColInfo();
                VarQuoteInfo varQuoteInfo = AnalyseRptFuncUtil.selQuoteInfo(this.getModelId(), function.getStepDataContainer(), memberQuoteList, id);
                varQuoteInfo.getRefDimGroupIds().forEach(dId -> analyseReportUtil.selRefDimNumOnObj((DynamicObject)refCombObjs4Id.get(dId), refDimColInfo));
                varQuoteInfo.getRefConditionIds().forEach(dId -> analyseReportUtil.selRefDimNumOnObj((DynamicObject)refConditionObjs4Id.get(dId), refDimColInfo));
                RefDimStrInfo refDimNumsStr = analyseReportUtil.getRefDimNumsStr(refDimColInfo, dimNums);
                obj.set("refparamdimnums", (Object)refDimNumsStr.getRefParamDims());
                obj.set("reffunctiondimnums", (Object)refDimNumsStr.getRefFunctionDims());
                obj.set("showfields", (Object)AnalyseRptFuncUtil.buildShowField(function.getShowLayout(), this.getModelCacheHelper()));
                obj.set("allstepdata_tag", (Object)function.getStepDataStr());
            }
            this.getMemberQuoteList().addAll(memberQuoteList);
        }
    }

    private String checkMemberFilter(MemberFilter memberFilter, Map<String, Dimension> dimensionMap, Map<String, Map<String, Long>> viewNumIdsByBusinessModel, Set<String> dimNumsOnFuncDimGroup, Set<String> refDimNums, Map<String, DynamicObject> refCombObjs) {
        if (memberFilter == null) {
            return null;
        }
        String errorMes = null;
        List memberRanges = memberFilter.getMemberRanges();
        VarImportContext importContext = this.getImportContext();
        block0: for (MemberRange memberRange : memberRanges) {
            String dimNumber = memberRange.getDimNum();
            Dimension dimension = dimensionMap.get(dimNumber);
            if (dimension == null) {
                errorMes = ResManager.loadResFormat((String)"\u76ee\u6807\u4e1a\u52a1\u6a21\u578b\u4e0d\u5b58\u5728\u51fd\u6570\u5f15\u7528\u7684%1\u7ef4\u5ea6", (String)"FunctionImportHandler_2", (String)"epm-eb-business", (Object[])new Object[]{dimNumber});
                break;
            }
            String dimName = dimension.getName();
            if (!dimNumsOnFuncDimGroup.contains(dimNumber)) {
                errorMes = ResManager.loadResFormat((String)"\u76ee\u6807\u4e1a\u52a1\u6a21\u578b\u4e0b\u4e0d\u5b58\u5728\u914d\u7f6e\u4e86%1\u7ef4\u5ea6\u51fd\u6570\u5165\u53c2\u7684\u6307\u6807", (String)"FunctionImportHandler_3", (String)"epm-eb-business", (Object[])new Object[]{dimName});
                break;
            }
            refDimNums.add(dimNumber);
            Map<String, Long> viewIdNumMap = viewNumIdsByBusinessModel.get(dimNumber);
            if (viewIdNumMap == null) {
                memberRange.setViewId(null);
            } else {
                Long viewId = memberRange.getViewId();
                if (viewId != null) {
                    String viewNumber = (String)importContext.getIndexNumberMap("eb_dimensionview").get(viewId);
                    viewId = viewIdNumMap.get(viewNumber);
                    if (viewId == null) {
                        errorMes = ResManager.loadResFormat((String)"\u76ee\u6807\u4e1a\u52a1\u6a21\u578b\u4e0b\u4e0d\u5b58\u5728%1\u89c6\u56fe", (String)"FunctionImportHandler_4", (String)"epm-eb-business", (Object[])new Object[]{viewNumber + dimName});
                        break;
                    }
                    memberRange.setViewId(viewId);
                }
            }
            for (MemberInfo memberInfo : memberRange.getMemberInfoList()) {
                if (dimension.getMember(memberRange.getViewId(), memberInfo.getMembNum()) != null) continue;
                errorMes = ResManager.loadResFormat((String)"\u76ee\u6807\u4e1a\u52a1\u6a21\u578b\u4e0b\u4e0d\u5b58\u5728\u6210\u5458\u8fc7\u6ee4\u5f15\u7528\u7684%1\u6210\u5458", (String)"FunctionImportHandler_5", (String)"epm-eb-business", (Object[])new Object[]{memberInfo.getMembNum() + dimName});
                continue block0;
            }
        }
        if (errorMes == null) {
            JudgeCondition filterCondition = memberFilter.getFilterCondition();
            errorMes = this.checkCondition(ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6", (String)"FunctionImportHandler_6", (String)"epm-eb-business", (Object[])new Object[0]), filterCondition, true, refCombObjs, refDimNums);
        }
        return errorMes;
    }

    private String checkSortWay(SortWay sortWay, Set<String> refDimNums, Map<String, DynamicObject> refCombObjs) {
        String errorInfo = null;
        if (sortWay != null) {
            String preText = ResManager.loadKDString((String)"\u6392\u5e8f\u65b9\u5f0f", (String)"FunctionImportHandler_7", (String)"epm-eb-business", (Object[])new Object[0]);
            errorInfo = this.checkRefObj(preText, VariableTypeEnum.Combination, refCombObjs, 2, true, refDimNums, sortWay.getSortAccord(), arg_0 -> ((SortWay)sortWay).setSortAccord(arg_0));
            if (errorInfo == null) {
                JudgeCondition sortCondition = sortWay.getSortCondition();
                errorInfo = this.checkCondition(preText, sortCondition, false, refCombObjs, refDimNums);
            }
        }
        return errorInfo;
    }

    private String checkShowLayout(ShowLayout showLayout, Map<String, DynamicObject> refConditionObjs, Map<String, DynamicObject> refCombObjs, Set<String> refDimNums) {
        String errorStr = null;
        if (showLayout != null) {
            int showAmount = showLayout.getShowAmount();
            if (showAmount > 100) {
                showLayout.setShowAmount(100);
            }
            if (showAmount < 1) {
                showLayout.setShowAmount(1);
            }
            for (FieldLayout layout : showLayout.getFieldLayoutList()) {
                Long index;
                String fieldType = layout.getFieldType();
                String fieldValNumber = layout.getShowField();
                if (FieldTypeEnum.DIMGROUP.getValue().equals(fieldType)) {
                    index = Long.valueOf(fieldValNumber);
                    errorStr = this.checkRefObj(ResManager.loadKDString((String)"\u663e\u793a\u5185\u5bb9", (String)"FunctionImportHandler_8", (String)"epm-eb-business", (Object[])new Object[0]), VariableTypeEnum.Combination, refCombObjs, 2, false, refDimNums, index, refObjId -> layout.setShowField(refObjId.toString()));
                    if (errorStr == null) continue;
                    break;
                }
                if (!FieldTypeEnum.CONDITION.getValue().equals(fieldType)) continue;
                index = Long.valueOf(fieldValNumber);
                errorStr = this.checkRefObj(ResManager.loadKDString((String)"\u663e\u793a\u5185\u5bb9", (String)"FunctionImportHandler_8", (String)"epm-eb-business", (Object[])new Object[0]), VariableTypeEnum.Condition, refConditionObjs, 2, false, refDimNums, index, refObjId -> layout.setShowField(refObjId.toString()));
                if (errorStr == null) continue;
                break;
            }
        }
        return errorStr;
    }

    private String checkRefObj(String preText, VariableTypeEnum refValType, Map<String, DynamicObject> refObjs, int checkDimGroupType, boolean checkDataType, Set<String> refDimNums, Long indexNumber, Consumer<Long> refObjConsumer) {
        if (IDUtils.isNotNull((Long)indexNumber)) {
            String fieldValNumber = (String)this.getImportContext().getIndexNumberMap(refValType.getMetadata()).get(indexNumber);
            DynamicObject refObj = refObjs.get(fieldValNumber);
            if (refObj == null) {
                return ResManager.loadResFormat((String)"%1\u5f15\u7528\u7684%2\u4e0d\u5b58\u5728", (String)"FunctionImportHandler_9", (String)"epm-eb-business", (Object[])new Object[]{preText, refValType.getName() + fieldValNumber});
            }
            if (checkDataType && refValType == VariableTypeEnum.Combination && !MetricDataTypeEnum.isNumber((String)refObj.getString("metricdatatype"))) {
                return ResManager.loadResFormat((String)"%1\u5f15\u7528\u7684%2\u4e0d\u662f\u6570\u503c\u7c7b\u578b", (String)"FunctionImportHandler_11", (String)"epm-eb-business", (Object[])new Object[]{preText, refValType.getName() + fieldValNumber});
            }
            String errorDim = this.checkRefFuncParam(checkDimGroupType, refObj, refDimNums);
            if (errorDim != null) {
                return ResManager.loadResFormat((String)"%1\u5f15\u7528\u7684%2\u5173\u8054\u7684\u51fd\u6570\u5165\u53c2\u7ef4\u5ea6\u4e0e\u5f53\u524d\u51fd\u6570\u4e0d\u5339\u914d\uff1a%3", (String)"FunctionImportHandler_10", (String)"epm-eb-business", (Object[])new Object[]{preText, refValType.getName() + fieldValNumber, errorDim});
            }
            if (refObjConsumer != null) {
                refObjConsumer.accept(refObj.getLong("id"));
            }
        }
        return null;
    }

    private String checkCondition(String preText, JudgeCondition filterCondition, boolean isMemberFilter, Map<String, DynamicObject> refCombObjs, Set<String> refDimNums) {
        if (filterCondition != null) {
            for (Condition condition : filterCondition.getConditionList()) {
                String errorMes = this.checkRefObj(preText, VariableTypeEnum.Combination, refCombObjs, isMemberFilter ? 2 : 1, true, refDimNums, condition.getLeftVal(), arg_0 -> ((Condition)condition).setLeftVal(arg_0));
                if (errorMes != null) {
                    return errorMes;
                }
                errorMes = this.checkRefObj(preText, VariableTypeEnum.Combination, refCombObjs, isMemberFilter ? 3 : 1, true, refDimNums, condition.getRightVal(), arg_0 -> ((Condition)condition).setRightVal(arg_0));
                if (errorMes == null) continue;
                return errorMes;
            }
        }
        return null;
    }

    private String checkRefFuncParam(int checkType, DynamicObject obj, Set<String> refDimNums) {
        String refFunctionDimNums = obj.getString("reffunctiondimnums");
        if (checkType == 1 && StringUtils.isNotEmpty((String)refFunctionDimNums)) {
            return refFunctionDimNums + "->";
        }
        if (checkType == 2 || checkType == 3) {
            boolean notMatch = false;
            if (refFunctionDimNums != null) {
                String[] splitDimNums = refFunctionDimNums.split(",");
                if (splitDimNums.length != refDimNums.size()) {
                    notMatch = true;
                } else {
                    for (String dimNum : splitDimNums) {
                        if (refDimNums.contains(dimNum)) continue;
                        notMatch = true;
                        break;
                    }
                }
            }
            if (notMatch && (checkType == 2 || StringUtils.isNotEmpty((String)refFunctionDimNums))) {
                return refFunctionDimNums + "->" + String.join((CharSequence)",", refDimNums);
            }
        }
        return null;
    }
}

