/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analyzeReport.impexp.handler;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.epm.eb.business.analyzeReport.impexp.handler.ARptVarImportHandler;
import kd.epm.eb.business.billimpexp.BillColGroup;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.enums.SysDimensionEnum;

public class ParamImportHandler
extends ARptVarImportHandler {
    @Override
    protected void selectData(List<Map<String, Object>> allRowData) {
        BillColGroup colConfig = this.getColConfig();
        Map<String, DynamicObject> existParamInfo = this.getRefValObjs(this.getVariableTypeEnum(), null);
        Set existDims = existParamInfo.values().stream().map(obj -> obj.getString("dimension.number")).collect(Collectors.toSet());
        existDims.remove(SysDimensionEnum.BudgetPeriod.getNumber());
        Map<String, Dimension> dimensionMap = this.getModelCacheHelper().getDimensionListByBusModel(this.getBizModelId()).stream().collect(Collectors.toMap(BaseCache::getNumber, d2 -> d2));
        for (Map<String, Object> rowData : allRowData) {
            String number = (String)rowData.get("number");
            String name = (String)rowData.get("name");
            DynamicObject existObj = existParamInfo.get(number);
            if (this.checkNumberAndName(name, number) || this.checkRepObj(existObj, number, name)) continue;
            String dimNumber = (String)rowData.get("dimension");
            Dimension dimension = dimensionMap.get(dimNumber);
            if (dimension == null) {
                this.addRowErrorLog(number, name, ResManager.loadResFormat((String)"\u76ee\u6807\u4e1a\u52a1\u6a21\u578b\u4e0d\u5b58\u5728\u53c2\u6570\u6240\u5c5e\u7ef4\u5ea6%1", (String)"ParamImportHandler_1", (String)"epm-eb-business", (Object[])new Object[]{dimNumber}));
                continue;
            }
            rowData.put("dimension", dimension.getId());
            if (existObj != null && this.isReplace()) {
                String oldDimNumber = existObj.getString("dimension.number");
                if (oldDimNumber == null || !oldDimNumber.equals(dimNumber)) {
                    this.addRowErrorLog(number, name, ResManager.loadKDString((String)"\u76ee\u6807\u4e1a\u52a1\u6a21\u578b\u5df2\u5b58\u5728\u6b64\u4f53\u7cfb\u53c2\u6570", (String)"ParamImportHandler_2", (String)"epm-eb-business", (Object[])new Object[0]));
                    continue;
                }
                this.selObj2Save(colConfig, rowData, existObj, null);
                continue;
            }
            if (existObj != null) continue;
            if (!existDims.add(dimNumber) && !SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber)) {
                this.addRowErrorLog(number, name, ResManager.loadKDString((String)"\u76ee\u6807\u4e1a\u52a1\u6a21\u578b\u5df2\u5b58\u5728\u6b64\u4f53\u7cfb\u53c2\u6570", (String)"ParamImportHandler_2", (String)"epm-eb-business", (Object[])new Object[0]));
                continue;
            }
            this.selObj2Save(colConfig, rowData, null, null);
        }
    }
}

