/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analyzeReport.impexp.handler;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.epm.eb.business.analyzeReport.impexp.handler.ARptExportHandler;
import kd.epm.eb.business.analyzeReport.service.AnalyseReportUtil;
import kd.epm.eb.common.impexp.ZipFileData;
import kd.epm.eb.common.impexp.ZipFileType;

public class TempExportHandler
extends ARptExportHandler {
    private final Long modelId;
    private List<ZipFileData> allTempFileUrlInfo = new LinkedList<ZipFileData>();
    private Map<String, String> tempIdNumbMap = new HashMap<String, String>(16);

    public TempExportHandler(Long modelId) {
        this.modelId = modelId;
    }

    @Override
    public Set<String> getIgnoreFields() {
        Set<String> ignoreFields = super.getIgnoreFields();
        ignoreFields.add("shareusers");
        ignoreFields.remove("bizmodel");
        return ignoreFields;
    }

    @Override
    public void handleData(List<Map<String, Object>> allRowData) {
        super.handleData(allRowData);
        if (this.tempIdNumbMap.size() > 0) {
            Map<String, String> filesUrl = AnalyseReportUtil.getInstance().getFileUrl(this.tempIdNumbMap.keySet());
            filesUrl.forEach((tempIdStr, tempFileUrl) -> this.allTempFileUrlInfo.add(new ZipFileData(this.tempIdNumbMap.get(tempIdStr) + ".docx", ZipFileType.URL, tempFileUrl)));
            this.tempIdNumbMap.clear();
        }
    }

    @Override
    public void selOtherInfo(DynamicObject rowObj, Map<String, Object> rowDataMap) {
        this.tempIdNumbMap.put(rowObj.getString("id"), rowObj.getString("name") + "(" + rowObj.getString("number") + ")");
        rowDataMap.put("bizmodelName", rowObj.getString("bizmodel.name"));
    }

    @Override
    public Long getModelId() {
        return this.modelId;
    }

    public List<ZipFileData> getAllTempFileUrlInfo() {
        return this.allTempFileUrlInfo;
    }
}

