/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analyzeReport.impexp.handler;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.business.analyzeReport.impexp.handler.ARptExportHandler;
import kd.epm.eb.common.analysereport.constants.VariableTypeEnum;
import kd.epm.eb.common.utils.CommonServiceHelper;

public class TempVarRefExportHandler
extends ARptExportHandler {
    private final List<Map<String, Object>> allTempData;
    private Map<String, Set<Long>> refVarInfo = new HashMap<String, Set<Long>>(16);

    public TempVarRefExportHandler(List<Map<String, Object>> allTempData) {
        this.allTempData = allTempData;
    }

    @Override
    public void handleData(List<Map<String, Object>> allRowData) {
        super.handleData(allRowData);
        this.updateVarId2Number(allRowData);
        this.addVarInfo2TempData(allRowData);
    }

    private void addVarInfo2TempData(List<Map<String, Object>> allRowData) {
        String rptTempNumber;
        HashMap<String, List> refDataOnTemp = new HashMap<String, List>(16);
        for (Map<String, Object> rowData : allRowData) {
            rptTempNumber = (String)rowData.get("rpttemp");
            refDataOnTemp.computeIfAbsent(rptTempNumber, key -> new LinkedList()).add(rowData);
        }
        if (this.allTempData != null) {
            for (Map<String, Object> tempRowData : this.allTempData) {
                rptTempNumber = (String)tempRowData.get("number");
                List refData = (List)refDataOnTemp.get(rptTempNumber);
                if (refData == null) continue;
                tempRowData.put("refVarData", refData);
            }
        }
    }

    private void updateVarId2Number(List<Map<String, Object>> allRowData) {
        if (this.refVarInfo.size() > 0) {
            HashMap varIdNumberMap = new HashMap(this.refVarInfo.size());
            this.refVarInfo.forEach((varTypeNumber, varIds) -> {
                VariableTypeEnum variableTypeEnum = VariableTypeEnum.getVariableTypeByNumber((String)varTypeNumber);
                if (variableTypeEnum != null) {
                    Map idNumberMap = varIdNumberMap.computeIfAbsent(varTypeNumber, key -> new HashMap(16));
                    CommonServiceHelper.queryDataSet(null, (String)variableTypeEnum.getMetadata(), (String)"id,number", (QFilter)new QFilter("id", "in", varIds), row -> idNumberMap.put(row.getLong("id"), row.getString("number")));
                }
            });
            allRowData.forEach(rowData -> {
                String varNumber;
                String varTypeNumber = (String)rowData.get("vartype");
                Long varId = (Long)rowData.get("var");
                Map idNumberMap = (Map)varIdNumberMap.get(varTypeNumber);
                if (idNumberMap != null && (varNumber = (String)idNumberMap.get(varId)) != null) {
                    rowData.put("var", varNumber);
                }
            });
        }
    }

    @Override
    public void selOtherInfo(DynamicObject rowObj, Map<String, Object> rowDataMap) {
        String varType = rowObj.getString("vartype");
        Long varId = rowObj.getLong("var_id");
        rowDataMap.put("var", varId);
        this.refVarInfo.computeIfAbsent(varType, key -> new HashSet(16)).add(varId);
    }
}

