/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analyzeReport.service;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;

public class AnalyseDimShowForDimBaseCtrl {
    private static final String USERDIM_PREFIX = "userdim";
    public static final Set<String> ALL_DIM_KEYS = Sets.newHashSet((Object[])new String[]{"account", "budgetperiod", "metric", "currency", "entity", "datatype", "version", "audittrail", "changetype", "internalcompany", "userdim1", "userdim2", "userdim3", "userdim4", "userdim5", "userdim6", "userdim7", "userdim8", "userdim9"});
    public static final String CACHE_USERDINNUM_KEY = "dimNumKeyMapCache";
    public static final String CACHE_SHOWDIM = "showdim";
    public static final String CACHE_MODEL = "modelid";

    public void setDimCtrlVisible(AbstractFormPlugin plugin) {
        String modelId = plugin.getPageCache().get(CACHE_MODEL);
        if (StringUtils.isEmpty((String)modelId)) {
            return;
        }
        plugin.getView().setVisible(Boolean.FALSE, ALL_DIM_KEYS.toArray(new String[0]));
        Set<String> showDimKeys = this.getDimShows(plugin);
        if (showDimKeys == null || showDimKeys.size() == 0) {
            return;
        }
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)Long.valueOf(modelId));
        Map dimensionMap = orCreate.getDimensionMap();
        List dimensions = dimensionMap.values().stream().filter(d -> !d.isPreset()).collect(Collectors.toList());
        HashMap<String, String> userDimNumMapping = new HashMap<String, String>(16);
        int i = 1;
        for (Dimension dimension : dimensions) {
            if (!showDimKeys.contains(dimension.getNumber())) continue;
            String key = USERDIM_PREFIX + i;
            userDimNumMapping.put(dimension.getNumber(), key);
            showDimKeys.remove(dimension.getNumber());
            showDimKeys.add(key);
            BasedataEdit control = (BasedataEdit)plugin.getView().getControl(key);
            control.setCaption(new LocaleString(dimension.getName()));
            ++i;
        }
        showDimKeys.forEach(p -> plugin.getView().setVisible(Boolean.TRUE, new String[]{p.toLowerCase()}));
        plugin.getPageCache().put(CACHE_USERDINNUM_KEY, SerializationUtils.toJsonString(userDimNumMapping));
        plugin.getPageCache().put(CACHE_SHOWDIM, SerializationUtils.toJsonString(showDimKeys));
    }

    public void loadDimValues(AbstractFormPlugin plugin, IDataModel thisModel, Map<String, String> dimValues) {
        String modelId = plugin.getPageCache().get(CACHE_MODEL);
        if (StringUtils.isEmpty((String)modelId)) {
            return;
        }
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)Long.valueOf(modelId));
        Map<String, String> userDimNumKeyMapping = this.getUserDimNumKeyMapping(plugin);
        for (Map.Entry<String, String> dimValueObj : dimValues.entrySet()) {
            String dimKey = dimValueObj.getKey();
            String dimValue = dimValueObj.getValue();
            Dimension dimension = orCreate.getDimension(dimKey);
            if (dimension == null) continue;
            if (!dimension.isPreset() && (dimKey = userDimNumKeyMapping.get(dimKey)) == null) {
                dimKey = dimension.getNumber();
            }
            if (thisModel.getProperty(dimKey.toLowerCase()) == null) continue;
            String memberNum = this.getnumber(plugin, dimKey, dimValue);
            Long viewId = this.getDimViewId(plugin, dimension.getNumber());
            Member member = dimension.getMember(viewId, memberNum);
            if (member == null) continue;
            thisModel.setValue(dimKey.toLowerCase(), (Object)member.getId());
        }
    }

    private String getnumber(AbstractFormPlugin plugin, String dimKey, String str) {
        String memberNumber = str;
        if (str.contains("!")) {
            String[] split = str.split("!");
            memberNumber = split[0];
            if (split.length >= 3) {
                Long viewId = Long.parseLong(split[2]);
                this.cacheDimViewId(plugin, this.getCurrentDimNumber(plugin, dimKey), viewId);
            }
        }
        return memberNumber;
    }

    public boolean checkDimHasValue(IDataModel thisModel, AbstractFormPlugin plugin) {
        Set<String> showDimKeys = this.getDimShows(plugin);
        if (showDimKeys == null) {
            return true;
        }
        for (String dim : showDimKeys) {
            DynamicObject value = thisModel.getProperty(dim.toLowerCase()) == null ? null : (DynamicObject)thisModel.getValue(dim.toLowerCase());
            if (value != null) continue;
            return false;
        }
        return true;
    }

    public String getDimJson(AbstractFormPlugin plugin, IDataModel thisModel) {
        HashMap<String, String> dimMaps = new HashMap<String, String>(16);
        Set<String> showDimKeys = this.getDimShows(plugin);
        for (String dim : showDimKeys) {
            DynamicObject member;
            DynamicObject dynamicObject = member = thisModel.getProperty(dim.toLowerCase()) == null ? null : (DynamicObject)thisModel.getValue(dim.toLowerCase());
            if (member == null) continue;
            dimMaps.put(this.getCurrentDimNumber(plugin, dim.toLowerCase(Locale.getDefault())), this.getMemberString(plugin, member, dim));
        }
        return SerializationUtils.toJsonString(dimMaps);
    }

    private String getMemberString(AbstractFormPlugin plugin, DynamicObject member, String dimKey) {
        String baseMemberString = member.getString("number") + "!" + member.getString("name");
        Long dimViewId = this.getDimViewId(plugin, this.getCurrentDimNumber(plugin, dimKey));
        if (dimViewId != 0L) {
            baseMemberString = baseMemberString + "!" + dimViewId;
        }
        return baseMemberString;
    }

    public Long getDimViewId(AbstractFormPlugin plugin, String dimKey) {
        String viewObj = plugin.getPageCache().get(dimKey + "_viewId");
        if (StringUtils.isEmpty((String)viewObj)) {
            return 0L;
        }
        return Long.parseLong(viewObj);
    }

    public void cacheDimViewId(AbstractFormPlugin plugin, String dimKey, Long viewId) {
        plugin.getPageCache().put(dimKey + "_viewId", viewId.toString());
    }

    public String getCurrentDimNumber(AbstractFormPlugin plugin, String controlKey) {
        if (controlKey == null) {
            return null;
        }
        String currentDimNumber = this.getCurrentDimNumberNew(plugin, controlKey);
        if (currentDimNumber == null) {
            currentDimNumber = this.getCurrentDimNumberNew(plugin, controlKey.toLowerCase());
        }
        return currentDimNumber;
    }

    public String getCurrentDimNumberNew(AbstractFormPlugin plugin, String controlKey) {
        switch (controlKey) {
            case "account": {
                return "Account";
            }
            case "budgetperiod": {
                return "BudgetPeriod";
            }
            case "entity": {
                return "Entity";
            }
            case "metric": {
                return "Metric";
            }
            case "currency": {
                return "Currency";
            }
            case "datatype": {
                return "DataType";
            }
            case "version": {
                return "Version";
            }
            case "audittrail": {
                return "AuditTrail";
            }
            case "changetype": {
                return "ChangeType";
            }
            case "internalcompany": {
                return "InternalCompany";
            }
        }
        Map<String, String> userDimNumKeyMapping = this.getUserDimNumKeyMapping(plugin);
        for (Map.Entry<String, String> entry : userDimNumKeyMapping.entrySet()) {
            if (!controlKey.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public Map<String, String> getUserDimNumKeyMapping(AbstractFormPlugin plugin) {
        String s = plugin.getPageCache().get(CACHE_USERDINNUM_KEY);
        if (s == null) {
            return new HashMap<String, String>(0);
        }
        return (Map)SerializationUtils.fromJsonString((String)s, HashMap.class);
    }

    private Set<String> getDimShows(AbstractFormPlugin plugin) {
        String s = plugin.getPageCache().get(CACHE_SHOWDIM);
        if (StringUtils.isEmpty((String)s)) {
            return new HashSet<String>(0);
        }
        return (Set)SerializationUtils.fromJsonString((String)s, Set.class);
    }
}

