/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analyzeReport.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.utils.DynamicObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.analyzeReport.service.AnalyseRptTmpUtil;
import kd.epm.eb.business.billimpexp.BillImpExpUtils;
import kd.epm.eb.business.centralapproval.CentralAppBillService;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.analysereport.constants.DimGroupTypeEnum;
import kd.epm.eb.common.analysereport.constants.DimMemberTypeEnum;
import kd.epm.eb.common.analysereport.constants.FunOperationEnum;
import kd.epm.eb.common.analysereport.constants.LogicOperationEnum;
import kd.epm.eb.common.analysereport.constants.VariableTypeEnum;
import kd.epm.eb.common.analysereport.pojo.AnalyseRptEntity;
import kd.epm.eb.common.analysereport.pojo.MemberView;
import kd.epm.eb.common.analysereport.pojo.formula.CalculateFormulaNode;
import kd.epm.eb.common.analysereport.pojo.formula.DimGroupFormulaNode;
import kd.epm.eb.common.analysereport.pojo.formula.FormulaCheckResult;
import kd.epm.eb.common.analysereport.pojo.formula.FormulaNode;
import kd.epm.eb.common.analysereport.pojo.formula.FunFormulaNode;
import kd.epm.eb.common.analysereport.pojo.formula.NumberFormulaNode;
import kd.epm.eb.common.analysereport.pojo.quote.RefDimColInfo;
import kd.epm.eb.common.analysereport.pojo.quote.RefDimStrInfo;
import kd.epm.eb.common.analysereport.pojo.quote.VarQuoteInfo;
import kd.epm.eb.common.analysereport.pojo.section.RptSection;
import kd.epm.eb.common.analysereport.pojo.var.MemberVarValObj;
import kd.epm.eb.common.applybill.Count;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.AbstractTree;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.TemplateStatus;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.common.permission.FunPermissionHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.Counter;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.cache.Cache;
import kd.epm.eb.common.utils.cache.ICache;
import kd.epm.eb.common.var.ReportVarUtil;
import kd.epm.eb.spread.template.BgTemplate;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.pagedim.IPageDimensionEntry;

public class AnalyseReportUtil {
    private static final AnalyseReportUtil instance = new AnalyseReportUtil();
    private static final String FORMKEY = "eb_rptvarreference";
    private static final Log log = LogFactory.getLog(AnalyseReportUtil.class);
    public static final List<String> dataTypes = Arrays.asList(MetricDataTypeEnum.CURRENCY.getIndex(), MetricDataTypeEnum.NONMONETARY.getIndex(), MetricDataTypeEnum.RATE.getIndex());

    public static AnalyseReportUtil getInstance() {
        return instance;
    }

    public RefDimStrInfo getRefDimNumsByQuote(VarQuoteInfo varQuoteInfo, Long modelId, Long bizModelId) {
        RefDimColInfo refDimColInfo = new RefDimColInfo();
        this.selRefDimNumsOnCondition(refDimColInfo, varQuoteInfo.getRefConditionIds());
        this.selRefDimNumsOnDimGroup(refDimColInfo, varQuoteInfo.getRefDimGroupIds());
        return this.getRefDimNumsStr(refDimColInfo, modelId, bizModelId);
    }

    public RefDimStrInfo getRefDimNumsStr(RefDimColInfo refDimColInfo, Long modelId, Long bizModelId) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        List dimensionList = modelCacheHelper.getDimensionListByBusModel(bizModelId);
        List<String> dimNums = dimensionList.stream().map(BaseCache::getNumber).collect(Collectors.toList());
        return this.getRefDimNumsStr(refDimColInfo, dimNums);
    }

    public RefDimStrInfo getRefDimNumsStr(RefDimColInfo refDimColInfo, List<String> dimNums) {
        StringBuilder sb1 = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        dimNums.forEach(dimNum -> {
            if (refDimColInfo.getRefFunctionDims().contains(dimNum)) {
                sb1.append((String)dimNum).append(',');
            }
            if (refDimColInfo.getRefParamDims().contains(dimNum)) {
                sb2.append((String)dimNum).append(',');
            }
        });
        if (sb1.length() > 0) {
            sb1.deleteCharAt(sb1.length() - 1);
        }
        if (sb2.length() > 0) {
            sb2.deleteCharAt(sb2.length() - 1);
        }
        return new RefDimStrInfo(sb1.toString(), sb2.toString());
    }

    public void selRefDimNumsOnDimGroup(RefDimColInfo refDimColInfo, Set<Long> dimGroupIds) {
        this.selRefDimNums(refDimColInfo, dimGroupIds, "eb_dimcombinationentity", null);
    }

    public void selRefDimNumsOnCondition(RefDimColInfo refDimColInfo, Set<Long> conditionIds) {
        this.selRefDimNums(refDimColInfo, conditionIds, "eb_judgecondition", null);
    }

    public void selRefDimNums(RefDimColInfo refDimColInfo, Set<Long> objIds, String formKey, Map<Long, Pair<String, String>> numNameSel) {
        if (objIds != null && objIds.size() > 0) {
            String selField = "reffunctiondimnums,refparamdimnums";
            if (numNameSel != null) {
                selField = selField + ",id,number,name";
            }
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getRefDimNumsOnDimGroup", (String)formKey, (String)selField, (QFilter[])new QFilter("id", "in", objIds).toArray(), null);){
                for (Row row : dataSet) {
                    String reffunctiondimnums = row.getString("reffunctiondimnums");
                    String refparamdimnums = row.getString("refparamdimnums");
                    refDimColInfo.getRefFunctionDims().addAll(this.parserRefDimNums(reffunctiondimnums));
                    refDimColInfo.getRefParamDims().addAll(this.parserRefDimNums(refparamdimnums));
                    if (numNameSel == null) continue;
                    numNameSel.put(row.getLong("id"), (Pair<String, String>)new Pair((Object)row.getString("number"), (Object)row.getString("name")));
                }
            }
        }
    }

    public void selRefDimNumOnObj(DynamicObject object, RefDimColInfo refDimColInfo) {
        if (object != null) {
            String dimStrOnFunc = object.getString("reffunctiondimnums");
            refDimColInfo.getRefFunctionDims().addAll(this.parserRefDimNums(dimStrOnFunc));
            String dimStrOnParam = object.getString("refparamdimnums");
            refDimColInfo.getRefParamDims().addAll(this.parserRefDimNums(dimStrOnParam));
        }
    }

    public List<String> parserRefDimNums(String dimNumStr) {
        LinkedList<String> result = new LinkedList<String>();
        if (StringUtils.isNotEmpty((String)dimNumStr)) {
            for (String dimNum : dimNumStr.split(",")) {
                if (!StringUtils.isNotEmpty((String)dimNumStr)) continue;
                result.add(dimNum);
            }
        }
        return result;
    }

    public FormulaCheckResult parseToFormulaNode(String formulaString, Long modelId, Long bizModelId, Boolean checkExist) {
        char[] chars;
        FormulaCheckResult checkResult = new FormulaCheckResult();
        if (StringUtils.isEmpty((String)formulaString) || StringUtils.isEmpty((String)formulaString.trim())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u516c\u5f0f\u4e0d\u5141\u8bb8\u4e3a\u7a7a", (String)"AnalyseReportUtil_0", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        Stack<String> op = new Stack<String>();
        Stack<String> specialOp = new Stack<String>();
        Stack<FormulaNode> nodes = new Stack<FormulaNode>();
        StringBuilder formulaPartString = new StringBuilder();
        Character endRecordChar = null;
        for (char aChar : chars = formulaString.toCharArray()) {
            LogicOperationEnum logicOperate;
            if (' ' == aChar || '\u00a0' == aChar) continue;
            if (endRecordChar != null) {
                if (endRecordChar.charValue() == aChar) {
                    if ('[' == endRecordChar.charValue()) {
                        String type = formulaPartString.toString();
                        if (!"function".equals(type) && !"dimGroup".equals(type)) {
                            throw new KDBizException(ResManager.loadResFormat((String)"\u5b58\u5728\u9519\u8bef\u7684\u7c7b\u578b\uff1a%1\u3002", (String)"AnalyseReportUtil_1", (String)"epm-eb-business", (Object[])new Object[]{type}));
                        }
                        op.push(type);
                        endRecordChar = Character.valueOf(']');
                    } else {
                        endRecordChar = null;
                        String dataMapJson = formulaPartString.toString();
                        Map dataMap = (Map)SerializationUtils.fromJsonString((String)dataMapJson, HashMap.class);
                        String type = this.pop(op);
                        if ("dimGroup".equals(type)) {
                            DimGroupFormulaNode dimGroupFormulaNode = new DimGroupFormulaNode();
                            long dimGroupId = Long.parseLong((String)dataMap.get("id"));
                            dimGroupFormulaNode.setDimCombinationId(Long.valueOf(dimGroupId));
                            dimGroupFormulaNode.setDimCombinationName((String)dataMap.get("name"));
                            this.pushNode(nodes, op, (FormulaNode)dimGroupFormulaNode);
                            checkResult.getRelateDimGroups().add(dimGroupId);
                            specialOp.push("endNode");
                        } else {
                            String index = (String)dataMap.get("id");
                            String name = (String)dataMap.get("name");
                            FunOperationEnum functionOperate = FunOperationEnum.getFunctionEnumByIndex((String)index);
                            if (functionOperate == null) {
                                throw new KDBizException(ResManager.loadResFormat((String)"\u9519\u8bef\u7684\u51fd\u6570\uff1a%1", (String)"AnalyseReportUtil_2", (String)"epm-eb-business", (Object[])new Object[]{index}));
                            }
                            if (!functionOperate.getExpress().equals(name)) {
                                throw new KDBizException(ResManager.loadKDString((String)"\u51fd\u6570\u7f16\u7801\u4e0e\u540d\u79f0\u4e0d\u7b26\u3002", (String)"AnalyseReportUtil_3", (String)"epm-eb-business", (Object[])new Object[0]));
                            }
                            op.push(index);
                            specialOp.push("funArgs");
                        }
                    }
                    formulaPartString = new StringBuilder();
                    continue;
                }
                if (aChar == '@') {
                    throw new KDBizException(ResManager.loadResFormat((String)"\u5b58\u5728\u9519\u8bef\u7684\u5b57\u7b26\uff1a%1", (String)"AnalyseReportUtil_8", (String)"epm-eb-business", (Object[])new Object[]{Character.valueOf(aChar)}));
                }
                formulaPartString.append(aChar);
                continue;
            }
            String specialOperate = null;
            if (specialOp.size() != 0) {
                specialOperate = (String)this.pop(specialOp);
            }
            boolean isEndNode = "endNode".equals(specialOperate);
            if ("funArgs".equals(specialOperate) && '(' != aChar) {
                throw new KDBizException(ResManager.loadResFormat((String)"%1 \u51fd\u6570\u540e\u5fc5\u987b\u4e3a\u62ec\u53f7", (String)"AnalyseReportUtil_4", (String)"epm-eb-business", (Object[])new Object[]{FunOperationEnum.getFunctionEnumByIndex((String)this.pop(op))}));
            }
            if (isEndNode && !LogicOperationEnum.isCalculateOperation((LogicOperationEnum)(logicOperate = LogicOperationEnum.getLogicEnumByExpress((String)String.valueOf(aChar)))).booleanValue() && ')' != aChar && ',' != aChar) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u5b58\u5728\u9519\u8bef\u7684\u8ba1\u7b97\u903b\u8f91\uff1a%1", (String)"AnalyseReportUtil_5", (String)"epm-eb-business", (Object[])new Object[]{this.pop(nodes).toString() + aChar}));
            }
            if (this.isNumerical(aChar)) {
                formulaPartString.append(aChar);
                continue;
            }
            if ('@' == aChar || '(' == aChar) {
                if (formulaPartString.length() != 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6570\u503c\u5217\u3001\u51fd\u6570\u6216\u5de6\u62ec\u53f7\u5904\u5b58\u5728\u9519\u8bef\u7684\u8ba1\u7b97\u903b\u8f91", (String)"AnalyseReportUtil_6", (String)"epm-eb-business", (Object[])new Object[0]));
                }
                if ('@' == aChar) {
                    endRecordChar = Character.valueOf('[');
                    continue;
                }
                if (op.size() != 0 && FunOperationEnum.getFunctionEnumByIndex((String)((String)op.elementAt(op.size() - 1))) != null) continue;
                CalculateFormulaNode calculateFormulaNode = new CalculateFormulaNode();
                calculateFormulaNode.setHasLeftParentheses(true);
                this.pushNode(nodes, op, (FormulaNode)calculateFormulaNode);
                op.push(String.valueOf(aChar));
                continue;
            }
            NumberFormulaNode numberFormulaNode = null;
            if (formulaPartString.length() != 0) {
                numberFormulaNode = this.createNumberNode(formulaPartString.toString());
            }
            if (',' == aChar) {
                this.pushNumberNode(nodes, op, numberFormulaNode, isEndNode, true);
                op.push(String.valueOf(aChar));
            } else if ('+' == aChar || '-' == aChar || '*' == aChar || '/' == aChar) {
                this.pushNumberNode(nodes, op, numberFormulaNode, isEndNode, false);
                op.push(String.valueOf(aChar));
            } else if (')' == aChar) {
                this.pushNumberNode(nodes, op, numberFormulaNode, isEndNode, false);
                this.matchLeftParentheses(nodes, op, null);
                specialOp.push("endNode");
            } else {
                throw new KDBizException(ResManager.loadResFormat((String)"\u5b58\u5728\u9519\u8bef\u7684\u5b57\u7b26\uff1a%1", (String)"AnalyseReportUtil_8", (String)"epm-eb-business", (Object[])new Object[]{Character.valueOf(aChar)}));
            }
            formulaPartString = new StringBuilder();
        }
        if (formulaPartString.length() != 0) {
            this.pushNumberNode(nodes, op, this.createNumberNode(formulaPartString.toString()), false, false);
        }
        if (endRecordChar != null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u5b58\u5728\u9519\u8bef\u7684\u5b57\u7b26\uff1a%1", (String)"AnalyseReportUtil_8", (String)"epm-eb-business", (Object[])new Object[]{"@"}));
        }
        if (nodes.size() - op.size() != 1) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u5b58\u5728\u591a\u4f59\u7684\u903b\u8f91\u7b26\u53f7: %1", (String)"AnalyseReportUtil_9", (String)"epm-eb-business", (Object[])new Object[]{this.pop(op)}));
        }
        if (op.contains(LogicOperationEnum.LEFTPARENTHESES.getExpress())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u8ba1\u7b97\u903b\u8f91\u95ee\u9898", (String)"AnalyseReportUtil_11", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        this.relateAllNodes(nodes, op, null);
        if (checkExist.booleanValue()) {
            this.checkDimGroupExist(checkResult, modelId, bizModelId);
        }
        checkResult.setSuccess(Boolean.valueOf(true));
        checkResult.setFormulaNode(this.pop(nodes));
        return checkResult;
    }

    private NumberFormulaNode createNumberNode(String calculate) {
        BigDecimal bigDecimal = ConvertUtils.toDecimal((Object)calculate);
        if (bigDecimal == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u5b58\u5728\u9519\u8bef\u7684\u6570\u503c\uff1a%1", (String)"AnalyseReportUtil_7", (String)"epm-eb-business", (Object[])new Object[]{calculate}));
        }
        NumberFormulaNode numberFormulaNode = new NumberFormulaNode();
        numberFormulaNode.setNumericalValue(bigDecimal);
        return numberFormulaNode;
    }

    private void pushNumberNode(Stack<FormulaNode> nodes, Stack<String> op, NumberFormulaNode numberFormulaNode, boolean isEndNode, boolean onlyPushNode) {
        if (numberFormulaNode == null) {
            if (!isEndNode) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u903b\u8f91\u95ee\u9898", (String)"AnalyseReportUtil_10", (String)"epm-eb-business", (Object[])new Object[0]));
            }
        } else if (onlyPushNode) {
            nodes.push((FormulaNode)numberFormulaNode);
        } else {
            this.pushNode(nodes, op, (FormulaNode)numberFormulaNode);
        }
    }

    private boolean isNumerical(char aChar) {
        return aChar >= '0' && aChar <= '9' || aChar == '.';
    }

    private void pushNode(Stack<FormulaNode> nodeStack, Stack<String> op, FormulaNode formulaNode) {
        int size = op.size();
        if (size == 0) {
            nodeStack.push(formulaNode);
            return;
        }
        String operate = this.pop(op);
        if (!"*".equals(operate) && !"/".equals(operate)) {
            nodeStack.push(formulaNode);
            op.push(operate);
            return;
        }
        FormulaNode preNode = this.pop(nodeStack);
        if (preNode instanceof CalculateFormulaNode) {
            if (preNode.isHasRightParentheses()) {
                CalculateFormulaNode calNode = new CalculateFormulaNode();
                calNode.setInnerNode(preNode);
                preNode.setLogicOperation(LogicOperationEnum.getLogicEnumByExpress((String)operate));
                preNode.setNextNode(formulaNode);
                nodeStack.push((FormulaNode)calNode);
            } else {
                FormulaNode node = ((CalculateFormulaNode)preNode).getInnerNode();
                while (node.getNextNode() != null) {
                    node = node.getNextNode();
                }
                node.setNextNode(formulaNode);
                node.setLogicOperation(LogicOperationEnum.getLogicEnumByExpress((String)operate));
                nodeStack.push(preNode);
            }
        } else {
            CalculateFormulaNode calNode = new CalculateFormulaNode();
            calNode.setInnerNode(preNode);
            preNode.setLogicOperation(LogicOperationEnum.getLogicEnumByExpress((String)operate));
            preNode.setNextNode(formulaNode);
            nodeStack.push((FormulaNode)calNode);
        }
    }

    private void matchLeftParentheses(Stack<FormulaNode> nodes, Stack<String> op, FormulaNode node) {
        block18: {
            String operate;
            FormulaNode curNode;
            block17: {
                LogicOperationEnum logicOperation;
                curNode = node;
                if (curNode == null) {
                    curNode = this.pop(nodes);
                }
                if ((logicOperation = LogicOperationEnum.getLogicEnumByExpress((String)(operate = this.pop(op)))) == null) break block17;
                switch (logicOperation) {
                    case PLUS: 
                    case SUBTRACT: {
                        FormulaNode preNode = this.pop(nodes);
                        preNode.setLogicOperation(logicOperation);
                        preNode.setNextNode(curNode);
                        curNode = preNode;
                        this.matchLeftParentheses(nodes, op, curNode);
                        break block18;
                    }
                    case LEFTPARENTHESES: {
                        FormulaNode calNode = this.pop(nodes);
                        if (calNode instanceof CalculateFormulaNode) {
                            CalculateFormulaNode calculateNode = (CalculateFormulaNode)calNode;
                            if (calculateNode.isHasRightParentheses()) {
                                throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u8ba1\u7b97\u903b\u8f91\u95ee\u9898", (String)"AnalyseReportUtil_11", (String)"epm-eb-business", (Object[])new Object[0]));
                            }
                            if (calculateNode.getInnerNode() == null) {
                                calculateNode.setHasRightParentheses(true);
                                calculateNode.setInnerNode(curNode);
                            } else {
                                FormulaNode nextNode = calculateNode.getInnerNode().getNextNode();
                                if (nextNode == null) {
                                    throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u8ba1\u7b97\u903b\u8f91\u95ee\u9898", (String)"AnalyseReportUtil_11", (String)"epm-eb-business", (Object[])new Object[0]));
                                }
                                nextNode.setHasRightParentheses(true);
                                if (nextNode instanceof CalculateFormulaNode) {
                                    ((CalculateFormulaNode)nextNode).setInnerNode(curNode);
                                } else {
                                    ((CalculateFormulaNode)nextNode.getNextNode()).setInnerNode(curNode);
                                }
                            }
                        } else {
                            throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u8ba1\u7b97\u903b\u8f91\u95ee\u9898", (String)"AnalyseReportUtil_11", (String)"epm-eb-business", (Object[])new Object[0]));
                        }
                        nodes.push(calNode);
                        break block18;
                    }
                    default: {
                        throw new KDBizException(ResManager.loadResFormat((String)"\u5b58\u5728\u9519\u8bef\u7684\u903b\u8f91\u7b26\u53f7\uff1a%1", (String)"AnalyseReportUtil_12", (String)"epm-eb-business", (Object[])new Object[]{operate}));
                    }
                }
            }
            FunOperationEnum funOperation = FunOperationEnum.getFunctionEnumByIndex((String)operate);
            if (funOperation != null) {
                List<FormulaNode> argNodes = this.getAllArgNodes(curNode);
                if (argNodes.size() != funOperation.getArgSize()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u51fd\u6570\u7684\u53c2\u6570\u6570\u91cf\u4e0d\u5339\u914d", (String)"AnalyseReportUtil_13", (String)"epm-eb-business", (Object[])new Object[0]));
                }
                FunFormulaNode funFormulaNode = new FunFormulaNode();
                funFormulaNode.setFunOperation(funOperation);
                funFormulaNode.setFunArgs(argNodes);
                this.pushNode(nodes, op, (FormulaNode)funFormulaNode);
            } else if (",".equals(operate)) {
                FormulaNode preNode = this.pop(nodes);
                preNode.setNextNode(curNode);
                curNode = preNode;
                this.matchLeftParentheses(nodes, op, curNode);
            }
        }
    }

    private <T> T pop(Stack<T> nodes) {
        if (nodes.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u8ba1\u7b97\u903b\u8f91\u95ee\u9898", (String)"AnalyseReportUtil_11", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        return nodes.pop();
    }

    private List<FormulaNode> getAllArgNodes(FormulaNode curNode) {
        ArrayList<FormulaNode> nodes = new ArrayList<FormulaNode>(16);
        if (curNode == null) {
            return nodes;
        }
        nodes.add(curNode);
        while (curNode.getNextNode() != null) {
            LogicOperationEnum logicOperation = curNode.getLogicOperation();
            curNode = curNode.getNextNode();
            if (logicOperation != null) continue;
            nodes.add(curNode);
        }
        return nodes;
    }

    private void relateAllNodes(Stack<FormulaNode> nodes, Stack<String> op, FormulaNode node) {
        if (op.size() == 0) {
            if (node != null) {
                nodes.push(node);
            }
            return;
        }
        if (node == null) {
            node = this.pop(nodes);
        }
        FormulaNode preNode = this.pop(nodes);
        String operate = this.pop(op);
        preNode.setNextNode(node);
        preNode.setLogicOperation(LogicOperationEnum.getLogicEnumByExpress((String)operate));
        this.relateAllNodes(nodes, op, preNode);
    }

    private void checkDimGroupExist(FormulaCheckResult formulaCheckResult, Long modelId, Long bizModelId) {
        List relateDimGroups = formulaCheckResult.getRelateDimGroups();
        if (relateDimGroups.size() == 0) {
            return;
        }
        QFilter qFilter = new QFilter("id", "in", (Object)relateDimGroups);
        qFilter.and("model", "=", (Object)modelId);
        qFilter.and("bizModel", "=", (Object)bizModelId);
        DynamicObjectCollection query = QueryServiceHelper.query((String)VariableTypeEnum.Combination.getMetadata(), (String)"id", (QFilter[])new QFilter[]{qFilter});
        HashSet tmp = new HashSet(relateDimGroups);
        List existIds = query.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
        tmp.removeAll(existIds);
        if (tmp.size() != 0) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u4e0d\u5b58\u5728id\u4e3a %1 \u7684\u7ef4\u5ea6\u7ec4\u5408", (String)"AnalyseReportUtil_14", (String)"epm-eb-business", (Object[])new Object[]{tmp.stream().map(String::valueOf).collect(Collectors.joining("\u3001"))}));
        }
    }

    public String calcPeriod(String period, IModelCacheHelper orCreate, boolean isRing) {
        String periodNum = this.calcPeriod(period, isRing);
        Member member = orCreate.getDimension("BudgetPeriod").getMember(null, periodNum);
        if (member == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u671f\u95f4\uff1a%1\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u8ba1\u7b97\u540c\u6bd4\u6216\u73af\u6bd4\u3002", (String)"AnalyseRptTemplateService_1", (String)"epm-eb-formplugin", (Object[])new Object[]{periodNum}));
        }
        return periodNum;
    }

    public String calcPeriod(String period, boolean isRing) {
        String[] split = period.split("\\.");
        int year = Integer.parseInt(split[0].replace("FY", ""));
        String stuff = split.length == 1 ? "" : split[1];
        String p = null;
        if (StringUtils.isEmpty((String)stuff)) {
            p = "FY" + --year;
        } else if (!isRing) {
            p = "FY" + --year + "." + stuff;
        } else {
            int st = Integer.parseInt(stuff.replaceFirst("M", "").replaceFirst("HF", "").replaceFirst("Q", ""));
            if (stuff.contains("M")) {
                if (st == 1) {
                    --year;
                    st = 12;
                } else {
                    --st;
                }
                p = "FY" + year + ".M" + String.format("%02d", st);
            } else if (stuff.contains("HF")) {
                if (st == 1) {
                    --year;
                    st = 2;
                } else {
                    --st;
                }
                p = "FY" + year + ".HF" + st;
            } else {
                if (st == 1) {
                    --year;
                    st = 4;
                } else {
                    --st;
                }
                p = "FY" + year + ".Q" + st;
            }
        }
        return p;
    }

    public QFilter getMetricTypeQFilter() {
        QFilter qFilter = new QFilter("metricdatatype", "in", dataTypes);
        qFilter.or("metric.datatype", "in", dataTypes);
        return qFilter;
    }

    public void updateDimGroups(Long modelId, Long datasetId) {
        QFilter qfilter = new QFilter("dataset", "=", (Object)datasetId);
        qfilter.and("model", "=", (Object)modelId);
        qfilter.and("dimgrouptype", "=", (Object)DimGroupTypeEnum.NUMBER.getIndex());
        List<Object> idList = CentralAppBillService.getInstance().getIdList(qfilter, VariableTypeEnum.Combination.getMetadata(), null);
        DynamicObject[] combinations = BusinessDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)VariableTypeEnum.Combination.getMetadata()));
        if (combinations.length == 0) {
            return;
        }
        ArrayList<MemberQuoteDao> quotes = new ArrayList<MemberQuoteDao>(16);
        try {
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
            List dimensionList = modelCacheHelper.getDimensionList(datasetId);
            ArrayList<DynamicObject> toSaveCombinations = new ArrayList<DynamicObject>(16);
            HashSet<String> ignoreKeys = new HashSet<String>(Arrays.asList("id", "seq"));
            for (DynamicObject combination : combinations) {
                Long combineId = combination.getLong("id");
                Long accountId = combination.getLong("account.id");
                Long metricId = combination.getLong("metric.id");
                DynamicObjectCollection memberEntity = combination.getDynamicObjectCollection("memberentry");
                Map<String, DynamicObject> memberEntryMap = memberEntity.stream().collect(Collectors.toMap(e -> e.getString("dimension.number"), e -> e, (n1, n2) -> n2));
                memberEntity.clear();
                for (Dimension dimension : dimensionList) {
                    String number = dimension.getNumber();
                    Long dimensionId = dimension.getId();
                    if (SysDimensionEnum.Account.getNumber().equals(number)) {
                        quotes.add(new MemberQuoteDao(modelId, datasetId, dimensionId, accountId, MemberQuoteResourceEnum.DimGroup, combineId));
                        continue;
                    }
                    if (SysDimensionEnum.Metric.getNumber().equals(number)) {
                        quotes.add(new MemberQuoteDao(modelId, datasetId, dimensionId, metricId, MemberQuoteResourceEnum.DimGroup, combineId));
                        continue;
                    }
                    DynamicObject memberEntry = memberEntity.addNew();
                    DynamicObject entry = memberEntryMap.get(number);
                    if (entry != null) {
                        DynamicObjectUtils.copy((DynamicObject)entry, (DynamicObject)memberEntry, ignoreKeys);
                        String dimMemberType = memberEntry.getString("dimmembertype");
                        if (DimMemberTypeEnum.PARAM.getIndex().equals(dimMemberType)) {
                            DynamicObject param = memberEntry.getDynamicObject("member");
                            if (!SysDimensionEnum.BudgetPeriod.getNumber().equals(number) || param == null) continue;
                            quotes.add(new MemberQuoteDao(modelId, Long.valueOf(0L), dimensionId, Long.valueOf(param.getLong("id")), MemberTypeEnum.DIMENSIONPARAM, MemberQuoteResourceEnum.DimGroup, combineId));
                            continue;
                        }
                        if (!DimMemberTypeEnum.MEMBER.getIndex().equals(dimMemberType)) continue;
                        quotes.add(new MemberQuoteDao(modelId, datasetId, dimensionId, Long.valueOf(memberEntry.getLong("member.id")), MemberQuoteResourceEnum.DimGroup, combineId));
                        DynamicObject dimView = memberEntry.getDynamicObject("dimview");
                        if (dimView == null) continue;
                        long dimViewId = dimView.getLong("id");
                        quotes.add(new MemberQuoteDao(modelId, Long.valueOf(0L), dimensionId, Long.valueOf(dimViewId), MemberTypeEnum.VIEW, MemberQuoteResourceEnum.DimGroup, combineId));
                        continue;
                    }
                    Long noneMemberId = dimension.getMember(dimension.getDefaultViewId(), dimension.getNoneNumber()).getId();
                    memberEntry.set("dimension", (Object)dimensionId);
                    memberEntry.set("dimmembertype", (Object)DimMemberTypeEnum.MEMBER.getIndex());
                    memberEntry.set("memberclasstype", (Object)SysDimensionEnum.getMemberTreemodelByNumber((String)dimension.getNumber()));
                    memberEntry.set("member", (Object)noneMemberId);
                    memberEntry.set("dimview", (Object)dimension.getDefaultViewId());
                    quotes.add(new MemberQuoteDao(modelId, datasetId, dimensionId, noneMemberId, MemberQuoteResourceEnum.DimGroup, combineId));
                }
                toSaveCombinations.add(combination);
            }
            try (TXHandle tx = TX.required((String)"updateDimGroup");){
                try {
                    SaveServiceHelper.save((DynamicObject[])toSaveCombinations.toArray(new DynamicObject[0]));
                    DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"save", (Object[])new Object[]{quotes});
                }
                catch (Exception ex) {
                    tx.markRollback();
                    throw ex;
                }
            }
        }
        catch (Exception ex) {
            log.error("update dimGroup failed:", (Throwable)ex);
        }
    }

    public Map<Long, Set<Long>> getRptSectionVarInfos(Set<Long> sectionIds) {
        DynamicObject[] objs;
        HashMap<Long, Set<Long>> varInfoMap = new HashMap<Long, Set<Long>>(16);
        for (DynamicObject object : objs = BusinessDataServiceHelper.load((Object[])sectionIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)VariableTypeEnum.RptSection.getMetadata()))) {
            this.getRptSectionVarInfos(object, false, (dimId, varId) -> varInfoMap.computeIfAbsent((Long)dimId, key -> new HashSet(16)).add((Long)varId));
        }
        return varInfoMap;
    }

    public void getRptSectionVarInfos(DynamicObject obj, boolean needNumber, BiConsumer<Object, Object> varConsumer) {
        if (obj == null) {
            return;
        }
        for (DynamicObject memberRow : obj.getDynamicObjectCollection("memberentry")) {
            if (!"eb_periodvariable".equals(memberRow.getString("memberclasstype"))) continue;
            if (needNumber) {
                varConsumer.accept(memberRow.getString("dimension.number"), memberRow.getString("member.number"));
                continue;
            }
            varConsumer.accept(memberRow.getLong("dimension.id"), memberRow.getLong("member.id"));
        }
        for (DynamicObject memberRow : obj.getDynamicObjectCollection("orderentry")) {
            if (!"eb_periodvariable".equals(memberRow.getString("memberclasstype1"))) continue;
            if (needNumber) {
                varConsumer.accept(memberRow.getString("dimension1.number"), memberRow.getString("member1.number"));
                continue;
            }
            varConsumer.accept(memberRow.getLong("dimension1.id"), memberRow.getLong("member1.id"));
        }
    }

    public Map<Long, Set<Long>> getTempRefVarInfos(Long rptTemplateId) {
        Set<Long> refDimGroupIds = AnalyseRptTmpUtil.getInstance().getRefDimGroupIds(rptTemplateId, 1);
        Set<Long> refRptSectionIds = AnalyseRptTmpUtil.getInstance().getRefRptSectionIds(rptTemplateId);
        Map<Long, Set<Long>> dimGroupVarInfos = AnalyseReportUtil.getInstance().getDimGroupVarInfos(refDimGroupIds);
        Map<Long, Set<Long>> sectionVarInfos = AnalyseReportUtil.getInstance().getRptSectionVarInfos(refRptSectionIds);
        sectionVarInfos.forEach((dimId, varSet) -> dimGroupVarInfos.computeIfAbsent((Long)dimId, key -> new HashSet()).addAll(varSet));
        return dimGroupVarInfos;
    }

    public Map<Long, Set<Long>> getDimGroupVarInfos(Set<Long> dimGroupIds) {
        HashMap<Long, Set<Long>> dimGroupVarInfoMap = new HashMap<Long, Set<Long>>(16);
        HashSet<Long> dimGroupIds_all = new HashSet<Long>(dimGroupIds);
        QFilter formula = new QFilter("id", "in", dimGroupIds);
        formula.and("dimgrouptype", "=", (Object)DimGroupTypeEnum.FORMULA.getIndex());
        DynamicObjectCollection formulas = QueryServiceHelper.query((String)VariableTypeEnum.Combination.getMetadata(), (String)"id, model, bizmodel, formula", (QFilter[])new QFilter[]{formula});
        for (DynamicObject dynamicObject : formulas) {
            String formulaString = dynamicObject.getString("formula");
            if (StringUtils.isEmpty((String)formulaString)) continue;
            FormulaCheckResult formulaCheckResult = this.parseToFormulaNode(formulaString, dynamicObject.getLong("model"), dynamicObject.getLong("bizmodel"), false);
            dimGroupIds_all.addAll(formulaCheckResult.getRelateDimGroups());
        }
        QFilter qFilter = new QFilter("id", "in", dimGroupIds_all);
        qFilter.and("dimgrouptype", "=", (Object)DimGroupTypeEnum.NUMBER.getIndex());
        qFilter.and("memberentry.memberclasstype", "=", (Object)"eb_periodvariable");
        DynamicObjectCollection query = QueryServiceHelper.query((String)VariableTypeEnum.Combination.getMetadata(), (String)"id, memberentry.dimension as dimension, memberentry.member as member", (QFilter[])new QFilter[]{qFilter});
        for (DynamicObject dynamicObject : query) {
            long dimId = dynamicObject.getLong("dimension");
            Set dimGroupVarInfo = dimGroupVarInfoMap.computeIfAbsent(dimId, k -> new HashSet(16));
            dimGroupVarInfo.add(dynamicObject.getLong("member"));
        }
        return dimGroupVarInfoMap;
    }

    public void openBaseForm(Long tempId, boolean isReadOnly, AnalyseRptEntity rptData, IFormView formView, CloseCallBack closeCallBack) {
        HashMap<String, String> openParameter = new HashMap<String, String>(4);
        openParameter.put("formId", "eb_analysereport");
        FormShowParameter formShowParameter = BaseShowParameter.createFormShowParameter(openParameter);
        formShowParameter.setCustomParam("tempid", (Object)String.valueOf(tempId));
        if (rptData != null) {
            if (kd.bos.util.StringUtils.isNotEmpty((String)rptData.getRptNumber())) {
                formShowParameter.setCustomParam("rptnumber", (Object)rptData.getRptNumber());
            }
            if (kd.bos.util.StringUtils.isNotEmpty((String)rptData.getRptName())) {
                formShowParameter.setCustomParam("rptname", (Object)rptData.getRptName());
            }
            if (rptData.isSaved()) {
                ((BaseShowParameter)formShowParameter).setPkId((Object)rptData.getFileId());
                formShowParameter.setStatus(OperationStatus.EDIT);
            }
            if (!rptData.getMemberVarInfo().isEmpty()) {
                AnalyseReportUtil.getInstance().addVarValInfo4Params(rptData.getMemberVarInfo(), formShowParameter.getCustomParams());
            }
        }
        formShowParameter.setCustomParam("isReadOnly", (Object)(isReadOnly ? "1" : "0"));
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        if (closeCallBack != null) {
            formShowParameter.setCloseCallBack(closeCallBack);
        }
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u5206\u6790\u62a5\u544a", (String)"AnalyseReportListPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        formView.showForm(formShowParameter);
    }

    public Map<String, MemberView> parseVarInfo(Long rptId) {
        DynamicObject rptObj = BusinessDataServiceHelper.loadSingleFromCache((Object)rptId, (String)"eb_analysereport");
        if (rptObj != null) {
            return this.parseVarInfo(rptObj.getDynamicObjectCollection("varentryentity"), rptObj.getLong("model.id"));
        }
        return new HashMap<String, MemberView>(16);
    }

    public Map<String, List<MemberVarValObj>> selValInfo(DynamicObjectCollection varRows, Long modelId, Long bizModelId) {
        HashMap<String, List<MemberVarValObj>> result = new HashMap<String, List<MemberVarValObj>>();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Map defaultViews = modelCacheHelper.getViewsByBusModel(bizModelId);
        for (DynamicObject row : varRows) {
            String dimNum = row.getString("vardim.number");
            String varNum = row.getString("varitem.number");
            Long varValId = row.getLong("varvalid");
            Long viewId = row.getLong("varvalviewid");
            if (IDUtils.isEmptyLong((Long)viewId).booleanValue() && SysDimensionEnum.dimHasView((String)dimNum)) {
                viewId = (Long)defaultViews.get(dimNum);
            }
            Long varId = row.getLong("varitem.id");
            List varInfo = result.computeIfAbsent(dimNum, key -> new ArrayList(16));
            varInfo.add(new MemberVarValObj(varId, varNum, varValId, viewId));
        }
        return result;
    }

    public Map<String, MemberView> parseVarInfo(AnalyseRptEntity rptData) {
        HashMap<String, MemberView> memberVarValInfo;
        if (rptData.isSaved()) {
            memberVarValInfo = this.parseVarInfo(rptData.getFileId());
        } else {
            memberVarValInfo = new HashMap();
            Map memberVarInfo = rptData.getMemberVarInfo();
            if (memberVarInfo.size() > 0) {
                IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)rptData.getModelId());
                HashMap map = new HashMap(1);
                memberVarInfo.forEach((dimNum, membVarInfos) -> {
                    Dimension dimension = modelCacheHelper.getDimension(dimNum);
                    if (dimension != null && CollectionUtils.isNotEmpty((Collection)membVarInfos)) {
                        membVarInfos.forEach(varValObj -> {
                            Member member = dimension.getMember(varValObj.getViewId(), varValObj.getVarValId());
                            if (member != null) {
                                if (varValObj.getVarNum().startsWith("@NextY") || varValObj.getVarNum().startsWith("@LastY") || varValObj.getVarNum().startsWith("@BaseY")) {
                                    memberVarValInfo.put(varValObj.getVarNum(), new MemberView(member.getNumber(), null));
                                } else {
                                    map.put(varValObj.getVarNum() + "!" + varValObj.getVarNum(), member.getNumber());
                                    AbstractTree viewOrDim = member.getViewOrDim();
                                    Long viewId = viewOrDim instanceof View ? viewOrDim.getId() : null;
                                    String varValNumber = ReportVarUtil.getVarValueNoError((Long)rptData.getModelId(), (String)varValObj.getVarNum(), (Map)map, (String)dimNum);
                                    memberVarValInfo.put(varValObj.getVarNum(), new MemberView(varValNumber, viewId));
                                }
                                map.clear();
                            }
                        });
                    }
                });
            }
        }
        return memberVarValInfo;
    }

    public Map<String, MemberView> parseVarInfo(DynamicObjectCollection varRows, Long modelId) {
        HashMap<String, MemberView> result = new HashMap<String, MemberView>(16);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        HashMap<String, String> numMap = new HashMap<String, String>(16);
        for (DynamicObject row : varRows) {
            String dimNum = row.getString("vardim.number");
            String varNum = row.getString("varitem.number");
            Long memberId = row.getLong("varvalid");
            Long viewId = row.getLong("varvalviewid");
            Member member = modelCacheHelper.getMember(dimNum, viewId, memberId);
            if (member == null || varNum == null) continue;
            if (varNum.startsWith("@NextY") || varNum.startsWith("@LastY") || varNum.startsWith("@BaseY")) {
                result.put(varNum, new MemberView(member.getNumber(), null));
            } else {
                numMap.put(varNum + "!" + varNum, member.getNumber());
                String realMembNum = ReportVarUtil.getVarValueNoError((Long)modelId, (String)varNum, numMap, (String)dimNum);
                result.put(varNum, new MemberView(realMembNum, viewId));
            }
            numMap.clear();
        }
        return result;
    }

    public void cacheVarValInfo2Redis(Map<String, Object> params) {
        String valStr = this.getVarValStrFromParam(params, true);
        if (valStr != null) {
            String varCacheId = String.valueOf(GlobalIdUtil.genGlobalLongId());
            Cache.get().set("MemberVarValInfo" + varCacheId, valStr, 10, TimeUnit.MINUTES);
            params.put("varCacheKey", varCacheId);
        }
    }

    public Map<String, List<MemberVarValObj>> getAndDelVarValInfoFromCache(Map<String, Object> params) {
        ICache cache;
        String cacheStr;
        String cacheKey = (String)params.get("varCacheKey");
        if (StringUtils.isNotEmpty((String)cacheKey) && StringUtils.isNotEmpty((String)(cacheStr = (cache = Cache.get()).get("MemberVarValInfo" + cacheKey)))) {
            Map result = null;
            ObjectMapper objectMapper = SerializationUtils.getObjectMapper2();
            try {
                result = (Map)objectMapper.readValue(cacheStr, (TypeReference)new TypeReference<Map<String, List<MemberVarValObj>>>(){});
                cache.remove("MemberVarValInfo" + cacheKey);
            }
            catch (Exception e) {
                log.error((Throwable)e);
                throw new KDBizException(e.getMessage());
            }
            return result;
        }
        return new HashMap<String, List<MemberVarValObj>>();
    }

    public void addVarValInfo4Params(Map<String, List<MemberVarValObj>> varValInfo, Map<String, Object> params) {
        params.put("MemberVarValInfo", SerializationUtils.toJsonString(varValInfo));
    }

    public String getVarValStrFromParam(Map<String, Object> params, boolean remove) {
        Object val;
        Object object = val = remove ? params.remove("MemberVarValInfo") : params.get("MemberVarValInfo");
        if (val instanceof String) {
            return (String)val;
        }
        return null;
    }

    public Map<String, List<MemberVarValObj>> getVarValInfoFromParam(Map<String, Object> params) {
        String cacheStr = this.getVarValStrFromParam(params, false);
        if (cacheStr != null) {
            ObjectMapper objectMapper = SerializationUtils.getObjectMapper2();
            try {
                return (Map)objectMapper.readValue(cacheStr, (TypeReference)new TypeReference<Map<String, List<MemberVarValObj>>>(){});
            }
            catch (Exception e) {
                log.error((Throwable)e);
                throw new KDBizException(e.getMessage());
            }
        }
        return new HashMap<String, List<MemberVarValObj>>(16);
    }

    public boolean buildVarEntryRows(Map<String, List<MemberVarValObj>> varValObjs, DynamicObjectCollection entryRows, IModelCacheHelper modelCacheHelper) {
        HashMap<Long, MemberView> varValInfo = new HashMap<Long, MemberView>(16);
        HashMap<Long, Set<Long>> memberVarInfo = new HashMap<Long, Set<Long>>(16);
        varValObjs.forEach((dimNum, varsInfo) -> {
            Long dimId = modelCacheHelper.getDimension(dimNum).getId();
            Set varIds = memberVarInfo.computeIfAbsent(dimId, key -> new HashSet(16));
            varsInfo.forEach(varValObj -> {
                varIds.add(varValObj.getVarId());
                varValInfo.put(varValObj.getVarId(), new MemberView(varValObj.getVarValId(), varValObj.getViewId()));
            });
        });
        return this.buildVarEntryRows(entryRows, memberVarInfo, varValInfo, modelCacheHelper);
    }

    public boolean buildVarEntryRows(DynamicObjectCollection entryRows, Map<Long, Set<Long>> memberVarInfo, Map<Long, MemberView> varValInfo, IModelCacheHelper modelCacheHelper) {
        Count rowChanged = new Count();
        if (memberVarInfo.size() > 0) {
            HashSet dimIds = new HashSet(memberVarInfo.size());
            HashSet allVIds = new HashSet(16);
            memberVarInfo.forEach((dId, vIds) -> {
                dimIds.add(dId);
                allVIds.addAll(vIds);
            });
            HashMap<Long, DynamicObject> dimObjs = new HashMap<Long, DynamicObject>(dimIds.size());
            HashMap<Long, DynamicObject> varObjs = new HashMap<Long, DynamicObject>(allVIds.size());
            DynamicObject[] objs = BusinessDataServiceHelper.load((String)"epm_dimension", (String)"id,number,name", (QFilter[])new QFilter("id", "in", dimIds).toArray());
            if (objs != null) {
                for (DynamicObject obj : objs) {
                    dimObjs.put(obj.getLong("id"), obj);
                }
            }
            if ((objs = BusinessDataServiceHelper.load((String)"eb_periodvariable", (String)"id,number,name,grouptype", (QFilter[])new QFilter("id", "in", allVIds).toArray())) != null) {
                for (DynamicObject obj : objs) {
                    varObjs.put(obj.getLong("id"), obj);
                }
            }
            memberVarInfo.forEach((dId, vIds) -> {
                DynamicObject dimObj = (DynamicObject)dimObjs.get(dId);
                if (dimObj != null) {
                    String dimNum1 = dimObj.getString("number");
                    for (Long vId : vIds) {
                        Member member1;
                        DynamicObject varObj = (DynamicObject)varObjs.get(vId);
                        if (varObj == null) continue;
                        DynamicObject newRow = entryRows.addNew();
                        newRow.set("id", (Object)GlobalIdUtil.genGlobalLongId());
                        newRow.set("vardim", (Object)dimObj);
                        newRow.set("varitem", (Object)varObj);
                        rowChanged.addOne();
                        MemberView varValRecord = (MemberView)varValInfo.get(vId);
                        if (varValRecord == null || (member1 = modelCacheHelper.getMember(dimNum1, varValRecord.getViewId(), varValRecord.getMemberId())) == null) continue;
                        newRow.set("varvaltext", (Object)member1.getName());
                        newRow.set("varvalid", (Object)varValRecord.getMemberId());
                        newRow.set("varvalviewid", (Object)varValRecord.getViewId());
                    }
                }
            });
        }
        return rowChanged.getCount() > 0;
    }

    public Long getBaseYearVarId(Long modelId) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId).and("number", "=", (Object)"@BaseY");
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_periodvariable", (String)"id", (QFilter[])qFilter.toArray());
        if (obj != null) {
            return obj.getLong("id");
        }
        return 0L;
    }

    public Map<Long, RptSection> queryRptSection(Collection<Long> rptSectionIds) {
        DynamicObject[] load;
        HashMap<Long, RptSection> result = new HashMap<Long, RptSection>(16);
        if (CollectionUtils.isEmpty(rptSectionIds)) {
            return result;
        }
        for (DynamicObject obj : load = BusinessDataServiceHelper.load((Object[])rptSectionIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)VariableTypeEnum.RptSection.getMetadata()))) {
            RptSection rptSection = RptSection.of((DynamicObject)obj);
            if (rptSection == null) continue;
            result.put(rptSection.getId(), rptSection);
        }
        return result;
    }

    public List<Map<String, String>> parseToFrontNodes(String formulaString) {
        ArrayList<Map<String, String>> formulaNodeList = new ArrayList<Map<String, String>>(16);
        if (StringUtils.isEmpty((String)formulaString)) {
            return formulaNodeList;
        }
        char[] chars = formulaString.toCharArray();
        Character endRecordChar = null;
        StringBuilder recordString = new StringBuilder();
        String formulaType = null;
        for (char aChar : chars) {
            if (endRecordChar != null) {
                if (endRecordChar.charValue() == aChar) {
                    if ('[' == aChar) {
                        formulaType = recordString.toString();
                        endRecordChar = Character.valueOf(']');
                    } else {
                        endRecordChar = null;
                        if (recordString.length() != 0) {
                            Map nodeInfos = (Map)SerializationUtils.fromJsonString((String)recordString.toString(), HashMap.class);
                            formulaNodeList.add(this.createFormulaNode(nodeInfos, formulaType));
                            formulaType = null;
                        } else {
                            throw new KDBizException(ResManager.loadResFormat((String)"\u9519\u8bef\u7684\u7c7b\u578b\u53c2\u6570\uff1a\u7c7b\u578b %1 \u53c2\u6570 %2", (String)"DimensionCombinationEditNewPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[]{formulaType, recordString.toString()}));
                        }
                    }
                    recordString = new StringBuilder();
                    continue;
                }
                recordString.append(aChar);
                continue;
            }
            if ('@' == aChar) {
                if (recordString.length() != 0) {
                    formulaNodeList.add(this.createTextNode(recordString.toString()));
                    recordString = new StringBuilder();
                }
                endRecordChar = Character.valueOf('[');
                continue;
            }
            recordString.append(aChar);
        }
        if (recordString.length() != 0) {
            formulaNodeList.add(this.createTextNode(recordString.toString()));
        }
        return formulaNodeList;
    }

    private Map<String, String> createFormulaNode(Map<String, String> nodeInfos, String operate) {
        HashMap<String, String> formulaNodeMap = new HashMap<String, String>(16);
        formulaNodeMap.put("type", operate);
        formulaNodeMap.putAll(nodeInfos);
        return formulaNodeMap;
    }

    private Map<String, String> createTextNode(String text) {
        HashMap<String, String> textNodeMap = new HashMap<String, String>(16);
        textNodeMap.put("type", "text");
        textNodeMap.put("data", text);
        return textNodeMap;
    }

    public String parseToFormulaString(List<Map<String, String>> formulaNodes, StringBuilder formulaToShow, Pair<String, String> baseInfo) {
        if (formulaNodes.size() == 0) {
            return null;
        }
        StringBuilder formulaString = new StringBuilder();
        for (Map<String, String> formulaNode : formulaNodes) {
            String type;
            String data = formulaNode.get("data");
            if (data == null) {
                data = formulaNode.get("name");
            }
            if ("text".equals(type = formulaNode.get("type"))) {
                formulaString.append(data);
            } else {
                String id = formulaNode.get("id");
                FunOperationEnum funOperation = FunOperationEnum.getFunctionEnumByIndex((String)id);
                if (funOperation != null) {
                    formulaString.append("@function[");
                } else {
                    formulaString.append("@dimGroup[");
                }
                HashMap<String, String> dataMap = new HashMap<String, String>(16);
                dataMap.put("id", id);
                data = this.getUpdatedName(baseInfo, id, data);
                dataMap.put("name", data);
                formulaString.append(SerializationUtils.toJsonString(dataMap));
                formulaString.append("]");
            }
            if (formulaToShow == null) continue;
            formulaToShow.append(data);
        }
        return formulaString.toString();
    }

    private String getUpdatedName(Pair<String, String> baseInfo, String id, String data) {
        if (baseInfo == null) {
            return data;
        }
        String pkId = (String)baseInfo.p1;
        if (pkId.equals(id)) {
            return (String)baseInfo.p2;
        }
        return data;
    }

    public Map<String, String> getFileUrl(Set<String> tempIdsStr) {
        HashMap<String, String> result = new HashMap<String, String>(16);
        String selectFields = "ffileid,finterid";
        QFilter qf = new QFilter("finterid", "in", tempIdsStr);
        QFilter qf1 = new QFilter("fBillType", "=", (Object)"eb_analysereporttemplate");
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getFileUrl", (String)"bos_attachment", (String)selectFields, (QFilter[])new QFilter[]{qf, qf1}, null);){
            for (Row row : dataSet) {
                result.put(row.getString("finterid"), row.getString("ffileid"));
            }
        }
        return result;
    }

    public void openImportPage(IFormView formView, boolean isTemp, Long modelId, Long bizModelId, CloseCallBack closeCallBack) {
        String title = isTemp ? ResManager.loadKDString((String)"\u5206\u6790\u62a5\u544a\u6a21\u677f", (String)"AnalyseReportUtil_15", (String)"epm-eb-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5206\u6790\u62a5\u544a\u53d8\u91cf", (String)"AnalyseReportUtil_16", (String)"epm-eb-business", (Object[])new Object[0]);
        HashMap<String, Object> customParam = new HashMap<String, Object>(16);
        if (IDUtils.isNotEmptyLong((Long)modelId).booleanValue()) {
            customParam.put("modelId", modelId.toString());
        }
        if (IDUtils.isNotEmptyLong((Long)bizModelId).booleanValue()) {
            customParam.put("bizModelId", bizModelId.toString());
        }
        String cusPluginName = isTemp ? "kd.epm.eb.formplugin.analysereport.ARptTemplateImportPlugin" : "kd.epm.eb.formplugin.analysereport.ARptVarImportPlugin";
        BillImpExpUtils.openImportTempPage(formView, customParam, null, title, cusPluginName, closeCallBack);
    }

    public void openRptSectionForm4BgTemp(ITemplateModel templateModel, IFormView formView) {
        if (templateModel == null) {
            return;
        }
        Long modelId = templateModel.getModelId();
        int resultCode = FunPermissionHelper.checkItemPermission((long)UserUtils.getUserId(), (long)modelId, (String)formView.getFormShowParameter().getAppId(), (String)"eb_analyserptvariablelist", (String)"47156aff000000ac");
        if (resultCode == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u5206\u6790\u62a5\u544a\u53d8\u91cf\u5217\u8868\u7684\u65b0\u589e\u6743\u9650", (String)"AnalyseReportUtil_17", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        BgTemplate templateBaseInfo = templateModel.getTemplateBaseInfo();
        String dataChangMark = formView.getPageCache().get("isdatachanged");
        DynamicObject tempObj = QueryServiceHelper.queryOne((String)"eb_templateentity", (String)"templatestatus", (QFilter[])new QFilter("id", "=", (Object)templateBaseInfo.getId()).toArray());
        if (tempObj == null || StringUtils.isNotEmpty((String)dataChangMark) && "true".equals(dataChangMark)) {
            String status = tempObj != null && TemplateStatus.PUBLISH.getValue().equals(tempObj.getString("templatestatus")) ? ResManager.loadKDString((String)"\u53d1\u5e03", (String)"AnalyseReportUtil_19", (String)"epm-eb-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"AnalyseReportUtil_20", (String)"epm-eb-business", (Object[])new Object[0]);
            formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148%s\u6a21\u677f", (String)"AnalyseReportUtil_18", (String)"epm-eb-business", (Object[])new Object[]{status}));
            return;
        }
        BaseShowParameter formShowParameter = this.getRptSectionForm(formView, templateBaseInfo.getModelID(), templateBaseInfo.getBizModel(), null);
        formShowParameter.setCustomParam("pageViewInfo", (Object)SerializationUtils.serializeToBase64((Object)templateModel.getPagemembentry()));
        formShowParameter.setCustomParam("dimViewMap", (Object)SerializationUtils.serializeToBase64((Object)templateModel.getDimemsionViews()));
        formShowParameter.setCustomParam("templateId", (Object)templateBaseInfo.getId());
        formView.showForm((FormShowParameter)formShowParameter);
    }

    public BaseShowParameter getRptSectionForm(IFormView currentView, Long modelI, Long bizModelId, String formId) {
        if (formId == null) {
            formId = VariableTypeEnum.RptSection.getMetadata();
        }
        HashMap<String, String> openParameter = new HashMap<String, String>(16);
        openParameter.put("formId", formId);
        FormShowParameter formShowParameter = FormShowParameter.createFormShowParameter(openParameter);
        formShowParameter.setFormId(formId);
        formShowParameter.setParentPageId(currentView.getPageId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("modelId", (Object)modelI);
        formShowParameter.setCustomParam("bizModelId", (Object)bizModelId);
        return (BaseShowParameter)formShowParameter;
    }

    public void upRptSection4TempChange(ITemplateModel templateModel) {
        Long tempId = templateModel.getTemplateBaseInfo().getId();
        Long modelId = templateModel.getModelId();
        Map<String, IPageDimensionEntry> pageMemberEntry = templateModel.getPagemembentry().stream().collect(Collectors.toMap(dim1 -> dim1.getDimension().getNumber(), dim2 -> dim2));
        DynamicObject[] sectionObjs = BusinessDataServiceHelper.load((String)VariableTypeEnum.RptSection.getMetadata(), (String)"model,bizmodel,number,memberentry.dimension,memberentry.dimview,memberentry.member,memberentry.dimmembertype,orderentry.dimension1,orderentry.dimview1,orderentry.member1,orderentry.dimmembertype1,refparamdimnums,reffunctiondimnums", (QFilter[])new QFilter("template", "=", (Object)tempId).toArray());
        if (sectionObjs.length > 0) {
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
            LinkedList<DynamicObject> toUpObjs = new LinkedList<DynamicObject>();
            LinkedList<MemberQuoteDao> quotes = new LinkedList<MemberQuoteDao>();
            for (DynamicObject object : sectionObjs) {
                Counter counter = new Counter();
                DynamicObjectCollection memberEntry = object.getDynamicObjectCollection("memberentry");
                Iterator iterator = memberEntry.iterator();
                HashSet<String> dimNums = new HashSet<String>(memberEntry.size());
                while (iterator.hasNext()) {
                    DynamicObject row = (DynamicObject)iterator.next();
                    String dimNum2 = row.getString("dimension.number");
                    if (!pageMemberEntry.containsKey(dimNum2)) {
                        iterator.remove();
                        counter.addOne();
                        continue;
                    }
                    dimNums.add(dimNum2);
                }
                pageMemberEntry.forEach((dimNum, entry) -> {
                    if (!dimNums.contains(dimNum)) {
                        DynamicObject memberRow = memberEntry.addNew();
                        Dimension dimension = modelCacheHelper.getDimension(dimNum);
                        DynamicObject dimObj = BusinessDataServiceHelper.newDynamicObject((String)"epm_dimension");
                        dimObj.set("id", (Object)dimension.getId());
                        dimObj.set("number", (Object)dimension.getNumber());
                        memberRow.set("dimension", (Object)dimObj);
                        memberRow.set("memberclasstype", (Object)dimension.getMemberModel());
                        memberRow.set("dimmembertype", (Object)DimMemberTypeEnum.PARAM.getIndex());
                        counter.addOne();
                    }
                });
                if (counter.getSize() <= 0) continue;
                this.selRptSectionRefDimInfo(object, quotes);
                toUpObjs.add(object);
            }
            if (toUpObjs.size() > 0) {
                try (TXHandle tx = TX.required((String)"saveRptSection4TempChange");){
                    try {
                        SaveServiceHelper.save((DynamicObject[])toUpObjs.toArray(new DynamicObject[1]));
                        DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"save", (Object[])new Object[]{quotes});
                    }
                    catch (Exception ex) {
                        tx.markRollback();
                        log.error("saveRptSection4TempChange: \n" + ex);
                        throw new KDBizException(ex.getMessage());
                    }
                }
            }
        }
    }

    public void selRptSectionRefDimInfo(DynamicObject object, List<MemberQuoteDao> quotes) {
        Long modelId = object.getLong("model.id");
        Long bizModelId = object.getLong("bizmodel.id");
        Long id = object.getLong("id");
        RefDimColInfo refDimColInfo = new RefDimColInfo();
        this.selMemberEntryQ(modelId, true, object.getDynamicObjectCollection("memberentry"), MemberQuoteResourceEnum.RPTSECTION, quotes, refDimColInfo, 0L, id);
        this.selMemberEntryQ(modelId, false, object.getDynamicObjectCollection("orderentry"), MemberQuoteResourceEnum.RPTSECTION, quotes, refDimColInfo, 0L, id);
        RefDimStrInfo refDimStrInfo = this.getRefDimNumsStr(refDimColInfo, modelId, bizModelId);
        object.set("refparamdimnums", (Object)refDimStrInfo.getRefParamDims());
        object.set("reffunctiondimnums", (Object)refDimStrInfo.getRefFunctionDims());
    }

    public void selMemberEntryQ(Long modelId, boolean isMemberEntry, DynamicObjectCollection entryRows, MemberQuoteResourceEnum resourceEnum, List<MemberQuoteDao> quotes, RefDimColInfo refDimColInfo, Long datasetId, Long objId) {
        String dimKey = isMemberEntry ? "dimension" : "dimension1";
        String dimViewKey = isMemberEntry ? "dimview" : "dimview1";
        String memberTypeKey = isMemberEntry ? "memberclasstype" : "memberclasstype1";
        String memberKey = isMemberEntry ? "member" : "member1";
        String dimTypeKey = isMemberEntry ? "dimmembertype" : "dimmembertype1";
        String dimIdKey = dimKey + ".id";
        String dimNumKey = dimKey + ".number";
        String memberIdKey = memberKey + ".id";
        for (DynamicObject memberEntry : entryRows) {
            String dimMemberType = memberEntry.getString(dimTypeKey);
            String dimNum = memberEntry.getString(dimNumKey);
            DynamicObject dimView = memberEntry.getDynamicObject(dimViewKey);
            if (DimMemberTypeEnum.FUNCTION.getIndex().equals(dimMemberType)) {
                refDimColInfo.getRefFunctionDims().add(dimNum);
                continue;
            }
            Long dimensionId = memberEntry.getLong(dimIdKey);
            if (DimMemberTypeEnum.PARAM.getIndex().equals(dimMemberType)) {
                refDimColInfo.getRefParamDims().add(dimNum);
                DynamicObject param = memberEntry.getDynamicObject(memberKey);
                if (!SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNum) || param == null) continue;
                quotes.add(new MemberQuoteDao(modelId, Long.valueOf(0L), Long.valueOf(0L), Long.valueOf(param.getLong("id")), MemberTypeEnum.DIMENSIONPARAM, resourceEnum, objId));
                continue;
            }
            Long memberId = memberEntry.getLong(memberIdKey);
            String type = memberEntry.getString(memberTypeKey);
            if ("eb_periodvariable".equals(type)) {
                quotes.add(new MemberQuoteDao(modelId, datasetId, dimensionId, memberId, MemberTypeEnum.VARIABLE, resourceEnum, objId));
            } else {
                quotes.add(new MemberQuoteDao(modelId, datasetId, dimensionId, memberId, resourceEnum, objId));
            }
            if (dimView == null) continue;
            long dimViewId = dimView.getLong("id");
            quotes.add(new MemberQuoteDao(modelId, Long.valueOf(0L), dimensionId, Long.valueOf(dimViewId), MemberTypeEnum.VIEW, resourceEnum, objId));
        }
    }

    public Map<String, Integer> getAllParamOffset(Long modelId, Long bizModelId) {
        HashMap<String, Integer> result = new HashMap<String, Integer>(16);
        QFBuilder qb = new QFBuilder("model", "=", (Object)modelId);
        qb.add("bizmodel", "=", (Object)bizModelId);
        qb.add("dimension.number", "=", (Object)SysDimensionEnum.BudgetPeriod.getNumber());
        QueryServiceHelper.query((String)VariableTypeEnum.Parameter.getMetadata(), (String)"offset,number", (QFilter[])qb.toArrays()).forEach(obj -> {
            String offsetStr = obj.getString("offset");
            int offset = StringUtils.isEmpty((String)offsetStr) ? 0 : Integer.parseInt(offsetStr);
            result.put(obj.getString("number"), offset);
        });
        return result;
    }
}

