/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analyzeReport.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.analysereport.constants.FieldTypeEnum;
import kd.epm.eb.common.analysereport.pojo.functions.steps.MemberFilter;
import kd.epm.eb.common.analysereport.pojo.functions.steps.MemberInfo;
import kd.epm.eb.common.analysereport.pojo.functions.steps.MemberRange;
import kd.epm.eb.common.analysereport.pojo.functions.steps.ShowLayout;
import kd.epm.eb.common.analysereport.pojo.functions.steps.StepDataContainer;
import kd.epm.eb.common.analysereport.pojo.quote.VarQuoteInfo;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;

public class AnalyseRptFuncUtil {
    public static Map<String, Set<String>> parseMembRange2Set(MemberFilter memberFilter, IModelCacheHelper modelCacheHelper) {
        HashMap<String, Set<String>> membNums = new HashMap<String, Set<String>>(16);
        AnalyseRptFuncUtil.parseMemberRange(memberFilter, modelCacheHelper, dimNum -> membNums.computeIfAbsent((String)dimNum, key -> new HashSet(16)));
        return membNums;
    }

    public static Map<String, List<String>> parseMembRange2List(MemberFilter memberFilter, IModelCacheHelper modelCacheHelper) {
        LinkedHashMap<String, List<String>> membNums = new LinkedHashMap<String, List<String>>(16);
        AnalyseRptFuncUtil.parseMemberRange(memberFilter, modelCacheHelper, dimNum -> membNums.computeIfAbsent((String)dimNum, key -> new ArrayList(16)));
        return membNums;
    }

    public static void parseMemberRange(MemberFilter memberFilter, IModelCacheHelper modelCacheHelper, Function<String, Collection<String>> listConsumer) {
        if (memberFilter != null) {
            List memberRanges = memberFilter.getMemberRanges();
            for (MemberRange memberRange : memberRanges) {
                Long viewId = memberRange.getViewId();
                for (MemberInfo memberInfo : memberRange.getMemberInfoList()) {
                    List members = modelCacheHelper.getMember(memberRange.getDimNum(), viewId, memberInfo.getMembNum(), Integer.parseInt(memberInfo.getRangeVal()), memberInfo.getChildLevel());
                    if (members.size() <= 0) continue;
                    Collection<String> membNums = listConsumer.apply(memberRange.getDimNum());
                    members.forEach(member -> membNums.add(member.getNumber()));
                }
            }
        }
    }

    public static String getShowFieldName(String fieldType, String showField, IModelCacheHelper modelCacheHelper) {
        DynamicObject obj;
        String fieldName = null;
        if (FieldTypeEnum.DIMMENSION.getValue().equals(fieldType)) {
            Dimension dimension = modelCacheHelper.getDimension(showField);
            if (dimension != null) {
                fieldName = dimension.getName();
            }
        } else if (FieldTypeEnum.DIMGROUP.getValue().equals(fieldType)) {
            DynamicObject obj2 = BusinessDataServiceHelper.loadSingleFromCache((Object)IDUtils.toLong((Object)showField), (String)"eb_dimcombinationentity");
            if (obj2 != null) {
                fieldName = obj2.getString("name");
            }
        } else if (FieldTypeEnum.CONDITION.getValue().equals(fieldType) && (obj = BusinessDataServiceHelper.loadSingleFromCache((Object)IDUtils.toLong((Object)showField), (String)"eb_judgecondition")) != null) {
            fieldName = obj.getString("name");
        }
        return fieldName;
    }

    public static Set<String> getDimNumsOnFuncDimGroup(Long bizModelId) {
        HashSet<String> result = new HashSet<String>(16);
        QFilter qBizModel = new QFilter("bizmodel", "=", (Object)bizModelId);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getDimNumsOnFuncDimGroup", (String)"eb_dimcombinationentity", (String)"reffunctiondimnums", (QFilter[])qBizModel.toArray(), null);){
            for (Row row : dataSet) {
                String reffunctiondimnums = row.getString("reffunctiondimnums");
                if (!StringUtils.isNotEmpty((String)reffunctiondimnums)) continue;
                for (String dimNum : reffunctiondimnums.split(",")) {
                    result.add(dimNum);
                }
            }
        }
        return result;
    }

    public static VarQuoteInfo selQuoteInfo(Long modelId, StepDataContainer allStepData, List<MemberQuoteDao> memberQuoteList, Long functionId) {
        VarQuoteInfo quoteInfo = new VarQuoteInfo();
        quoteInfo.setModelId(modelId);
        allStepData.getStepData().values().forEach(stepData -> stepData.selectQuote(quoteInfo));
        quoteInfo.getRefMemberIds().forEach((dimId, memberIds) -> memberQuoteList.add(new MemberQuoteDao(modelId, Long.valueOf(0L), dimId, (Collection)memberIds, MemberTypeEnum.MEMBER, MemberQuoteResourceEnum.RptFunction, functionId)));
        quoteInfo.getRefViewIs().forEach((dimId, viewIds) -> memberQuoteList.add(new MemberQuoteDao(modelId, Long.valueOf(0L), dimId, (Collection)viewIds, MemberTypeEnum.VIEW, MemberQuoteResourceEnum.RptFunction, functionId)));
        memberQuoteList.add(new MemberQuoteDao(modelId, Long.valueOf(0L), Long.valueOf(0L), (Collection)quoteInfo.getRefConditionIds(), MemberTypeEnum.JUDGECONDITION, MemberQuoteResourceEnum.RptFunction, functionId));
        memberQuoteList.add(new MemberQuoteDao(modelId, Long.valueOf(0L), Long.valueOf(0L), (Collection)quoteInfo.getRefDimGroupIds(), MemberTypeEnum.DIMGROUP, MemberQuoteResourceEnum.RptFunction, functionId));
        return quoteInfo;
    }

    public static String buildShowField(ShowLayout showLayout, IModelCacheHelper modelCacheHelper) {
        StringBuilder sb = new StringBuilder();
        showLayout.getFieldLayoutList().forEach(fieldLayout -> {
            String fieldName = AnalyseRptFuncUtil.getShowFieldName(fieldLayout.getFieldType(), fieldLayout.getShowField(), modelCacheHelper);
            sb.append(fieldName == null ? Character.valueOf(' ') : fieldName).append('@');
        });
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }
}

