/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analyzeReport.service;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.WebOffice;
import kd.bos.form.control.model.WebOfficeMark;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.util.FileNameUtils;
import kd.epm.eb.business.analyzeReport.service.AnalyseReportUtil;
import kd.epm.eb.business.analyzeReport.service.AnalyseRptVarExecUtil;
import kd.epm.eb.business.analyzeReport.service.AnalyzeRptWebOfficeCommon;
import kd.epm.eb.business.word.TableConvert;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.analysereport.AnalyseWebOfficeVarEntity;
import kd.epm.eb.common.analysereport.constants.VariableTypeEnum;
import kd.epm.eb.common.analysereport.pojo.AnalyseRptEntity;
import kd.epm.eb.common.analysereport.pojo.MemberView;
import kd.epm.eb.common.analysereport.pojo.VarParams;
import kd.epm.eb.common.analysereport.pojo.VarValues;
import kd.epm.eb.common.analysereport.pojo.formula.DimGroupResult;
import kd.epm.eb.common.analysereport.pojo.functions.FunctionResult;
import kd.epm.eb.common.analysereport.pojo.functions.FunctionStrResult;
import kd.epm.eb.common.analysereport.pojo.functions.FunctionTableResult;
import kd.epm.eb.common.analysereport.pojo.quote.RefDimColInfo;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.pojo.BasedataPojo;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.Counter;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.LogSignHelper;
import kd.epm.eb.common.utils.UploadUtil;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.common.var.ReportVarUtil;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xwpf.usermodel.XWPFDocument;

public class AnalyseRptGenUtil {
    private static final Log log = LogFactory.getLog(AnalyseRptGenUtil.class);

    public static AnalyseRptGenUtil getInstance() {
        return InnerClass.instance;
    }

    private AnalyseRptGenUtil() {
    }

    public Collection<DynamicObject> getSaveDataTmpBase(AnalyseRptEntity rptTemp, String dimJson) {
        ArrayList<DynamicObject> needSaveRpts = new ArrayList<DynamicObject>(16);
        if (QueryServiceHelper.exists((String)"eb_analysereport", (Object)rptTemp.getFileId())) {
            DynamicObject load = BusinessDataServiceHelper.loadSingle((Object)rptTemp.getFileId(), (String)"eb_analysereport");
            Map rptName = (Map)JSONUtils.parse((String)rptTemp.getRptName(), HashMap.class);
            LocaleString langName = new LocaleString();
            for (Map.Entry entry : rptName.entrySet()) {
                langName.setItem((String)entry.getKey(), entry.getValue());
            }
            load.set("name", (Object)langName);
            load.set("modifier", (Object)UserUtils.getUserId());
            load.set("modifydate", (Object)TimeServiceHelper.now());
            load.set("dimsjson", (Object)dimJson);
            needSaveRpts.add(load);
        } else {
            DynamicObject varObj = BusinessDataServiceHelper.newDynamicObject((String)"eb_analysereport");
            varObj.set("id", (Object)rptTemp.getFileId());
            varObj.set("number", (Object)rptTemp.getRptNumber());
            Map rptName = (Map)JSONUtils.parse((String)rptTemp.getRptName(), HashMap.class);
            LocaleString langName = new LocaleString();
            for (Map.Entry entry : rptName.entrySet()) {
                langName.setItem((String)entry.getKey(), entry.getValue());
            }
            varObj.set("name", (Object)langName);
            varObj.set("model", (Object)rptTemp.getRptTemp().getModelid());
            varObj.set("rpttemp", (Object)rptTemp.getRptTemp().getId());
            varObj.set("dimsjson", (Object)dimJson);
            varObj.set("creater", (Object)UserUtils.getUserId());
            varObj.set("createdate", (Object)this.getCurrentTime());
            varObj.set("modifier", (Object)UserUtils.getUserId());
            varObj.set("modifydate", (Object)this.getCurrentTime());
            DynamicObjectCollection varEntryRows = varObj.getDynamicObjectCollection("varentryentity");
            AnalyseReportUtil.getInstance().buildVarEntryRows(rptTemp.getMemberVarInfo(), varEntryRows, ModelCacheContext.getOrCreate((Long)rptTemp.getModelId()));
            needSaveRpts.add(varObj);
        }
        return needSaveRpts;
    }

    private Date getCurrentTime() {
        return Convert.toDate((Object)System.currentTimeMillis());
    }

    public Set<String> getVarDims(AnalyseRptEntity rptTemp, AbstractFormPlugin plugin) {
        HashSet<String> returns = new HashSet(16);
        Collection<AnalyseWebOfficeVarEntity> varIds = this.getVarIds(rptTemp.getRptTemp().getId(), plugin);
        returns = this.getDimFromVars(varIds, plugin);
        return returns;
    }

    private Set<String> getDimFromVars(Collection<AnalyseWebOfficeVarEntity> refVarInfo, AbstractFormPlugin plugin) {
        HashSet<String> refParamDimNums = new HashSet<String>(16);
        if (refVarInfo == null || refVarInfo.size() == 0) {
            return refParamDimNums;
        }
        this.selDimFromDimComb(refVarInfo, refParamDimNums);
        this.getDimFromConds(refVarInfo, refParamDimNums);
        this.selDimFromDimParas(refVarInfo, refParamDimNums);
        this.selDimFromFunction(refVarInfo, refParamDimNums);
        this.getRptSectionRefParamDim(refVarInfo, refParamDimNums);
        plugin.getPageCache().put("varSelInfos", SerializationUtils.serializeToBase64(refVarInfo));
        return refParamDimNums;
    }

    private void getRptSectionRefParamDim(Collection<AnalyseWebOfficeVarEntity> refVarInfo, Set<String> refDimNumbers) {
        HashMap sectionMap = new HashMap(16);
        refVarInfo.forEach(varEntity -> {
            if (VariableTypeEnum.RptSection.getNumber().equals(varEntity.getVarType())) {
                sectionMap.computeIfAbsent(varEntity.getId(), key -> new ArrayList()).add(varEntity);
            }
        });
        if (sectionMap.isEmpty()) {
            return;
        }
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)VariableTypeEnum.RptSection.getMetadata(), (String)"id,refparamdimnums,number,name", (QFilter[])new QFilter("id", "in", sectionMap.keySet()).toArray());
        dynamicObjects.forEach(obj -> {
            List varEntityList = (List)sectionMap.get(obj.getLong("id"));
            if (varEntityList != null) {
                String name = obj.getString("name");
                String number = obj.getString("number");
                varEntityList.forEach(varEntity -> {
                    varEntity.setNumber(number);
                    varEntity.setName(name);
                });
            }
            for (String dimNum : obj.getString("refparamdimnums").split(",")) {
                if (!StringUtils.isNotEmpty((CharSequence)dimNum)) continue;
                refDimNumbers.add(dimNum);
            }
        });
    }

    private void matchVarFromVarObj(Collection<AnalyseWebOfficeVarEntity> varEntities, String varType, Consumer<AnalyseWebOfficeVarEntity> varEntityConsumer) {
        if (varEntities == null) {
            return;
        }
        for (AnalyseWebOfficeVarEntity obj : varEntities) {
            if (!varType.equalsIgnoreCase(obj.getVarType())) continue;
            varEntityConsumer.accept(obj);
        }
    }

    private Set<Long> getVarIdsFromVarObj(Collection<AnalyseWebOfficeVarEntity> varEntities, String varType) {
        HashSet<Long> returns = new HashSet<Long>(16);
        this.matchVarFromVarObj(varEntities, varType, varEntity -> returns.add(varEntity.getId()));
        return returns;
    }

    private void getDimFromConds(Collection<AnalyseWebOfficeVarEntity> varIds, Set<String> refParamDimNums) {
        Set<Long> dimConds = this.getVarIdsFromVarObj(varIds, VariableTypeEnum.Condition.getNumber());
        if (CollectionUtils.isEmpty(dimConds)) {
            return;
        }
        QFilter filter = new QFilter("id", "in", dimConds);
        String selectFields = "id,number,name,refparamdimnums";
        AnalyseReportUtil reportUtil = AnalyseReportUtil.getInstance();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"eb_judgecondition", (String)selectFields, (QFilter[])new QFilter[]{filter}, null);){
            while (ds.hasNext()) {
                Row row = ds.next();
                refParamDimNums.addAll(reportUtil.parserRefDimNums(row.getString("refparamdimnums")));
                for (AnalyseWebOfficeVarEntity obj : varIds) {
                    if (row.getLong("id").compareTo(obj.getId()) != 0) continue;
                    obj.setNumber(row.getString("number"));
                    obj.setName(row.getString("name"));
                }
            }
        }
    }

    private void selDimFromDimComb(Collection<AnalyseWebOfficeVarEntity> refVarInfo, Set<String> refParamDimNums) {
        Set<Long> dimCombs = this.getVarIdsFromVarObj(refVarInfo, VariableTypeEnum.Combination.getNumber());
        if (CollectionUtils.isEmpty(dimCombs)) {
            return;
        }
        QFilter filter = new QFilter("id", "in", dimCombs);
        String selectFields = "number,name,id,refparamdimnums";
        AnalyseReportUtil reportUtil = AnalyseReportUtil.getInstance();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"eb_dimcombinationentity", (String)selectFields, (QFilter[])new QFilter[]{filter}, null);){
            while (ds.hasNext()) {
                Row row = ds.next();
                refParamDimNums.addAll(reportUtil.parserRefDimNums(row.getString("refparamdimnums")));
                for (AnalyseWebOfficeVarEntity obj : refVarInfo) {
                    if (row.getLong("id").compareTo(obj.getId()) != 0) continue;
                    obj.setNumber(row.getString("number"));
                    obj.setName(row.getString("name"));
                }
            }
        }
    }

    private void selDimFromDimParas(Collection<AnalyseWebOfficeVarEntity> varIds, Set<String> refParamDimNums) {
        Set<Long> dimParas = this.getVarIdsFromVarObj(varIds, VariableTypeEnum.Parameter.getNumber());
        if (CollectionUtils.isEmpty(dimParas)) {
            return;
        }
        QFilter filter = new QFilter("id", "in", dimParas);
        String selectFields = "dimension.number,id,number,name";
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"eb_dimensionparameter", (String)selectFields, (QFilter[])new QFilter[]{filter}, null);){
            while (ds.hasNext()) {
                Row row = ds.next();
                refParamDimNums.add(row.getString("dimension.number"));
                for (AnalyseWebOfficeVarEntity obj : varIds) {
                    if (row.getLong("id").compareTo(obj.getId()) != 0) continue;
                    obj.setNumber(row.getString("number"));
                    obj.setName(row.getString("name"));
                }
            }
        }
    }

    private void selDimFromFunction(Collection<AnalyseWebOfficeVarEntity> varIds, Set<String> refParamDimNums) {
        Set<Long> functionIds = this.getVarIdsFromVarObj(varIds, VariableTypeEnum.Function.getNumber());
        if (CollectionUtils.isEmpty(functionIds)) {
            return;
        }
        RefDimColInfo refDimColInfo = new RefDimColInfo();
        HashMap<Long, Pair<String, String>> numNameSel = new HashMap<Long, Pair<String, String>>(functionIds.size());
        AnalyseReportUtil.getInstance().selRefDimNums(refDimColInfo, functionIds, VariableTypeEnum.Function.getMetadata(), numNameSel);
        varIds.forEach(entity -> {
            Pair numName = (Pair)numNameSel.get(entity.getId());
            if (numName != null) {
                entity.setNumber((String)numName.p1);
                entity.setName((String)numName.p2);
            }
        });
        refParamDimNums.addAll(refDimColInfo.getRefParamDims());
    }

    private Collection<AnalyseWebOfficeVarEntity> getVarIds(Long tmpId, AbstractFormPlugin plugin) {
        ArrayList<AnalyseWebOfficeVarEntity> returns = new ArrayList<AnalyseWebOfficeVarEntity>(16);
        String sql = "select fvartype,fvarid,fvarkey from t_eb_analysevarsel where frpttempid = ?";
        try (DataSet ds = DB.queryDataSet((String)"getVarIds", (DBRoute)new DBRoute("epm"), (String)sql, (Object[])new Object[]{tmpId});){
            while (ds.hasNext()) {
                Row row = ds.next();
                AnalyseWebOfficeVarEntity obj = new AnalyseWebOfficeVarEntity();
                obj.setId(row.getLong("fvarid"));
                obj.setVarKey(row.getString("fvarkey"));
                obj.setVarType(row.getString("fvartype"));
                returns.add(obj);
            }
        }
        return returns;
    }

    private VarValues execRptVar(String wordFieldUrl, Collection<AnalyseWebOfficeVarEntity> varInfos, Map<String, MemberView> varDimValues, Long modelId, Long bizModelId, Map<String, MemberView> memberVarInfoMap) {
        VarValues values = null;
        HashMap varDimNumber = new HashMap(varDimValues.size());
        varDimValues.forEach((dimkey, valueNumber) -> varDimNumber.put(dimkey, new MemberView(this.getNumber(valueNumber.getMemberNumber()), valueNumber.getViewId())));
        if (varInfos == null || varInfos.size() == 0) {
            return values;
        }
        Set<Long> conditionsId = this.getVarIdsFromVarObj(varInfos, VariableTypeEnum.Condition.getNumber());
        Set<Long> dimGroupsId = this.getVarIdsFromVarObj(varInfos, VariableTypeEnum.Combination.getNumber());
        Set<Long> paramsId = this.getVarIdsFromVarObj(varInfos, VariableTypeEnum.Parameter.getNumber());
        Set<Long> functionsId = this.getVarIdsFromVarObj(varInfos, VariableTypeEnum.Function.getNumber());
        Set<Long> rptSectionsId = this.getVarIdsFromVarObj(varInfos, VariableTypeEnum.RptSection.getNumber());
        VarParams varParams = new VarParams();
        varParams.setParamIds(paramsId);
        varParams.setFunctionIds(functionsId);
        varParams.setConditionIds(conditionsId);
        varParams.setDimMemberGroupIds(dimGroupsId);
        varParams.setModelId(modelId);
        varParams.setBizModelId(bizModelId);
        varParams.setPageDimMembers(varDimNumber);
        varParams.setWordFieldUrl(wordFieldUrl);
        varParams.setRptSectionIds(rptSectionsId);
        varParams.setMemberVarInfoMap(memberVarInfoMap);
        values = AnalyseRptVarExecUtil.executeVars(varParams);
        return values;
    }

    private String getNumber(String str) {
        if (str.contains("!")) {
            return str.split("!")[0];
        }
        return str;
    }

    public void replaceVar(String wordUrl, List<String> errorInfo, Set<String> bookmarks, AnalyseRptEntity templateData, Collection<AnalyseWebOfficeVarEntity> varInfos, Map<String, MemberView> paramDimValues, Map<String, MemberView> dimMemberVarValInfo, WebOffice webOffice) {
        if (null == bookmarks || bookmarks.isEmpty() || varInfos == null || paramDimValues == null) {
            return;
        }
        VarValues varValues = this.execRptVar(wordUrl, varInfos, paramDimValues, templateData.getModelId(), templateData.getRptTemp().getBizModelid(), dimMemberVarValInfo);
        this.upVarVal2Word(wordUrl, errorInfo, varInfos, bookmarks, webOffice, varValues, templateData);
        if (varValues != null) {
            errorInfo.addAll(varValues.getErrorInfo());
            this.logVarReplaceInfo(varInfos, bookmarks, varValues, templateData);
        }
    }

    public String checkMemberVarValInfo(Long modelId, Map<String, MemberView> membVarValInfo, Map<Long, Set<Long>> dimGroupVarInfos) {
        String errorInfo = null;
        if (!dimGroupVarInfos.isEmpty()) {
            StringBuilder noValVarNames = new StringBuilder();
            HashSet allVarIds = new HashSet();
            dimGroupVarInfos.values().forEach(allVarIds::addAll);
            HashMap<Long, BasedataPojo> varObjs = new HashMap<Long, BasedataPojo>(allVarIds.size());
            for (DynamicObject obj : BusinessDataServiceHelper.load((String)"eb_periodvariable", (String)"id,number,name,grouptype", (QFilter[])new QFilter("id", "in", allVarIds).toArray())) {
                varObjs.put(obj.getLong("id"), new BasedataPojo(Long.valueOf(obj.getLong("id")), obj.getString("name"), obj.getString("number")));
            }
            MemberView baseYearVal = membVarValInfo.get("@BaseY");
            HashMap<String, String> varMap = new HashMap<String, String>(1);
            if (baseYearVal != null) {
                varMap.put("BaseY!BaseY", baseYearVal.getMemberNumber());
            }
            dimGroupVarInfos.values().forEach(varIds -> varIds.forEach(varId -> {
                BasedataPojo varObj = (BasedataPojo)varObjs.get(varId);
                if (varObj != null && !membVarValInfo.containsKey(varObj.getNumber())) {
                    if (varMap.size() > 0 && AnalyseRptGenUtil.getInstance().isOffsetYearVar(varObj.getNumber())) {
                        String varVal = ReportVarUtil.getVarValueNoError((Long)modelId, (String)varObj.getNumber(), (Map)varMap, (String)SysDimensionEnum.BudgetPeriod.getNumber());
                        if (varVal != null) {
                            membVarValInfo.put(varObj.getNumber(), new MemberView(varVal, null));
                        } else {
                            noValVarNames.append(varObj.getName()).append(',');
                        }
                    } else {
                        noValVarNames.append(varObj.getName()).append(',');
                    }
                }
            }));
            if (noValVarNames.length() > 0) {
                noValVarNames.setLength(noValVarNames.length() - 1);
                errorInfo = ResManager.loadResFormat((String)"\u53d8\u91cf\u201c%1\u201d\u672a\u8d4b\u503c\u3002", (String)"AnalyseRptGenUtil_3", (String)"epm-eb-formplugin", (Object[])new Object[]{noValVarNames.toString()});
            }
        }
        return errorInfo;
    }

    private void logVarReplaceInfo(Collection<AnalyseWebOfficeVarEntity> varInfos, Collection<String> bookmarks, VarValues varValues, AnalyseRptEntity templateData) {
        Set signs = LogSignHelper.getLogSignByGropNum((String)"AnalyseRptReplaceVar");
        if (signs.contains("VarReplaceInfo")) {
            CommonServiceHelper.handleLog((Log)log, (String)"VarReplace-varInfos", (String)SerializationUtils.toJsonString(varInfos));
            CommonServiceHelper.handleLog((Log)log, (String)"VarReplace-bookmarks", (String)SerializationUtils.toJsonString(bookmarks));
            CommonServiceHelper.handleLog((Log)log, (String)"VarReplace-varValues-rptSectionSize", (String)SerializationUtils.toJsonString(varValues.getRptSectionsData().keySet()));
            varValues.getRptSectionsData().clear();
            CommonServiceHelper.handleLog((Log)log, (String)"VarReplace-varValues", (String)SerializationUtils.toJsonString((Object)varValues));
            CommonServiceHelper.handleLog((Log)log, (String)"VarReplace-templateData", (String)SerializationUtils.toJsonString((Object)templateData));
        }
    }

    private void upVarVal2Word(String wordFieldUrl, List<String> errInfo, Collection<AnalyseWebOfficeVarEntity> varInfos, Set<String> bookmarks, WebOffice webOffice, VarValues varValues, AnalyseRptEntity templateData) {
        if (varValues == null || varInfos == null || webOffice == null) {
            return;
        }
        this.doLog(" doReplace.bookmarks:" + bookmarks.toString());
        Map<String, AnalyseWebOfficeVarEntity> varEntityMap = varInfos.stream().filter(var -> var.getVarKey() != null).collect(Collectors.toMap(AnalyseWebOfficeVarEntity::getVarKey, obj1 -> obj1));
        ArrayList<WebOfficeMark> marks = new ArrayList<WebOfficeMark>(16);
        HashMap<String, String[][]> tablesData = new HashMap<String, String[][]>(16);
        String rptNumber = templateData.getRptNumber();
        for (String mark : bookmarks) {
            if (StringUtils.isEmpty((CharSequence)mark)) {
                this.doLog(" doReplace mark skip is null:" + mark);
                continue;
            }
            AnalyseWebOfficeVarEntity obj = varEntityMap.get(mark);
            if (!this.checkVarExist(obj, mark, errInfo, rptNumber)) {
                this.addErrorVarInfo(mark, marks);
                continue;
            }
            String varType = obj.getVarType();
            VariableTypeEnum variableTypeEnum = VariableTypeEnum.getVariableTypeByNumber((String)varType);
            switch (variableTypeEnum) {
                case Function: {
                    this.doReplaceFunction(varValues, obj, mark, errInfo, rptNumber, marks, tablesData);
                    break;
                }
                case Condition: {
                    this.doReplaceCondition(varValues, obj, mark, errInfo, rptNumber, marks);
                    break;
                }
                case Combination: {
                    this.doReplaceDimGroup(varValues, obj, mark, errInfo, rptNumber, marks);
                    break;
                }
                case Parameter: {
                    this.doReplaceDimParam(varValues, obj, mark, errInfo, rptNumber, marks);
                    break;
                }
            }
        }
        String newFieldUrl = this.doReplaceRptSection(bookmarks, varValues.getRptSectionsData(), wordFieldUrl, templateData, varInfos);
        if (newFieldUrl != null) {
            webOffice.open(newFieldUrl);
        }
        if (tablesData.size() > 0) {
            tablesData.forEach((arg_0, arg_1) -> ((WebOffice)webOffice).addTable(arg_0, arg_1));
        }
        if (!marks.isEmpty()) {
            webOffice.modifyMarks(marks);
        }
    }

    private String doReplaceRptSection(Set<String> bookmarks, Map<Long, Sheet> allSheet, String wordFieldUrl, AnalyseRptEntity rptData, Collection<AnalyseWebOfficeVarEntity> varInfos) {
        String result = null;
        HashMap<String, Sheet> markKeyTableMap = new HashMap<String, Sheet>(allSheet.size());
        HashMap<String, String> markKeyNameMap = new HashMap<String, String>(16);
        Counter counter = new Counter();
        this.matchVarFromVarObj(varInfos, VariableTypeEnum.RptSection.getNumber(), varEntity -> {
            if (bookmarks.contains(varEntity.getVarKey())) {
                markKeyNameMap.put(varEntity.getVarKey(), "@" + varEntity.getName() + "@");
                Sheet sheet = (Sheet)allSheet.get(varEntity.getId());
                if (sheet != null) {
                    markKeyTableMap.put(varEntity.getVarKey(), sheet);
                }
                counter.addOne();
            }
        });
        if (counter.getSize() == 0) {
            return null;
        }
        if (wordFieldUrl == null) {
            log.info("wordFieldUrl null");
            throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u544a\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25", (String)"AnalyseRptGenUtil_4", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        try (InputStream fileInputStream = UploadUtil.getFileInputStream((String)wordFieldUrl);
             XWPFDocument doc = new XWPFDocument(fileInputStream);
             ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            TableConvert.replaceTable(doc, markKeyTableMap, markKeyNameMap);
            TempFileCache tfc = CacheFactory.getCommonCacheFactory().getTempFileCache();
            int timeout = 600;
            Map rptName = (Map)JSONUtils.parse((String)rptData.getRptName(), HashMap.class);
            String name = (String)rptName.get(Lang.get().toString());
            if (name == null) {
                name = (String)rptName.get("GLang");
            }
            String utf8FileName = URLEncoder.encode(name + "(" + rptData.getRptNumber() + ").docx", "utf-8");
            String tenantId = RequestContext.get().getTenantId();
            String accountId = RequestContext.get().getAccountId();
            String path = FileNameUtils.getAttachmentFileName((String)tenantId, (String)accountId, (String)"epm", (String)"eb_analysereport", (Object)rptData.getFileId(), (String)utf8FileName);
            doc.write((OutputStream)outputStream);
            try (ByteArrayInputStream finalInputStream = new ByteArrayInputStream(outputStream.toByteArray());){
                result = tfc.saveAsFullUrl(path, (InputStream)finalInputStream, timeout);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(e.getMessage());
        }
        return result;
    }

    private void addErrorVarInfo(String mark, List<WebOfficeMark> marks) {
        marks.add(new WebOfficeMark(mark, " "));
    }

    private boolean checkVarHasVal(Object varVal, AnalyseWebOfficeVarEntity obj, String mark, List<String> errInfo, String rptNumber) {
        if (varVal == null || varVal instanceof String && StringUtils.isEmpty((CharSequence)((String)varVal))) {
            this.doLog(StringUtils.join((Object[])new Serializable[]{" doReplace var has not value,rpt: ", rptNumber, " || mark:", mark, ",id:", obj.getId()}));
            errInfo.add(ResManager.loadResFormat((String)"\u7c7b\u578b\u4e3a %1 \u7684\u53d8\u91cf  %2 \u8d4b\u503c\u4e3a\u7a7a\u3002", (String)"AnalyseRptGenUtil_2", (String)"epm-eb-formplugin", (Object[])new Object[]{VariableTypeEnum.getVariableTypeByNumber((String)obj.getVarType()).getName(), obj.getName()}));
            return false;
        }
        return true;
    }

    private boolean checkVarExist(AnalyseWebOfficeVarEntity obj, String mark, List<String> errInfo, String rptNumber) {
        if (obj == null) {
            this.doLog(StringUtils.join((Object[])new String[]{" doReplace mark isnot exist,rpt: ", rptNumber, " || mark:", mark}));
            errInfo.add(ResManager.loadResFormat((String)"\u6a21\u677f\u4e0a\u4e0d\u5b58\u5728\u6807\u7b7e\u201c%1\u201d\u3002", (String)"AnalyseRptGenUtil_1", (String)"epm-eb-formplugin", (Object[])new Object[]{mark}));
            return false;
        }
        return true;
    }

    private void doReplaceDimGroup(VarValues varValues, AnalyseWebOfficeVarEntity obj, String mark, List<String> errInfo, String rptNumber, List<WebOfficeMark> marks) {
        DimGroupResult varVal = (DimGroupResult)varValues.getMemberGroupVals().get(obj.getId());
        String varValStr = varVal == null ? null : varVal.getShowResult();
        this.doReplaceText(varValStr, obj, mark, errInfo, rptNumber, marks);
    }

    private void doReplaceFunction(VarValues varValues, AnalyseWebOfficeVarEntity obj, String mark, List<String> errInfo, String rptNumber, List<WebOfficeMark> marks, Map<String, String[][]> tablesData) {
        FunctionResult functionResult = (FunctionResult)varValues.getFunctionVals().get(obj.getId());
        if (this.checkVarHasVal(functionResult, obj, mark, errInfo, rptNumber)) {
            if (functionResult instanceof FunctionTableResult) {
                List dataList2Show = ((FunctionTableResult)functionResult).getTableRows();
                String tableKey = mark;
                String[][] tableData = new String[dataList2Show.size()][];
                int index = 0;
                Iterator iterator = dataList2Show.iterator();
                while (iterator.hasNext()) {
                    String[] rowVals;
                    tableData[index] = rowVals = (String[])iterator.next();
                    ++index;
                }
                tablesData.put(tableKey, tableData);
            } else if (functionResult instanceof FunctionStrResult) {
                this.doReplaceText(((FunctionStrResult)functionResult).getShowStr(), obj, mark, errInfo, rptNumber, marks);
            }
        }
    }

    private void doReplaceCondition(VarValues varValues, AnalyseWebOfficeVarEntity obj, String mark, List<String> errInfo, String rptNumber, List<WebOfficeMark> marks) {
        String varVal = (String)varValues.getConditionVals().get(obj.getId());
        this.doReplaceText(varVal, obj, mark, errInfo, rptNumber, marks);
    }

    private void doReplaceDimParam(VarValues varValues, AnalyseWebOfficeVarEntity obj, String mark, List<String> errInfo, String rptNumber, List<WebOfficeMark> marks) {
        String varVal = (String)varValues.getParamVals().get(obj.getId());
        this.doReplaceText(varVal, obj, mark, errInfo, rptNumber, marks);
    }

    private void doReplaceText(String varVal, AnalyseWebOfficeVarEntity obj, String mark, List<String> errInfo, String rptNumber, List<WebOfficeMark> marks) {
        if (!this.checkVarHasVal(varVal, obj, mark, errInfo, rptNumber)) {
            varVal = "";
        }
        this.doLog(StringUtils.join((Object[])new String[]{" doReplace rpt: ", rptNumber, " || mark:", mark, " || varName: ", obj.getName(), " || varNumber: ", obj.getNumber(), " || value: ", varVal}));
        marks.add(new WebOfficeMark(mark, varVal));
    }

    private void doLog(String info) {
        AnalyzeRptWebOfficeCommon.doLog(info, log);
    }

    public boolean isOffsetYearVar(String varNumber) {
        return varNumber != null && (varNumber.startsWith("@NextY") || varNumber.startsWith("@LastY") || varNumber.startsWith("@BaseY."));
    }

    private static class InnerClass {
        private static AnalyseRptGenUtil instance = new AnalyseRptGenUtil();

        private InnerClass() {
        }
    }
}

