/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analyzeReport.service;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.business.quote.MemberQuote;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.analysereport.constants.VariableTypeEnum;
import kd.epm.eb.common.analysereport.pojo.AnalyseRptEntity;
import kd.epm.eb.common.analysereport.pojo.MemberView;
import kd.epm.eb.common.constant.BgFormConstant;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.SqlBatchUtils;
import kd.epm.eb.common.utils.UserUtils;

public class AnalyseRptTmpUtil {
    public static AnalyseRptTmpUtil getInstance() {
        return InnerClass.instance;
    }

    private AnalyseRptTmpUtil() {
    }

    public Set<String> getBookMarkVar(List<String> bookmarks) {
        HashSet<String> returns = new HashSet<String>(16);
        for (String mark : bookmarks) {
            if (StringUtils.isEmpty((String)mark)) continue;
            returns.add(mark);
        }
        return returns;
    }

    public Collection<DynamicObject> getSaveDataTmpBase(AnalyseRptEntity rptTemp, IDataModel thisModel) {
        ArrayList<DynamicObject> needSaveRpts = new ArrayList<DynamicObject>(16);
        if (QueryServiceHelper.exists((String)"eb_analysereporttemplate", (Object)rptTemp.getRptTemp().getId())) {
            DynamicObject load = BusinessDataServiceHelper.loadSingle((Object)rptTemp.getRptTemp().getId(), (String)"eb_analysereporttemplate");
            load.set("name", (Object)rptTemp.getRptTemp().getName());
            load.set("number", (Object)rptTemp.getRptTemp().getNumber());
            load.set("description", (Object)rptTemp.getRptTemp().getDescription());
            load.set("modifier", (Object)UserUtils.getUserId());
            load.set("modifydate", (Object)TimeServiceHelper.now());
            load.set("shareusers", thisModel.getValue("shareusers"));
            needSaveRpts.add(load);
        } else {
            DynamicObject varObj = BusinessDataServiceHelper.newDynamicObject((String)"eb_analysereporttemplate");
            varObj.set("id", (Object)rptTemp.getRptTemp().getId());
            varObj.set("number", (Object)rptTemp.getRptTemp().getNumber());
            varObj.set("name", (Object)rptTemp.getRptTemp().getName());
            varObj.set("description", (Object)rptTemp.getRptTemp().getDescription());
            varObj.set("model", (Object)rptTemp.getRptTemp().getModelid());
            varObj.set("status", (Object)1);
            varObj.set("bizmodel", (Object)rptTemp.getRptTemp().getBizModelid());
            varObj.set("creater", (Object)UserUtils.getUserId());
            varObj.set("createdate", (Object)TimeServiceHelper.now());
            varObj.set("modifier", (Object)UserUtils.getUserId());
            varObj.set("modifydate", (Object)TimeServiceHelper.now());
            varObj.set("shareusers", thisModel.getValue("shareusers"));
            needSaveRpts.add(varObj);
        }
        return needSaveRpts;
    }

    public Collection<DynamicObject> getVarSelFromWebOffice(DynamicObjectCollection varSelEntity, Set<String> bookMarks) {
        ArrayList<DynamicObject> returns = new ArrayList<DynamicObject>(16);
        if (varSelEntity == null || varSelEntity.size() == 0) {
            return returns;
        }
        if (bookMarks == null || bookMarks.size() == 0) {
            return returns;
        }
        for (DynamicObject dynamicObject : varSelEntity) {
            String varKey = dynamicObject.getString("varselkey");
            if (!bookMarks.contains(varKey)) continue;
            returns.add(dynamicObject);
        }
        return returns;
    }

    public Collection<DynamicObject> getSaveDataVarSel(Long rtpTempId, Collection<DynamicObject> varSelEntity) {
        if (varSelEntity == null || varSelEntity.size() == 0) {
            return null;
        }
        DynamicObject varObj = null;
        ArrayList<DynamicObject> needSaveRpts = new ArrayList<DynamicObject>(16);
        for (DynamicObject dynamicObject : varSelEntity) {
            varObj = BusinessDataServiceHelper.newDynamicObject((String)"eb_analysevarsel");
            varObj.set("varkey", (Object)dynamicObject.getString("varselkey"));
            varObj.set("var", (Object)dynamicObject.getLong("varidsel"));
            varObj.set("vartype", (Object)dynamicObject.getString("vartypesel"));
            varObj.set("rpttemp", (Object)rtpTempId);
            needSaveRpts.add(varObj);
        }
        return needSaveRpts;
    }

    public void putMap(Long var, String varType, String varKey, Map<String, List<Long>> varTypeMap, Map<Long, List<String>> varIdKeys) {
        List<Long> varTypes = varTypeMap.get(varType);
        if (varTypes == null) {
            varTypes = new ArrayList<Long>(16);
        }
        varTypes.add(var);
        varTypeMap.put(varType, varTypes);
        List<String> varIdKey = varIdKeys.get(var);
        if (varIdKey == null) {
            varIdKey = new ArrayList<String>(16);
        }
        varIdKey.add(varKey);
        varIdKeys.put(var, varIdKey);
    }

    public Map<String, List<Long>> queryVarSel(Long modleid, Long templateid, Map<Long, List<String>> out_map) {
        HashMap<String, List<Long>> varTypeMap = new HashMap<String, List<Long>>(16);
        String selectFields = "var.id,vartype,varkey";
        QFilter qf = new QFilter("rpttemp", "=", (Object)templateid);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"eb_analysevarsel", (String)selectFields, (QFilter[])qf.toArray(), null);){
            while (ds.hasNext()) {
                Row row = ds.next();
                this.putMap(row.getLong("var.id"), row.getString("vartype"), row.getString("varkey"), varTypeMap, out_map);
            }
        }
        return varTypeMap;
    }

    public List<Map<String, String>> getVarSels(Map<String, List<Long>> varTypeMap, Map<Long, List<String>> varIdKeys) {
        ArrayList<Map<String, String>> lists = new ArrayList<Map<String, String>>(10);
        if (varTypeMap == null || varTypeMap.size() == 0) {
            return lists;
        }
        if (varIdKeys == null || varIdKeys.size() == 0) {
            return lists;
        }
        for (Map.Entry<String, List<Long>> varTypes : varTypeMap.entrySet()) {
            lists.addAll(this.getVarSel(varTypes.getKey(), varTypes.getValue(), varIdKeys));
        }
        return lists;
    }

    private List<Map<String, String>> getVarSel(String varType, List<Long> varIds, Map<Long, List<String>> varIdKeys) {
        ArrayList<Map<String, String>> lists = new ArrayList<Map<String, String>>(10);
        if (varIds == null || varIds.size() == 0) {
            return lists;
        }
        if (varIdKeys == null || varIdKeys.size() == 0) {
            return lists;
        }
        QFBuilder qfilter = new QFBuilder("id", "in", varIds);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)VariableTypeEnum.getVariableTypeByNumber((String)varType).getMetadata(), (String)"id,number,name", (QFilter[])qfilter.toArray(), null);){
            while (ds.hasNext()) {
                Row row = ds.next();
                List<String> varIdKey = varIdKeys.get(row.getLong("id"));
                if (varIdKey == null) continue;
                for (String varId_Key : varIdKey) {
                    HashMap<String, String> map = new HashMap<String, String>(8);
                    map.put("id", row.getString("id"));
                    map.put("number", row.getString("number"));
                    map.put("name", row.getString("name"));
                    map.put("type", varType);
                    map.put("varkey", varId_Key);
                    lists.add(map);
                }
            }
        }
        return lists;
    }

    public TableValueSetter setEntryValueSet(AnalyseRptEntity info, List<Map<String, String>> varLst) {
        if (varLst == null || varLst.size() == 0) {
            return null;
        }
        TableValueSetter tableValueSetter = new TableValueSetter(new String[]{"varid", "varname", "varnumber", "vartype", "vartypenumber"});
        for (Map<String, String> vars : varLst) {
            tableValueSetter.addRow(new Object[]{vars.get("id"), vars.get("name"), vars.get("number"), vars.get("type"), VariableTypeEnum.getVariableTypeByNumber((String)vars.get("type")).getName()});
        }
        return tableValueSetter;
    }

    public TableValueSetter setEntryValueSel(List<Map<String, String>> varLst) {
        if (varLst == null) {
            varLst = new ArrayList<Map<String, String>>(16);
        }
        TableValueSetter tableValueSetter = new TableValueSetter(new String[]{"varidsel", "varnamesel", "varnumbersel", "vartypesel", "varselkey", "vartypenumbersel"});
        for (Map<String, String> vars : varLst) {
            tableValueSetter.addRow(new Object[]{vars.get("id"), vars.get("name"), vars.get("number"), vars.get("type"), vars.get("varkey"), VariableTypeEnum.getVariableTypeByNumber((String)vars.get("type")).getName()});
        }
        return tableValueSetter;
    }

    public Set<Long> getRefDimGroupIds(Long sourceId, int typeVal) {
        return this.getRefDimGroupIds(Sets.newHashSet((Object[])new Object[]{sourceId}), typeVal);
    }

    public Set<Long> getRefRptSectionIds(Long sourceId) {
        MemberQuote memberQuote = MemberQuote.get();
        Map tempQuoteInfo = memberQuote.queryQuote(Collections.singletonList(sourceId)).getOrDefault(0L, new HashMap(16));
        return tempQuoteInfo.getOrDefault(String.valueOf(MemberTypeEnum.RPTSECTION.getType()), new HashSet(16));
    }

    public Set<Long> getRefDimGroupIds(Set<Object> sourceId, int typeVal) {
        ArrayList<MemberTypeEnum> quoteTypes = new ArrayList<MemberTypeEnum>(16);
        if (typeVal == 1) {
            quoteTypes.add(MemberTypeEnum.RPTFUNCTION);
            quoteTypes.add(MemberTypeEnum.JUDGECONDITION);
        } else if (typeVal == 2) {
            quoteTypes.add(MemberTypeEnum.JUDGECONDITION);
        }
        quoteTypes.add(MemberTypeEnum.DIMGROUP);
        MemberQuote memberQuote = MemberQuote.get();
        ArrayList<Set<Object>> allQuoteIds = new ArrayList<Set<Object>>(quoteTypes.size());
        allQuoteIds.add(sourceId);
        for (int i = 0; i < quoteTypes.size(); ++i) {
            allQuoteIds.add(new HashSet(16));
        }
        for (int i = 0; i < quoteTypes.size(); ++i) {
            Map<String, Set<Long>> tempQuoteInfo = memberQuote.queryQuote((Collection)allQuoteIds.get(i)).get(0L);
            if (tempQuoteInfo == null) continue;
            for (int j = i; j < quoteTypes.size(); ++j) {
                MemberTypeEnum type = (MemberTypeEnum)quoteTypes.get(j);
                Set<Long> refIds = tempQuoteInfo.get(String.valueOf(type.getType()));
                if (refIds == null) continue;
                ((Set)allQuoteIds.get(j + 1)).addAll(refIds);
            }
        }
        return IDUtils.toLongs((Set)((Set)allQuoteIds.get(allQuoteIds.size() - 1)));
    }

    public void addVarValUserRecord(Long templateId, Map<Long, Pair<Long, Long>> varValMap) {
        if (varValMap == null || varValMap.isEmpty()) {
            return;
        }
        String delSql = "delete from t_eb_varvaluserrecord where fsourceid = " + templateId;
        String insertSql = "insert into t_eb_varvaluserrecord(fid,fsourceid,fvarid,fvarvalid,fviewid) values(?,?,?,?,?)";
        ArrayList allValParams = new ArrayList(varValMap.size());
        varValMap.forEach((varId, varValInfo) -> {
            Object[] valParams = new Object[]{GlobalIdUtil.genGlobalLongId(), templateId, varId, varValInfo.p1, varValInfo.p2};
            allValParams.add(valParams);
        });
        try (TXHandle tx = TX.requiresNew((String)"addVarValUserRecord");){
            try {
                DB.execute((DBRoute)BgFormConstant.DBROUTE, (String)delSql);
                DB.executeBatch((DBRoute)BgFormConstant.DBROUTE, (String)insertSql, allValParams);
            }
            catch (Throwable e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    public Map<Long, MemberView> getVarValUserRecord(Long templateId) {
        HashMap<Long, MemberView> result = new HashMap<Long, MemberView>(16);
        String sql = "select fvarid,fvarvalid,fviewid from t_eb_varvaluserrecord where fsourceid = " + templateId;
        try (DataSet dataSet = DB.queryDataSet((String)"getVarValUserRecord", (DBRoute)BgFormConstant.DBROUTE, (String)sql);){
            for (Row row : dataSet) {
                result.put(row.getLong("fvarid"), new MemberView(row.getLong("fvarvalid"), row.getLong("fviewid")));
            }
        }
        return result;
    }

    public void delVarValUserRecord(Collection<Long> tempIds) {
        if (tempIds == null || tempIds.isEmpty()) {
            return;
        }
        String sql = "delete from t_eb_varvaluserrecord where fsourceid in(" + SqlBatchUtils.getBatchParamsSql((int)tempIds.size()) + ")";
        DB.execute((DBRoute)BgFormConstant.DBROUTE, (String)sql, (Object[])tempIds.toArray());
    }

    private static class InnerClass {
        private static AnalyseRptTmpUtil instance = new AnalyseRptTmpUtil();

        private InnerClass() {
        }
    }
}

