/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analyzeReport.service;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.analyzeReport.context.ConditionContext;
import kd.epm.eb.business.analyzeReport.context.DatasetSelContext;
import kd.epm.eb.business.analyzeReport.context.DimGroupExecContext;
import kd.epm.eb.business.analyzeReport.context.FunctionExecContext;
import kd.epm.eb.business.analyzeReport.context.RptSectionExecContext;
import kd.epm.eb.business.analyzeReport.context.VarParseContext;
import kd.epm.eb.business.analyzeReport.execute.DimGroupFormulaExecutor;
import kd.epm.eb.business.analyzeReport.execute.IConditionExecutor;
import kd.epm.eb.business.analyzeReport.execute.IDimGroupExecutor;
import kd.epm.eb.business.analyzeReport.execute.IFunctionExecutor;
import kd.epm.eb.business.analyzeReport.execute.RptSectionExecutor;
import kd.epm.eb.business.analyzeReport.factory.ConditionExecutorFactory;
import kd.epm.eb.business.analyzeReport.factory.DimGroupExecutorFactory;
import kd.epm.eb.business.analyzeReport.factory.FunctionExecutorFactory;
import kd.epm.eb.business.applybill.util.BgApplyBillUtils;
import kd.epm.eb.common.analysereport.pojo.MemberView;
import kd.epm.eb.common.analysereport.pojo.VarParams;
import kd.epm.eb.common.analysereport.pojo.VarValues;
import kd.epm.eb.common.analysereport.pojo.condition.ConditionResult;
import kd.epm.eb.common.analysereport.pojo.formula.DimGroupResult;
import kd.epm.eb.common.analysereport.pojo.functions.Function;
import kd.epm.eb.common.analysereport.pojo.functions.FunctionResult;
import kd.epm.eb.common.analysereport.pojo.section.RptSectionExecResult;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.LogHelper;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.spread.utils.ReportVar.TemplateVarCommonUtil;

public class AnalyseRptVarExecUtil {
    private static final Log log = LogFactory.getLog(AnalyseRptVarExecUtil.class);

    public static Map<Long, IDimGroupExecutor> parseMemberGroup(VarParams varParams, Map<Long, Map<String, Set<String>>> dimMemberNums, IModelCacheHelper modelCacheHelper) {
        HashMap<Long, IDimGroupExecutor> result = new HashMap<Long, IDimGroupExecutor>(16);
        Set dimMemberGroupIds = varParams.getDimMemberGroupIds();
        if (dimMemberGroupIds.size() > 0) {
            HashSet formulaDimGroups = new HashSet(16);
            Map varsObj = BusinessDataServiceHelper.loadFromCache((Object[])dimMemberGroupIds.toArray(), (String)"eb_dimcombinationentity");
            varsObj.values().forEach(obj -> {
                IDimGroupExecutor dimGroupExecutor = DimGroupExecutorFactory.parserAndSelParam(obj, modelCacheHelper, dimMemberNums, varParams, formulaDimGroups);
                result.put(obj.getLong("id"), dimGroupExecutor);
            });
            if (formulaDimGroups.size() != 0) {
                varsObj = BusinessDataServiceHelper.loadFromCache((Object[])formulaDimGroups.toArray(), (String)"eb_dimcombinationentity");
                for (Map.Entry varsObjEntry : varsObj.entrySet()) {
                    Long pkId = ConvertUtils.toLong(varsObjEntry.getKey());
                    DynamicObject dimGroup = (DynamicObject)varsObjEntry.getValue();
                    IDimGroupExecutor dimGroupExecutor = DimGroupExecutorFactory.parserAndSelParam(dimGroup, modelCacheHelper, dimMemberNums, varParams, new HashSet<Long>(16));
                    if (!result.containsKey(pkId)) {
                        result.put(pkId, dimGroupExecutor);
                    }
                    formulaDimGroups.remove(pkId);
                }
                if (formulaDimGroups.size() != 0) {
                    throw new KDBizException(ResManager.loadResFormat((String)"\u4e0d\u5b58\u5728id\u4e3a %1 \u7684\u7ef4\u5ea6\u7ec4\u5408", (String)"AnalyzeRptWebOfficeUtil_0", (String)"epm-eb-business", (Object[])new Object[]{formulaDimGroups.stream().map(String::valueOf).collect(Collectors.joining("\u3001"))}));
                }
            }
        }
        return result;
    }

    public static Map<Long, IConditionExecutor> parseCondition(VarParams varParams) {
        Set conditionIds = varParams.getConditionIds();
        HashMap<Long, IConditionExecutor> result = new HashMap<Long, IConditionExecutor>(conditionIds.size());
        if (conditionIds.size() > 0) {
            Map varsObj = BusinessDataServiceHelper.loadFromCache((Object[])conditionIds.toArray(), (String)"eb_judgecondition");
            varsObj.values().forEach(obj -> {
                IConditionExecutor executor = ConditionExecutorFactory.parserAndSelParam(obj, varParams);
                if (executor != null) {
                    result.put(obj.getLong("id"), executor);
                }
            });
        }
        return result;
    }

    public static Map<Long, IFunctionExecutor> parseFunction(VarParams varParams, boolean selectParam) {
        Set functionIds = varParams.getFunctionIds();
        HashMap<Long, IFunctionExecutor> result = new HashMap<Long, IFunctionExecutor>(16);
        if (functionIds != null && functionIds.size() > 0) {
            DynamicObject[] objects;
            for (DynamicObject obj : objects = BusinessDataServiceHelper.load((String)"eb_analyzereportfuntion", (String)"model,number,type,allstepdata_tag", (QFilter[])new QFilter("id", "in", (Object)functionIds).toArray())) {
                IFunctionExecutor executor = FunctionExecutorFactory.parserAndSelParam(obj, (VarParams)(selectParam ? varParams : null));
                if (executor == null) continue;
                result.put(obj.getLong("id"), executor);
            }
        }
        return result;
    }

    public static void parseCommonDimMembs(VarParseContext parseContext, VarParams varParams) {
        DatasetSelContext selContext = new DatasetSelContext();
        selContext.setDimGroupExecutorMap(parseContext.getDimMemberGroup());
        selContext.setConditionExecutorMap(parseContext.getConditionMap());
        parseContext.getFunctionMap().forEach((functionId, functionExecutor) -> functionExecutor.selectParam(parseContext, selContext));
        varParams.getConditionIds().forEach(conditionId -> {
            IConditionExecutor conditionExecutor = parseContext.getConditionMap().get(conditionId);
            if (conditionExecutor != null) {
                conditionExecutor.select(selContext);
            }
        });
        varParams.getDimMemberGroupIds().forEach(dimGroupId -> {
            IDimGroupExecutor dimGroupExecutor = parseContext.getDimMemberGroup().get(dimGroupId);
            if (dimGroupExecutor != null) {
                dimGroupExecutor.select(selContext);
            }
        });
        selContext.getRefParamDimOnDataset().forEach((datasetId, dimNums) -> {
            Map dimMembNums = parseContext.getDimMemberNums().computeIfAbsent((Long)datasetId, key -> new HashMap(16));
            dimNums.forEach(dimNum -> {
                MemberView memberView = (MemberView)varParams.getPageDimMembers().get(dimNum);
                if (memberView != null) {
                    dimMembNums.computeIfAbsent(dimNum, key -> new HashSet(16)).add(memberView.getMemberNumber());
                }
            });
        });
    }

    public static VarValues executeVars(VarParams varParams) {
        CommonServiceHelper.handleLogBySign((Log)log, (String)"AnalyseExec_VarParams", () -> SerializationUtils.toJsonString((Object)varParams), (String)"AnalyseExec", (String)"VarParams");
        LogHelper logHelper = new LogHelper("parseVars", log);
        VarParseContext parseContext = new VarParseContext();
        parseContext.setModelCacheHelper(ModelCacheContext.getOrCreate((Long)varParams.getModelId()));
        AnalyseRptVarExecUtil.selectVarParamObjs(varParams, parseContext);
        logHelper.addInfoLog("selectVarParamObjs");
        Map<Long, Map<MembersKey, Object>> olapData = AnalyseRptVarExecUtil.queryOlapData(parseContext, varParams);
        logHelper.addInfoLog("queryOlapData");
        VarValues varValues = new VarValues();
        AnalyseRptVarExecUtil.executeDimGroup(varValues, varParams, olapData, parseContext);
        logHelper.addInfoLog("executeDimGroup");
        AnalyseRptVarExecUtil.executeCondition(varValues, varParams, olapData, parseContext);
        logHelper.addInfoLog("executeCondition");
        AnalyseRptVarExecUtil.executeFunction(varValues, varParams, olapData, parseContext);
        logHelper.addInfoLog("executeFunction");
        AnalyseRptVarExecUtil.executeDimParam(varValues, varParams, parseContext.getModelCacheHelper());
        logHelper.addInfoLog("executeDimParam");
        AnalyseRptVarExecUtil.executeRptSection(varValues, varParams, parseContext.getModelCacheHelper());
        logHelper.addInfoLog("executeRptReport");
        return varValues;
    }

    public static FunctionResult executeFunction4Show(Function functionData, Map<String, MemberView> pageDimMembers, Map<String, MemberView> memberVarValInfo) {
        VarParams varParams = new VarParams();
        varParams.setModelId(functionData.getModelId());
        varParams.setPageDimMembers(pageDimMembers);
        varParams.getFunctionIds().add(0L);
        varParams.setMemberVarInfoMap(memberVarValInfo);
        FunctionExecutorFactory.selectParams(varParams, functionData);
        VarParseContext varParseContext = new VarParseContext();
        varParseContext.setModelCacheHelper(ModelCacheContext.getOrCreate((Long)functionData.getModelId()));
        varParseContext.getFunctionMap().put(0L, FunctionExecutorFactory.getExecutor(functionData));
        AnalyseRptVarExecUtil.selectVarParamObjs(varParams, varParseContext);
        Map<Long, Map<MembersKey, Object>> olapData = AnalyseRptVarExecUtil.queryOlapData(varParseContext, varParams);
        VarValues values = new VarValues();
        AnalyseRptVarExecUtil.executeFunction(values, varParams, olapData, varParseContext);
        FunctionResult functionResult = (FunctionResult)values.getFunctionVals().get(0L);
        if (functionResult == null) {
            functionResult = new FunctionResult();
        }
        return functionResult;
    }

    private static void executeDimGroup(VarValues varValues, VarParams varParams, Map<Long, Map<MembersKey, Object>> olapData, VarParseContext parseContext) {
        DimGroupResult memberGroupVal;
        IDimGroupExecutor executor;
        Set dimMemberGroupIds = varParams.getDimMemberGroupIds();
        HashMap<Long, DimGroupResult> dimGroupVals = new HashMap<Long, DimGroupResult>(dimMemberGroupIds.size());
        Map<Long, IDimGroupExecutor> dimMemberGroup = parseContext.getDimMemberGroup();
        DimGroupExecContext dimGroupExecContext = new DimGroupExecContext();
        dimGroupExecContext.setPageDimMembers(varParams.getPageDimMembers());
        dimGroupExecContext.setOlapData(olapData);
        dimGroupExecContext.setModelId(parseContext.getModelCacheHelper().getModelobj().getId());
        dimGroupExecContext.setMemberGroupMap(dimMemberGroup);
        HashSet<Long> formulaGroupIds = new HashSet<Long>(16);
        for (Long groupId : dimMemberGroupIds) {
            executor = dimMemberGroup.get(groupId);
            if (executor == null) continue;
            if (executor instanceof DimGroupFormulaExecutor) {
                formulaGroupIds.add(groupId);
                continue;
            }
            memberGroupVal = executor.execute(dimGroupExecContext);
            if (memberGroupVal == null) continue;
            dimGroupVals.put(groupId, memberGroupVal);
        }
        for (Long formulaGroupId : formulaGroupIds) {
            executor = dimMemberGroup.get(formulaGroupId);
            memberGroupVal = executor.execute(dimGroupExecContext);
            if (memberGroupVal == null) continue;
            dimGroupVals.put(formulaGroupId, memberGroupVal);
        }
        varValues.setMemberGroupVals(dimGroupVals);
    }

    private static void executeCondition(VarValues varValues, VarParams varParams, Map<Long, Map<MembersKey, Object>> olapData, VarParseContext parseContext) {
        Set conditionIds = varParams.getConditionIds();
        ConditionContext conditionContext = new ConditionContext();
        conditionContext.setPageDimMembers(varParams.getPageDimMembers());
        conditionContext.setOlapData(olapData);
        conditionContext.setMemberGroupMap(parseContext.getDimMemberGroup());
        conditionContext.setModelCacheHelper(parseContext.getModelCacheHelper());
        for (Long conditionId : conditionIds) {
            ConditionResult conditionResult;
            IConditionExecutor executor = parseContext.getConditionMap().get(conditionId);
            if (executor == null || (conditionResult = executor.getResult(conditionContext)) == null || !conditionResult.isSucceed()) continue;
            varValues.getConditionVals().put(conditionId, conditionResult.getResult());
        }
    }

    private static void executeFunction(VarValues varValues, VarParams varParams, Map<Long, Map<MembersKey, Object>> olapData, VarParseContext parseContext) {
        Set functionIds = varParams.getFunctionIds();
        Map<Long, IFunctionExecutor> functionMap = parseContext.getFunctionMap();
        FunctionExecContext execContext = new FunctionExecContext();
        execContext.setOlapData(olapData);
        execContext.setVarParseContext(parseContext);
        execContext.setPageDimNums(varParams.getPageDimMembers());
        HashMap<Long, FunctionResult> allFunctionResult = new HashMap<Long, FunctionResult>(16);
        for (Long functionId : functionIds) {
            IFunctionExecutor executor = functionMap.get(functionId);
            if (executor == null) continue;
            FunctionResult executeResult = executor.execute(execContext);
            allFunctionResult.put(functionId, executeResult);
        }
        varValues.setFunctionVals(allFunctionResult);
    }

    public static void selectVarParamObjs(VarParams varParams, VarParseContext parseContext) {
        LogHelper logHelper = new LogHelper("selectVarParamObjs", log);
        HashMap<Long, Map<String, Set<String>>> dimMemberNums = new HashMap<Long, Map<String, Set<String>>>(16);
        VarParams varParamsCopy = varParams.copy();
        Map<Long, IFunctionExecutor> functionMap = AnalyseRptVarExecUtil.parseFunction(varParamsCopy, true);
        logHelper.addInfoLog("parseFunction");
        parseContext.getFunctionMap().putAll(functionMap);
        Map<Long, IConditionExecutor> conditionMap = AnalyseRptVarExecUtil.parseCondition(varParamsCopy);
        logHelper.addInfoLog("parseCondition");
        parseContext.getConditionMap().putAll(conditionMap);
        Map<Long, IDimGroupExecutor> dimGroupExecutorMap = AnalyseRptVarExecUtil.parseMemberGroup(varParamsCopy, dimMemberNums, parseContext.getModelCacheHelper());
        logHelper.addInfoLog("parseMemberGroup");
        parseContext.getDimMemberGroup().putAll(dimGroupExecutorMap);
        parseContext.setDimMemberNums(dimMemberNums);
        AnalyseRptVarExecUtil.parseCommonDimMembs(parseContext, varParams);
        logHelper.addInfoLog("parseCommonDimMembs");
        CommonServiceHelper.handleLogBySign((Log)log, (String)"AnalyseExec_DimMemberGroup", () -> SerializationUtils.toJsonString(parseContext.getDimMemberGroup()), (String)"AnalyseExec", (String)"DimMemberGroup");
        CommonServiceHelper.handleLogBySign((Log)log, (String)"AnalyseExec_FunctionMap", () -> SerializationUtils.toJsonString(parseContext.getFunctionMap()), (String)"AnalyseExec", (String)"FunctionMap");
        CommonServiceHelper.handleLogBySign((Log)log, (String)"AnalyseExec_ConditionMap", () -> SerializationUtils.toJsonString(parseContext.getConditionMap()), (String)"AnalyseExec", (String)"ConditionMap");
    }

    private static void executeDimParam(VarValues varValues, VarParams varParams, IModelCacheHelper modelCacheHelper) {
        Set paramIds = varParams.getParamIds();
        if (paramIds == null || paramIds.isEmpty()) {
            return;
        }
        HashMap res = new HashMap(16);
        Long modelId = modelCacheHelper.getModelobj().getId();
        Map maps = BusinessDataServiceHelper.loadFromCache((String)"eb_dimensionparameter", (String)"id,model.id,dimension.number,offset,name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)paramIds)});
        maps.values().forEach(dimParam -> {
            String dimNum = dimParam.getString("dimension.number");
            MemberView memberView = (MemberView)varParams.getPageDimMembers().get(dimNum);
            if (memberView != null) {
                Member member;
                String number = memberView.getMemberNumber();
                if ("BudgetPeriod".equals(dimNum)) {
                    number = AnalyseRptVarExecUtil.getOffset(dimParam.getString("offset"), number, dimParam.getString("name"), modelId);
                }
                if ((member = modelCacheHelper.getDimension(dimNum).getMember(memberView.getViewId(), number)) != null) {
                    res.put(dimParam.getLong("id"), member.getName());
                }
            }
        });
        varValues.setParamVals(res);
    }

    private static void executeRptSection(VarValues varValues, VarParams varParams, IModelCacheHelper modelCacheHelper) {
        String wordFileUrl = varParams.getWordFieldUrl();
        Set rptSectionIds = varParams.getRptSectionIds();
        if (StringUtils.isEmpty((String)wordFileUrl) || rptSectionIds.isEmpty()) {
            return;
        }
        try {
            RptSectionExecContext execContext = new RptSectionExecContext();
            execContext.getParamDimValues().putAll(varParams.getPageDimMembers());
            execContext.getDimVarValues().putAll(varParams.getMemberVarInfoMap());
            execContext.setModelId(varParams.getModelId());
            execContext.setBizModelId(varParams.getBizModelId());
            execContext.getRptSectionIds().addAll(rptSectionIds);
            execContext.setModelCacheHelper(modelCacheHelper);
            RptSectionExecutor executor = new RptSectionExecutor();
            RptSectionExecResult executeResult = executor.execute(execContext);
            varValues.getRptSectionsData().putAll(executeResult.getTables());
            varValues.getErrorInfo().addAll(executeResult.getErrorSectionInfo().values());
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    private static String getOffset(String offSet, String periodNumber, String varName, Long modelid) {
        if (StringUtils.isEmpty((String)offSet)) {
            return periodNumber;
        }
        String res = TemplateVarCommonUtil.getOff((String)periodNumber, (int)Integer.parseInt(offSet), (Long)modelid);
        if (res.equalsIgnoreCase("error")) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u671f\u95f4\u53d8\u91cf\u201c%1\u201d\u9009\u62e9\u7684\u671f\u95f4\u503c\u201c%2\u201d\u504f\u79fb\u201c%3\u201d\u540e\u7684\u671f\u95f4\u503c\u4e0d\u5728\u5f53\u524d\u4f53\u7cfb\u7684\u9884\u7b97\u671f\u95f4\u5185\uff0c\u8bf7\u8c03\u6574\u3002", (String)"AnalyzeRptWebOfficeUtil_1", (String)"epm-eb-business", (Object[])new Object[]{varName, periodNumber, offSet}));
        }
        return res;
    }

    public static Map<Long, Map<MembersKey, Object>> queryOlapData(VarParseContext parseContext, VarParams varParams) {
        Map<Long, Map<String, Set<String>>> allDimMemberNums = parseContext.getDimMemberNums();
        HashMap<Long, Map<MembersKey, Object>> result = new HashMap<Long, Map<MembersKey, Object>>(allDimMemberNums.size());
        allDimMemberNums.forEach((datasetId, dimMemberNums) -> {
            Map<MembersKey, Object> olapData = BgApplyBillUtils.getInstance().queryOlapData(parseContext.getModelCacheHelper(), varParams.getModelId(), (Long)datasetId, (Map<String, Set<String>>)dimMemberNums, false, false, 0L);
            result.put((Long)datasetId, olapData);
        });
        CommonServiceHelper.handleLogBySign((Log)log, (String)"AnalyseExec_allDimMemberNums", () -> SerializationUtils.toJsonString((Object)allDimMemberNums), (String)"AnalyseExec", (String)"allDimMemberNums");
        CommonServiceHelper.handleLogBySign((Log)log, (String)"AnalyseExec_allOlapData", () -> SerializationUtils.toJsonString((Object)result), (String)"AnalyseExec", (String)"allOlapData");
        return result;
    }
}

