/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.apiservice;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.epm.eb.business.dataupload.ModelUploadService;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.thread.EpmThreadPools;

public class DataUploadService {
    private static final Log log = LogFactory.getLog(DataUploadService.class);

    public static DataUploadService getInstance() {
        return InnerClass.instance;
    }

    private DataUploadService() {
    }

    public void interModelDataUpload(String json) {
        log.info("param:" + json);
        JSONObject jo = JSON.parseObject((String)json);
        List periodNumbers = (List)jo.getObject("periodNumbers", (TypeReference)new TypeReference<List<String>>(){});
        String srcVersion = jo.getString("srcVersion");
        String tarVersion = jo.getString("tarVersion");
        String schemeNumber = jo.getString("schemeNumber");
        Boolean isLock = jo.getBoolean("isLock");
        List tarEntityNumbers = (List)jo.getObject("tarEntityNumbers", (TypeReference)new TypeReference<List<String>>(){});
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_modelupload", (String)"id,number,srcmodel.id,tarmodel.id", (QFilter[])new QFilter("number", "=", (Object)schemeNumber).toArray());
        if (dynamicObject == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u6570\u636e\u4e0a\u4f20\u65b9\u6848\u201c%1\u201d\u6570\u636e\u4e0d\u5b58\u5728!", (String)"", (String)"", (Object[])new Object[]{schemeNumber}));
        }
        ModelUploadService instance = ModelUploadService.getInstance();
        Long id = dynamicObject.getLong("id");
        instance.validRepeatRun(id);
        HashMap<String, String> pageParam = new HashMap<String, String>(8);
        pageParam.put("bp", String.join((CharSequence)",", periodNumbers));
        long srcModelId = dynamicObject.getLong("srcmodel.id");
        IModelCacheHelper srcModelCache = ModelCacheContext.getOrCreate((Long)srcModelId);
        Member member = srcModelCache.getMember(SysDimensionEnum.Version.getNumber(), null, srcVersion);
        if (member == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u6e90\u7248\u672c\u201c%1\u201d\u6570\u636e\u4e0d\u5b58\u5728!", (String)"", (String)"", (Object[])new Object[]{srcVersion}));
        }
        pageParam.put("srcVersion", member.getNumber());
        pageParam.put("srcVersionName", member.getName());
        long tarModelId = dynamicObject.getLong("tarmodel.id");
        QFilter qFilter = new QFilter("model", "=", (Object)tarModelId);
        Date today = TimeServiceHelper.today();
        QFilter qFilter1 = new QFilter("startdate", "<=", (Object)today);
        qFilter1.and("enddate", ">", (Object)today);
        qFilter1.and("version.number", "=", (Object)tarVersion);
        DynamicObject dynamicObject1 = QueryServiceHelper.queryOne((String)"eb_receiveparameter", (String)"version.number", (QFilter[])new QFilter[]{qFilter, qFilter1});
        if (dynamicObject1 == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u76ee\u6807\u7248\u672c\u201c%1\u201d\u6570\u636e\u4e0d\u5b58\u5728,\u8bf7\u5728\u2018\u9884\u7b97\u4f53\u7cfb-\u6570\u636e\u96c6\u6210-\u63a5\u6536\u53c2\u6570\u2019\u4e2d\u914d\u7f6e\u3002", (String)"", (String)"", (Object[])new Object[]{tarVersion}));
        }
        IModelCacheHelper tarModelCache = ModelCacheContext.getOrCreate((Long)tarModelId);
        member = tarModelCache.getMember(SysDimensionEnum.Version.getNumber(), null, tarVersion);
        if (member == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u76ee\u6807\u7248\u672c\u201c%1\u201d\u6570\u636e\u4e0d\u5b58\u5728!", (String)"", (String)"", (Object[])new Object[]{tarVersion}));
        }
        pageParam.put("tarVersion", member.getNumber());
        pageParam.put("tarVersionName", member.getName());
        pageParam.put("tarVersionId", member.getId().toString());
        pageParam.put("isLock", String.valueOf(isLock));
        if (tarEntityNumbers == null || tarEntityNumbers.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76ee\u6807\u7ec4\u7ec7\u3002", (String)"EbDataTransMissionPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        ArrayList<String> number = new ArrayList<String>(10);
        ArrayList<String> name = new ArrayList<String>(10);
        for (String tarEntity : tarEntityNumbers) {
            Member member1 = tarModelCache.getMember(SysDimensionEnum.Entity.getNumber(), null, tarEntity);
            if (member1 == null) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u76ee\u6807\u7ec4\u7ec7\u201c%1\u201d\u6570\u636e\u4e0d\u5b58\u5728!", (String)"", (String)"", (Object[])new Object[]{tarEntity}));
            }
            number.add(member1.getNumber());
            name.add(member1.getName());
        }
        pageParam.put("org", String.join((CharSequence)",", number));
        pageParam.put("orgName", String.join((CharSequence)",", name));
        this.asyncModelDataUpload(id, pageParam, ModelUploadService.getInstance(), null, schemeNumber);
    }

    public void asyncModelDataUpload(Long id, Map<String, String> pageParam, ModelUploadService instance, IPageCache pageCache, String schemeNumber) {
        ThreadPool commPools = EpmThreadPools.CommPools;
        String traceId = RequestContext.getOrCreate().getTraceId();
        String loginIP = RequestContext.getOrCreate().getLoginIP();
        commPools.execute(() -> {
            RequestContext.getOrCreate().setTraceId(traceId);
            RequestContext.getOrCreate().setLoginIP(loginIP);
            instance.executeUpload(id, pageParam, pageCache, schemeNumber);
        });
    }

    private static class InnerClass {
        private static DataUploadService instance = new DataUploadService();

        private InnerClass() {
        }
    }
}

