/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.apiservice;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.apiservice.SyncCommonService;
import kd.epm.eb.business.apiservice.entity.DimensionResponse;
import kd.epm.eb.business.apiservice.entity.SyncBgmDataRequest;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.Builder;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.olap.OlapServiceCaller;
import kd.epm.eb.olap.api.base.IKDValue;
import kd.epm.eb.olap.api.dataSource.IKDOlapRequest;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.eb.olap.impl.base.KDValue;
import kd.epm.eb.olap.impl.metadata.KDCell;
import kd.epm.eb.olap.impl.utils.KDOlapRequestUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class SyncBgmBudgetDataService {
    private static final Log log = LogFactory.getLog(SyncBgmBudgetDataService.class);

    public static SyncBgmBudgetDataService getInstance() {
        return InnerClass.instance;
    }

    private SyncBgmBudgetDataService() {
    }

    public List syncData(String json) {
        ArrayList<ImmutableMap> errList = new ArrayList<ImmutableMap>(10);
        log.info("param:" + json);
        SyncBgmDataRequest request = (SyncBgmDataRequest)JSON.parseObject((String)json, SyncBgmDataRequest.class);
        if (request.getDatas().isEmpty()) {
            log.warn("\u540c\u6b65\u6570\u636e\u4e3a\u7a7a");
            return errList;
        }
        log.info("data_size:" + request.getDatas().size());
        DynamicObject model = SyncCommonService.getInstance().getModelObj(request.getModelNumber());
        long modelId = model.getLong("id");
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        DynamicObject bizModelObj = SyncCommonService.getInstance().getBizModelObj(modelId, request.getBizModelNumber());
        long dataSetId = bizModelObj.getLong("id");
        Long bizModelId = modelCache.getBusModelByDataSet(Long.valueOf(dataSetId));
        OlapServiceCaller olapServiceCaller = new OlapServiceCaller();
        List dimensions = modelCache.getDimensionList(Long.valueOf(dataSetId));
        ArrayList<IKDCell> cells = new ArrayList<IKDCell>(1);
        for (Map<String, String> data : request.getDatas()) {
            try {
                String[] memberMeta = this.getMemberMeta(modelCache, dimensions, data, dataSetId);
                BigDecimal value = new BigDecimal(data.get("value"));
                IKDCell cell = KDCell.of((String[])memberMeta, (BigDecimal)value);
                cells.clear();
                cells.add(cell);
                IKDOlapRequest req = KDOlapRequestUtils.of((Long)UserUtils.getUserId(), (Long)modelId, (Long)bizModelId, (Long)dataSetId, cells);
                req.getProperties().setPropertyValue("IGNORE_PERM_SAVE", (IKDValue)new KDValue("true"));
                req.getProperties().setPropertyValue("IGNORE_CALC", (IKDValue)new KDValue("true"));
                olapServiceCaller.save(req);
            }
            catch (Exception e) {
                log.error((Throwable)e);
                errList.add(ImmutableMap.of((Object)"errData", data, (Object)"errMsg", (Object)e.getMessage()));
            }
        }
        return errList;
    }

    public List syncActualData(String json) {
        ArrayList<ImmutableMap> errList = new ArrayList<ImmutableMap>(10);
        log.info("param:" + json);
        SyncBgmDataRequest request = (SyncBgmDataRequest)JSON.parseObject((String)json, SyncBgmDataRequest.class);
        if (request.getDatas().isEmpty()) {
            log.warn("\u540c\u6b65\u6570\u636e\u4e3a\u7a7a");
            return errList;
        }
        log.info("data_size:" + request.getDatas().size());
        DynamicObject model = SyncCommonService.getInstance().getModelObj(request.getModelNumber());
        long modelId = model.getLong("id");
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        DynamicObject bizModelObj = SyncCommonService.getInstance().getBizModelObj(modelId, request.getBizModelNumber());
        long dataSetId = bizModelObj.getLong("id");
        Long bizModelId = modelCache.getBusModelByDataSet(Long.valueOf(dataSetId));
        List dimensions = modelCache.getDimensionList(Long.valueOf(dataSetId));
        OlapServiceCaller olapServiceCaller = new OlapServiceCaller();
        ArrayList<IKDCell> cells = new ArrayList<IKDCell>(1);
        for (Map<String, String> data : request.getDatas()) {
            try {
                String[] memberMeta = this.getMemberMeta(modelCache, dimensions, data, dataSetId);
                BigDecimal value = new BigDecimal(data.get("value"));
                IKDCell cell = KDCell.of((String[])memberMeta, (BigDecimal)value);
                cells.clear();
                cells.add(cell);
                IKDOlapRequest req = KDOlapRequestUtils.of((Long)UserUtils.getUserId(), (Long)modelId, (Long)bizModelId, (Long)dataSetId, cells);
                req.getProperties().setPropertyValue("IGNORE_PERM_SAVE", (IKDValue)new KDValue("true"));
                req.getProperties().setPropertyValue("IGNORE_CALC", (IKDValue)new KDValue("true"));
                olapServiceCaller.saveByAdd(req);
            }
            catch (Exception e) {
                log.error((Throwable)e);
                errList.add(ImmutableMap.of((Object)"errData", data, (Object)"errMsg", (Object)e.getMessage()));
            }
        }
        return errList;
    }

    private String[] getMemberMeta(IModelCacheHelper modelCache, List<Dimension> dimensions, Map<String, String> data, long dataSetId) {
        Object[] memberMeta = new String[]{};
        for (Dimension dim : dimensions) {
            String dimNumber = dim.getNumber();
            String memberNubmer = data.get(dimNumber);
            if (StringUtils.isBlank((CharSequence)memberNubmer)) {
                log.error("\u7f3a\u5931\u7ef4\u5ea6\uff1a" + dimNumber);
                throw new KDBizException(ResManager.loadResFormat((String)"\u7f3a\u5931\u7ef4\u5ea6(%1)", (String)"SyncBudgetDataService_02", (String)"epm-eb-business", (Object[])new Object[]{dimNumber}));
            }
            Member member = modelCache.getMember(dimNumber, null, memberNubmer);
            if (member == null) {
                log.error("\u6210\u5458\u4e0d\u5b58\u5728\uff1a" + memberNubmer);
                throw new KDBizException(ResManager.loadResFormat((String)"\u6210\u5458\u4e0d\u5b58\u5728(%1)", (String)"SyncBudgetDataService_07", (String)"epm-eb-business", (Object[])new Object[]{memberNubmer}));
            }
            if (SysDimensionEnum.Account.getNumber().equals(dimNumber) && !member.getDatasetId().equals(dataSetId)) {
                log.error("\u79d1\u76ee\u4e0d\u5c5e\u4e8e\u8be5\u6570\u636e\u96c6\uff1a" + memberNubmer);
                throw new KDBizException(ResManager.loadResFormat((String)"\u79d1\u76ee(%1)\u4e0d\u5c5e\u4e8e\u8be5\u6570\u636e\u96c6", (String)"SyncBgmBudgetDataService_01", (String)"epm-eb-business", (Object[])new Object[]{memberNubmer}));
            }
            memberMeta = (String[])ArrayUtils.add((Object[])memberMeta, (Object)memberNubmer);
        }
        return memberMeta;
    }

    public List<DimensionResponse> getDimensionInfo(String json) {
        log.info("param:" + json);
        SyncBgmDataRequest request = (SyncBgmDataRequest)JSON.parseObject((String)json, SyncBgmDataRequest.class);
        DynamicObject model = SyncCommonService.getInstance().getModelObj(request.getModelNumber());
        long modelId = model.getLong("id");
        DynamicObject bizModelObj = SyncCommonService.getInstance().getBizModelObj(modelId, request.getBizModelNumber());
        long dataSetId = bizModelObj.getLong("id");
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List dimensions = modelCache.getDimensionList(Long.valueOf(dataSetId));
        return dimensions.stream().map(e -> (DimensionResponse)Builder.of(DimensionResponse::new).with(DimensionResponse::setDimensionNumber, (Object)e.getNumber()).with(DimensionResponse::setGetDimensionName, (Object)e.getName()).build()).collect(Collectors.toList());
    }

    private static class InnerClass {
        private static SyncBgmBudgetDataService instance = new SyncBgmBudgetDataService();

        private InnerClass() {
        }
    }
}

