/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.apiservice;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.apiservice.SyncCommonService;
import kd.epm.eb.business.apiservice.entity.DimensionResponse;
import kd.epm.eb.business.apiservice.entity.SyncDataRequest;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.shrek.controller.IShrekSave;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.util.ShrekIdCodeUtils;
import kd.epm.eb.common.utils.Builder;
import kd.epm.eb.common.utils.LogStats;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class SyncBudgetDataService {
    private static final Log log = LogFactory.getLog(SyncBudgetDataService.class);
    private static String[] ignoreDim = new String[]{SysDimensionEnum.DataType.getNumber(), SysDimensionEnum.Scenario.getNumber(), SysDimensionEnum.Process.getNumber()};

    public static SyncBudgetDataService getInstance() {
        return InnerClass.instance;
    }

    private SyncBudgetDataService() {
    }

    public List syncData(String json) {
        ArrayList<ImmutableMap> errList = new ArrayList<ImmutableMap>(10);
        log.info("param:" + json);
        SyncDataRequest request = (SyncDataRequest)JSON.parseObject((String)json, SyncDataRequest.class);
        if (request.getDatas().isEmpty()) {
            log.warn("\u540c\u6b65\u6570\u636e\u4e3a\u7a7a");
            return errList;
        }
        log.info("data_size:" + request.getDatas().size());
        LogStats stats = new LogStats("budget-shrek-log : ");
        stats.addInfo("begin-syncData");
        stats.addInfo("data_size:" + request.getDatas().size());
        DynamicObject model = SyncCommonService.getInstance().getModelObj(request.getModelNumber());
        long modelId = model.getLong("id");
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List dimensions = modelCache.getDimensionList();
        Dataset dataset = new Dataset(Long.valueOf(modelId), request.getModelNumber());
        try (IShrekSave shrekOlapSave = ShrekOlapServiceHelper.saveData((Model)modelCache.getModelobj(), (Dataset)dataset, (String[])modelCache.getDimensionNums(), (Map)ShrekIdCodeUtils.getDefaultIdCodes((LogStats)stats));){
            for (Map<String, String> data : request.getDatas()) {
                try {
                    String[] memberMeta = this.getMemberMeta(modelCache, dimensions, data);
                    BigDecimal value = new BigDecimal(data.get("value"));
                    shrekOlapSave.add(memberMeta, (Object)value);
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                    errList.add(ImmutableMap.of((Object)"errData", data, (Object)"errMsg", (Object)e.getMessage()));
                }
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(ResManager.loadResFormat((String)"\u6570\u636e\u4fdd\u5b58\u5f02\u5e38\u3002%1", (String)"SyncBudgetDataService_03", (String)"epm-eb-business", (Object[])new Object[]{e.getMessage()}));
        }
        finally {
            stats.addInfo("end-syncData");
            log.info(stats.toString());
        }
        return errList;
    }

    public List syncActualData(String json) {
        ArrayList<ImmutableMap> errList = new ArrayList<ImmutableMap>(10);
        log.info("param:" + json);
        SyncDataRequest request = (SyncDataRequest)JSON.parseObject((String)json, SyncDataRequest.class);
        if (request.getDatas().isEmpty()) {
            log.warn("\u540c\u6b65\u6570\u636e\u4e3a\u7a7a");
            return errList;
        }
        log.info("data_size:" + request.getDatas().size());
        LogStats stats = new LogStats("budget-shrek-log : ");
        stats.addInfo("begin-syncActualData");
        stats.addInfo("data_size:" + request.getDatas().size());
        DynamicObject model = SyncCommonService.getInstance().getModelObj(request.getModelNumber());
        long modelId = model.getLong("id");
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List dimensions = modelCache.getDimensionList();
        try (IShrekSave shrekOlapSave = ShrekOlapServiceHelper.saveDataByIncrement((Model)modelCache.getModelobj(), (String[])modelCache.getDimensionNums(), (Map)ShrekIdCodeUtils.getDefaultIdCodes((LogStats)stats));){
            for (Map<String, String> data : request.getDatas()) {
                try {
                    String[] memberMeta = this.getMemberMeta(modelCache, dimensions, data);
                    BigDecimal value = new BigDecimal(data.get("value"));
                    shrekOlapSave.add(memberMeta, (Object)value);
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                    errList.add(ImmutableMap.of((Object)"errData", data, (Object)"errMsg", (Object)e.getMessage()));
                }
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(ResManager.loadResFormat((String)"\u6570\u636e\u4fdd\u5b58\u5f02\u5e38\u3002%1", (String)"SyncBudgetDataService_03", (String)"epm-eb-business", (Object[])new Object[]{e.getMessage()}));
        }
        finally {
            stats.addInfo("end-syncActualData");
            log.info(stats.toString());
        }
        return errList;
    }

    private String[] getMemberMeta(IModelCacheHelper modelCache, List<Dimension> dimensions, Map<String, String> data) {
        Object[] memberMeta = new String[]{};
        for (Dimension dim : dimensions) {
            String dimNumber = dim.getNumber();
            String memberNubmer = data.get(dimNumber);
            if (SysDimensionEnum.Scenario.getNumber().equals(dimNumber)) {
                memberMeta = (String[])ArrayUtils.add((Object[])memberMeta, (Object)"NoScenario");
                continue;
            }
            if (SysDimensionEnum.Process.getNumber().equals(dimNumber)) {
                memberMeta = (String[])ArrayUtils.add((Object[])memberMeta, (Object)"IRpt");
                continue;
            }
            if (StringUtils.isBlank((CharSequence)memberNubmer)) {
                log.error("\u7f3a\u5931\u7ef4\u5ea6\uff1a" + dimNumber);
                throw new KDBizException(ResManager.loadResFormat((String)"\u7f3a\u5931\u7ef4\u5ea6(%1)", (String)"SyncBudgetDataService_02", (String)"epm-eb-business", (Object[])new Object[]{dimNumber}));
            }
            if (modelCache.getMember(dimNumber, null, memberNubmer) == null) {
                log.error("\u6210\u5458\u4e0d\u5b58\u5728\uff1a" + memberNubmer);
                throw new KDBizException(ResManager.loadResFormat((String)"\u6210\u5458\u4e0d\u5b58\u5728(%1)", (String)"SyncBudgetDataService_07", (String)"epm-eb-business", (Object[])new Object[]{memberNubmer}));
            }
            memberMeta = (String[])ArrayUtils.add((Object[])memberMeta, (Object)memberNubmer);
        }
        return memberMeta;
    }

    public List<DimensionResponse> getDimensionInfo(String json) {
        log.info("param:" + json);
        JSONObject jo = JSON.parseObject((String)json);
        String modelNumber = jo.getString("modelNumber");
        DynamicObject model = SyncCommonService.getInstance().getModelObj(modelNumber);
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)model.getLong("id"));
        List dimensions = modelCache.getDimensionList();
        return dimensions.stream().filter(e -> !ArrayUtils.contains((Object[])ignoreDim, (Object)e.getNumber())).map(e -> (DimensionResponse)Builder.of(DimensionResponse::new).with(DimensionResponse::setDimensionNumber, (Object)e.getNumber()).with(DimensionResponse::setGetDimensionName, (Object)e.getName()).build()).collect(Collectors.toList());
    }

    private static class InnerClass {
        private static SyncBudgetDataService instance = new SyncBudgetDataService();

        private InnerClass() {
        }
    }
}

