/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.apiservice;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.apiservice.entity.AcountMemberDto;
import kd.epm.eb.business.servicehelper.DimensionServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MemberSourceEnum;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.domain.ShrekConfig;
import kd.epm.eb.common.shrek.service.ShrekConfigServiceHelper;
import kd.epm.eb.common.utils.CubeUtils;
import org.apache.commons.lang3.StringUtils;

public class SyncMemberService {
    private static final Log log = LogFactory.getLog(SyncMemberService.class);

    public static SyncMemberService getInstance() {
        return InnerClass.instance;
    }

    private SyncMemberService() {
    }

    public void syncMember(String json) {
        log.info("param:" + json);
        JSONObject jo = JSON.parseObject((String)json);
        String modelNumber = jo.getString("modelNumber");
        String dimensionNumber = jo.getString("dimensionNumber");
        log.info("\u6839\u636emodelNubmer\u53d6modelId:" + modelNumber);
        DynamicObject model = QueryServiceHelper.queryOne((String)"epm_model", (String)"id", (QFilter[])new QFilter[]{new QFilter("shownumber", "=", (Object)modelNumber)});
        if (model == null) {
            log.error("\u4f53\u7cfb\u7f16\u7801\u4e0d\u5b58\u5728\uff1a" + modelNumber);
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u7f16\u7801\u4e0d\u5b58\u5728\u3002", (String)"SyncBudgetDataService_01", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        if (SysDimensionEnum.Account.getNumber().equals(dimensionNumber)) {
            List memberDtos = JSON.parseArray((String)jo.getString("members"), AcountMemberDto.class);
            if (memberDtos.isEmpty()) {
                log.warn("\u540c\u6b65\u6570\u636e\u4e3a\u7a7a");
                throw new KDBizException(ResManager.loadKDString((String)"\u540c\u6b65\u6570\u636e\u4e3a\u7a7a\u3002", (String)"SyncBudgetDataService_04", (String)"epm-eb-business", (Object[])new Object[0]));
            }
            log.info("memberDtos_size:" + memberDtos.size());
            this.syncAccount(dimensionNumber, memberDtos, model.getLong("id"));
        }
    }

    private void syncAccount(String dimensionNumber, List<AcountMemberDto> memberDtos, Long modelId) {
        log.info("syncAccount");
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Dimension dimension = modelCache.getDimension(dimensionNumber);
        List modelMembers = modelCache.getMembers(null, dimensionNumber);
        Map<String, Member> existMemberMap = modelMembers.stream().collect(Collectors.toMap(BaseCache::getNumber, e -> e));
        memberDtos = memberDtos.stream().filter(e -> !existMemberMap.containsKey(e.getNumber()) && StringUtils.isNotBlank((CharSequence)e.getNumber())).collect(Collectors.toList());
        log.info("\u8fc7\u6ee4\u6389\u5df2\u5b58\u5728\u7684\u6210\u5458:" + memberDtos.size());
        memberDtos.sort(Comparator.comparing(AcountMemberDto::getParentNumber));
        HashMap<String, AcountMemberDto> memMap = new HashMap<String, AcountMemberDto>(16);
        HashMap<Long, Integer> parentSeqMap = new HashMap<Long, Integer>(16);
        Iterator<AcountMemberDto> ite = memberDtos.iterator();
        while (ite.hasNext()) {
            AcountMemberDto dto = ite.next();
            dto.setId(DBServiceHelper.genGlobalLongId());
            if (StringUtils.isBlank((CharSequence)dto.getParentNumber())) {
                Member rootMember = modelCache.getMember(dimensionNumber, null, dimensionNumber);
                dto.setParentId(rootMember.getId());
                dto.setParentNumber(rootMember.getNumber());
                dto.setLongNumber(dimensionNumber + "!" + dto.getNumber());
                dto.setLevel(2);
                dto.setSeq(this.getSeq(rootMember.getId(), modelMembers, parentSeqMap));
            } else {
                Member member = existMemberMap.get(dto.getParentNumber());
                if (member != null) {
                    dto.setParentId(member.getId());
                    dto.setLongNumber(member.getLongNumber() + "!" + dto.getNumber());
                    dto.setLevel(member.getLevel() + 1);
                    dto.setSeq(this.getSeq(member.getId(), modelMembers, parentSeqMap));
                } else {
                    AcountMemberDto parent = (AcountMemberDto)memMap.get(dto.getParentNumber());
                    if (parent == null) {
                        log.warn("\u7236\u7f16\u7801\u6709\u8bef\uff0c\u5ffd\u7565\u6b64\u6210\u5458");
                        ite.remove();
                        continue;
                    }
                    dto.setParentId(parent.getId());
                    dto.setLongNumber(parent.getLongNumber() + "!" + dto.getNumber());
                    dto.setLevel(parent.getLevel() + 1);
                    dto.setSeq(this.getSeq(parent.getId(), modelMembers, parentSeqMap));
                }
            }
            memMap.put(dto.getNumber(), dto);
        }
        Set parentNumberSet = memberDtos.stream().map(AcountMemberDto::getParentNumber).collect(Collectors.toSet());
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(memberDtos.size());
        for (AcountMemberDto dto : memberDtos) {
            DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"epm_accountmembertree");
            obj.set("id", (Object)dto.getId());
            obj.set("masterid", (Object)dto.getId());
            obj.set("number", (Object)dto.getNumber());
            obj.set("name", (Object)dto.getName());
            obj.set("parent", (Object)dto.getParentId());
            obj.set("longnumber", (Object)dto.getLongNumber());
            obj.set("level", (Object)dto.getLevel());
            obj.set("dseq", (Object)dto.getSeq());
            obj.set("isleaf", (Object)(!parentNumberSet.contains(dto.getNumber()) ? 1 : 0));
            obj.set("membersource", (Object)MemberSourceEnum.FILE_IMPORT.getIndex());
            obj.set("aggoprt", (Object)dto.getAggoprt());
            obj.set("accounttype", (Object)dto.getAccountType());
            obj.set("drcrdirect", (Object)dto.getDrcrdirect());
            obj.set("status", (Object)"C");
            obj.set("enable", (Object)"1");
            obj.set("storagetype", (Object)"2");
            DimensionServiceHelper.initCommonDyObject(obj);
            DimensionServiceHelper.initDimensionAndModel(obj, modelId, dimension.getId());
            saveList.add(obj);
        }
        if (!saveList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[saveList.size()]));
            Set parentIdSet = memberDtos.stream().map(AcountMemberDto::getParentId).collect(Collectors.toSet());
            DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)("update t_eb_structofaccount set fisleaf = '0' where fid in ( " + parentIdSet.stream().map(e -> e + "").collect(Collectors.joining(",")) + " )"));
            Model model = modelCache.getModelobj();
            Dataset dataset = new Dataset(modelId, model.getNumber());
            ShrekOlapServiceHelper.updateDimension((Model)model, Collections.singletonList(dataset), (String)dimensionNumber, null, (ShrekConfig)ShrekConfigServiceHelper.getEBConfig());
            CubeUtils.get().checkDimension(modelId, dimension.getId());
        }
    }

    private int getSeq(Long parentId, List<Member> modelMembers, Map<Long, Integer> parentSeqMap) {
        Integer seq = parentSeqMap.get(parentId);
        if (seq != null) {
            Integer n = seq;
            Integer n2 = seq = Integer.valueOf(seq + 1);
        } else {
            List children = modelMembers.stream().filter(e -> e.getParentId().equals(parentId)).collect(Collectors.toList());
            if (children.isEmpty()) {
                seq = 1;
            } else {
                int currMax = children.stream().mapToInt(BaseCache::getSeq).max().getAsInt();
                seq = ++currMax;
            }
        }
        parentSeqMap.put(parentId, seq);
        return seq;
    }

    private static class InnerClass {
        private static SyncMemberService instance = new SyncMemberService();

        private InnerClass() {
        }
    }
}

