/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.apiservice;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.epm.eb.business.apiservice.SyncCommonService;
import kd.epm.eb.business.apiservice.entity.SyncQueryDataRequest;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.enums.FacTabFieldDefEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.shrek.controller.ShrekOlapReader;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.olap.api.base.IKDValue;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.eb.olap.impl.metadata.KDCell;
import org.apache.commons.collections4.CollectionUtils;

public class SyncQueryDataService {
    private static final Log log = LogFactory.getLog(SyncQueryDataService.class);

    public static SyncQueryDataService getInstance() {
        return InnerClass.instance;
    }

    private SyncQueryDataService() {
    }

    public List<Map<String, String>> query(String json) {
        log.info("param:" + json);
        SyncQueryDataRequest request = (SyncQueryDataRequest)JSON.parseObject((String)json, SyncQueryDataRequest.class);
        DynamicObject model = SyncCommonService.getInstance().getModelObj(request.getModelNumber());
        long modelId = model.getLong("id");
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List dimensions = modelCache.getDimensionList();
        Map<String, Set<String>> queryInfo = request.getQueryInfo();
        SelectCommandInfo sci = new SelectCommandInfo();
        for (Dimension dim : dimensions) {
            String dimNumber = dim.getNumber();
            Set<String> members = queryInfo.get(dimNumber);
            if (SysDimensionEnum.Scenario.getNumber().equals(dimNumber)) {
                sci.addFilter(dimNumber, new String[]{"NoScenario"});
                continue;
            }
            if (SysDimensionEnum.Process.getNumber().equals(dimNumber)) {
                sci.addFilter(dimNumber, new String[]{"IRpt"});
                continue;
            }
            if (CollectionUtils.isEmpty(members)) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u7ef4\u5ea6\u6210\u5458\u4e3a\u7a7a\uff1a%1\u3002", (String)"SyncBudgetDataService_05", (String)"epm-eb-business", (Object[])new Object[]{dimNumber}));
            }
            sci.addFilter(dimNumber, members.toArray(new String[members.size()]));
        }
        sci.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        sci.setDimensions(Arrays.asList(modelCache.getDimensionNums()));
        ArrayList<IKDCell> cells = new ArrayList<IKDCell>(10);
        try (ShrekOlapReader reader = ShrekOlapServiceHelper.queryReader((Model)modelCache.getModelobj(), (SelectCommandInfo)sci, (LogStats)new LogStats(this.getClass().getSimpleName()));){
            int count = 0;
            while (reader.hasNext()) {
                Object[] row = reader.next();
                IKDCell cell = KDCell.of((Object[])row);
                if (cell == null) continue;
                if (++count > 10000) {
                    cells.clear();
                    throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u8d85\u8fc710000\u6761", (String)"SyncBudgetDataService_06", (String)"epm-eb-business", (Object[])new Object[0]));
                }
                cells.add(cell);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(ResManager.loadResFormat((String)"\u6570\u636e\u4fdd\u5b58\u5f02\u5e38\u3002%1", (String)"SyncBudgetDataService_03", (String)"epm-eb-business", (Object[])new Object[]{e.getMessage()}));
        }
        return this.cellToMap(cells, dimensions);
    }

    private List<Map<String, String>> cellToMap(List<IKDCell> cells, List<Dimension> dimensionList) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>(16);
        for (IKDCell cell : cells) {
            LinkedHashMap<String, String> cellMap = new LinkedHashMap<String, String>(16);
            String[] number = cell.getMeta().getNumber();
            for (int i = 0; i < dimensionList.size(); ++i) {
                String srcDimNumber = dimensionList.get(i).getNumber();
                cellMap.put(srcDimNumber, number[i]);
            }
            IKDValue value = cell.getValue();
            cellMap.put("value", value == null ? "" : value.toString());
            list.add(cellMap);
        }
        return list;
    }

    private static class InnerClass {
        private static SyncQueryDataService instance = new SyncQueryDataService();

        private InnerClass() {
        }
    }
}

