/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.applybill.service;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.epm.eb.business.applybill.util.ApplyBillAggHelper;
import kd.epm.eb.business.applybill.util.BgApplyBillUtils;
import kd.epm.eb.common.applybill.DetailMembBillData;
import kd.epm.eb.common.applybill.EntityRowDataType;
import kd.epm.eb.common.applytemplatecolumn.BaseColumn;
import kd.epm.eb.common.applytemplatecolumn.ColumnEnum;
import kd.epm.eb.common.applytemplatecolumn.DataMapDimension;
import kd.epm.eb.common.applytemplatecolumn.DimensionColumn;
import kd.epm.eb.common.applytemplatecolumn.DimensionDataColumn;
import kd.epm.eb.common.applytemplatecolumn.DimensionMemberRange;
import kd.epm.eb.common.applytemplatecolumn.EntryTemplateConfig;
import kd.epm.eb.common.applytemplatecolumn.MeasureColumn;
import kd.epm.eb.common.applytemplatecolumn.RelationDimensionColumn;
import kd.epm.eb.common.applytemplatecolumn.RowDimensionColumn;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.FacTabFieldDefEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.examine.request.CheckRange;
import kd.epm.eb.common.examine.request.ReportCheckRange;
import kd.epm.eb.common.examine.request.ReportRelation;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.olap.api.dataSource.IKDOlapRequest;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.eb.olap.api.metadata.IKDCellMeta;
import kd.epm.eb.olap.impl.base.KDValue;
import kd.epm.eb.olap.impl.metadata.KDCell;
import kd.epm.eb.olap.impl.metadata.KDCellMeta;
import kd.epm.eb.olap.impl.utils.KDOlapRequestUtils;
import kd.epm.eb.olap.impl.utils.OlapCommandInfo;

public class ApplyBillServiceHelper {
    private static final ApplyBillServiceHelper instance = new ApplyBillServiceHelper();
    private static final Log logger = LogFactory.getLog(ApplyBillServiceHelper.class);

    public static ApplyBillServiceHelper getInstance() {
        return instance;
    }

    public List<Map<String, Object>> getApplyBillInitData(Long modelId, EntryTemplateConfig templateConfigModel, List<Map<String, String>> rowDimLists) {
        long startTime = System.currentTimeMillis();
        this.paramsValidator(modelId, templateConfigModel, rowDimLists);
        HashMap<String, Map> returnDatas = new HashMap<String, Map>(16);
        if (rowDimLists.size() == 0) {
            return new ArrayList<Map<String, Object>>(returnDatas.values());
        }
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)modelId);
        long datasetId = templateConfigModel.getDatasetId();
        Long busModelid = DatasetServiceHelper.getInstance().getBizModelIdByDataSetId(Long.valueOf(datasetId));
        Map viewsByBusModel = orCreate.getViewsByBusModel(busModelid);
        Map<String, Set<String>> rowDimMap = this.getRowDimMap(rowDimLists, orCreate, templateConfigModel, busModelid);
        Map<String, Integer> dimNumber2IndexMap = this.getDimNumber2IndexMap(orCreate.getDimensionList(Long.valueOf(datasetId)), new HashSet<String>(rowDimMap.keySet()));
        Map<String, String> dimNum2keyMap = this.getDimNum2keyMap(orCreate, templateConfigModel);
        Set<String> dimRelationship = this.getDimRelationship(rowDimLists, dimNumber2IndexMap);
        Map<String, String> hiddenDim2MemMap = templateConfigModel.getHiddenDimMemMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> orCreate.getMember((String)e.getKey(), (Long)viewsByBusModel.get(e.getKey()), (Long)e.getValue()).getNumber()));
        List measureColumnList = templateConfigModel.getEntryColumns().stream().filter(c -> "h".equals(c.getCategory()) && (c instanceof MeasureColumn || c instanceof DimensionDataColumn)).collect(Collectors.toList());
        Set<String> paramNumbers = rowDimLists.get(0).keySet();
        HashSet rowDimNumSet = new HashSet(templateConfigModel.getRowDimNums());
        HashMap<String, List> modelDataColsData = new HashMap<String, List>(16);
        HashMap<String, HashMap<String, String>> allRowDimMemberOnCol = new HashMap<String, HashMap<String, String>>(16);
        int i = 1;
        for (BaseColumn baseColumn : measureColumnList) {
            String valueKey = baseColumn.getKey();
            SelectCommandInfo queryInfo = this.getSelectCommandInfo(modelId, datasetId);
            HashMap<String, String> rowDimMemberOnCol = new HashMap<String, String>(16);
            allRowDimMemberOnCol.put(valueKey, rowDimMemberOnCol);
            List dataMapDimensions = new ArrayList(16);
            if (baseColumn instanceof MeasureColumn) {
                dataMapDimensions = ((MeasureColumn)baseColumn).getDataMapDimensions();
            } else if (baseColumn instanceof DimensionDataColumn) {
                dataMapDimensions = ((DimensionDataColumn)baseColumn).getDataMapDimensions();
                DimensionDataColumn dimensionDataColumn = (DimensionDataColumn)baseColumn;
                if (dimensionDataColumn.getOpenCalFormula() && StringUtils.isNotEmpty((CharSequence)dimensionDataColumn.getFormula())) continue;
            }
            for (DataMapDimension dataMapDimension : dataMapDimensions) {
                String dimNumber = orCreate.getDimension(Long.valueOf(dataMapDimension.getDimensionId())).getNumber();
                Member dimMember = orCreate.getMember(dimNumber, (Long)viewsByBusModel.get(dimNumber), Long.valueOf(dataMapDimension.getDimensionRememberId()));
                if (dimMember == null) continue;
                String memNumber = dimMember.getNumber();
                if (rowDimNumSet.contains(dimNumber)) {
                    rowDimMemberOnCol.put(dimNumber, memNumber);
                    continue;
                }
                queryInfo.addFilter(dimNumber, new String[]{memNumber});
            }
            for (Map.Entry entry : hiddenDim2MemMap.entrySet()) {
                queryInfo.addFilter((String)entry.getKey(), new String[]{(String)entry.getValue()});
            }
            for (Map.Entry entry : rowDimMap.entrySet()) {
                String dimNum = (String)entry.getKey();
                String memberNum = (String)rowDimMemberOnCol.get(dimNum);
                if (memberNum != null) {
                    queryInfo.addFilter((String)entry.getKey(), new String[]{memberNum});
                    continue;
                }
                queryInfo.addFilter((String)entry.getKey(), ((Set)entry.getValue()).toArray(new String[0]));
            }
            if (queryInfo.getFilter().size() < queryInfo.getDimensions().size()) continue;
            logger.info("initData: " + queryInfo);
            OlapCommandInfo[] olapCommandInfos = new OlapCommandInfo[]{OlapCommandInfo.of(null, (SelectCommandInfo)queryInfo)};
            IKDOlapRequest iKDOlapRequest = KDOlapRequestUtils.of((IModelCacheHelper)orCreate, (Long)modelId, (Long)busModelid, (Long)datasetId, null, (OlapCommandInfo[])olapCommandInfos, null, (boolean)false);
            iKDOlapRequest.getProperties().setPropertyValue("DATA_GET_ALL", KDValue.valueOf((String)Boolean.TRUE.toString()));
            long prepare = System.currentTimeMillis();
            logger.info("initData: " + i + " prepare data time is " + (prepare - startTime) + " ms");
            List<IKDCell> cells = this.queryOlap(iKDOlapRequest);
            long query = System.currentTimeMillis();
            logger.info("initData: " + i + " query data time is " + (query - startTime) + " ms");
            if (rowDimMemberOnCol.size() > 0 && cells.size() > 0) {
                modelDataColsData.put(valueKey, cells);
                cells = this.replace2RealRowDimMember(rowDimMemberOnCol, rowDimMap, dimNumber2IndexMap, cells);
            }
            for (IKDCell cell : cells) {
                Object value = cell.getValue().getValue();
                if (value == null || cell.getValue().isDecimal() && ((BigDecimal)value).compareTo(BigDecimal.ZERO) == 0) continue;
                String[] memNumbers = cell.getMeta().getNumber();
                LinkedHashMap<String, Long> data = new LinkedHashMap<String, Long>(16);
                StringJoiner sj = new StringJoiner("!");
                StringJoiner sj2 = new StringJoiner("!");
                for (Map.Entry<String, Integer> entry : dimNumber2IndexMap.entrySet()) {
                    String memNumber = memNumbers[entry.getValue()];
                    data.put(dimNum2keyMap.get(entry.getKey()), orCreate.getMember(entry.getKey(), (Long)viewsByBusModel.get(entry.getKey()), memNumber).getId());
                    sj2.add(memNumber);
                    if (!paramNumbers.contains(entry.getKey())) continue;
                    sj.add(memNumber);
                }
                if (!dimRelationship.contains(sj.toString())) continue;
                Map map = returnDatas.computeIfAbsent(sj2.toString(), v -> data);
                map.put(valueKey, value);
            }
        }
        if (modelDataColsData.size() > 0) {
            modelDataColsData.forEach((colKey, refCells) -> {
                Set refRowDimNums = ((Map)allRowDimMemberOnCol.get(colKey)).keySet();
                HashMap notCurrentColValMap = new HashMap(16);
                returnDatas.values().forEach(valMap -> {
                    if (!valMap.containsKey(colKey)) {
                        StringBuilder sb = new StringBuilder();
                        dimNum2keyMap.forEach((dimNum, rowDimColKey) -> {
                            if (!refRowDimNums.contains(dimNum)) {
                                Long memberId = (Long)valMap.get(rowDimColKey);
                                sb.append(orCreate.getMember(dimNum, (Long)viewsByBusModel.get(dimNum), memberId).getNumber()).append(',');
                            }
                        });
                        notCurrentColValMap.computeIfAbsent(sb.toString(), key -> new LinkedList()).add(valMap);
                    }
                });
                if (notCurrentColValMap.size() > 0) {
                    refCells.forEach(cell -> {
                        Object value = cell.getValue().getValue();
                        if (value == null) {
                            return;
                        }
                        if (cell.getValue().isDecimal() && ((BigDecimal)value).compareTo(BigDecimal.ZERO) == 0) {
                            return;
                        }
                        StringBuilder sb = new StringBuilder();
                        dimNum2keyMap.forEach((dimNum, rowDimColKey) -> {
                            if (!refRowDimNums.contains(dimNum)) {
                                String memberNum = cell.getMeta().getNumber()[(Integer)dimNumber2IndexMap.get(dimNum)];
                                sb.append(memberNum).append(',');
                            }
                        });
                        List refRowVals = (List)notCurrentColValMap.get(sb.toString());
                        if (refRowVals != null) {
                            refRowVals.forEach(rowVal -> rowVal.put(colKey, value));
                        }
                    });
                }
            });
        }
        long end = System.currentTimeMillis();
        logger.info("initData: all time is " + (end - startTime) + " ms");
        return new ArrayList<Map<String, Object>>(returnDatas.values());
    }

    public Map<String, Map<String, Object>> getApplyBillInitData(Long modelId, EntryTemplateConfig templateConfigModel, Map<String, Set<String>> rowDimMap, Set<String> dimDataColumns) {
        long startTime = System.currentTimeMillis();
        HashMap<String, Map<String, Object>> returnDatas = new HashMap<String, Map<String, Object>>(16);
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)modelId);
        long datasetId = templateConfigModel.getDatasetId();
        Long busModelid = DatasetServiceHelper.getInstance().getBizModelIdByDataSetId(Long.valueOf(datasetId));
        Map viewsByBusModel = orCreate.getViewsByBusModel(busModelid);
        Map<String, Integer> dimNumber2IndexMap = this.getDimNumber2IndexMap(orCreate.getDimensionList(Long.valueOf(datasetId)), new HashSet<String>(rowDimMap.keySet()));
        Map<String, String> dimNum2keyMap = this.getDimNum2keyMap(orCreate, templateConfigModel);
        Map<String, String> hiddenDim2MemMap = templateConfigModel.getHiddenDimMemMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> orCreate.getMember((String)e.getKey(), (Long)viewsByBusModel.get(e.getKey()), (Long)e.getValue()).getNumber()));
        List measureColumnList = templateConfigModel.getEntryColumns().stream().filter(c -> dimDataColumns.contains(c.getKey())).collect(Collectors.toList());
        HashSet rowDimNumSet = new HashSet(templateConfigModel.getRowDimNums());
        HashMap<String, List> modelDataColsData = new HashMap<String, List>(16);
        HashMap<String, HashMap<String, String>> allRowDimMemberOnCol = new HashMap<String, HashMap<String, String>>(16);
        int i = 1;
        for (BaseColumn baseColumn : measureColumnList) {
            String valueKey = baseColumn.getKey();
            SelectCommandInfo queryInfo = this.getSelectCommandInfo(modelId, datasetId);
            HashMap<String, String> rowDimMemberOnCol = new HashMap<String, String>(16);
            allRowDimMemberOnCol.put(valueKey, rowDimMemberOnCol);
            List dataMapDimensions = new ArrayList(16);
            if (baseColumn instanceof MeasureColumn) {
                dataMapDimensions = ((MeasureColumn)baseColumn).getDataMapDimensions();
            } else if (baseColumn instanceof DimensionDataColumn) {
                dataMapDimensions = ((DimensionDataColumn)baseColumn).getDataMapDimensions();
            }
            for (DataMapDimension dataMapDimension : dataMapDimensions) {
                String dimNumber = orCreate.getDimension(Long.valueOf(dataMapDimension.getDimensionId())).getNumber();
                Member dimMember = orCreate.getMember(dimNumber, (Long)viewsByBusModel.get(dimNumber), Long.valueOf(dataMapDimension.getDimensionRememberId()));
                if (dimMember == null) continue;
                String memNumber = dimMember.getNumber();
                if (rowDimNumSet.contains(dimNumber)) {
                    rowDimMemberOnCol.put(dimNumber, memNumber);
                    continue;
                }
                queryInfo.addFilter(dimNumber, new String[]{memNumber});
            }
            for (Map.Entry entry : hiddenDim2MemMap.entrySet()) {
                queryInfo.addFilter((String)entry.getKey(), new String[]{(String)entry.getValue()});
            }
            for (Map.Entry entry : rowDimMap.entrySet()) {
                String dimNum = (String)entry.getKey();
                String memberNum = (String)rowDimMemberOnCol.get(dimNum);
                if (memberNum != null) {
                    queryInfo.addFilter((String)entry.getKey(), new String[]{memberNum});
                    continue;
                }
                if (((Set)entry.getValue()).isEmpty()) continue;
                queryInfo.addFilter((String)entry.getKey(), ((Set)entry.getValue()).toArray(new String[0]));
            }
            logger.info("getApplyBillInitData.initData: " + queryInfo);
            OlapCommandInfo[] olapCommandInfos = new OlapCommandInfo[]{OlapCommandInfo.of(null, (SelectCommandInfo)queryInfo)};
            IKDOlapRequest iKDOlapRequest = KDOlapRequestUtils.of((IModelCacheHelper)orCreate, (Long)modelId, (Long)busModelid, (Long)datasetId, null, (OlapCommandInfo[])olapCommandInfos, null, (boolean)false);
            iKDOlapRequest.getProperties().setPropertyValue("DATA_GET_ALL", KDValue.valueOf((String)Boolean.TRUE.toString()));
            long prepare = System.currentTimeMillis();
            logger.info("getApplyBillInitData.initData: " + i + " prepare data time is " + (prepare - startTime) + " ms");
            List<IKDCell> cells = this.queryOlap(iKDOlapRequest);
            long query = System.currentTimeMillis();
            logger.info("getApplyBillInitData.initData: " + i + " query data time is " + (query - startTime) + " ms");
            if (rowDimMemberOnCol.size() > 0 && cells.size() > 0) {
                modelDataColsData.put(valueKey, cells);
                if (rowDimMap.keySet().containsAll(rowDimMemberOnCol.keySet())) {
                    cells = this.replace2RealRowDimMember(rowDimMemberOnCol, rowDimMap, dimNumber2IndexMap, cells);
                }
            }
            for (IKDCell cell : cells) {
                Object value = cell.getValue().getValue();
                if (value == null || cell.getValue().isDecimal() && ((BigDecimal)value).compareTo(BigDecimal.ZERO) == 0) continue;
                String[] memNumbers = cell.getMeta().getNumber();
                HashMap<String, Long> data = new HashMap<String, Long>(16);
                StringJoiner sj = new StringJoiner("!");
                StringJoiner sj2 = new StringJoiner("!");
                for (Map.Entry<String, Integer> entry : dimNumber2IndexMap.entrySet()) {
                    String memNumber = memNumbers[entry.getValue()];
                    data.put(dimNum2keyMap.get(entry.getKey()), orCreate.getMember(entry.getKey(), (Long)viewsByBusModel.get(entry.getKey()), memNumber).getId());
                    sj2.add(entry.getKey() + "#" + memNumber);
                }
                Map map = returnDatas.computeIfAbsent(sj2.toString(), v -> data);
                map.put(valueKey, value);
            }
        }
        if (modelDataColsData.size() > 0) {
            modelDataColsData.forEach((colKey, refCells) -> {
                Set refRowDimNums = ((Map)allRowDimMemberOnCol.get(colKey)).keySet();
                HashMap notCurrentColValMap = new HashMap(16);
                returnDatas.values().forEach(valMap -> {
                    if (!valMap.containsKey(colKey)) {
                        StringBuilder sb = new StringBuilder();
                        dimNum2keyMap.forEach((dimNum, rowDimColKey) -> {
                            if (!refRowDimNums.contains(dimNum)) {
                                Long memberId = (Long)valMap.get(rowDimColKey);
                                sb.append(orCreate.getMember(dimNum, (Long)viewsByBusModel.get(dimNum), memberId).getNumber()).append(',');
                            }
                        });
                        notCurrentColValMap.computeIfAbsent(sb.toString(), key -> new LinkedList()).add(valMap);
                    }
                });
                if (notCurrentColValMap.size() > 0) {
                    refCells.forEach(cell -> {
                        Object value = cell.getValue().getValue();
                        if (value == null) {
                            return;
                        }
                        if (cell.getValue().isDecimal() && ((BigDecimal)value).compareTo(BigDecimal.ZERO) == 0) {
                            return;
                        }
                        StringBuilder sb = new StringBuilder();
                        dimNum2keyMap.forEach((dimNum, rowDimColKey) -> {
                            if (!refRowDimNums.contains(dimNum)) {
                                String memberNum = cell.getMeta().getNumber()[(Integer)dimNumber2IndexMap.get(dimNum)];
                                sb.append(memberNum).append(',');
                            }
                        });
                        List refRowVals = (List)notCurrentColValMap.get(sb.toString());
                        if (refRowVals != null) {
                            refRowVals.forEach(rowVal -> rowVal.put(colKey, value));
                        }
                    });
                }
            });
        }
        long end = System.currentTimeMillis();
        logger.info("getApplyBillInitData.initData: all time is " + (end - startTime) + " ms");
        return returnDatas;
    }

    public ReportCheckRange getReportCheckRang(List<Object[]> entityData, EntryTemplateConfig templateConfig, Long modelId, Map<String, Long> CVDMembIds, Long billId, Boolean isApplyBill, boolean showsubtotal) {
        if (entityData == null || entityData.isEmpty()) {
            return null;
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        DetailMembBillData sourceData = new DetailMembBillData();
        long busModelid = templateConfig.getDatasetId();
        Long bizCtrlRangeId = DatasetServiceHelper.getInstance().getBizModelIdByDataSetId(Long.valueOf(busModelid));
        Map viewIds = modelCacheHelper.getViewsByBusModel(bizCtrlRangeId);
        Map<String, Map<String, Set<Long>>> groupMembsByStats = ApplyBillAggHelper.getInstance().initDetailDataGroup(sourceData, entityData, modelCacheHelper, viewIds, BigDecimal.ONE, templateConfig);
        if (groupMembsByStats.size() < 0) {
            return null;
        }
        ArrayList<BaseColumn> measureCols = new ArrayList<BaseColumn>(16);
        ArrayList<BaseColumn> dimensionCols = new ArrayList<BaseColumn>(16);
        List entryColumns = templateConfig.getEntryColumns();
        List columns = entryColumns.stream().filter(ee -> !ee.getKey().endsWith("_text")).collect(Collectors.toList());
        for (BaseColumn column : columns) {
            if (column.getType() == ColumnEnum.Dimension || column.getType() == ColumnEnum.RelationDimension || column.getType() == ColumnEnum.RowDimension) {
                dimensionCols.add(column);
                continue;
            }
            if (column.getType() != ColumnEnum.Measure && column.getType() != ColumnEnum.DimensionData) continue;
            measureCols.add(column);
        }
        Map columnIndexes = templateConfig.getColumnIndex();
        Map<String, Map<String, String>> allColDimMembers = BgApplyBillUtils.getInstance().getAllColDimMembers(measureCols, viewIds, modelCacheHelper, (Boolean)true);
        HashMap<String, Integer> rowDimColumnIndex = new HashMap<String, Integer>(16);
        ArrayList<Map<String, String>> subtotalDimDatas = new ArrayList<Map<String, String>>(16);
        dimensionCols.forEach(e -> {
            Integer cfr_ignored_0 = (Integer)rowDimColumnIndex.put(BgApplyBillUtils.getInstance().getDimOrRelateDimNumber((BaseColumn)e, modelCacheHelper), (Integer)columnIndexes.get(e.getKey()));
        });
        ArrayList<Map<String, Set<String>>> allRowDimMembers = new ArrayList<Map<String, Set<String>>>(16);
        for (int i = 0; i < entityData.size(); ++i) {
            Object[] data = entityData.get(i);
            String dataType = (String)data[3];
            if (!EntityRowDataType.isDetailData((String)dataType)) continue;
            HashMap rowMemMap = new HashMap(16);
            HashMap rowMemberMap = new HashMap(16);
            HashMap hashMap = new HashMap(16);
            rowDimColumnIndex.forEach((key, value) -> {
                Object memberId = data[value];
                Set members = rowMemberMap.computeIfAbsent(key, e -> new HashSet(16));
                Member member = modelCacheHelper.getMember(key, (Long)viewIds.get(key), IDUtils.toLong((Object)memberId));
                if (member != null) {
                    members.add(member);
                    detailDim.put(key, member.getNumber());
                }
            });
            if (showsubtotal) {
                subtotalDimDatas.add(hashMap);
            }
            rowMemberMap.forEach((key, value) -> {
                Set memNums = rowMemMap.computeIfAbsent(key, e -> new HashSet(16));
                memNums.addAll(value.stream().map(x -> x.getNumber()).collect(Collectors.toSet()));
            });
            allRowDimMembers.add(rowMemMap);
        }
        ArrayList converSubTotalRowDims = new ArrayList(16);
        ArrayList<Map<String, String>> converSubTotalRowDims2 = new ArrayList<Map<String, String>>(16);
        if (!subtotalDimDatas.isEmpty()) {
            Map sourceMap = (Map)subtotalDimDatas.get(0);
            List<Map<String, String>> subtotalRowDims = BgApplyBillUtils.getSubtotalRowDims(templateConfig, modelCacheHelper, subtotalDimDatas);
            for (Map map : subtotalRowDims) {
                HashMap convertMap = new HashMap(16);
                HashMap convertMap2 = new HashMap(16);
                for (Map.Entry stringStringEntry : sourceMap.entrySet()) {
                    convertMap.put(stringStringEntry.getKey(), new HashSet(Collections.singletonList(map.get(stringStringEntry.getKey()))));
                    convertMap2.put(stringStringEntry.getKey(), map.get(stringStringEntry.getKey()));
                }
                converSubTotalRowDims.add(convertMap);
                converSubTotalRowDims2.add(convertMap2);
            }
            if (!subtotalRowDims.isEmpty()) {
                allRowDimMembers.addAll(converSubTotalRowDims);
            }
        }
        if (!isApplyBill.booleanValue()) {
            this.getAllFirstRow(templateConfig, groupMembsByStats, sourceData, allRowDimMembers);
        }
        Map<String, String> hideDimMembers = BgApplyBillUtils.getInstance().getHideDimMembersFromTempConfig(modelCacheHelper, templateConfig);
        HashMap<String, Set<String>> dimGroups = new HashMap<String, Set<String>>(16);
        BgApplyBillUtils.getInstance().mergeMap(hideDimMembers, dimGroups);
        allRowDimMembers.forEach(e -> BgApplyBillUtils.getInstance().mergeMap2((Map<String, Set<String>>)e, (Map<String, Set<String>>)dimGroups));
        allColDimMembers.values().forEach(e -> BgApplyBillUtils.getInstance().mergeMap((Map<String, String>)e, (Map<String, Set<String>>)dimGroups));
        List dimensionList = modelCacheHelper.getDimensionList(Long.valueOf(templateConfig.getDatasetId()));
        if (allColDimMembers.size() == 0 || allRowDimMembers.size() == 0) {
            return null;
        }
        Map<String, String> map = BgApplyBillUtils.getInstance().getDefaultAddDimMembers2(dimensionList, hideDimMembers, allColDimMembers.values().iterator().next(), (Map)allRowDimMembers.get(0));
        BgApplyBillUtils.getInstance().mergeMap(map, dimGroups);
        ReportCheckRange reportCheckRange = new ReportCheckRange();
        reportCheckRange.setBizModelId(bizCtrlRangeId);
        Map viewsByDataSet = modelCacheHelper.getViewsByDataSet(Long.valueOf(templateConfig.getDatasetId()));
        reportCheckRange.setDatasetId(Long.valueOf(templateConfig.getDatasetId()));
        reportCheckRange.setTemplateId(Long.valueOf(templateConfig.getTemplateID()));
        reportCheckRange.setReportProcessId(billId);
        ArrayList<CheckRange> mapList = new ArrayList<CheckRange>(16);
        ArrayList<ReportRelation> reportRelationList = new ArrayList<ReportRelation>(16);
        this.getReportRelation(entityData, rowDimColumnIndex, viewIds, modelCacheHelper, reportRelationList, isApplyBill, converSubTotalRowDims2, allColDimMembers.values());
        ReportRelation reportRelation = new ReportRelation();
        ArrayList<String[]> memberRelationList = new ArrayList<String[]>(16);
        Set colDimNums = templateConfig.getColDimNums();
        for (Map<String, String> stringMap : allColDimMembers.values()) {
            HashMap<String, String> map2 = new HashMap<String, String>(stringMap);
            map2.entrySet().removeIf(entry -> !colDimNums.contains(entry.getKey()));
            reportRelation.setDimNumbers(map2.keySet().toArray(new String[0]));
            String[] array = map2.values().toArray(new String[0]);
            memberRelationList.add(array);
        }
        reportRelation.setMemberRelationList(memberRelationList);
        reportRelationList.add(reportRelation);
        mapList.add(new CheckRange(1, viewsByDataSet, dimGroups, reportRelationList));
        reportCheckRange.setCheckRangeList(mapList);
        return reportCheckRange;
    }

    private void getReportRelation(List<Object[]> entityData, Map<String, Integer> rowDimColumnIndex, Map<String, Long> viewIds, IModelCacheHelper modelCacheHelper, List<ReportRelation> reportRelationList, Boolean isApplyBill, List<Map<String, String>> converSubTotalRowDims, Collection<Map<String, String>> colDimMap) {
        String[] array;
        ArrayList allRowDimMembers = new ArrayList(16);
        for (int i = 0; i < entityData.size(); ++i) {
            Object[] data = entityData.get(i);
            String dataType = (String)data[3];
            if (!EntityRowDataType.isDetailData((String)dataType)) continue;
            HashMap hashMap = new HashMap(16);
            rowDimColumnIndex.forEach((key, value) -> {
                Long memberId = (Long)data[value];
                Member member = modelCacheHelper.getMember(key, (Long)viewIds.get(key), IDUtils.toLong((Object)memberId));
                if (member != null) {
                    rowMemMap.put(key, member.getNumber());
                }
            });
            allRowDimMembers.add(hashMap);
        }
        ReportRelation reportRelation = new ReportRelation();
        ArrayList<String[]> memberRelationList = new ArrayList<String[]>(16);
        for (Map map : allRowDimMembers) {
            reportRelation.setDimNumbers(map.keySet().toArray(new String[0]));
            array = map.values().toArray(new String[0]);
            memberRelationList.add(array);
        }
        if (isApplyBill.booleanValue() && !converSubTotalRowDims.isEmpty()) {
            for (Map map : converSubTotalRowDims) {
                array = map.values().toArray(new String[0]);
                memberRelationList.add(array);
            }
        }
        if (!isApplyBill.booleanValue()) {
            for (Map map : allRowDimMembers) {
                int size = map.size();
                for (int i = 0; i < size; ++i) {
                    ArrayList DimNumList = new ArrayList(map.keySet());
                    String DimNum = (String)DimNumList.get(i);
                    String memNum = (String)map.get(DimNum);
                    HashMap subMap = new HashMap(map);
                    subMap.remove(DimNum);
                    List[] memParents = new List[size];
                    memParents[i] = Collections.singletonList(memNum);
                    for (int m = 0; m < subMap.size(); ++m) {
                        ArrayList memNumList = new ArrayList(subMap.keySet());
                        String subKey = (String)memNumList.get(m);
                        String value2 = (String)subMap.get(subKey);
                        Long viewId = viewIds.get(subKey);
                        Member member = modelCacheHelper.getMember(subKey, viewId, value2);
                        if (member == null) continue;
                        List parents = modelCacheHelper.getParents(viewId, member, false);
                        ArrayList<String> list = new ArrayList<String>(parents.size());
                        if (!parents.isEmpty()) {
                            for (Member parent : parents) {
                                if (parent.getNumber() == null) continue;
                                list.add(parent.getNumber());
                            }
                        }
                        if (memParents[m] == null) {
                            memParents[m] = list;
                            continue;
                        }
                        memParents[m + 1] = list;
                    }
                    boolean hasNull = true;
                    for (List element : memParents) {
                        if (element != null) continue;
                        hasNull = false;
                        break;
                    }
                    if (!hasNull) continue;
                    ApplyBillServiceHelper.arrangeCombine(memParents, new ArrayList<Object>(), 0, memberRelationList);
                }
            }
        }
        reportRelation.setMemberRelationList(memberRelationList);
        reportRelationList.add(reportRelation);
    }

    public static void arrangeCombine(List<?>[] arrays, List<Object> tempRes, int depth, List<String[]> results) {
        if (depth == arrays.length) {
            String[] result = new String[tempRes.size()];
            for (int i = 0; i < tempRes.size(); ++i) {
                result[i] = tempRes.get(i).toString();
            }
            results.add(result);
            return;
        }
        List<?> currentArray = arrays[depth];
        for (int i = 0; i < currentArray.size(); ++i) {
            tempRes.add(currentArray.get(i));
            ApplyBillServiceHelper.arrangeCombine(arrays, tempRes, depth + 1, results);
            tempRes.remove(tempRes.size() - 1);
        }
    }

    protected List<Map<String, String>> getAllFirstRow(EntryTemplateConfig templateConfig, Map<String, Map<String, Set<Long>>> groupMembsByStats, DetailMembBillData detailMembBillData, List<Map<String, Set<String>>> allRowDimMembers) {
        ArrayList<Map<String, String>> allFirstRow = new ArrayList<Map<String, String>>(16);
        for (Map.Entry<String, Map<String, Set<Long>>> entry : groupMembsByStats.entrySet()) {
            Map<String, Set<Long>> dimsMembId = entry.getValue();
            if (entry.getKey().length() > 0) {
                String[] membIds = entry.getKey().split(",");
                for (int i = 0; i < membIds.length; ++i) {
                    HashSet<Long> ids = new HashSet<Long>(1);
                    ids.add(Long.valueOf(membIds[i]));
                    dimsMembId.put((String)templateConfig.getNotTreeDimKeys().get(i), (Set<Long>)ids);
                }
            }
            Map<String, String> sameParentNum = this.getSameParentNum(templateConfig, dimsMembId);
            this.replateFirstRowMemb(sameParentNum, templateConfig, dimsMembId, allRowDimMembers);
            if (sameParentNum.isEmpty()) continue;
            allFirstRow.add(sameParentNum);
        }
        return allFirstRow;
    }

    private void replateFirstRowMemb(Map<String, String> sameParentNum, EntryTemplateConfig templateConfig, Map<String, Set<Long>> dimsMembId, List<Map<String, Set<String>>> allRowDimMembers) {
        if (sameParentNum.isEmpty()) {
            return;
        }
        List notTreeDimKeys = templateConfig.getNotTreeDimKeys();
        Map columnMapDimNum = templateConfig.selectColumnMapDimNum();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)templateConfig.getModelId());
        Map viewsByDataSet = modelCacheHelper.getViewsByDataSet(Long.valueOf(templateConfig.getDatasetId()));
        HashMap<String, Set> dimMembers = new HashMap<String, Set>();
        allRowDimMembers.add(dimMembers);
        for (String dimColumnKey : templateConfig.getDimKeysList()) {
            Member parent;
            Long membId;
            Member member;
            Set<Long> detailMembIds;
            String dimNum;
            if (notTreeDimKeys.contains(dimColumnKey) || (dimNum = (String)columnMapDimNum.get(dimColumnKey)) == null || (detailMembIds = dimsMembId.get(dimColumnKey)) == null) continue;
            Set memNums = dimMembers.computeIfAbsent(dimNum, e -> new HashSet(16));
            SysDimensionEnum enumByNumber = SysDimensionEnum.getEnumByNumber((String)dimNum);
            Long viewId = (Long)viewsByDataSet.get(dimNum);
            if (enumByNumber == null || enumByNumber.getMemberTreemodel().equals("epm_userdefinedmembertree")) {
                for (Long memId : detailMembIds) {
                    Member member2 = modelCacheHelper.getMember(dimNum, viewId, memId);
                    if (member2 == null) continue;
                    List parents = modelCacheHelper.getParents(viewId, member2, true);
                    memNums.addAll(parents.stream().map(x -> x.getNumber()).collect(Collectors.toSet()));
                }
                sameParentNum.put(dimColumnKey, dimNum);
                continue;
            }
            if (detailMembIds == null) continue;
            if (detailMembIds.size() == 1 && (member = modelCacheHelper.getMember(dimNum, viewId, membId = detailMembIds.iterator().next())) != null && (parent = modelCacheHelper.getMember(dimNum, viewId, member.getParentId())) != null) {
                sameParentNum.put(dimColumnKey, parent.getNumber());
            }
            String parentNum = sameParentNum.get(dimColumnKey);
            Member parent2 = modelCacheHelper.getMember(dimNum, viewId, parentNum);
            for (Long memId : detailMembIds) {
                Member member3 = modelCacheHelper.getMember(dimNum, viewId, memId);
                if (member3 == null) continue;
                List parents = modelCacheHelper.getParents(viewId, member3, true);
                memNums.addAll(parents.stream().filter(x -> x.getLevel() >= parent2.getLevel()).map(x -> x.getNumber()).collect(Collectors.toSet()));
            }
        }
    }

    private Map<String, String> getSameParentNum(EntryTemplateConfig templateConfig, Map<String, Set<Long>> detailRowMembIds) {
        HashMap<String, String> sameParentNums = new HashMap<String, String>(16);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)templateConfig.getModelId());
        for (Map.Entry<String, Set<Long>> rowMembIds : detailRowMembIds.entrySet()) {
            String dimNum = (String)templateConfig.selectColumnMapDimNum().get(rowMembIds.getKey());
            Long viewId = modelCacheHelper.getViewByDataSetAndDimNumber(Long.valueOf(templateConfig.getDatasetId()), dimNum);
            List<String> parentNums = new ArrayList<String>(16);
            boolean isInit = true;
            for (Long membId : rowMembIds.getValue()) {
                Member member = modelCacheHelper.getMember(dimNum, viewId, membId);
                if (member == null || !member.isLeaf()) continue;
                String[] membNums = member.getLongNumber().split("!");
                int index = 0;
                for (String number : membNums) {
                    if (number.equals("")) continue;
                    if (isInit) {
                        parentNums.add(number);
                        continue;
                    }
                    if (index >= parentNums.size()) break;
                    String num = (String)parentNums.get(index);
                    if (!num.equals(number)) {
                        parentNums = parentNums.subList(0, index);
                        break;
                    }
                    ++index;
                }
                if (!isInit) continue;
                isInit = false;
            }
            if (parentNums.isEmpty()) {
                sameParentNums.clear();
                return sameParentNums;
            }
            sameParentNums.put(rowMembIds.getKey(), (String)parentNums.get(parentNums.size() - 1));
        }
        return sameParentNums;
    }

    private List<IKDCell> replace2RealRowDimMember(Map<String, String> rowDimMemberOnCol, Map<String, Set<String>> rowDimMemberMap, Map<String, Integer> dimNumber2IndexMap, List<IKDCell> cells) {
        boolean hasOrgAndAccount = false;
        LinkedList<IKDCell> newCellList = new LinkedList<IKDCell>();
        cells.forEach(cell -> {
            String[] numbers = cell.getMeta().getNumber();
            KDCell newCell = new KDCell((IKDCellMeta)new KDCellMeta(Arrays.copyOf(numbers, numbers.length)));
            newCell.setValue(cell.getValue());
            newCellList.add((IKDCell)newCell);
        });
        for (String dimNum : rowDimMemberOnCol.keySet()) {
            int endIndex = newCellList.size();
            int dimIndex = dimNumber2IndexMap.get(dimNum);
            for (int index = 0; index < endIndex; ++index) {
                IKDCell cCell = (IKDCell)newCellList.get(index);
                Set<String> realMemberNums = rowDimMemberMap.get(dimNum);
                if (realMemberNums == null || realMemberNums.isEmpty()) continue;
                boolean firstMember = true;
                for (String membNum : realMemberNums) {
                    String[] dimNumbers = cCell.getMeta().getNumber();
                    if (firstMember) {
                        dimNumbers[dimIndex] = membNum;
                        firstMember = false;
                        continue;
                    }
                    String[] newDimNumbers = Arrays.copyOf(dimNumbers, dimNumbers.length);
                    newDimNumbers[dimIndex] = membNum;
                    KDCell newCell = new KDCell((IKDCellMeta)new KDCellMeta(newDimNumbers));
                    newCell.setValue(cCell.getValue());
                    newCellList.add((IKDCell)newCell);
                }
            }
        }
        return newCellList;
    }

    private void paramsValidator(Long modelId, EntryTemplateConfig templateConfigModel, List<Map<String, String>> rowDimLists) {
        if (modelId == null || modelId == 0L) {
            throw new KDBizException("modelId is null or 0.");
        }
        if (templateConfigModel == null) {
            throw new KDBizException("template object is null.");
        }
        if (rowDimLists == null) {
            throw new KDBizException("row dimension data is null.");
        }
    }

    public Map<String, Set<String>> getRowDimMap(List<Map<String, String>> lists, IModelCacheHelper modelCacheHelper, EntryTemplateConfig templateConfigModel, long busmodelid) {
        HashMap<String, Set<String>> data = new HashMap<String, Set<String>>(16);
        for (Map<String, String> map : lists) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                Set set = data.computeIfAbsent(entry.getKey(), d -> new HashSet(16));
                set.add(entry.getValue());
            }
        }
        Map viewsByBusModel = modelCacheHelper.getViewsByBusModel(Long.valueOf(busmodelid));
        for (BaseColumn c : templateConfigModel.getEntryColumns()) {
            Dimension dimension;
            String number;
            if (!"h".equals(c.getCategory())) continue;
            Long dimensionId = 0L;
            List dimensionMemberRanges = null;
            if (c instanceof DimensionColumn) {
                dimensionId = ((DimensionColumn)c).getDimensionId();
                dimensionMemberRanges = ((DimensionColumn)c).getDimensionMemberRanges();
            } else if (c instanceof RelationDimensionColumn) {
                dimensionId = ((RelationDimensionColumn)c).getDimensionId();
            } else if (c instanceof RowDimensionColumn) {
                dimensionId = ((RowDimensionColumn)c).getDimensionId();
                dimensionMemberRanges = ((RowDimensionColumn)c).getDimensionMemberRanges();
            }
            if (dimensionId == 0L || data.containsKey(number = (dimension = modelCacheHelper.getDimension(dimensionId)).getNumber())) continue;
            Long viewId = (Long)viewsByBusModel.get(number);
            if (dimensionMemberRanges != null) {
                HashSet memberNums = new HashSet(16);
                this.selMemberByDimColRange(modelCacheHelper, number, viewId, dimensionMemberRanges, member -> {
                    if (member.isLeaf()) {
                        memberNums.add(member.getNumber());
                    }
                });
                data.put(number, memberNums);
                continue;
            }
            if (IDUtils.isNotNull((Long)viewId)) {
                data.put(number, dimension.getView(viewId).getLeafMembers().stream().map(BaseCache::getNumber).collect(Collectors.toSet()));
                continue;
            }
            data.put(number, dimension.getLeafMembers().stream().map(BaseCache::getNumber).collect(Collectors.toSet()));
        }
        return data;
    }

    public void selMemberByDimColRange(IModelCacheHelper modelCacheHelper, String dimensionNumber, Long viewId, List<DimensionMemberRange> dimensionMemberRanges, Consumer<Member> memberConsumer) {
        if (dimensionMemberRanges != null && !dimensionMemberRanges.isEmpty()) {
            for (DimensionMemberRange dimensionMemberRange : dimensionMemberRanges) {
                int range;
                String memberNumber = dimensionMemberRange.getNumber();
                List members = modelCacheHelper.getMember(dimensionNumber, viewId, memberNumber, range = Integer.parseInt(dimensionMemberRange.getScope()));
                if (members == null || members.isEmpty()) continue;
                for (Member member : members) {
                    memberConsumer.accept(member);
                }
            }
        }
    }

    private Set<String> getDimRelationship(List<Map<String, String>> rowDimLists, Map<String, Integer> dimNumber2IndexMap) {
        HashSet<String> dimRelationship = new HashSet<String>(16);
        int size = dimNumber2IndexMap.size();
        ArrayList<String> str = new ArrayList<String>(size);
        for (Map<String, String> map : rowDimLists) {
            for (Map.Entry<String, Integer> entry : dimNumber2IndexMap.entrySet()) {
                String s = map.get(entry.getKey());
                if (s == null) continue;
                str.add(s);
            }
            dimRelationship.add(String.join((CharSequence)"!", str));
            str.clear();
        }
        return dimRelationship;
    }

    private SelectCommandInfo getSelectCommandInfo(Long modelId, Long dataSetId) {
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)modelId);
        List dimensionList = orCreate.getDimensionList(dataSetId);
        String[] dims = (String[])dimensionList.stream().map(BaseCache::getNumber).toArray(String[]::new);
        SelectCommandInfo queryInfo = new SelectCommandInfo();
        queryInfo.addDims(dims);
        queryInfo.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        return queryInfo;
    }

    private Map<String, Integer> getDimNumber2IndexMap(List<Dimension> dimensionList, Set<String> rowDimNumbers) {
        LinkedHashMap dimNumber2IndexMap = Maps.newLinkedHashMapWithExpectedSize((int)rowDimNumbers.size());
        for (int i = 0; i < dimensionList.size(); ++i) {
            String dimNumber = dimensionList.get(i).getNumber();
            if (rowDimNumbers.size() == 0) break;
            if (!rowDimNumbers.remove(dimNumber)) continue;
            dimNumber2IndexMap.put(dimNumber, i);
        }
        return dimNumber2IndexMap;
    }

    private Map<String, String> getDimNum2keyMap(IModelCacheHelper orCreate, EntryTemplateConfig templateConfigModel) {
        HashMap<String, String> dimNum2keyMap = new HashMap<String, String>(16);
        for (BaseColumn b : templateConfigModel.getEntryColumns()) {
            if ("e".equals(b.getCategory())) continue;
            if (b instanceof DimensionColumn) {
                dimNum2keyMap.put(((DimensionColumn)b).getDimNumber(), b.getKey());
                continue;
            }
            if (b instanceof RelationDimensionColumn) {
                dimNum2keyMap.put(orCreate.getDimension(Long.valueOf(((RelationDimensionColumn)b).getDimensionId())).getNumber(), b.getKey());
                continue;
            }
            if (!(b instanceof RowDimensionColumn)) continue;
            dimNum2keyMap.put(((RowDimensionColumn)b).getDimNumber(), b.getKey());
        }
        return dimNum2keyMap;
    }

    private List<IKDCell> queryOlap(IKDOlapRequest request) {
        return (List)DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"OlapService", (String)"get", (Object[])new Object[]{request});
    }
}

