/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.applybill.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.applytemplatecolumn.BaseColumn;
import kd.epm.eb.common.applytemplatecolumn.BgApplyENtryInfo;
import kd.epm.eb.common.applytemplatecolumn.ColumnEnum;
import kd.epm.eb.common.applytemplatecolumn.DimensionColumn;
import kd.epm.eb.common.applytemplatecolumn.EntryTemplateConfig;
import kd.epm.eb.common.applytemplatecolumn.RelationDimensionColumn;
import kd.epm.eb.common.applytemplatecolumn.RowDimensionColumn;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dimension.multidimrelation.domain.BillAllMultiRelationDomain;
import kd.epm.eb.common.dimension.multidimrelation.dto.MultiDimRelationColumn;
import kd.epm.eb.common.dimension.multidimrelation.dto.MultiDimRelationItem;
import kd.epm.eb.common.dimension.multidimrelation.dto.MultiDimRelationMember;
import kd.epm.eb.common.dimension.multidimrelation.dto.MultiDimRelationScheme;

public class MultiDimRelationService {
    private static final MultiDimRelationService INSTANCE = new MultiDimRelationService();

    private MultiDimRelationService() {
    }

    public static MultiDimRelationService getInstance() {
        return INSTANCE;
    }

    public BillAllMultiRelationDomain getMultiDimRelationList(BgApplyENtryInfo bgApplyENtryInfo, Long modelId) {
        BillAllMultiRelationDomain billAllMultiRelation = new BillAllMultiRelationDomain();
        if (bgApplyENtryInfo == null) {
            return billAllMultiRelation;
        }
        Map entryTemplateConfig = bgApplyENtryInfo.getEntryTemplateConfig();
        HashMap entryconfiginfo = new HashMap(16);
        for (Map.Entry entry : entryTemplateConfig.entrySet()) {
            entryconfiginfo.put(entry.getKey(), ((EntryTemplateConfig)entry.getValue()).getEntryColumns());
        }
        ArrayList<MultiDimRelationScheme> schemeList = new ArrayList<MultiDimRelationScheme>(16);
        ArrayList<String> mainRelationColumnKeyList = new ArrayList<String>(16);
        ArrayList<String> relationColumnKeyList = new ArrayList<String>(16);
        HashMap<String, MultiDimRelationScheme> schemeMap = new HashMap<String, MultiDimRelationScheme>(16);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        billAllMultiRelation.setBillAllMultiDimMainColumnRelation(schemeList);
        billAllMultiRelation.setMainRelationColumnKeyList(mainRelationColumnKeyList);
        billAllMultiRelation.setRelationColumnKeyList(relationColumnKeyList);
        billAllMultiRelation.setSchemeMap(schemeMap);
        for (Map.Entry next : entryconfiginfo.entrySet()) {
            String mapKey = (String)next.getKey();
            List list = (List)next.getValue();
            EntryTemplateConfig templateConfig = (EntryTemplateConfig)entryTemplateConfig.get(mapKey);
            Map viewIds = modelCacheHelper.getViewsByDataSet(Long.valueOf(templateConfig.getDatasetId()));
            for (BaseColumn column : list) {
                long dimensionBussSchemeId;
                DynamicObject multiDimRelationSchemeObj;
                RelationDimensionColumn column4;
                String dimensionrelationidtype;
                ColumnEnum type = column.getType();
                int value = type.getValue();
                if (value != 4 || !StringUtils.equals((CharSequence)(dimensionrelationidtype = (column4 = (RelationDimensionColumn)column).getDimensionrelationidtype()), (CharSequence)"epm_multidimrelation") || (multiDimRelationSchemeObj = this.getMultiDimRelationScheme(dimensionBussSchemeId = column4.getDimensionBussSchemeId())) == null) continue;
                DynamicObjectCollection schemeDimCollection = multiDimRelationSchemeObj.getDynamicObjectCollection("entryentity");
                String mainDim = "";
                HashMap<String, Long> dimNumberIdMap = new HashMap<String, Long>(16);
                HashMap<String, String> dimKeyMap = new HashMap<String, String>(16);
                for (DynamicObject dynamicObject : schemeDimCollection) {
                    String dimNumber = dynamicObject.getDynamicObject("dimension").getString("number");
                    String isMainDim = dynamicObject.getString("ismaindim");
                    long dimensionId = dynamicObject.getLong("dimension_id");
                    dimNumberIdMap.put(dimNumber, dimensionId);
                    String relationDimKey = this.getDimensionColumnKey(list, dimensionId);
                    if (StringUtils.equals((CharSequence)"1", (CharSequence)isMainDim)) {
                        mainDim = dimNumber;
                    } else if (mapKey.startsWith("biz")) {
                        List bizList = (List)entryconfiginfo.get(mapKey.replace("biz", ""));
                        relationDimKey = this.getDimensionColumnKey(bizList, dimensionId);
                    }
                    if (StringUtils.isEmpty((CharSequence)relationDimKey)) {
                        throw new KDBizException(ResManager.loadResFormat((String)"\u201c%1\u201d\u7ef4\u5ea6\u5728\u6b64\u7533\u62a5\u5355\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5217\u3002", (String)"MultiDimRelationService_0", (String)"epm-eb-formplugin", (Object[])new Object[]{dimNumber}));
                    }
                    dimKeyMap.put(dimNumber, relationDimKey);
                }
                List<MultiDimRelationColumn> multiDimRelationColumns = this.getMultiDimRelationColumns(modelId, dimensionBussSchemeId);
                MultiDimRelationScheme multiDimRelationScheme = schemeMap.computeIfAbsent(mapKey, k -> new MultiDimRelationScheme());
                ArrayList dimRelationItems = new ArrayList(16);
                multiDimRelationScheme.setMultiDimRelationSchemeId(Long.valueOf(dimensionBussSchemeId));
                multiDimRelationScheme.setDimNumberIdMap(dimNumberIdMap);
                HashMap<Long, MultiDimRelationItem> relationItemMap = new HashMap<Long, MultiDimRelationItem>(1024);
                for (MultiDimRelationColumn multiDimRelationColumn : multiDimRelationColumns) {
                    Long id = multiDimRelationColumn.getId();
                    MultiDimRelationItem multiDimRelationItem = relationItemMap.computeIfAbsent(id, k -> new MultiDimRelationItem());
                    String dimNumber = multiDimRelationColumn.getDimensionNumber();
                    Long dimensionId = (Long)dimNumberIdMap.get(dimNumber);
                    Long memberId = multiDimRelationColumn.getDimensionMemberId();
                    String dimensionMemberNumber = multiDimRelationColumn.getDimensionMemberNumber();
                    Member memberOnCache = modelCacheHelper.getMember(dimNumber, (Long)viewIds.get(dimNumber), memberId);
                    String relationDimKey = (String)dimKeyMap.get(dimNumber);
                    MultiDimRelationMember relationDimMember = new MultiDimRelationMember();
                    relationDimMember.setDimId(dimensionId);
                    relationDimMember.setDimNumber(dimNumber);
                    relationDimMember.setDimColumnKey(relationDimKey);
                    relationDimMember.setDimMemberId(memberId);
                    relationDimMember.setDimMemberNumber(dimensionMemberNumber);
                    relationDimMember.setLeaf(memberOnCache == null ? true : memberOnCache.isLeaf());
                    if (StringUtils.equals((CharSequence)mainDim, (CharSequence)dimNumber)) {
                        multiDimRelationScheme.setMainDimColumnKey(relationDimKey);
                        if (!mainRelationColumnKeyList.contains(relationDimKey)) {
                            mainRelationColumnKeyList.add(relationDimKey);
                        }
                        multiDimRelationItem.setMainDimMember(relationDimMember);
                        continue;
                    }
                    if (!relationColumnKeyList.contains(relationDimKey)) {
                        relationColumnKeyList.add(relationDimKey);
                    }
                    multiDimRelationItem.addRelationDimMember(relationDimMember);
                }
                dimRelationItems.addAll(relationItemMap.values());
                multiDimRelationScheme.setDimRelationItems(dimRelationItems);
                schemeList.add(multiDimRelationScheme);
            }
        }
        return billAllMultiRelation;
    }

    private DynamicObject getMultiDimRelationScheme(Long pkId) {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)pkId, (String)"epm_multidimrelation");
    }

    private List<MultiDimRelationColumn> getMultiDimRelationColumns(Long modelId, Long schemeId) {
        ArrayList<MultiDimRelationColumn> relationDtos = new ArrayList<MultiDimRelationColumn>(16);
        String sql = "select a.fid id, a.frelationid as relationid, b.FDIMENSION dimensionnumber, b.fmembernum membernum, b.fmemberid memberid from t_eb_multidimmemrelation a, t_eb_multidimmemrel_d b where a.fid = b.fid and a.FRELATIONID = ? and a.FMODELID= ? and a.fstatus= '1'";
        try (DataSet ds = DB.queryDataSet((String)"queryMultiDimRelation", (DBRoute)DBRoute.of((String)"epm"), (String)sql, (Object[])new Object[]{schemeId, modelId});){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                MultiDimRelationColumn multiDimRelationColumn = new MultiDimRelationColumn();
                Long id = row.getLong("id");
                String dimensionnumber = row.getString("dimensionnumber");
                String membernum = row.getString("membernum");
                Long memberid = row.getLong("memberid");
                Long relationid = row.getLong("relationid");
                multiDimRelationColumn.setId(id);
                multiDimRelationColumn.setDimensionMemberId(memberid);
                multiDimRelationColumn.setDimensionMemberNumber(membernum);
                multiDimRelationColumn.setDimensionNumber(dimensionnumber);
                multiDimRelationColumn.setRelationId(relationid);
                relationDtos.add(multiDimRelationColumn);
            }
        }
        return relationDtos;
    }

    private String getDimensionColumnKey(List<BaseColumn> list, long relationDimensionId) {
        for (BaseColumn column : list) {
            String key = column.getKey();
            ColumnEnum type = column.getType();
            int value = type.getValue();
            switch (value) {
                case 1: {
                    DimensionColumn column1 = (DimensionColumn)column;
                    long dimensionId = column1.getDimensionId();
                    if (relationDimensionId != dimensionId) break;
                    return key;
                }
                case 4: {
                    RelationDimensionColumn relationDimensionColumn = (RelationDimensionColumn)column;
                    long relationDimensionColumnDimensionId = relationDimensionColumn.getDimensionId();
                    if (relationDimensionId != relationDimensionColumnDimensionId) break;
                    return key;
                }
                case 11: {
                    RowDimensionColumn rowDimensionColumn = (RowDimensionColumn)column;
                    long rowDimensionColumnId = rowDimensionColumn.getDimensionId();
                    if (relationDimensionId != rowDimensionColumnId) break;
                    return key;
                }
            }
        }
        return "";
    }
}

