/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.applybill.util;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.epm.eb.business.applybill.util.ApplyTemplateUtils;
import kd.epm.eb.common.applybill.ApplyBillEntityData;
import kd.epm.eb.common.applybill.DetailMembBillData;
import kd.epm.eb.common.applybill.EntityCellBaseData;
import kd.epm.eb.common.applybill.EntityRowDataType;
import kd.epm.eb.common.applybill.RowDataStatus;
import kd.epm.eb.common.applytemplatecolumn.BaseColumn;
import kd.epm.eb.common.applytemplatecolumn.DimensionDataColumn;
import kd.epm.eb.common.applytemplatecolumn.EntryTemplateConfig;
import kd.epm.eb.common.applytemplatecolumn.MeasureColumn;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.StringUtils;

public class ApplyBillAggHelper {
    private static final ApplyBillAggHelper instance = new ApplyBillAggHelper();

    public static ApplyBillAggHelper getInstance() {
        return instance;
    }

    public Object[] getRowData(Map<String, String> members, DetailMembBillData billData, List<String> dimColumnKeyList) {
        String rowDimMembIdStr = this.getRowDimMembIdStr(members, dimColumnKeyList);
        RowDataStatus rowDataStatus = (RowDataStatus)billData.getDetailRowStatus().get(rowDimMembIdStr);
        if (rowDataStatus != null) {
            return (Object[])billData.getAllRowData().get(rowDataStatus.getRowIndex());
        }
        return null;
    }

    public String getRowDimMembIdStr(DynamicObject rowObj, List<String> dimColumnKeyList) {
        StringBuilder sb = new StringBuilder();
        for (String key : dimColumnKeyList) {
            DynamicObject membObj = rowObj.getDynamicObject(key);
            if (membObj == null) continue;
            sb.append(membObj.getString("id")).append(',');
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public String getRowDimMembIdStr(Object[] rowData, List<String> dimColumnKeyList, Map<String, Integer> columnIndexs) {
        StringBuilder sb = new StringBuilder();
        for (String key : dimColumnKeyList) {
            int index = columnIndexs.get(key);
            Long membId = (Long)rowData[index];
            if (membId == null) continue;
            sb.append(membId).append(',');
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public Map<String, String> selectRowDimMembNums(ApplyBillEntityData entityData, int rowIndex, List<String> dimColumnKeyList) {
        HashMap<String, String> reuslt = new HashMap<String, String>(dimColumnKeyList.size());
        for (String key : dimColumnKeyList) {
            EntityCellBaseData cellBaseData = entityData.getCellBaseData(rowIndex, key);
            reuslt.put(key, cellBaseData.getNumber());
        }
        return reuslt;
    }

    public String getRowDimMembIdStr(ApplyBillEntityData entityData, int rowIndex, List<String> dimColumnKeyList) {
        StringBuilder sb = new StringBuilder();
        for (String key : dimColumnKeyList) {
            EntityCellBaseData cellBaseData = entityData.getCellBaseData(rowIndex, key);
            sb.append(cellBaseData.getId()).append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public String getRowDimMembIdStr(Map<String, String> members, List<String> dimColumnKeyList) {
        StringBuilder sb = new StringBuilder();
        for (String key : dimColumnKeyList) {
            sb.append(members.get(key)).append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public Map<String, BigDecimal> getData(Map<String, String> members, DetailMembBillData billData, Collection<String> aggColumnKey, EntryTemplateConfig templateConfig, boolean needDefaultZero, Set<Long> matchChildRowIds) {
        Map<String, Set<Long>> detailChildMemb = this.getDetailChildMemb(members, billData);
        List dimColumnKeyList = templateConfig.getDimKeysList();
        Map columnIndex = templateConfig.getColumnIndex();
        HashMap<String, BigDecimal> data = new HashMap<String, BigDecimal>();
        if (needDefaultZero) {
            for (String key : aggColumnKey) {
                data.put(key, BigDecimal.ZERO.setScale(2));
            }
        }
        HashMap rowDimNumOnCol = new HashMap(16);
        HashMap rowDimNumStrOnCol = new HashMap(16);
        Set colDimNums = templateConfig.getColDimNums();
        templateConfig.getEntryColumns().forEach(col -> {
            if (col.getIspullfrommodel()) {
                if (col instanceof MeasureColumn) {
                    ((MeasureColumn)col).getDataMapDimensions().forEach(dataMapDimension -> {
                        String dimNum = dataMapDimension.getDimNum();
                        if (StringUtils.isNotEmpty((String)dimNum) && !colDimNums.contains(dimNum)) {
                            rowDimNumOnCol.computeIfAbsent(col.getKey(), key -> new HashSet(16)).add(dimNum);
                        }
                    });
                } else if (col instanceof DimensionDataColumn) {
                    ((DimensionDataColumn)col).getDataMapDimensions().forEach(dataMapDimension -> {
                        String dimNum = dataMapDimension.getDimNum();
                        if (StringUtils.isNotEmpty((String)dimNum) && !colDimNums.contains(dimNum)) {
                            rowDimNumOnCol.computeIfAbsent(col.getKey(), key -> new HashSet(16)).add(dimNum);
                        }
                    });
                }
                Set rowDimNums = (Set)rowDimNumOnCol.get(col.getKey());
                if (CollectionUtils.isNotEmpty((Collection)rowDimNums)) {
                    rowDimNumStrOnCol.put(col.getKey(), rowDimNums.toString());
                }
            }
        });
        List rowDimNums = templateConfig.getRowDimNums();
        HashMap<String, Set> repeatableRow = new HashMap<String, Set>(16);
        StringBuilder sb = new StringBuilder();
        HashMap<String, String> rowLoadInfo = new HashMap<String, String>(16);
        for (Object[] rowData : billData.getAllRowData()) {
            if (!this.matchChildRow(dimColumnKeyList, columnIndex, detailChildMemb, rowData)) continue;
            if (matchChildRowIds != null) {
                matchChildRowIds.add(this.getRowId(rowData));
            }
            for (String key : aggColumnKey) {
                BigDecimal bigDecimal;
                Set rowDimNumsOnCol = (Set)rowDimNumOnCol.get(key);
                if (rowDimNumsOnCol != null) {
                    Set rowMembersStrSet;
                    String rowDimNumStr = (String)rowDimNumStrOnCol.get(key);
                    String rowMemberStr = (String)rowLoadInfo.get(rowDimNumStr);
                    if (rowMemberStr == null) {
                        sb.setLength(0);
                        for (int index = 0; index < dimColumnKeyList.size(); ++index) {
                            String dimNum = (String)rowDimNums.get(index);
                            if (rowDimNumsOnCol.contains(dimNum)) continue;
                            sb.append(rowData[(Integer)columnIndex.get(dimColumnKeyList.get(index))]).append(',');
                        }
                        rowMemberStr = sb.toString();
                        rowLoadInfo.put(rowDimNumStr, rowMemberStr);
                    }
                    if ((rowMembersStrSet = repeatableRow.computeIfAbsent(rowDimNumStr, k -> new HashSet(16))).contains(rowMemberStr)) continue;
                }
                if ((bigDecimal = (BigDecimal)data.get(key)) == null) {
                    bigDecimal = new BigDecimal(0);
                }
                if (!columnIndex.containsKey(key)) {
                    throw new KDBizException("key:" + key + "index:" + columnIndex.toString() + "aggKeys:" + aggColumnKey.toString());
                }
                int valIndex = (Integer)columnIndex.get(key);
                if (!(rowData[valIndex] instanceof BigDecimal)) continue;
                BigDecimal bigDecimal1 = (BigDecimal)rowData[valIndex];
                if (bigDecimal1 != null) {
                    bigDecimal = bigDecimal.add(bigDecimal1);
                }
                data.put(key, bigDecimal);
            }
            if (rowLoadInfo.size() <= 0) continue;
            rowLoadInfo.forEach((rowDimStr, rowMemberIdStr) -> repeatableRow.computeIfAbsent((String)rowDimStr, k -> new HashSet(16)).add(rowMemberIdStr));
            rowLoadInfo.clear();
        }
        return data;
    }

    public Map<String, BigDecimal> getDataNew(Map<String, String> members, DetailMembBillData billData, Collection<String> aggColumnKey, EntryTemplateConfig templateConfig, Set<Long> matchChildRowIds, Map<String, BigDecimal> olapData) {
        HashMap<String, BigDecimal> data = new HashMap<String, BigDecimal>(16);
        boolean hasOlapData = false;
        if (CollectionUtils.isNotEmpty(olapData)) {
            for (Map.Entry<String, BigDecimal> entry : olapData.entrySet()) {
                BigDecimal olapValue = entry.getValue();
                if (olapValue.compareTo(BigDecimal.ZERO) == 0) continue;
                hasOlapData = true;
                break;
            }
        }
        Map<String, Set<Long>> detailChildMemb = this.getDetailChildMemb(members, billData);
        List dimColumnKeyList = templateConfig.getDimKeysList();
        Map columnIndex = templateConfig.getColumnIndex();
        HashMap rowDimNumOnCol = new HashMap(16);
        HashMap rowDimNumStrOnCol = new HashMap(16);
        Set colDimNums = templateConfig.getColDimNums();
        templateConfig.getEntryColumns().forEach(col -> {
            if (col.getIspullfrommodel()) {
                if (col instanceof MeasureColumn) {
                    ((MeasureColumn)col).getDataMapDimensions().forEach(dataMapDimension -> {
                        String dimNum = dataMapDimension.getDimNum();
                        if (StringUtils.isNotEmpty((String)dimNum) && !colDimNums.contains(dimNum)) {
                            rowDimNumOnCol.computeIfAbsent(col.getKey(), key -> new HashSet(16)).add(dimNum);
                        }
                    });
                } else if (col instanceof DimensionDataColumn) {
                    ((DimensionDataColumn)col).getDataMapDimensions().forEach(dataMapDimension -> {
                        String dimNum = dataMapDimension.getDimNum();
                        if (StringUtils.isNotEmpty((String)dimNum) && !colDimNums.contains(dimNum)) {
                            rowDimNumOnCol.computeIfAbsent(col.getKey(), key -> new HashSet(16)).add(dimNum);
                        }
                    });
                }
                Set rowDimNums = (Set)rowDimNumOnCol.get(col.getKey());
                if (CollectionUtils.isNotEmpty((Collection)rowDimNums)) {
                    rowDimNumStrOnCol.put(col.getKey(), rowDimNums.toString());
                }
            }
        });
        List rowDimNums = templateConfig.getRowDimNums();
        HashMap<String, Set> repeatableRow = new HashMap<String, Set>(16);
        StringBuilder sb = new StringBuilder();
        HashMap<String, String> rowLoadInfo = new HashMap<String, String>(16);
        for (Object[] rowData : billData.getAllRowData()) {
            String dataType;
            if (!this.matchChildRow(dimColumnKeyList, columnIndex, detailChildMemb, rowData)) continue;
            if (hasOlapData) {
                data.putAll(olapData);
            }
            if (CollectionUtils.isNotEmpty(data) && EntityRowDataType.isDetailData((String)(dataType = (String)rowData[3]))) continue;
            if (matchChildRowIds != null) {
                matchChildRowIds.add(this.getRowId(rowData));
            }
            for (String key : aggColumnKey) {
                BigDecimal bigDecimal;
                Set rowDimNumsOnCol = (Set)rowDimNumOnCol.get(key);
                if (rowDimNumsOnCol != null) {
                    Set rowMembersStrSet;
                    String rowDimNumStr = (String)rowDimNumStrOnCol.get(key);
                    String rowMemberStr = (String)rowLoadInfo.get(rowDimNumStr);
                    if (rowMemberStr == null) {
                        sb.setLength(0);
                        for (int index = 0; index < dimColumnKeyList.size(); ++index) {
                            String dimNum = (String)rowDimNums.get(index);
                            if (rowDimNumsOnCol.contains(dimNum)) continue;
                            sb.append(rowData[(Integer)columnIndex.get(dimColumnKeyList.get(index))]).append(',');
                        }
                        rowMemberStr = sb.toString();
                        rowLoadInfo.put(rowDimNumStr, rowMemberStr);
                    }
                    if ((rowMembersStrSet = repeatableRow.computeIfAbsent(rowDimNumStr, k -> new HashSet(16))).contains(rowMemberStr)) continue;
                }
                if ((bigDecimal = (BigDecimal)data.get(key)) == null) {
                    bigDecimal = new BigDecimal(0);
                }
                if (!columnIndex.containsKey(key)) {
                    throw new KDBizException("key:" + key + "index:" + columnIndex.toString() + "aggKeys:" + aggColumnKey.toString());
                }
                int valIndex = (Integer)columnIndex.get(key);
                if (!(rowData[valIndex] instanceof BigDecimal)) continue;
                BigDecimal bigDecimal1 = (BigDecimal)rowData[valIndex];
                if (bigDecimal1 != null) {
                    bigDecimal = bigDecimal.add(bigDecimal1);
                }
                data.put(key, bigDecimal);
            }
            if (rowLoadInfo.size() <= 0) continue;
            rowLoadInfo.forEach((rowDimStr, rowMemberIdStr) -> repeatableRow.computeIfAbsent((String)rowDimStr, k -> new HashSet(16)).add(rowMemberIdStr));
            rowLoadInfo.clear();
        }
        return data;
    }

    public Map<String, BigDecimal> getData(Map<String, String> members, DetailMembBillData billData, Collection<String> aggColumnKey, EntryTemplateConfig templateConfig, boolean needDefaultZero) {
        return this.getData(members, billData, aggColumnKey, templateConfig, needDefaultZero, null);
    }

    public Map<String, BigDecimal> getData(Map<String, String> members, DetailMembBillData billData, Collection<String> aggColumnKey, EntryTemplateConfig templateConfig) {
        return this.getData(members, billData, aggColumnKey, templateConfig, true);
    }

    public List<Integer> getDetailRowDataIndex(Map<String, String> members, List<String> dimColumnKeyList, Map<String, Integer> columnIndex, DetailMembBillData billData) {
        Map<String, Set<Long>> detailChildMemb = this.getDetailChildMemb(members, billData);
        ArrayList<Integer> result = new ArrayList<Integer>();
        int index = 0;
        for (Object[] rowData : billData.getAllRowData()) {
            boolean match = this.matchChildRow(dimColumnKeyList, columnIndex, detailChildMemb, rowData);
            String dataType = (String)rowData[3];
            if (match && dataType != null && EntityRowDataType.isDetailData((String)dataType)) {
                result.add(index);
            }
            ++index;
        }
        return result;
    }

    public List<Integer> getRejectRowModifyRowDataIndex(Map<String, String> members, List<String> dimColumnKeyList, Map<String, Integer> columnIndex, DetailMembBillData billData) {
        Map<String, Set<Long>> detailChildMemb = this.getDetailChildMemb(members, billData);
        ArrayList<Integer> result = new ArrayList<Integer>();
        int index = 0;
        for (Object[] rowData : billData.getAllRowData()) {
            boolean match = this.matchChildRow(dimColumnKeyList, columnIndex, detailChildMemb, rowData);
            String dataType = (String)rowData[3];
            if (match && dataType != null) {
                result.add(index);
            }
            ++index;
        }
        return result;
    }

    public boolean matchChildRow(List<String> dimColumnKeyList, Map<String, Integer> columnIndex, Map<String, Set<Long>> detailChildMemb, Object[] rowData) {
        boolean match = true;
        for (String dimColumnKey : dimColumnKeyList) {
            Integer index = columnIndex.get(dimColumnKey);
            Set<Long> detailChild = detailChildMemb.get(dimColumnKey);
            if (detailChild == null || detailChild.contains(rowData[index])) continue;
            match = false;
            break;
        }
        return match;
    }

    public Map<String, Set<Long>> getDetailChildMemb(Map<String, String> member, DetailMembBillData billData) {
        HashMap<String, Set<Long>> result = new HashMap<String, Set<Long>>(16);
        EntryTemplateConfig templateConfig = billData.getTemplateConfig();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)templateConfig.getModelId());
        Map columnMapDimNum = templateConfig.selectColumnMapDimNum();
        for (Map.Entry<String, String> membInfo : member.entrySet()) {
            HashSet membNums = new HashSet();
            if (columnMapDimNum.containsKey(membInfo.getKey())) {
                billData.iteratorMembersOnRow(modelCacheHelper, membInfo.getKey(), memberObj -> {
                    if (memberObj != null && this.matchParent(memberObj.getLongNumber(), (String)membInfo.getValue())) {
                        membNums.add(memberObj.getId());
                    }
                });
            }
            result.put(membInfo.getKey(), membNums);
        }
        return result;
    }

    public boolean matchParent(String childLongNum, String parentNum) {
        int index2 = 0;
        int endLength1 = childLongNum.length() - 1;
        int endLength2 = parentNum.length() - 1;
        boolean beginMatch = true;
        boolean match = false;
        int cLength = childLongNum.length();
        int pLength = parentNum.length();
        for (int index1 = 0; index1 < cLength && index2 < pLength; ++index1) {
            char c1 = childLongNum.charAt(index1);
            if (c1 == '!') {
                beginMatch = true;
                index2 = 0;
                continue;
            }
            if (!beginMatch) continue;
            if (parentNum.charAt(index2) == c1) {
                if (index2 == endLength2 && (endLength1 == index1 || childLongNum.charAt(index1 + 1) == '!')) {
                    match = true;
                    break;
                }
                if (++index2 < pLength) continue;
                beginMatch = false;
                index2 = 0;
                continue;
            }
            beginMatch = false;
        }
        return match;
    }

    public Map<String, Set<Long>> getDetailChildMemb(Map<String, String> member, IModelCacheHelper modelCacheHelper, Map<String, Long> viewIdMap, EntryTemplateConfig templateConfig) {
        HashMap<String, Set<Long>> result = new HashMap<String, Set<Long>>(16);
        Map columnMapDimNum = templateConfig.selectColumnMapDimNum();
        for (Map.Entry<String, String> membInfo : member.entrySet()) {
            String dimNum = (String)columnMapDimNum.get(membInfo.getKey());
            Long viewId = viewIdMap.get(dimNum);
            Member memb = modelCacheHelper.getMember(dimNum, viewId, membInfo.getValue());
            HashSet childMembIds = new HashSet();
            if (memb != null) {
                memb.iterate(child -> childMembIds.add(child.getId()));
            }
            result.put(membInfo.getKey(), childMembIds);
        }
        return result;
    }

    public void initDetailData(DetailMembBillData billData) {
    }

    public Map<String, Map<String, Set<Long>>> initDetailDataGroup(DetailMembBillData billData, List<Object[]> rowDatas, IModelCacheHelper modelCacheHelper, Map<String, Long> viewIds, BigDecimal unitData, EntryTemplateConfig templateConfig) {
        Map keyMapDimNum = templateConfig.selectColumnMapDimNum();
        List dimColumnKeys = templateConfig.getDimKeysList();
        Map columnIndex = templateConfig.getColumnIndex();
        HashSet notTreeDimColumnKeys = new HashSet(templateConfig.getNotTreeDimKeys());
        ApplyTemplateUtils.qFlterNoDetailRecord(rowDatas, keyMapDimNum, modelCacheHelper, viewIds, dimColumnKeys, columnIndex);
        this.changeValByUnit(rowDatas, templateConfig.getEntryColumns(), columnIndex, templateConfig.getCurrencyColumnKeys(), unitData);
        billData.setTemplateConfig(templateConfig);
        billData.getAllRowData().addAll(rowDatas);
        Map detailRowStatus = billData.getDetailRowStatus();
        HashMap<String, Map<String, Set<Long>>> detailRowMembIds = new HashMap<String, Map<String, Set<Long>>>();
        StringBuilder dimMembIdStr = new StringBuilder();
        int rowCount = 0;
        StringBuilder sb = new StringBuilder();
        HashMap<String, Long> dimsMembIdOnRow = new HashMap<String, Long>(16);
        for (Object[] row : rowDatas) {
            Object dataType = row[3];
            boolean isDetail = dataType.equals(EntityRowDataType.NEW_DETAIL.getNumber()) || dataType.equals(EntityRowDataType.EDIT_DETAIL.getNumber());
            for (String key2 : dimColumnKeys) {
                Long membId = (Long)row[(Integer)columnIndex.get(key2)];
                dimMembIdStr.append(membId).append(',');
                if (!isDetail) continue;
                if (notTreeDimColumnKeys.contains(key2)) {
                    sb.append(membId).append(',');
                    continue;
                }
                dimsMembIdOnRow.put(key2, membId);
            }
            if (isDetail) {
                if (sb.length() > 0) {
                    sb.deleteCharAt(sb.length() - 1);
                }
                Map dimsMembIds = detailRowMembIds.computeIfAbsent(sb.toString(), key -> new HashMap(16));
                for (Map.Entry entry : dimsMembIdOnRow.entrySet()) {
                    Set membIds = dimsMembIds.computeIfAbsent(entry.getKey(), key -> new HashSet(16));
                    membIds.add(entry.getValue());
                }
                dimsMembIdOnRow.clear();
                sb.setLength(0);
            }
            if (dimMembIdStr.charAt(dimMembIdStr.length() - 1) == ',') {
                dimMembIdStr.deleteCharAt(dimMembIdStr.length() - 1);
            }
            detailRowStatus.put(dimMembIdStr.toString(), new RowDataStatus(isDetail, rowCount++, false));
            dimMembIdStr.setLength(0);
        }
        return detailRowMembIds;
    }

    private void changeValByUnit(List<Object[]> rowVals, List<BaseColumn> columns, Map<String, Integer> columnIndex, Set<String> currencyKeys, BigDecimal unitData) {
        if (currencyKeys == null || currencyKeys.isEmpty()) {
            return;
        }
        for (BaseColumn baseColumn : columns) {
            if (!currencyKeys.contains(baseColumn.getKey())) continue;
            int index = columnIndex.get(baseColumn.getKey());
            for (Object[] rowVal : rowVals) {
                if (index > rowVal.length - 1) continue;
                Object val = rowVal[index];
                rowVal[index] = val = this.changeValByUnit(val, unitData);
            }
        }
    }

    private Object changeValByUnit(Object oldVal, BigDecimal unit) {
        if (oldVal instanceof BigDecimal) {
            oldVal = ((BigDecimal)oldVal).multiply(unit);
        }
        return oldVal;
    }

    public boolean isDetailRow(Object[] rowData) {
        String dataType = ApplyBillAggHelper.getInstance().getRowDataType(rowData);
        return EntityRowDataType.isDetailData((String)dataType);
    }

    public String getRowDataType(Object[] rowVal) {
        String dataType = (String)rowVal[3];
        if (dataType == null) {
            dataType = EntityRowDataType.NEW_DETAIL.getNumber();
        }
        return dataType;
    }

    public Timestamp getModifTime(Object[] rowVal) {
        Timestamp modifTime = (Timestamp)rowVal[7];
        if (modifTime == null) {
            modifTime = new Timestamp(1000L);
        }
        return modifTime;
    }

    public Timestamp getCreateTime(Object[] rowVal) {
        Object time = rowVal[5];
        Timestamp createTime = time == null ? new Timestamp(1000L) : Timestamp.valueOf(time.toString());
        return createTime;
    }

    public Long getRowId(Object[] rowVal) {
        Long rowId = (Long)rowVal[0];
        if (rowId == null) {
            rowId = 0L;
        }
        return rowId;
    }

    public String getBillNumberOnRow(Object[] rowVal) {
        String billNumber = (String)rowVal[2];
        if (billNumber == null) {
            billNumber = "";
        }
        return billNumber;
    }
}

