/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.applybill.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.IntegerEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.DateField;
import kd.bos.metadata.entity.commonfield.DateTimeField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IntegerField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.EntryFieldGroupAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.applybill.util.ApplyBillPluginUitl;
import kd.epm.eb.business.applybill.util.BgApplyBillUtils;
import kd.epm.eb.business.applytemplate.config.service.ApplyTemplateColCfgService;
import kd.epm.eb.business.applytemplate.config.service.ApplyTemplateDimAreaCfgService;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.applyTemplate.TempDimConfig;
import kd.epm.eb.common.applyTemplate.TempDimConfigType;
import kd.epm.eb.common.applyTemplate.constants.ColCfgPropEnum;
import kd.epm.eb.common.applyTemplate.constants.ColCfgPropTypeEnum;
import kd.epm.eb.common.applyTemplate.constants.FormTypeEnum;
import kd.epm.eb.common.applyTemplate.entity.tableconfig.BizTableConfig;
import kd.epm.eb.common.applybill.ApplyBillConstant;
import kd.epm.eb.common.applybill.EntityRowDataType;
import kd.epm.eb.common.applybill.MemberShowType;
import kd.epm.eb.common.applytemplatecolumn.ApplyBillModel;
import kd.epm.eb.common.applytemplatecolumn.BaseColumn;
import kd.epm.eb.common.applytemplatecolumn.BgApplyENtryInfo;
import kd.epm.eb.common.applytemplatecolumn.CalculateColumn;
import kd.epm.eb.common.applytemplatecolumn.ColumnEnum;
import kd.epm.eb.common.applytemplatecolumn.ColumnList;
import kd.epm.eb.common.applytemplatecolumn.ColumnStyle;
import kd.epm.eb.common.applytemplatecolumn.DataMapDimension;
import kd.epm.eb.common.applytemplatecolumn.DimensionColumn;
import kd.epm.eb.common.applytemplatecolumn.DimensionDataColumn;
import kd.epm.eb.common.applytemplatecolumn.DimensionMemberRange;
import kd.epm.eb.common.applytemplatecolumn.EntryTemplateConfig;
import kd.epm.eb.common.applytemplatecolumn.FieldTypeEnum;
import kd.epm.eb.common.applytemplatecolumn.MeasureColumn;
import kd.epm.eb.common.applytemplatecolumn.NumberColumn;
import kd.epm.eb.common.applytemplatecolumn.NumberType;
import kd.epm.eb.common.applytemplatecolumn.RelationDimensionColumn;
import kd.epm.eb.common.applytemplatecolumn.RelationValueColumn;
import kd.epm.eb.common.applytemplatecolumn.RowDimensionColumn;
import kd.epm.eb.common.applytemplatecolumn.TextColumn;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.common.permission.membPerm.DimMemberPermChecker;
import kd.epm.eb.common.permission.membPerm.MemberItem;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.var.ReportVarUtil;
import kd.epm.eb.common.var.VarException;

public class ApplyTemplateUtils {
    private static final Log log = LogFactory.getLog(ApplyTemplateUtils.class);
    private static final String KEY_MAINENTRYENTITY = "mainentryentity";
    private static final String KEY_BIZMAINENTRYENTITY = "bizentryentity";
    public static String FIELD_COMBINEDIMENSION = "e_combinedimension";
    public static String FIELDSQL_COMBINEDIMENSION = "fcombinedimension";
    public static String FIELDSQL_COMBINEDIMENSION1 = "combinedimension";
    public static String FIELD_DETAILID = "e_detailid";
    public static String FIELD_BIZPLAN_TABKEY = "e_bizplantabkey";
    public static String FIELDSQL_BIZPLAN_TABKEY = "fbizplantabkey";
    public static String FIELDSQL_BIZPLAN_TABKEY1 = "bizplantabkey";
    public static String FIELDSQL_DETAILID = "fdetailid";
    public static String FIELDSQL_DETAILID1 = "detailid";
    public static String FIELD_BUSPLANDETAIL = "h_busplandetail";
    public static String FIELDSQL_BUSPLANDETAIL = "fbusplandetail";
    public static String FIELDSQL_BUSPLANDETAIL1 = "busplandetail";
    public static String FIELD_REJECT_STATUS = "h_rejectstatus";
    public static String FIELD_SUBTOTAL_STATUS = "h_subtotalstatus";

    public static ColumnList getEntrycfgByApplyTemplateID(Long templateid) {
        DynamicObject template = BusinessDataServiceHelper.loadSingleFromCache((Object)templateid, (String)"eb_applytemplate", (String)"id,number,entrycfgjson_tag");
        return ApplyTemplateUtils.getEntrycfgByApplyTemplate(template);
    }

    public static ColumnList getEntrycfgByApplyTemplate(DynamicObject template) {
        String entrycfgjson_tag = (String)template.get("entrycfgjson_tag");
        String number = template.getString("number");
        if (StringUtils.isEmpty((CharSequence)entrycfgjson_tag)) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u6a21\u677f\u201c%1\u201d\u6ca1\u6709\u5206\u5f55\u914d\u7f6e\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ApplyTemplateUtils_0", (String)"epm-eb-common", (Object[])new Object[]{number}));
        }
        return (ColumnList)SerializationUtils.fromJsonString((String)entrycfgjson_tag, ColumnList.class);
    }

    public static void changeVarOnColumn(ColumnList columnList, Long datasetId, IModelCacheHelper modelCacheHelper, Map<String, Map<String, String>> allDimVarSetting) {
        Collection columns = columnList.getColumns();
        if (allDimVarSetting == null || modelCacheHelper == null) {
            return;
        }
        Map dimViewMap = modelCacheHelper.getViewsByDataSet(datasetId);
        columns.forEach(col -> {
            if (col instanceof DimensionColumn) {
                String dimNum = ((DimensionColumn)col).getDimNumber();
                ApplyTemplateUtils.changeVar4Column(((DimensionColumn)col).getDimensionMemberRanges(), modelCacheHelper, allDimVarSetting, dimNum, (Long)dimViewMap.get(dimNum));
            } else if (col instanceof MeasureColumn) {
                List dataMapDimensions = ((MeasureColumn)col).getDataMapDimensions();
                ApplyTemplateUtils.changeVar4Column(dataMapDimensions, dimViewMap, modelCacheHelper, allDimVarSetting);
            } else if (col instanceof CalculateColumn) {
                List dataMapDimensions = ((CalculateColumn)col).getDataMapDimensions();
                ApplyTemplateUtils.changeVar4Column(dataMapDimensions, dimViewMap, modelCacheHelper, allDimVarSetting);
            } else if (col instanceof RowDimensionColumn) {
                String dimNum = ((RowDimensionColumn)col).getDimNumber();
                ApplyTemplateUtils.changeVar4Column(((RowDimensionColumn)col).getDimensionMemberRanges(), modelCacheHelper, allDimVarSetting, dimNum, (Long)dimViewMap.get(dimNum));
            } else if (col instanceof DimensionDataColumn) {
                List dataMapDimensions = ((DimensionDataColumn)col).getDataMapDimensions();
                ApplyTemplateUtils.changeVar4Column(dataMapDimensions, dimViewMap, modelCacheHelper, allDimVarSetting);
            }
        });
    }

    private static void changeVar4Column(List<DataMapDimension> dataMapDimensions, Map<String, Long> dimViewMap, IModelCacheHelper modelCacheHelper, Map<String, Map<String, String>> allDimVarSetting) {
        if (allDimVarSetting != null) {
            dataMapDimensions.forEach(dimInfo -> {
                if (dimInfo.isVar()) {
                    ApplyTemplateUtils.changeVar(modelCacheHelper, dimInfo.getMembNum(), allDimVarSetting, (Long)dimViewMap.get(dimInfo.getDimNum()), dimInfo.getDimNum(), member -> {
                        dimInfo.setDimensionRememberId(member.getId().longValue());
                        dimInfo.setMembNum(member.getNumber());
                    });
                }
            });
        }
    }

    private static void changeVar4Column(List<DimensionMemberRange> dimensionMemberRanges, IModelCacheHelper modelCacheHelper, Map<String, Map<String, String>> allDimVarSetting, String dimNumber, Long viewId) {
        if (dimensionMemberRanges != null && allDimVarSetting != null) {
            dimensionMemberRanges.forEach(dimMembRange -> {
                if (dimMembRange.isVar()) {
                    ApplyTemplateUtils.changeVar(modelCacheHelper, dimMembRange.getNumber(), allDimVarSetting, viewId, dimNumber, member -> {
                        dimMembRange.setId(member.getId().toString());
                        dimMembRange.setName(member.getName());
                        dimMembRange.setNumber(member.getNumber());
                    });
                }
            });
        }
    }

    public static void changeVar(IModelCacheHelper modelCacheHelper, String varNum, Map<String, Map<String, String>> allDimVarSetting, Long viewId, String dimNum, Consumer<Member> memberConsumer) {
        Map<String, String> varMapDimMembs = allDimVarSetting.get(dimNum);
        if (varMapDimMembs == null) {
            throw new VarException(ResManager.loadResFormat((String)"\u5355\u636e\u4e0a\u8bbe\u7f6e\u7684%1\u7ef4\u5ea6\u53d8\u91cf\u6ca1\u6709\u8bbe\u7f6e\u503c\uff0c\u8bf7\u5728\u65b9\u6848\u4e2d\u8bbe\u7f6e\u3002", (String)"ApplyTemplateUtils_1", (String)"epm-eb-business", (Object[])new Object[]{dimNum}));
        }
        String readlMemb = ReportVarUtil.getVarValueNoError((Long)modelCacheHelper.getModelobj().getId(), (String)varNum, varMapDimMembs, (String)dimNum);
        Member member = modelCacheHelper.getMember(dimNum, viewId, readlMemb);
        if (member == null) {
            throw new VarException(ResManager.loadResFormat((String)"\u5355\u636e\u4e0a\u8bbe\u7f6e\u7684%1\u7ef4\u5ea6\u53d8\u91cf%2\u6ca1\u6709\u8bbe\u7f6e\u503c\uff0c\u8bf7\u5728\u65b9\u6848\u4e2d\u8bbe\u7f6e\u3002", (String)"ApplyTemplateUtils_2", (String)"epm-eb-business", (Object[])new Object[]{dimNum, varNum}));
        }
        memberConsumer.accept(member);
    }

    public static List<String> getDimKeyList(List<BaseColumn> columns) {
        ArrayList<String> dimKeyList = new ArrayList<String>();
        for (BaseColumn column : columns) {
            if (!(column instanceof DimensionColumn) && !(column instanceof RelationDimensionColumn) && !(column instanceof RowDimensionColumn)) continue;
            dimKeyList.add(column.getKey());
        }
        return dimKeyList;
    }

    public static List<String> getRowDimNumList(List<BaseColumn> columns, IModelCacheHelper modelCacheHelper) {
        ArrayList<String> result = new ArrayList<String>();
        for (BaseColumn column : columns) {
            Dimension dimension;
            Long dimId = null;
            if (column instanceof DimensionColumn) {
                dimId = ((DimensionColumn)column).getDimensionId();
            } else if (column instanceof RelationDimensionColumn) {
                dimId = ((RelationDimensionColumn)column).getDimensionId();
            } else if (column instanceof RowDimensionColumn) {
                dimId = ((RowDimensionColumn)column).getDimensionId();
            }
            if (dimId == null || dimId.equals(0L) || (dimension = modelCacheHelper.getDimension(dimId)) == null) continue;
            result.add(dimension.getNumber());
        }
        return result;
    }

    public static String getOrgOrAccountColumnKey(Collection<BaseColumn> columns, List<String> dimKeyList, boolean needAccountKey) {
        for (BaseColumn coll : columns) {
            String key = coll.getKey();
            if (dimKeyList.contains(coll.getKey()) && SysDimensionEnum.Account.getMemberTreemodel().equals(coll.getBaseEntityId()) && needAccountKey) {
                return key;
            }
            if (!dimKeyList.contains(coll.getKey()) || !SysDimensionEnum.Entity.getMemberTreemodel().equals(coll.getBaseEntityId()) || needAccountKey) continue;
            return key;
        }
        return null;
    }

    public static Set<String> getRateColumnAndUpFormula(List<BaseColumn> columnList, Long modelId) {
        Set<String> rateMetricColumn = ApplyTemplateUtils.selectMetricColumn(columnList, modelId, MetricDataTypeEnum.RATE);
        ApplyTemplateUtils.updateFormlaPercent(rateMetricColumn, columnList);
        return rateMetricColumn;
    }

    public static void updateFormlaPercent(Set<String> rateMetricColumn, List<BaseColumn> columnList) {
        if (!rateMetricColumn.isEmpty()) {
            for (BaseColumn column : columnList) {
                String formula;
                if (column instanceof NumberColumn) {
                    formula = ((NumberColumn)column).getFormula();
                    formula = ApplyTemplateUtils.setPercent(formula, rateMetricColumn);
                    ((NumberColumn)column).setFormula(formula);
                    continue;
                }
                if (column instanceof CalculateColumn) {
                    formula = ((CalculateColumn)column).getFormula();
                    formula = ApplyTemplateUtils.setPercent(formula, rateMetricColumn);
                    ((CalculateColumn)column).setFormula(formula);
                    continue;
                }
                if (!(column instanceof DimensionDataColumn)) continue;
                formula = ((DimensionDataColumn)column).getFormula();
                formula = ApplyTemplateUtils.setPercent(formula, rateMetricColumn);
                ((DimensionDataColumn)column).setFormula(formula);
            }
        }
    }

    private static String setPercent(String formula, Set<String> rateMetricColumn) {
        return formula;
    }

    public static Set<String> selectMetricColumn(Collection<BaseColumn> columns, Long modelId, MetricDataTypeEnum metricType) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Dimension metricDim = modelCacheHelper.getDimension(SysDimensionEnum.Metric.getNumber());
        HashSet<String> result = new HashSet<String>(16);
        for (BaseColumn column : columns) {
            MeasureColumn column1;
            List dataMapDimensions = null;
            if (column instanceof MeasureColumn) {
                column1 = (MeasureColumn)column;
                dataMapDimensions = column1.getDataMapDimensions();
            } else if (column instanceof CalculateColumn) {
                column1 = (CalculateColumn)column;
                dataMapDimensions = column1.getDataMapDimensions();
            } else if (column instanceof DimensionDataColumn) {
                column1 = (DimensionDataColumn)column;
                dataMapDimensions = column1.getDataMapDimensions();
            }
            if (dataMapDimensions == null) continue;
            for (DataMapDimension dataMapDimension : dataMapDimensions) {
                Member member;
                if (dataMapDimension.getDimensionId() != metricDim.getId().longValue() || (member = modelCacheHelper.getMember(SysDimensionEnum.Metric.getNumber(), null, Long.valueOf(dataMapDimension.getDimensionRememberId()))) == null || !metricType.getIndex().equals(member.getDatatype())) continue;
                result.add(column.getKey());
            }
        }
        return result;
    }

    public static Set<String> getDetailAtColumnKeys(Collection<BaseColumn> columns, Long modelId) {
        HashSet<String> result = new HashSet<String>(16);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Dimension auditDim = modelCacheHelper.getDimension(SysDimensionEnum.AuditTrail.getNumber());
        if (auditDim != null) {
            for (BaseColumn column : columns) {
                if (!(column instanceof MeasureColumn) && !(column instanceof DimensionDataColumn)) continue;
                List membs = null;
                membs = column instanceof MeasureColumn ? ((MeasureColumn)column).getDataMapDimensions() : ((DimensionDataColumn)column).getDataMapDimensions();
                boolean hasAtDim = false;
                for (DataMapDimension m : membs) {
                    if (!auditDim.getId().equals(m.getDimensionId())) continue;
                    Long membId = m.getDimensionRememberId();
                    Member memberCache = auditDim.getMember(null, membId);
                    hasAtDim = true;
                    if (memberCache == null || !memberCache.isLeaf()) continue;
                    result.add(column.getKey());
                    break;
                }
                if (hasAtDim) continue;
                result.add(column.getKey());
            }
        }
        return result;
    }

    public static Set<String> getCurrencyColumnKeys(Collection<BaseColumn> columns, Long modelId) {
        Set<String> result = ApplyTemplateUtils.selectMetricColumn(columns, modelId, MetricDataTypeEnum.CURRENCY);
        ApplyTemplateUtils.getCurrencyColumnKeys(columns, result);
        return result;
    }

    public static void getCurrencyColumnKeys(Collection<BaseColumn> columns, Set<String> metricCols) {
        if (!metricCols.isEmpty()) {
            for (BaseColumn column : columns) {
                if (!(column instanceof NumberColumn)) continue;
                NumberColumn column1 = (NumberColumn)column;
                boolean ispercentage = column1.isIspercentage();
                String formula = column1.getFormula();
                List<String> exprs = ApplyTemplateUtils.getExprs(formula);
                if (!(exprs.isEmpty() || Collections.disjoint(metricCols, exprs) || ispercentage)) {
                    metricCols.add(column.getKey());
                }
                if (column1.getNumberType() != NumberType.currency.getValue() || ispercentage) continue;
                metricCols.add(column.getKey());
            }
        }
    }

    public static List<String> getExprs(String formula) {
        ArrayList<String> exprs = new ArrayList<String>();
        String regex = "\\[(.*?)]";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(formula);
        while (m.find()) {
            String find = m.group(1).replaceAll("\"", "");
            exprs.add(find);
        }
        return exprs;
    }

    public static Map<String, String> getRefDimKeyMap(List<BaseColumn> columns) {
        Long dimId;
        HashMap<Long, String> dimKeyMap = new HashMap<Long, String>();
        HashMap<String, String> refDimKeyMap = new HashMap<String, String>();
        for (BaseColumn column : columns) {
            if (column instanceof RelationDimensionColumn) {
                dimId = ((RelationDimensionColumn)column).getDimensionId();
                if (dimKeyMap.containsKey(dimId)) continue;
                dimKeyMap.put(dimId, column.getKey());
                continue;
            }
            if (!(column instanceof DimensionColumn)) continue;
            dimId = ((DimensionColumn)column).getDimensionId();
            dimKeyMap.put(dimId, column.getKey());
        }
        for (BaseColumn column : columns) {
            if (!(column instanceof RelationDimensionColumn)) continue;
            dimId = ((RelationDimensionColumn)column).getRelationDimensionId();
            refDimKeyMap.put(column.getKey(), (String)dimKeyMap.get(dimId));
        }
        return refDimKeyMap;
    }

    public static EntryAp createEntryAp(String entityNumber, Collection<BaseColumn> collect, boolean isTemplate) {
        return ApplyTemplateUtils.createEntryAp(entityNumber, collect, isTemplate, false, null);
    }

    public static EntryAp createEntryAp(String entityNumber, Collection<BaseColumn> collect, boolean isTemplate, boolean setOrderAndFilter, MemberShowType memberShowType) {
        EntryAp entryAp = new EntryAp();
        entryAp.setKey(entityNumber);
        entryAp.setPageRow(10000);
        if (!setOrderAndFilter) {
            entryAp.setOrderAndFilter(1);
        } else {
            entryAp.setOrderAndFilter(0);
        }
        HashMap<String, EntryFieldGroupAp> entryGroups = new HashMap<String, EntryFieldGroupAp>();
        ApplyTemplateUtils.addFieldAps(entryAp, entryGroups, collect, isTemplate, memberShowType);
        ApplyTemplateUtils.checkGroupFieldShow(entryGroups);
        entryAp.setShowSeq(true);
        return entryAp;
    }

    private static void checkGroupFieldShow(Map<String, EntryFieldGroupAp> entryGroups) {
        entryGroups.values().forEach(groupAp -> {
            boolean allItemHide = true;
            List items = groupAp.getItems();
            for (ControlAp item : items) {
                if (item.getVisible().equals("")) continue;
                allItemHide = false;
                break;
            }
            if (allItemHide) {
                groupAp.setVisible("");
            }
        });
    }

    public static void addFieldAps(EntryAp entryAp, Map<String, EntryFieldGroupAp> entryGroups, Collection<BaseColumn> collect, boolean isTemplate, MemberShowType memberShowType) {
        collect.forEach(e -> ApplyTemplateUtils.addFieldAp(entryAp, entryGroups, e, isTemplate, memberShowType));
    }

    public static void addFieldAp(EntryAp entryAp, Map<String, EntryFieldGroupAp> entryGroups, BaseColumn columnInfo, boolean isTemplate, MemberShowType memberShowType) {
        DateField dateTimeField;
        TextField field;
        String name = columnInfo.getTitle();
        String key = columnInfo.getKey();
        FieldTypeEnum type = columnInfo.getFieldtype();
        EntryFieldAp fieldAp = null;
        if (FieldTypeEnum.IntField == type) {
            DimensionDataColumn dimensionDataColumn;
            NumberColumn numberColumn;
            MeasureColumn column;
            Boolean summaryDisplay;
            fieldAp = ApplyTemplateUtils.createEntryFieldAp(key, name);
            if (columnInfo.getWidth() != null) {
                fieldAp.setWidth(new LocaleString(columnInfo.getWidth().toString() + "px"));
            }
            IntegerField integerField = new IntegerField();
            integerField.setId(key);
            integerField.setKey(key);
            integerField.setMustInput(columnInfo.getIsmustinput().booleanValue());
            if (isTemplate) {
                integerField.setMustInput(false);
            }
            fieldAp.setField((Field)integerField);
            entryAp.getItems().add(fieldAp);
            if (columnInfo instanceof MeasureColumn && (summaryDisplay = Boolean.valueOf((column = (MeasureColumn)columnInfo).isSummaryDisplay())).booleanValue()) {
                fieldAp.setSummary(1);
            }
            if (columnInfo instanceof NumberColumn && (summaryDisplay = Boolean.valueOf((numberColumn = (NumberColumn)columnInfo).isSummaryDisplay())).booleanValue()) {
                fieldAp.setSummary(1);
            }
            if (columnInfo instanceof DimensionDataColumn && (summaryDisplay = Boolean.valueOf((dimensionDataColumn = (DimensionDataColumn)columnInfo).isSummaryDisplay())).booleanValue()) {
                fieldAp.setSummary(1);
            }
        } else if (FieldTypeEnum.NumberField == type) {
            fieldAp = ApplyTemplateUtils.createEntryFieldAp(key, name);
            if (columnInfo.getWidth() != null) {
                fieldAp.setWidth(new LocaleString(columnInfo.getWidth().toString() + "px"));
            }
            DecimalField decimalField = new DecimalField();
            decimalField.setId(key);
            decimalField.setKey(key);
            decimalField.setZeroShow(true);
            decimalField.setMustInput(columnInfo.getIsmustinput().booleanValue());
            if (isTemplate) {
                decimalField.setMustInput(false);
            }
            decimalField.setScale(columnInfo.getScale());
            decimalField.setPrecision(17);
            fieldAp.setField((Field)decimalField);
            String zero = "00000000000000";
            if (columnInfo instanceof NumberColumn) {
                NumberColumn numberColumn = (NumberColumn)columnInfo;
                Integer decimaldigit = numberColumn.getDecimaldigit();
                boolean ispercentage = numberColumn.isIspercentage();
                if (decimaldigit == null) {
                    decimaldigit = 0;
                }
                if (ispercentage) {
                    if (decimaldigit == 0) {
                        fieldAp.setDisplayFormatString("#%");
                    } else {
                        fieldAp.setDisplayFormatString("#." + zero.substring(0, decimaldigit) + "%");
                    }
                    decimalField.setScale(decimaldigit + 2);
                } else {
                    decimalField.setScale(decimaldigit.intValue());
                }
                Boolean summaryDisplay = numberColumn.isSummaryDisplay();
                if (summaryDisplay.booleanValue()) {
                    fieldAp.setSummary(1);
                }
            } else if (columnInfo instanceof MeasureColumn) {
                MeasureColumn column = (MeasureColumn)columnInfo;
                Boolean summaryDisplay = column.isSummaryDisplay();
                if (summaryDisplay.booleanValue()) {
                    fieldAp.setSummary(1);
                }
            } else if (columnInfo instanceof DimensionDataColumn) {
                DimensionDataColumn dimensionDataColumn = (DimensionDataColumn)columnInfo;
                Boolean summaryDisplay = dimensionDataColumn.isSummaryDisplay();
                boolean isBfb = dimensionDataColumn.isViewPercentageSign();
                if (isBfb) {
                    if (columnInfo.getScale() == 0) {
                        fieldAp.setDisplayFormatString("#%");
                    } else {
                        fieldAp.setDisplayFormatString("#." + zero.substring(0, columnInfo.getScale()) + "%");
                    }
                    decimalField.setScale(columnInfo.getScale() + 2);
                } else {
                    decimalField.setScale(columnInfo.getScale());
                }
                if (summaryDisplay.booleanValue()) {
                    fieldAp.setSummary(1);
                }
            }
            ApplyTemplateUtils.addFieldApToEntryAp(entryAp, entryGroups, columnInfo, key, fieldAp);
        } else if (FieldTypeEnum.TextField == type) {
            fieldAp = ApplyTemplateUtils.createEntryFieldAp(key, name);
            if (columnInfo.getWidth() != null) {
                fieldAp.setWidth(new LocaleString(columnInfo.getWidth().toString() + "px"));
            }
            field = new TextField();
            field.setId(key);
            field.setKey(key);
            field.setMustInput(columnInfo.getIsmustinput().booleanValue());
            if (isTemplate) {
                field.setMustInput(false);
            }
            if (columnInfo instanceof TextColumn) {
                TextColumn columnInfo1 = (TextColumn)columnInfo;
                field.setMaxLength(columnInfo1.getMaxLength());
                field.setEditStyle(columnInfo1.getEditStyle());
                fieldAp.setHyperlink(columnInfo1.isHyperLink());
                if (!columnInfo1.isBaseVisible()) {
                    fieldAp.setVisible("");
                }
            }
            field.setMaxLength(500);
            fieldAp.setField((Field)field);
            ApplyTemplateUtils.addFieldApToEntryAp(entryAp, entryGroups, columnInfo, key, fieldAp);
        } else if (FieldTypeEnum.BaseDataField == type) {
            fieldAp = ApplyTemplateUtils.createEntryFieldAp(key, name);
            if (columnInfo.getWidth() != null) {
                fieldAp.setWidth(new LocaleString(columnInfo.getWidth().toString() + "px"));
            }
            fieldAp.setQuickAddNew(false);
            field = new BasedataField();
            field.setMustInput(columnInfo.getIsmustinput().booleanValue());
            if (isTemplate) {
                field.setMustInput(false);
            }
            field.setKey(key);
            field.setId(key);
            fieldAp.setField((Field)field);
            field.setViewDetail(false);
            if (memberShowType != null && StringUtils.isNotEmpty((CharSequence)memberShowType.getProp())) {
                field.setDisplayProp(memberShowType.getProp());
            }
            ApplyTemplateUtils.addFieldApToEntryAp(entryAp, entryGroups, columnInfo, key, fieldAp);
        } else if (FieldTypeEnum.Boolean == type) {
            fieldAp = new EntryFieldAp();
            if (columnInfo.getWidth() != null) {
                fieldAp.setWidth(new LocaleString(columnInfo.getWidth().toString() + "px"));
            }
            fieldAp.setName(new LocaleString(name));
            fieldAp.setKey(key);
            fieldAp.setLabelDirection("true");
            fieldAp.setId(key);
            fieldAp.setFireUpdEvt(true);
            CheckBoxField checkbox = new CheckBoxField();
            checkbox.setId(key);
            checkbox.setKey(key);
            fieldAp.setField((Field)checkbox);
            ApplyTemplateUtils.addFieldApToEntryAp(entryAp, entryGroups, columnInfo, key, fieldAp);
        } else if (FieldTypeEnum.Date == type) {
            fieldAp = ApplyTemplateUtils.createEntryFieldAp(key, name);
            if (columnInfo.getWidth() != null) {
                fieldAp.setWidth(new LocaleString(columnInfo.getWidth().toString() + "px"));
            }
            fieldAp.setFireUpdEvt(true);
            dateTimeField = new DateField();
            dateTimeField.setId(key);
            dateTimeField.setKey(key);
            dateTimeField.setMustInput(columnInfo.getIsmustinput().booleanValue());
            if (isTemplate) {
                dateTimeField.setMustInput(false);
            }
            fieldAp.setField((Field)dateTimeField);
            ApplyTemplateUtils.addFieldApToEntryAp(entryAp, entryGroups, columnInfo, key, fieldAp);
        } else if (FieldTypeEnum.EnumField == type) {
            fieldAp = ApplyTemplateUtils.createEntryFieldAp(key, name);
            if (columnInfo.getWidth() != null) {
                fieldAp.setWidth(new LocaleString(columnInfo.getWidth().toString() + "px"));
            }
            ComboField combo = new ComboField();
            combo.setId(key);
            combo.setKey(key);
            combo.setMustInput(columnInfo.getIsmustinput().booleanValue());
            if (isTemplate) {
                combo.setMustInput(false);
            }
            combo.setEditable(false);
            ArrayList<kd.bos.metadata.entity.commonfield.ComboItem> list = new ArrayList<kd.bos.metadata.entity.commonfield.ComboItem>(3);
            List enumdata = columnInfo.getEnumdata();
            if (CollectionUtils.isNotEmpty((Collection)enumdata)) {
                for (int i = 0; i < enumdata.size(); ++i) {
                    ComboItem comboItem = (ComboItem)enumdata.get(i);
                    String value = comboItem.getValue();
                    LocaleString caption = comboItem.getCaption();
                    kd.bos.metadata.entity.commonfield.ComboItem combo1 = new kd.bos.metadata.entity.commonfield.ComboItem(i + 1, caption, value);
                    list.add(combo1);
                }
            }
            combo.setItems(list);
            fieldAp.setField((Field)combo);
            ApplyTemplateUtils.addFieldApToEntryAp(entryAp, entryGroups, columnInfo, key, fieldAp);
        } else if (FieldTypeEnum.DateTime == type) {
            fieldAp = ApplyTemplateUtils.createEntryFieldAp(key, name);
            if (columnInfo.getWidth() != null) {
                fieldAp.setWidth(new LocaleString(columnInfo.getWidth().toString() + "px"));
            }
            fieldAp.setFireUpdEvt(true);
            dateTimeField = new DateTimeField();
            dateTimeField.setId(key);
            dateTimeField.setKey(key);
            dateTimeField.setMustInput(columnInfo.getIsmustinput().booleanValue());
            if (isTemplate) {
                dateTimeField.setMustInput(false);
            }
            fieldAp.setField((Field)dateTimeField);
            ApplyTemplateUtils.addFieldApToEntryAp(entryAp, entryGroups, columnInfo, key, fieldAp);
        }
        if (!isTemplate && fieldAp != null) {
            if (!columnInfo.isFinalVisible()) {
                fieldAp.setVisible("");
            }
            if (!columnInfo.isEnable()) {
                fieldAp.setLock("new,edit,view");
            }
            fieldAp.setFreeze(columnInfo.isFreeze());
            ColumnStyle style = columnInfo.getStyle();
            if (style != null) {
                fieldAp.setBackColor(style.getBackColor());
                fieldAp.setHyperlink(style.isHyperlink());
            }
        }
        if (columnInfo instanceof RowDimensionColumn) {
            RowDimensionColumn rowDimensionColumn = (RowDimensionColumn)columnInfo;
            Boolean hide = rowDimensionColumn.getHide();
            boolean readonly = rowDimensionColumn.getReadonly();
            if (hide.booleanValue() && fieldAp != null) {
                fieldAp.setVisible("");
            }
            if (fieldAp != null && readonly) {
                fieldAp.setLock("new,edit,view");
            }
        }
        boolean ispullfrommodel = columnInfo.getIspullfrommodel();
        if (fieldAp != null && ispullfrommodel) {
            fieldAp.setLock("new,edit,view");
        }
    }

    public static EntryAp createEntryAp(String entityNumber, Collection<BaseColumn> collect) {
        return ApplyTemplateUtils.createEntryAp(entityNumber, collect, false);
    }

    private static void addFieldApToEntryAp(EntryAp entryAp, Map<String, EntryFieldGroupAp> entryGroups, BaseColumn columnInfo, String key, EntryFieldAp fieldAp) {
        if (entryGroups != null && StringUtils.isNotEmpty((CharSequence)columnInfo.getGrouptitle())) {
            EntryFieldGroupAp entryFieldGroupAp = new EntryFieldGroupAp();
            entryFieldGroupAp.setName(new LocaleString(columnInfo.getGrouptitle()));
            entryFieldGroupAp.setKey(key + "grpap");
            if (entryGroups.containsKey(columnInfo.getGrouptitle())) {
                entryFieldGroupAp = entryGroups.get(columnInfo.getGrouptitle());
                entryFieldGroupAp.getItems().add(fieldAp);
            } else {
                entryFieldGroupAp.getItems().add(fieldAp);
                entryGroups.put(columnInfo.getGrouptitle(), entryFieldGroupAp);
                entryAp.getItems().add(entryFieldGroupAp);
            }
        } else {
            entryAp.getItems().add(fieldAp);
        }
    }

    public static EntryFieldAp createEntryFieldAp(String key, String name) {
        EntryFieldAp fieldAp = new EntryFieldAp();
        fieldAp.setId(key);
        fieldAp.setKey(key);
        fieldAp.setName(new LocaleString(name));
        fieldAp.setFireUpdEvt(true);
        return fieldAp;
    }

    public static boolean initControl(OnGetControlArgs e, String controlKey, String entityNumber, EntryGrid grid, List<BaseColumn> currentColumnInfo) {
        BaseColumn columnInfo = null;
        for (BaseColumn column : currentColumnInfo) {
            if (!column.getKey().equals(controlKey)) continue;
            columnInfo = column;
            break;
        }
        if (columnInfo != null) {
            FieldTypeEnum type = columnInfo.getFieldtype();
            ApplyTemplateUtils.initControlNew(e, controlKey, entityNumber, grid, type, columnInfo);
            return true;
        }
        return false;
    }

    public static void initControlNew(OnGetControlArgs e, String controlKey, String entityNumber, EntryGrid grid, FieldTypeEnum type, BaseColumn columnInfo) {
        if (FieldTypeEnum.TextField == type) {
            TextEdit textEdit = new TextEdit();
            textEdit.setKey(controlKey);
            textEdit.setView(grid.getView());
            textEdit.setEntryKey(entityNumber);
            e.setControl((Control)textEdit);
        } else if (FieldTypeEnum.IntField == type) {
            IntegerEdit integerEdit = new IntegerEdit();
            integerEdit.setKey(controlKey);
            integerEdit.setView(grid.getView());
            integerEdit.setEntryKey(entityNumber);
            e.setControl((Control)integerEdit);
        } else if (FieldTypeEnum.NumberField == type) {
            DecimalEdit decimaledit = new DecimalEdit();
            decimaledit.setKey(controlKey);
            decimaledit.setEntryKey(entityNumber);
            decimaledit.setFlatField(true);
            decimaledit.setView(grid.getView());
            decimaledit.setFieldKey(controlKey);
            decimaledit.setModel(grid.getModel());
            decimaledit.setSensitiveInfo(true);
            e.setControl((Control)decimaledit);
        } else if (FieldTypeEnum.BaseDataField == type) {
            BasedataEdit bsEdit = new BasedataEdit();
            bsEdit.setKey(controlKey);
            bsEdit.setModel(grid.getModel());
            bsEdit.setView(grid.getView());
            bsEdit.setFieldKey(controlKey);
            bsEdit.setEntryKey(entityNumber);
            e.setControl((Control)bsEdit);
        } else if (FieldTypeEnum.EnumField == type) {
            ComboEdit comboEdit = new ComboEdit();
            comboEdit.setKey(controlKey);
            comboEdit.setModel(grid.getModel());
            comboEdit.setView(grid.getView());
            comboEdit.setFieldKey(controlKey);
            comboEdit.setEntryKey(entityNumber);
            e.setControl((Control)comboEdit);
        } else if (FieldTypeEnum.Boolean == type) {
            FieldEdit field = new FieldEdit();
            field.setKey(controlKey);
            field.setModel(grid.getModel());
            field.setView(grid.getView());
            field.setFieldKey(controlKey);
            field.setEntryKey(entityNumber);
            e.setControl((Control)field);
        } else if (FieldTypeEnum.Date == type) {
            DateEdit dateEdit = new DateEdit();
            dateEdit.setKey(controlKey);
            dateEdit.setModel(grid.getModel());
            dateEdit.setView(grid.getView());
            dateEdit.setFieldKey(controlKey);
            dateEdit.setEntryKey(entityNumber);
            e.setControl((Control)dateEdit);
        } else if (FieldTypeEnum.DateTime == type) {
            DateTimeEdit dateEdit = new DateTimeEdit();
            dateEdit.setKey(controlKey);
            dateEdit.setModel(grid.getModel());
            dateEdit.setView(grid.getView());
            dateEdit.setFieldKey(controlKey);
            dateEdit.setEntryKey(entityNumber);
            e.setControl((Control)dateEdit);
        }
    }

    public static void initControl(OnGetControlArgs e, String controlKey, String entityNumber, EntryGrid grid, FieldTypeEnum type) {
        if (FieldTypeEnum.TextField == type) {
            TextEdit textEdit = new TextEdit();
            textEdit.setKey(controlKey);
            textEdit.setView(grid.getView());
            textEdit.setEntryKey(entityNumber);
            e.setControl((Control)textEdit);
        } else if (FieldTypeEnum.IntField == type) {
            IntegerEdit integerEdit = new IntegerEdit();
            integerEdit.setKey(controlKey);
            integerEdit.setView(grid.getView());
            integerEdit.setEntryKey(entityNumber);
            e.setControl((Control)integerEdit);
        } else if (FieldTypeEnum.NumberField == type) {
            DecimalEdit decimaledit = new DecimalEdit();
            decimaledit.setKey(controlKey);
            decimaledit.setEntryKey(entityNumber);
            decimaledit.setFlatField(true);
            decimaledit.setView(grid.getView());
            decimaledit.setFieldKey(controlKey);
            decimaledit.setModel(grid.getModel());
            decimaledit.setSummary(1);
            decimaledit.setSensitiveInfo(true);
            e.setControl((Control)decimaledit);
        } else if (FieldTypeEnum.BaseDataField == type) {
            BasedataEdit bsEdit = new BasedataEdit();
            bsEdit.setKey(controlKey);
            bsEdit.setModel(grid.getModel());
            bsEdit.setView(grid.getView());
            bsEdit.setFieldKey(controlKey);
            bsEdit.setEntryKey(entityNumber);
            e.setControl((Control)bsEdit);
        } else if (FieldTypeEnum.EnumField == type) {
            ComboEdit comboEdit = new ComboEdit();
            comboEdit.setKey(controlKey);
            comboEdit.setModel(grid.getModel());
            comboEdit.setView(grid.getView());
            comboEdit.setFieldKey(controlKey);
            comboEdit.setEntryKey(entityNumber);
            e.setControl((Control)comboEdit);
        } else if (FieldTypeEnum.Boolean == type) {
            FieldEdit field = new FieldEdit();
            field.setKey(controlKey);
            field.setModel(grid.getModel());
            field.setView(grid.getView());
            field.setFieldKey(controlKey);
            field.setEntryKey(entityNumber);
            e.setControl((Control)field);
        } else if (FieldTypeEnum.Date == type) {
            DateEdit dateEdit = new DateEdit();
            dateEdit.setKey(controlKey);
            dateEdit.setModel(grid.getModel());
            dateEdit.setView(grid.getView());
            dateEdit.setFieldKey(controlKey);
            dateEdit.setEntryKey(entityNumber);
            e.setControl((Control)dateEdit);
        } else if (FieldTypeEnum.DateTime == type) {
            DateTimeEdit dateEdit = new DateTimeEdit();
            dateEdit.setKey(controlKey);
            dateEdit.setModel(grid.getModel());
            dateEdit.setView(grid.getView());
            dateEdit.setFieldKey(controlKey);
            dateEdit.setEntryKey(entityNumber);
            e.setControl((Control)dateEdit);
        }
    }

    public static String validateKeyIsRefrence(String key, List<BaseColumn> columns, String columnCategory) {
        String result = null;
        if (columns != null && !columns.isEmpty()) {
            String find;
            Matcher m;
            String formula;
            List numberColumns = columns.stream().filter(s -> s.getType() == ColumnEnum.NumberC && s.getCategory().equals(columnCategory)).collect(Collectors.toList());
            List dimensionDataColumns = columns.stream().filter(s -> s.getType() == ColumnEnum.DimensionData && s.getCategory().equals(columnCategory)).collect(Collectors.toList());
            List calColumns = columns.stream().filter(s -> s.getType() == ColumnEnum.Cal && s.getCategory().equals(columnCategory)).collect(Collectors.toList());
            String regex = "\\[(.*?)]";
            Pattern p = Pattern.compile(regex);
            if (numberColumns != null && !numberColumns.isEmpty()) {
                for (BaseColumn baseColumn : numberColumns) {
                    NumberColumn numberColumn = (NumberColumn)baseColumn;
                    formula = numberColumn.getFormula();
                    if (!StringUtils.isNotEmpty((CharSequence)formula)) continue;
                    m = p.matcher(formula);
                    while (m.find()) {
                        find = m.group(1).replaceAll("\"", "");
                        if (!StringUtils.equals((CharSequence)find, (CharSequence)key)) continue;
                        return baseColumn.getTitle();
                    }
                }
            }
            if (calColumns != null && !calColumns.isEmpty()) {
                for (BaseColumn baseColumn : calColumns) {
                    CalculateColumn calColumn = (CalculateColumn)baseColumn;
                    formula = calColumn.getFormula();
                    if (!StringUtils.isNotEmpty((CharSequence)formula)) continue;
                    m = p.matcher(formula);
                    while (m.find()) {
                        find = m.group(1).replaceAll("\"", "");
                        if (!StringUtils.equals((CharSequence)find, (CharSequence)key)) continue;
                        return baseColumn.getTitle();
                    }
                }
            }
            if (dimensionDataColumns != null && !dimensionDataColumns.isEmpty()) {
                for (BaseColumn baseColumn : dimensionDataColumns) {
                    DimensionDataColumn dimensionDataColumn = (DimensionDataColumn)baseColumn;
                    formula = dimensionDataColumn.getFormula();
                    if (!StringUtils.isNotEmpty((CharSequence)formula)) continue;
                    m = p.matcher(formula);
                    while (m.find()) {
                        find = m.group(1).replaceAll("\"", "");
                        if (!StringUtils.equals((CharSequence)find, (CharSequence)key)) continue;
                        return baseColumn.getTitle();
                    }
                }
            }
        }
        return result;
    }

    public static String validateKeyIsRefrenceSummary(String key, List<BaseColumn> columns) {
        String result = null;
        if (StringUtils.isEmpty((CharSequence)key)) {
            return null;
        }
        if (columns != null && !columns.isEmpty()) {
            ArrayList<ColumnEnum> summaryColumnType = new ArrayList<ColumnEnum>();
            summaryColumnType.add(ColumnEnum.Cal);
            summaryColumnType.add(ColumnEnum.NumberC);
            summaryColumnType.add(ColumnEnum.Measure);
            summaryColumnType.add(ColumnEnum.RelationValue);
            List summaryColumns = columns.stream().filter(s -> summaryColumnType.contains(s.getType()) && s.getCategory().equals("e")).collect(Collectors.toList());
            if (summaryColumns != null && !summaryColumns.isEmpty()) {
                for (BaseColumn baseColumn : summaryColumns) {
                    RelationValueColumn RelationValueColumn2;
                    ColumnEnum type = baseColumn.getType();
                    if (type == ColumnEnum.Cal) {
                        CalculateColumn calColumn = (CalculateColumn)baseColumn;
                        if (!calColumn.isIssummary() || !StringUtils.equals((CharSequence)calColumn.getHcolumnkey(), (CharSequence)key)) continue;
                        return calColumn.getTitle();
                    }
                    if (type == ColumnEnum.NumberC) {
                        NumberColumn numberColumn = (NumberColumn)baseColumn;
                        if (!numberColumn.isIssummary() || !StringUtils.equals((CharSequence)numberColumn.getHcolumnkey(), (CharSequence)key)) continue;
                        return numberColumn.getTitle();
                    }
                    if (type == ColumnEnum.Measure) {
                        MeasureColumn measureColumn = (MeasureColumn)baseColumn;
                        if (!measureColumn.isIssummary() || !StringUtils.equals((CharSequence)measureColumn.getHcolumnkey(), (CharSequence)key)) continue;
                        return measureColumn.getTitle();
                    }
                    if (type != ColumnEnum.RelationValue || !(RelationValueColumn2 = (RelationValueColumn)baseColumn).isIssummary() || !StringUtils.equals((CharSequence)RelationValueColumn2.getHcolumnkey(), (CharSequence)key)) continue;
                    return RelationValueColumn2.getTitle();
                }
            }
        }
        return result;
    }

    public static void replaceKeyForformula(Map<String, String> keys, Collection<BaseColumn> columns) {
        if (CollectionUtils.isNotEmpty(columns)) {
            for (BaseColumn column : columns) {
                String formula;
                CalculateColumn calculateColumn;
                if (column instanceof CalculateColumn) {
                    calculateColumn = (CalculateColumn)column;
                    formula = ApplyTemplateUtils.replaceFormulaColumnKeys(keys, calculateColumn.getFormula());
                    calculateColumn.setFormula(formula);
                    continue;
                }
                if (column instanceof NumberColumn) {
                    calculateColumn = (NumberColumn)column;
                    formula = ApplyTemplateUtils.replaceFormulaColumnKeys(keys, calculateColumn.getFormula());
                    calculateColumn.setFormula(formula);
                    continue;
                }
                if (!(column instanceof DimensionDataColumn)) continue;
                calculateColumn = (DimensionDataColumn)column;
                formula = ApplyTemplateUtils.replaceFormulaColumnKeys(keys, calculateColumn.getFormula());
                calculateColumn.setFormula(formula);
            }
        }
    }

    private static String replaceFormulaColumnKeys(Map<String, String> keys, String formula) {
        for (Map.Entry<String, String> key : keys.entrySet()) {
            String oldKey = key.getKey();
            String newKey = key.getValue();
            if (!formula.contains(oldKey)) continue;
            formula = formula.replaceAll(oldKey, newKey);
        }
        return formula;
    }

    public static void registEntryDynamicProps(EntryType entryType, List<BaseColumn> entry_collect) {
        for (BaseColumn columnInfo : entry_collect) {
            DateProp dateProp;
            String key = columnInfo.getKey();
            String name = columnInfo.getTitle();
            if (columnInfo.getFieldtype() == FieldTypeEnum.IntField) {
                IntegerProp integerProp = ApplyTemplateUtils.createIntegerProp(key, name);
                entryType.addProperty((DynamicProperty)integerProp);
                continue;
            }
            if (columnInfo.getFieldtype() == FieldTypeEnum.TextField) {
                TextProp textProp = ApplyTemplateUtils.createTextProp(key, name);
                entryType.addProperty((DynamicProperty)textProp);
                continue;
            }
            if (columnInfo.getFieldtype() == FieldTypeEnum.NumberField) {
                DecimalProp decimalProp = ApplyTemplateUtils.createDecimalProp(key, name);
                decimalProp.setScale(10);
                entryType.addProperty((DynamicProperty)decimalProp);
                continue;
            }
            if (columnInfo.getFieldtype() == FieldTypeEnum.BaseDataField) {
                BasedataProp basedataProp = ApplyTemplateUtils.createBaseDataProp(key, columnInfo.getBaseEntityId());
                entryType.addProperty((DynamicProperty)basedataProp);
                entryType.addProperty((DynamicProperty)((LongProp)basedataProp.getRefIdProp()));
                continue;
            }
            if (columnInfo.getFieldtype() == FieldTypeEnum.Boolean) {
                BooleanProp booleanProp = ApplyTemplateUtils.createCheckBoxProp(key, name);
                entryType.addProperty((DynamicProperty)booleanProp);
                continue;
            }
            if (columnInfo.getFieldtype() == FieldTypeEnum.Date) {
                dateProp = ApplyTemplateUtils.createDateProp(key, name);
                entryType.addProperty((DynamicProperty)dateProp);
                continue;
            }
            if (columnInfo.getFieldtype() == FieldTypeEnum.EnumField) {
                ComboProp comboProp = ApplyTemplateUtils.createComboProp(key, name);
                entryType.addProperty((DynamicProperty)comboProp);
                continue;
            }
            if (columnInfo.getFieldtype() != FieldTypeEnum.DateTime) continue;
            dateProp = ApplyTemplateUtils.createDateTimeProp(key, name);
            entryType.addProperty((DynamicProperty)dateProp);
        }
    }

    public static TextProp createTextProp(String key, String name) {
        TextProp textProp = new TextProp();
        textProp.setName(key);
        textProp.setDisplayName(new LocaleString(name));
        textProp.setDbIgnore(true);
        textProp.setAlias("");
        return textProp;
    }

    private static DecimalProp createDecimalProp(String key, String name) {
        DecimalProp decimalProp = new DecimalProp();
        decimalProp.setName(key);
        decimalProp.setDisplayName(new LocaleString(name));
        decimalProp.setDbIgnore(true);
        decimalProp.setAlias("");
        decimalProp.setDbType(0);
        decimalProp.setZeroShow(true);
        return decimalProp;
    }

    private static BooleanProp createCheckBoxProp(String key, String name) {
        BooleanProp booleanProp = new BooleanProp();
        booleanProp.setName(key);
        booleanProp.setDbIgnore(true);
        return booleanProp;
    }

    private static DateProp createDateProp(String key, String name) {
        DateProp dateProp = new DateProp();
        dateProp.setName(key);
        dateProp.setDisplayName(new LocaleString(name));
        dateProp.setDbIgnore(true);
        dateProp.setAlias("");
        dateProp.setDbType(0);
        return dateProp;
    }

    private static DateTimeProp createDateTimeProp(String key, String name) {
        DateTimeProp dateProp = new DateTimeProp();
        dateProp.setName(key);
        dateProp.setDisplayName(new LocaleString(name));
        dateProp.setDbIgnore(true);
        dateProp.setAlias("");
        dateProp.setDbType(0);
        return dateProp;
    }

    private static ComboProp createComboProp(String key, String name) {
        ComboProp comboProp = new ComboProp();
        comboProp.setName(key);
        comboProp.setDisplayName(new LocaleString(name));
        comboProp.setDbIgnore(true);
        comboProp.setAlias("");
        comboProp.setDbType(0);
        return comboProp;
    }

    private static IntegerProp createIntegerProp(String key, String name) {
        IntegerProp integerProp = new IntegerProp();
        integerProp.setName(key);
        integerProp.setDisplayName(new LocaleString(name));
        integerProp.setDbIgnore(true);
        integerProp.setAlias("");
        return integerProp;
    }

    public static BasedataProp createBaseDataProp(String key, String refBaseDataKey) {
        BasedataProp basedataProp = new BasedataProp();
        LongProp idprop = new LongProp();
        basedataProp.setDbIgnore(true);
        idprop.setDbIgnore(true);
        idprop.setName(key + "_id");
        basedataProp.setName(key);
        basedataProp.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)refBaseDataKey));
        basedataProp.setBaseEntityId(refBaseDataKey);
        basedataProp.setRefIdProp((IDataEntityProperty)idprop);
        basedataProp.setRefIdPropName(idprop.getName());
        return basedataProp;
    }

    public static void setEntryEntiryDefaultValueByDim(String tablename, String pkValue, List<BaseColumn> collect, DynamicObjectCollection entryEntity, String rowSourceBillNumber, BigDecimal unitData, Set<String> currencyColKeys, String tabkey, Long modelId, Map<String, Long> rowDimGroup, Map<String, Long> hideDimMembers, EntryTemplateConfig entryTemplateConfig) {
        entryEntity.clear();
        StringBuilder selectfield = new StringBuilder("fid");
        for (BaseColumn coll : collect) {
            if (coll.getKey().startsWith(FIELD_COMBINEDIMENSION)) {
                selectfield.append(",").append(FIELDSQL_COMBINEDIMENSION);
                continue;
            }
            if (coll.getKey().startsWith(FIELD_DETAILID)) {
                selectfield.append(",").append(FIELDSQL_DETAILID);
                continue;
            }
            if (coll.getKey().startsWith(FIELD_BUSPLANDETAIL)) {
                selectfield.append(",").append(FIELDSQL_BUSPLANDETAIL);
                continue;
            }
            if (coll.getKey().startsWith(FIELD_BIZPLAN_TABKEY)) {
                selectfield.append(",").append(FIELDSQL_BIZPLAN_TABKEY);
                continue;
            }
            selectfield.append(",f").append(coll.getKey());
        }
        String sql = "SELECT " + selectfield + " FROM " + tablename + " t WHERE t.fcombinedimension = '" + pkValue + "' and fbillnumber = '" + rowSourceBillNumber + "'";
        if (StringUtils.isNotEmpty((CharSequence)tabkey)) {
            sql = sql + " and " + FIELDSQL_BIZPLAN_TABKEY + "='" + tabkey + "'";
        }
        try (DataSet ds = DB.queryDataSet((String)"setEntryEntiryDefaultValue", (DBRoute)BgBaseConstant.epm, (String)sql);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                DynamicObject dynamicObject = entryEntity.addNew();
                for (BaseColumn coll : collect) {
                    BaseColumn baseColumn;
                    Optional<BaseColumn> first;
                    NumberColumn column;
                    if (coll.getFieldtype() == FieldTypeEnum.BaseDataField) {
                        Long o = (Long)row.get("f" + coll.getKey());
                        if (o == 0L) {
                            dynamicObject.set(coll.getKey(), null);
                        } else {
                            DynamicObject dynamicObject1 = BusinessDataServiceHelper.loadSingleFromCache((Object)o, (String)coll.getBaseEntityId());
                            dynamicObject.set(coll.getKey(), (Object)dynamicObject1);
                        }
                    } else if (coll.getKey().startsWith(FIELD_COMBINEDIMENSION)) {
                        dynamicObject.set(coll.getKey(), row.get(FIELDSQL_COMBINEDIMENSION));
                    } else if (coll.getKey().startsWith(FIELD_DETAILID)) {
                        dynamicObject.set(coll.getKey(), row.get(FIELDSQL_DETAILID));
                    } else if (coll.getKey().startsWith(FIELD_BUSPLANDETAIL)) {
                        dynamicObject.set(coll.getKey(), row.get(FIELDSQL_BUSPLANDETAIL));
                    } else if (coll.getKey().startsWith(FIELD_BIZPLAN_TABKEY)) {
                        dynamicObject.set(coll.getKey(), row.get(FIELDSQL_BIZPLAN_TABKEY));
                    } else {
                        Object colVal = row.get("f" + coll.getKey());
                        if (currencyColKeys.contains(coll.getKey()) && colVal instanceof BigDecimal) {
                            colVal = ((BigDecimal)colVal).divide(unitData);
                        }
                        dynamicObject.set(coll.getKey(), colVal);
                    }
                    if (coll instanceof DimensionDataColumn) {
                        List bizCloumn = collect.stream().filter(e -> e instanceof RowDimensionColumn && ((RowDimensionColumn)e).getBizPlanTabKey().equals(tabkey)).collect(Collectors.toList());
                        HashMap<String, Long> bizRowDimGroup = new HashMap<String, Long>(16);
                        for (BaseColumn baseColumn2 : bizCloumn) {
                            RowDimensionColumn rowDimensionColumn = (RowDimensionColumn)baseColumn2;
                            if (row.getLong("f" + baseColumn2.getKey()) > 0L) {
                                bizRowDimGroup.put(rowDimensionColumn.getDimNumber(), row.getLong("f" + baseColumn2.getKey()));
                                continue;
                            }
                            Long aLong = rowDimGroup.get(rowDimensionColumn.getDimNumber());
                            if (aLong == null || aLong <= 0L) continue;
                            bizRowDimGroup.put(rowDimensionColumn.getDimNumber(), aLong);
                        }
                        if (ApplyTemplateUtils.queryDimPerMemer(coll, modelId, entryTemplateConfig.getDatasetId(), bizRowDimGroup, hideDimMembers)) continue;
                        dynamicObject.set(coll.getKey(), (Object)0);
                        continue;
                    }
                    if (!(coll instanceof NumberColumn) || !(column = (NumberColumn)coll).isIssummary() || !(first = entryTemplateConfig.getEntryColumns().stream().filter(e -> e instanceof DimensionDataColumn && e.getKey().equals(column.getHcolumnkey())).findFirst()).isPresent() || ApplyTemplateUtils.queryDimPerMemer(baseColumn = first.get(), modelId, entryTemplateConfig.getDatasetId(), rowDimGroup, entryTemplateConfig.getHiddenDimMemMap())) continue;
                    dynamicObject.set(coll.getKey(), (Object)0);
                }
            }
        }
    }

    private static boolean queryDimPerMemer(BaseColumn column, Long modelId, Long datasetId, Map<String, Long> rowDimGroup, Map<String, Long> hideDimMembers) {
        HashMap<String, Long> allDimGroup = new HashMap<String, Long>(16);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Map<String, Long> dimMeasureGroup = BgApplyBillUtils.getInstance().getDimMembersFromMeasureColumnIds(modelCacheHelper, column);
        allDimGroup.putAll(dimMeasureGroup);
        allDimGroup.putAll(rowDimGroup);
        allDimGroup.putAll(hideDimMembers);
        DimMemberPermChecker readPermChecker = DimMembPermHelper.getReadPermChecker((Long)modelId, (Long)datasetId);
        HashMap memberGroup = new HashMap(16);
        for (Map.Entry dimEntry : allDimGroup.entrySet()) {
            MemberItem mi = new MemberItem(true, (Long)dimEntry.getValue());
            memberGroup.put(dimEntry.getKey(), mi);
        }
        if (readPermChecker.hasAllPerm()) {
            return true;
        }
        return readPermChecker.check(memberGroup);
    }

    public static void getHaveDataTableKeys(String tablename, String pkValue, List<BaseColumn> collect, String rowSourceBillNumber, String tabkey, List<String> openTableKeys) {
        StringBuilder selectfield = new StringBuilder("fid");
        for (BaseColumn coll : collect) {
            if (coll.getKey().startsWith(FIELD_COMBINEDIMENSION)) {
                selectfield.append(",").append(FIELDSQL_COMBINEDIMENSION);
                continue;
            }
            if (coll.getKey().startsWith(FIELD_DETAILID)) {
                selectfield.append(",").append(FIELDSQL_DETAILID);
                continue;
            }
            if (coll.getKey().startsWith(FIELD_BUSPLANDETAIL)) {
                selectfield.append(",").append(FIELDSQL_BUSPLANDETAIL);
                continue;
            }
            if (coll.getKey().startsWith(FIELD_BIZPLAN_TABKEY)) {
                selectfield.append(",").append(FIELDSQL_BIZPLAN_TABKEY);
                continue;
            }
            selectfield.append(",f").append(coll.getKey());
        }
        String sql = "SELECT " + selectfield + " FROM " + tablename + " t WHERE t.fcombinedimension = '" + pkValue + "' and fbillnumber = '" + rowSourceBillNumber + "'";
        if (StringUtils.isNotEmpty((CharSequence)tabkey)) {
            sql = sql + " and " + FIELDSQL_BIZPLAN_TABKEY + "='" + tabkey + "'";
        }
        try (DataSet ds = DB.queryDataSet((String)"setEntryEntiryDefaultValue", (DBRoute)BgBaseConstant.epm, (String)sql);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                Object fid = row.get("fid");
                if (fid == null) continue;
                openTableKeys.add(tabkey);
                break;
            }
        }
    }

    public static List<Object[]> getBatchBillData(String tablename, Set<String> billNumbers, List<BaseColumn> collect) {
        if (billNumbers.isEmpty()) {
            return new ArrayList<Object[]>(10);
        }
        String fieldSql = ApplyTemplateUtils.buildSqlStr(collect);
        StringBuilder sb = new StringBuilder("(");
        for (String billNum : billNumbers) {
            sb.append('\'').append(billNum).append('\'').append(',');
        }
        sb.setCharAt(sb.length() - 1, ')');
        StringBuilder stringBuilder = new StringBuilder("select ");
        stringBuilder.append(fieldSql).append(" from ").append(tablename).append(" where fbillnumber in ").append((CharSequence)sb);
        return ApplyTemplateUtils.getQueryData(collect, stringBuilder.toString());
    }

    public static List<Object[]> getBatchBillDataWhere(String tablename, Set<String> billNumbers, List<BaseColumn> collect, String wheresql) {
        if (billNumbers.isEmpty()) {
            return new ArrayList<Object[]>(10);
        }
        String fieldSql = ApplyTemplateUtils.buildSqlStr(collect);
        StringBuilder sb = new StringBuilder("(");
        for (String billNum : billNumbers) {
            sb.append('\'').append(billNum).append('\'').append(',');
        }
        sb.setCharAt(sb.length() - 1, ')');
        StringBuilder stringBuilder = new StringBuilder("select ");
        stringBuilder.append(fieldSql).append(" from ").append(tablename).append(" where fbillnumber in ").append((CharSequence)sb);
        if (StringUtils.isNotEmpty((CharSequence)wheresql)) {
            stringBuilder.append(" and ").append(wheresql);
        }
        return ApplyTemplateUtils.getQueryData(collect, stringBuilder.toString());
    }

    private static String buildSqlStr(List<BaseColumn> collect) {
        StringBuilder selectfield = new StringBuilder();
        for (String key : ApplyBillConstant.fixEntityTableKey) {
            selectfield.append(key).append(',');
        }
        selectfield.deleteCharAt(selectfield.length() - 1);
        for (BaseColumn coll : collect) {
            if (coll.isIgnoreDB()) continue;
            String columnKey = ApplyTemplateUtils.dealSpColumnKey(coll);
            selectfield.append(",f").append(columnKey);
        }
        return selectfield.toString();
    }

    public static String buildInsertSql(String tableName, List<BaseColumn> columns) {
        StringBuilder sql = new StringBuilder("insert into ").append(tableName).append("(");
        for (String key : ApplyBillConstant.fixEntityTableKey) {
            sql.append(key).append(',');
        }
        int valLength = ApplyBillConstant.fixEntityTableKey.length;
        for (BaseColumn column : columns) {
            if (column.getKey().endsWith("_text") || column.isIgnoreDB()) continue;
            ++valLength;
            String colKey = ApplyTemplateUtils.dealSpColumnKey(column);
            sql.append('f').append(colKey).append(',');
        }
        sql.setCharAt(sql.length() - 1, ')');
        sql.append(" values(");
        for (int i = 0; i < valLength; ++i) {
            sql.append('?').append(',');
        }
        sql.setCharAt(sql.length() - 1, ')');
        return sql.toString();
    }

    public static List<Object[]> getEntityData(String tablename, Object pkValue, List<BaseColumn> collect) {
        String selectfield = ApplyTemplateUtils.buildSqlStr(collect);
        String sql = "SELECT " + selectfield + " FROM " + tablename + " t WHERE t.fid = " + pkValue;
        List<Object[]> allValues = ApplyTemplateUtils.getQueryData(collect, sql);
        return allValues;
    }

    private static List<Object[]> getQueryData(List<BaseColumn> columns, String sql) {
        ArrayList<Object[]> allValues = new ArrayList<Object[]>();
        int valLength = ApplyBillConstant.fixEntityTableKey.length + columns.size();
        try (DataSet ds = DB.queryDataSet((String)"setEntryEntiryDefaultValue", (DBRoute)BgBaseConstant.epm, (String)sql);){
            while (ds != null && ds.hasNext()) {
                int index = 0;
                Object[] values = new Object[valLength];
                Row row = ds.next();
                for (String key : ApplyBillConstant.fixEntityTableKey) {
                    values[index++] = row.get(key);
                }
                for (BaseColumn coll : columns) {
                    if (coll.isIgnoreDB()) continue;
                    String fkey = ApplyTemplateUtils.dealSpColumnKey(coll);
                    values[index++] = row.get("f" + fkey);
                }
                allValues.add(values);
            }
        }
        catch (Exception e1) {
            log.error(CommonServiceHelper.getStackTraceStr((Throwable)e1));
        }
        return allValues;
    }

    public static String dealSpColumnKey(BaseColumn coll) {
        if (coll.getKey().startsWith(FIELD_COMBINEDIMENSION)) {
            return FIELDSQL_COMBINEDIMENSION1;
        }
        if (coll.getKey().startsWith(FIELD_DETAILID)) {
            return FIELDSQL_DETAILID1;
        }
        if (coll.getKey().startsWith(FIELD_BUSPLANDETAIL)) {
            return FIELDSQL_BUSPLANDETAIL1;
        }
        if (coll.getKey().startsWith(FIELD_BIZPLAN_TABKEY)) {
            return FIELDSQL_BIZPLAN_TABKEY1;
        }
        return coll.getKey();
    }

    public static void filterDataByOrg(List<Object[]> sourceData, List<BaseColumn> columns, Set<Long> orgIds, List<String> dimkeyList) {
        int entityKeyIndex = -1;
        int count = ApplyBillConstant.fixEntityTableKey.length;
        for (BaseColumn baseColumn : columns) {
            if (dimkeyList.contains(baseColumn.getKey()) && SysDimensionEnum.Entity.getMemberTreemodel().equals(baseColumn.getBaseEntityId())) {
                entityKeyIndex = count;
                break;
            }
            ++count;
        }
        if (entityKeyIndex > -1) {
            Iterator<Object[]> iterator = sourceData.iterator();
            while (iterator.hasNext()) {
                Object[] rowData = iterator.next();
                String dataType = (String)rowData[3];
                if (dataType != null && dataType.equals(EntityRowDataType.NEW_NOTDETAIL.getNumber()) || EntityRowDataType.EDIT_NOTDETAIL.getNumber().equals(dataType) || orgIds.contains(rowData[entityKeyIndex])) continue;
                iterator.remove();
            }
        }
    }

    public static void qFlterNoDetailRecord(List<Object[]> allData, Map<String, String> columnMapDimNum, IModelCacheHelper modelCacheHelper, Map<String, Long> dimNumMapViewId, List<String> dimListKeys, Map<String, Integer> columnIndex) {
        ArrayList<Object[]> noDetailData = new ArrayList<Object[]>();
        Iterator<Object[]> iterator = allData.iterator();
        while (iterator.hasNext()) {
            Object[] val = iterator.next();
            String dataType = (String)val[3];
            if (EntityRowDataType.EDIT_DETAIL.getNumber().equals(dataType) || EntityRowDataType.NEW_DETAIL.getNumber().equals(dataType)) continue;
            noDetailData.add(val);
            iterator.remove();
        }
        if (noDetailData.isEmpty()) {
            return;
        }
        ApplyTemplateUtils.qFlterNoDetailRecord(allData, noDetailData, columnMapDimNum, modelCacheHelper, dimNumMapViewId, dimListKeys, columnIndex);
        if (!noDetailData.isEmpty()) {
            allData.addAll(noDetailData);
        }
    }

    public static void qFlterNoDetailRecord(List<Object[]> detailData, List<Object[]> noDetailData, Map<String, String> columnMapDimNum, IModelCacheHelper modelCacheHelper, Map<String, Long> dimNumMapViewId, List<String> dimListKeys, Map<String, Integer> columnIndex) {
        HashMap<String, Map> detailMembIds = new HashMap<String, Map>();
        if (noDetailData.isEmpty()) {
            return;
        }
        Iterator<Object[]> iterator = noDetailData.iterator();
        String dimNum = null;
        while (iterator.hasNext()) {
            Object[] rowVals = iterator.next();
            boolean hasDetail = false;
            for (Object[] rows : detailData) {
                boolean matchRow = true;
                for (String dimKey : dimListKeys) {
                    Long id1 = (Long)rowVals[columnIndex.get(dimKey)];
                    Long id2 = (Long)rows[columnIndex.get(dimKey)];
                    Map longSetMap = detailMembIds.computeIfAbsent(dimKey, key -> new HashMap());
                    Set longs = longSetMap.computeIfAbsent(id1, id -> new HashSet());
                    dimNum = columnMapDimNum.get(dimKey);
                    if (longs.isEmpty()) {
                        ApplyTemplateUtils.getDetailMembIds(longs, modelCacheHelper, dimNum, dimNumMapViewId.get(dimNum), id1);
                    }
                    if (longs.contains(id2)) continue;
                    matchRow = false;
                    break;
                }
                if (!matchRow) continue;
                hasDetail = true;
                break;
            }
            if (hasDetail) continue;
            iterator.remove();
        }
    }

    private static void getDetailMembIds(Set<Long> longs, IModelCacheHelper modelCacheHelper, String dimNum, Long viewId, Long membId) {
        Member memb = modelCacheHelper.getMember(dimNum, viewId, membId);
        if (memb != null) {
            if (memb.isLeaf()) {
                longs.add(memb.getId());
            } else {
                for (Member member : memb.getAllMembers()) {
                    if (!member.isLeaf()) continue;
                    longs.add(member.getId());
                }
            }
        }
    }

    public static ApplyBillModel instanceApplyBillModel(DynamicObject billModel) {
        ApplyBillModel applyBillModel = new ApplyBillModel();
        applyBillModel.setApplyOrgId((Long)ApplyTemplateUtils.getValueFromDynamic(billModel.getDynamicObject("org"), "id"));
        applyBillModel.setYearId((Long)ApplyTemplateUtils.getValueFromDynamic(billModel.getDynamicObject("year"), "id"));
        applyBillModel.setBillNumber(billModel.getString("billnumber"));
        applyBillModel.setApplyDate(billModel.getDate("applydate"));
        applyBillModel.setApplyerId((Long)ApplyTemplateUtils.getValueFromDynamic(billModel.getDynamicObject("proposer"), "id"));
        applyBillModel.setCreaterId((Long)ApplyTemplateUtils.getValueFromDynamic(billModel.getDynamicObject("creater"), "id"));
        applyBillModel.setCreateDate(billModel.getDate("createdate"));
        applyBillModel.setModifierId((Long)ApplyTemplateUtils.getValueFromDynamic(billModel.getDynamicObject("modifier"), "id"));
        applyBillModel.setModifyDate(billModel.getDate("modifydate"));
        applyBillModel.setAuditorId((Long)ApplyTemplateUtils.getValueFromDynamic(billModel.getDynamicObject("auditor"), "id"));
        applyBillModel.setAuditDate(billModel.getDate("auditdate"));
        return applyBillModel;
    }

    private static <T> T getValueFromDynamic(DynamicObject object, String key) {
        if (object == null) {
            return null;
        }
        return (T)object.get(key);
    }

    public static Set<String> getColDimNums(String cachedata_tag) {
        HashSet<String> result = new HashSet<String>(16);
        if (StringUtils.isEmpty((CharSequence)cachedata_tag)) {
            return result;
        }
        List allList = SerializationUtils.fromJsonStringToList((String)cachedata_tag, TempDimConfig.class);
        for (TempDimConfig dimMap : allList) {
            if (!TempDimConfigType.COLDIM.getValue().equals(dimMap.getPanel())) continue;
            result.add(dimMap.getDimensionNumber());
        }
        return result;
    }

    public static Map<String, Integer> getColumnIndexMap(List<BaseColumn> columns) {
        HashMap<String, Integer> columnIndex = new HashMap<String, Integer>(columns.size() + ApplyBillConstant.fixEntityTableKey.length);
        int count = 0;
        for (String columnKey : ApplyBillConstant.fixEntityTableKey) {
            columnIndex.put(columnKey, count++);
        }
        for (BaseColumn column : columns) {
            if (column.getKey().endsWith("_text") || column.isIgnoreDB()) continue;
            columnIndex.put(column.getKey(), count++);
        }
        return columnIndex;
    }

    public static List<String> getNotTreeDimColumn(Collection<String> statisticsDimCfg, List<BaseColumn> columns, IModelCacheHelper modelCacheHelper) {
        ArrayList<String> notTreeDimColumns = new ArrayList<String>(16);
        columns.forEach(column -> {
            ColumnEnum type = column.getType();
            String dimNum = null;
            if (type == ColumnEnum.Dimension) {
                dimNum = ((DimensionColumn)column).getDimNumber();
            } else if (type == ColumnEnum.RowDimension) {
                dimNum = ((RowDimensionColumn)column).getDimNumber();
            } else if (type == ColumnEnum.RelationDimension) {
                Long dimId = ((RelationDimensionColumn)column).getDimensionId();
                dimNum = modelCacheHelper.getDimension(dimId).getNumber();
            }
            if (!(dimNum == null || statisticsDimCfg != null && statisticsDimCfg.contains(dimNum))) {
                notTreeDimColumns.add(column.getKey());
            }
        });
        return notTreeDimColumns;
    }

    public static boolean isMeasureColumn(BaseColumn column) {
        return column instanceof MeasureColumn || column instanceof DimensionDataColumn;
    }

    public static List<DataMapDimension> getColDimColumnMembInfo(BaseColumn column) {
        List dimMembInfo = null;
        if (column instanceof MeasureColumn) {
            dimMembInfo = ((MeasureColumn)column).getDataMapDimensions();
        } else if (column instanceof CalculateColumn) {
            dimMembInfo = ((CalculateColumn)column).getDataMapDimensions();
        } else if (column instanceof DimensionDataColumn) {
            dimMembInfo = ((DimensionDataColumn)column).getDataMapDimensions();
        }
        return dimMembInfo;
    }

    public static void selectDimMembInfoOnTemp(BgApplyENtryInfo eNtryInfo, Map<Long, Map<String, Long>> hideDimMap, Map<String, Map<String, Long>> colDimMap, IModelCacheHelper modelCacheHelper) {
        BgApplyBillUtils applyBillUtils = BgApplyBillUtils.getInstance();
        eNtryInfo.getEntryTemplateConfig().forEach((entityKey, tempConfig) -> {
            if (!applyBillUtils.isBizEntry((String)entityKey)) {
                hideDimMap.put(tempConfig.getTemplateID(), tempConfig.getHiddenDimMemMap());
                tempConfig.getEntryColumns().forEach(column -> {
                    List<DataMapDimension> colDimColumnMembInfo = ApplyTemplateUtils.getColDimColumnMembInfo(column);
                    if (colDimColumnMembInfo != null) {
                        HashMap membInfo = new HashMap(colDimColumnMembInfo.size());
                        colDimColumnMembInfo.forEach(memb -> {
                            Dimension dimension = modelCacheHelper.getDimension(Long.valueOf(memb.getDimensionId()));
                            membInfo.put(dimension.getNumber(), memb.getDimensionRememberId());
                        });
                        colDimMap.put(column.getKey(), membInfo);
                    }
                });
            }
        });
    }

    public static EntryTemplateConfig convertToBaseConfig(DynamicObject templateObj, FormTypeEnum formTypeEnumByBillType, IModelCacheHelper modelCacheHelper, Map<String, Map<String, String>> allDimValSetting) {
        Long templateId = templateObj.getLong("id");
        Long datasetId = templateObj.getLong("dataset.id");
        ColumnList columnList = ApplyTemplateUtils.getEntrycfgByApplyTemplate(templateObj);
        ApplyTemplateUtils.changeVarOnColumn(columnList, datasetId, modelCacheHelper, allDimValSetting);
        Collection columns = columnList.getColumns();
        Map entityinfomap = columnList.getEntityinfomap();
        List<BaseColumn> main_collect = columns.stream().filter(ee -> "h".equals(ee.getCategory())).collect(Collectors.toList());
        Map<ColCfgPropTypeEnum, Map<String, ColCfgPropEnum>> colConfigMap = ApplyTemplateColCfgService.getInstance().queryColCfgMapByTemplateId(templateId, formTypeEnumByBillType);
        Map<String, ColCfgPropEnum> colConfig = colConfigMap.get(ColCfgPropTypeEnum.EDIT_TYPE);
        ApplyBillPluginUitl.setColumnBaseStatus(main_collect, colConfig);
        EntryTemplateConfig templateConfig = ApplyBillPluginUitl.createMainEntryConfig(templateObj, main_collect, (String)entityinfomap.get(KEY_MAINENTRYENTITY), modelCacheHelper, colConfigMap, templateObj.getLong("dataset.id"), allDimValSetting);
        templateConfig.setApplyTemplateSubTotal(columnList.getApplyTemplateSubTotal());
        return templateConfig;
    }

    public static Map<Long, Pair<String, String>> getTempEntryTable(Collection<Long> tempIds) {
        Map tempObjs = BusinessDataServiceHelper.loadFromCache((Object[])tempIds.toArray(), (String)"eb_applytemplate");
        HashMap<Long, Pair<String, String>> result = new HashMap<Long, Pair<String, String>>(16);
        tempObjs.values().forEach(obj -> {
            ColumnList entrycfg = ApplyTemplateUtils.getEntrycfgByApplyTemplate(obj);
            Map tableInfo = entrycfg.getEntityinfomap();
            String mainTable = (String)tableInfo.get(KEY_MAINENTRYENTITY);
            String bizTable = (String)tableInfo.get(KEY_BIZMAINENTRYENTITY);
            result.put(obj.getLong("id"), new Pair((Object)mainTable, (Object)bizTable));
        });
        return result;
    }

    public static Map<String, List<String>> getRowDimisionAutoUpdateColumnKeys(Collection<BaseColumn> columns) {
        List rowDimensions = columns.stream().filter(s -> s.getType() == ColumnEnum.RowDimension).collect(Collectors.toList());
        HashMap<String, List<String>> map = new HashMap<String, List<String>>(16);
        if (rowDimensions.isEmpty()) {
            return map;
        }
        HashMap<String, List> columnKeyMapSchemeIds = new HashMap<String, List>(16);
        HashMap<String, Long> columnkeyMapDimId = new HashMap<String, Long>(16);
        for (Object rowDimension : rowDimensions) {
            RowDimensionColumn column = (RowDimensionColumn)rowDimension;
            Boolean enableDimensionRelation = column.getEnableDimensionRelation();
            List dimensionRelationSchemas = column.getDimensionRelationSchemas();
            if (!enableDimensionRelation.booleanValue() || dimensionRelationSchemas.isEmpty()) continue;
            columnkeyMapDimId.put(column.getKey(), column.getDimensionId());
            List schemes = columnKeyMapSchemeIds.computeIfAbsent(column.getKey(), s -> new ArrayList(16));
            schemes.addAll(dimensionRelationSchemas);
        }
        if (!columnKeyMapSchemeIds.isEmpty()) {
            ArrayList ids = new ArrayList(16);
            for (List value : columnKeyMapSchemeIds.values()) {
                ids.addAll(value);
            }
            QFilter filter = new QFilter("id", "in", ids);
            Map epmDimensionrelationMaps = BusinessDataServiceHelper.loadFromCache((String)"epm_dimensionrelation", (String)"id,entryentity,entryentity.dimension", (QFilter[])filter.toArray());
            ArrayList epmDimensionrelation = new ArrayList(epmDimensionrelationMaps.values());
            if (!epmDimensionrelation.isEmpty()) {
                for (Map.Entry colmap : columnKeyMapSchemeIds.entrySet()) {
                    String key = (String)colmap.getKey();
                    List schemeIds = (List)colmap.getValue();
                    Optional<BaseColumn> first = columns.stream().filter(s -> s.getKey().equals(key)).findFirst();
                    String tabkey = first.isPresent() ? first.get().getBizPlanTabKey() : "";
                    List datas = epmDimensionrelation.stream().filter(s -> schemeIds.contains(s.getLong("id"))).collect(Collectors.toList());
                    for (DynamicObject data : datas) {
                        DynamicObjectCollection entrys = data.getDynamicObjectCollection("entryentity");
                        List<Long> dimIds = entrys.stream().map(s -> s.getLong("dimension.id")).collect(Collectors.toList());
                        Long currentdimId = (Long)columnkeyMapDimId.get(key);
                        dimIds.remove(currentdimId);
                        if (dimIds.isEmpty()) continue;
                        List<Object> keysByDimensionId = new ArrayList();
                        if (tabkey == null || tabkey.equals("")) {
                            keysByDimensionId = ApplyTemplateUtils.getKeysByDimensionId(columns, dimIds);
                        } else {
                            List<BaseColumn> tabrowcolumns = columns.stream().filter(s -> tabkey.equals(s.getBizPlanTabKey())).collect(Collectors.toList());
                            keysByDimensionId = ApplyTemplateUtils.getKeysByDimensionId(tabrowcolumns, dimIds);
                        }
                        if (keysByDimensionId.isEmpty()) continue;
                        String sourceKey = String.join((CharSequence)"|", keysByDimensionId);
                        List target = map.computeIfAbsent(sourceKey, s -> new ArrayList(16));
                        target.add(key);
                    }
                }
            }
        }
        return map;
    }

    private static List<String> getKeysByDimensionId(Collection<BaseColumn> columns, List<Long> ids) {
        ArrayList<String> keys = new ArrayList<String>(16);
        for (BaseColumn column : columns) {
            RowDimensionColumn column1;
            if (column.getType() == ColumnEnum.RowDimension) {
                column1 = (RowDimensionColumn)column;
                if (!ids.contains(column1.getDimensionId())) continue;
                keys.add(column.getKey());
                continue;
            }
            if (column.getType() == ColumnEnum.RelationDimension) {
                column1 = (RelationDimensionColumn)column;
                if (!ids.contains(column1.getDimensionId())) continue;
                keys.add(column.getKey());
                continue;
            }
            if (column.getType() != ColumnEnum.Dimension || !ids.contains((column1 = (DimensionColumn)column).getDimensionId())) continue;
            keys.add(column.getKey());
        }
        return keys;
    }

    public static List<MemberQuoteDao> getTemplateMemberQuotes(Long modelId, Long datasetId, Long resourceId, ColumnList columnList, List<TempDimConfig> mainHideDimConfigList, IModelCacheHelper modelCache) {
        List bizTableConfigList;
        if (IDUtils.isNull((Long)modelId) || IDUtils.isNull((Long)resourceId) || modelCache == null || columnList == null) {
            return Collections.emptyList();
        }
        ApplyTemplateDimAreaCfgService dimAreaCfgService = ApplyTemplateDimAreaCfgService.getInstance();
        LinkedList<MemberQuoteDao> quotes = new LinkedList<MemberQuoteDao>();
        Map dimensionMap = modelCache.getDimensionMap();
        if (IDUtils.isNotNull((Long)datasetId)) {
            quotes.add(new MemberQuoteDao(modelId, datasetId, Long.valueOf(0L), datasetId, MemberTypeEnum.DATASET, MemberQuoteResourceEnum.ApplyTemplate, resourceId));
        }
        for (BaseColumn _column : columnList.getColumns()) {
            List<DataMapDimension> dataMapDimensions;
            if (_column instanceof RowDimensionColumn) {
                RowDimensionColumn _dimCol = (RowDimensionColumn)_column;
                Dimension _dimension = (Dimension)dimensionMap.get(_dimCol.getDimNumber());
                List dimensionMemberRanges = _dimCol.getDimensionMemberRanges();
                if (dimensionMemberRanges == null) continue;
                HashSet<Long> varIds = new HashSet<Long>(dimensionMemberRanges.size());
                HashSet<Long> memberIds = new HashSet<Long>(dimensionMemberRanges.size());
                for (DimensionMemberRange member : dimensionMemberRanges) {
                    if (member.isVar()) {
                        varIds.add(Long.valueOf(member.getId()));
                        continue;
                    }
                    memberIds.add(Long.valueOf(member.getId()));
                }
                if (memberIds.size() > 0) {
                    quotes.add(new MemberQuoteDao(modelId, datasetId, _dimension.getId(), memberIds, MemberQuoteResourceEnum.ApplyTemplate, resourceId));
                }
                if (varIds.size() <= 0) continue;
                quotes.add(new MemberQuoteDao(modelId, Long.valueOf(0L), _dimension.getId(), varIds, MemberTypeEnum.VARIABLE, MemberQuoteResourceEnum.ApplyTemplate, resourceId));
                continue;
            }
            if (!dimAreaCfgService.isShowDataDimensionMappingColumn(_column) || (dataMapDimensions = dimAreaCfgService.getColumnDataMapDimensions(_column)) == null) continue;
            for (DataMapDimension member : dataMapDimensions) {
                if (member.isVar()) {
                    quotes.add(new MemberQuoteDao(modelId, Long.valueOf(0L), Long.valueOf(member.getDimensionId()), Long.valueOf(member.getDimensionRememberId()), MemberTypeEnum.VARIABLE, MemberQuoteResourceEnum.ApplyTemplate, resourceId));
                    continue;
                }
                quotes.add(new MemberQuoteDao(modelId, datasetId, Long.valueOf(member.getDimensionId()), Long.valueOf(member.getDimensionRememberId()), MemberQuoteResourceEnum.ApplyTemplate, resourceId));
            }
        }
        if (mainHideDimConfigList != null) {
            for (TempDimConfig dimConfig : mainHideDimConfigList) {
                Long dimensionId = IDUtils.toLong((Object)dimConfig.getDimensionId());
                Long memId = IDUtils.toLong((Object)dimConfig.getMemberId());
                if (dimConfig.isVar()) {
                    quotes.add(new MemberQuoteDao(modelId, Long.valueOf(0L), dimensionId, memId, MemberTypeEnum.VARIABLE, MemberQuoteResourceEnum.ApplyTemplate, resourceId));
                    continue;
                }
                quotes.add(new MemberQuoteDao(modelId, datasetId, dimensionId, memId, MemberQuoteResourceEnum.ApplyTemplate, resourceId));
            }
        }
        if ((bizTableConfigList = columnList.getBizTableConfigList()) != null) {
            for (BizTableConfig bizTableConfig : bizTableConfigList) {
                Map bizHideDimConfig = bizTableConfig.getDimFlexInfo().getHidDimConfig();
                for (TempDimConfig dimConfig : bizHideDimConfig.values()) {
                    Long dimensionId = IDUtils.toLong((Object)dimConfig.getDimensionId());
                    Long memId = IDUtils.toLong((Object)dimConfig.getMemberId());
                    if (dimConfig.isVar()) {
                        quotes.add(new MemberQuoteDao(modelId, Long.valueOf(0L), dimensionId, memId, MemberTypeEnum.VARIABLE, MemberQuoteResourceEnum.ApplyTemplate, resourceId));
                        continue;
                    }
                    quotes.add(new MemberQuoteDao(modelId, datasetId, dimensionId, memId, MemberQuoteResourceEnum.ApplyTemplate, resourceId));
                }
            }
        }
        return quotes;
    }

    public static String getMapKeyByValue(Map<String, String> map, String value) {
        for (Map.Entry<String, String> stringStringEntry : map.entrySet()) {
            String value1 = stringStringEntry.getValue();
            String key1 = stringStringEntry.getKey();
            if (!value1.equals(value)) continue;
            return key1;
        }
        return null;
    }

    public static Set<String> notAggMetricColumn(Collection<BaseColumn> columns, Long modelId) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Dimension metricDim = modelCacheHelper.getDimension(SysDimensionEnum.Metric.getNumber());
        HashSet<String> result = new HashSet<String>(16);
        for (BaseColumn column : columns) {
            MeasureColumn column1;
            List dataMapDimensions = null;
            if (column instanceof MeasureColumn) {
                column1 = (MeasureColumn)column;
                dataMapDimensions = column1.getDataMapDimensions();
            } else if (column instanceof CalculateColumn) {
                column1 = (CalculateColumn)column;
                dataMapDimensions = column1.getDataMapDimensions();
            } else if (column instanceof DimensionDataColumn) {
                column1 = (DimensionDataColumn)column;
                dataMapDimensions = column1.getDataMapDimensions();
            }
            if (dataMapDimensions == null) continue;
            for (DataMapDimension dataMapDimension : dataMapDimensions) {
                Member member;
                if (dataMapDimension.getDimensionId() != metricDim.getId().longValue() || (member = modelCacheHelper.getMember(SysDimensionEnum.Metric.getNumber(), Long.valueOf(0L), Long.valueOf(dataMapDimension.getDimensionRememberId()))) == null || member.hasAgg() || !MetricDataTypeEnum.TEXT.getIndex().equals(member.getDatatype())) continue;
                result.add(column.getKey());
            }
        }
        return result;
    }
}

