/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.applybill.util;

import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.applybill.ApplyBillType;
import kd.epm.eb.common.centralapproval.CentralAppShowInfo;

public class BgApplyBillHelper {
    private static final BgApplyBillHelper instance = new BgApplyBillHelper();

    public static BgApplyBillHelper getInstance() {
        return instance;
    }

    public BaseShowParameter openAuditForm(CentralAppShowInfo centralAppShowInfo, String billType, boolean showData) {
        if (centralAppShowInfo.getTemplates().isEmpty()) {
            throw new KDBizException("template is empty");
        }
        ApplyBillType billTypeEnum = ApplyBillType.getBillTypeByNumber((String)billType);
        Long templateId = (Long)centralAppShowInfo.getTemplates().iterator().next();
        DynamicObject tempObj = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)"eb_applytemplate");
        DynamicObject dataset = tempObj.getDynamicObject("dataset");
        BaseShowParameter baseShowParameter = this.getBgApplyTypeBillFormShow(tempObj.getLong("model.id"), centralAppShowInfo.getCentralBillNo(), billTypeEnum);
        baseShowParameter.setCustomParam("bizCtrlRangeId", (Object)dataset.getLong("businessmodel.id"));
        baseShowParameter.setCustomParam("applyAuditParam", (Object)SerializationUtils.toJsonString((Object)centralAppShowInfo));
        baseShowParameter.setCustomParam("showData", (Object)showData);
        baseShowParameter.setCustomParam("billno", (Object)centralAppShowInfo.getBillNo());
        baseShowParameter.getOpenStyle().setTargetKey("flexpanelap1");
        baseShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        baseShowParameter.setCaption(ResManager.loadKDString((String)"\u7533\u62a5\u5ba1\u6279\u5355", (String)"BgApplyBillPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        return baseShowParameter;
    }

    public BaseShowParameter getBgApplyTypeBillFormShow(Long modelId, String billNumber, ApplyBillType billType) {
        return this.getBgApplyTypeBillFormShow(null, null, null, null, null, modelId, billNumber, billType);
    }

    public BaseShowParameter getBgApplyTypeBillFormShow(Long schemeId, Long modelId, String billNumber, ApplyBillType billType) {
        return this.getBgApplyTypeBillFormShow(schemeId, null, null, null, null, modelId, billNumber, billType);
    }

    public BaseShowParameter getBgApplyTypeBillFormShow(Long schemeId, Long yearId, Long versionId, Long dataTypeId, Long orgId, Long modelId, String billNumber, ApplyBillType billType) {
        String formKey = billType == ApplyBillType.SPLIT ? "eb_bgapplybill_split" : "eb_bgapplybill";
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId(formKey);
        baseShowParameter.setCustomParam("schemeId", (Object)schemeId);
        baseShowParameter.setCustomParam("versionId", (Object)versionId);
        baseShowParameter.setCustomParam("dataTypeId", (Object)dataTypeId);
        baseShowParameter.setCustomParam("yearId", (Object)yearId);
        baseShowParameter.setCustomParam("orgId", (Object)orgId);
        baseShowParameter.setCustomParam("modelId", (Object)modelId);
        baseShowParameter.setCustomParam("billnumber", (Object)billNumber);
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)formKey);
        baseShowParameter.setFormConfig(formConfig);
        baseShowParameter.setCustomParam("bill_type", (Object)billType.getNumber());
        baseShowParameter.setCaption(billType.getName());
        baseShowParameter.addCustPlugin(billType.getBillPlugin());
        return baseShowParameter;
    }

    public FormShowParameter getClearDataTipFormShowParam(List<Map<String, String>> showInfos, CloseCallBack closeCallBack) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_conflictrowtip");
        formShowParameter.setCloseCallBack(closeCallBack);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("infos", (Object)SerializationUtils.serializeToBase64(showInfos));
        return formShowParameter;
    }
}

