/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.applybill.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.CellStyle;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.analyzeReport.service.AnalyseReportUtil;
import kd.epm.eb.business.applybill.util.ApplyBillAggHelper;
import kd.epm.eb.business.applybill.util.ApplyTemplateUtils;
import kd.epm.eb.business.applytemplate.config.service.ApplyTemplateColCfgService;
import kd.epm.eb.business.bizrule.RuleRelationService;
import kd.epm.eb.business.centralapproval.CentralAppBillService;
import kd.epm.eb.business.reportscheme.service.ReportSchemeService;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.applyTemplate.TempDimConfig;
import kd.epm.eb.common.applyTemplate.TempDimConfigType;
import kd.epm.eb.common.applyTemplate.constants.ColCfgPropEnum;
import kd.epm.eb.common.applyTemplate.constants.ColCfgPropTypeEnum;
import kd.epm.eb.common.applyTemplate.constants.FormTypeEnum;
import kd.epm.eb.common.applyTemplate.entity.subtotal.ApplyTemplateSubTotal;
import kd.epm.eb.common.applyTemplate.entity.subtotal.SubTotalConfig;
import kd.epm.eb.common.applyTemplate.entity.tableconfig.BizTableConfig;
import kd.epm.eb.common.applyTemplate.entity.tableconfig.DimFlexInfo;
import kd.epm.eb.common.applybill.ApplyBillType;
import kd.epm.eb.common.applybill.Count;
import kd.epm.eb.common.applybill.EntityRowDataType;
import kd.epm.eb.common.applybill.SchemeAssignDimGroup;
import kd.epm.eb.common.applytemplatecolumn.BaseColumn;
import kd.epm.eb.common.applytemplatecolumn.CalculateColumn;
import kd.epm.eb.common.applytemplatecolumn.ColumnEnum;
import kd.epm.eb.common.applytemplatecolumn.ColumnList;
import kd.epm.eb.common.applytemplatecolumn.DataMapDimension;
import kd.epm.eb.common.applytemplatecolumn.DateColumn;
import kd.epm.eb.common.applytemplatecolumn.DimensionColumn;
import kd.epm.eb.common.applytemplatecolumn.DimensionDataColumn;
import kd.epm.eb.common.applytemplatecolumn.DimensionMemberRange;
import kd.epm.eb.common.applytemplatecolumn.EntryTemplateConfig;
import kd.epm.eb.common.applytemplatecolumn.FieldTypeEnum;
import kd.epm.eb.common.applytemplatecolumn.MeasureColumn;
import kd.epm.eb.common.applytemplatecolumn.OlapDataEntry;
import kd.epm.eb.common.applytemplatecolumn.RelationDimensionColumn;
import kd.epm.eb.common.applytemplatecolumn.RowDimensionColumn;
import kd.epm.eb.common.applytemplatecolumn.SimpleDynamicObject;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.ModelCacheServiceHelper;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.centralapproval.ApproveBill;
import kd.epm.eb.common.centralapproval.ApproveBillConfig;
import kd.epm.eb.common.centralapproval.CentralAppChain;
import kd.epm.eb.common.centralapproval.CentralAppShowInfo;
import kd.epm.eb.common.elasticsearch.OlapDataAuditEventEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.olapdao.BgmdOlapReader;
import kd.epm.eb.common.olapdao.OlapContext;
import kd.epm.eb.common.olapdao.OlapWriteOption;
import kd.epm.eb.common.olapdao.SaveDataContext;
import kd.epm.eb.common.permission.membPerm.DimMemberPermChecker;
import kd.epm.eb.common.permission.membPerm.MemberItem;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.DateTimeUtils;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.eb.olap.api.metadata.IKDCellMeta;
import kd.epm.eb.olap.impl.base.KDValue;
import kd.epm.eb.olap.impl.bizrule.RuleCacheService;
import kd.epm.eb.olap.impl.bizrule.entity.RuleDto;
import kd.epm.eb.olap.impl.bizrule.entity.RuleTemplateInfo;
import kd.epm.eb.olap.impl.metadata.KDCell;
import kd.epm.eb.olap.impl.metadata.KDCellMeta;
import kd.epm.eb.olap.service.OlapCommService;
import kd.epm.eb.olap.service.OlapManager;
import kd.epm.eb.olap.service.OlapReportService;
import kd.epm.eb.olap.service.request.QueryRequest;
import kd.epm.eb.olap.service.request.SaveRequest;
import kd.epm.eb.spread.utils.ReportVar.ReportVarUtil;
import kd.epm.epbs.business.log.trace.OlapTraceServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class BgApplyBillUtils {
    private static final BgApplyBillUtils instance = new BgApplyBillUtils();
    private static final Log log = LogFactory.getLog(BgApplyBillUtils.class);

    public static BgApplyBillUtils getInstance() {
        return instance;
    }

    public void saveOlapData(List<OlapDataEntry> olapDatas, long datasetId, long userId, IModelCacheHelper modelCache, String templateNumber) {
        long modelId = modelCache.getModelobj().getId();
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)templateNumber)) {
            OlapTraceServiceHelper.setTraceOpInfo((String)templateNumber);
        }
        SaveRequest request = this.getSaveRequest(olapDatas, datasetId, modelCache, modelId);
        OlapReportService.getInstance().reportSave(null, Collections.singletonList(request));
    }

    public void saveOlapData(List<OlapDataEntry> olapDatas, long datasetId, long userId, IModelCacheHelper modelCache) {
        this.saveOlapData(olapDatas, datasetId, userId, modelCache, null);
    }

    public void saveOlapData(List<OlapDataEntry> olapDatas, long datasetId, long userId, IModelCacheHelper modelCache, boolean checkperm, String templateNumber) {
        long modelId = modelCache.getModelobj().getId();
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)templateNumber)) {
            OlapTraceServiceHelper.setTraceOpInfo((String)templateNumber);
        }
        SaveRequest request = this.getSaveRequest(olapDatas, datasetId, modelCache, modelId);
        request.setValidPerm(checkperm);
        OlapReportService.getInstance().reportSave(null, Collections.singletonList(request));
    }

    private SaveRequest getSaveRequest(List<OlapDataEntry> olapDatas, long datasetId, IModelCacheHelper modelCache, long modelId) {
        ArrayList bgCells = Lists.newArrayList();
        for (OlapDataEntry olapData : olapDatas) {
            if (olapData == null) continue;
            Map memberMap = olapData.getDimMemMap();
            Object value = olapData.getValue();
            if (!(value instanceof BigDecimal) || this.needChangePercent(modelCache, (String)memberMap.get(SysDimensionEnum.Metric.getNumber()))) {
                // empty if block
            }
            BGCell bgCell = new BGCell(memberMap, value);
            bgCells.add(bgCell);
        }
        OlapContext.setSaveDataContext((SaveDataContext)new SaveDataContext(OlapDataAuditEventEnum.Report));
        SaveRequest request = new SaveRequest(Long.valueOf(modelId), Long.valueOf(datasetId), (List)bgCells);
        return request;
    }

    public List<BGCell> saveOlapData(List<Map<String, Object>> saveDatas, long datasetId, IModelCacheHelper modelCacheHelper) {
        long modelId = modelCacheHelper.getModelobj().getId();
        LinkedList<BGCell> cells = new LinkedList<BGCell>();
        for (Map<String, Object> saveData : saveDatas) {
            Object money = saveData.get("FMONEY");
            HashMap memberMap = new HashMap(16);
            saveData.forEach((k, v) -> {
                if (!"FMONEY".equals(k)) {
                    memberMap.put(k, v.toString());
                }
            });
            if (!(money instanceof BigDecimal) || this.needChangePercent(modelCacheHelper, (String)memberMap.get(SysDimensionEnum.Metric.getNumber()))) {
                // empty if block
            }
            BGCell bgCell = new BGCell(memberMap, money);
            cells.add(bgCell);
        }
        OlapWriteOption olapWriteOption = new OlapWriteOption();
        olapWriteOption.setDataLockThrowErr(true);
        olapWriteOption.setValidPerm(false);
        return OlapCommService.getInstance().save(new SaveRequest(Long.valueOf(modelId), Long.valueOf(datasetId), cells), olapWriteOption);
    }

    private boolean needChangePercent(IModelCacheHelper modelCacheHelper, String number) {
        Member member = modelCacheHelper.getMember(SysDimensionEnum.Metric.getNumber(), null, number);
        return member != null && MetricDataTypeEnum.RATE.getIndex().equals(member.getDatatype());
    }

    public boolean isCurrency(IModelCacheHelper modelCacheHelper, String number) {
        Member member = modelCacheHelper.getMember(SysDimensionEnum.Metric.getNumber(), null, number);
        return member != null && MetricDataTypeEnum.CURRENCY.getIndex().equals(member.getDatatype());
    }

    public Map<Integer, Map<String, Object>> updateMeasureValue(IModelCacheHelper modelCacheHelper, EntryTemplateConfig templateConfig, IDataModel dataModel, Set<Integer> rowIndexes, BigDecimal unitData) {
        HashMap<Integer, Map<String, Object>> olapData = new HashMap<Integer, Map<String, Object>>(16);
        if (templateConfig == null || dataModel == null || rowIndexes == null || rowIndexes.isEmpty()) {
            return olapData;
        }
        Long modelId = null;
        if (modelCacheHelper != null) {
            modelId = modelCacheHelper.getModelobj().getId();
        } else {
            DynamicObject model = (DynamicObject)dataModel.getValue("model");
            if (model != null) {
                modelId = model.getLong("id");
                modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
            }
        }
        if (modelId == null) {
            return olapData;
        }
        LinkedList<BaseColumn> pullFromModelColumns = new LinkedList<BaseColumn>();
        LinkedList<BaseColumn> disColumns = new LinkedList<BaseColumn>();
        for (BaseColumn column : templateConfig.getEntryColumns()) {
            DimensionDataColumn dimensionDataColumn;
            if (column.getType() == ColumnEnum.Dimension || column.getType() == ColumnEnum.RelationDimension || column.getType() == ColumnEnum.RowDimension) {
                disColumns.add(column);
                continue;
            }
            if (column.getType() == ColumnEnum.Measure) {
                pullFromModelColumns.add(column);
                continue;
            }
            if (column.getType() != ColumnEnum.DimensionData || (dimensionDataColumn = (DimensionDataColumn)column).getOpenCalFormula() && !kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)dimensionDataColumn.getFormula())) continue;
            pullFromModelColumns.add(column);
        }
        HashMap<MembersKey, List> membersKeytoModelsKey = new HashMap<MembersKey, List>(16);
        Map<String, String> hideDimMems = this.getHideDimMembersFromTempConfig(modelCacheHelper, templateConfig);
        Map dimViewMap = modelCacheHelper.getViewsByDataSet(Long.valueOf(templateConfig.getDatasetId()));
        HashMap<String, Set<String>> dimMemsForQuery = new HashMap<String, Set<String>>(16);
        this.mergeMap(hideDimMems, dimMemsForQuery);
        for (Integer rowIndex : rowIndexes) {
            if (rowIndex == null) continue;
            Map<String, String> rowDimMems = this.getRowDimMems(modelCacheHelper, dataModel, disColumns, rowIndex);
            for (BaseColumn column : pullFromModelColumns) {
                HashMap<String, String> dimMemsForKey = new HashMap<String, String>(hideDimMems);
                Map<String, String> colDimMems = this.getDimMembersFromMeasureColumn(modelCacheHelper, dimViewMap, column, true);
                dimMemsForKey.putAll(rowDimMems);
                dimMemsForKey.putAll(colDimMems);
                List dimensionList = modelCacheHelper.getDimensionList(Long.valueOf(templateConfig.getDatasetId()));
                Map<String, String> noneDimMembers = this.getDefaultAddDimMembers(dimensionList, hideDimMems, colDimMems, rowDimMems);
                dimMemsForKey.putAll(noneDimMembers);
                MembersKey membersKey = this.getMembersKey(dimMemsForKey, dimensionList);
                List keys = membersKeytoModelsKey.computeIfAbsent(membersKey, k -> new ArrayList(16));
                keys.add(column.getKey() + "###" + rowIndex);
                this.mergeMap(colDimMems, dimMemsForQuery);
                this.mergeMap(noneDimMembers, dimMemsForQuery);
            }
            this.mergeMap(rowDimMems, dimMemsForQuery);
        }
        log.info("pullFromModel query:" + dimMemsForQuery);
        Map<MembersKey, Object> datas = this.queryOlapData(modelCacheHelper, modelId, templateConfig.getDatasetId(), dimMemsForQuery, true, templateConfig.getTemplateID());
        log.info("pullFromModel datas:" + datas);
        Set currencyCols = templateConfig.getCurrencyColumnKeys();
        for (Map.Entry entry : membersKeytoModelsKey.entrySet()) {
            List keys = (List)entry.getValue();
            MembersKey membersKey = (MembersKey)entry.getKey();
            keys.forEach(e -> {
                String[] colAndRow = e.split("###");
                Object data = datas.get(membersKey);
                if (colAndRow.length == 2) {
                    int index = Integer.parseInt(colAndRow[1]);
                    if (data instanceof BigDecimal && currencyCols != null && currencyCols.contains(colAndRow[0]) && unitData != null) {
                        data = ((BigDecimal)data).divide(unitData);
                    }
                    Map rowVals = olapData.computeIfAbsent(index, key -> new HashMap(16));
                    rowVals.put(colAndRow[0], data);
                    dataModel.setValue(colAndRow[0], data, index);
                }
            });
        }
        return olapData;
    }

    public Map<MembersKey, Object> queryOlapData(IModelCacheHelper modelCacheHelper, Long modelId, Long datasetId, Map<String, Set<String>> dimMembers, boolean isFromTemplate, long templateId) {
        return this.queryOlapData(modelCacheHelper, modelId, datasetId, dimMembers, true, isFromTemplate, templateId);
    }

    public Map<MembersKey, Object> queryOlapDataNotAuth(IModelCacheHelper modelCacheHelper, Long modelId, Long datasetId, Map<String, Set<String>> dimMembers, boolean isFromTemplate, long templateId) {
        return this.queryOlapDataNotAuth(modelCacheHelper, modelId, datasetId, dimMembers, true, isFromTemplate, templateId);
    }

    public Map<MembersKey, Object> queryOlapData(IModelCacheHelper modelCacheHelper, Long modelId, Long datasetId, Map<String, Set<String>> dimMembers, boolean needChangeRate, boolean isFromTemplate, long templateId) {
        if (modelId == null || datasetId == null || dimMembers == null) {
            return null;
        }
        String[] dimensionNums = modelCacheHelper.getDimensionNums(datasetId);
        List bgCells = null;
        if (!isFromTemplate) {
            bgCells = OlapCommService.getInstance().queryList(new QueryRequest(modelId, datasetId, dimMembers));
        } else {
            List<RuleDto> ruleList = this.queryRuleList(modelCacheHelper, templateId, datasetId);
            RuleTemplateInfo ruleTemplateInfo = new RuleTemplateInfo(modelId, Long.valueOf(templateId));
            bgCells = OlapReportService.getInstance().reportQuery(ruleTemplateInfo, ruleList, Collections.singletonList(new QueryRequest(modelId, datasetId, dimMembers)));
        }
        return this.getMembersKeyObjectMap(modelCacheHelper, needChangeRate, dimensionNums, bgCells);
    }

    public Map<MembersKey, Object> queryOlapDataNotAuth(IModelCacheHelper modelCacheHelper, Long modelId, Long datasetId, Map<String, Set<String>> dimMembers, boolean needChangeRate, boolean isFromTemplate, long templateId) {
        if (modelId == null || datasetId == null || dimMembers == null) {
            return null;
        }
        String[] dimensionNums = modelCacheHelper.getDimensionNums(datasetId);
        List bgCells = OlapCommService.getInstance().queryList(new QueryRequest(modelId, datasetId, dimMembers));
        return this.getMembersKeyObjectMap(modelCacheHelper, needChangeRate, dimensionNums, bgCells);
    }

    private Map<MembersKey, Object> getMembersKeyObjectMap(IModelCacheHelper modelCacheHelper, boolean needChangeRate, String[] dimensionNums, List<BGCell> bgCells) {
        int objectSize = dimensionNums.length;
        String metricMember = null;
        Map<String, MetricDataTypeEnum> metricDataTypeEnumMap = this.getAllMetricDataTypeEnumMap(modelCacheHelper);
        HashMap<MembersKey, Object> cellSets = new HashMap<MembersKey, Object>(16);
        for (BGCell cell : bgCells) {
            BigDecimal bigDecimal = ConvertUtils.toDecimal((Object)cell.getValue());
            if (bigDecimal != null && bigDecimal.compareTo(BigDecimal.ZERO) == 0) continue;
            Map memberMap = cell.getMemberMap();
            Object[] values = new Object[objectSize + 1];
            for (int i = 0; i < dimensionNums.length; ++i) {
                String member = (String)memberMap.get(dimensionNums[i]);
                values[i + 1] = member;
                if (!SysDimensionEnum.Metric.getNumber().equals(dimensionNums[i])) continue;
                metricMember = member;
            }
            Object value = cell.getValue();
            MetricDataTypeEnum metricDataTypeEnum = metricDataTypeEnumMap.get(metricMember);
            if (metricDataTypeEnum != null) {
                if (bigDecimal != null && AnalyseReportUtil.dataTypes.contains(metricDataTypeEnum.getIndex())) {
                    if (MetricDataTypeEnum.RATE != metricDataTypeEnum || !needChangeRate) {
                        value = bigDecimal;
                    }
                } else if (MetricDataTypeEnum.DATE == metricDataTypeEnum) {
                    Date date;
                    Object dateValue = ConvertUtils.from((String)value.toString());
                    if ((dateValue == null || kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)dateValue.toString())) && (date = DateTimeUtils.parseToDate((String)value.toString())) != null) {
                        dateValue = value;
                    }
                    value = dateValue;
                }
            }
            cellSets.put(new MembersKey(values), value);
        }
        return cellSets;
    }

    private List<RuleDto> queryRuleList(IModelCacheHelper modelCache, long templateId, Long datasetId) {
        List<Long> ruleIds = RuleRelationService.getInstance().listRuleByApplyTemplateId(Collections.singleton(templateId));
        if (CollectionUtils.isEmpty(ruleIds)) {
            return Collections.emptyList();
        }
        Long bizModelId = modelCache.getBusModelByDataSet(datasetId);
        List allRuleList = RuleCacheService.getInstance().listRuleFromLocalCache(bizModelId).getRuleDtoList();
        return allRuleList.stream().filter(RuleDto::getStatus).filter(rule -> ruleIds.contains(rule.getId())).collect(Collectors.toList());
    }

    private Map<String, MetricDataTypeEnum> getAllMetricDataTypeEnumMap(IModelCacheHelper modelCacheHelper) {
        Dimension dimension = modelCacheHelper.getDimension(SysDimensionEnum.Metric.getNumber());
        List allMembers = dimension.getAllMembers();
        HashMap<String, MetricDataTypeEnum> dataTypeEnumMap = new HashMap<String, MetricDataTypeEnum>(16);
        allMembers.forEach(e -> {
            MetricDataTypeEnum metricDataType = MetricDataTypeEnum.getByIndex((String)e.getDatatype());
            if (metricDataType != null) {
                dataTypeEnumMap.put(e.getNumber(), metricDataType);
            }
        });
        return dataTypeEnumMap;
    }

    public Map<MembersKey, IKDCell> queryOlapData_new(IModelCacheHelper modelCacheHelper, Long modelId, Long datasetId, Map<String, Set<String>> dimMembers, List<Set<String>> dataKeyList, List<String> rowDimKeyList) {
        if (modelId == null || datasetId == null || dimMembers == null) {
            return null;
        }
        String[] dimensionNums = modelCacheHelper.getDimensionNums(datasetId);
        List<IKDCell> bgCells = this.queryList_Analyse(new QueryRequest(modelId, datasetId, dimMembers));
        int objectSize = dimensionNums.length;
        HashMap<MembersKey, IKDCell> cellSets = new HashMap<MembersKey, IKDCell>(bgCells.size());
        int dimSize = rowDimKeyList.size();
        String[] memberArray = new String[dimSize];
        int dimCount = 0;
        StringBuilder dataKey = new StringBuilder();
        for (IKDCell cell : bgCells) {
            String member;
            int i;
            if (cell.getValue().isDecimal() && cell.getValue().getDecimal().compareTo(BigDecimal.ZERO) == 0) continue;
            dimCount = 0;
            IKDCellMeta meta = cell.getMeta();
            Object[] values = new Object[objectSize + 1];
            for (i = 0; i < dimensionNums.length; ++i) {
                int index;
                member = meta.getNumber()[i];
                values[i + 1] = member;
                if (dimCount >= dimSize || (index = rowDimKeyList.indexOf(dimensionNums[i])) == -1) continue;
                memberArray[index] = member;
            }
            dataKey.setLength(0);
            for (i = 0; i < memberArray.length; ++i) {
                Set<Object> dataKeys;
                member = memberArray[i];
                if (dataKey.length() != 0) {
                    dataKey.append("!");
                }
                dataKey.append(member);
                if (dataKeyList.size() <= i) {
                    dataKeys = new HashSet(16);
                    dataKeyList.add(dataKeys);
                } else {
                    dataKeys = dataKeyList.get(i);
                }
                dataKeys.add(dataKey.toString());
            }
            cellSets.put(new MembersKey(values, cell.getKey(), cell.getMeta().getNumber(), cell.getDetail()), cell);
        }
        return cellSets;
    }

    public Map<String, String> getHideDimMembersFromTempConfig(IModelCacheHelper modelCacheHelper, EntryTemplateConfig templateConfig) {
        HashMap<String, String> memberMap = new HashMap<String, String>(16);
        log.info("getHideDimMembersFromTempConfig\uff1agetHiddenDimMemMap=", (Object)SerializationUtils.toJsonString((Object)templateConfig.getHiddenDimMemMap()));
        Map viewsByDataSet = modelCacheHelper.getViewsByDataSet(Long.valueOf(templateConfig.getDatasetId()));
        for (Map.Entry entry : templateConfig.getHiddenDimMemMap().entrySet()) {
            Member member = modelCacheHelper.getMember((String)entry.getKey(), (Long)viewsByDataSet.get(entry.getKey()), (Long)entry.getValue());
            if (member == null) continue;
            memberMap.put((String)entry.getKey(), member.getNumber());
        }
        return memberMap;
    }

    public Map<String, String> getDimMembersFromMeasureColumn(IModelCacheHelper modelCacheHelper, Map<String, Long> dimViewMap, BaseColumn column, Boolean isQueryNumber) {
        HashMap<String, String> memberMap = new HashMap<String, String>(16);
        List dataMap = null;
        if (column instanceof MeasureColumn) {
            dataMap = ((MeasureColumn)column).getDataMapDimensions();
        } else if (column instanceof CalculateColumn) {
            dataMap = ((CalculateColumn)column).getDataMapDimensions();
        } else if (column instanceof DimensionDataColumn) {
            dataMap = ((DimensionDataColumn)column).getDataMapDimensions();
        } else {
            return memberMap;
        }
        log.info("getDimMembersFromMeasureColumn\uff1bdataMap=", (Object)SerializationUtils.toJsonString((Object)dataMap));
        for (DataMapDimension dataMapDimension : dataMap) {
            long dimensionRememberId;
            Dimension dim = modelCacheHelper.getDimension(Long.valueOf(dataMapDimension.getDimensionId()));
            if (dim == null || (dimensionRememberId = dataMapDimension.getDimensionRememberId()) == 0L) continue;
            if (isQueryNumber.booleanValue()) {
                Member member = modelCacheHelper.getMember(dim.getNumber(), dimViewMap.get(dim.getNumber()), Long.valueOf(dimensionRememberId));
                if (member == null) continue;
                memberMap.put(dim.getNumber(), member.getNumber());
                continue;
            }
            memberMap.put(dim.getNumber(), String.valueOf(dimensionRememberId));
        }
        return memberMap;
    }

    public Map<String, Long> getDimMembersFromMeasureColumnIds(IModelCacheHelper modelCacheHelper, BaseColumn column) {
        HashMap<String, Long> memberMap = new HashMap<String, Long>(16);
        List dataMap = null;
        if (column instanceof MeasureColumn) {
            dataMap = ((MeasureColumn)column).getDataMapDimensions();
        } else if (column instanceof CalculateColumn) {
            dataMap = ((CalculateColumn)column).getDataMapDimensions();
        } else if (column instanceof DimensionDataColumn) {
            dataMap = ((DimensionDataColumn)column).getDataMapDimensions();
        } else {
            return memberMap;
        }
        log.info("getDimMembersFromMeasureColumn\uff1bdataMap=", (Object)SerializationUtils.toJsonString((Object)dataMap));
        for (DataMapDimension dataMapDimension : dataMap) {
            Dimension dim = modelCacheHelper.getDimension(Long.valueOf(dataMapDimension.getDimensionId()));
            if (dim == null) continue;
            long dimensionRememberId = dataMapDimension.getDimensionRememberId();
            memberMap.put(dim.getNumber(), dimensionRememberId);
        }
        return memberMap;
    }

    public Map<String, String> getRowDimMems(IModelCacheHelper modelCacheHelper, IDataModel dataModel, List<BaseColumn> columns, int rowIndex) {
        HashMap<String, String> dimMembers = new HashMap<String, String>(16);
        for (BaseColumn column : columns) {
            String disKey = column.getKey();
            String dimNumber = null;
            if (column instanceof DimensionColumn) {
                dimNumber = ((DimensionColumn)column).getDimNumber();
            } else if (column instanceof RelationDimensionColumn && modelCacheHelper != null) {
                dimNumber = modelCacheHelper.getDimension(Long.valueOf(((RelationDimensionColumn)column).getDimensionId())).getNumber();
            } else if (column instanceof RowDimensionColumn) {
                dimNumber = ((RowDimensionColumn)column).getDimNumber();
            }
            DynamicObject dynamicObject = (DynamicObject)dataModel.getValue(disKey, rowIndex);
            if (dimNumber == null || dynamicObject == null) continue;
            dimMembers.put(dimNumber, dynamicObject.getString("number"));
        }
        return dimMembers;
    }

    public MembersKey getMembersKey(Map<String, String> dimMembers, List<Dimension> dimensions) {
        Object[] metaData = new String[dimensions.size() + 1];
        int in = dimensions.size();
        for (int i = 0; i < in; ++i) {
            metaData[i + 1] = dimMembers.get(dimensions.get(i).getNumber());
        }
        return new MembersKey(metaData);
    }

    public MembersKey getMembersKey(Map<String, String> dimMembers, String[] dimensionNums) {
        Object[] metaData = new String[dimensionNums.length + 1];
        int in = dimensionNums.length;
        for (int i = 0; i < in; ++i) {
            metaData[i + 1] = dimMembers.get(dimensionNums[i]);
        }
        return new MembersKey(metaData);
    }

    public void mergeMap(Map<String, String> source, Map<String, Set<String>> target) {
        if (target != null && source != null) {
            for (Map.Entry<String, String> entry : source.entrySet()) {
                Set values = target.computeIfAbsent(entry.getKey(), k -> new HashSet(16));
                values.add(entry.getValue());
            }
        }
    }

    public void mergeMap2(Map<String, Set<String>> source, Map<String, Set<String>> target) {
        if (target != null && source != null) {
            for (Map.Entry<String, Set<String>> entry : source.entrySet()) {
                Set values = target.computeIfAbsent(entry.getKey(), k -> new HashSet(16));
                values.addAll((Collection)entry.getValue());
            }
        }
    }

    public Map<String, Long> getHiddenDimMemMap(String cacheTemplateData, Long datasetId, IModelCacheHelper modelCacheHelper, Map<String, Map<String, String>> allDimVarSetting) {
        Map dimViewMap = modelCacheHelper.getViewsByDataSet(datasetId);
        return this.getHiddenDimMemMap(cacheTemplateData, dimViewMap, modelCacheHelper, allDimVarSetting);
    }

    public Map<String, Long> getHiddenDimMemMap(String cacheTemplateData, Map<String, Long> dimViewMap, IModelCacheHelper modelCacheHelper, Map<String, Map<String, String>> allDimVarSetting) {
        HashMap<String, Long> result = new HashMap<String, Long>(16);
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)cacheTemplateData)) {
            return result;
        }
        List allList = SerializationUtils.fromJsonStringToList((String)cacheTemplateData, TempDimConfig.class);
        String dimNum = "";
        for (TempDimConfig dimMap : allList) {
            if (!TempDimConfigType.HIDEDIM.getValue().equals(dimMap.getPanel())) continue;
            dimNum = dimMap.getDimensionNumber();
            String memberId = dimMap.getMemberId();
            String memberNum = dimMap.getMemberNumber();
            if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)memberId)) continue;
            try {
                kd.epm.eb.common.model.Pair memberInfo = new kd.epm.eb.common.model.Pair((Object)Long.parseLong(memberId), null);
                if (allDimVarSetting != null && dimMap.isVar()) {
                    ApplyTemplateUtils.changeVar(modelCacheHelper, memberNum, allDimVarSetting, dimViewMap.get(dimNum), dimNum, member -> memberInfo.setKey((Object)member.getId()));
                }
                result.put(dimNum, (Long)memberInfo.getKey());
            }
            catch (NumberFormatException e) {
                log.error((Throwable)e);
                throw new KDBizException(ResManager.loadResFormat((String)"\u9690\u85cf\u7ef4\u5ea6\u6210\u5458id\u53c2\u6570\u4e0d\u5408\u6cd5\uff1a%1 id: %2", (String)"BgApplyBillUtils_0", (String)"epm-eb-business", (Object[])new Object[]{dimNum, memberId}));
            }
        }
        return result;
    }

    public Map<String, String> getHiddenDimMemNumMap(String cacheTemplateData, Map<String, Long> dimViewMap, IModelCacheHelper modelCacheHelper, Map<String, Map<String, String>> allDimVarSetting) {
        HashMap<String, String> dimMembers = new HashMap<String, String>(16);
        Map<String, Long> hiddenDimMemMap = this.getHiddenDimMemMap(cacheTemplateData, dimViewMap, modelCacheHelper, allDimVarSetting);
        for (Map.Entry<String, Long> hiddenDimMember : hiddenDimMemMap.entrySet()) {
            String dimKey = hiddenDimMember.getKey();
            Long memberId = hiddenDimMember.getValue();
            Member member = modelCacheHelper.getMember(dimKey, dimViewMap.get(dimKey), memberId);
            if (member == null) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u4f53\u7cfb\u7f13\u5b58\u4e2d\u672a\u83b7\u53d6\u5230\u9690\u85cf\u7ef4%1\u7684\u6210\u5458\u3002", (String)"BgApplyBillUtils_1", (String)"epm-eb-business", (Object[])new Object[]{dimKey}));
            }
            dimMembers.put(dimKey, member.getNumber());
        }
        return dimMembers;
    }

    public Map<String, Object> getMainEntityInfoByTemplate(Long templateId, IModelCacheHelper modelCacheHelper, Map<String, Map<String, String>> allDimVarSetting) {
        HashMap<String, Object> mainEntityInfo = new HashMap<String, Object>(16);
        if (templateId == null || templateId == 0L) {
            return mainEntityInfo;
        }
        List<Object> mainCols = new ArrayList(16);
        ColumnList columnList = ApplyTemplateUtils.getEntrycfgByApplyTemplateID(templateId);
        Long datasetId = (Long)CommonServiceHelper.getValueFromDB((String)"eb_applytemplate", (String)"dataset", (String)"id", (Object[])new Object[]{templateId});
        ApplyTemplateUtils.changeVarOnColumn(columnList, datasetId, modelCacheHelper, allDimVarSetting);
        Collection columns = columnList.getColumns();
        if (columns != null) {
            mainCols = columns.stream().filter(ee -> "h".equals(ee.getCategory())).collect(Collectors.toList());
        }
        mainEntityInfo.put("col", mainCols);
        Map entityTableMap = columnList.getEntityinfomap();
        String table = (String)entityTableMap.get("mainentryentity");
        mainEntityInfo.put("table", table);
        return mainEntityInfo;
    }

    public Map<String, Map<String, Map<String, String>>> getColRowDimMembers(Long templateId, IModelCacheHelper modelCacheHelper, IDataModel dataModel, Set<String> applyNumbers, int[] indexes, Boolean onlyNotDetail, Map<String, Map<String, String>> allDimVarSetting) {
        return this.getColRowDimMembers(templateId, modelCacheHelper, dataModel, applyNumbers, indexes, onlyNotDetail, allDimVarSetting, false);
    }

    public Map<String, Map<String, Map<String, String>>> getColRowDimMembersNew(Long templateId, IModelCacheHelper modelCacheHelper, IDataModel dataModel, Set<String> applyNumbers, int[] indexes, Boolean onlyNotDetail, Map<String, Map<String, String>> allDimVarSetting, Map<String, String> hiddenDimMemMap, Long dataSetId) {
        return this.getColRowDimMembersNew(templateId, modelCacheHelper, dataModel, applyNumbers, indexes, onlyNotDetail, allDimVarSetting, false, hiddenDimMemMap, dataSetId);
    }

    public Map<String, Map<String, Map<String, String>>> getColRowDimMembers(Long templateId, IModelCacheHelper modelCacheHelper, IDataModel dataModel, Set<String> applyNumbers, int[] indexes, Boolean onlyNotDetail, Map<String, Map<String, String>> allDimVarSetting, Boolean ignorePullFormModel) {
        HashMap<String, Map<String, Map<String, String>>> colRowDimMembers = new HashMap<String, Map<String, Map<String, String>>>(16);
        if (templateId == null || templateId == 0L) {
            return colRowDimMembers;
        }
        Map<String, Object> mainEntityInfo = this.getMainEntityInfoByTemplate(templateId, modelCacheHelper, allDimVarSetting);
        List columns = (List)mainEntityInfo.get("col");
        ArrayList<BaseColumn> measureCols = new ArrayList<BaseColumn>(16);
        ArrayList<BaseColumn> dimensionCols = new ArrayList<BaseColumn>(16);
        ArrayList<BaseColumn> otherCols = new ArrayList<BaseColumn>(16);
        for (BaseColumn column : columns) {
            if (column.getType() == ColumnEnum.Dimension || column.getType() == ColumnEnum.RelationDimension || column.getType() == ColumnEnum.RowDimension) {
                dimensionCols.add(column);
                continue;
            }
            otherCols.add(column);
            if (ColumnEnum.Cal != column.getType() && (ColumnEnum.Measure != column.getType() || ignorePullFormModel.booleanValue() && column.getIspullfrommodel()) && (ColumnEnum.DimensionData != column.getType() || ignorePullFormModel.booleanValue() && column.getIspullfrommodel())) continue;
            measureCols.add(column);
        }
        Long datasetId = (Long)CommonServiceHelper.getValueFromDB((String)"eb_applytemplate", (String)"dataset", (String)"id", (Object[])new Object[]{templateId});
        colRowDimMembers.put("col", this.getAllColDimMembers(measureCols, datasetId, modelCacheHelper, (Boolean)true));
        HashMap<String, Map<String, String>> allRowDimMembers = new HashMap<String, Map<String, String>>(16);
        HashMap<String, Map<String, String>> otherRowInfo = new HashMap<String, Map<String, String>>(16);
        if (indexes != null && indexes.length != 0 && dataModel != null && this.checkHasProperty(dataModel, dimensionCols).booleanValue() && this.checkHasProperty(dataModel, otherCols).booleanValue()) {
            for (int index : indexes) {
                allRowDimMembers.put(String.valueOf(index), this.getRowDimMems(modelCacheHelper, dataModel, dimensionCols, index));
                otherRowInfo.put(String.valueOf(index), this.getRowInfos(dataModel, otherCols, index));
            }
        } else if (applyNumbers != null && applyNumbers.size() != 0) {
            this.getAllRowInfosInDataBase(applyNumbers, modelCacheHelper, mainEntityInfo.get("table").toString(), dimensionCols, allRowDimMembers, otherCols, otherRowInfo, onlyNotDetail);
        }
        colRowDimMembers.put("row", allRowDimMembers);
        colRowDimMembers.put("other", otherRowInfo);
        return colRowDimMembers;
    }

    public Map<String, Map<String, String>> getAllColDimMembers(List<BaseColumn> measureCols, Long datasetId, IModelCacheHelper modelCacheHelper, Boolean isQueryNumber) {
        HashMap<String, Long> dimViewMap = modelCacheHelper == null ? new HashMap<String, Long>(16) : modelCacheHelper.getViewsByDataSet(datasetId);
        return this.getAllColDimMembers(measureCols, dimViewMap, modelCacheHelper, isQueryNumber);
    }

    public Map<String, Map<String, String>> getAllColDimMembers(List<BaseColumn> measureCols, Map<String, Long> dimViewMap, IModelCacheHelper modelCacheHelper, Boolean isQueryNumber) {
        HashMap<String, Map<String, String>> allColDimMembers = new HashMap<String, Map<String, String>>(16);
        if (measureCols == null) {
            return allColDimMembers;
        }
        measureCols.forEach(e -> {
            String key = e.getKey();
            Map<String, String> dimMembers = this.getDimMembersFromMeasureColumn(modelCacheHelper, dimViewMap, (BaseColumn)e, isQueryNumber);
            allColDimMembers.put(key, dimMembers);
        });
        return allColDimMembers;
    }

    public Map<String, Map<String, Long>> getAllColDimMemberIds(List<BaseColumn> measureCols, IModelCacheHelper modelCacheHelper) {
        HashMap<String, Map<String, Long>> allColDimMembers = new HashMap<String, Map<String, Long>>(16);
        if (measureCols == null) {
            return allColDimMembers;
        }
        measureCols.forEach(e -> {
            String key = e.getKey();
            Map<String, Long> dimMembers = this.getDimMembersFromMeasureColumnIds(modelCacheHelper, (BaseColumn)e);
            allColDimMembers.put(key, dimMembers);
        });
        return allColDimMembers;
    }

    public Map<String, Map<String, Map<String, String>>> getColRowDimMembersNew(Long templateId, IModelCacheHelper modelCacheHelper, IDataModel dataModel, Set<String> applyNumbers, int[] indexes, Boolean onlyNotDetail, Map<String, Map<String, String>> allDimVarSetting, Boolean ignorePullFormModel, Map<String, String> hiddenDimMemMap, Long dataSetId) {
        HashMap<String, Map<String, Map<String, String>>> colRowDimMembers = new HashMap<String, Map<String, Map<String, String>>>(16);
        if (templateId == null || templateId == 0L) {
            return colRowDimMembers;
        }
        Map<String, Object> mainEntityInfo = this.getMainEntityInfoByTemplate(templateId, modelCacheHelper, allDimVarSetting);
        List columns = (List)mainEntityInfo.get("col");
        ArrayList<BaseColumn> measureCols = new ArrayList<BaseColumn>(16);
        ArrayList<BaseColumn> dimensionCols = new ArrayList<BaseColumn>(16);
        ArrayList<BaseColumn> otherCols = new ArrayList<BaseColumn>(16);
        for (BaseColumn column : columns) {
            if (column.getType() == ColumnEnum.Dimension || column.getType() == ColumnEnum.RelationDimension || column.getType() == ColumnEnum.RowDimension) {
                dimensionCols.add(column);
                continue;
            }
            otherCols.add(column);
            if (ColumnEnum.Cal != column.getType() && (ColumnEnum.Measure != column.getType() || ignorePullFormModel.booleanValue() && column.getIspullfrommodel()) && (ColumnEnum.DimensionData != column.getType() || ignorePullFormModel.booleanValue() && column.getIspullfrommodel())) continue;
            measureCols.add(column);
        }
        Map<String, Map<String, String>> allColDimMembers = this.getAllColDimMembers(measureCols, dataSetId, modelCacheHelper, (Boolean)true);
        colRowDimMembers.put("col", allColDimMembers);
        HashMap<String, Map<String, String>> allRowDimMembers = new HashMap<String, Map<String, String>>(16);
        HashMap<String, Map<String, String>> otherRowInfo = new HashMap<String, Map<String, String>>(16);
        if (indexes != null && indexes.length != 0 && dataModel != null && this.checkHasProperty(dataModel, dimensionCols).booleanValue() && this.checkHasProperty(dataModel, otherCols).booleanValue()) {
            for (int index : indexes) {
                allRowDimMembers.put(String.valueOf(index), this.getRowDimMems(modelCacheHelper, dataModel, dimensionCols, index));
                otherRowInfo.put(String.valueOf(index), this.getRowInfos(dataModel, otherCols, index));
            }
        } else if (applyNumbers != null && applyNumbers.size() != 0) {
            this.getAllRowInfosInDataBaseNew(applyNumbers, modelCacheHelper, mainEntityInfo.get("table").toString(), dimensionCols, allRowDimMembers, otherCols, otherRowInfo, onlyNotDetail);
        }
        colRowDimMembers.put("row", allRowDimMembers);
        colRowDimMembers.put("other", otherRowInfo);
        return colRowDimMembers;
    }

    private Map<String, String> getRowInfos(IDataModel dataModel, List<BaseColumn> otherCols, int index) {
        HashMap<String, String> rowInfos = new HashMap<String, String>(16);
        String key = null;
        for (BaseColumn otherCol : otherCols) {
            key = otherCol.getKey();
            Object value = dataModel.getValue(key, index);
            if (value == null) continue;
            rowInfos.put(key, value.toString());
        }
        return rowInfos;
    }

    private void getAllRowInfosInDataBase(Set<String> applyNumbers, IModelCacheHelper modelCacheHelper, String table, List<BaseColumn> dimensionCols, Map<String, Map<String, String>> rowDimMembers, List<BaseColumn> otherCols, Map<String, Map<String, String>> rowOtherInfos, Boolean onlyNotDetail) {
        DataSet dataSet;
        HashMap<String, String> dimensionMap = new HashMap<String, String>(16);
        ArrayList<String> otherColFields = new ArrayList<String>(16);
        dimensionCols.forEach(e -> {
            String key = "f" + e.getKey();
            if (e instanceof DimensionColumn) {
                dimensionMap.put(((DimensionColumn)e).getDimNumber(), key);
            } else if (e instanceof RowDimensionColumn) {
                dimensionMap.put(((RowDimensionColumn)e).getDimNumber(), key);
            } else {
                dimensionMap.put(this.getRelationDimensionNumber((RelationDimensionColumn)e, modelCacheHelper), key);
            }
        });
        otherCols.forEach(e -> {
            String key = "f" + e.getKey();
            otherColFields.add(key);
        });
        String sql = this.getQuerySql(dimensionMap, otherColFields, table) + applyNumbers.stream().collect(Collectors.joining("','", "('", "')"));
        if (onlyNotDetail.booleanValue()) {
            sql = sql + " and main.fdatatype in ('" + EntityRowDataType.NEW_NOTDETAIL.getNumber() + "', '" + EntityRowDataType.EDIT_NOTDETAIL.getNumber() + "')";
        }
        if ((dataSet = DB.queryDataSet((String)"queryApplyMainData", (DBRoute)DBRoute.of((String)"epm"), (String)sql)) == null || dataSet.isEmpty() || !dataSet.hasNext()) {
            return;
        }
        Row row = null;
        int index = 0;
        while (dataSet.hasNext()) {
            row = dataSet.next();
            HashMap<String, String> dimMembers = new HashMap<String, String>(16);
            for (String dimNum : dimensionMap.keySet()) {
                String member = row.getString(dimNum + "number");
                dimMembers.put(dimNum, member);
            }
            rowDimMembers.put(String.valueOf(index), dimMembers);
            HashMap<String, String> otherInfos = new HashMap<String, String>(16);
            for (String otherColField : otherColFields) {
                String fieldInfo = row.getString(otherColField);
                otherInfos.put(otherColField, fieldInfo);
            }
            rowOtherInfos.put(String.valueOf(index), otherInfos);
            ++index;
        }
    }

    private void getAllRowInfosInDataBaseNew(Set<String> applyNumbers, IModelCacheHelper modelCacheHelper, String table, List<BaseColumn> dimensionCols, Map<String, Map<String, String>> rowDimMembers, List<BaseColumn> otherCols, Map<String, Map<String, String>> rowOtherInfos, Boolean onlyNotDetail) {
        DataSet dataSet;
        HashMap<String, String> dimensionMap = new HashMap<String, String>(16);
        ArrayList<String> otherColFields = new ArrayList<String>(16);
        dimensionCols.forEach(e -> {
            String key = "f" + e.getKey();
            if (e instanceof DimensionColumn) {
                dimensionMap.put(((DimensionColumn)e).getDimNumber(), key);
            } else if (e instanceof RowDimensionColumn) {
                dimensionMap.put(((RowDimensionColumn)e).getDimNumber(), key);
            } else {
                dimensionMap.put(this.getRelationDimensionNumber((RelationDimensionColumn)e, modelCacheHelper), key);
            }
        });
        otherCols.forEach(e -> {
            String key = "f" + e.getKey();
            otherColFields.add(key);
        });
        String sql = this.getQuerySql(dimensionMap, otherColFields, table) + applyNumbers.stream().collect(Collectors.joining("','", "('", "')"));
        if (onlyNotDetail.booleanValue()) {
            sql = sql + " and main.fdatatype in ('" + EntityRowDataType.NEW_NOTDETAIL.getNumber() + "', '" + EntityRowDataType.EDIT_NOTDETAIL.getNumber() + "')";
        }
        if ((dataSet = DB.queryDataSet((String)"queryApplyMainData", (DBRoute)DBRoute.of((String)"epm"), (String)sql)) == null || dataSet.isEmpty() || !dataSet.hasNext()) {
            return;
        }
        Row row = null;
        int index = 0;
        while (dataSet.hasNext()) {
            row = dataSet.next();
            HashMap<String, String> dimMembers = new HashMap<String, String>(16);
            for (String dimNum : dimensionMap.keySet()) {
                String member = row.getString(dimNum + "number");
                dimMembers.put(dimNum, member);
            }
            rowDimMembers.put(row.getString("fentryid"), dimMembers);
            HashMap<String, String> otherInfos = new HashMap<String, String>(16);
            for (String otherColField : otherColFields) {
                String fieldInfo = row.getString(otherColField);
                otherInfos.put(otherColField, fieldInfo);
            }
            rowOtherInfos.put(row.getString("fentryid"), otherInfos);
            ++index;
        }
    }

    private String getQuerySql(Map<String, String> dimensionMap, List<String> otherColFields, String table) {
        ArrayList queryFields = new ArrayList(16);
        StringBuilder joinTables = new StringBuilder();
        dimensionMap.forEach((key, value) -> {
            String tableKey = "inner" + key;
            queryFields.add(tableKey + ".fnumber as " + key + "number");
            String joinTable = null;
            SysDimensionEnum dimensionEnum = SysDimensionEnum.getEnumByNumberIgnoreCase((String)key);
            joinTable = dimensionEnum == null ? "t_eb_structofdefined" : dimensionEnum.getMemberTreetable();
            joinTables.append(" inner join ").append(joinTable);
            joinTables.append(" as ").append(tableKey);
            joinTables.append(" on ").append(tableKey);
            joinTables.append(".fid = main.").append((String)value);
        });
        String otherFieldSql = null;
        if (otherColFields.size() != 0) {
            otherFieldSql = otherColFields.stream().collect(Collectors.joining(", main.", ", main.", " "));
        }
        StringBuilder stringBuilder = new StringBuilder("select main.fentryid,");
        stringBuilder.append(String.join((CharSequence)",", queryFields)).append(kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)otherFieldSql) ? " " : otherFieldSql).append("from ").append(table).append(" as main ").append((CharSequence)joinTables).append(" where main.fbillnumber in ");
        return stringBuilder.toString();
    }

    private Boolean checkHasProperty(IDataModel dataModel, List<BaseColumn> dimensionCols) {
        DynamicObjectType dynamicObjectType = dataModel.getDataEntity().getDynamicObjectType();
        for (BaseColumn dimensionCol : dimensionCols) {
            String key = dimensionCol.getKey();
            if (dynamicObjectType.getProperty(key) != null) continue;
            return false;
        }
        return true;
    }

    public String getRelationDimensionNumber(RelationDimensionColumn column, IModelCacheHelper modelCacheHelper) {
        long dimensionId = column.getDimensionId();
        Dimension dimension = modelCacheHelper.getDimension(Long.valueOf(dimensionId));
        if (dimension == null) {
            return null;
        }
        return dimension.getNumber();
    }

    public int filterMemMapRow(DynamicObjectCollection entityRows, Map<String, Object> importData, List<String> dimKeys) {
        int index = -1;
        for (int i = 0; i < entityRows.size(); ++i) {
            DynamicObject entityRow = (DynamicObject)entityRows.get(i);
            boolean sameDim = true;
            for (String dimKey : dimKeys) {
                Long entityValue = entityRow.getLong(dimKey + ".id");
                Object importValue = importData.get(dimKey);
                if (entityValue == 0L || entityValue.equals(importValue)) continue;
                sameDim = false;
                break;
            }
            if (!sameDim) continue;
            index = i;
            break;
        }
        return index;
    }

    public int filterMemMapRow(DynamicObjectCollection entityRows, Object[] importData, Map<String, Integer> columnIndex, List<String> dimKeys) {
        int index = -1;
        for (int i = 0; i < entityRows.size(); ++i) {
            DynamicObject entityRow = (DynamicObject)entityRows.get(i);
            boolean sameDim = true;
            for (String dimKey : dimKeys) {
                Object importValue;
                String entityValue = entityRow.getString(dimKey + ".id");
                if (entityValue.equals((importValue = importData[columnIndex.get(dimKey)]).toString())) continue;
                sameDim = false;
                break;
            }
            if (!sameDim) continue;
            index = i;
            break;
        }
        return index;
    }

    public int filterMemMapRow2(DynamicObjectCollection entityRows, SimpleDynamicObject importData, Map<String, Integer> columnIndex, List<String> dimKeys) {
        int index = -1;
        for (int i = 0; i < entityRows.size(); ++i) {
            DynamicObject entityRow = (DynamicObject)entityRows.get(i);
            boolean sameDim = true;
            for (String dimKey : dimKeys) {
                String entityValue = entityRow.getString(dimKey + ".id");
                Object importValue = importData.getValue(dimKey);
                if (importValue instanceof Map) {
                    Map importValue2 = (Map)importValue;
                    importValue = importValue2.get("id");
                }
                if (entityValue.equals(importValue.toString())) continue;
                sameDim = false;
                break;
            }
            if (!sameDim) continue;
            index = i;
            break;
        }
        return index;
    }

    public void openMainEntryImportPage(IFormPlugin formPlugin, IFormView formView, Map<Long, List<String>> enableCols, Map<String, Long> templates, String billNo, Long modelId, SchemeAssignDimGroup schemeAssignDimGroup) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        customParams.put("model", modelId);
        customParams.put("billNo", billNo);
        customParams.put("templates", ObjectSerialUtil.toByteSerialized(templates));
        customParams.put("colConfig", ObjectSerialUtil.toByteSerialized(enableCols));
        String caption = ResManager.loadKDString((String)"\u5bfc\u5165", (String)"BgApplyBillPlugin_45", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String plugin = "kd.epm.eb.formplugin.applybill.fileImport.BgApplyBillDataImportPlugin";
        String actionId = "mainEntryImport";
        this.showImportBasePage(formView, formPlugin, caption, plugin, actionId, customParams, schemeAssignDimGroup);
    }

    public void showImportBasePage(IFormView formView, IFormPlugin formPlugin, String caption, String plugin, String actionId, Map<String, Object> customParams, SchemeAssignDimGroup schemeAssignDimGroup) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("epm_import");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(caption);
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)"epm_import");
        formConfig.getPlugins().clear();
        showParameter.setFormConfig(formConfig);
        showParameter.addCustPlugin(plugin);
        CloseCallBack callBack = new CloseCallBack(formPlugin, actionId);
        customParams.put("schemeAssignDimGroup", SerializationUtils.serializeToBase64((Object)schemeAssignDimGroup));
        showParameter.setCustomParams(customParams);
        showParameter.setCloseCallBack(callBack);
        formView.showForm(showParameter);
    }

    public Set<Long> queryBizByModel(Long modelId) {
        HashSet<Long> set = new HashSet<Long>();
        QFilter Qf1 = new QFilter("model", "=", (Object)modelId);
        if (modelId == null || modelId == 0L) {
            return null;
        }
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"eb_businessmodel", (String)"id", (QFilter[])new QFilter[]{Qf1});
        for (DynamicObject object : collection) {
            set.add(object.getLong("id"));
        }
        return set;
    }

    public Set<Long> getTemplateByOrg(Long orgId, Long schemeId, Long modelId) {
        HashSet<Long> set = new HashSet<Long>(16);
        DynamicObjectCollection applyRecords = ReportSchemeService.getInstance().getApplyRecordsByScheme(schemeId);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        if (applyRecords != null) {
            DynamicObject schemeObj = BusinessDataServiceHelper.loadSingleFromCache((Object)schemeId, (String)"eb_rptscheme", (String)"orgview");
            Long orgViewId = schemeObj.getLong("orgview.id");
            block0: for (DynamicObject applyRecord : applyRecords) {
                int orgrange = applyRecord.getInt("orgrange");
                String orgnumber = applyRecord.getString("org.number");
                List members = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), orgViewId, orgnumber, orgrange);
                for (Member member : members) {
                    if (!member.getId().equals(orgId)) continue;
                    set.add(applyRecord.getLong("applytemplate"));
                    continue block0;
                }
            }
        }
        return set;
    }

    public String getDimOrRelateDimNumber(BaseColumn column, IModelCacheHelper modelCacheHelper) {
        String number = null;
        if (column instanceof DimensionColumn) {
            number = ((DimensionColumn)column).getDimNumber();
        } else if (column instanceof RelationDimensionColumn) {
            number = this.getRelationDimensionNumber((RelationDimensionColumn)column, modelCacheHelper);
        } else if (column instanceof RowDimensionColumn) {
            number = ((RowDimensionColumn)column).getDimNumber();
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u5176\u4ed6\u7c7b\u578b\u7684\u5217\u65e0\u6cd5\u83b7\u53d6\u7ef4\u5ea6\u7f16\u7801\u3002", (String)"BgApplyBillUtils_2", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        return number;
    }

    public Map<String, String> getDimColumnNumbers(EntryTemplateConfig templateConfig, IModelCacheHelper modelCacheHelper) {
        List entryColumns = templateConfig.getEntryColumns();
        return entryColumns.stream().filter(e -> e instanceof DimensionColumn || e instanceof RelationDimensionColumn || e instanceof RowDimensionColumn).collect(Collectors.toMap(BaseColumn::getKey, e -> this.getDimOrRelateDimNumber((BaseColumn)e, modelCacheHelper)));
    }

    public Map<String, String> getDefaultAddDimMembers(List<Dimension> dimensionList, Map<String, String> hideDimMembers, Map<String, String> colDimMembers, Map<String, String> rowDimMembers) {
        HashMap<String, String> defaultDimMembers = new HashMap<String, String>(16);
        dimensionList.forEach(e -> {
            String number = e.getNumber();
            if (!(hideDimMembers.containsKey(number) || colDimMembers.containsKey(number) || rowDimMembers.containsKey(number))) {
                String memNumber = e.getNoneNumber();
                defaultDimMembers.put(number, memNumber);
            }
        });
        return defaultDimMembers;
    }

    public Map<String, String> getDefaultAddDimMembers2(List<Dimension> dimensionList, Map<String, String> hideDimMembers, Map<String, String> colDimMembers, Map<String, Set<String>> rowDimMembers) {
        HashMap<String, String> defaultDimMembers = new HashMap<String, String>(16);
        dimensionList.forEach(e -> {
            String number = e.getNumber();
            if (!(hideDimMembers.containsKey(number) || colDimMembers.containsKey(number) || rowDimMembers.containsKey(number))) {
                String memNumber = e.getNoneNumber();
                defaultDimMembers.put(number, memNumber);
            }
        });
        return defaultDimMembers;
    }

    public void deleteDimQuote(Set<Long> billIds) {
        if (billIds == null || billIds.size() == 0) {
            return;
        }
        DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"delete", (Object[])new Object[]{MemberQuoteResourceEnum.ApplyBill.getType(), billIds});
    }

    public void deleteBillEntryData(Map<String, Set<Long>> templateInBill) {
        Set<String> billNos = templateInBill.keySet();
        HashSet<Long> templates = new HashSet<Long>(16);
        templateInBill.values().forEach(templates::addAll);
        Map<Long, Pair<String, String>> tempEntryTable = ApplyTemplateUtils.getTempEntryTable(templates);
        List tables = tempEntryTable.values().stream().map(tab -> (String)tab.p1).collect(Collectors.toList());
        String preSql = "delete from ";
        String nextSql = " where fbillnumber in " + billNos.stream().collect(Collectors.joining("','", "('", "')"));
        for (String table : tables) {
            if (table == null || kd.bos.util.StringUtils.isEmpty((String)table)) continue;
            this.executeSql(preSql + table + nextSql);
        }
    }

    private void executeSql(String sql) {
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)sql);
    }

    public void clearBillOlapData(Map<String, Set<Long>> bills, Map<SchemeAssignDimGroup, Set<String>> schemeAssignRecordIdToMapBills, IModelCacheHelper modelCacheHelper, IDataModel dataModel, Boolean onlyAdded) {
        Long modelId;
        HashMap<Long, List> dataEntryMap = new HashMap<Long, List>(16);
        HashSet templates = new HashSet(16);
        Long userId = UserUtils.getUserId();
        bills.values().forEach(templates::addAll);
        HashSet<String> subtotalApplyNumbes = new HashSet<String>(16);
        if (kd.epm.eb.common.utils.CollectionUtils.isNotEmpty(schemeAssignRecordIdToMapBills)) {
            Set<SchemeAssignDimGroup> schemeAssignDimGroups = schemeAssignRecordIdToMapBills.keySet();
            if (CollectionUtils.isNotEmpty(schemeAssignDimGroups)) {
                Optional<Long> first = schemeAssignDimGroups.stream().map(s -> s.getModelId()).findFirst();
                if (first.isPresent()) {
                    modelId = first.get();
                    QFilter filter = new QFilter("model", "=", (Object)modelId);
                    filter.and(new QFilter("billnumber", "in", bills.keySet()));
                    filter.and(new QFilter("showsubtotal", "=", (Object)"1"));
                    DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_bgapplybill", (String)"billnumber", (QFilter[])filter.toArray());
                    if (query != null && !query.isEmpty()) {
                        for (DynamicObject dynamicObject : query) {
                            subtotalApplyNumbes.add(dynamicObject.getString("billnumber"));
                        }
                    }
                } else {
                    modelId = 0L;
                }
            } else {
                modelId = 0L;
            }
        } else {
            modelId = 0L;
        }
        DynamicObjectCollection templateInfos = QueryServiceHelper.query((String)"eb_applytemplate", (String)"id, cachedata_tag, dataset_id,number,entrycfgjson_tag", (QFilter[])new QFilter[]{new QFilter("id", "in", templates)});
        if (templateInfos == null || templateInfos.size() == 0) {
            return;
        }
        Map<Long, DynamicObject> templateConfigMap = templateInfos.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e, (n1, n2) -> n2));
        HashSet allTemps = new HashSet(16);
        HashMap<SchemeAssignDimGroup, Set> schemeAssignRecordIdMapTemps = new HashMap<SchemeAssignDimGroup, Set>(16);
        if (kd.epm.eb.common.utils.CollectionUtils.isNotEmpty(schemeAssignRecordIdToMapBills)) {
            schemeAssignRecordIdToMapBills.forEach((schemeAssignDimGroup, billNums) -> billNums.forEach(billNum -> {
                Set tempIds = (Set)bills.get(billNum);
                if (tempIds != null) {
                    Set temps = schemeAssignRecordIdMapTemps.computeIfAbsent((SchemeAssignDimGroup)schemeAssignDimGroup, key -> new HashSet(16));
                    temps.addAll(tempIds);
                    allTemps.addAll(tempIds);
                }
            }));
        }
        FormTypeEnum formTypeEnumByBillType = ApplyTemplateColCfgService.getInstance().getFormTypeEnumByBillType(ApplyBillType.APPLY.getNumber());
        Map<Long, Map<ColCfgPropTypeEnum, Map<String, ColCfgPropEnum>>> templateColConfigMap = ApplyTemplateColCfgService.getInstance().queryColCfgMapByTemplateIds(new ArrayList<Long>(allTemps), formTypeEnumByBillType);
        schemeAssignRecordIdMapTemps.forEach((schemeAssignDimGroup, tempIds) -> {
            Map varInfo = ReportVarUtil.getVarInfo((SchemeAssignDimGroup)schemeAssignDimGroup);
            Set refBillNums = (Set)schemeAssignRecordIdToMapBills.get(schemeAssignDimGroup);
            for (Long templateId : templates) {
                List<Map<String, String>> subtotalRowDims;
                Map<String, Map<String, String>> detailrows;
                DynamicObject template = (DynamicObject)templateConfigMap.get(templateId);
                if (template == null) continue;
                Map colConfigMap = (Map)templateColConfigMap.get(templateId);
                Map colConfig = (Map)colConfigMap.get(ColCfgPropTypeEnum.EDIT_TYPE);
                List<String> enableViewCols = this.getEnableViewCols(colConfig);
                String templateConfig = template.getString("cachedata_tag");
                if (!kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)templateConfig)) continue;
                Long datasetId = template.getLong("dataset_id");
                Map dimViewMap = modelCacheHelper.getViewsByDataSet(datasetId);
                Map<String, String> hiddenDimMemMap = this.getHiddenDimMemNumMap(templateConfig, dimViewMap, modelCacheHelper, varInfo);
                Map<String, Map<String, Map<String, String>>> colRowDimMembers = this.getColRowDimMembers(templateId, modelCacheHelper, dataModel, refBillNums, null, onlyAdded, varInfo, true);
                Map<String, Map<String, String>> cols = colRowDimMembers.get("col");
                Map<String, Map<String, String>> rows = colRowDimMembers.get("row");
                if (cols.size() == 0 || rows.size() == 0) continue;
                List dataEntries = dataEntryMap.computeIfAbsent(datasetId, k -> new ArrayList(16));
                Map<String, String> defaultAddDimMembers = this.getDefaultAddDimMembers(modelCacheHelper.getDimensionList(datasetId), hiddenDimMemMap, cols.values().iterator().next(), rows.values().iterator().next());
                for (Map<String, String> row : rows.values()) {
                    for (Map.Entry<String, Map<String, String>> entry : cols.entrySet()) {
                        String colKey = entry.getKey();
                        if (!enableViewCols.contains(colKey)) continue;
                        Map<String, String> col = entry.getValue();
                        OlapDataEntry dataEntry = new OlapDataEntry();
                        HashMap<String, String> dimGroup = new HashMap<String, String>(hiddenDimMemMap);
                        dimGroup.putAll(row);
                        dimGroup.putAll(col);
                        dimGroup.putAll(defaultAddDimMembers);
                        dataEntry.setDimMemMap(dimGroup);
                        dataEntry.setValue(null);
                        dataEntries.add(dataEntry);
                    }
                }
                if (subtotalApplyNumbes.isEmpty()) continue;
                EntryTemplateConfig mainEntrytemplateConfig = new EntryTemplateConfig();
                ColumnList columnList = ApplyTemplateUtils.getEntrycfgByApplyTemplate(template);
                Collection columns = columnList.getColumns();
                List<BaseColumn> main_collect = columns.stream().filter(ee -> "h".equals(ee.getCategory())).collect(Collectors.toList());
                ApplyTemplateSubTotal applyTemplateSubTotal = columnList.getApplyTemplateSubTotal();
                List<String> dimKeyList = ApplyTemplateUtils.getDimKeyList(main_collect);
                List<String> rowDimNumList = ApplyTemplateUtils.getRowDimNumList(main_collect, modelCacheHelper);
                mainEntrytemplateConfig.setDimKeysList(dimKeyList);
                mainEntrytemplateConfig.setEntryColumns(main_collect);
                mainEntrytemplateConfig.setApplyTemplateSubTotal(applyTemplateSubTotal);
                mainEntrytemplateConfig.setRowDimNums(rowDimNumList);
                Set<String> notaggkeys = ApplyTemplateUtils.notAggMetricColumn(mainEntrytemplateConfig.getEntryColumns(), modelId);
                Map<String, Map<String, Map<String, String>>> subtotalColRowDimMembers = this.getColRowDimMembers(templateId, modelCacheHelper, dataModel, subtotalApplyNumbes, null, onlyAdded, varInfo, true);
                if (subtotalColRowDimMembers == null || (detailrows = subtotalColRowDimMembers.get("row")) == null || detailrows.isEmpty() || (subtotalRowDims = BgApplyBillUtils.getSubtotalRowDims(mainEntrytemplateConfig, modelCacheHelper, new ArrayList<Map<String, String>>(detailrows.values()))) == null || subtotalRowDims.isEmpty()) continue;
                for (Map<String, String> row : subtotalRowDims) {
                    for (Map.Entry<String, Map<String, String>> entry : cols.entrySet()) {
                        String colKey = entry.getKey();
                        if (!enableViewCols.contains(colKey) && !notaggkeys.contains(colKey)) continue;
                        Map<String, String> col = entry.getValue();
                        OlapDataEntry dataEntry = new OlapDataEntry();
                        HashMap<String, String> dimGroup = new HashMap<String, String>(hiddenDimMemMap);
                        dimGroup.putAll(row);
                        dimGroup.putAll(col);
                        dimGroup.putAll(defaultAddDimMembers);
                        dataEntry.setDimMemMap(dimGroup);
                        dataEntry.setValue(null);
                        dataEntries.add(dataEntry);
                    }
                }
            }
        });
        dataEntryMap.forEach((key, value) -> this.saveOlapData((List<OlapDataEntry>)value, (long)key, userId, modelCacheHelper, null));
    }

    public List<String> getEnableViewCols(Map<String, ColCfgPropEnum> colConfig) {
        ArrayList<String> cols = new ArrayList<String>(16);
        for (Map.Entry<String, ColCfgPropEnum> colConfigDetail : colConfig.entrySet()) {
            String key = colConfigDetail.getKey();
            ColCfgPropEnum value = colConfigDetail.getValue();
            if (ColCfgPropEnum.HIDE == value) continue;
            cols.add(key);
        }
        return cols;
    }

    public List<String> getMemberRanges(List<DimensionMemberRange> dimensionMemberRanges, IModelCacheHelper modelCacheHelper, Long dataSetId, String dimNumber) {
        ArrayList<String> memNumbers = new ArrayList<String>(16);
        Long viewId = DimensionViewServiceHelper.getViewId((Long)dataSetId, (String)dimNumber);
        memNumbers.addAll(this.getAllMembersInRange(dimensionMemberRanges, modelCacheHelper, dimNumber, viewId));
        List members = modelCacheHelper.getMembers(viewId, dimNumber);
        if (members != null && members.size() != 0) {
            List memInDataSet = members.stream().map(BaseCache::getNumber).collect(Collectors.toList());
            memNumbers.retainAll(memInDataSet);
        } else {
            memNumbers.clear();
        }
        return memNumbers;
    }

    private Set<String> getAllMembersInRange(List<DimensionMemberRange> dimensionMemberRanges, IModelCacheHelper modelCacheHelper, String dimNum, Long viewId) {
        HashSet<String> memNums = new HashSet<String>(16);
        if (dimensionMemberRanges != null) {
            dimensionMemberRanges.forEach(e -> {
                int scope = Integer.parseInt(e.getScope());
                List members = modelCacheHelper.getMember(dimNum, viewId, e.getNumber(), scope);
                members.forEach(h -> {
                    if (h.isLeaf()) {
                        memNums.add(h.getNumber());
                    }
                });
            });
        }
        return memNums;
    }

    public CentralAppChain getChainFromCollectBill(DynamicObject billObj) {
        String auditPath = billObj.getString("auditpath");
        CentralAppChain chain = kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)auditPath) ? new CentralAppChain() : (CentralAppChain)SerializationUtils.fromJsonString((String)auditPath, CentralAppChain.class);
        return chain;
    }

    public void filterDataByAccountAndOrg(List<Object[]> allRowData, EntryTemplateConfig templateConfig, Set<Long> entitySet, Set<Long> accountSet, boolean needClearNotDetail) {
        Long hidEntityId = (Long)templateConfig.getHiddenDimMemMap().get(SysDimensionEnum.Entity.getNumber());
        Long hidAccountId = (Long)templateConfig.getHiddenDimMemMap().get(SysDimensionEnum.Account.getNumber());
        Map columnIndex = templateConfig.getColumnIndex();
        if (entitySet == null && accountSet == null) {
            return;
        }
        if (hidEntityId != null && entitySet != null && !entitySet.contains(hidEntityId)) {
            allRowData.clear();
            return;
        }
        if (hidAccountId != null && accountSet != null && !accountSet.contains(hidAccountId)) {
            allRowData.clear();
            return;
        }
        if (templateConfig.getOrgColumnKey() == null && templateConfig.getAccountColumnKey() == null) {
            return;
        }
        Iterator<Object[]> iterator = allRowData.iterator();
        int accontColumnIndex = -1;
        int orgColumnIndex = -1;
        if (templateConfig.getAccountColumnKey() != null) {
            accontColumnIndex = (Integer)columnIndex.get(templateConfig.getAccountColumnKey());
        }
        if (templateConfig.getOrgColumnKey() != null) {
            orgColumnIndex = (Integer)columnIndex.get(templateConfig.getOrgColumnKey());
        }
        while (iterator.hasNext()) {
            boolean notContainEntity;
            Object[] rowData = iterator.next();
            String dataType = (String)rowData[3];
            boolean isDetail = EntityRowDataType.isDetailData((String)dataType);
            boolean notContainAccount = accontColumnIndex > 0 && accountSet != null && !accountSet.contains(rowData[accontColumnIndex]);
            boolean bl = notContainEntity = orgColumnIndex > 0 && entitySet != null && !entitySet.contains(rowData[orgColumnIndex]);
            if ((!needClearNotDetail || isDetail) && (!isDetail || !notContainAccount && !notContainEntity)) continue;
            iterator.remove();
        }
    }

    public void filterDataByOrg(List<Object[]> allRowData, EntryTemplateConfig templateConfig, Set<Long> entitySet, boolean needClearNotDetail) {
        Long hidEntityId = (Long)templateConfig.getHiddenDimMemMap().get(SysDimensionEnum.Entity.getNumber());
        Map columnIndex = templateConfig.getColumnIndex();
        if (entitySet == null) {
            return;
        }
        if (hidEntityId != null && entitySet != null && !entitySet.contains(hidEntityId)) {
            allRowData.clear();
            return;
        }
        if (templateConfig.getOrgColumnKey() == null) {
            return;
        }
        Iterator<Object[]> iterator = allRowData.iterator();
        int orgColumnIndex = -1;
        if (templateConfig.getOrgColumnKey() != null) {
            orgColumnIndex = (Integer)columnIndex.get(templateConfig.getOrgColumnKey());
        }
        while (iterator.hasNext()) {
            boolean notContainEntity;
            Object[] rowData = iterator.next();
            String dataType = (String)rowData[3];
            boolean isDetail = EntityRowDataType.isDetailData((String)dataType);
            boolean bl = notContainEntity = orgColumnIndex > 0 && entitySet != null && !entitySet.contains(rowData[orgColumnIndex]);
            if ((!needClearNotDetail || isDetail) && (!isDetail || !notContainEntity)) continue;
            iterator.remove();
        }
    }

    public void filterDataBySubBill(List<Object[]> allRowData, EntryTemplateConfig templateConfig, CentralAppShowInfo showinfo, boolean needClearNotDetail, IModelCacheHelper modelCacheHelper) {
        boolean mainBill = showinfo.isMainBill();
        if (mainBill) {
            return;
        }
        List configs = showinfo.getApproveBillConfigs().stream().filter(s -> s.getTemplateId().equals(templateConfig.getTemplateID())).collect(Collectors.toList());
        ArrayList filterdatas = new ArrayList(16);
        for (ApproveBillConfig config : configs) {
            List matchMemberIds = config.getMatchMemberIds();
            filterdatas.addAll(matchMemberIds);
        }
        if (filterdatas.isEmpty()) {
            allRowData.clear();
            return;
        }
        List main_collect = templateConfig.getEntryColumns().stream().filter(ee -> ee.getType() == ColumnEnum.Dimension || ee.getType() == ColumnEnum.RowDimension).collect(Collectors.toList());
        HashMap<String, String> dimkeyMapfieldKey = new HashMap<String, String>(16);
        for (BaseColumn baseColumn : main_collect) {
            String dimNumber;
            DimensionColumn ncolumn;
            if (baseColumn instanceof DimensionColumn) {
                ncolumn = (DimensionColumn)baseColumn;
                dimNumber = ncolumn.getDimNumber();
                dimkeyMapfieldKey.put(dimNumber, ncolumn.getKey());
                continue;
            }
            if (baseColumn instanceof RelationDimensionColumn) {
                ncolumn = (RelationDimensionColumn)baseColumn;
                dimNumber = modelCacheHelper.getDimension(Long.valueOf(ncolumn.getDimensionId())).getNumber();
                dimkeyMapfieldKey.put(dimNumber, ncolumn.getKey());
                continue;
            }
            if (!(baseColumn instanceof RowDimensionColumn)) continue;
            ncolumn = (RowDimensionColumn)baseColumn;
            dimNumber = ncolumn.getDimNumber();
            dimkeyMapfieldKey.put(dimNumber, ncolumn.getKey());
        }
        Map columnIndex = templateConfig.getColumnIndex();
        Iterator<Object[]> iterator = allRowData.iterator();
        while (iterator.hasNext()) {
            Object[] rowData = iterator.next();
            String dataType = (String)rowData[3];
            boolean isdelete = true;
            for (Map filterdata : filterdatas) {
                ArrayList<Boolean> iscontain = new ArrayList<Boolean>(16);
                for (Map.Entry map : filterdata.entrySet()) {
                    String key = (String)map.getKey();
                    Set value = (Set)map.getValue();
                    Long hidEntityId = (Long)templateConfig.getHiddenDimMemMap().get(key);
                    if (value == null || value.isEmpty()) {
                        iscontain.add(true);
                        continue;
                    }
                    if (hidEntityId != null) {
                        iscontain.add(true);
                        continue;
                    }
                    String nkey = (String)dimkeyMapfieldKey.get(key);
                    if (nkey == null) {
                        iscontain.add(true);
                        continue;
                    }
                    Integer index = (Integer)columnIndex.get(nkey);
                    iscontain.add(value.contains(rowData[index]));
                }
                if (!iscontain.stream().allMatch(s -> s)) continue;
                isdelete = false;
                break;
            }
            if (!isdelete) continue;
            iterator.remove();
        }
    }

    public Map<Long, Map<String, Set<Long>>> selectEntityDataForCollectBillSubmit(Map<String, List<Object[]>> detailData, Map<String, EntryTemplateConfig> allTemplateConfig) {
        HashMap<Long, Map<String, Set<Long>>> collectBillOrgIds = new HashMap<Long, Map<String, Set<Long>>>(16);
        for (Map.Entry<String, EntryTemplateConfig> tempConfigEntry : allTemplateConfig.entrySet()) {
            String entityKey = tempConfigEntry.getKey();
            EntryTemplateConfig tempConfig = tempConfigEntry.getValue();
            if (this.isBizEntry(entityKey)) continue;
            Long entityIdOnHideDim = (Long)tempConfig.getHiddenDimMemMap().get(SysDimensionEnum.Entity.getNumber());
            HashMap allOrgIds = new HashMap(16);
            HashSet newRowOrgIds = new HashSet();
            String orgColumnKey = tempConfig.getOrgColumnKey();
            int orgColumnIndex = tempConfig.getColumnIndex().getOrDefault(orgColumnKey, -1);
            List<Object[]> allRowData = detailData.get(entityKey);
            if (allRowData != null) {
                allRowData.forEach(rowData -> {
                    String billType = (String)rowData[1];
                    String dataType = (String)rowData[3];
                    if (EntityRowDataType.isDetailData((String)dataType)) {
                        boolean isApplyBill;
                        Long orgId = null;
                        if (entityIdOnHideDim == null) {
                            if (orgColumnIndex != -1) {
                                orgId = (Long)rowData[orgColumnIndex];
                            }
                        } else {
                            orgId = entityIdOnHideDim;
                        }
                        String billNumber = (String)rowData[2];
                        boolean bl = isApplyBill = kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)billType) || ApplyBillType.isApplyBill((String)billType);
                        if (isApplyBill) {
                            Set orgIds = allOrgIds.computeIfAbsent(billNumber, b -> new HashSet(16));
                            orgIds.add(orgId);
                        } else {
                            newRowOrgIds.add(orgId);
                        }
                    }
                });
            }
            if (newRowOrgIds.size() > 0) {
                allOrgIds.put("0", newRowOrgIds);
            }
            collectBillOrgIds.put(tempConfig.getTemplateID(), allOrgIds);
        }
        return collectBillOrgIds;
    }

    public Map<String, Long> selectDVYOnBillObj(DynamicObject billObj) {
        HashMap<String, Long> dataMap = new HashMap<String, Long>();
        DynamicObject year = billObj.getDynamicObject("year");
        DynamicObject version = billObj.getDynamicObject("version");
        DynamicObject datatype = billObj.getDynamicObject("datatype");
        dataMap.put(SysDimensionEnum.DataType.getNumber(), datatype.getLong("id"));
        dataMap.put(SysDimensionEnum.Year.getNumber(), year.getLong("id"));
        dataMap.put(SysDimensionEnum.Version.getNumber(), version.getLong("id"));
        return dataMap;
    }

    public boolean isBizEntry(String entryKey) {
        return entryKey.startsWith("bizentryentity");
    }

    public Pair<Boolean, Set<Long>> getControlMembIds(Member member, Set<Long> containMembIds) {
        HashSet<Long> membIds = new HashSet<Long>(16);
        Count membCount = new Count(0);
        this.checkAndSelectDisableNode(member, containMembIds, membIds, membCount);
        if (member != null && membIds.size() > membCount.getCount() / 2) {
            HashSet resultMembIds = new HashSet(membCount.getCount() - membIds.size());
            member.iterate(child -> {
                if (!membIds.contains(child.getId())) {
                    resultMembIds.add(child.getId());
                }
            });
            return new Pair((Object)Boolean.TRUE, resultMembIds);
        }
        return new Pair((Object)Boolean.FALSE, membIds);
    }

    private boolean checkAndSelectDisableNode(Member member, Set<Long> containMembIds, Set<Long> disableMembIds, Count membCount) {
        if (member != null) {
            boolean hasChildDisable = false;
            if (!member.isLeaf()) {
                for (Member child : member.getChildren()) {
                    if (!this.checkAndSelectDisableNode(child, containMembIds, disableMembIds, membCount) || hasChildDisable) continue;
                    hasChildDisable = true;
                }
            }
            membCount.add(1);
            if (hasChildDisable || member.isLeaf() && !containMembIds.contains(member.getId())) {
                disableMembIds.add(member.getId());
                return true;
            }
        }
        return false;
    }

    public Map<String, Long> getDimMembList(List<String> dimKeysList, Map<String, String> columnMapDimNum, Object[] rowVals, Map<String, Integer> columnIndexKey) {
        HashMap<String, Long> dimMembs = new HashMap<String, Long>(dimKeysList.size());
        for (String dimColumnKey : dimKeysList) {
            String dimNum = columnMapDimNum.get(dimColumnKey);
            dimMembs.put(dimNum, (Long)rowVals[columnIndexKey.get(dimColumnKey)]);
        }
        return dimMembs;
    }

    public Integer formatInt(String dataStr) {
        return kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)dataStr) ? 0 : Integer.parseInt(dataStr);
    }

    public BigDecimal formatBigDecimal(String dataStr) {
        return kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)dataStr) ? BigDecimal.ZERO : new BigDecimal(dataStr);
    }

    public Map<String, List<Object[]>> getAuditBillData(CentralAppShowInfo showInfo, String billNumber, Map<String, EntryTemplateConfig> entryTemplateConfig, boolean needBizEnitiyData) {
        return this.getCollectData(showInfo.getCentralAppChain(), showInfo.getReportBillNos(), showInfo.getRefedBillNos(), billNumber, showInfo.getEntitySet(), showInfo.getAccountSet(), entryTemplateConfig, needBizEnitiyData, false);
    }

    public Map<String, List<Object[]>> getAuditBillDataNew(CentralAppShowInfo showInfo, String billNumber, Map<String, EntryTemplateConfig> entryTemplateConfig, boolean needBizEnitiyData, boolean needClearNotDetail) {
        return this.getCollectDataNew(showInfo, billNumber, entryTemplateConfig, needBizEnitiyData, needClearNotDetail);
    }

    public Map<String, List<Object[]>> getCollectData(CentralAppChain chain, Set<String> applyBillNumbers, Set<String> refedBillNumbers, String currentBillNumber, Set<Long> orgIds, Set<Long> accountIds, Map<String, EntryTemplateConfig> entryTemplateConfig, boolean needBizEnitiyData, boolean needClearNotDetail) {
        HashMap<String, List<Object[]>> rowDatas = new HashMap<String, List<Object[]>>(16);
        Set<String> centralAppChainsBillSet = CentralAppBillService.getInstance().getCentralAppChainsBillSet(chain);
        centralAppChainsBillSet.addAll(applyBillNumbers);
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)currentBillNumber)) {
            centralAppChainsBillSet.add(currentBillNumber);
        }
        centralAppChainsBillSet.addAll(refedBillNumbers);
        log.info("getCollectData ---- centralAppChainsBillSet: " + centralAppChainsBillSet + " applyBillNumbers: " + applyBillNumbers + " currentBillNumber:" + currentBillNumber + " refedBillNumbers: " + refedBillNumbers);
        Long applyBillId = 0L;
        centralAppChainsBillSet.remove("");
        if (applyBillNumbers.size() > 0) {
            String applyBillNumber = applyBillNumbers.iterator().next();
            applyBillId = (Long)CommonServiceHelper.getValueFromDB((String)"eb_bgapplybill", (String)"id", (String)"billnumber", (Object[])new Object[]{applyBillNumber});
        }
        for (Map.Entry<String, EntryTemplateConfig> entry : entryTemplateConfig.entrySet()) {
            List<Object[]> collectBillData;
            String entityname = entry.getKey();
            List main_collect = entry.getValue().selectEntryColumnsNoDimText();
            main_collect.removeIf(BaseColumn::isIgnoreDB);
            String table = entry.getValue().getEntryTable();
            Long templateId = entry.getValue().getTemplateID();
            if (this.isBizEntry(entityname)) {
                if (!needBizEnitiyData) continue;
                collectBillData = ApplyTemplateUtils.getEntityData(table, applyBillId, main_collect);
            } else {
                collectBillData = ApplyTemplateUtils.getBatchBillData(table, centralAppChainsBillSet, main_collect);
                this.filterDataByAccountAndOrg(collectBillData, entry.getValue(), orgIds, accountIds, needClearNotDetail);
                this.mergeSameDimGroupRecord(collectBillData, entry.getValue());
            }
            rowDatas.put(entityname, collectBillData);
        }
        return rowDatas;
    }

    public Map<String, List<Object[]>> getCollectDataNew(CentralAppShowInfo showInfo, String currentBillNumber, Map<String, EntryTemplateConfig> entryTemplateConfig, boolean needBizEnitiyData, boolean needClearNotDetail) {
        CentralAppChain chain = showInfo.getCentralAppChain();
        Set applyBillNumbers = showInfo.getReportBillNos();
        Set refedBillNumbers = showInfo.getRefedBillNos();
        HashMap<String, List<Object[]>> rowDatas = new HashMap<String, List<Object[]>>(16);
        Set<String> centralAppChainsBillSet = CentralAppBillService.getInstance().getCentralAppChainsBillSet(chain);
        centralAppChainsBillSet.addAll(applyBillNumbers);
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)currentBillNumber)) {
            centralAppChainsBillSet.add(currentBillNumber);
        }
        centralAppChainsBillSet.addAll(refedBillNumbers);
        log.info("getCollectData ---- centralAppChainsBillSet: " + centralAppChainsBillSet + " applyBillNumbers: " + applyBillNumbers + " currentBillNumber:" + currentBillNumber + " refedBillNumbers: " + refedBillNumbers);
        Long applyBillId = 0L;
        centralAppChainsBillSet.remove("");
        if (applyBillNumbers.size() > 0) {
            String applyBillNumber = (String)applyBillNumbers.iterator().next();
            applyBillId = (Long)CommonServiceHelper.getValueFromDB((String)"eb_bgapplybill", (String)"id", (String)"billnumber", (Object[])new Object[]{applyBillNumber});
        }
        Long modelId = 0L;
        Optional<EntryTemplateConfig> first = entryTemplateConfig.values().stream().findFirst();
        if (first.isPresent()) {
            modelId = first.get().getModelId();
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        for (Map.Entry<String, EntryTemplateConfig> entry : entryTemplateConfig.entrySet()) {
            List<Object[]> collectBillData;
            String entityname = entry.getKey();
            List main_collect = entry.getValue().selectEntryColumnsNoDimText();
            main_collect.removeIf(BaseColumn::isIgnoreDB);
            String table = entry.getValue().getEntryTable();
            Long tempateId = entry.getValue().getTemplateID();
            if (this.isBizEntry(entityname)) {
                if (!needBizEnitiyData) continue;
                collectBillData = ApplyTemplateUtils.getEntityData(table, applyBillId, main_collect);
            } else {
                collectBillData = ApplyTemplateUtils.getBatchBillData(table, centralAppChainsBillSet, main_collect);
                log.info("BgApplyBillUtils.getCollectDataNew--\u6743\u9650\u8fc7\u6ee4\u524d\u6570\u636e\uff1a" + SerializationUtils.toJsonString(collectBillData) + "----size:" + collectBillData.size());
                this.IsCheckItem(entry, modelCacheHelper, collectBillData);
                log.info("BgApplyBillUtils.IsCheckItem--\u6743\u9650\u8fc7\u6ee4\u540e\u6570\u636e\uff1a" + SerializationUtils.toJsonString(collectBillData) + "----size:" + collectBillData.size());
                this.filterDataByOrg(collectBillData, entry.getValue(), showInfo.getEntitySet(), needClearNotDetail);
                log.info("BgApplyBillUtils.filterDataByOrg--\u6743\u9650\u8fc7\u6ee4\u540e\u6570\u636e\uff1a" + SerializationUtils.toJsonString(collectBillData) + "----size:" + collectBillData.size());
                this.filterDataBySubBill(collectBillData, entry.getValue(), showInfo, needClearNotDetail, modelCacheHelper);
                this.mergeSameDimGroupRecord(collectBillData, entry.getValue());
                log.info("BgApplyBillUtils.getCollectDataNew--\u6743\u9650\u8fc7\u6ee4\u540e\u6570\u636e\uff1a" + SerializationUtils.toJsonString(collectBillData) + "----size:" + collectBillData.size());
            }
            rowDatas.put(entityname, collectBillData);
        }
        return rowDatas;
    }

    private void IsCheckItem(Map.Entry<String, EntryTemplateConfig> entry, IModelCacheHelper modelCacheHelper, List<Object[]> collectBillData) {
        HashMap<Integer, List<Map<String, Long>>> memberMap = this.getSelectedMemberNew(entry, modelCacheHelper, collectBillData);
        HashSet<Integer> indexs = new HashSet<Integer>(16);
        for (Map.Entry<Integer, List<Map<String, Long>>> memberMapEntry : memberMap.entrySet()) {
            Integer index = memberMapEntry.getKey();
            List<Map<String, Long>> list = memberMapEntry.getValue();
            Boolean hasPermission = this.filterPermRead(list, entry.getValue().getDatasetId(), modelCacheHelper);
            if (hasPermission.booleanValue()) continue;
            indexs.add(index);
        }
        if (!indexs.isEmpty()) {
            Iterator<Object[]> iterator = collectBillData.iterator();
            int currentIndex = 0;
            while (iterator.hasNext()) {
                iterator.next();
                if (indexs.contains(currentIndex)) {
                    iterator.remove();
                }
                ++currentIndex;
            }
        }
    }

    private Boolean filterPermRead(List<Map<String, Long>> list, long datasetId, IModelCacheHelper modelCache) {
        Long modelId = modelCache.getModelobj().getId();
        DimMemberPermChecker readPermChecker = DimMembPermHelper.getReadPermChecker((Long)modelId, (Long)datasetId);
        if (readPermChecker.hasAllPerm()) {
            return true;
        }
        ArrayList<Boolean> isHavePerm = new ArrayList<Boolean>(list.size());
        for (Map<String, Long> dimMap : list) {
            HashMap<String, MemberItem> memberGroup = new HashMap<String, MemberItem>(16);
            for (Map.Entry<String, Long> dimEntry : dimMap.entrySet()) {
                MemberItem mi = new MemberItem(true, dimEntry.getValue());
                memberGroup.put(dimEntry.getKey(), mi);
            }
            boolean check = readPermChecker.check(memberGroup);
            isHavePerm.add(check);
            log.info("BgApplyBillUtils.filterPermRead--\u8bfb\u6743\u9650\u8fc7\u6ee4\uff1a" + SerializationUtils.toJsonString(dimMap) + "----result:" + check);
        }
        return isHavePerm.contains(true);
    }

    protected HashMap<Integer, List<Map<String, Long>>> getSelectedMemberNew(Map.Entry<String, EntryTemplateConfig> entry, IModelCacheHelper modelCacheHelper, List<Object[]> entityData) {
        EntryTemplateConfig entryConfig = entry.getValue();
        ArrayList<BaseColumn> measureCols = new ArrayList<BaseColumn>(16);
        ArrayList<BaseColumn> dimensionCols = new ArrayList<BaseColumn>(16);
        List entryColumns = entryConfig.getEntryColumns();
        List columns = entryColumns.stream().filter(ee -> !ee.getKey().endsWith("_text")).collect(Collectors.toList());
        for (BaseColumn column : columns) {
            if (column.getType() == ColumnEnum.Dimension || column.getType() == ColumnEnum.RelationDimension || column.getType() == ColumnEnum.RowDimension) {
                dimensionCols.add(column);
                continue;
            }
            if (column.getType() != ColumnEnum.Measure && column.getType() != ColumnEnum.DimensionData) continue;
            measureCols.add(column);
        }
        Map columnIndexes = entryConfig.getColumnIndex();
        Map<String, Map<String, Long>> allColDimMembers = BgApplyBillUtils.getInstance().getAllColDimMemberIds(measureCols, modelCacheHelper);
        HashMap<String, Integer> rowDimColumnIndex = new HashMap<String, Integer>(16);
        dimensionCols.forEach(e -> {
            Integer cfr_ignored_0 = (Integer)rowDimColumnIndex.put(BgApplyBillUtils.getInstance().getDimOrRelateDimNumber((BaseColumn)e, modelCacheHelper), (Integer)columnIndexes.get(e.getKey()));
        });
        HashMap allRowDimMembers = new HashMap(16);
        for (int i = 0; i < entityData.size(); ++i) {
            Object[] data = entityData.get(i);
            String dataType = (String)data[3];
            if (!EntityRowDataType.isDetailData((String)dataType)) continue;
            HashMap rowMemMap = new HashMap(16);
            rowDimColumnIndex.forEach((key, value) -> {
                Long memberId = (Long)data[value];
                rowMemMap.put(key, memberId);
            });
            allRowDimMembers.put(i, rowMemMap);
        }
        Map hideDimMembers = entryConfig.getHiddenDimMemMap();
        HashMap<Integer, List<Map<String, Long>>> dimMap = new HashMap<Integer, List<Map<String, Long>>>(16);
        for (Map.Entry mapEntry : allRowDimMembers.entrySet()) {
            Integer key2 = (Integer)mapEntry.getKey();
            Map rowDimMembers = (Map)mapEntry.getValue();
            ArrayList dimGroups = new ArrayList(16);
            for (Map.Entry<String, Map<String, Long>> stringMapEntry : allColDimMembers.entrySet()) {
                Map<String, Long> colDimMembers = stringMapEntry.getValue();
                colDimMembers.entrySet().removeIf(e -> rowDimMembers.containsKey(e.getKey()) && (Long)e.getValue() == 0L);
                HashMap<String, Long> mergedDimMembers = new HashMap<String, Long>(rowDimMembers);
                mergedDimMembers.putAll(colDimMembers);
                mergedDimMembers.putAll(hideDimMembers);
                dimGroups.add(mergedDimMembers);
            }
            dimMap.put(key2, dimGroups);
        }
        return dimMap;
    }

    public void mergeSameDimGroupRecord(List<Object[]> allRowData, EntryTemplateConfig templateConfig) {
        if (allRowData.size() > 0) {
            StringBuilder sb = new StringBuilder();
            ApplyBillAggHelper billAggHelper = ApplyBillAggHelper.getInstance();
            HashMap<String, Integer> recordMap = new HashMap<String, Integer>(16);
            int index = 0;
            Iterator<Object[]> iterator = allRowData.iterator();
            while (iterator.hasNext()) {
                Object[] rowData = iterator.next();
                String dimMembStr = this.seletRowDimMembIds(rowData, templateConfig.getDimKeysList(), templateConfig.getColumnIndex());
                Integer rowIndex = (Integer)recordMap.get(dimMembStr);
                if (rowIndex != null) {
                    Object[] existedRowData = allRowData.get(rowIndex);
                    String dataType = billAggHelper.getRowDataType(rowData);
                    Timestamp modifTime1 = billAggHelper.getModifTime(existedRowData);
                    Timestamp midifTime2 = billAggHelper.getModifTime(rowData);
                    sb.append(existedRowData[0]).append('-').append(rowData[0]).append(',');
                    if (EntityRowDataType.isDetailData((String)dataType)) {
                        if (midifTime2.after(modifTime1)) {
                            allRowData.set(rowIndex, rowData);
                        }
                    } else if (midifTime2.after(modifTime1)) {
                        this.mergeRowVal(existedRowData, rowData);
                        allRowData.set(rowIndex, rowData);
                    } else {
                        this.mergeRowVal(rowData, existedRowData);
                    }
                    iterator.remove();
                    continue;
                }
                recordMap.put(dimMembStr, index);
                ++index;
            }
            if (sb.length() > 0) {
                CommonServiceHelper.handleLog((Log)log, (String)("mergeSameDimGroupRecord:" + templateConfig.getNumber()), (String)sb.toString());
            }
        }
    }

    public void mergeRowVal(Object[] sourceRow, Object[] targetRow) {
        int length = sourceRow.length;
        for (int i = 0; i < length; ++i) {
            Object val1 = sourceRow[i];
            Object val2 = targetRow[i];
            if (val1 == null) continue;
            if (val1 instanceof Integer) {
                targetRow[i] = (Integer)val1 + (Integer)val2;
                continue;
            }
            if (!(val1 instanceof BigDecimal)) continue;
            targetRow[i] = ((BigDecimal)val1).add((BigDecimal)val2);
        }
    }

    public String seletRowDimMembIds(Object[] rowVals, List<String> dimColumnKeys, Map<String, Integer> columnIndex) {
        StringBuilder sb = new StringBuilder();
        for (String key : dimColumnKeys) {
            Object membId = rowVals[columnIndex.get(key)];
            sb.append(membId).append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public Set<Long> getMembsAncestor(Set<Long> membIds, String dimNumber, IModelCacheHelper modelCacheHelper, Long viewId) {
        HashSet<Long> ancestorIds = new HashSet<Long>(16);
        if (!membIds.isEmpty()) {
            Dimension dimension = modelCacheHelper.getDimension(dimNumber);
            List members = dimension.getMember(viewId, membIds);
            for (Member member : members) {
                List parents = ModelCacheServiceHelper.getParents((Long)viewId, (Member)member, (boolean)true);
                parents.forEach(p -> ancestorIds.add(p.getId()));
            }
        }
        return ancestorIds;
    }

    public void setOneAdjustedColumnColor(IFormView formView, String entityKey, int rowIndex, String columnKey) {
        EntryGrid entryGrid = (EntryGrid)formView.getControl(entityKey);
        ArrayList<CellStyle> cellStyleList = new ArrayList<CellStyle>(16);
        CellStyle cellStyle = this.createCellStype(columnKey, rowIndex);
        cellStyleList.add(cellStyle);
        entryGrid.setCellStyle(cellStyleList);
    }

    public CellStyle createCellStype(String columnKey, int rowIndex) {
        CellStyle cellStyle = new CellStyle();
        cellStyle.setRow(rowIndex);
        cellStyle.setForeColor("blue");
        cellStyle.setFieldKey(columnKey);
        return cellStyle;
    }

    public BigDecimal getUnitData(String unitStr) {
        int unit = this.getUnit(unitStr);
        BigDecimal unitData = BigDecimal.TEN.pow(unit);
        return unitData;
    }

    private int getUnit(String val) {
        int unit = 0;
        switch (val) {
            case "1": {
                unit = 0;
                break;
            }
            case "2": {
                unit = 3;
                break;
            }
            case "3": {
                unit = 4;
                break;
            }
            case "4": {
                unit = 5;
                break;
            }
            case "5": {
                unit = 6;
                break;
            }
            case "6": {
                unit = 7;
                break;
            }
            case "7": {
                unit = 8;
            }
        }
        return unit;
    }

    public DynamicObject getBgAppSchemeObj(ApproveBill appBill) {
        Long bgAppSchemeId = appBill.getReportScheme();
        DynamicObject bgAppScheme = null;
        if (bgAppSchemeId != 0L) {
            bgAppScheme = BusinessDataServiceHelper.loadSingle((Object)bgAppSchemeId, (String)"eb_rptscheme");
        }
        return bgAppScheme;
    }

    public TreeNode buildOrgTreeByFilters(Long modelId, QFilter qFilter, String idPre) {
        TreeNode rootNode = new TreeNode();
        if (qFilter == null) {
            return rootNode;
        }
        qFilter.or(new QFilter("level", "=", (Object)1).and("model", "=", (Object)modelId));
        HashMap<String, TreeNode> longNumberMap = new HashMap<String, TreeNode>(16);
        try (DataSet epmOrgDataSet = QueryServiceHelper.queryDataSet((String)"buildOrgTreeByFilters", (String)"epm_entitymembertree", (String)"id,name,number,longnumber,parent", (QFilter[])qFilter.toArray(), (String)"level,dseq,number");){
            while (epmOrgDataSet.hasNext()) {
                int i;
                Row next = epmOrgDataSet.next();
                Long orgId = next.getLong("id");
                String longNumber = next.getString("longnumber");
                TreeNode node = new TreeNode();
                String nodeId = idPre == null ? String.valueOf(orgId) : idPre + "_" + orgId;
                node.setId(nodeId);
                node.setLongNumber(next.getString("number"));
                node.setText(next.getString("name"));
                longNumberMap.put(longNumber, node);
                String parentLongNumber = "";
                if (longNumber.lastIndexOf("!") != -1) {
                    parentLongNumber = longNumber.substring(0, longNumber.lastIndexOf("!"));
                }
                while (!longNumberMap.containsKey(parentLongNumber) && kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)parentLongNumber) && (i = parentLongNumber.lastIndexOf("!")) != -1) {
                    parentLongNumber = parentLongNumber.substring(0, i);
                }
                if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)parentLongNumber)) {
                    rootNode = (TreeNode)longNumberMap.get("Entity");
                    continue;
                }
                if (!longNumberMap.containsKey(parentLongNumber)) continue;
                TreeNode parentNode = (TreeNode)longNumberMap.get(parentLongNumber);
                node.setParentid(parentNode.getId());
                parentNode.addChild(node);
            }
        }
        return rootNode;
    }

    public Map<Long, String> getSchemeIdNameMap(Map<String, List<Long>> yvdSchemeOrgMap) {
        HashMap<Long, String> schemeIdNameMap = new HashMap<Long, String>(16);
        ArrayList<Long> schemeIds = new ArrayList<Long>(10);
        for (List<Long> value : yvdSchemeOrgMap.values()) {
            schemeIds.addAll(value);
        }
        if (schemeIds.size() == 0) {
            return schemeIdNameMap;
        }
        try (DataSet ds = DB.queryDataSet((String)"getSchemeIdNameMap", (DBRoute)DBRoute.of((String)"epm"), (String)("select fid,fname from t_eb_rptscheme_l where fid in (" + StringUtils.join((Object[])schemeIds.toArray(), (String)",") + ")"));){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                schemeIdNameMap.put(row.getLong("fid"), row.getString("fname"));
            }
        }
        return schemeIdNameMap;
    }

    public Map<Long, String> getDeepSortOrgIdNameMap(Long modelId) {
        LinkedHashMap<Long, String> deepSortOrgIdNameMap = new LinkedHashMap<Long, String>(16);
        LinkedHashMap<Long, List<Long>> childNodeIdsMap = new LinkedHashMap<Long, List<Long>>(16);
        HashMap<Long, String> orgIdNameMap = new HashMap<Long, String>(16);
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        DataSet epmOrgDataSet = QueryServiceHelper.queryDataSet((String)"getDeepSortOrgIdNameMap", (String)"epm_entitymembertree", (String)"id,name,parent", (QFilter[])new QFilter[]{qFilter}, (String)"level,dseq,number");
        Object object = null;
        try {
            while (epmOrgDataSet.hasNext()) {
                Row next = epmOrgDataSet.next();
                List childIds = childNodeIdsMap.computeIfAbsent(next.getLong("parent"), e -> new ArrayList(0));
                childIds.add(next.getLong("id"));
                orgIdNameMap.put(next.getLong("id"), next.getString("name"));
            }
        }
        catch (Throwable next) {
            object = next;
            throw next;
        }
        finally {
            if (epmOrgDataSet != null) {
                if (object != null) {
                    try {
                        epmOrgDataSet.close();
                    }
                    catch (Throwable next) {
                        ((Throwable)object).addSuppressed(next);
                    }
                } else {
                    epmOrgDataSet.close();
                }
            }
        }
        if (childNodeIdsMap.size() > 0) {
            ArrayList<Long> deepSortOrgIdList = new ArrayList<Long>(10);
            this.getDeepSortOrgIdList(childNodeIdsMap, (Long)childNodeIdsMap.keySet().iterator().next(), deepSortOrgIdList);
            for (Long orgId : deepSortOrgIdList) {
                if (!orgIdNameMap.containsKey(orgId)) continue;
                deepSortOrgIdNameMap.put(orgId, (String)orgIdNameMap.get(orgId));
            }
        }
        return deepSortOrgIdNameMap;
    }

    private void getDeepSortOrgIdList(Map<Long, List<Long>> childIdsMap, Long curOrgId, List<Long> deepSortOrgIdList) {
        deepSortOrgIdList.add(curOrgId);
        List<Long> childIds = childIdsMap.get(curOrgId);
        if (CollectionUtils.isEmpty(childIds)) {
            return;
        }
        for (Long childId : childIds) {
            this.getDeepSortOrgIdList(childIdsMap, childId, deepSortOrgIdList);
        }
    }

    public List<IKDCell> queryList_Analyse(QueryRequest request) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)request.getModelId());
        List<String> selectDims = CollectionUtils.isEmpty((Collection)request.getSelectDims()) ? Arrays.asList(modelCache.getDimensionNums(request.getDatasetId())) : request.getSelectDims();
        ArrayList datas = Lists.newArrayList();
        try (BgmdOlapReader reader = OlapManager.getInstance().queryReader(request);){
            while (reader.hasNext()) {
                Object[] row = reader.next();
                if (row[0] == null) continue;
                Object value = row[0];
                String[] memberArray = new String[row.length];
                for (int i = 0; i < selectDims.size(); ++i) {
                    memberArray[i] = row[i + 1].toString();
                }
                KDCell cell = new KDCell(KDCellMeta.of((String[])memberArray));
                cell.setValue(KDValue.valueOf((Object)value));
                datas.add(cell);
            }
        }
        return datas;
    }

    public Map<Integer, Map<String, BigDecimal>> getOlapDataForNoDetail(EntryTemplateConfig templateConfig, Map<Integer, Map<String, String>> noDetailMembers, Set<String> allAggColumnKeys) {
        if (noDetailMembers == null || noDetailMembers.isEmpty()) {
            return Maps.newHashMap();
        }
        HashMap<Integer, Map> allRowDimMembers = new HashMap<Integer, Map>(16);
        Map columnDimNumMap = templateConfig.selectColumnMapDimNum();
        List baseDataKeySeq = templateConfig.getDimKeysList();
        for (Map.Entry<Integer, Map<String, String>> entry : noDetailMembers.entrySet()) {
            Integer rowIndex2 = entry.getKey();
            Map<String, String> dimMemRow = entry.getValue();
            HashMap<String, String> rowMemMap = new HashMap<String, String>(16);
            for (String baseDataKey : baseDataKeySeq) {
                String dimNum = (String)columnDimNumMap.get(baseDataKey);
                String memNum = (String)dimMemRow.get(baseDataKey);
                rowMemMap.put(dimNum, memNum);
            }
            allRowDimMembers.put(rowIndex2, rowMemMap);
        }
        ArrayList<BaseColumn> measureCols = new ArrayList<BaseColumn>(16);
        List entryColumns = templateConfig.getEntryColumns();
        List columns = entryColumns.stream().filter(ee -> !ee.getKey().endsWith("_text")).collect(Collectors.toList());
        for (BaseColumn column : columns) {
            if (column.getType() != ColumnEnum.Measure && column.getType() != ColumnEnum.DimensionData && column.getType() != ColumnEnum.Cal) continue;
            measureCols.add(column);
        }
        Long modelId = templateConfig.getModelId();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Map<String, Map<String, String>> allColDimMembers = this.getAllColDimMembers(measureCols, templateConfig.getDatasetId(), modelCacheHelper, (Boolean)true);
        Map<String, String> hideDimMembers = this.getHideDimMembersFromTempConfig(modelCacheHelper, templateConfig);
        HashMap<String, Set<String>> dimMembers = new HashMap<String, Set<String>>(16);
        BgApplyBillUtils.getInstance().mergeMap(hideDimMembers, dimMembers);
        allRowDimMembers.values().forEach(e -> BgApplyBillUtils.getInstance().mergeMap((Map<String, String>)e, (Map<String, Set<String>>)dimMembers));
        allColDimMembers.values().forEach(e -> BgApplyBillUtils.getInstance().mergeMap((Map<String, String>)e, (Map<String, Set<String>>)dimMembers));
        HashMap<Integer, Map<String, BigDecimal>> rowAggColumnDataMap = new HashMap<Integer, Map<String, BigDecimal>>(16);
        for (Integer rowIndex3 : noDetailMembers.keySet()) {
            HashMap<String, BigDecimal> aggColumnDataMap = new HashMap<String, BigDecimal>(16);
            for (String aggColumnKey : allAggColumnKeys) {
                aggColumnDataMap.put(aggColumnKey, new BigDecimal(0));
            }
            rowAggColumnDataMap.put(rowIndex3, aggColumnDataMap);
        }
        List dimensionList = modelCacheHelper.getDimensionList(Long.valueOf(templateConfig.getDatasetId()));
        Map<MembersKey, Object> membersKeyObjectMap = BgApplyBillUtils.getInstance().queryOlapData(modelCacheHelper, modelId, templateConfig.getDatasetId(), dimMembers, true, templateConfig.getTemplateID());
        allRowDimMembers.forEach((rowIndex, rowDimMembNums) -> {
            HashMap dimGroup = new HashMap(hideDimMembers);
            dimGroup.putAll(rowDimMembNums);
            allColDimMembers.forEach((key, value) -> {
                HashMap<String, String> dimGroup_tmp = new HashMap<String, String>(dimGroup);
                dimGroup_tmp.putAll((Map<String, String>)value);
                MembersKey membersKey = BgApplyBillUtils.getInstance().getMembersKey(dimGroup_tmp, dimensionList);
                Object cellValue = membersKeyObjectMap.get(membersKey);
                BigDecimal olapValue = ConvertUtils.toDecimal(cellValue);
                Map dataMap = (Map)rowAggColumnDataMap.get(rowIndex);
                if (dataMap.containsKey(key) && olapValue != null) {
                    dataMap.put(key, olapValue);
                }
            });
        });
        return rowAggColumnDataMap;
    }

    public boolean isSameDimMap(Map<String, String> olapMemberMap, Map<String, String> rowMemberMap) {
        boolean isSame = true;
        for (Map.Entry<String, String> rowMemberEntry : rowMemberMap.entrySet()) {
            String rowDimNum = rowMemberEntry.getKey();
            String rowMemNum = rowMemberEntry.getValue();
            String dimMemNum = olapMemberMap.get(rowDimNum);
            if (!kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)dimMemNum) && dimMemNum.equals(rowMemNum)) continue;
            isSame = false;
            break;
        }
        return isSame;
    }

    public Map<String, Map<String, Long>> getBizPlanHiddenDimMemMap(ColumnList columnList, Long datasetId, IModelCacheHelper modelCacheHelper, Map<String, Map<String, String>> allDimVarSetting) {
        HashMap<String, Map<String, Long>> result = new HashMap<String, Map<String, Long>>(16);
        List bizTableConfigList = columnList.getBizTableConfigList();
        if (bizTableConfigList != null && !bizTableConfigList.isEmpty()) {
            Map dimViewMap = modelCacheHelper.getViewsByDataSet(datasetId);
            for (BizTableConfig bizTableConfig : bizTableConfigList) {
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                DimFlexInfo dimFlexInfo = bizTableConfig.getDimFlexInfo();
                if (dimFlexInfo != null) {
                    Map hidDimConfig = dimFlexInfo.getHidDimConfig();
                    String dimNum = "";
                    Collection values = hidDimConfig.values();
                    for (TempDimConfig dimMap : values) {
                        dimNum = dimMap.getDimensionNumber();
                        String memberId = dimMap.getMemberId();
                        String memberNum = dimMap.getMemberNumber();
                        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)memberId)) continue;
                        try {
                            kd.epm.eb.common.model.Pair memberInfo = new kd.epm.eb.common.model.Pair((Object)Long.parseLong(memberId), null);
                            if (allDimVarSetting != null && dimMap.isVar()) {
                                ApplyTemplateUtils.changeVar(modelCacheHelper, memberNum, allDimVarSetting, (Long)dimViewMap.get(dimNum), dimNum, member -> memberInfo.setKey((Object)member.getId()));
                            }
                            map.put(dimNum, memberInfo.getKey());
                        }
                        catch (NumberFormatException e) {
                            log.error((Throwable)e);
                            throw new KDBizException(ResManager.loadResFormat((String)"\u9690\u85cf\u7ef4\u5ea6\u6210\u5458id\u53c2\u6570\u4e0d\u5408\u6cd5\uff1a%1 id: %2", (String)"BgApplyBillUtils_0", (String)"epm-eb-business", (Object[])new Object[]{dimNum, memberId}));
                        }
                    }
                }
                result.put(bizTableConfig.getTabKey(), map);
            }
        }
        return result;
    }

    public Map<String, Map<String, String>> getBizHideDimMembersFromTempConfig(IModelCacheHelper modelCacheHelper, EntryTemplateConfig templateConfig) {
        HashMap<String, Map<String, String>> memberMap = new HashMap<String, Map<String, String>>(16);
        log.info("getHideDimMembersFromTempConfig\uff1agetBizPlanHiddenDimMemMap=", (Object)SerializationUtils.toJsonString((Object)templateConfig.getBizPlanHiddenDimMemMap()));
        Map dimViewMap = modelCacheHelper.getViewsByDataSet(Long.valueOf(templateConfig.getDatasetId()));
        for (Map.Entry entry : templateConfig.getBizPlanHiddenDimMemMap().entrySet()) {
            String key = (String)entry.getKey();
            Map value = (Map)entry.getValue();
            Map stringStringMap = memberMap.computeIfAbsent(key, s -> new HashMap(16));
            for (Map.Entry stringLongEntry : value.entrySet()) {
                Member member = modelCacheHelper.getMember((String)stringLongEntry.getKey(), (Long)dimViewMap.get(stringLongEntry.getKey()), (Long)stringLongEntry.getValue());
                if (member == null) continue;
                stringStringMap.put(stringLongEntry.getKey(), member.getNumber());
            }
        }
        return memberMap;
    }

    public Map<Integer, Map<String, Object>> updateBizPlanMeasureValue(IModelCacheHelper modelCacheHelper, String planTabKeyValue, EntryTemplateConfig templateConfig, IDataModel dataModel, Set<Integer> rowIndexes, BigDecimal unitData) {
        HashMap<Integer, Map<String, Object>> olapData = new HashMap<Integer, Map<String, Object>>(16);
        if (templateConfig == null || dataModel == null || rowIndexes == null || rowIndexes.isEmpty() || kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)planTabKeyValue)) {
            return olapData;
        }
        Long modelId = null;
        if (modelCacheHelper != null) {
            modelId = modelCacheHelper.getModelobj().getId();
        } else {
            DynamicObject model = (DynamicObject)dataModel.getValue("model");
            if (model != null) {
                modelId = model.getLong("id");
                modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
            }
        }
        if (modelId == null) {
            return olapData;
        }
        LinkedList<BaseColumn> pullFromModelColumns = new LinkedList<BaseColumn>();
        LinkedList<BaseColumn> disColumns = new LinkedList<BaseColumn>();
        for (BaseColumn column : templateConfig.getEntryColumns()) {
            if (!planTabKeyValue.equals(column.getBizPlanTabKey())) continue;
            if (column.getType() == ColumnEnum.Dimension || column.getType() == ColumnEnum.RelationDimension || column.getType() == ColumnEnum.RowDimension) {
                disColumns.add(column);
                continue;
            }
            if (column.getType() != ColumnEnum.Measure && column.getType() != ColumnEnum.DimensionData) continue;
            pullFromModelColumns.add(column);
        }
        HashMap<MembersKey, List> membersKeytoModelsKey = new HashMap<MembersKey, List>(16);
        Map<String, Map<String, String>> bizHideDimMembersFromTempConfig = this.getBizHideDimMembersFromTempConfig(modelCacheHelper, templateConfig);
        Map<String, String> hideDimMems = bizHideDimMembersFromTempConfig.get(planTabKeyValue);
        Map dimViewMap = modelCacheHelper.getViewsByDataSet(Long.valueOf(templateConfig.getDatasetId()));
        HashMap<String, Set<String>> dimMemsForQuery = new HashMap<String, Set<String>>(16);
        this.mergeMap(hideDimMems, dimMemsForQuery);
        for (Integer rowIndex : rowIndexes) {
            if (rowIndex == null) continue;
            Map<String, String> rowDimMems = this.getRowDimMems(modelCacheHelper, dataModel, disColumns, rowIndex);
            for (BaseColumn column : pullFromModelColumns) {
                HashMap<String, String> dimMemsForKey = new HashMap<String, String>(hideDimMems);
                Map<String, String> colDimMems = this.getDimMembersFromMeasureColumn(modelCacheHelper, dimViewMap, column, true);
                dimMemsForKey.putAll(rowDimMems);
                dimMemsForKey.putAll(colDimMems);
                List dimensionList = modelCacheHelper.getDimensionList(Long.valueOf(templateConfig.getDatasetId()));
                Map<String, String> noneDimMembers = this.getDefaultAddDimMembers(dimensionList, hideDimMems, colDimMems, rowDimMems);
                dimMemsForKey.putAll(noneDimMembers);
                MembersKey membersKey = this.getMembersKey(dimMemsForKey, dimensionList);
                List keys = membersKeytoModelsKey.computeIfAbsent(membersKey, k -> new ArrayList(16));
                keys.add(column.getKey() + "###" + rowIndex);
                this.mergeMap(colDimMems, dimMemsForQuery);
                this.mergeMap(noneDimMembers, dimMemsForQuery);
            }
            this.mergeMap(rowDimMems, dimMemsForQuery);
        }
        log.info("pullFromModel query:" + dimMemsForQuery);
        Map<MembersKey, Object> datas = this.queryOlapData(modelCacheHelper, modelId, templateConfig.getDatasetId(), dimMemsForQuery, true, templateConfig.getTemplateID());
        log.info("pullFromModel datas:" + datas);
        Set currencyCols = templateConfig.getCurrencyColumnKeys();
        for (Map.Entry entry : membersKeytoModelsKey.entrySet()) {
            List keys = (List)entry.getValue();
            MembersKey membersKey = (MembersKey)entry.getKey();
            keys.forEach(e -> {
                String[] colAndRow = e.split("###");
                Object data = datas.get(membersKey);
                if (colAndRow.length == 2) {
                    int index = Integer.parseInt(colAndRow[1]);
                    if (!(data instanceof BigDecimal) || currencyCols == null || !currencyCols.contains(colAndRow[0]) || unitData != null) {
                        // empty if block
                    }
                    Map rowVals = olapData.computeIfAbsent(index, key -> new HashMap(16));
                    rowVals.put(colAndRow[0], data);
                    dataModel.setValue(colAndRow[0], data, index);
                }
            });
        }
        return olapData;
    }

    public static void replaceSubtotalOlap(EntryTemplateConfig entryConfig, DynamicObjectCollection entityData, BigDecimal unitData) {
        ArrayList<BaseColumn> measureCols = new ArrayList<BaseColumn>(16);
        ArrayList<BaseColumn> dimensionCols = new ArrayList<BaseColumn>(16);
        Long modelId = entryConfig.getModelId();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Map dimViewMap = modelCacheHelper.getViewsByDataSet(Long.valueOf(entryConfig.getDatasetId()));
        List entryColumns = entryConfig.getEntryColumns();
        List columns = entryColumns.stream().filter(ee -> !ee.getKey().endsWith("_text")).collect(Collectors.toList());
        for (BaseColumn column : columns) {
            if (column.getType() == ColumnEnum.Dimension || column.getType() == ColumnEnum.RelationDimension || column.getType() == ColumnEnum.RowDimension) {
                dimensionCols.add(column);
                continue;
            }
            if (column.getType() != ColumnEnum.Measure && column.getType() != ColumnEnum.DimensionData) continue;
            measureCols.add(column);
        }
        Map<String, Map<String, String>> allColDimMembers = BgApplyBillUtils.getInstance().getAllColDimMembers(measureCols, entryConfig.getDatasetId(), modelCacheHelper, (Boolean)true);
        HashMap<String, String> rowDimColumn = new HashMap<String, String>(16);
        dimensionCols.forEach(e -> rowDimColumn.put(BgApplyBillUtils.getInstance().getDimOrRelateDimNumber((BaseColumn)e, modelCacheHelper), e.getKey()));
        HashMap<Integer, Map> allRowDimMembers = new HashMap<Integer, Map>(16);
        String subtotalstatuskey = entryConfig.getSubtotalKey();
        for (int i = 0; i < entityData.size(); ++i) {
            DynamicObject data = (DynamicObject)entityData.get(i);
            boolean subtotalstatus = data.getBoolean(subtotalstatuskey);
            boolean ismatch = true;
            for (BaseColumn dimensionCol : dimensionCols) {
                Object value2 = data.get(dimensionCol.getKey());
                if (value2 != null) continue;
                ismatch = false;
                break;
            }
            if (!subtotalstatus || !ismatch) continue;
            HashMap rowMemMap = new HashMap(16);
            rowDimColumn.forEach((key, value) -> {
                Member member;
                Object memberId = data.get(value);
                if (memberId instanceof DynamicObject && (member = modelCacheHelper.getMember(key, (Long)dimViewMap.get(key), Long.valueOf(((DynamicObject)memberId).getLong("id")))) != null) {
                    rowMemMap.put(key, member.getNumber());
                }
            });
            allRowDimMembers.put(i, rowMemMap);
        }
        Map<String, String> hideDimMembers = BgApplyBillUtils.getInstance().getHideDimMembersFromTempConfig(modelCacheHelper, entryConfig);
        HashMap<String, Set<String>> dimGroups = new HashMap<String, Set<String>>(16);
        BgApplyBillUtils.getInstance().mergeMap(hideDimMembers, dimGroups);
        allRowDimMembers.values().forEach(e -> BgApplyBillUtils.getInstance().mergeMap((Map<String, String>)e, (Map<String, Set<String>>)dimGroups));
        allColDimMembers.values().forEach(e -> BgApplyBillUtils.getInstance().mergeMap((Map<String, String>)e, (Map<String, Set<String>>)dimGroups));
        List dimensionList = modelCacheHelper.getDimensionList(Long.valueOf(entryConfig.getDatasetId()));
        if (allColDimMembers.size() == 0 || allRowDimMembers.size() == 0) {
            return;
        }
        Map<String, String> defaultMembers = BgApplyBillUtils.getInstance().getDefaultAddDimMembers(dimensionList, hideDimMembers, allColDimMembers.values().iterator().next(), (Map)allRowDimMembers.values().iterator().next());
        BgApplyBillUtils.getInstance().mergeMap(defaultMembers, dimGroups);
        Map<MembersKey, Object> membersKeyObjectMap = BgApplyBillUtils.getInstance().queryOlapData(modelCacheHelper, modelId, entryConfig.getDatasetId(), dimGroups, true, entryConfig.getTemplateID());
        Map columnMap = entryConfig.selectColumnMap();
        allRowDimMembers.forEach((rowIndex, rowDimMembNums) -> {
            DynamicObject data = (DynamicObject)entityData.get(rowIndex.intValue());
            HashMap dimGroup = new HashMap(hideDimMembers);
            dimGroup.putAll(rowDimMembNums);
            allColDimMembers.forEach((key, value) -> {
                HashMap<String, String> dimGroup_tmp = new HashMap<String, String>(dimGroup);
                dimGroup_tmp.putAll((Map<String, String>)value);
                dimGroup_tmp.putAll(defaultMembers);
                MembersKey membersKey = BgApplyBillUtils.getInstance().getMembersKey(dimGroup_tmp, dimensionList);
                Object cellValue = membersKeyObjectMap.get(membersKey);
                if (cellValue == null) {
                    BaseColumn column = (BaseColumn)columnMap.get(key);
                    cellValue = BgApplyBillUtils.setDefaultData(cellValue, column);
                }
                if (cellValue instanceof BigDecimal) {
                    cellValue = ((BigDecimal)cellValue).divide(unitData);
                }
                data.set(key, cellValue);
            });
        });
    }

    private static Object setDefaultData(Object val, BaseColumn column) {
        FieldTypeEnum fieldtype;
        if (val == null && (fieldtype = column.getFieldtype()) != null) {
            switch (fieldtype) {
                case IntField: {
                    val = 0;
                    break;
                }
                case NumberField: {
                    val = BigDecimal.ZERO.setScale(2);
                    break;
                }
                case TextField: 
                case LongText: {
                    val = "";
                    break;
                }
                case BaseDataField: {
                    val = 0L;
                    break;
                }
                case Boolean: {
                    val = Boolean.FALSE;
                }
            }
        }
        return val;
    }

    public static DynamicObjectCollection getSubtotalEntrys(EntryTemplateConfig maincfg, IModelCacheHelper modelCacheHelper, DynamicObjectCollection nentrys, List<String> groupKeys, boolean isalldata) {
        Map columnMapDimNum = maincfg.selectColumnMapDimNum();
        Set sumkeys = maincfg.getSummaryDisplayKeys();
        DynamicObjectCollection subtotalEntrys = new DynamicObjectCollection(nentrys.getDynamicObjectType(), nentrys.getParent());
        DynamicObjectCollection notmatchEntrys = new DynamicObjectCollection(nentrys.getDynamicObjectType(), nentrys.getParent());
        List dimKeysList = maincfg.getDimKeysList();
        Map columnMap = maincfg.selectColumnMap();
        ApplyTemplateSubTotal applyTemplateSubTotal = maincfg.getApplyTemplateSubTotal();
        if (!applyTemplateSubTotal.isShowSubTotal() || applyTemplateSubTotal.getSubTotalConfigs().isEmpty()) {
            if (isalldata) {
                subtotalEntrys.addAll((Collection)nentrys);
            }
            return subtotalEntrys;
        }
        Map dimViewMap = modelCacheHelper.getViewsByDataSet(Long.valueOf(maincfg.getDatasetId()));
        List subTotalConfigs = applyTemplateSubTotal.getSubTotalConfigs();
        HashMap subtotalMap = new HashMap(16);
        HashMap<String, Object> sourceSubtotalMap = new HashMap<String, Object>(16);
        for (SubTotalConfig subTotalConfig : subTotalConfigs) {
            Set memberIds = subTotalConfig.getMemberIds();
            String dimNumber = subTotalConfig.getDimNumber();
            sourceSubtotalMap.put(dimNumber, memberIds);
            memberIds.forEach(s -> {
                List allMembers;
                Set ids;
                Member member = modelCacheHelper.getMember(dimNumber, (Long)dimViewMap.get(dimNumber), s);
                if (member != null && (ids = (allMembers = member.getAllMembers()).stream().map(x -> x.getId()).collect(Collectors.toSet())) != null) {
                    Set idArray = subtotalMap.computeIfAbsent(dimNumber, x -> new HashSet(16));
                    idArray.addAll(ids);
                }
            });
        }
        Set dimNumbers = subtotalMap.keySet();
        ArrayList<Object> matchFields = new ArrayList<Object>(16);
        for (Object s2 : dimKeysList) {
            String dimNumber = (String)columnMapDimNum.get(s2);
            if (!dimNumbers.contains(dimNumber)) {
                groupKeys.add((String)s2);
                continue;
            }
            matchFields.add(s2);
        }
        ArrayList<DynamicObject> entrys = new ArrayList<DynamicObject>(16);
        for (DynamicObject nentry : nentrys) {
            boolean ismatch = true;
            for (String string : matchFields) {
                String dimNumber = (String)columnMapDimNum.get(string);
                if (dimNumber == null) continue;
                Set memberIds = (Set)subtotalMap.get(dimNumber);
                DynamicObject data = nentry.getDynamicObject(string);
                if (data != null && memberIds.contains(data.getLong("id"))) continue;
                ismatch = false;
                break;
            }
            if (ismatch) {
                entrys.add(nentry);
                continue;
            }
            if (!isalldata) continue;
            notmatchEntrys.add((Object)nentry);
        }
        Map<String, List<DynamicObject>> groupdatas = entrys.stream().collect(Collectors.groupingBy(s -> BgApplyBillUtils.getSubTotalGroupStr(groupKeys, s)));
        if (groupdatas.isEmpty() && isalldata) {
            subtotalEntrys.addAll((Collection)notmatchEntrys);
            return subtotalEntrys;
        }
        String subtotalstatuskey = maincfg.getSubtotalKey();
        for (Map.Entry<String, List<DynamicObject>> group : groupdatas.entrySet()) {
            String string = group.getKey();
            List<DynamicObject> value = group.getValue();
            HashMap<String, List> groupvalueMap = new HashMap<String, List>(16);
            HashMap<String, String> memberIdMapName = new HashMap<String, String>(16);
            for (DynamicObject dynamicObject : value) {
                String str = "";
                ArrayList arrs = new ArrayList(16);
                for (String string2 : matchFields) {
                    long l = dynamicObject.getLong(string2 + ".id");
                    String dimNumber = (String)columnMapDimNum.get(string2);
                    Member member = modelCacheHelper.getMember(dimNumber, (Long)dimViewMap.get(dimNumber), Long.valueOf(l));
                    Long mvv = 0L;
                    if (member == null) continue;
                    List parentOrgList = modelCacheHelper.getParents((Long)dimViewMap.get(dimNumber), member, false);
                    Set memberIds = (Set)sourceSubtotalMap.get(dimNumber);
                    for (Member member1 : parentOrgList) {
                        if (!memberIds.contains(member1.getId())) continue;
                        mvv = member1.getId();
                        memberIdMapName.put(mvv.toString(), member1.getName());
                        break;
                    }
                    arrs.add(string2 + ":" + mvv);
                }
                str = String.join((CharSequence)"!", arrs);
                List gdatas = groupvalueMap.computeIfAbsent(str, x -> new ArrayList(16));
                gdatas.add(dynamicObject);
            }
            for (Map.Entry entry : groupvalueMap.entrySet()) {
                if (isalldata) {
                    List detailDatas = (List)entry.getValue();
                    subtotalEntrys.addAll((Collection)detailDatas);
                }
                DynamicObject addrow = subtotalEntrys.addNew();
                for (String groupKey : groupKeys) {
                    addrow.set(groupKey, value.get(0).get(groupKey));
                }
                String[] ss = ((String)entry.getKey()).split("!");
                for (String string3 : matchFields) {
                    Optional<String> optional = Arrays.stream(ss).filter(x -> x.contains(matchfield)).findFirst();
                    if (!optional.isPresent()) continue;
                    String membeId = optional.get().split(":")[1];
                    String memberName = (String)memberIdMapName.get(membeId);
                    BaseColumn baseColumn = (BaseColumn)columnMap.get(string3);
                    DynamicObject data = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(membeId), (String)baseColumn.getBaseEntityId());
                    addrow.set(string3, (Object)data);
                }
                if (!sumkeys.isEmpty()) {
                    HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>(16);
                    for (DynamicObject dynamicObject : (List)entry.getValue()) {
                        for (String sumkey : sumkeys) {
                            BaseColumn column = (BaseColumn)columnMap.get(sumkey);
                            if (column instanceof DateColumn) continue;
                            BigDecimal vv = map.computeIfAbsent(sumkey, x -> BigDecimal.ZERO);
                            BigDecimal data = ConvertUtils.toDecimal((Object)dynamicObject.get(sumkey));
                            if (data == null) {
                                data = BigDecimal.ZERO;
                            }
                            vv = vv.add(data);
                            map.put(sumkey, vv);
                        }
                    }
                    for (Map.Entry entry2 : map.entrySet()) {
                        String key1 = (String)entry2.getKey();
                        BigDecimal value1 = (BigDecimal)entry2.getValue();
                        addrow.set(key1, (Object)value1);
                    }
                }
                addrow.set(subtotalstatuskey, (Object)true);
                long rowId = GlobalIdUtil.genGlobalLongId();
                addrow.set("id", (Object)rowId);
            }
        }
        subtotalEntrys.addAll((Collection)notmatchEntrys);
        return subtotalEntrys;
    }

    public static List<Map<String, String>> getSubtotalRowDims(EntryTemplateConfig maincfg, IModelCacheHelper modelCacheHelper, List<Map<String, String>> sourceDatas) {
        Map columnMapDimNum = maincfg.selectColumnMapDimNum();
        ArrayList<Map<String, String>> subtotalEntrys = new ArrayList<Map<String, String>>(16);
        List dimKeysList = maincfg.getDimKeysList();
        ApplyTemplateSubTotal applyTemplateSubTotal = maincfg.getApplyTemplateSubTotal();
        if (!applyTemplateSubTotal.isShowSubTotal() || applyTemplateSubTotal.getSubTotalConfigs().isEmpty()) {
            return subtotalEntrys;
        }
        Map dimViewMap = modelCacheHelper.getViewsByDataSet(Long.valueOf(maincfg.getDatasetId()));
        List subTotalConfigs = applyTemplateSubTotal.getSubTotalConfigs();
        HashMap subtotalMap = new HashMap(16);
        HashMap sourceSubtotalMap = new HashMap(16);
        for (SubTotalConfig subTotalConfig : subTotalConfigs) {
            Set memberIds = subTotalConfig.getMemberIds();
            String dimNumber = subTotalConfig.getDimNumber();
            HashSet numbers = new HashSet(16);
            sourceSubtotalMap.put(dimNumber, numbers);
            memberIds.forEach(s -> {
                Member member = modelCacheHelper.getMember(dimNumber, (Long)dimViewMap.get(dimNumber), s);
                if (member != null) {
                    numbers.add(member.getNumber());
                    List allMembers = member.getAllMembers();
                    Set memberNumbers = allMembers.stream().map(x -> x.getNumber()).collect(Collectors.toSet());
                    if (memberNumbers != null) {
                        subtotalMap.put(dimNumber, memberNumbers);
                        Set idArray = subtotalMap.computeIfAbsent(dimNumber, x -> new HashSet(16));
                        idArray.addAll(memberNumbers);
                    }
                }
            });
        }
        Set dimNumbers = subtotalMap.keySet();
        ArrayList<Object> matchFields = new ArrayList<Object>(16);
        ArrayList<String> groupDims = new ArrayList<String>(16);
        for (Object s2 : dimKeysList) {
            String string = (String)columnMapDimNum.get(s2);
            if (!dimNumbers.contains(string)) {
                groupDims.add(string);
                continue;
            }
            matchFields.add(s2);
        }
        ArrayList<Map> entrys = new ArrayList<Map>(16);
        for (Map map : sourceDatas) {
            boolean ismatch = true;
            for (String string : matchFields) {
                String dimNumber = (String)columnMapDimNum.get(string);
                if (dimNumber == null) continue;
                Set set = (Set)subtotalMap.get(dimNumber);
                String data = (String)map.get(dimNumber);
                if (data != null && set.contains(data)) continue;
                ismatch = false;
                break;
            }
            if (!ismatch) continue;
            entrys.add(map);
        }
        Map<String, List<Map>> groupdatas = entrys.stream().collect(Collectors.groupingBy(s -> BgApplyBillUtils.getSubTotalGroupStr((List<String>)groupDims, s)));
        if (groupdatas.isEmpty()) {
            return subtotalEntrys;
        }
        for (Map.Entry<String, List<Map>> group : groupdatas.entrySet()) {
            List<Map> value = group.getValue();
            HashMap<String, List> hashMap = new HashMap<String, List>(16);
            for (Map map : value) {
                String str = "";
                ArrayList arrs = new ArrayList(16);
                for (String string : matchFields) {
                    String dimNumber = (String)columnMapDimNum.get(string);
                    String mv = (String)map.get(dimNumber);
                    Member member = modelCacheHelper.getMember(dimNumber, (Long)dimViewMap.get(dimNumber), mv);
                    String mvv = "";
                    if (member == null) continue;
                    List parentOrgList = modelCacheHelper.getParents((Long)dimViewMap.get(dimNumber), member, false);
                    Set memberNumbers = (Set)sourceSubtotalMap.get(dimNumber);
                    for (Member member1 : parentOrgList) {
                        if (!memberNumbers.contains(member1.getNumber())) continue;
                        mvv = member1.getNumber();
                        break;
                    }
                    arrs.add(string + ":" + mvv);
                }
                str = String.join((CharSequence)"!", arrs);
                List gdatas = hashMap.computeIfAbsent(str, x -> new ArrayList(16));
                gdatas.add(map);
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                HashMap addrow = new HashMap(16);
                for (String groupKey : groupDims) {
                    addrow.put(groupKey, value.get(0).get(groupKey));
                }
                String[] ss = ((String)entry.getKey()).split("!");
                for (String string : matchFields) {
                    Optional<String> matchV = Arrays.stream(ss).filter(x -> x.contains(matchfield)).findFirst();
                    if (!matchV.isPresent()) continue;
                    String membeNumber = matchV.get().split(":")[1];
                    String dimNumber = (String)columnMapDimNum.get(string);
                    addrow.put(dimNumber, membeNumber);
                }
                subtotalEntrys.add(addrow);
            }
        }
        return subtotalEntrys;
    }

    public static String getSubTotalGroupStr(List<String> groupKeys, DynamicObject s) {
        StringBuilder groubstr = new StringBuilder();
        for (String groupKey : groupKeys) {
            groubstr.append(s.getString(groupKey + ".number")).append("_");
        }
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)groubstr)) {
            groubstr.substring(0, groubstr.length() - 1);
        }
        return groubstr.toString();
    }

    public static String getSubTotalGroupStr(List<String> groupDims, Map<String, String> s) {
        StringBuilder groubstr = new StringBuilder();
        for (String group : groupDims) {
            groubstr.append(s.get(group)).append("_");
        }
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)groubstr)) {
            groubstr.substring(0, groubstr.length() - 1);
        }
        return groubstr.toString();
    }

    public static List<OlapDataEntry> getDeleteSubtotalOlapByTemplateData(EntryTemplateConfig templateConfig, List<SimpleDynamicObject> billData, IModelCacheHelper modelCacheHelper, List<String> enableEditCols) {
        ArrayList<OlapDataEntry> result = new ArrayList<OlapDataEntry>(16);
        BgApplyBillUtils instance = BgApplyBillUtils.getInstance();
        Map<String, String> refDimKeyMap = instance.getDimColumnNumbers(templateConfig, modelCacheHelper);
        Set<String> notaggkeys = ApplyTemplateUtils.notAggMetricColumn(templateConfig.getEntryColumns(), templateConfig.getModelId());
        if (notaggkeys.isEmpty()) {
            return result;
        }
        ArrayList<BaseColumn> measureColumns = new ArrayList<BaseColumn>(16);
        ArrayList<String> pullFromModelCols = new ArrayList<String>(16);
        for (BaseColumn entryColumn : templateConfig.getEntryColumns()) {
            if (!notaggkeys.contains(entryColumn.getKey())) continue;
            if (ColumnEnum.Cal == entryColumn.getType()) {
                measureColumns.add(entryColumn);
                continue;
            }
            if (ColumnEnum.Measure != entryColumn.getType() && ColumnEnum.DimensionData != entryColumn.getType()) continue;
            measureColumns.add(entryColumn);
            if (!entryColumn.getIspullfrommodel()) continue;
            pullFromModelCols.add(entryColumn.getKey());
        }
        Map<String, Map<String, String>> colDimMembers = instance.getAllColDimMembers(measureColumns, templateConfig.getDatasetId(), modelCacheHelper, (Boolean)true);
        Map<String, String> hideDimMembers = instance.getHideDimMembersFromTempConfig(modelCacheHelper, templateConfig);
        ArrayList deleteDimGroups = new ArrayList(16);
        if (billData != null) {
            for (int i = 0; i < billData.size(); ++i) {
                HashMap dimMember = new HashMap(16);
                SimpleDynamicObject rowEntry = billData.get(i);
                refDimKeyMap.forEach((key, value) -> {
                    Map dimmap;
                    Object dimDyn = rowEntry.getValue(key);
                    if (dimDyn instanceof Map && (dimmap = (Map)dimDyn) != null) {
                        dimMember.put(value, (String)dimmap.get("number"));
                    }
                });
                deleteDimGroups.add(dimMember);
            }
        }
        if (deleteDimGroups.size() == 0) {
            return result;
        }
        List dimensionList = modelCacheHelper.getDimensionList(Long.valueOf(templateConfig.getDatasetId()));
        Map<String, String> afterAddDimMembers = instance.getDefaultAddDimMembers(dimensionList, hideDimMembers, colDimMembers.values().iterator().next(), (Map)deleteDimGroups.get(0));
        for (Map map : deleteDimGroups) {
            colDimMembers.forEach((key, value) -> {
                if (enableEditCols.contains(key) && !pullFromModelCols.contains(key)) {
                    OlapDataEntry olapDataEntry = new OlapDataEntry();
                    HashMap dimGroup = new HashMap(hideDimMembers);
                    dimGroup.putAll(deleteDimGroup);
                    dimGroup.putAll(value);
                    dimGroup.putAll(afterAddDimMembers);
                    olapDataEntry.setDimMemMap(dimGroup);
                    olapDataEntry.setValue(null);
                    result.add(olapDataEntry);
                }
            });
        }
        return result;
    }
}

