/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.applybill.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.applybill.ApplyBillType;
import kd.epm.eb.common.applybill.DecpStepManager;
import kd.epm.eb.common.applybill.SplitRowData;
import kd.epm.eb.common.applybill.SplitStatus;
import kd.epm.eb.common.applybill.SplitedDataInfo;
import kd.epm.eb.common.centralapproval.ApproveBill;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.NumberCheckUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.SqlBatchUtils;
import kd.epm.eb.common.utils.UserUtils;

public class BgApplySplitUtil {
    private static final BgApplySplitUtil instance = new BgApplySplitUtil();

    public static BgApplySplitUtil getInstance() {
        return instance;
    }

    public String serialDecpStepData(DecpStepManager data) {
        return null;
    }

    public DecpStepManager deSerialDecpStepData(String dataStr) {
        return null;
    }

    public DecpStepManager getStepDatasBySchemeId(Long decpSchemeId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)decpSchemeId, (String)"eb_decomposescheme");
        DecpStepManager decpStepManager = this.getStepDatasBySchemeObj(dynamicObject);
        return decpStepManager;
    }

    public DynamicObject getSplitBillObjByNumber(String billNumber) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(1);
        filterList.add(new QFilter("billnumber", "=", (Object)billNumber));
        String selFields = "year,moneyunit,org,splitorg,remark,decomposescheme,decpstep,decppath,decpdata,isfirststep,sourcebillid,bgapplyscheme,billnumber,splitstatus,creater,createdate,modifier,modifydate,prebillid";
        DynamicObject rowDy = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_bgdecompose", (String)selFields, (QFilter[])filterList.toArray(new QFilter[filterList.size()]));
        return rowDy;
    }

    public DynamicObject createBgDecomposeBillNew(String billNumber, String stepNumber, Long deSchemeId, Long bgOrgId, Long decomposeOrgId, List<Long> decomposeUsersId, ApproveBill appBillDy, DynamicObject bgApplyScheme, boolean isFisrtStep, String splitPath) {
        DynamicObject bgDecomposeDy = null;
        bgDecomposeDy = BusinessDataServiceHelper.newDynamicObject((String)"eb_bgdecompose");
        bgDecomposeDy.set("year_id", (Object)appBillDy.getYear());
        bgDecomposeDy.set("org_id", (Object)bgOrgId);
        bgDecomposeDy.set("splitorg_id", (Object)decomposeOrgId);
        DynamicObjectCollection decomposepersons = bgDecomposeDy.getDynamicObjectCollection("mudecomposeperson");
        decomposeUsersId.forEach(userId -> {
            DynamicObject userObj = decomposepersons.addNew();
            userObj.set("fbasedataid", userId);
        });
        bgDecomposeDy.set("mudecomposeperson", (Object)decomposepersons);
        bgDecomposeDy.set("decomposescheme_id", (Object)deSchemeId);
        bgDecomposeDy.set("remark", (Object)"");
        bgDecomposeDy.set("decpstep", (Object)stepNumber);
        bgDecomposeDy.set("isfirststep", (Object)isFisrtStep);
        bgDecomposeDy.set("model_id", (Object)appBillDy.getModel());
        bgDecomposeDy.set("sourcebillid", (Object)appBillDy.getId());
        bgDecomposeDy.set("billtype", (Object)ApplyBillType.SPLIT.getNumber());
        bgDecomposeDy.set("version_id", (Object)appBillDy.getVersion());
        bgDecomposeDy.set("datatype_id", (Object)appBillDy.getDatatype());
        if (bgApplyScheme != null) {
            bgDecomposeDy.set("bgapplyscheme", (Object)bgApplyScheme);
        }
        Date now = TimeServiceHelper.now();
        bgDecomposeDy.set("splitstatus", (Object)SplitStatus.NOTSPLIT.getValue());
        bgDecomposeDy.set("creater", (Object)UserUtils.getUserId());
        bgDecomposeDy.set("createdate", (Object)now);
        bgDecomposeDy.set("modifier", (Object)UserUtils.getUserId());
        bgDecomposeDy.set("modifydate", (Object)now);
        if (billNumber == null) {
            billNumber = this.getCodeRuleNum("eb_bgdecompose", bgDecomposeDy);
        }
        bgDecomposeDy.set("decppath", (Object)(splitPath + billNumber));
        bgDecomposeDy.set("billnumber", (Object)billNumber);
        return bgDecomposeDy;
    }

    public String getCodeRuleNum(String formId, DynamicObject dy) {
        return CodeRuleServiceHelper.getNumber((String)formId, (DynamicObject)dy, null);
    }

    public DecpStepManager getStepDatasBySchemeObj(DynamicObject schemeObj) {
        String rowdata = schemeObj.getString("rowsdata");
        DecpStepManager decpStepManager = (DecpStepManager)SerializationUtils.fromJsonString((String)rowdata, DecpStepManager.class);
        return decpStepManager;
    }

    public void saveBillEditInfo(Long billId, SplitStatus splitStatus) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"eb_bgdecompose");
        dynamicObject.set("modifier", (Object)UserUtils.getUserId());
        dynamicObject.set("modifydate", (Object)new Timestamp(TimeServiceHelper.now().getTime()));
        dynamicObject.set("splitstatus", (Object)splitStatus.getValue());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    private SplitRowData copySplitedRowData(SplitRowData rowData) {
        SplitRowData newRowData = new SplitRowData();
        newRowData.setCurrentSplitDim(rowData.getCurrentSplitDim());
        newRowData.setCurrentFocusSplitDim(rowData.getCurrentSplitDim());
        newRowData.setSubData(rowData.getSubData());
        newRowData.setNotDetailDimColumn(rowData.getNotDetailDimColumn());
        newRowData.setFinishSplit(rowData.isFinishSplit());
        newRowData.setSplitedData(rowData.getSplitedData());
        return newRowData;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<Long, Map<String, Map<Long, SplitRowData>>> querySplitedRowDatas(List<Long> splitBillIds, Map<Long, String> tempIdMapEntryKey) {
        Long rowId;
        Long splitBillId;
        String entryKey;
        HashMap<Long, Map<String, Map<Long, SplitRowData>>> result = new HashMap<Long, Map<String, Map<Long, SplitRowData>>>(16);
        String querySql = "select fid,fsplitbillid,ftemplateid,fsplitdimpart,fsplitrowid from t_eb_splitedrowdata  where fsplitbillid in(" + SqlBatchUtils.getBatchParamsSql((int)splitBillIds.size()) + ")";
        HashMap<Long, SplitBillRowMap> fidMapRow = new HashMap<Long, SplitBillRowMap>(16);
        try (DataSet dataSet = DB.queryDataSet((String)"querySplitedRowDatas", (DBRoute)new DBRoute("epm"), (String)querySql, (Object[])splitBillIds.toArray());){
            for (Row row : dataSet) {
                Long tempId = row.getLong("ftemplateid");
                entryKey = tempIdMapEntryKey.get(tempId);
                splitBillId = row.getLong("fsplitbillid");
                Map allSplitRecord = result.computeIfAbsent(splitBillId, key -> new HashMap(16));
                if (entryKey == null) continue;
                Map splitRowDataMap = allSplitRecord.computeIfAbsent(entryKey, key -> new HashMap(16));
                rowId = row.getLong("fsplitrowid");
                String splitDimPart = row.getString("fsplitdimpart");
                SplitRowData splitRowData = (SplitRowData)SerializationUtils.fromJsonString((String)splitDimPart, SplitRowData.class);
                splitRowDataMap.put(rowId, splitRowData);
                fidMapRow.put(row.getLong("fid"), new SplitBillRowMap(rowId, splitBillId, entryKey));
            }
        }
        if (fidMapRow.size() <= 0) return result;
        querySql = "select fid,fsplitdimcol,fmodifiedrows from t_eb_spliteddimrowdata  where fid in(" + SqlBatchUtils.getBatchParamsSql((int)fidMapRow.size()) + ")";
        dataSet = DB.queryDataSet((String)"querySplitedDimRowDatas", (DBRoute)new DBRoute("epm"), (String)querySql, (Object[])fidMapRow.keySet().toArray());
        var12_7 = null;
        try {
            for (Row row : dataSet) {
                Long fid = row.getLong("fid");
                SplitBillRowMap entryMapRowId = (SplitBillRowMap)fidMapRow.get(fid);
                rowId = entryMapRowId.getRowId();
                entryKey = entryMapRowId.getEntryKey();
                splitBillId = entryMapRowId.getBillId();
                SplitRowData rowData = (SplitRowData)((Map)((Map)result.get(splitBillId)).get(entryKey)).get(rowId);
                String spiltDimCol = row.getString("fsplitdimcol");
                String modifiedRows = row.getString("fmodifiedrows");
                ObjectMapper objectMapper = SerializationUtils.getObjectMapper2();
                try {
                    Map splitedDataInfoMap = (Map)objectMapper.readValue(modifiedRows, (TypeReference)new TypeReference<Map<Long, SplitedDataInfo>>(){});
                    rowData.getSplitedRows().put(spiltDimCol, splitedDataInfoMap);
                }
                catch (Exception e) {
                    throw new KDBizException(e.getMessage());
                    return result;
                }
            }
        }
        catch (Throwable throwable) {
            var12_7 = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (var12_7 != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        var12_7.addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
    }

    public Map<String, Map<Long, SplitRowData>> querySplitedRowDatas(Long splitBillId, Map<Long, String> tempIdMapEntryKey) {
        Map<Long, Map<String, Map<Long, SplitRowData>>> allSplitBillData = this.querySplitedRowDatas(Collections.singletonList(splitBillId), tempIdMapEntryKey);
        Map<String, Map<Long, SplitRowData>> result = allSplitBillData.get(splitBillId);
        if (result == null) {
            result = new HashMap<String, Map<Long, SplitRowData>>(1);
        }
        return result;
    }

    public void saveSplitedRowDatas(Long splitBillId, Long templateId, Map<Long, SplitRowData> preSplitRowInfo, Map<Long, Set<String>> toSaveDataSign) {
        String updateSql;
        String insertSql;
        String querySql = "select A.fentryid as entryid,B.fid as fid,A.fsplitdimcol as splitdim,B.fsplitrowid as fsplitrowid from t_eb_spliteddimrowdata A right join t_eb_splitedrowdata B on A.fid = B.fid where B.fsplitbillid = ? and B.ftemplateid = ?";
        HashMap<String, Pair> existRowInfo = new HashMap<String, Pair>(16);
        try (DataSet dataSet = DB.queryDataSet((String)"", (DBRoute)new DBRoute("epm"), (String)querySql, (Object[])new Object[]{splitBillId, templateId});){
            StringBuilder sb = new StringBuilder();
            String preSign = splitBillId + "," + templateId + ",";
            for (Row row : dataSet) {
                sb.append(preSign).append(row.getString("fsplitrowid"));
                Pair mapPair = existRowInfo.computeIfAbsent(sb.toString(), key -> new Pair((Object)row.getLong("fid"), new HashMap(16)));
                String splitDim = row.getString("splitdim");
                if (splitDim != null) {
                    Long entryId = row.getLong("entryid");
                    ((Map)mapPair.p2).put(splitDim, entryId);
                }
                sb.setLength(0);
            }
        }
        String topSign = splitBillId + "," + templateId + ",";
        ArrayList insertHeadDatas = new ArrayList(16);
        ArrayList updateHeadDatas = new ArrayList(16);
        ArrayList insertEntryDatas = new ArrayList(16);
        ArrayList updateEntryDatas = new ArrayList(16);
        ArrayList toDelEntryRow = new ArrayList(16);
        preSplitRowInfo.forEach((rowId, splitRowData) -> {
            Long fentryId;
            Set changedSplitDims = (Set)toSaveDataSign.get(rowId);
            String rowSign = topSign + rowId;
            Pair mapPair = (Pair)existRowInfo.get(rowSign);
            if (mapPair == null) {
                Object[] row = new Object[5];
                Long id = GlobalIdUtil.genGlobalLongId();
                row[0] = id;
                row[1] = splitBillId;
                row[2] = templateId;
                row[3] = rowId;
                row[4] = SerializationUtils.toJsonString((Object)this.copySplitedRowData((SplitRowData)splitRowData));
                insertHeadDatas.add(row);
                mapPair = new Pair((Object)id, new HashMap(16));
            }
            HashSet existDims = new HashSet(((Map)mapPair.p2).keySet());
            boolean hasNewOtherDimChange = false;
            for (Map.Entry entry : splitRowData.getSplitedRows().entrySet()) {
                String splitDimCol = (String)entry.getKey();
                fentryId = (Long)((Map)mapPair.p2).get(splitDimCol);
                if (changedSplitDims != null && changedSplitDims.contains(splitDimCol)) {
                    Object[] row;
                    if (fentryId != null) {
                        row = new Object[]{SerializationUtils.toJsonString(entry.getValue()), fentryId};
                        updateEntryDatas.add(row);
                    } else {
                        hasNewOtherDimChange = true;
                        row = new Object[]{mapPair.p1, GlobalIdUtil.genGlobalLongId(), splitDimCol, SerializationUtils.toJsonString(entry.getValue())};
                        insertEntryDatas.add(row);
                    }
                }
                existDims.remove(splitDimCol);
            }
            boolean hasRollback = false;
            if (existDims.size() > 0) {
                hasRollback = true;
                for (String dimKey : existDims) {
                    fentryId = (Long)((Map)mapPair.p2).get(dimKey);
                    toDelEntryRow.add(fentryId);
                }
            }
            if (existRowInfo.containsKey(rowSign) && (changedSplitDims != null && changedSplitDims.contains("preRowChangeSign") || hasRollback || hasNewOtherDimChange)) {
                Object[] objectArray = new Object[]{SerializationUtils.toJsonString((Object)this.copySplitedRowData((SplitRowData)splitRowData)), mapPair.p1};
                updateHeadDatas.add(objectArray);
            }
        });
        if (insertHeadDatas.size() > 0) {
            insertSql = "insert into t_eb_splitedrowdata(fid,fsplitbillid,ftemplateid,fsplitrowid,fsplitdimpart) values(?,?,?,?,?)";
            DB.executeBatch((DBRoute)new DBRoute("epm"), (String)insertSql, insertHeadDatas);
        }
        if (updateHeadDatas.size() > 0) {
            updateSql = "update t_eb_splitedrowdata set fsplitdimpart = ? where fid = ?";
            DB.executeBatch((DBRoute)new DBRoute("epm"), (String)updateSql, updateHeadDatas);
        }
        if (toDelEntryRow.size() > 0) {
            String delSql = "delete from t_eb_spliteddimrowdata where fentryid in (" + SqlBatchUtils.getBatchParamsSql((int)toDelEntryRow.size()) + ")";
            DB.execute((DBRoute)new DBRoute("epm"), (String)delSql, (Object[])toDelEntryRow.toArray());
        }
        if (insertEntryDatas.size() > 0) {
            insertSql = "insert into t_eb_spliteddimrowdata(fid,fentryid,fsplitdimcol,fmodifiedrows) values(?,?,?,?)";
            DB.executeBatch((DBRoute)new DBRoute("epm"), (String)insertSql, insertEntryDatas);
        }
        if (updateEntryDatas.size() > 0) {
            updateSql = "update t_eb_spliteddimrowdata set fmodifiedrows = ? where fentryid = ?";
            DB.executeBatch((DBRoute)new DBRoute("epm"), (String)updateSql, updateEntryDatas);
        }
    }

    public Set<String> getAllChildBillNumbers(Long modelId, String longNumber) {
        HashSet<String> result = new HashSet<String>(16);
        QFBuilder qb = new QFBuilder("model", "=", (Object)modelId);
        qb.add("decppath", "like", (Object)(longNumber + "!%"));
        DynamicObjectCollection objects = QueryServiceHelper.query((String)"eb_bgdecompose", (String)"billnumber", (QFilter[])qb.toArrays());
        objects.forEach(obj -> result.add(obj.getString("billnumber")));
        return result;
    }

    public void setSplitBillHead(IDataModel dataModel, DynamicObject splitBillObj) {
        dataModel.setValue("billnumber", (Object)splitBillObj.getString("billnumber"));
        dataModel.setValue("year", splitBillObj.get("year"));
        dataModel.setValue("budgetorg", splitBillObj.get("org"));
        dataModel.setValue("splitorg", splitBillObj.get("splitorg"));
        dataModel.setValue("creater", splitBillObj.get("creater"));
        dataModel.setValue("createdate", splitBillObj.get("createdate"));
        dataModel.setValue("modifier", splitBillObj.get("modifier"));
        dataModel.setValue("modifydate", splitBillObj.get("modifydate"));
        dataModel.setValue("remark", (Object)splitBillObj.getString("remark"));
        dataModel.setValue("sourceBillNumber", (Object)this.getSourceBillNumber(splitBillObj));
    }

    private String getSourceBillNumber(DynamicObject splitBillObj) {
        String sourceBillId = splitBillObj.getString("sourcebillid");
        String preBillId = splitBillObj.getString("prebillid");
        Boolean isFirstStep = splitBillObj.getBoolean("isfirststep");
        if (isFirstStep.booleanValue()) {
            DynamicObject approveBillObject = QueryServiceHelper.queryOne((String)"eb_centralappbill", (String)"billno", (QFilter[])new QFilter("id", "=", (Object)IDUtils.toLong((Object)sourceBillId)).toArray());
            if (approveBillObject == null) {
                return null;
            }
            return approveBillObject.getString("billno");
        }
        DynamicObject splitBillObject = QueryServiceHelper.queryOne((String)"eb_bgdecompose", (String)"billnumber", (QFilter[])new QFilter("id", "=", (Object)IDUtils.toLong((Object)preBillId)).toArray());
        if (splitBillObject == null) {
            return null;
        }
        return splitBillObject.getString("billnumber");
    }

    public String checkCreateBillsRepeat(List<DynamicObject> decomposeBills, Long modelId) {
        HashSet numbers = new HashSet(16);
        decomposeBills.forEach(e -> numbers.add(e.getString("billnumber")));
        QFilter qFilter = new QFilter("billnumber", "in", numbers);
        qFilter.and("model", "=", (Object)modelId);
        if (NumberCheckUtils.checkNumberExist((String)"eb_bgdecompose", (QFilter[])new QFilter[]{qFilter}, null)) {
            return ResManager.loadResFormat((String)"\u81ea\u52a8\u751f\u6210\u5206\u89e3\u5355\u5931\u8d25\uff0c\u751f\u6210\u7684\u5206\u89e3\u5355%1\u4e2d\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u3002", (String)"BgApplySplitUtil_0", (String)"epm-eb-business", (Object[])new Object[]{numbers});
        }
        return null;
    }

    private static class SplitBillRowMap {
        private Long rowId;
        private Long billId;
        private String entryKey;

        public SplitBillRowMap(Long rowId, Long billId, String entryKey) {
            this.rowId = rowId;
            this.billId = billId;
            this.entryKey = entryKey;
        }

        public Long getRowId() {
            return this.rowId;
        }

        public String getEntryKey() {
            return this.entryKey;
        }

        public Long getBillId() {
            return this.billId;
        }
    }
}

