/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.applybill.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.eb.common.applybill.TemplateBizPlan;
import kd.epm.eb.common.applytemplatecolumn.BaseColumn;
import kd.epm.eb.common.applytemplatecolumn.EntryTemplateConfig;
import kd.epm.eb.common.utils.fileImport.entity.Header;
import kd.epm.eb.common.utils.fileImport.entity.ImportEntity;

public class BizEntityImAndExpUtil {
    private static final BizEntityImAndExpUtil instance = new BizEntityImAndExpUtil();

    public static BizEntityImAndExpUtil getInstance() {
        return instance;
    }

    public ImportEntity getTemplateData(EntryTemplateConfig config) {
        ImportEntity importData = new ImportEntity();
        importData.setTemplateName(ResManager.loadResFormat((String)"%1-\u5173\u8054\u4fe1\u606f", (String)"BizEntityImAndExpUtil_4", (String)"epm-eb-business", (Object[])new Object[]{config.getName()}));
        importData.setSheetTitle("Kingdee");
        importData.setSheetNotes(ResManager.loadKDString((String)"\u8bf7\u5c06\u9f20\u6807\u79fb\u5230\u7070\u8272\u6807\u9898\u884c\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42\u3002", (String)"BizEntityImAndExpUtil_0", (String)"epm-eb-business", (Object[])new Object[0]));
        Map sheetHeaderMap = importData.getSheetHeaderMap();
        List<BaseColumn> columns = this.getColumns(config);
        for (int i = 0; i < columns.size(); ++i) {
            BaseColumn baseColumn = columns.get(i);
            String columnName = baseColumn.getTitle();
            String tips = ResManager.loadKDString((String)"\u975e\u5fc5\u586b\u9879", (String)"BizEntityImAndExpUtil_1", (String)"epm-eb-business", (Object[])new Object[0]);
            if (baseColumn.getIsmustinput().booleanValue()) {
                columnName = "*" + columnName;
                tips = ResManager.loadKDString((String)"\u5fc5\u586b\u9879", (String)"BizEntityImAndExpUtil_2", (String)"epm-eb-business", (Object[])new Object[0]);
            }
            sheetHeaderMap.put(String.valueOf(i), new Header(columnName, tips));
        }
        return importData;
    }

    public List<ImportEntity> getBizTemplateDatas(EntryTemplateConfig config, List<TemplateBizPlan.BizPlan> bizplans) {
        ArrayList<ImportEntity> result = new ArrayList<ImportEntity>(16);
        if (bizplans.isEmpty()) {
            return result;
        }
        for (TemplateBizPlan.BizPlan bizplan : bizplans) {
            ImportEntity importData = new ImportEntity();
            result.add(importData);
            importData.setSheetName(bizplan.getTabName());
            importData.setTemplateName(ResManager.loadResFormat((String)"%1-\u5173\u8054\u4fe1\u606f", (String)"BizEntityImAndExpUtil_4", (String)"epm-eb-business", (Object[])new Object[]{config.getName()}));
            importData.setSheetTitle("Kingdee");
            importData.setSheetNotes(ResManager.loadKDString((String)"\u8bf7\u5c06\u9f20\u6807\u79fb\u5230\u7070\u8272\u6807\u9898\u884c\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42\u3002", (String)"BizEntityImAndExpUtil_0", (String)"epm-eb-business", (Object[])new Object[0]));
            Map sheetHeaderMap = importData.getSheetHeaderMap();
            List<BaseColumn> columns = this.getColumns(config);
            Set fields = bizplan.getFields();
            columns.stream().filter(s -> fields.contains(s.getKey())).collect(Collectors.toList());
            int i = 0;
            for (BaseColumn baseColumn : columns) {
                String key = baseColumn.getKey();
                if (!bizplan.getFields().contains(key)) continue;
                String columnName = baseColumn.getTitle();
                String tips = ResManager.loadKDString((String)"\u975e\u5fc5\u586b\u9879", (String)"BizEntityImAndExpUtil_1", (String)"epm-eb-business", (Object[])new Object[0]);
                if (baseColumn.getIsmustinput().booleanValue()) {
                    columnName = "*" + columnName;
                    tips = ResManager.loadKDString((String)"\u5fc5\u586b\u9879", (String)"BizEntityImAndExpUtil_2", (String)"epm-eb-business", (Object[])new Object[0]);
                }
                sheetHeaderMap.put(String.valueOf(i), new Header(columnName, tips));
                ++i;
            }
        }
        return result;
    }

    public List<BaseColumn> getColumns(EntryTemplateConfig config) {
        List entryColumns = config.getEntryColumns();
        List<BaseColumn> columns = entryColumns.stream().filter(BaseColumn::isFinalVisible).collect(Collectors.toList());
        if (columns.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u53ef\u4e0b\u8f7d\u6a21\u677f\uff0c\u8bf7\u68c0\u67e5\u6a21\u677f\u5217\u914d\u7f6e\u4fe1\u606f\u3002", (String)"BizEntityImAndExpUtil_3", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        return columns;
    }
}

