/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.applybill.util;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.centralapproval.CustomSelectGroup;
import kd.epm.eb.common.centralapproval.CustomShowParam;
import kd.epm.eb.common.utils.StringUtils;

public class CustomSelectUtil {
    private static final CustomSelectUtil instance = new CustomSelectUtil();

    public static CustomSelectUtil getInstance() {
        return instance;
    }

    public CustomShowParam createCustomShowParam(List<CustomSelectGroup> selectGroups, String caption, String plugin, int maxLength) {
        CustomShowParam customShowParam = new CustomShowParam();
        if (selectGroups == null || selectGroups.size() == 0) {
            return customShowParam;
        }
        customShowParam.setSelectGroup(selectGroups);
        customShowParam.setPlugin(plugin);
        customShowParam.setCaption(caption);
        if (maxLength != 0) {
            customShowParam.setMaxLength(maxLength);
        }
        return customShowParam;
    }

    public FormShowParameter getCustomPageParameter(CustomShowParam customShowParam) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_selectcusdim");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)"eb_selectcusdim");
        formConfig.getPlugins().clear();
        showParameter.setFormConfig(formConfig);
        String plugin = customShowParam.getPlugin();
        if (StringUtils.isEmpty((String)plugin)) {
            plugin = this.getDefaultPlugin();
        }
        showParameter.addCustPlugin(plugin);
        List selectGroup = customShowParam.getSelectGroup();
        int maxLength = customShowParam.getMaxLength();
        Pair<Integer, Integer> pageSize = this.calFormPageSize(selectGroup, maxLength);
        StyleCss css = new StyleCss();
        css.setHeight((Integer)pageSize.p1 + 70 + "px");
        css.setWidth(pageSize.p2 + "px");
        showParameter.getOpenStyle().setInlineStyleCss(css);
        String caption = customShowParam.getCaption();
        if (StringUtils.isNotEmpty((String)caption)) {
            showParameter.setCaption(caption);
        }
        showParameter.setCustomParam("selectGroups", (Object)SerializationUtils.toJsonString((Object)selectGroup));
        showParameter.setCustomParam("splitLength", (Object)maxLength);
        return showParameter;
    }

    private Pair<Integer, Integer> calFormPageSize(List<CustomSelectGroup> groups, int maxLength) {
        int realHeight = 0;
        int realWidth = 0;
        int itemCount = 4;
        int costHeightCount = 0;
        int maxCostWidthPx = 0;
        ArrayList<Integer> itemList = new ArrayList<Integer>(16);
        for (CustomSelectGroup group : groups) {
            int costWidthPx = 0;
            String name = group.getName();
            if (StringUtils.isNotEmpty((String)name)) {
                if (group.getDivideShow().booleanValue()) {
                    ++costHeightCount;
                    costWidthPx += 20;
                } else {
                    costWidthPx += this.getStringPx(name);
                }
            }
            itemList.add(group.getCustomSelectItems().size());
            maxCostWidthPx = Math.max(costWidthPx += 30, maxCostWidthPx);
        }
        for (int i = 1; i < 10; ++i) {
            int widthPx = i * (9 * maxLength + 30);
            int height = costHeightCount;
            for (Integer count : itemList) {
                height += count / i + (count % i == 0 ? 0 : 1);
            }
            int heightPx = height * 70;
            if (heightPx * 2 > widthPx + maxCostWidthPx) continue;
            realHeight = heightPx;
            realWidth = widthPx + maxCostWidthPx + 40;
            itemCount = i;
            break;
        }
        ArrayList<CustomSelectGroup> tmp = new ArrayList<CustomSelectGroup>(groups);
        groups.clear();
        for (CustomSelectGroup group : tmp) {
            List customSelectItems = group.getCustomSelectItems();
            int size = customSelectItems.size();
            if (size <= itemCount) {
                groups.add(group);
                continue;
            }
            int count = size / itemCount + (size % itemCount == 0 ? 0 : 1);
            for (int i = 0; i < count; ++i) {
                CustomSelectGroup group_item = new CustomSelectGroup();
                ArrayList items = new ArrayList(16);
                if (i == 0) {
                    group_item.setName(group.getName());
                }
                group_item.setSetting(group.getSetting());
                group_item.setDivideShow(group.getDivideShow());
                group_item.setKey(group.getKey() + "!" + (i + 1));
                for (int j = i * itemCount; j < customSelectItems.size() && j < (i + 1) * itemCount; ++j) {
                    items.add(customSelectItems.get(j));
                }
                group_item.setCustomSelectItems(items);
                groups.add(group_item);
            }
        }
        return new Pair((Object)realHeight, (Object)realWidth);
    }

    private int getStringPx(String key) {
        char[] chars;
        int px = 0;
        if (StringUtils.isEmpty((String)key)) {
            return px;
        }
        for (char aChar : chars = key.toCharArray()) {
            if (aChar >= '\u4e00' && aChar <= '\u9fa5') {
                px += 14;
                continue;
            }
            if ('a' <= aChar && 'z' >= aChar || 'A' <= aChar && 'Z' >= aChar) {
                px += 8;
                continue;
            }
            px += 10;
        }
        return px + 10;
    }

    private String getDefaultPlugin() {
        return "kd.epm.eb.formplugin.centralapproval.CustomSelectBasePlugin";
    }
}

