/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.applytemplate.config.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.applytemplate.config.service.ApplyTemplateColCfgService;
import kd.epm.eb.common.applyTemplate.constants.ColCfgPropEnum;
import kd.epm.eb.common.applyTemplate.constants.FormTypeEnum;
import kd.epm.eb.common.applyTemplate.entity.ApplyTemplateColCfgEntity;
import kd.epm.eb.common.applytemplatecolumn.ColumnList;
import kd.epm.eb.common.applytemplatecolumn.DataMapDimension;
import kd.epm.eb.common.applytemplatecolumn.DimensionColumn;
import kd.epm.eb.common.applytemplatecolumn.DimensionDataColumn;
import kd.epm.eb.common.applytemplatecolumn.NumberColumn;
import kd.epm.eb.common.applytemplatecolumn.RelationDimensionColumn;
import kd.epm.eb.common.applytemplatecolumn.RowDimensionColumn;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import org.apache.commons.collections4.CollectionUtils;

public class ApplyTemplateCfgService {
    protected static final Log log = LogFactory.getLog(ApplyTemplateCfgService.class);

    private ApplyTemplateCfgService() {
    }

    public static ApplyTemplateCfgService getInstance() {
        return new ApplyTemplateCfgService();
    }

    public void createDefaultCfg(Long templateId, String templateNumber, ColumnList columnList, Long modelId) {
        if (columnList == null || StringUtils.isEmpty((String)templateNumber) || IDUtils.isEmptyLong((Long)templateId).booleanValue()) {
            return;
        }
        ArrayList<ApplyTemplateColCfgEntity> defaultColCfgList = new ArrayList<ApplyTemplateColCfgEntity>(16);
        List<Object> saveObjs = new ArrayList(16);
        ArrayList baseColumns = new ArrayList(columnList.getColumns());
        List hBaseColumns = baseColumns.stream().filter(t -> t.getKey().startsWith("h_")).collect(Collectors.toList());
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        HashSet<String> rowDimensionColumnSet = new HashSet<String>(16);
        for (Object baseColumn : hBaseColumns) {
            for (FormTypeEnum value : FormTypeEnum.values()) {
                ApplyTemplateColCfgEntity entity = new ApplyTemplateColCfgEntity();
                entity.setApplytemplatenumber(templateNumber);
                entity.setApplytemplateid(templateId);
                entity.setFormtype(value.getCode());
                entity.setColkey(baseColumn.getKey());
                if (baseColumn instanceof DimensionColumn || baseColumn instanceof RelationDimensionColumn || baseColumn instanceof RowDimensionColumn) {
                    entity.setEdittype(ColCfgPropEnum.WRITE.getValue());
                } else {
                    entity.setEdittype(ColCfgPropEnum.READONLY.getValue());
                }
                if (baseColumn instanceof DimensionDataColumn) {
                    List dataMapDimensions = ((DimensionDataColumn)baseColumn).getDataMapDimensions();
                    for (DataMapDimension dataMapDimension : dataMapDimensions) {
                        boolean ispullfrommodel;
                        Member metric;
                        Long dimensionRememberId;
                        if (SysDimensionEnum.Metric.getNumber().equals(dataMapDimension.getDimNum())) {
                            dimensionRememberId = dataMapDimension.getDimensionRememberId();
                            metric = modelCacheHelper.getMember(SysDimensionEnum.Metric.getNumber(), null, dimensionRememberId);
                            if (metric == null) continue;
                            String datatype = metric.getDatatype();
                            boolean hasAgg = metric.hasAgg();
                            if (hasAgg && (MetricDataTypeEnum.CURRENCY.getIndex().equals(datatype) || MetricDataTypeEnum.NONMONETARY.getIndex().equals(datatype) || MetricDataTypeEnum.RATE.getIndex().equals(datatype))) {
                                entity.setAggregate(ColCfgPropEnum.AGGREGATE.getValue());
                                if (FormTypeEnum.APPLY == value) {
                                    entity.setSummarydisplay(ColCfgPropEnum.SUMMARYDISPLAY.getValue());
                                }
                            }
                        } else if (SysDimensionEnum.AuditTrail.getNumber().equals(dataMapDimension.getDimNum())) {
                            dimensionRememberId = dataMapDimension.getDimensionRememberId();
                            metric = modelCacheHelper.getMember(SysDimensionEnum.AuditTrail.getNumber(), null, dataMapDimension.getMembNum());
                            log.info("dimensionRememberxxxxx" + String.valueOf(dimensionRememberId));
                            if (metric == null) {
                                log.info("dimensionRememberwwwww");
                            } else if (!metric.isLeaf() && FormTypeEnum.APPLY == value) {
                                entity.setEdittype(ColCfgPropEnum.READONLY.getValue());
                            }
                        }
                        if (!(ispullfrommodel = baseColumn.getIspullfrommodel())) continue;
                        entity.setEdittype(ColCfgPropEnum.READONLY.getValue());
                    }
                } else if (baseColumn instanceof NumberColumn) {
                    int numberType = ((NumberColumn)baseColumn).getNumberType();
                    if (numberType == 1) {
                        entity.setAggregate(ColCfgPropEnum.AGGREGATE.getValue());
                        if (FormTypeEnum.APPLY == value) {
                            entity.setSummarydisplay(ColCfgPropEnum.SUMMARYDISPLAY.getValue());
                        }
                    }
                } else if (baseColumn instanceof RowDimensionColumn) {
                    rowDimensionColumnSet.add(baseColumn.getKey());
                    Boolean hide = ((RowDimensionColumn)baseColumn).getHide();
                    if (hide.booleanValue()) {
                        entity.setEdittype(ColCfgPropEnum.HIDE.getValue());
                    }
                }
                defaultColCfgList.add(entity);
                saveObjs.add(entity.convertToDynamic());
            }
        }
        List<ApplyTemplateColCfgEntity> colCfgListByTemplateId = ApplyTemplateColCfgService.getInstance().getColCfgListByTemplateIdFromDB(templateId);
        if (CollectionUtils.isNotEmpty(colCfgListByTemplateId)) {
            saveObjs = this.mergeCfg(colCfgListByTemplateId, defaultColCfgList);
            for (ApplyTemplateColCfgEntity entity : defaultColCfgList) {
                if (!rowDimensionColumnSet.contains(entity.getColkey()) || !entity.getFormtype().equals(FormTypeEnum.APPLY.getCode())) continue;
                saveObjs.add(entity.convertToDynamic());
            }
            if (saveObjs != null && saveObjs.size() > 0) {
                DynamicObject[] load;
                List updateDynamicObject = saveObjs.stream().filter(e -> rowDimensionColumnSet.contains(e.getString("colkey")) && FormTypeEnum.APPLY.getCode().equals(e.getString("formtype"))).collect(Collectors.toList());
                HashSet<DynamicObject[]> updateColKey = new HashSet<DynamicObject[]>(16);
                for (DynamicObject saveObj : updateDynamicObject) {
                    DynamicObject[] colkey = saveObj.getString("colkey");
                    updateColKey.add(colkey);
                }
                QFilter qFilter = new QFilter("applytemplateid", "=", (Object)templateId).and("colkey", "in", updateColKey).and("formtype", "=", (Object)FormTypeEnum.APPLY.getCode());
                block5: for (DynamicObject loadDynamicObject : load = BusinessDataServiceHelper.load((String)"eb_applytemplate_colcfg", (String)"id,applytemplateid,applytemplatenumber,colkey,formtype,edittype,aggregate,summarydisplay,entryentity.audittrailuse", (QFilter[])qFilter.toArray())) {
                    for (DynamicObject saveObj : updateDynamicObject) {
                        if (!saveObj.getString("colkey").equals(loadDynamicObject.getString("colkey")) || !FormTypeEnum.APPLY.getCode().equals(saveObj.getString("formtype")) || !FormTypeEnum.APPLY.getCode().equals(loadDynamicObject.getString("formtype"))) continue;
                        loadDynamicObject.set("edittype", (Object)saveObj.getString("edittype"));
                        continue block5;
                    }
                }
                if (load != null && load.length > 0) {
                    Set removeKeys = Arrays.stream(load).map(e -> e.getString("colkey")).collect(Collectors.toSet());
                    saveObjs.removeIf(e -> removeKeys.contains(e.getString("colkey")) && FormTypeEnum.APPLY.getCode().equals(e.getString("formtype")));
                    SaveServiceHelper.save((DynamicObject[])load);
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])saveObjs.toArray(new DynamicObject[0]));
    }

    private List<DynamicObject> mergeCfg(List<ApplyTemplateColCfgEntity> oldCfg, List<ApplyTemplateColCfgEntity> newCfg) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(16);
        if (CollectionUtils.isEmpty(oldCfg) || CollectionUtils.isEmpty(newCfg)) {
            return result;
        }
        for (ApplyTemplateColCfgEntity entity : newCfg) {
            boolean flag = false;
            for (ApplyTemplateColCfgEntity applyTemplateColCfgEntity : oldCfg) {
                if (!StringUtils.equals((String)entity.getColkey(), (String)applyTemplateColCfgEntity.getColkey())) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            result.add(entity.convertToDynamic());
        }
        return result;
    }
}

