/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.applytemplate.config.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.applyTemplate.constants.AuditTrailUseEnum;
import kd.epm.eb.common.applyTemplate.constants.ColCfgPropEnum;
import kd.epm.eb.common.applyTemplate.constants.ColCfgPropTypeEnum;
import kd.epm.eb.common.applyTemplate.constants.FormTypeEnum;
import kd.epm.eb.common.applyTemplate.entity.ApplyTemplateAtAllCfgEntity;
import kd.epm.eb.common.applyTemplate.entity.ApplyTemplateAtCfgEntity;
import kd.epm.eb.common.applyTemplate.entity.ApplyTemplateColCfgEntity;
import kd.epm.eb.common.applybill.ApplyBillType;
import kd.epm.eb.common.utils.StringUtils;
import org.apache.commons.collections4.CollectionUtils;

public class ApplyTemplateColCfgService {
    private ApplyTemplateColCfgService() {
    }

    public static ApplyTemplateColCfgService getInstance() {
        return new ApplyTemplateColCfgService();
    }

    public void saveColCfg(List<ApplyTemplateColCfgEntity> colCfgEntities, long templateId) {
        this.delete(templateId);
        this.save(colCfgEntities);
    }

    public void delete(long templateId) {
        QFilter filter = new QFilter("applytemplateid", "=", (Object)templateId);
        DeleteServiceHelper.delete((String)"eb_applytemplate_colcfg", (QFilter[])filter.toArray());
    }

    public void deletes(Set<Long> templateIds) {
        QFilter filter = new QFilter("applytemplateid", "in", templateIds);
        DeleteServiceHelper.delete((String)"eb_applytemplate_colcfg", (QFilter[])filter.toArray());
    }

    public void save(List<ApplyTemplateColCfgEntity> colCfgEntities) {
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])colCfgEntities.stream().map(ApplyTemplateColCfgEntity::convertToDynamic).toArray(DynamicObject[]::new)));
    }

    public List<ApplyTemplateColCfgEntity> getColCfgListByTemplateId(Long templateId) {
        QFilter filter = new QFilter("applytemplateid", "=", (Object)templateId);
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"eb_applytemplate_colcfg", (QFilter[])filter.toArray());
        ArrayList<ApplyTemplateColCfgEntity> result = new ArrayList<ApplyTemplateColCfgEntity>(16);
        for (DynamicObject value : dynamicObjectMap.values()) {
            result.add(ApplyTemplateColCfgEntity.convertToEntity((DynamicObject)value));
        }
        return result;
    }

    public List<ApplyTemplateColCfgEntity> getColCfgListByTemplateIdFromDB(Long templateId) {
        QFilter filter = new QFilter("applytemplateid", "=", (Object)templateId);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_applytemplate_colcfg", (String)"id,applytemplateid,applytemplatenumber,colkey,formtype,edittype,aggregate,summarydisplay,entryentity.audittrailuse,entryentity.audittrailnum,entryentity.audittrail.id", (QFilter[])filter.toArray());
        ArrayList<ApplyTemplateColCfgEntity> result = new ArrayList<ApplyTemplateColCfgEntity>(16);
        if (query != null && query.size() > 0) {
            Map<Long, List<DynamicObject>> queryMap = query.stream().collect(Collectors.groupingBy(e -> e.getLong("id")));
            for (List<DynamicObject> dynamicObjectList : queryMap.values()) {
                result.add(ApplyTemplateColCfgEntity.convertToEntity2(dynamicObjectList));
            }
        }
        return result;
    }

    public Map<Long, List<ApplyTemplateColCfgEntity>> getColCfgMapByTemplateIds(List<Long> templateIds) {
        QFilter filter = new QFilter("applytemplateid", "in", templateIds);
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"eb_applytemplate_colcfg", (QFilter[])filter.toArray());
        HashMap<Long, List<ApplyTemplateColCfgEntity>> result = new HashMap<Long, List<ApplyTemplateColCfgEntity>>(16);
        for (DynamicObject value : dynamicObjectMap.values()) {
            long templateId = value.getLong("applytemplateid.id");
            List applyTemplateColCfgEntities = result.computeIfAbsent(templateId, k -> new ArrayList(16));
            applyTemplateColCfgEntities.add(ApplyTemplateColCfgEntity.convertToEntity((DynamicObject)value));
        }
        return result;
    }

    public FormTypeEnum getFormTypeEnumByBillType(String billType) {
        FormTypeEnum typeEnum;
        ApplyBillType billTypeByNumber = ApplyBillType.getBillTypeByNumber((String)billType);
        switch (billTypeByNumber) {
            case COLLECY: 
            case COLLECTSTATISTICS: {
                typeEnum = FormTypeEnum.COLLECT;
                break;
            }
            case APPLYAUDIT: 
            case COLLECYAUDIT: 
            case AUDITSTATISTICS: 
            case COLLECTAUDITSTATISTICS: 
            case APPLYREJECT: 
            case COLLECTREJECT: 
            case REJECT: {
                typeEnum = FormTypeEnum.APPROVE;
                break;
            }
            case SPLIT: {
                typeEnum = FormTypeEnum.SPLIT;
                break;
            }
            default: {
                typeEnum = FormTypeEnum.APPLY;
            }
        }
        return typeEnum;
    }

    public Map<ColCfgPropTypeEnum, Map<String, ColCfgPropEnum>> queryColCfgMapByTemplateId(Long templateId, FormTypeEnum formTypeEnum) {
        HashMap<ColCfgPropTypeEnum, Map<String, ColCfgPropEnum>> result = new HashMap<ColCfgPropTypeEnum, Map<String, ColCfgPropEnum>>(16);
        List<ApplyTemplateColCfgEntity> colCfgListByTemplateId = this.getColCfgListByTemplateId(templateId);
        if (CollectionUtils.isEmpty(colCfgListByTemplateId)) {
            return result;
        }
        for (ApplyTemplateColCfgEntity entity : colCfgListByTemplateId) {
            ColCfgPropEnum enumByValue;
            String editType = entity.getEdittype();
            String colKey = entity.getColkey();
            String formType = entity.getFormtype();
            String aggregate = entity.getAggregate();
            if (!StringUtils.equals((String)formType, (String)formTypeEnum.getCode()) || (enumByValue = ColCfgPropEnum.getEnumByValue((String)editType)) == null) continue;
            Map editTypeMap = result.computeIfAbsent(ColCfgPropTypeEnum.EDIT_TYPE, t -> new HashMap(16));
            editTypeMap.put(colKey, enumByValue);
            ColCfgPropEnum aggregateEnum = ColCfgPropEnum.getEnumByValue((String)aggregate);
            if (aggregateEnum == null) continue;
            Map aggregateMap = result.computeIfAbsent(ColCfgPropTypeEnum.AGGREGATE, t -> new HashMap(16));
            aggregateMap.put(colKey, aggregateEnum);
        }
        return result;
    }

    public Map<Long, Map<ColCfgPropTypeEnum, Map<String, ColCfgPropEnum>>> queryColCfgMapByTemplateIds(List<Long> templateIds, FormTypeEnum formTypeEnum) {
        HashMap<Long, Map<ColCfgPropTypeEnum, Map<String, ColCfgPropEnum>>> result = new HashMap<Long, Map<ColCfgPropTypeEnum, Map<String, ColCfgPropEnum>>>(16);
        Map<Long, List<ApplyTemplateColCfgEntity>> colCfgMapByTemplateIds = this.getColCfgMapByTemplateIds(templateIds);
        if (colCfgMapByTemplateIds.size() == 0) {
            return result;
        }
        for (Map.Entry<Long, List<ApplyTemplateColCfgEntity>> colCfgListByTemplateId : colCfgMapByTemplateIds.entrySet()) {
            Long templateId = colCfgListByTemplateId.getKey();
            List<ApplyTemplateColCfgEntity> applyTemplateColCfgEntities = colCfgListByTemplateId.getValue();
            HashMap<ColCfgPropTypeEnum, Map> colCfgMap = new HashMap<ColCfgPropTypeEnum, Map>(16);
            for (ApplyTemplateColCfgEntity entity : applyTemplateColCfgEntities) {
                ColCfgPropEnum summaryDisplayEnum;
                ColCfgPropEnum enumByValue;
                String editType = entity.getEdittype();
                String colKey = entity.getColkey();
                String formType = entity.getFormtype();
                String aggregate = entity.getAggregate();
                String summaryDisplay = entity.getSummarydisplay();
                if (!StringUtils.equals((String)formType, (String)formTypeEnum.getCode()) || (enumByValue = ColCfgPropEnum.getEnumByValue((String)editType)) == null) continue;
                Map editTypeMap = colCfgMap.computeIfAbsent(ColCfgPropTypeEnum.EDIT_TYPE, t -> new HashMap(16));
                editTypeMap.put(colKey, enumByValue);
                ColCfgPropEnum aggregateEnum = ColCfgPropEnum.getEnumByValue((String)aggregate);
                if (aggregateEnum != null) {
                    Map aggregateMap = colCfgMap.computeIfAbsent(ColCfgPropTypeEnum.AGGREGATE, t -> new HashMap(16));
                    aggregateMap.put(colKey, aggregateEnum);
                }
                if ((summaryDisplayEnum = ColCfgPropEnum.getEnumByValue((String)summaryDisplay)) == null) continue;
                Map summaryDisplayMap = colCfgMap.computeIfAbsent(ColCfgPropTypeEnum.SUMMARYDISPLAY, t -> new HashMap(16));
                summaryDisplayMap.put(colKey, summaryDisplayEnum);
            }
            result.put(templateId, colCfgMap);
        }
        return result;
    }

    public Map<Long, Map<String, ApplyTemplateAtAllCfgEntity>> queryColAuditTrailAllCfgByTemplateId(Set<Long> templateIds, FormTypeEnum formTypeEnum) {
        HashMap<Long, Map<String, ApplyTemplateAtAllCfgEntity>> result = new HashMap<Long, Map<String, ApplyTemplateAtAllCfgEntity>>(16);
        Map<Long, Map<String, List<ApplyTemplateAtCfgEntity>>> config = this.queryColAuditTrailCfgByTemplateId(templateIds, formTypeEnum);
        config.forEach((tempId, colCofig) -> {
            HashMap c = new HashMap(16);
            colCofig.forEach((colKey, atlMembInfo) -> {
                ApplyTemplateAtAllCfgEntity allCfgEntity = new ApplyTemplateAtAllCfgEntity();
                for (ApplyTemplateAtCfgEntity cfgEntity : atlMembInfo) {
                    if (AuditTrailUseEnum.SPLIT_PROPORTION.getCode().equals(cfgEntity.getAuditTrailUse())) {
                        allCfgEntity.setRatioMembNum(cfgEntity.getAuditTrailMemNum());
                        continue;
                    }
                    if (AuditTrailUseEnum.ADJUST_LEAF.getCode().equals(cfgEntity.getAuditTrailUse())) {
                        allCfgEntity.setAdjustMembNum(cfgEntity.getAuditTrailMemNum());
                        continue;
                    }
                    if (!AuditTrailUseEnum.ADJUST_NON_LEAF.getCode().equals(cfgEntity.getAuditTrailUse())) continue;
                    allCfgEntity.setShareMembNum(cfgEntity.getAuditTrailMemNum());
                }
                c.put(colKey, allCfgEntity);
            });
            result.put((Long)tempId, c);
        });
        return result;
    }

    public Map<Long, Map<String, List<ApplyTemplateAtCfgEntity>>> queryColAuditTrailCfgByTemplateId(Set<Long> templateIds, FormTypeEnum formTypeEnum) {
        HashMap<Long, Map<String, List<ApplyTemplateAtCfgEntity>>> result = new HashMap<Long, Map<String, List<ApplyTemplateAtCfgEntity>>>(16);
        if (CollectionUtils.isEmpty(templateIds) || formTypeEnum == null) {
            return result;
        }
        QFilter filter = new QFilter("applytemplateid", "in", templateIds);
        Map colCfgMap = BusinessDataServiceHelper.loadFromCache((String)"eb_applytemplate_colcfg", (QFilter[])filter.toArray());
        if (colCfgMap == null) {
            return result;
        }
        for (Map.Entry entry : colCfgMap.entrySet()) {
            DynamicObject value = (DynamicObject)entry.getValue();
            if (value == null) continue;
            ApplyTemplateColCfgEntity entity = ApplyTemplateColCfgEntity.convertToEntity((DynamicObject)value);
            if (!StringUtils.equals((String)formTypeEnum.getCode(), (String)entity.getFormtype())) continue;
            Long applyTemplateId = entity.getApplytemplateid();
            Map colAuditCfgMap = result.computeIfAbsent(applyTemplateId, t -> new HashMap(16));
            String colkey = entity.getColkey();
            List atCfgEntities = colAuditCfgMap.computeIfAbsent(colkey, t -> new ArrayList(16));
            List atCfgEntities1 = entity.getAtCfgEntities();
            if (!CollectionUtils.isNotEmpty((Collection)atCfgEntities1)) continue;
            atCfgEntities.addAll(atCfgEntities1);
        }
        return result;
    }
}

