/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.applytemplate.config.service;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.epm.eb.common.applyTemplate.TempDimConfig;
import kd.epm.eb.common.applyTemplate.TempDimConfigType;
import kd.epm.eb.common.applyTemplate.entity.tableconfig.BizTableConfig;
import kd.epm.eb.common.applyTemplate.entity.tableconfig.DimFlexInfo;
import kd.epm.eb.common.applyTemplate.helper.TableHelper;
import kd.epm.eb.common.applytemplatecolumn.BaseColumn;
import kd.epm.eb.common.applytemplatecolumn.CalculateColumn;
import kd.epm.eb.common.applytemplatecolumn.DataMapDimension;
import kd.epm.eb.common.applytemplatecolumn.DimensionDataColumn;
import kd.epm.eb.common.applytemplatecolumn.FieldTypeEnum;
import kd.epm.eb.common.applytemplatecolumn.MeasureColumn;
import kd.epm.eb.common.applytemplatecolumn.RelationValueColumn;
import kd.epm.eb.common.applytemplatecolumn.RowDimensionColumn;
import kd.epm.eb.common.applytemplatecolumn.ShowOptionEnum;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.constant.ApplyTemplateConstant;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.IDUtils;
import org.apache.commons.collections4.CollectionUtils;

public class ApplyTemplateDimAreaCfgService
implements ApplyTemplateConstant {
    private static final ApplyTemplateDimAreaCfgService instance = new ApplyTemplateDimAreaCfgService();

    public static ApplyTemplateDimAreaCfgService getInstance() {
        return instance;
    }

    public String[] translateMessage(String text) {
        text = text.substring(1, text.length() - 1);
        String[] msg = text.split(",");
        for (int i = 0; i < msg.length; ++i) {
            msg[i] = msg[i].substring(1, msg[i].length() - 1);
        }
        return msg;
    }

    public void setDefaultMember(Object object, Dimension dimension) {
        Member member = null;
        String dimNumber = dimension.getNumber();
        if ("Currency".equals(dimNumber)) {
            member = dimension.getMember(Long.valueOf(0L), "CNY");
        } else if ("ChangeType".equals(dimNumber)) {
            member = dimension.getMember(Long.valueOf(0L), "CurrentPeriod");
        } else if ("Version".equals(dimNumber)) {
            member = dimension.getMember(Long.valueOf(0L), "VNone");
        } else if ("AuditTrail".equals(dimNumber)) {
            member = dimension.getMember(Long.valueOf(0L), "EntityInput");
        } else if ("DataType".equals(dimNumber)) {
            member = dimension.getMember(Long.valueOf(0L), "Budget");
        } else if ("Metric".equals(dimNumber)) {
            member = dimension.getMember(Long.valueOf(0L), "Money");
        } else if ("Year".equals(dimNumber)) {
            member = dimension.getMember(Long.valueOf(0L), "AllYear");
        } else if ("InternalCompany".equals(dimNumber)) {
            member = dimension.getMember(Long.valueOf(0L), "ICNone");
        } else if (SysDimensionEnum.Scenario.getNumber().equals(dimNumber)) {
            member = dimension.getMember(Long.valueOf(0L), "NoScenario");
        } else if (!dimension.isPreset()) {
            member = dimension.getMember(Long.valueOf(0L), dimension.getNoneNumber());
        }
        if (member != null) {
            if (object instanceof TempDimConfig) {
                TempDimConfig dimConfig = (TempDimConfig)object;
                dimConfig.setMemberId(member.getId().toString());
                dimConfig.setMemberNumber(member.getNumber());
                dimConfig.setName(member.getName());
            } else if (object instanceof DataMapDimension) {
                DataMapDimension dataMapDimension = (DataMapDimension)object;
                dataMapDimension.setDimensionRememberId(member.getId().longValue());
                dataMapDimension.setMembNum(member.getNumber());
                dataMapDimension.setVar(false);
            }
        }
    }

    public void checkAndSetNewDims(DimFlexInfo dimFlexInfo, Long modelId, Long datasetId) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        List curDataSetDims = modelCacheHelper.getDimensionList(datasetId);
        Map dimViewMap = modelCacheHelper.getViewsByDataSet(datasetId);
        for (Dimension dimension : curDataSetDims) {
            Member member;
            TempDimConfig dimConfig;
            Set allDims = dimFlexInfo.getAllDims();
            String dimNumber = dimension.getNumber();
            Long viewId = (Long)dimViewMap.get(dimNumber);
            if (!allDims.contains(dimNumber)) {
                dimConfig = new TempDimConfig();
                dimConfig.setDimensionNumber(dimNumber);
                dimConfig.setDimensionId(dimension.getId().toString());
                dimConfig.setFlag(dimension.getName());
                member = dimension.getMember(viewId, dimension.getNoneNumber());
                dimConfig.setMemberId(member.getId().toString());
                dimConfig.setMemberNumber(member.getNumber());
                dimConfig.setName(member.getName());
                dimConfig.setKey("hid" + dimFlexInfo.getHideDims().size() + 1);
                dimConfig.setPanel(TempDimConfigType.HIDEDIM.getValue());
                dimConfig.setSign(dimension.getMemberModel());
                dimConfig.setVar(false);
                dimFlexInfo.addDimConfig(dimConfig);
                continue;
            }
            dimConfig = dimFlexInfo.getDimConfig(dimNumber);
            dimConfig.setFlag(dimension.getName());
            member = dimension.getMember(viewId, IDUtils.toLong((Object)dimConfig.getMemberId()));
            if (member == null) continue;
            dimConfig.setName(member.getName());
        }
    }

    public List<DataMapDimension> getColumnDataMapDimensions(BaseColumn column) {
        List dataMapDimensions = null;
        if (column instanceof MeasureColumn) {
            MeasureColumn measureColumn = (MeasureColumn)column;
            dataMapDimensions = measureColumn.getDataMapDimensions();
        } else if (column instanceof CalculateColumn) {
            CalculateColumn calculateColumn = (CalculateColumn)column;
            dataMapDimensions = calculateColumn.getDataMapDimensions();
        } else if (column instanceof RelationValueColumn) {
            RelationValueColumn relationValueColumn = (RelationValueColumn)column;
            dataMapDimensions = relationValueColumn.getDataMapDimensions();
        } else if (column instanceof DimensionDataColumn) {
            DimensionDataColumn dimensionDataColumn = (DimensionDataColumn)column;
            dataMapDimensions = dimensionDataColumn.getDataMapDimensions();
        }
        return dataMapDimensions;
    }

    public boolean isShowDataDimensionMappingColumn(BaseColumn baseColumn) {
        return baseColumn instanceof MeasureColumn || baseColumn instanceof CalculateColumn || baseColumn instanceof RelationValueColumn || baseColumn instanceof DimensionDataColumn;
    }

    public boolean auditTrailIsNoLeaf(IModelCacheHelper modelCacheHelper, List<DataMapDimension> dataMapDimensions) {
        if (CollectionUtils.isEmpty(dataMapDimensions)) {
            return false;
        }
        Optional<DataMapDimension> first = dataMapDimensions.stream().filter(e -> "AuditTrail".equals(e.getDimNum())).findFirst();
        if (first.isPresent()) {
            Member member = modelCacheHelper.getMember("AuditTrail", null, Long.valueOf(first.get().getDimensionRememberId()));
            return member != null && !member.isLeaf();
        }
        return false;
    }

    public String getSuffixNum(String source) {
        String regEx = "[^0-9]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(source);
        return m.replaceAll("").trim();
    }

    public List<BaseColumn> getDefaultMainFormColumns(IModelCacheHelper cacheHelper, Long dateSetId, DimFlexInfo dimFlexInfo, String category, Set<String> existKeys) {
        ArrayList<BaseColumn> columns = new ArrayList<BaseColumn>(10);
        List<RowDimensionColumn> defaultRowDimColumns = this.getDefaultRowDimColumns(cacheHelper, dateSetId, dimFlexInfo.getRowDims(), category, existKeys);
        DimensionDataColumn dimensionDataColumn = this.getPresetDimensionDataColumn(cacheHelper, dimFlexInfo.getColDimConfig(), category, existKeys);
        columns.addAll(defaultRowDimColumns);
        columns.add((BaseColumn)dimensionDataColumn);
        for (int i = 0; i < columns.size(); ++i) {
            ((BaseColumn)columns.get(i)).setSort(i + 1);
        }
        return columns;
    }

    public List<RowDimensionColumn> getDefaultRowDimColumns(IModelCacheHelper modelCacheHelper, Long dataSetId, Set<String> dimNumbers, String columnCategory, Set<String> existKeys) {
        ArrayList<RowDimensionColumn> columns = new ArrayList<RowDimensionColumn>(16);
        List dimensionList = modelCacheHelper.getDimensionList(dimNumbers.toArray(new String[0]));
        for (Dimension dimension : dimensionList) {
            RowDimensionColumn column = new RowDimensionColumn();
            String nextColumnKey = this.getNextColumnKey(existKeys, columnCategory);
            column.setKey(nextColumnKey);
            column.setTitle(dimension.getName());
            column.setCategory(columnCategory);
            column.setIsmustinput(true);
            column.setIsdoubletitle(false);
            column.setBussinessModelId(dataSetId.longValue());
            column.setDimensionId(dimension.getId().longValue());
            column.setBaseEntityId(dimension.getMemberModel());
            column.setDimNumber(dimension.getNumber());
            column.setDimensionMemberRanges(new ArrayList());
            column.setEnableDimensionRelation(Boolean.valueOf(false));
            column.setHide(Boolean.valueOf(false));
            column.setDimensionRelationSchemas(new ArrayList(16));
            column.setShowOptionEnum(ShowOptionEnum.Name);
            columns.add(column);
        }
        return columns;
    }

    public RowDimensionColumn getDefaultRowDimColumn(IModelCacheHelper modelCacheHelper, Long dataSetId, String dimNumber, String columnCategory, Set<String> existKeys) {
        return this.getDefaultRowDimColumns(modelCacheHelper, dataSetId, Sets.newHashSet((Object[])new String[]{dimNumber}), columnCategory, existKeys).get(0);
    }

    public DimensionDataColumn getPresetDimensionDataColumn(IModelCacheHelper cacheHelper, Map<String, TempDimConfig> colDimConfig, String columnCategory, Set<String> existKeys) {
        DimensionDataColumn column = new DimensionDataColumn();
        column.setKey(this.getNextColumnKey(existKeys, columnCategory));
        column.setSort(0);
        column.setTitle(ResManager.loadKDString((String)"\u9ed8\u8ba4\u7ef4\u5ea6\u6570\u636e\u5217", (String)"ApplyTemplateDimAreaCfgService_01", (String)"epm-eb-business", (Object[])new Object[0]));
        column.setCategory(columnCategory);
        column.setFormula("");
        column.setFieldtype(FieldTypeEnum.NumberField);
        column.setDataMapDimensions(this.getDefaultDimDataColDataMap(cacheHelper, colDimConfig));
        return column;
    }

    private List<DataMapDimension> getDefaultDimDataColDataMap(IModelCacheHelper cacheHelper, Map<String, TempDimConfig> colDimConfig) {
        if (colDimConfig == null || colDimConfig.isEmpty()) {
            return null;
        }
        ArrayList<DataMapDimension> dataMapDimensions = new ArrayList<DataMapDimension>(colDimConfig.size());
        for (Map.Entry<String, TempDimConfig> entry : colDimConfig.entrySet()) {
            TempDimConfig dimConfig = entry.getValue();
            String dimensionNumber = dimConfig.getDimensionNumber();
            Dimension dimension = cacheHelper.getDimension(dimensionNumber);
            if (dimension == null) continue;
            DataMapDimension dataMapDimension = new DataMapDimension();
            dataMapDimension.setDimensionId(dimension.getId().longValue());
            dataMapDimension.setDimNum(dimensionNumber);
            this.setDefaultMember(dataMapDimension, dimension);
            dataMapDimensions.add(dataMapDimension);
        }
        return dataMapDimensions;
    }

    public String getNextColumnKey(Set<String> existKeys, String columnCategory) {
        String columnKey;
        while (!existKeys.add(columnKey = columnCategory + "_" + Uuid8.generateShortUuid().toLowerCase())) {
        }
        return columnKey;
    }

    public boolean checkExistBasicSettingData(Long templateId) {
        if (IDUtils.isEmptyLong((Long)templateId).booleanValue()) {
            return false;
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("applytemplateid", "=", (Object)templateId)};
        boolean tableCfgExists = QueryServiceHelper.exists((String)"eb_applytemplate_tablecfg", (QFilter[])qFilters);
        boolean dimCfgExists = QueryServiceHelper.exists((String)"eb_applytemplate_dimcfg", (QFilter[])qFilters);
        boolean colCfgExists = QueryServiceHelper.exists((String)"eb_applytemplate_colcfg", (QFilter[])qFilters);
        return tableCfgExists || dimCfgExists || colCfgExists;
    }

    public void deleteBasicSettingData(Long templateId) {
        if (IDUtils.isEmptyLong((Long)templateId).booleanValue()) {
            return;
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("applytemplateid", "=", (Object)templateId)};
        DeleteServiceHelper.delete((String)"eb_applytemplate_dimcfg", (QFilter[])qFilters);
        DeleteServiceHelper.delete((String)"eb_applytemplate_colcfg", (QFilter[])qFilters);
        DynamicObject tableCfg = QueryServiceHelper.queryOne((String)"eb_applytemplate_tablecfg", (String)"tablename", (QFilter[])new QFilter[]{new QFilter("applytemplateid", "=", (Object)templateId)});
        if (tableCfg != null) {
            String tableName = tableCfg.getString("tablename");
            TableHelper.dropTable((String)tableName);
            DeleteServiceHelper.delete((String)"eb_applytemplate_tablecfg", (QFilter[])qFilters);
        }
    }

    public void synModifyBizRowDimColumnMemberRange(Collection<BaseColumn> allColumns, RowDimensionColumn mainRowDimensionColumn, List<BizTableConfig> bizTableConfigList) {
        for (BizTableConfig bizTableConfig : bizTableConfigList) {
            Optional<BaseColumn> first;
            String dimNumber;
            String tabKey = bizTableConfig.getTabKey();
            Set rowDims = bizTableConfig.getDimFlexInfo().getRowDims();
            if (!rowDims.contains(dimNumber = mainRowDimensionColumn.getDimNumber()) || !(first = allColumns.stream().filter(e -> tabKey.equals(e.getBizPlanTabKey()) && e instanceof RowDimensionColumn && ((RowDimensionColumn)e).getDimNumber().equals(dimNumber)).findFirst()).isPresent()) continue;
            RowDimensionColumn bizRowDimColumn = (RowDimensionColumn)first.get();
            bizRowDimColumn.setDimensionMemberRanges(mainRowDimensionColumn.getDimensionMemberRanges());
            bizRowDimColumn.setEnableDimensionRelation(mainRowDimensionColumn.getEnableDimensionRelation());
            bizRowDimColumn.setDimensionRelationSchemas(mainRowDimensionColumn.getDimensionRelationSchemas());
        }
    }
}

