/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.applytemplate.config.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.applybill.util.ApplyTemplateUtils;
import kd.epm.eb.common.applyTemplate.constants.DimUseTypeEnum;
import kd.epm.eb.common.applyTemplate.entity.ApplyTemplateDataInitCfgEntity;
import kd.epm.eb.common.applyTemplate.entity.ApplyTemplateDimCfgEntity;
import kd.epm.eb.common.applytemplatecolumn.BaseColumn;
import kd.epm.eb.common.applytemplatecolumn.ColumnList;
import kd.epm.eb.common.applytemplatecolumn.DimensionDataColumn;
import kd.epm.eb.common.applytemplatecolumn.RowDimensionColumn;
import kd.epm.eb.common.utils.StringUtils;
import org.apache.commons.collections4.CollectionUtils;

public class ApplyTemplateDimCfgService {
    public static ApplyTemplateDimCfgService getInstance() {
        return new ApplyTemplateDimCfgService();
    }

    private ApplyTemplateDimCfgService() {
    }

    public void delete(long templateId, DimUseTypeEnum dimUseTypeEnum) {
        QFilter filter = new QFilter("applytemplateid", "=", (Object)templateId);
        filter.and("usetype", "=", (Object)dimUseTypeEnum.getValue());
        DeleteServiceHelper.delete((String)"eb_applytemplate_dimcfg", (QFilter[])filter.toArray());
    }

    public void deletes(Set<Long> templateIds) {
        QFilter filter = new QFilter("applytemplateid", "in", templateIds);
        DeleteServiceHelper.delete((String)"eb_applytemplate_dimcfg", (QFilter[])filter.toArray());
    }

    public boolean save(List<ApplyTemplateDimCfgEntity> dimCfgEntityList) {
        ArrayList<DynamicObject> saveObjs = new ArrayList<DynamicObject>(16);
        for (ApplyTemplateDimCfgEntity applyTemplateDimCfgEntity : dimCfgEntityList) {
            saveObjs.add(applyTemplateDimCfgEntity.convertToDynamic());
        }
        SaveServiceHelper.save((DynamicObject[])saveObjs.toArray(new DynamicObject[0]));
        return true;
    }

    public void createDimCfgEntityList(List<ApplyTemplateDimCfgEntity> dimCfgList, Long tableCfgId) {
        for (ApplyTemplateDimCfgEntity applyTemplateDimCfgEntity : dimCfgList) {
            String useType = applyTemplateDimCfgEntity.getUsetype();
            if (!StringUtils.equals((String)DimUseTypeEnum.BUSINESS_PLAN.getValue(), (String)useType)) continue;
            applyTemplateDimCfgEntity.setTablecfgid(tableCfgId);
        }
    }

    public List<ApplyTemplateDimCfgEntity> getDimCfgListByTemplateId(long templateId) {
        QFilter filter = new QFilter("applytemplateid", "=", (Object)templateId);
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"eb_applytemplate_dimcfg", (QFilter[])filter.toArray());
        ArrayList<ApplyTemplateDimCfgEntity> result = new ArrayList<ApplyTemplateDimCfgEntity>(16);
        for (DynamicObject value : dynamicObjectMap.values()) {
            result.add(ApplyTemplateDimCfgEntity.convertToEntity((DynamicObject)value));
        }
        return result;
    }

    public Map<Long, List<ApplyTemplateDimCfgEntity>> getDimCfgListByTemplateIds(List<Long> templateIds) {
        QFilter filter = new QFilter("applytemplateid", "in", templateIds);
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"eb_applytemplate_dimcfg", (QFilter[])filter.toArray());
        HashMap<Long, List<ApplyTemplateDimCfgEntity>> result = new HashMap<Long, List<ApplyTemplateDimCfgEntity>>(16);
        for (DynamicObject value : dynamicObjectMap.values()) {
            long templateId = value.getLong("applytemplateid.id");
            List applyTemplateDimCfgEntities = result.computeIfAbsent(templateId, k -> new ArrayList(16));
            applyTemplateDimCfgEntities.add(ApplyTemplateDimCfgEntity.convertToEntity((DynamicObject)value));
        }
        return result;
    }

    public Set<String> getStatisticsDimCfg(Long templateId) {
        HashSet<String> result = new HashSet<String>(16);
        List<ApplyTemplateDimCfgEntity> dimCfgListByTemplateId = this.getDimCfgListByTemplateId(templateId);
        if (CollectionUtils.isEmpty(dimCfgListByTemplateId)) {
            return result;
        }
        for (ApplyTemplateDimCfgEntity applyTemplateDimCfgEntity : dimCfgListByTemplateId) {
            if (!StringUtils.equals((String)applyTemplateDimCfgEntity.getUsetype(), (String)DimUseTypeEnum.STATISTICS.getValue())) continue;
            result.add(applyTemplateDimCfgEntity.getDimnum());
        }
        return result;
    }

    public Map<Long, List<String>> getStatisticsDimCfg(List<Long> templateIds) {
        HashMap<Long, List<String>> result = new HashMap<Long, List<String>>(16);
        Map<Long, List<ApplyTemplateDimCfgEntity>> dimCfgListByTemplateIds = this.getDimCfgListByTemplateIds(templateIds);
        if (dimCfgListByTemplateIds.size() == 0) {
            return result;
        }
        for (Map.Entry<Long, List<ApplyTemplateDimCfgEntity>> dimCfgListByTemplateId : dimCfgListByTemplateIds.entrySet()) {
            Long templateId = dimCfgListByTemplateId.getKey();
            List<ApplyTemplateDimCfgEntity> applyTemplateDimCfgEntities = dimCfgListByTemplateId.getValue();
            HashSet<String> dimCfgSet = new HashSet<String>(16);
            for (ApplyTemplateDimCfgEntity applyTemplateDimCfgEntity : applyTemplateDimCfgEntities) {
                if (!StringUtils.equals((String)applyTemplateDimCfgEntity.getUsetype(), (String)DimUseTypeEnum.STATISTICS.getValue())) continue;
                dimCfgSet.add(applyTemplateDimCfgEntity.getDimnum());
            }
            result.put(templateId, new ArrayList(dimCfgSet));
        }
        return result;
    }

    public void saveDataInitCfg(long templateId, ApplyTemplateDataInitCfgEntity cfg) {
        QFilter filter = new QFilter("applytemplateid", "=", (Object)templateId);
        DynamicObject data = null;
        DynamicObject[] datas = BusinessDataServiceHelper.load((String)"eb_applytemplate_dataicfg", (String)"id,creator,modifier,createdate,modifydate,applytemplateid,configdata_tag", (QFilter[])filter.toArray());
        data = datas.length == 0 ? BusinessDataServiceHelper.newDynamicObject((String)"eb_applytemplate_dataicfg") : datas[0];
        RequestContext requestContext = RequestContext.get();
        long currUserId = requestContext.getCurrUserId();
        data.set("applytemplateid", (Object)templateId);
        data.set("configdata_tag", (Object)SerializationUtils.toJsonString((Object)cfg));
        data.set("creator", (Object)currUserId);
        data.set("modifier", (Object)currUserId);
        data.set("createdate", (Object)TimeServiceHelper.now());
        data.set("modifydate", (Object)TimeServiceHelper.now());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{data});
    }

    public void updateDataInitCfg(long templateId) {
        QFilter filter = new QFilter("applytemplateid", "=", (Object)templateId);
        DynamicObject data = null;
        DynamicObject[] datas = BusinessDataServiceHelper.load((String)"eb_applytemplate_dataicfg", (String)"id,creator,modifier,createdate,modifydate,applytemplateid,configdata_tag", (QFilter[])filter.toArray());
        if (datas.length == 0) {
            return;
        }
        data = datas[0];
        String configdataTag = data.getString("configdata_tag");
        if (StringUtils.isNotEmpty((String)configdataTag)) {
            ApplyTemplateDataInitCfgEntity cfg = (ApplyTemplateDataInitCfgEntity)SerializationUtils.fromJsonString((String)configdataTag, ApplyTemplateDataInitCfgEntity.class);
            if (cfg.getDimIds().isEmpty() && cfg.getColumnKeys().isEmpty()) {
                return;
            }
            DynamicObject[] templateData = BusinessDataServiceHelper.load((String)"eb_applytemplate", (String)"id,name,number,amountunit,dataset_id,createtime,cachedata_tag,entrycfgjson_tag", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)templateId)});
            if (templateData != null && templateData.length > 0) {
                DynamicObject templateDatum = templateData[0];
                ColumnList columnList = ApplyTemplateUtils.getEntrycfgByApplyTemplate(templateDatum);
                Collection columns = columnList.getColumns();
                List main_collect = columns.stream().filter(ee -> "h".equals(ee.getCategory())).collect(Collectors.toList());
                ArrayList<String> dimensionDataKeys = new ArrayList<String>(16);
                ArrayList<Long> dimensionIds = new ArrayList<Long>(16);
                for (BaseColumn baseColumn : main_collect) {
                    if (baseColumn instanceof DimensionDataColumn) {
                        dimensionDataKeys.add(baseColumn.getKey());
                        continue;
                    }
                    if (!(baseColumn instanceof RowDimensionColumn)) continue;
                    RowDimensionColumn rowDimensionColumn = (RowDimensionColumn)baseColumn;
                    dimensionIds.add(rowDimensionColumn.getDimensionId());
                }
                cfg.getColumnKeys().retainAll(dimensionDataKeys);
                cfg.getDimIds().retainAll(dimensionIds);
                RequestContext requestContext = RequestContext.get();
                long currUserId = requestContext.getCurrUserId();
                data.set("configdata_tag", (Object)SerializationUtils.toJsonString((Object)cfg));
                data.set("creator", (Object)currUserId);
                data.set("modifier", (Object)currUserId);
                data.set("createdate", (Object)TimeServiceHelper.now());
                data.set("modifydate", (Object)TimeServiceHelper.now());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{data});
            }
        }
    }

    public ApplyTemplateDataInitCfgEntity getApplyTemplateDataInitCfgEntity(long templateId) {
        QFilter filter = new QFilter("applytemplateid", "=", (Object)templateId);
        DynamicObject[] datas = BusinessDataServiceHelper.load((String)"eb_applytemplate_dataicfg", (String)"id,creator,modifier,createdate,modifydate,applytemplateid,configdata_tag", (QFilter[])filter.toArray());
        if (datas.length == 0) {
            return new ApplyTemplateDataInitCfgEntity();
        }
        DynamicObject data = datas[0];
        String configdataTag = data.getString("configdata_tag");
        ApplyTemplateDataInitCfgEntity cfg = (ApplyTemplateDataInitCfgEntity)SerializationUtils.fromJsonString((String)configdataTag, ApplyTemplateDataInitCfgEntity.class);
        return cfg;
    }
}

