/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.applytemplate.config.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.business.applytemplate.config.service.ApplyTemplateTableCfgService;
import kd.epm.eb.common.applyTemplate.constants.BussPlanEntryPresetFieldsEnum;
import kd.epm.eb.common.applyTemplate.constants.StatusEnum;
import kd.epm.eb.common.applyTemplate.entity.ApplyTemplateBizRange;
import kd.epm.eb.common.applyTemplate.entity.ApplyTemplateTableCfgEntity;
import kd.epm.eb.common.applyTemplate.entity.dto.TableColumn;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.utils.DateTimeUtils;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import org.apache.commons.collections4.CollectionUtils;

public class ApplyTemplateDimRangeService {
    private IModelCacheHelper modelCacheHelper;
    private static final Log log = LogFactory.getLog(ApplyTemplateDimRangeService.class);
    private static final String FIELD_MAINBUDGETINFO = "_mainbudgetinfo";
    private static final String FIELD_BUSINESSPLANSHEET = "_businessplansheet";

    public static ApplyTemplateDimRangeService getInstance() {
        return new ApplyTemplateDimRangeService();
    }

    private ApplyTemplateDimRangeService() {
    }

    public void saveDimRange(DynamicObjectCollection saveDatas, ApplyTemplateTableCfgEntity tableCfgEntity) {
        if (CollectionUtils.isEmpty((Collection)saveDatas) || tableCfgEntity == null) {
            return;
        }
        String tableName = tableCfgEntity.getTablename();
        if (StringUtils.isEmpty((String)tableName)) {
            return;
        }
        List columnList = tableCfgEntity.getColumnList();
        if (CollectionUtils.isEmpty((Collection)columnList)) {
            return;
        }
        String sql = this.buildInsertSql(tableName, columnList);
        List<Object[]> paramsList = this.buildInsertParams((List<TableColumn>)columnList, saveDatas);
        DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)sql, paramsList);
    }

    public void saveDimRange(List<Map<String, Object>> saveDataList, ApplyTemplateTableCfgEntity tableCfgEntity) {
        if (CollectionUtils.isEmpty(saveDataList) || tableCfgEntity == null) {
            return;
        }
        String tableName = tableCfgEntity.getTablename();
        if (StringUtils.isEmpty((String)tableName)) {
            return;
        }
        List columnList = tableCfgEntity.getColumnList();
        if (CollectionUtils.isEmpty((Collection)columnList)) {
            return;
        }
        String sql = this.buildInsertSql(tableName, columnList);
        List<Object[]> paramsList = this.buildInsertParams((List<TableColumn>)columnList, saveDataList);
        DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)sql, paramsList);
    }

    private List<Object[]> buildInsertParams(List<TableColumn> columnList, List<Map<String, Object>> saveDataList) {
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(16);
        for (Map<String, Object> saveData : saveDataList) {
            Object[] rowData = new Object[columnList.size() + 1];
            rowData[0] = GlobalIdUtil.genGlobalLongId();
            for (int i = 1; i < rowData.length; ++i) {
                TableColumn tableColumn = columnList.get(i - 1);
                String colKey = tableColumn.getColKey();
                Object value = saveData.get(colKey);
                rowData[i] = StringUtils.equals((String)colKey, (String)BussPlanEntryPresetFieldsEnum.MODIFIER.getColKey()) ? this.getUserId() : (StringUtils.equals((String)colKey, (String)BussPlanEntryPresetFieldsEnum.MODIFY_DATE.getColKey()) ? DateTimeUtils.formatFromStr((String)(TimeServiceHelper.now() + "")) : value);
            }
            paramsList.add(rowData);
        }
        return paramsList;
    }

    private List<Object[]> buildInsertParams(List<TableColumn> columnList, DynamicObjectCollection saveDatas) {
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(16);
        for (DynamicObject saveData : saveDatas) {
            Object[] rowData = new Object[columnList.size() + 1];
            Long oldId = saveData.getLong("id");
            rowData[0] = IDUtils.isEmptyLong((Long)oldId) != false ? Long.valueOf(GlobalIdUtil.genGlobalLongId()) : oldId;
            for (int i = 1; i < rowData.length; ++i) {
                TableColumn tableColumn = columnList.get(i - 1);
                String colKey = tableColumn.getColKey();
                Object value = saveData.get(colKey);
                if (StringUtils.equals((String)colKey, (String)BussPlanEntryPresetFieldsEnum.MODIFIER.getColKey())) {
                    if (value instanceof DynamicObject) {
                        rowData[i] = ((DynamicObject)value).getLong("id");
                        continue;
                    }
                    rowData[i] = this.getUserId();
                    continue;
                }
                if (StringUtils.equals((String)colKey, (String)BussPlanEntryPresetFieldsEnum.MODIFY_DATE.getColKey())) {
                    if (value != null && StringUtils.isNotEmpty((String)value.toString())) {
                        rowData[i] = value;
                        continue;
                    }
                    rowData[i] = DateTimeUtils.formatFromStr((String)(TimeServiceHelper.now() + ""));
                    continue;
                }
                if (StringUtils.equals((String)colKey, (String)BussPlanEntryPresetFieldsEnum.MAINBUDGETINFO.getColKey())) {
                    if (value != null && StringUtils.isNotEmpty((String)value.toString())) {
                        rowData[i] = value;
                        continue;
                    }
                    rowData[i] = "";
                    continue;
                }
                if (StringUtils.equals((String)colKey, (String)BussPlanEntryPresetFieldsEnum.BUSINESSPLANSHEET.getColKey())) {
                    if (value != null && StringUtils.isNotEmpty((String)value.toString())) {
                        rowData[i] = value;
                        continue;
                    }
                    rowData[i] = "";
                    continue;
                }
                if (value instanceof DynamicObjectCollection) {
                    ArrayList<Long> baseDataIds = new ArrayList<Long>(16);
                    for (DynamicObject baseData : (DynamicObjectCollection)value) {
                        DynamicObject basedataObj = baseData.getDynamicObject("fbasedataid");
                        Long basedataId = (Long)basedataObj.getPkValue();
                        baseDataIds.add(basedataId);
                    }
                    rowData[i] = StringUtils.join(baseDataIds, (String)",");
                    continue;
                }
                rowData[i] = value;
            }
            paramsList.add(rowData);
        }
        return paramsList;
    }

    private String buildInsertSql(String tableName, List<TableColumn> columnList) {
        StringBuilder sql = new StringBuilder("insert into ").append(tableName);
        sql.append("(fid");
        List colKeys = columnList.stream().map(TableColumn::getKey).collect(Collectors.toCollection(() -> new ArrayList(16)));
        String keyStr = StringUtils.join((Collection)colKeys, (String)",");
        keyStr = "," + keyStr;
        sql.append(keyStr);
        sql.append(") values(?");
        List flag = columnList.stream().map(tableColumn -> "?").collect(Collectors.toCollection(() -> new ArrayList(16)));
        String join = StringUtils.join((Collection)flag, (String)",");
        join = "," + join;
        sql.append(join);
        sql.append(")");
        return sql.toString();
    }

    public boolean isHasDimRangeRecords(String tableName) {
        if (StringUtils.isEmpty((String)tableName)) {
            return false;
        }
        String sql = "select count(fid) count from " + tableName;
        try (DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)new DBRoute("epm"), (String)sql);){
            if (ds != null && ds.hasNext()) {
                Row next = ds.next();
                Integer count = next.getInteger("count");
                boolean bl = count > 0;
                return bl;
            }
        }
        return false;
    }

    public List<Map<String, Object>> getDimRangeRecords(long templateId, StatusEnum statusEnum) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(16);
        ApplyTemplateTableCfgEntity tableCfgEntity = ApplyTemplateTableCfgService.getInstance().getTableCfgByTemplateId(templateId);
        String columnJson = tableCfgEntity.getColumnjson();
        if (StringUtils.isEmpty((String)columnJson)) {
            return result;
        }
        List tableColumns = tableCfgEntity.getColumnList();
        String tableName = tableCfgEntity.getTablename();
        if (StringUtils.isEmpty((String)tableName)) {
            return result;
        }
        List colKeys = tableColumns.stream().map(TableColumn::getKey).collect(Collectors.toList());
        String selectKeys = String.join((CharSequence)",", colKeys);
        String sql = "select " + selectKeys + " from " + tableName;
        if (statusEnum != null) {
            sql = sql + " where f" + BussPlanEntryPresetFieldsEnum.STATUS.getKey() + " = '" + statusEnum.getCode() + "'";
        }
        try (DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"epm"), (String)sql);){
            while (ds != null && ds.hasNext()) {
                Row next = ds.next();
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                for (TableColumn tableColumn : tableColumns) {
                    Object value = next.get(tableColumn.getKey());
                    if (value == null) continue;
                    if (StringUtils.equals((String)BussPlanEntryPresetFieldsEnum.STATUS.getColKey(), (String)tableColumn.getColKey())) {
                        for (StatusEnum statusEnum1 : StatusEnum.values()) {
                            if (!StringUtils.equals((String)statusEnum1.getCode(), (String)value.toString())) continue;
                            value = statusEnum1.getValue();
                        }
                    }
                    map.put(tableColumn.getColKey(), value);
                }
                result.add(map);
            }
        }
        return result;
    }

    public List<ApplyTemplateBizRange> getApplytemplateDimRange(Long templateId, Long datasetId, Long modelId) {
        ArrayList<ApplyTemplateBizRange> results = new ArrayList<ApplyTemplateBizRange>(16);
        if (this.modelCacheHelper == null) {
            this.modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        }
        Map dimViewMap = this.modelCacheHelper.getViewsByDataSet(datasetId);
        List<Map<String, Object>> dimRangeRecords = this.getDimRangeRecords(templateId, StatusEnum.ENABLE);
        for (Map<String, Object> dimRangeRecord : dimRangeRecords) {
            HashMap<String, List> map = new HashMap<String, List>(16);
            ApplyTemplateBizRange range = new ApplyTemplateBizRange();
            for (Map.Entry<String, Object> entry : dimRangeRecord.entrySet()) {
                String v;
                Object value = entry.getValue();
                String key = entry.getKey();
                if (key.endsWith("_name")) {
                    String[] splitValue;
                    String dimNumber = key.replace("entryentity_businessplan_", "").replace("_name", "");
                    for (String val : splitValue = StringUtils.split((String)value.toString(), (String)",")) {
                        Long memberId = Long.parseLong(val);
                        Member member = this.modelCacheHelper.getMember(dimNumber = dimNumber.substring(0, 1).toUpperCase() + dimNumber.substring(1), (Long)dimViewMap.get(dimNumber), memberId);
                        if (member == null) continue;
                        List members = member.getAllMembers().stream().map(s -> s.getId()).collect(Collectors.toList());
                        List allmembers = map.computeIfAbsent(dimNumber, s -> new ArrayList(16));
                        allmembers.addAll(members);
                    }
                    continue;
                }
                if (key.endsWith(FIELD_MAINBUDGETINFO)) {
                    v = value == null ? "" : value.toString();
                    range.setBudgetSumFieldKey(v);
                    continue;
                }
                if (!key.endsWith(FIELD_BUSINESSPLANSHEET)) continue;
                v = value == null ? "" : value.toString();
                String[] split = v.split(",");
                ArrayList<String> plankeys = new ArrayList<String>(16);
                for (String s2 : split) {
                    plankeys.add(s2);
                }
                range.setBizPlanKeys(plankeys);
            }
            range.setMembers(map);
            results.add(range);
        }
        return results;
    }

    public List<ApplyTemplateBizRange> compareMemberId(List<ApplyTemplateBizRange> dimRange, String dimNumber, Long dimMemberId) {
        ArrayList<ApplyTemplateBizRange> finds = new ArrayList<ApplyTemplateBizRange>(16);
        for (ApplyTemplateBizRange range : dimRange) {
            Map members = range.getMembers();
            if (members.isEmpty()) continue;
            List memberids = (List)members.get(dimNumber);
            if (memberids == null) {
                return dimRange;
            }
            if (memberids.isEmpty() || !memberids.contains(dimMemberId)) continue;
            finds.add(range);
        }
        return finds;
    }

    public String getTemplateIdAndDimStr(String templateId, String dimstr) {
        return templateId + "@" + dimstr;
    }

    private Long getUserId() {
        return IDUtils.toLong((Object)RequestContext.get().getUserId());
    }
}

