/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.applytemplate.config.service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.applyTemplate.entity.ApplyTemplateTableCfgEntity;
import kd.epm.eb.common.applyTemplate.helper.TableHelper;

public class ApplyTemplateTableCfgService {
    public static ApplyTemplateTableCfgService getInstance() {
        return new ApplyTemplateTableCfgService();
    }

    private ApplyTemplateTableCfgService() {
    }

    public Long saveTableCfg(ApplyTemplateTableCfgEntity entity, long templateId) {
        this.delete(templateId);
        return this.save(entity);
    }

    private void delete(long templateId) {
        QFilter filter = new QFilter("applytemplateid", "=", (Object)templateId);
        DeleteServiceHelper.delete((String)"eb_applytemplate_tablecfg", (QFilter[])filter.toArray());
    }

    public void deletes(Set<Long> templateIds) {
        QFilter filter = new QFilter("applytemplateid", "in", templateIds);
        DeleteServiceHelper.delete((String)"eb_applytemplate_tablecfg", (QFilter[])filter.toArray());
    }

    public void dropTable(Set<Long> templateIds) {
        List<ApplyTemplateTableCfgEntity> tableCfgList = this.getTableCfgList(templateIds);
        HashSet tableNames = new HashSet(16);
        tableCfgList.stream().map(t -> tableNames.add(t.getTablename()));
        TableHelper.dropTables(tableNames);
    }

    public Long save(ApplyTemplateTableCfgEntity entity) {
        DynamicObject dynamicObject = entity.convertToDynamic();
        Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        if (save != null && save.length == 1) {
            if (!(save[0] instanceof DynamicObject)) {
                return 0L;
            }
            DynamicObject dynamicObjectObj = (DynamicObject)save[0];
            return dynamicObjectObj.getLong("id");
        }
        return 0L;
    }

    public ApplyTemplateTableCfgEntity getTableCfgByTemplateId(Long templateId) {
        QFilter filter = new QFilter("applytemplateid", "=", (Object)templateId);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_applytemplate_tablecfg", (String)"applytemplateid,columnjson,applytemplatenumber,tablename,creator,modifier,createdate,modifydate", (QFilter[])filter.toArray());
        return ApplyTemplateTableCfgEntity.convertToEntityNew((DynamicObject)dynamicObject);
    }

    public List<ApplyTemplateTableCfgEntity> getTableCfgList(Set<Long> templateIds) {
        ArrayList<ApplyTemplateTableCfgEntity> result = new ArrayList<ApplyTemplateTableCfgEntity>(16);
        QFilter filter = new QFilter("applytemplateid", "in", templateIds);
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"eb_applytemplate_tablecfg", (QFilter[])filter.toArray());
        for (DynamicObject value : dynamicObjectMap.values()) {
            ApplyTemplateTableCfgEntity applyTemplateTableCfgEntity = ApplyTemplateTableCfgEntity.convertToEntity((DynamicObject)value);
            result.add(applyTemplateTableCfgEntity);
        }
        return result;
    }
}

