/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.approveBill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.approveBill.CommitCheck;
import kd.epm.eb.business.approvetype.ApproveTypeUtils;
import kd.epm.eb.business.approvetype.ApproveUtils;
import kd.epm.eb.business.bailorg.BailOrgService;
import kd.epm.eb.business.bailorg.pojo.BailOrgRelation;
import kd.epm.eb.common.approveBill.ApproveBillCommon;
import kd.epm.eb.common.approveBill.Entity.AllocateDetailRecord;
import kd.epm.eb.common.approveBill.Entity.AllocateRecord;
import kd.epm.eb.common.approveBill.Entity.ApproveBillCreateInfo;
import kd.epm.eb.common.approveBill.Entity.ApproveBillRptTemp;
import kd.epm.eb.common.approveBill.Entity.ApproveBillSubMitDim;
import kd.epm.eb.common.approveBill.Entity.ApproveBillSubMitInfo;
import kd.epm.eb.common.approveBill.Entity.CentralBillType;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.pojo.TemplateEntryPojo;
import kd.epm.eb.common.reportprocess.helper.ApproveBillHelper;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import org.apache.commons.collections4.CollectionUtils;

public class ApproveBillAutoCreate {
    private static final Log log = LogFactory.getLog(ApproveBillAutoCreate.class);
    private Long defaultApproveType;

    public List<DynamicObject> getNeedSaveApproveBillList(ApproveBillSubMitInfo rptInfo, Map<Long, ApproveBillCreateInfo> approveBillInfos, Set<String> addBillNos) {
        ArrayList<DynamicObject> needSaveDatas = new ArrayList<DynamicObject>();
        Collection<ApproveBillSubMitInfo> subTaskRptInfos = this.splitApproveBill(rptInfo);
        for (ApproveBillSubMitInfo subTaskRptInfo : subTaskRptInfos) {
            boolean isModify = false;
            Collection rptTemps = subTaskRptInfo.getRptTemps();
            for (Map.Entry<Long, ApproveBillCreateInfo> entry : approveBillInfos.entrySet()) {
                ApproveBillCreateInfo value = entry.getValue();
                Set templates = value.getTemplates();
                Set collect = rptTemps.stream().map(ApproveBillRptTemp::getTempId).collect(Collectors.toSet());
                if (collect.size() != templates.size() || !collect.containsAll(templates)) continue;
                ApproveBillCreateInfo approveBillCreateInfo = approveBillInfos.get(entry.getKey());
                if ("B".equals(approveBillCreateInfo.getBillStatus())) {
                    throw new KDBizException(ResManager.loadResFormat((String)"\u5f53\u524d\u63d0\u4ea4\u7684\u62a5\u8868\u5df2\u7ecf\u5b58\u5728\u5ba1\u6279\u5355\u201c%1\u201d\u3002", (String)"CommitCheck_2", (String)"epm-eb-formplugin", (Object[])new Object[]{approveBillCreateInfo.getBillNo()}));
                }
                DynamicObject bill = this.modifyApproveBill(entry.getKey(), subTaskRptInfo);
                needSaveDatas.add(bill);
                isModify = true;
            }
            if (isModify) continue;
            List<DynamicObject> bills = this.createApproveBill(subTaskRptInfo);
            needSaveDatas.addAll(bills);
            bills.forEach(e -> addBillNos.add(e.getString("billno")));
        }
        boolean containRepeat = ApproveUtils.getInstance().validateRepeat(needSaveDatas);
        if (containRepeat) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672c\u6b21\u63d0\u4ea4\u7684\u62a5\u8868\u5b58\u5728\u4ea4\u96c6\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CommitCheck_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return needSaveDatas;
    }

    public Object[] saveApproveBill(List<DynamicObject> needSaveDatas, Set<String> addBillNos) {
        Object[] obj = null;
        try (TXHandle tx = TX.requiresNew((String)"saveAndDeleteApproveBill");){
            try {
                if (needSaveDatas.size() > 0) {
                    obj = SaveServiceHelper.save((IDataEntityType)needSaveDatas.get(0).getDataEntityType(), (Object[])needSaveDatas.toArray(new Object[0]));
                    HashSet<Long> approveIds = new HashSet<Long>(16);
                    for (Object dynamic : obj) {
                        DynamicObject dynamicObject;
                        if (!(dynamic instanceof DynamicObject) || !addBillNos.contains((dynamicObject = (DynamicObject)dynamic).getString("billno"))) continue;
                        approveIds.add(dynamicObject.getLong("id"));
                    }
                    Set<Long> reportProcessIds = ApproveUtils.getInstance().getApproveRefReportProcessIds(approveIds);
                    ApproveUtils.getInstance().updateRejectOpinionInstance(reportProcessIds, approveIds);
                }
            }
            catch (Throwable ex) {
                log.error("save or delete approvebill fail !" + ex.getMessage() + Arrays.toString(ex.getStackTrace()));
                tx.markRollback();
            }
        }
        return obj;
    }

    public Object[] createApproveBillAuto(ApproveBillSubMitInfo rptInfo) {
        Map<Long, ApproveBillCreateInfo> approveBillInfos = this.getApproveBillInfo(rptInfo);
        HashSet<String> addBillNos = new HashSet<String>(16);
        List<DynamicObject> needSaveDatas = this.getNeedSaveApproveBillList(rptInfo, approveBillInfos, addBillNos);
        return this.saveApproveBill(needSaveDatas, addBillNos);
    }

    private void createOrModifyApproveBill(Collection<ApproveBillSubMitInfo> subTaskRptInfos, List<ApproveBillSubMitInfo> canSaveTaskRptInfos, List<Long> reSubmitBills, Map<Long, ApproveBillCreateInfo> approveBillInfos, List<Long> toDelRepeatBills) {
    }

    private Map<Long, ApproveBillCreateInfo> getApproveBillInfo(ApproveBillSubMitInfo rptInfo) {
        QFilter qFilter = new CommitCheck().getQFilterNew(rptInfo.getSubmitDims());
        String fields = "id,billno,billstatus,dim_period,dim_version,dim_datatype,entryentity.tempid as tempid,eborgid,approvetype,approvetypeversion";
        DynamicObjectCollection approveBills = QueryServiceHelper.query((String)"eb_approvebill", (String)fields, (QFilter[])qFilter.toArray());
        HashMap<Long, ApproveBillCreateInfo> tempBillMap = new HashMap<Long, ApproveBillCreateInfo>(16);
        for (DynamicObject approveBill : approveBills) {
            long billId = approveBill.getLong("id");
            ApproveBillCreateInfo approveBillCreateInfo = (ApproveBillCreateInfo)tempBillMap.get(billId);
            if (approveBillCreateInfo == null) {
                approveBillCreateInfo = new ApproveBillCreateInfo();
                approveBillCreateInfo.setId(Long.valueOf(billId));
                approveBillCreateInfo.setBillNo(approveBill.getString("billno"));
                approveBillCreateInfo.setBillStatus(approveBill.getString("billstatus"));
                approveBillCreateInfo.setTemplates(new HashSet(16));
                approveBillCreateInfo.setApproveType(Long.valueOf(approveBill.getLong("approvetype")));
                approveBillCreateInfo.setApproveTypeVersion(Long.valueOf(approveBill.getLong("approvetypeversion")));
                tempBillMap.put(billId, approveBillCreateInfo);
            }
            Set templateIds = approveBillCreateInfo.getTemplates();
            templateIds.add(approveBill.getLong("tempid"));
        }
        return tempBillMap;
    }

    private Collection<ApproveBillSubMitInfo> splitApproveBill(ApproveBillSubMitInfo rptInfo) {
        ArrayList<ApproveBillSubMitInfo> rptInfos = new ArrayList<ApproveBillSubMitInfo>(10);
        Collection rptTemps = rptInfo.getRptTemps();
        if (rptTemps.isEmpty()) {
            return rptInfos;
        }
        AllocateRecord allocateRecord = this.getAllApproveTypeRecords(rptInfo);
        Map<Long, List<ApproveBillRptTemp>> subTaskRptTemps = rptTemps.stream().collect(Collectors.groupingBy(ApproveBillRptTemp::getSubTaskId));
        Map<Long, Long> taskIdToApTypeMap = this.getTaskApproveTypeId(subTaskRptTemps.keySet());
        try {
            for (Map.Entry<Long, List<ApproveBillRptTemp>> entry : subTaskRptTemps.entrySet()) {
                List<ApproveBillRptTemp> temps = entry.getValue();
                ApproveBillSubMitInfo subRptInfo = (ApproveBillSubMitInfo)rptInfo.clone();
                if (temps.size() < 1) {
                    log.info("subTask is empty !");
                    continue;
                }
                subRptInfo.setApprovalType(taskIdToApTypeMap.getOrDefault(temps.get(0).getSubTaskId(), 0L));
                subRptInfo.setRptTemps(temps);
                subRptInfo.getSubmitDims().setTempIds(ApproveBillCommon.getTempIds(temps));
                rptInfos.addAll(this.matchingApproveTypeAndSplit(subRptInfo, allocateRecord));
            }
        }
        catch (Exception e) {
            log.info("split ApproveBillSubMitInfo error! " + e.getMessage() + Arrays.toString(e.getStackTrace()));
        }
        return rptInfos;
    }

    private AllocateRecord getAllApproveTypeRecords(ApproveBillSubMitInfo rptInfo) {
        Set tempIds;
        ApproveBillSubMitDim submitDims = rptInfo.getSubmitDims();
        QFilter qFilter = new QFilter("model", "=", (Object)submitDims.getModelId());
        Long bizModelId = submitDims.getBizModelId();
        if ((bizModelId == null || bizModelId == 0L) && (tempIds = submitDims.getTempIds()).size() != 0) {
            DynamicObjectCollection businessModel = QueryServiceHelper.query((String)"eb_templateentity", (String)"dataset.businessmodel as businessModel", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)tempIds)});
            Set businessModels = businessModel.stream().map(e -> e.getLong("businessModel")).collect(Collectors.toSet());
            bizModelId = businessModels.size() != 1 ? Long.valueOf(0L) : (Long)businessModels.iterator().next();
        }
        if (bizModelId == null) {
            bizModelId = 0L;
        }
        qFilter.and("bizmodel", "=", (Object)bizModelId);
        qFilter.and("status", "=", (Object)"1");
        return ApproveTypeUtils.getInstance().buildAllocatedRecordFromDB(qFilter);
    }

    private List<ApproveBillSubMitInfo> matchingApproveTypeAndSplit(ApproveBillSubMitInfo subRptInfo, AllocateRecord allocateRecord) {
        ArrayList<ApproveBillSubMitInfo> rptInfos = new ArrayList<ApproveBillSubMitInfo>(16);
        ApproveBillSubMitDim submitDims = subRptInfo.getSubmitDims();
        ArrayList<AllocateDetailRecord> detailRecords = new ArrayList<AllocateDetailRecord>(16);
        Long orgId = submitDims.getOrgId();
        Set tempIds = submitDims.getTempIds();
        for (Long tempId : tempIds) {
            AllocateDetailRecord detailRecord = new AllocateDetailRecord();
            detailRecord.setEntity(orgId);
            detailRecord.setRange(Integer.valueOf(RangeEnum.ONLY.getIndex()));
            detailRecord.setTemplate(tempId);
            detailRecords.add(detailRecord);
        }
        Long modelId = submitDims.getModelId();
        List<AllocateDetailRecord> matchingAllocateRecords = ApproveTypeUtils.getInstance().matchingAllocateRecords(detailRecords, allocateRecord, modelId, submitDims.getViewId());
        if (matchingAllocateRecords.size() == 0) {
            subRptInfo.setApproveType(this.getDefaultApproveType());
            rptInfos.add(subRptInfo);
        } else {
            try {
                ArrayList<Long> hasCreateBillTemps = new ArrayList<Long>(16);
                HashMap<Long, ApproveBillSubMitInfo> mixRecordMap = new HashMap<Long, ApproveBillSubMitInfo>(16);
                HashSet<Long> hasCreateBillApproveTypes = new HashSet<Long>(16);
                Map<Long, ApproveBillRptTemp> tempMap = subRptInfo.getRptTemps().stream().collect(Collectors.toMap(ApproveBillRptTemp::getTempId, e -> e, (n1, n2) -> n2));
                for (AllocateDetailRecord matchingAllocateRecord : matchingAllocateRecords) {
                    ArrayList<ApproveBillRptTemp> temps;
                    ApproveBillSubMitInfo childRptInfo;
                    Map entityRangeMap = matchingAllocateRecord.getEntityRangeMap();
                    Long recordId = matchingAllocateRecord.getRecordId();
                    if (entityRangeMap != null) {
                        if (!entityRangeMap.containsKey(orgId) || !hasCreateBillApproveTypes.add(recordId)) continue;
                        ApproveBillSubMitInfo childRptInfo2 = (ApproveBillSubMitInfo)subRptInfo.clone();
                        childRptInfo2.setApproveType(recordId);
                        childRptInfo2.setApproveTypeVersion(matchingAllocateRecord.getRecordVersion());
                        rptInfos.add(childRptInfo2);
                        hasCreateBillTemps.addAll(tempIds);
                        continue;
                    }
                    List templates = matchingAllocateRecord.getTemplates();
                    if (templates != null) {
                        if (hasCreateBillApproveTypes.contains(recordId)) continue;
                        ArrayList<ApproveBillRptTemp> temps2 = new ArrayList<ApproveBillRptTemp>(16);
                        HashSet<Long> templateIds = new HashSet<Long>(16);
                        for (TemplateEntryPojo template2 : templates) {
                            ApproveBillRptTemp approveBillRptTemp = tempMap.get(template2.getId());
                            if (approveBillRptTemp == null) continue;
                            temps2.add(approveBillRptTemp);
                            templateIds.add(template2.getId());
                        }
                        childRptInfo = (ApproveBillSubMitInfo)subRptInfo.clone();
                        childRptInfo.setApproveType(recordId);
                        childRptInfo.setRptTemps(temps2);
                        childRptInfo.getSubmitDims().setTempIds(templateIds);
                        childRptInfo.setApproveTypeVersion(matchingAllocateRecord.getRecordVersion());
                        rptInfos.add(childRptInfo);
                        hasCreateBillTemps.addAll(templates.stream().map(template -> template.getId()).collect(Collectors.toList()));
                        hasCreateBillApproveTypes.add(recordId);
                        continue;
                    }
                    Long template3 = matchingAllocateRecord.getTemplate();
                    childRptInfo = (ApproveBillSubMitInfo)mixRecordMap.get(recordId);
                    if (childRptInfo == null) {
                        temps = new ArrayList<ApproveBillRptTemp>(16);
                        childRptInfo = (ApproveBillSubMitInfo)subRptInfo.clone();
                        childRptInfo.setApproveType(recordId);
                        childRptInfo.setRptTemps(temps);
                        childRptInfo.getSubmitDims().setTempIds(new HashSet(16));
                        childRptInfo.setApproveTypeVersion(matchingAllocateRecord.getRecordVersion());
                        mixRecordMap.put(recordId, childRptInfo);
                        rptInfos.add(childRptInfo);
                    } else {
                        temps = childRptInfo.getRptTemps();
                    }
                    temps.add(tempMap.get(template3));
                    childRptInfo.getSubmitDims().getTempIds().add(template3);
                    hasCreateBillTemps.add(template3);
                }
                HashSet tmp = new HashSet(tempIds);
                tmp.removeAll(hasCreateBillTemps);
                if (tmp.size() != 0) {
                    ApproveBillSubMitInfo childRptInfo = (ApproveBillSubMitInfo)subRptInfo.clone();
                    List temps = tmp.stream().map(tempMap::get).collect(Collectors.toList());
                    childRptInfo.setRptTemps(temps);
                    childRptInfo.getSubmitDims().setTempIds(tmp);
                    childRptInfo.setApproveType(this.getDefaultApproveType());
                    rptInfos.add(childRptInfo);
                }
            }
            catch (Exception e2) {
                log.info("split ApproveBillSubMitInfo error! " + e2.getMessage() + Arrays.toString(e2.getStackTrace()));
            }
        }
        return rptInfos;
    }

    private List<DynamicObject> createApproveBill(ApproveBillSubMitInfo rptInfo) {
        ArrayList<DynamicObject> needSaveDatas = new ArrayList<DynamicObject>(16);
        DynamicObject billData = this.setSaveBillValue(rptInfo);
        if (billData != null) {
            needSaveDatas.add(billData);
        }
        return needSaveDatas;
    }

    private DynamicObject modifyApproveBill(Long approveBillId, ApproveBillSubMitInfo rptInfo) {
        DynamicObject billData = BusinessDataServiceHelper.newDynamicObject((String)ApproveBillCommon.getFormId((ApproveBillSubMitInfo)rptInfo));
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)approveBillId, (DynamicObjectType)billData.getDynamicObjectType());
        this.setHeadFields(bill, rptInfo);
        bill.set("modifier", (Object)UserUtils.getUserId());
        bill.set("modifydate", (Object)new Date());
        return bill;
    }

    protected void saveReportData(ApproveBillSubMitInfo rptInfo) {
    }

    private String getCodeRuleNumber(DynamicObject billData, String entityNumber) {
        ICodeRuleService service = (ICodeRuleService)ServiceFactory.getService((String)"ICodeRuleService");
        return service.getNumber(entityNumber, billData, null);
    }

    public DynamicObject setSaveBillValue(ApproveBillSubMitInfo rptInfo) {
        DynamicObject billData = BusinessDataServiceHelper.newDynamicObject((String)ApproveBillCommon.getFormId((ApproveBillSubMitInfo)rptInfo));
        this.setHeadFields(billData, rptInfo);
        this.setEntryFields(billData, rptInfo);
        ApproveBillCommon.log((String)"begin setNumberField", (Log)log);
        this.setNumberField(billData, rptInfo);
        return billData;
    }

    private void setNumberField(DynamicObject billData, ApproveBillSubMitInfo rptInfo) {
        String formId = ApproveBillCommon.getFormId((ApproveBillSubMitInfo)rptInfo);
        String number = this.getCodeRuleNumber(billData, formId);
        if (StringUtils.isEmpty((String)number)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u8bbe\u7f6e\u7f16\u7801\u89c4\u5219\u3002", (String)"ApproveBillAutoCreate_1", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        billData.set("billno", (Object)number);
    }

    private void setEntryFields(DynamicObject billData, ApproveBillSubMitInfo rptInfo) {
        DynamicObjectCollection entryCollect = billData.getDynamicObjectCollection("entryentity");
        Set tempids = ApproveBillCommon.getTempIds((Collection)rptInfo.getRptTemps());
        if (tempids == null || tempids.size() == 0) {
            return;
        }
        int seq = 0;
        for (Long tempid : tempids) {
            DynamicObject entry = entryCollect.addNew();
            entry.set("seq", (Object)seq);
            ++seq;
            entry.set("tempid", (Object)tempid);
        }
    }

    private void setHeadFields(DynamicObject billData, ApproveBillSubMitInfo rptInfo) {
        billData.set("modelid", (Object)rptInfo.getSubmitDims().getModelId());
        billData.set("eborgid", (Object)rptInfo.getSubmitDims().getOrgId());
        billData.set("createrid", (Object)UserUtils.getUserId());
        billData.set("createorgid", (Object)rptInfo.getCreateOrgId());
        billData.set("department", (Object)rptInfo.getDepartment());
        billData.set("position", (Object)rptInfo.getPosition());
        billData.set("createdate", (Object)TimeServiceHelper.now());
        billData.set("eborgmasterid", (Object)this.getOrgMasterId(rptInfo));
        billData.set("approveinfo", (Object)rptInfo.getApproveNote());
        billData.set("billtype", (Object)"2");
        billData.set("billstatus", (Object)"A");
        billData.set("handler", (Object)UserUtils.getUserId());
        billData.set("dealdate", (Object)TimeServiceHelper.now());
        billData.set("source", (Object)((ApproveBillRptTemp)rptInfo.getRptTemps().iterator().next()).getTaskListId());
        if ("eb_approvebill".equals(ApproveBillCommon.getFormId((ApproveBillSubMitInfo)rptInfo))) {
            billData.set("approvaltype", (Object)rptInfo.getApprovalType());
            billData.set("bizmodelid", (Object)rptInfo.getSubmitDims().getBizModelId());
            billData.set("committype", (Object)rptInfo.getSubmitDims().getCommitType());
            billData.set("selectorg", (Object)rptInfo.getSubmitDims().getSelectOrg());
            billData.set("approvetype", (Object)rptInfo.getApproveType());
            billData.set("approvetypeversion", (Object)rptInfo.getApproveTypeVersion());
            String billType = billData.getString("splitbilltype");
            if (!CentralBillType.Reject.getNumber().equals(billType)) {
                billData.set("splitbilltype", (Object)CentralBillType.Normal.getNumber());
            }
            ApproveBillHelper.setSortVal((DynamicObject)billData);
            HashSet<Long> bailOrgIds = rptInfo.getBailOrgIds();
            if (bailOrgIds == null) {
                BailOrgRelation bailOrgRelation;
                bailOrgIds = new HashSet<Long>(16);
                Member member = ApproveBillCommon.getOrgMember((ApproveBillSubMitInfo)rptInfo, null);
                if (member != null && (bailOrgRelation = BailOrgService.getInstance().getBailOrgRelation(rptInfo.getSubmitDims().getModelId(), member.getNumber())) != null) {
                    Long bailOrgId = bailOrgRelation.getDefaultBailId();
                    bailOrgIds.add(bailOrgId);
                }
            }
            DynamicObjectCollection bailOrg = billData.getDynamicObjectCollection("entryentity_bailorg");
            bailOrg.clear();
            bailOrgIds.forEach(e -> {
                DynamicObject dynamicObject = bailOrg.addNew();
                dynamicObject.set("bail_org", e);
            });
        }
        this.setHeasFieldsSpec(billData, rptInfo);
    }

    protected void setHeasFieldsSpec(DynamicObject billData, ApproveBillSubMitInfo rptInfo) {
        billData.set("orgviewid", (Object)rptInfo.getSubmitDims().getViewId());
        billData.set("rptProcessType", (Object)rptInfo.getRptProcessType());
        billData.set("dim_period", (Object)rptInfo.getSubmitDims().getYearPeriodId());
        billData.set("dim_datatype", (Object)rptInfo.getSubmitDims().getDataTypeId());
        billData.set("dim_version", (Object)rptInfo.getSubmitDims().getVersionId());
    }

    private Long getOrgMasterId(ApproveBillSubMitInfo rptInfo) {
        QFilter qFilter = new QFilter("model", "=", (Object)rptInfo.getSubmitDims().getModelId());
        qFilter = qFilter.and(new QFilter("id", "=", (Object)rptInfo.getSubmitDims().getOrgId()));
        String strSelectFields = "id,owner ";
        DynamicObject dy = QueryServiceHelper.queryOne((String)"epm_entitymembertree", (String)strSelectFields, (QFilter[])new QFilter[]{qFilter});
        if (dy == null) {
            return 0L;
        }
        return dy.getLong("owner.id");
    }

    private Map<Long, Long> getTaskApproveTypeId(Set<Long> taskIds) {
        HashMap<Long, Long> map = new HashMap<Long, Long>(16);
        if (CollectionUtils.isEmpty(taskIds)) {
            return map;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid,fapprovaltypeid from t_eb_task where ", new Object[0]);
        sqlBuilder.appendIn("fid", taskIds.toArray());
        try (DataSet ds = DB.queryDataSet((String)"getTaskApproveTypeId", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);){
            while (ds.hasNext()) {
                Row next = ds.next();
                map.put(next.getLong("fid"), next.getLong("fapprovaltypeid"));
            }
        }
        return map;
    }

    private Long getDefaultApproveType() {
        if (this.defaultApproveType == null) {
            this.defaultApproveType = ApproveTypeUtils.getInstance().getDefaultApproveType();
        }
        return this.defaultApproveType;
    }
}

