/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.approveBill;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.approveBill.RejectOnReportService;
import kd.epm.eb.business.approvetype.ApproveUtils;
import kd.epm.eb.business.task.service.BgTaskDeployListService;
import kd.epm.eb.business.taskflow.TaskFlowServiceHelper;
import kd.epm.eb.common.approveBill.ApproveBillCommon;
import kd.epm.eb.common.approveBill.ApproveBillQuery;
import kd.epm.eb.common.approveBill.Entity.ApproveBillInfo;
import kd.epm.eb.common.approveBill.Entity.ApproveBillRptTemp;
import kd.epm.eb.common.approveBill.Entity.ApproveBillStatus;
import kd.epm.eb.common.approveBill.Entity.ApproveBillSubMitDim;
import kd.epm.eb.common.approveBill.Entity.ApproveBillSubMitInfo;
import kd.epm.eb.common.approveBill.Entity.CentralBillType;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.ebcommon.common.enums.RangeEnum;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.task.ReportOperationEnum;
import kd.epm.eb.common.reportprocess.helper.ApproveBillHelper;
import kd.epm.eb.common.reportprocess.helper.MemberHelper;
import kd.epm.eb.common.reportprocess.service.impl.ReportProcessAggService;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.ebSpread.common.util.StringUtil;

public class CommitCheck {
    private static final Log log = LogFactory.getLog(CommitCheck.class);

    public boolean checkCommitRptTempNotValiad(ApproveBillSubMitInfo bgmBill, ApproveBillInfo refApproveBillInfo, OperationResult out_refResult) {
        if (bgmBill.getRptTemps() == null) {
            return true;
        }
        if (this.checkHasNoSaveRpt(bgmBill.getRptTemps(), out_refResult)) {
            return true;
        }
        if (this.checkReadonlyTemplate(bgmBill.getRptTemps(), out_refResult)) {
            return true;
        }
        if (!"orgcommit".equals(bgmBill.getBtnKey()) && this.checkIsNotSameOrg(bgmBill.getRptTemps(), out_refResult)) {
            return true;
        }
        if (this.checkAppproveBillsIsNotOk(bgmBill, refApproveBillInfo, out_refResult)) {
            return true;
        }
        if (this.checkPreTask(bgmBill, out_refResult)) {
            return true;
        }
        if (this.checkChildStatusCannotSubmit(bgmBill, out_refResult)) {
            return true;
        }
        return this.checkReportLocked(bgmBill.getRptTemps(), out_refResult);
    }

    public boolean checkChildStatusCannotSubmit(ApproveBillSubMitInfo bgmBill, OperationResult out_refResult) {
        ApproveBillSubMitDim submitDims = bgmBill.getSubmitDims();
        Long modelId = submitDims.getModelId();
        Long viewId = submitDims.getViewId();
        Long periodId = submitDims.getYearPeriodId();
        Long dataTypeId = submitDims.getDataTypeId();
        Long versionId = submitDims.getVersionId();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        HashMap<Long, Set> orgMap = new HashMap<Long, Set>(16);
        for (ApproveBillRptTemp rptTemp : bgmBill.getRptTemps()) {
            Set entityIdSetByRange = (Set)orgMap.get(rptTemp.getOrgId());
            if (!CollectionUtils.isEmpty((Collection)entityIdSetByRange) || !CollectionUtils.isNotEmpty((Collection)(entityIdSetByRange = MemberHelper.getEntityIdSetByView((IModelCacheHelper)modelCacheHelper, (Long)viewId, (Long)rptTemp.getOrgId(), (Integer)RangeEnum.VALUE_40.getValue())))) continue;
            orgMap.put(rptTemp.getOrgId(), entityIdSetByRange);
        }
        if (orgMap == null || orgMap.isEmpty()) {
            return false;
        }
        int rptProcessType = bgmBill.getRptProcessType();
        Long taskListId = ((ApproveBillRptTemp)bgmBill.getRptTemps().iterator().next()).getTaskListId();
        String title = ResManager.loadKDString((String)"\u4e0b\u7ea7\u7ec4\u7ec7\u5b58\u5728\u672a\u63d0\u4ea4\u62a5\u8868", (String)"CommitCheck_2", (String)"epm-eb-business", (Object[])new Object[0]);
        String tips = ResManager.loadKDString((String)"\u4e0b\u7ea7\u7ec4\u7ec7\u5b58\u5728\u672a\u63d0\u4ea4\u62a5\u8868\uff0c\u7981\u6b62\u4e0a\u7ea7\u7ec4\u7ec7\u63d0\u4ea4\u3002", (String)"CommitCheck_1", (String)"epm-eb-business", (Object[])new Object[0]);
        if (ProcessTypeEnum.REPORT.getIndex() == rptProcessType) {
            QFilter qFilter = new QFilter("id", "=", (Object)taskListId).and("model", "=", (Object)modelId);
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_rptscheme", (String)"commitcheck", (QFilter[])qFilter.toArray());
            if (dynamicObject != null) {
                boolean commitcheck = dynamicObject.getBoolean("commitcheck");
                if (!commitcheck) {
                    return false;
                }
                boolean b = ReportProcessAggService.getInstance().checkCurrentSchemeCanOperation(viewId, periodId, dataTypeId, versionId, modelId, taskListId, orgMap, true);
                if (!b) {
                    ApproveBillCommon.addErrIntoResult((String)title, (String)tips, (OperationResult)out_refResult);
                    return true;
                }
            }
        } else {
            QFilter qFilter = new QFilter("id", "=", (Object)taskListId).and("model", "=", (Object)modelId);
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_tasklist", (String)"commitcheck", (QFilter[])qFilter.toArray());
            if (dynamicObject != null) {
                boolean commitcheck = dynamicObject.getBoolean("commitcheck");
                if (!commitcheck) {
                    return false;
                }
                boolean b = ReportProcessAggService.getInstance().checkCurrentTaskCanOperation(viewId, periodId, dataTypeId, versionId, modelId, taskListId, orgMap, true);
                if (!b) {
                    ApproveBillCommon.addErrIntoResult((String)title, (String)tips, (OperationResult)out_refResult);
                    return true;
                }
            }
        }
        return false;
    }

    public boolean checkCurrentSchemeOrTaskEntityReportCanOperation(Long modelId, Long schemeId, Long taskListId, ProcessTypeEnum processTypeEnum, Long entityViewId, Long periodId, Long dataTypeId, Long versionId, Map<Long, Set<Long>> orgMap, IFormView formView, OperationResult out_refResult, boolean isSumbit) {
        if (ProcessTypeEnum.REPORT == processTypeEnum) {
            QFilter qFilter = new QFilter("id", "=", (Object)schemeId).and("model", "=", (Object)modelId);
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_rptscheme", (String)"commitcheck", (QFilter[])qFilter.toArray());
            if (dynamicObject != null) {
                boolean commitcheck = dynamicObject.getBoolean("commitcheck");
                if (!commitcheck) {
                    return true;
                }
                boolean b = ReportProcessAggService.getInstance().checkCurrentSchemeCanOperation(entityViewId, periodId, dataTypeId, versionId, modelId, schemeId, orgMap, isSumbit);
                if (!b) {
                    String msg = ResManager.loadKDString((String)"\u4e0b\u7ea7\u7ec4\u7ec7\u5b58\u5728\u672a\u63d0\u4ea4\u62a5\u8868\uff0c\u7981\u6b62\u4e0a\u7ea7\u7ec4\u7ec7\u63d0\u4ea4\u3002", (String)"CommitCheck_1", (String)"epm-eb-business", (Object[])new Object[0]);
                    if (formView != null) {
                        formView.showErrorNotification(msg);
                    } else if (out_refResult != null) {
                        if (isSumbit) {
                            String title = ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff1a", (String)"BgApplyBillPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                            ApproveBillCommon.addErrIntoResult((String)title, (String)msg, (OperationResult)out_refResult);
                        } else {
                            String title = ResManager.loadKDString((String)"\u64a4\u9500\u68c0\u67e5", (String)"CommitCheck_9", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                            msg = ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\u5df2\u63d0\u4ea4\uff0c\u65e0\u6cd5\u64a4\u9500\u6216\u53cd\u5ba1\u6838\u3002", (String)"CommitCheck_6", (String)"epm-eb-business", (Object[])new Object[0]);
                            ApproveBillCommon.addErrIntoResult((String)title, (String)msg, (OperationResult)out_refResult);
                        }
                    }
                    return false;
                }
            }
        } else {
            QFilter qFilter = new QFilter("id", "=", (Object)taskListId).and("model", "=", (Object)modelId);
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_tasklist", (String)"commitcheck", (QFilter[])qFilter.toArray());
            if (dynamicObject != null) {
                boolean commitcheck = dynamicObject.getBoolean("commitcheck");
                if (!commitcheck) {
                    return true;
                }
                boolean b = ReportProcessAggService.getInstance().checkCurrentTaskCanOperation(entityViewId, periodId, dataTypeId, versionId, modelId, taskListId, orgMap, isSumbit);
                if (!b) {
                    String msg = ResManager.loadKDString((String)"\u4e0b\u7ea7\u7ec4\u7ec7\u5b58\u5728\u672a\u63d0\u4ea4\u62a5\u8868\uff0c\u7981\u6b62\u4e0a\u7ea7\u7ec4\u7ec7\u63d0\u4ea4\u3002", (String)"CommitCheck_1", (String)"epm-eb-business", (Object[])new Object[0]);
                    if (formView != null) {
                        formView.showErrorNotification(msg);
                    } else if (out_refResult != null) {
                        if (isSumbit) {
                            String title = ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff1a", (String)"BgApplyBillPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                            ApproveBillCommon.addErrIntoResult((String)title, (String)msg, (OperationResult)out_refResult);
                        } else {
                            String title = ResManager.loadKDString((String)"\u64a4\u9500\u68c0\u67e5", (String)"CommitCheck_9", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                            msg = ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\u5df2\u63d0\u4ea4\uff0c\u65e0\u6cd5\u64a4\u9500\u6216\u53cd\u5ba1\u6838\u3002", (String)"CommitCheck_6", (String)"epm-eb-business", (Object[])new Object[0]);
                            ApproveBillCommon.addErrIntoResult((String)title, (String)msg, (OperationResult)out_refResult);
                        }
                    }
                }
            }
        }
        return true;
    }

    public boolean checkCurrentSchemeOrTaskEntityReeportCanOperationByTaskOrSchemeAssign(Long tasklisIdOrSchemeAssignId, OperationResult out_refResult, boolean isSumbit, Long orgId) {
        if (IDUtils.isNull((Long)tasklisIdOrSchemeAssignId)) {
            return true;
        }
        Long modelId = null;
        Long viewId = null;
        Long period = null;
        Long version = null;
        Long datatype = null;
        Long source = null;
        Long orgid = null;
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_schemeassign", (String)"id, scheme.id,scheme.model.id, year.id,  datatype.id,  version.id, scheme.orgview.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)tasklisIdOrSchemeAssignId)});
        if (dynamicObject != null) {
            modelId = dynamicObject.getLong("scheme.model.id");
            period = dynamicObject.getLong("year.id");
            version = dynamicObject.getLong("version.id");
            datatype = dynamicObject.getLong("datatype.id");
            orgid = orgId;
            viewId = dynamicObject.getLong("scheme.orgview.id");
            source = dynamicObject.getLong("scheme.id");
            return this.checkByReportCondition(out_refResult, isSumbit, modelId, viewId, period, version, datatype, source, orgid);
        }
        DynamicObject query = QueryServiceHelper.queryOne((String)"eb_tasklist", (String)"year.id, version.id,datatype.id,orgview.id,id,model.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)tasklisIdOrSchemeAssignId)});
        if (query != null) {
            modelId = query.getLong("model.id");
            period = query.getLong("year.id");
            version = query.getLong("version.id");
            datatype = query.getLong("datatype.id");
            orgid = orgId;
            viewId = query.getLong("orgview.id");
            source = query.getLong("id");
            return this.checkByReportCondition(out_refResult, isSumbit, modelId, viewId, period, version, datatype, source, orgid);
        }
        return true;
    }

    public boolean checkCurrentSchemeOrTaskEntityReportCanOperation(Long approveBillId, OperationResult out_refResult, boolean isSumbit) {
        String fields = "modelid, dim_period, dim_version, dim_datatype, orgviewid, eborgid,source";
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_approvebill", (String)fields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)approveBillId)});
        Long modelId = null;
        Long viewId = null;
        Long period = null;
        Long version = null;
        Long datatype = null;
        Long source = null;
        Long orgid = null;
        if (dynamicObject != null) {
            period = dynamicObject.getLong("dim_period");
            version = dynamicObject.getLong("dim_version");
            datatype = dynamicObject.getLong("dim_datatype");
            orgid = dynamicObject.getLong("eborgid");
            modelId = dynamicObject.getLong("modelid");
            viewId = dynamicObject.getLong("orgviewid");
            source = dynamicObject.getLong("source");
        }
        return this.checkByReportCondition(out_refResult, isSumbit, modelId, viewId, period, version, datatype, source, orgid);
    }

    private boolean checkByReportCondition(OperationResult out_refResult, boolean isSumbit, Long modelId, Long viewId, Long period, Long version, Long datatype, Long source, Long orgid) {
        if (IDUtils.isNotNull((Long)source)) {
            QFilter qFilter = new QFilter("id", "=", (Object)source).and("model", "=", (Object)modelId);
            DynamicObject schemeDynamic = QueryServiceHelper.queryOne((String)"eb_rptscheme", (String)"id,commitcheck", (QFilter[])qFilter.toArray());
            if (schemeDynamic != null) {
                boolean commitcheck = schemeDynamic.getBoolean("commitcheck");
                if (!commitcheck) {
                    return true;
                }
                IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
                HashMap<Long, Set<Long>> orgMap = new HashMap<Long, Set<Long>>(16);
                Set<Object> entityIdSetByRange = new HashSet(16);
                if (isSumbit) {
                    entityIdSetByRange = MemberHelper.getEntityIdSetByView((IModelCacheHelper)modelCacheHelper, (Long)viewId, (Long)orgid, (Integer)RangeEnum.VALUE_40.getValue());
                } else {
                    List parents;
                    Member member = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), viewId, orgid);
                    if (member != null && CollectionUtils.isNotEmpty((Collection)(parents = modelCacheHelper.getParents(viewId, member, false)))) {
                        entityIdSetByRange = parents.stream().map(x -> x.getId()).collect(Collectors.toSet());
                    }
                }
                if (CollectionUtils.isNotEmpty(entityIdSetByRange)) {
                    orgMap.put(orgid, entityIdSetByRange);
                }
                if (orgMap.isEmpty()) {
                    return true;
                }
                return this.checkCurrentSchemeOrTaskEntityReportCanOperation(modelId, schemeDynamic.getLong("id"), 0L, ProcessTypeEnum.REPORT, viewId, period, datatype, version, orgMap, null, out_refResult, isSumbit);
            }
            DynamicObject taskDyna = QueryServiceHelper.queryOne((String)"eb_tasklist", (String)"id,commitcheck", (QFilter[])qFilter.toArray());
            if (taskDyna != null) {
                boolean commitcheck = taskDyna.getBoolean("commitcheck");
                if (!commitcheck) {
                    return true;
                }
                IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
                HashMap<Long, Set<Long>> orgMap = new HashMap<Long, Set<Long>>(16);
                Set<Object> entityIdSetByRange = new HashSet(16);
                if (isSumbit) {
                    entityIdSetByRange = MemberHelper.getEntityIdSetByView((IModelCacheHelper)modelCacheHelper, (Long)viewId, (Long)orgid, (Integer)RangeEnum.VALUE_40.getValue());
                } else {
                    List parents;
                    Member member = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), viewId, orgid);
                    if (member != null && CollectionUtils.isNotEmpty((Collection)(parents = modelCacheHelper.getParents(viewId, member, false)))) {
                        entityIdSetByRange = parents.stream().map(x -> x.getId()).collect(Collectors.toSet());
                    }
                }
                if (CollectionUtils.isNotEmpty(entityIdSetByRange)) {
                    orgMap.put(orgid, entityIdSetByRange);
                }
                if (orgMap.isEmpty()) {
                    return true;
                }
                return this.checkCurrentSchemeOrTaskEntityReportCanOperation(modelId, 0L, taskDyna.getLong("id"), ProcessTypeEnum.TASK, viewId, period, datatype, version, orgMap, null, out_refResult, isSumbit);
            }
        }
        return true;
    }

    private boolean checkPreTask(ApproveBillSubMitInfo bgmBill, OperationResult out_refResult) {
        if (bgmBill.getRptProcessType() != 1) {
            return false;
        }
        Long modelId = bgmBill.getSubmitDims().getModelId();
        Long orgId = bgmBill.getSubmitDims().getOrgId();
        Long viewId = bgmBill.getSubmitDims().getViewId();
        Collection rptTemps = bgmBill.getRptTemps();
        if (CollectionUtils.isNotEmpty((Collection)rptTemps)) {
            Set<Long> subTaskIds = rptTemps.stream().map(ApproveBillRptTemp::getSubTaskId).collect(Collectors.toSet());
            String errInfo = BgTaskDeployListService.getInstance().checkTaskMonitor(modelId, subTaskIds, ReportOperationEnum.SUBMIT, orgId, viewId);
            if (StringUtils.isNotEmpty((String)errInfo)) {
                String title = ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff1a", (String)"BgApplyBillPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                ApproveBillCommon.addErrIntoResult((String)title, (String)errInfo, (OperationResult)out_refResult);
                return true;
            }
        }
        return false;
    }

    private boolean checkAppproveBillsIsNotOk(ApproveBillSubMitInfo bgmBill, ApproveBillInfo refApproveBillInfo, OperationResult out_refResult) {
        Map<Long, ApproveBillInfo> approveBillInfos = this.getApproveBillInfos(bgmBill);
        if (this.checkReportStatusNotOk(bgmBill, approveBillInfos, out_refResult)) {
            return true;
        }
        return this.checkHasAppproveBill(bgmBill, refApproveBillInfo, out_refResult);
    }

    private boolean checkHasAppproveBill(ApproveBillSubMitInfo bgmBill, ApproveBillInfo refApproveBillInfo, OperationResult out_refResult) {
        Boolean result = false;
        if (refApproveBillInfo != null && refApproveBillInfo.isCentralBill()) {
            return false;
        }
        HashSet needReSubmitBills = new HashSet(16);
        QFilter qFilter = this.getQFilter(bgmBill.getSubmitDims());
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"eb_approvebill", (String)"id,billno,entryentity,billstatus", (QFilter[])qFilter.toArray());
        if (dynamicObjectCollection != null && !dynamicObjectCollection.isEmpty()) {
            String title = ResManager.loadKDString((String)"\u68c0\u67e5\u62a5\u8868\u662f\u5426\u5b58\u5728\u5ba1\u6279\u5355", (String)"CommitCheck_1", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                String billno = (String)dynamicObject.get("billno");
                String billstatus = dynamicObject.getString("billstatus");
                if (!(StringUtil.equals((String)"A", (String)billstatus) || StringUtil.equals((String)"C", (String)billstatus) || StringUtil.equals((String)"F", (String)billstatus))) {
                    String message = ResManager.loadResFormat((String)"\u5f53\u524d\u63d0\u4ea4\u7684\u62a5\u8868\u5df2\u7ecf\u5b58\u5728\u5ba1\u6279\u5355\u201c%1\u201d\u3002", (String)"CommitCheck_2", (String)"epm-eb-formplugin", (Object[])new Object[]{billno});
                    ApproveBillCommon.addErrIntoResult((String)title, (String)message, (OperationResult)out_refResult);
                    result = true;
                    continue;
                }
                if (!StringUtil.equals((String)"A", (String)billstatus) && !StringUtil.equals((String)"C", (String)billstatus)) continue;
            }
        }
        bgmBill.setNeedReSubmitBills(needReSubmitBills);
        return result;
    }

    public QFilter getQFilter(ApproveBillSubMitDim approveBillSubMitDim) {
        QFilter qFilter = new QFilter("modelid", "=", (Object)approveBillSubMitDim.getModelId());
        qFilter.and("dim_period", "=", (Object)approveBillSubMitDim.getYearPeriodId());
        qFilter.and("dim_version", "=", (Object)approveBillSubMitDim.getVersionId());
        qFilter.and("dim_datatype", "=", (Object)approveBillSubMitDim.getDataTypeId());
        qFilter.and("entryentity.tempid", "in", (Object)approveBillSubMitDim.getTempIds());
        qFilter.and("eborgid", "=", (Object)approveBillSubMitDim.getOrgId());
        qFilter.and("centralbilltype", "!=", (Object)CentralBillType.Child.getNumber());
        qFilter.and("billstatus", "!=", (Object)ApproveBillStatus.DISCARD.getNumber());
        return qFilter;
    }

    public QFilter getQFilterNew(ApproveBillSubMitDim approveBillSubMitDim) {
        QFilter qFilter = new QFilter("modelid", "=", (Object)approveBillSubMitDim.getModelId());
        qFilter.and("dim_period", "=", (Object)approveBillSubMitDim.getYearPeriodId());
        qFilter.and("dim_version", "=", (Object)approveBillSubMitDim.getVersionId());
        qFilter.and("dim_datatype", "=", (Object)approveBillSubMitDim.getDataTypeId());
        qFilter.and("eborgid", "=", (Object)approveBillSubMitDim.getOrgId());
        qFilter.and("centralbilltype", "!=", (Object)CentralBillType.Child.getNumber());
        qFilter.and("billstatus", "!=", (Object)ApproveBillStatus.DISCARD.getNumber());
        return qFilter;
    }

    private boolean checkHasNoSaveRpt(Collection<ApproveBillRptTemp> rptTemps, OperationResult out_refResult) {
        if (rptTemps == null) {
            return false;
        }
        boolean returns = false;
        String title = ResManager.loadKDString((String)"\u68c0\u67e5\u62a5\u8868\u662f\u5426\u7f16\u8f91", (String)"CommitCheck_4", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        for (ApproveBillRptTemp rptTemp : rptTemps) {
            if (rptTemp.getRptId() != null && rptTemp.getRptId().compareTo(0L) != 0) continue;
            String message = ResManager.loadResFormat((String)"\u62a5\u8868\u201c%1\u201d\u5c1a\u672a\u7f16\u8f91\u3002", (String)"CommitCheck_5", (String)"epm-eb-formplugin", (Object[])new Object[]{rptTemp.getTempName()});
            ApproveBillCommon.addErrIntoResult((String)title, (String)message, (OperationResult)out_refResult);
            returns = true;
        }
        return returns;
    }

    private boolean checkReadonlyTemplate(Collection<ApproveBillRptTemp> rptTemps, OperationResult out_refResult) {
        DynamicObjectCollection dynamicObjects;
        boolean hasReadOnly = false;
        if (rptTemps != null && rptTemps.size() > 0 && (dynamicObjects = QueryServiceHelper.query((String)"eb_templateentity", (String)"id, number, name", (QFilter[])new QFilter[]{new QFilter("id", "in", rptTemps.stream().map(ApproveBillRptTemp::getTempId).collect(Collectors.toSet())), new QFilter("isreadonly", "=", (Object)Boolean.TRUE)})) != null && dynamicObjects.size() > 0) {
            if (dynamicObjects.size() == rptTemps.size()) {
                hasReadOnly = true;
                String title = ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff1a", (String)"BgApplyBillPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                String message = ResManager.loadKDString((String)"\u5206\u6790\u6a21\u677f\u7684\u62a5\u8868\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"CommitCommandCommon_6", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                ApproveBillCommon.addErrIntoResult((String)title, (String)message, (OperationResult)out_refResult);
            } else {
                Set readOnlyTemps = dynamicObjects.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
                rptTemps.removeIf(e -> readOnlyTemps.contains(e.getTempId()));
            }
        }
        return hasReadOnly;
    }

    private Map<Long, ApproveBillInfo> getApproveBillInfos(ApproveBillSubMitInfo bgmBill) {
        Collection rptTemps = bgmBill.getRptTemps();
        if (rptTemps == null) {
            return null;
        }
        ApproveBillQuery billQuery = ApproveBillQuery.getInstance();
        return billQuery.getApproveBillInfos(bgmBill.getSubmitDims(), billQuery.queryBillInfsByIds(ApproveBillCommon.getApproveBillIds((Collection)rptTemps)));
    }

    private boolean checkReportStatusNotOk(ApproveBillSubMitInfo bgmBill, Map<Long, ApproveBillInfo> approveBillInfos, OperationResult out_refResult) {
        Collection rptTemps = bgmBill.getRptTemps();
        if (rptTemps == null) {
            return false;
        }
        boolean returns = false;
        String title = ResManager.loadKDString((String)"\u68c0\u67e5\u62a5\u8868\u7684\u72b6\u6001", (String)"CommitCheck_6", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String message = "";
        for (ApproveBillRptTemp rptTemp : rptTemps) {
            switch (rptTemp.getStatus()) {
                case "3": 
                case "5": {
                    message = ResManager.loadResFormat((String)"\u62a5\u8868\u201c%1\u201d\u5df2\u63d0\u4ea4\u6216\u5df2\u5b8c\u6210\uff0c\u65e0\u9700\u63d0\u4ea4\u3002", (String)"CommitCheck_3", (String)"epm-eb-formplugin", (Object[])new Object[]{rptTemp.getTempName()});
                    ApproveBillCommon.addErrIntoResult((String)title, (String)message, (OperationResult)out_refResult);
                    returns = true;
                    break;
                }
            }
        }
        return returns;
    }

    private boolean checkIsNotSameOrg(Collection<ApproveBillRptTemp> rptTemps, OperationResult out_refResult) {
        if (rptTemps == null || rptTemps.size() <= 1) {
            return false;
        }
        boolean returns = false;
        Long current_org = null;
        String title = ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u63d0\u4ea4\u662f\u5426\u4e3a\u540c\u4e00\u7ec4\u7ec7\u3002", (String)"CommitCheck_7", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        for (ApproveBillRptTemp rptTemp : rptTemps) {
            if (current_org != null && current_org.compareTo(rptTemp.getOrgId()) != 0) {
                returns = true;
                break;
            }
            current_org = rptTemp.getOrgId();
        }
        if (returns) {
            ApproveBillCommon.addErrIntoResult((String)title, (String)ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u540c\u4e00\u4e2a\u7ec4\u7ec7\u7684\u62a5\u8868\u63d0\u4ea4\u3002", (String)"CommitCheck_8", (String)"epm-eb-formplugin", (Object[])new Object[0]), (OperationResult)out_refResult);
        }
        return returns;
    }

    public void canBillDoOperate(ApproveBillSubMitDim submitDim, Long billId, OperationResult out_refResult, String key) {
        ApproveBillQuery queryObj = ApproveBillQuery.getInstance();
        Map appBills = queryObj.getApproveBillInfos(submitDim, 2, false);
        boolean isCentralBill = ApproveBillHelper.isCentralApproveBill((Long)billId);
        boolean isRejectBill = RejectOnReportService.getInstance().isRejectApproveBill(billId);
        if (!StringUtil.equals((String)"submit", (String)key)) {
            if (("unaudit".equals(key) || "delete".equals(key)) && isCentralBill) {
                if ("delete".equals(key) || this.isAllCentralBillApproved(billId)) {
                    ApproveBillCommon.addErrIntoResult((String)ResManager.loadKDString((String)"\u5f52\u53e3\u5355\u636e\u68c0\u67e5", (String)"CommitCheck_16", (String)"epm-eb-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u5f52\u53e3\u5355\u636e\u4e0d\u5141\u8bb8\u6267\u884c\u8be5\u64cd\u4f5c\u3002", (String)"CommitCheck_14", (String)"epm-eb-formplugin", (Object[])new Object[0]), (OperationResult)out_refResult);
                }
            } else if (!"delete".equals(key) && !isCentralBill) {
                String title = ResManager.loadKDString((String)"\u64a4\u9500\u68c0\u67e5", (String)"CommitCheck_9", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                if (ApproveUtils.getInstance().hasCentralBillOnAudit(billId)) {
                    ApproveBillCommon.addErrIntoResult((String)title, (String)ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u5df2\u4ea7\u751f\u5f52\u53e3\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\u3002", (String)"CommitCheck_15", (String)"epm-eb-formplugin", (Object[])new Object[0]), (OperationResult)out_refResult);
                } else if (appBills == null || appBills.isEmpty()) {
                    ApproveBillCommon.addErrIntoResult((String)title, (String)ResManager.loadKDString((String)"\u65e0\u9700\u64a4\u9500\u672a\u63d0\u4ea4\u7684\u5355\u636e\u3002", (String)"CommitCheck_10", (String)"epm-eb-formplugin", (Object[])new Object[0]), (OperationResult)out_refResult);
                } else {
                    String billNo;
                    boolean canOperation = this.checkCurrentSchemeOrTaskEntityReportCanOperation(billId, out_refResult, false);
                    if (canOperation && (billNo = ApproveUtils.getInstance().isParentEntityInApprove(billId)) != null) {
                        String message = ResManager.loadResFormat((String)"\u4e0a\u7ea7\u7ec4\u7ec7\u5df2\u63d0\u4ea4\u5355\u636e\u201c%1\u201d\uff0c\u65e0\u6cd5\u64a4\u9500\u6216\u53cd\u5ba1\u6838\u3002", (String)"CommitCheck_11", (String)"epm-eb-formplugin", (Object[])new Object[]{billNo});
                        ApproveBillCommon.addErrIntoResult((String)title, (String)message, (OperationResult)out_refResult);
                    }
                }
            }
        } else if (!isCentralBill && !isRejectBill) {
            String billNo;
            boolean canOp = this.checkCurrentSchemeOrTaskEntityReportCanOperation(billId, out_refResult, true);
            if (appBills != null && appBills.size() > 0 && canOp && (billNo = ApproveUtils.getInstance().isParentEntityInApprove(billId)) != null) {
                String title = ResManager.loadKDString((String)"\u63d0\u4ea4\u68c0\u67e5", (String)"CommitCheck_12", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                String message = ResManager.loadResFormat((String)"\u65e0\u6cd5\u63d0\u4ea4\uff0c\u56e0\u4e3a\u5b58\u5728\u4e0a\u7ea7\u7ec4\u7ec7\u63d0\u4ea4\u7684\u5355\u636e\u201c%1\u201d\u3002", (String)"CommitCheck_13", (String)"epm-eb-formplugin", (Object[])new Object[]{billNo});
                ApproveBillCommon.addErrIntoResult((String)title, (String)message, (OperationResult)out_refResult);
            }
        }
    }

    private boolean isAllCentralBillApproved(Long billId) {
        QFilter qFilter = new QFilter("id", "=", (Object)billId);
        DynamicObject bill = QueryServiceHelper.queryOne((String)"eb_approvebill", (String)"auditnode, parentbillid", (QFilter[])new QFilter[]{qFilter});
        if (bill == null) {
            return true;
        }
        String node = bill.getString("auditnode");
        Long parentBill = bill.getLong("parentbillid");
        if (StringUtils.isEmpty((String)node) || parentBill == 0L) {
            return true;
        }
        HashSet parentBills = Sets.newHashSet((Object[])new Long[]{parentBill});
        Map subApproveBillLists = ApproveBillHelper.getSubApproveBillLists((Set)parentBills, (boolean)false);
        List subBills = (List)subApproveBillLists.get(parentBill);
        if (subBills == null || subBills.size() == 0) {
            return true;
        }
        for (ApproveBillInfo subBill : subBills) {
            String nodeId = subBill.getNodeId();
            if (!node.equals(nodeId)) continue;
            String billStatus = subBill.getBillStatus();
            if (ApproveBillStatus.AUDIT.getNumber().equals(billStatus)) continue;
            return false;
        }
        return true;
    }

    private boolean checkReportLocked(Collection<ApproveBillRptTemp> rptTemps, OperationResult operationResult) {
        HashSet<Long> taskIds = new HashSet<Long>(16);
        HashMap<Long, Long> reportTaskMap = new HashMap<Long, Long>(16);
        for (ApproveBillRptTemp rptTemp : rptTemps) {
            taskIds.add(rptTemp.getSubTaskId());
            reportTaskMap.put(rptTemp.getRptId(), rptTemp.getSubTaskId());
        }
        HashMap<Long, String> taskMap = new HashMap<Long, String>(16);
        DynamicObjectCollection taskList = QueryServiceHelper.query((String)"eb_task", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", taskIds)});
        for (DynamicObject task : taskList) {
            taskMap.put(task.getLong("id"), task.getString("name"));
        }
        if (taskMap.isEmpty()) {
            return false;
        }
        Map<Long, Set<Long>> lockedOrgRptMap = TaskFlowServiceHelper.getLockedOrgIds(reportTaskMap.keySet());
        if (CollectionUtils.isNotEmpty(lockedOrgRptMap)) {
            StringBuilder message = new StringBuilder();
            message.append(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff1a\u4ee5\u4e0b\u7ec4\u7ec7\u7684\u4efb\u52a1\u672a\u542f\u52a8\uff0c\u8bf7\u68c0\u67e5\u524d\u7f6e\u4efb\u52a1\u662f\u5426\u5df2\u5b8c\u6210\u3002", (String)"BgTaskExecutePlugin_110", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\r\n");
            DynamicObjectCollection orgList = QueryServiceHelper.query((String)"epm_entitymembertree", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", lockedOrgRptMap.keySet())});
            HashSet<String> names = new HashSet<String>(16);
            int i = 0;
            for (DynamicObject org : orgList) {
                Long orgId = org.getLong("id");
                String orgName = org.getString("name");
                Set<Long> lockedRptIds = lockedOrgRptMap.get(orgId);
                for (Long lockedRptId : lockedRptIds) {
                    Long taskId = (Long)reportTaskMap.get(lockedRptId);
                    String taskName = (String)taskMap.get(taskId);
                    if (!names.add(orgName + taskName)) continue;
                    message.append(ResManager.loadResFormat((String)"%1.\u7ec4\u7ec7\uff1a\u201c%2\u201d\uff0c\u5b50\u4efb\u52a1:\u201c%3\u201d\u3002", (String)"BgTaskExecutePlugin_111", (String)"epm-eb-formplugin", (Object[])new Object[]{++i, orgName, taskName}));
                    message.append("\n\r");
                }
            }
            String title = ResManager.loadKDString((String)"\u63d0\u4ea4\u68c0\u67e5", (String)"CommitCheck_12", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            ApproveBillCommon.addErrIntoResult((String)title, (String)message.toString(), (OperationResult)operationResult);
            return true;
        }
        return false;
    }
}

