/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.approveBill;

import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.examinev2.cache.ExamineCache;
import kd.epm.eb.business.examinev2.service.ExamineCheckServiceImpl;
import kd.epm.eb.business.examinev2.service.ExamineServiceImpl;
import kd.epm.eb.business.report.dto.ReportSubmitRequest;
import kd.epm.eb.business.report.dto.ReportSubmitResponse;
import kd.epm.eb.business.report.exception.EpmReportSubmitErrorException;
import kd.epm.eb.common.approveBill.ApproveBillCommon;
import kd.epm.eb.common.approveBill.Entity.ApproveBillRptTemp;
import kd.epm.eb.common.approveBill.Entity.ApproveBillSubMitInfo;
import kd.epm.eb.common.approveBill.Entity.CentralBillFilterInfo;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.enums.TriggerEventEnum;
import kd.epm.eb.common.examine.domain.ExamineDto;
import kd.epm.eb.common.examine.domain.report.ExamineCheckReport;
import kd.epm.eb.common.examine.enums.ExamineCheckResultEnum;
import kd.epm.eb.common.examine.enums.ExamineExecTypeEnum;
import kd.epm.eb.common.examine.request.MultiExamineCheckRequest;
import kd.epm.eb.common.examine.request.ReportCheckRange;
import kd.epm.eb.common.examine.request.ReportCheckRangeRequest;
import kd.epm.eb.common.examine.request.SchemeOrTaskReqeust;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.spread.template.BgTemplate;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.TemplateFactory;
import kd.epm.eb.spread.template.TemplateModelJSONUtil;
import kd.epm.eb.spread.utils.ReportVar.ReportVarUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class CommitExaminCheck {
    private static final Log log = LogFactory.getLog(CommitExaminCheck.class);
    private static final String LOG_PREFIX = "EB-EXAMINE";

    public boolean batchCheckExamine(ExamineExecTypeEnum execTypeEnum, CentralBillFilterInfo refBillFilterInfo, ApproveBillSubMitInfo rptInfo, ReportSubmitRequest reportSubmitRequest, ReportSubmitResponse reportSubmitResponse) {
        Long modelId = reportSubmitRequest.getModelId();
        Collection rptTemps = rptInfo.getRptTemps();
        if (rptTemps == null || rptTemps.size() == 0) {
            return true;
        }
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)rptInfo.getSubmitDims().getModelId());
        Set tempids = ApproveBillCommon.getTempIds((Collection)rptTemps);
        Long taskListId = ProcessTypeEnum.REPORT.getIndex() == rptInfo.getRptProcessType() ? ReportVarUtil.querySchemeAssign((Long)rptInfo.getSubmitDims().getModelId(), (Long)rptInfo.getSubmitDims().getDataTypeId(), (Long)rptInfo.getSubmitDims().getVersionId(), (Long)rptInfo.getSubmitDims().getYearPeriodId(), (Long)((ApproveBillRptTemp)rptInfo.getRptTemps().iterator().next()).getTaskListId()) : ((ApproveBillRptTemp)rptInfo.getRptTemps().iterator().next()).getTaskListId();
        Map varValues = ReportVarUtil.getVarValues((Integer)rptInfo.getRptProcessType(), (Long)rptInfo.getSubmitDims().getModelId(), (Long)taskListId);
        ArrayList<ITemplateModel> templateModels = new ArrayList<ITemplateModel>(tempids.size());
        ExamineCache examineCache = ExamineServiceImpl.getInstance().listExamineFromLocalCache(rptInfo.getSubmitDims().getModelId()).getExamineCache();
        for (Long temp : tempids) {
            ITemplateModel templateModel;
            DynamicObject dyna;
            String data;
            Set<ExamineDto> examineDtos = examineCache.getExamineByTempId(temp);
            if (CollectionUtils.isEmpty(examineDtos) || StringUtils.isEmpty((CharSequence)(data = (String)(dyna = BusinessDataServiceHelper.loadSingle((Object)temp, (String)"eb_templateentity")).get("data"))) || (templateModel = StringUtils.isNotEmpty((CharSequence)data) ? TemplateModelJSONUtil.parseITemplateModel((String)data) : TemplateFactory.buildTemplateModel()) == null) continue;
            templateModel.setTemplateBaseInfo(this.getTemplateBaseInfo(dyna));
            templateModels.add(templateModel);
        }
        if (CollectionUtils.isEmpty(templateModels)) {
            if (ExamineExecTypeEnum.CheckInList == execTypeEnum) {
                reportSubmitResponse.addWarningInfo(ResManager.loadKDString((String)"\u672a\u68c0\u6d4b\u5173\u8054\u7684\u52fe\u7a3d\u5173\u7cfb\u3002", (String)"BgExamineCheckCommand_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            return true;
        }
        return this.doCheckExamine(execTypeEnum, modelId, templateModels, rptInfo, varValues, reportSubmitResponse, taskListId);
    }

    @NotNull
    protected BgTemplate getTemplateBaseInfo(DynamicObject dyna) {
        BgTemplate templateBaseInfo = new BgTemplate();
        templateBaseInfo.setId(Long.valueOf(dyna.getLong("id")));
        templateBaseInfo.setName(dyna.getString("name"));
        templateBaseInfo.setNumber(dyna.getString("number"));
        templateBaseInfo.setDataunit(dyna.getString("dataunit"));
        templateBaseInfo.setModelID(Long.valueOf(dyna.getLong("model.id")));
        templateBaseInfo.setCatalog(Long.valueOf(dyna.getLong("templateCatalog.id")));
        templateBaseInfo.setBizModel(Long.valueOf(dyna.getLong("dataset.businessmodel.id")));
        Object dataset = dyna.get("dataset");
        if (dataset instanceof Long) {
            templateBaseInfo.setDatasetID(Long.valueOf(dyna.getLong("dataset")));
        } else {
            templateBaseInfo.setDatasetID(Long.valueOf(dyna.getDynamicObject("dataset").getLong("id")));
        }
        templateBaseInfo.setVarBase(dyna.getString("varbaseforeb"));
        templateBaseInfo.setIsReadOnly(dyna.getBoolean("isreadonly") ? "1" : "0");
        templateBaseInfo.setIsDimRelation(dyna.getBoolean("isrelation") ? "1" : "0");
        templateBaseInfo.setFloatcalculate(dyna.getBoolean("floatcalculate") ? "1" : "0");
        return templateBaseInfo;
    }

    protected boolean doCheckExamine(ExamineExecTypeEnum execTypeEnum, Long modelId, List<ITemplateModel> templateModels, ApproveBillSubMitInfo rptInfo, Map<String, Map<String, String>> varValues, ReportSubmitResponse reportSubmitResponse, long taskListId) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        MultiExamineCheckRequest multiExamineCheckRequest = new MultiExamineCheckRequest();
        multiExamineCheckRequest.setExecutorId(UserUtils.getUserId());
        multiExamineCheckRequest.setModelId(modelId);
        multiExamineCheckRequest.setTriggerEvent(TriggerEventEnum.BUDGET_TABLE_SUBMIT);
        ArrayList<ReportCheckRange> reportCheckRanges = new ArrayList<ReportCheckRange>(templateModels.size());
        multiExamineCheckRequest.setReportCheckRangeList(reportCheckRanges);
        multiExamineCheckRequest.setProcessTypeEnum(ProcessTypeEnum.REPORT);
        multiExamineCheckRequest.setVarValues(varValues);
        Map<Object, Object> reportProcessMap = Collections.emptyMap();
        if (execTypeEnum == ExamineExecTypeEnum.CheckInList) {
            reportProcessMap = rptInfo.getRptTemps().stream().collect(Collectors.groupingBy(ApproveBillRptTemp::getTempId));
        }
        ArrayList<SchemeOrTaskReqeust> reportList = new ArrayList<SchemeOrTaskReqeust>(16);
        for (ITemplateModel templateModel : templateModels) {
            List<Object> reportIds = new ArrayList(16);
            if (execTypeEnum == ExamineExecTypeEnum.CheckInList) {
                List approveBillRptTemps = (List)reportProcessMap.get(templateModel.getTemplateBaseInfo().getId());
                if (approveBillRptTemps != null) {
                    reportIds = approveBillRptTemps.stream().map(x -> x.getRptId()).collect(Collectors.toList());
                }
            } else {
                reportIds = ApproveBillCommon.getRptIds((Collection)rptInfo.getRptTemps(), (Long)templateModel.getTemplateBaseInfo().getId()).stream().collect(Collectors.toList());
            }
            SchemeOrTaskReqeust schemeOrTaskReqeust = new SchemeOrTaskReqeust();
            schemeOrTaskReqeust.setReportProcessId(reportIds);
            schemeOrTaskReqeust.setReportProcessType(Integer.valueOf(rptInfo.getRptProcessType()));
            schemeOrTaskReqeust.setTaskProcessId(Long.valueOf(taskListId));
            reportList.add(schemeOrTaskReqeust);
        }
        ReportCheckRangeRequest reportCheckRangeRequest = new ReportCheckRangeRequest();
        reportCheckRangeRequest.setModel(modelId);
        reportCheckRangeRequest.setReportList(reportList);
        log.info("{} createRequest cost:{}ms,params:{}", new Object[]{LOG_PREFIX, stopwatch.elapsed(TimeUnit.MILLISECONDS), JsonUtils.getJsonString((Object)reportCheckRangeRequest)});
        stopwatch.reset();
        List<ReportCheckRange> reportCheckRanges1 = ExamineCheckServiceImpl.getInstance().getReportCheckRange(reportCheckRangeRequest);
        log.info("{} getReportCheckRange cost:{}ms,response:{}", new Object[]{LOG_PREFIX, stopwatch.elapsed(TimeUnit.MILLISECONDS), JsonUtils.getJsonString(reportCheckRanges1)});
        stopwatch.reset();
        reportCheckRanges.addAll(reportCheckRanges1);
        if (CollectionUtils.isEmpty(reportCheckRanges)) {
            return true;
        }
        List<ExamineCheckReport> examineCheckReports = ExamineCheckServiceImpl.getInstance().multiCheck(multiExamineCheckRequest);
        boolean result = examineCheckReports.stream().anyMatch(e -> !e.getExamineCheckResultEnum().isPass());
        if (result) {
            reportSubmitResponse.setExamineCheckReports(examineCheckReports);
            boolean match = examineCheckReports.stream().anyMatch(e -> e.getExamineCheckResultEnum() == ExamineCheckResultEnum.NoPass);
            boolean match1 = examineCheckReports.stream().anyMatch(e -> e.getExamineCheckResultEnum() == ExamineCheckResultEnum.NoPassCanAnnotation);
            if (match) {
                throw new EpmReportSubmitErrorException(ResManager.loadKDString((String)"\u52fe\u7a3d\u68c0\u67e5\u672a\u901a\u8fc7\u3002", (String)"BgExamineCheckCommand_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (match1) {
                throw new EpmReportSubmitErrorException(ResManager.loadKDString((String)"\u52fe\u7a3d\u68c0\u67e5\u672a\u901a\u8fc7\uff0c\u4f46\u53ef\u586b\u5199\u6279\u6ce8\uff0c\u8bf7\u5bf9\u672a\u901a\u8fc7\u7684\u62a5\u544a\u586b\u5199\u6279\u6ce8\u8bf4\u660e\u3002", (String)"BgExamineCheckCommand_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            throw new EpmReportSubmitErrorException(ExamineCheckResultEnum.OverRange.getDescription().loadKDString());
        }
        boolean match = examineCheckReports.stream().anyMatch(e -> e.getExamineCheckResultEnum() == ExamineCheckResultEnum.NoPassIgnore);
        boolean match1 = examineCheckReports.stream().allMatch(e -> e.getExamineCheckResultEnum() == ExamineCheckResultEnum.NoExamine);
        if (match) {
            reportSubmitResponse.setExamineCheckReports(examineCheckReports);
            reportSubmitResponse.addWarningInfo(ResManager.loadKDString((String)"\u52fe\u7a3d\u68c0\u67e5\u672a\u901a\u8fc7(\u4e0d\u5f71\u54cd\u63d0\u4ea4)\u3002", (String)"BgExamineCheckCommand_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else if (match1) {
            if (execTypeEnum != ExamineExecTypeEnum.Commit) {
                // empty if block
            }
        } else {
            reportSubmitResponse.addSuccessInfo(ResManager.loadKDString((String)"\u52fe\u7a3d\u68c0\u67e5\u5df2\u901a\u8fc7\u3002", (String)"BgExamineCheckCommand_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        boolean hasAnnotation = examineCheckReports.stream().anyMatch(e -> ExamineCheckResultEnum.Annotation == e.getExamineCheckResultEnum());
        if (hasAnnotation) {
            String msg = ResManager.loadKDString((String)"\u5f53\u524d\u5f85\u5ba1\u6279\u8868\u5b58\u5728\u52fe\u7a3d\u5dee\u5f02\uff0c\u5df2\u6dfb\u52a0\u6279\u6ce8\u8bf4\u660e\uff0c\u8bf7\u5173\u6ce8\u3002", (String)"CommitExaminCheck_0", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            if (StringUtils.isNotEmpty((CharSequence)rptInfo.getApproveNote())) {
                rptInfo.setApproveNote(rptInfo.getApproveNote() + "\r\n" + msg);
            } else {
                rptInfo.setApproveNote(msg);
            }
            reportSubmitResponse.setExamineCheckReports(examineCheckReports);
            reportSubmitResponse.addWarningInfo(msg);
        }
        return true;
    }
}

