/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.approveBill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.approveBill.CommitExaminCheck;
import kd.epm.eb.business.examinev2.service.ExamineCheckServiceImpl;
import kd.epm.eb.business.report.dto.ReportSubmitRequest;
import kd.epm.eb.business.report.dto.ReportSubmitResponse;
import kd.epm.eb.common.approveBill.ApproveBillCommon;
import kd.epm.eb.common.approveBill.Entity.ApproveBillRptTemp;
import kd.epm.eb.common.approveBill.Entity.ApproveBillSubMitInfo;
import kd.epm.eb.common.approveBill.Entity.CentralBillFilterInfo;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.enums.ExamineBehaviorEnum;
import kd.epm.eb.common.enums.ExamineCheckTypeEnum;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.TriggerEventEnum;
import kd.epm.eb.common.examine.domain.ExamineDto;
import kd.epm.eb.common.examine.domain.report.ExamineCheckReport;
import kd.epm.eb.common.examine.enums.ExamineExecTypeEnum;
import kd.epm.eb.common.examine.request.CheckRange;
import kd.epm.eb.common.examine.request.MultiExamineCheckRequest;
import kd.epm.eb.common.examine.request.ReportCheckRange;
import kd.epm.eb.common.examine.request.ReportCheckRangeRequest;
import kd.epm.eb.common.examine.request.SchemeOrTaskReqeust;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.spread.template.BgTemplate;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.TemplateModelJSONUtil;
import kd.epm.eb.spread.template.pagedim.IPageDimensionEntry;
import kd.epm.eb.spread.template.spread.style.MetricCellStyleInfo;
import kd.epm.eb.spread.template.viewpointdim.IViewPointDimensionEntry;
import kd.epm.eb.spread.utils.ReportVar.ReportVarUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class MetricNotNullCheck
extends CommitExaminCheck {
    private static Log log = LogFactory.getLog(MetricNotNullCheck.class);

    @Override
    public boolean batchCheckExamine(ExamineExecTypeEnum execTypeEnum, CentralBillFilterInfo billFilterInfo, ApproveBillSubMitInfo rptInfo, ReportSubmitRequest reportSubmitRequest, ReportSubmitResponse reportSubmitResponse) {
        if (!reportSubmitRequest.isNeedCheckMetricNotNull()) {
            return true;
        }
        Collection rptTemps = rptInfo.getRptTemps();
        if (rptTemps == null || rptTemps.size() == 0) {
            return true;
        }
        ArrayList<ITemplateModel> needCheckNotNullTemplateModels = new ArrayList<ITemplateModel>(16);
        HashMap<Long, Set<ExamineDto>> templateNotNullChcekExamineMap = new HashMap<Long, Set<ExamineDto>>(16);
        Set tempids = ApproveBillCommon.getTempIds((Collection)rptTemps);
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)rptInfo.getSubmitDims().getModelId());
        ProcessTypeEnum processType = ProcessTypeEnum.getProcessTypeByIndex((int)rptInfo.getRptProcessType());
        if (processType == null) {
            log.info("\u62a5\u8868\u7c7b\u578b\u4e3a\u7a7a\u4e0d\u505a\u6784\u5efa\u68c0\u67e5");
            return true;
        }
        Long taskListId = ProcessTypeEnum.REPORT.getIndex() == rptInfo.getRptProcessType() ? ReportVarUtil.querySchemeAssign((Long)rptInfo.getSubmitDims().getModelId(), (Long)rptInfo.getSubmitDims().getDataTypeId(), (Long)rptInfo.getSubmitDims().getVersionId(), (Long)rptInfo.getSubmitDims().getYearPeriodId(), (Long)((ApproveBillRptTemp)rptInfo.getRptTemps().iterator().next()).getTaskListId()) : ((ApproveBillRptTemp)rptInfo.getRptTemps().iterator().next()).getTaskListId();
        Map varValues = ReportVarUtil.getVarValues((Integer)rptInfo.getRptProcessType(), (Long)rptInfo.getSubmitDims().getModelId(), (Long)taskListId);
        HashMap<Long, ReportCheckRange> tempReportCheckRange = new HashMap<Long, ReportCheckRange>(16);
        String selectFields = "id,data,name,number,dataunit,model.id,templateCatalog.id,dataset.businessmodel.id,dataset,varbaseforeb,isreadonly,isrelation,floatcalculate";
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"eb_templateentity", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)tempids)});
        for (DynamicObject dyna : dynamicObjectCollection) {
            ReportCheckRange reportCheckRange;
            Optional<MetricCellStyleInfo> first2;
            Optional<IPageDimensionEntry> first1;
            Optional<IViewPointDimensionEntry> first;
            if (dyna == null) continue;
            Long temp = dyna.getLong("id");
            String data = (String)dyna.get("data");
            if (StringUtils.isEmpty((CharSequence)data)) continue;
            BgTemplate templateBaseInfo = this.getTemplateBaseInfo(dyna);
            ITemplateModel templateModel = TemplateModelJSONUtil.parseITemplateModel((String)data);
            templateModel.setTemplateBaseInfo(templateBaseInfo);
            if (!CollectionUtils.isNotEmpty((Collection)templateModel.getMetricCellStyleInfo()) || dyna.getBoolean("isreadonly") || (first = templateModel.getViewpointmembentry().stream().filter(x -> x.getDimension().getNumber().equals(SysDimensionEnum.Metric.getNumber())).findFirst()).isPresent() || (first1 = templateModel.getPagemembentry().stream().filter(x -> x.getDimension().getNumber().equals(SysDimensionEnum.Metric.getNumber())).findFirst()).isPresent() || !(first2 = templateModel.getMetricCellStyleInfo().stream().filter(x -> x.getMustInput() != null && x.getMustInput() != false).findFirst()).isPresent()) continue;
            boolean editNoLeafCell = Boolean.TRUE;
            ReportCheckRangeRequest reportCheckRangeRequest = new ReportCheckRangeRequest();
            reportCheckRangeRequest.setModel(modelCache.getModelobj().getId());
            reportCheckRangeRequest.setIncludeNotLeaf(Boolean.valueOf(editNoLeafCell));
            ArrayList<SchemeOrTaskReqeust> reportList = new ArrayList<SchemeOrTaskReqeust>(16);
            List reportIds = ApproveBillCommon.getRptIds((Collection)rptInfo.getRptTemps(), (Long)templateModel.getTemplateBaseInfo().getId()).stream().collect(Collectors.toList());
            SchemeOrTaskReqeust schemeOrTaskReqeust = new SchemeOrTaskReqeust();
            schemeOrTaskReqeust.setReportProcessId(reportIds);
            schemeOrTaskReqeust.setReportProcessType(Integer.valueOf(rptInfo.getRptProcessType()));
            schemeOrTaskReqeust.setTaskProcessId(taskListId);
            reportList.add(schemeOrTaskReqeust);
            reportCheckRangeRequest.setReportList(reportList);
            List<ReportCheckRange> reportCheckRangeV1 = ExamineCheckServiceImpl.getInstance().getReportCheckRange(reportCheckRangeRequest);
            HashSet accountSet = new HashSet(16);
            HashSet metricSet = new HashSet(16);
            ArrayList<CheckRange> removeRange = new ArrayList<CheckRange>(16);
            if (CollectionUtils.isEmpty(reportCheckRangeV1) || (reportCheckRange = reportCheckRangeV1.get(0)) == null || CollectionUtils.isEmpty((Collection)reportCheckRange.getCheckRangeList())) continue;
            for (CheckRange checkRange : reportCheckRange.getCheckRangeList()) {
                Optional<Map.Entry> first3 = checkRange.getCheckRange().entrySet().stream().filter(x -> CollectionUtils.isEmpty((Collection)((Collection)x.getValue()))).findFirst();
                if (first3.isPresent()) {
                    removeRange.add(checkRange);
                    continue;
                }
                accountSet.addAll((Collection)checkRange.getCheckRange().get(SysDimensionEnum.Account.getNumber()));
                metricSet.addAll((Collection)checkRange.getCheckRange().get(SysDimensionEnum.Metric.getNumber()));
            }
            reportCheckRange.getCheckRangeList().removeAll(removeRange);
            if (CollectionUtils.isEmpty((Collection)reportCheckRange.getCheckRangeList()) || CollectionUtils.isEmpty(accountSet) || CollectionUtils.isEmpty(metricSet)) continue;
            tempReportCheckRange.put(temp, reportCheckRange);
            needCheckNotNullTemplateModels.add(templateModel);
            HashMap accountMap = new HashMap(16);
            accountMap.put(SysDimensionEnum.Account.getNumber(), accountSet);
            HashSet<ExamineDto> examineDtos = new HashSet<ExamineDto>(16);
            for (int i = 0; i < templateModel.getMetricCellStyleInfo().size(); ++i) {
                MetricCellStyleInfo metricCellStyleInfo = (MetricCellStyleInfo)templateModel.getMetricCellStyleInfo().get(i);
                if (!metricCellStyleInfo.getMustInput().booleanValue() || !metricSet.contains(metricCellStyleInfo.getMetricNumber())) continue;
                StringBuilder sb = new StringBuilder();
                sb.append("@NOTNULL(\"Metric|").append(metricCellStyleInfo.getMetricNumber()).append("\")");
                ExamineDto examineDto = new ExamineDto();
                examineDto.setId(Long.valueOf(GlobalIdUtil.genGlobalLongId()));
                String name = "Metric_" + metricCellStyleInfo.getMetricNumber() + "_" + temp;
                examineDto.setName(name);
                examineDto.setNumber(name);
                examineDto.setDatasetId(templateModel.getTemplateBaseInfo().getDatasetID());
                examineDto.setModelId(templateModel.getTemplateBaseInfo().getModelID());
                examineDto.setMainDimension(SysDimensionEnum.Metric.getNumber());
                examineDto.setFormulaStr(sb.toString());
                examineDto.setScopes(accountMap);
                examineDto.setExamineCheckTypeEnum(ExamineCheckTypeEnum.ABSOLUTE_VALUE);
                examineDto.setTolerance(new BigDecimal("0"));
                examineDto.setExamineBehaviorEnum(ExamineBehaviorEnum.FORBID);
                examineDto.setDisTempIds(Collections.singletonList(temp));
                examineDtos.add(examineDto);
            }
            templateNotNullChcekExamineMap.put(temp, examineDtos);
        }
        if (CollectionUtils.isNotEmpty(needCheckNotNullTemplateModels)) {
            return this.doCheckNotNull(modelCache, needCheckNotNullTemplateModels, rptInfo, varValues, templateNotNullChcekExamineMap, tempReportCheckRange, reportSubmitResponse, processType);
        }
        return true;
    }

    protected boolean doCheckNotNull(IModelCacheHelper modelCache, List<ITemplateModel> templateModels, ApproveBillSubMitInfo rptInfo, Map<String, Map<String, String>> varValues, Map<Long, Set<ExamineDto>> templateNotNullChcekExamineMap, Map<Long, ReportCheckRange> tempReportCheckRange, ReportSubmitResponse reportSubmitResponse, ProcessTypeEnum processTypeEnum) {
        MultiExamineCheckRequest multiExamineCheckRequest = new MultiExamineCheckRequest();
        multiExamineCheckRequest.setExecutorId(UserUtils.getUserId());
        multiExamineCheckRequest.setModelId(modelCache.getModelobj().getId());
        multiExamineCheckRequest.setTriggerEvent(TriggerEventEnum.BUDGET_TABLE_SUBMIT);
        ArrayList<ReportCheckRange> reportCheckRanges = new ArrayList<ReportCheckRange>(templateModels.size());
        multiExamineCheckRequest.setReportCheckRangeList(reportCheckRanges);
        multiExamineCheckRequest.setVarValues(varValues);
        multiExamineCheckRequest.setProcessTypeEnum(processTypeEnum);
        multiExamineCheckRequest.setTemplateMetricNullChcekExamineMap(templateNotNullChcekExamineMap);
        for (ITemplateModel templateModel : templateModels) {
            reportCheckRanges.add(tempReportCheckRange.get(templateModel.getTemplateBaseInfo().getId()));
        }
        if (CollectionUtils.isEmpty(reportCheckRanges)) {
            return true;
        }
        List<ExamineCheckReport> examineCheckReports = ExamineCheckServiceImpl.getInstance().multiCheck(multiExamineCheckRequest);
        boolean result = examineCheckReports.stream().anyMatch(e -> !e.getExamineCheckResultEnum().isPass());
        if (templateNotNullChcekExamineMap != null && result) {
            List collect = examineCheckReports.stream().filter(x -> !x.getExamineCheckResultEnum().isPass()).collect(Collectors.toList());
            reportSubmitResponse.setMetricNotNullCheckReports(examineCheckReports);
            return false;
        }
        return true;
    }
}

