/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.approveBill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.business.approvetype.ApproveUtils;
import kd.epm.eb.business.ebupgrades.utils.UpgradesTaskUtil;
import kd.epm.eb.business.utils.WorkFlowUtil;
import kd.epm.eb.common.approveBill.Entity.ApproveBillStatus;
import kd.epm.eb.common.approveBill.Entity.CentralBillType;
import kd.epm.eb.common.approveBill.RejectOnReport;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.ebcommon.common.enums.RangeEnum;
import kd.epm.eb.common.enums.AuditTypeEnum;
import kd.epm.eb.common.enums.BgTaskStateEnum;
import kd.epm.eb.common.message.MessageUtils;
import kd.epm.eb.common.params.ParamEnum;
import kd.epm.eb.common.params.ParamQueryServiceHelper;
import kd.epm.eb.common.reportprocess.entity.domain.ReportProcess;
import kd.epm.eb.common.reportprocess.helper.ApproveBillHelper;
import kd.epm.eb.common.reportprocess.helper.MemberHelper;
import kd.epm.eb.common.reportprocess.service.impl.ReportProcessAggService;
import kd.epm.eb.common.thread.EpmThreadPools;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;

public class RejectOnReportService {
    private static final Log log = LogFactory.getLog(RejectOnReportService.class);

    private RejectOnReportService() {
    }

    public static RejectOnReportService getInstance() {
        return new RejectOnReportService();
    }

    public void createRejectBill(Set<Long> approveBillIds, Set<Long> rejectRptIds, String opType) {
        log.info("createRejectBill start, approveBillIds={},rejectRptIds={},opType={}", new Object[]{approveBillIds, rejectRptIds, opType});
        Map<RejectOnReport, Set<Long>> rejectOnReportMap = this.getRejectOnReportMap(approveBillIds, rejectRptIds);
        if (CollectionUtils.isEmpty(rejectOnReportMap)) {
            log.info("createRejectBill rejectReportMap is empty");
            return;
        }
        Set<Long> rejectBillIds = this.saveAndSubmitBills(approveBillIds, rejectRptIds, rejectOnReportMap, opType);
        Map<Long, Set<Long>> billRptMap = this.getRejectBillRptMapForCreate(rejectBillIds);
        this.updateReportProcessForCreate(billRptMap, BgTaskStateEnum.UNDERWAY.getNumber());
        this.updateRejectStatus2Submit(approveBillIds, rejectRptIds);
        log.info("createRejectBill finished, approveBillIds={},rejectRptIds={},rejectBillIds={}", new Object[]{approveBillIds, rejectRptIds, rejectBillIds});
    }

    public Map<Long, Set<ReportProcess>> filterEntityRptMap(Map<Long, Set<ReportProcess>> entityRptMap) {
        HashSet<Long> reportIds = new HashSet<Long>(16);
        for (Map.Entry<Long, Set<ReportProcess>> entry : entityRptMap.entrySet()) {
            Set<ReportProcess> reportProcessList = entry.getValue();
            for (ReportProcess reportProcess : reportProcessList) {
                reportIds.add(reportProcess.getId());
            }
        }
        Set<Long> rejectOnReports = this.getRejectOnReports(reportIds);
        if (CollectionUtils.isNotEmpty(rejectOnReports)) {
            HashMap<Long, Set<ReportProcess>> result = new HashMap<Long, Set<ReportProcess>>(entityRptMap.size());
            for (Map.Entry<Long, Set<ReportProcess>> entry : entityRptMap.entrySet()) {
                Set<ReportProcess> reportProcessList = entry.getValue();
                if (CollectionUtils.isEmpty(reportProcessList)) continue;
                LinkedHashSet<ReportProcess> newReportProcessList = new LinkedHashSet<ReportProcess>(16);
                for (ReportProcess process : reportProcessList) {
                    if (rejectOnReports.contains(process.getId())) continue;
                    newReportProcessList.add(process);
                }
                if (newReportProcessList.isEmpty()) continue;
                result.put(entry.getKey(), newReportProcessList);
            }
            return result;
        }
        return entityRptMap;
    }

    public void jump2NodeAfterSubmit(Long rejectBillId, String curNode) {
        QFilter qFilter = new QFilter("approvebill", "=", (Object)rejectBillId);
        DynamicObject rejectBillObj = QueryServiceHelper.queryOne((String)"eb_rejectapprovebill", (String)"rejecttype,rejectnode", (QFilter[])qFilter.toArray());
        if (rejectBillObj == null) {
            return;
        }
        String rejectType = rejectBillObj.getString("rejecttype");
        if ("0".equals(rejectType)) {
            return;
        }
        String rejectNode = rejectBillObj.getString("rejectnode");
        log.info("jump2NodeAfterSubmit businessKey={}, curNode={}, rejectNode={}", new Object[]{rejectBillId, curNode, rejectNode});
        if (Objects.equals(rejectNode, curNode)) {
            return;
        }
        Long flowProcessId = WorkflowServiceHelper.getProcessInstanceIdByBusinessKey((String)rejectBillId.toString());
        WorkflowServiceHelper.jumpToNode((Long)flowProcessId, (String)rejectNode, (String)curNode);
        log.info("jump2NodeAfterSubmit finished, businessKey={}", (Object)rejectBillId);
    }

    public void stopRejectBillWorkFlow(Long rejectBillId, String curNode) {
        DynamicObject rejectBill = BusinessDataServiceHelper.loadSingleFromCache((Object)rejectBillId, (String)"eb_approvebill");
        if (rejectBill == null) {
            return;
        }
        String billType = rejectBill.getString("splitbilltype");
        if (!CentralBillType.Reject.getNumber().equals(billType)) {
            return;
        }
        String auditNode = rejectBill.getString("auditnode");
        log.info("stopRejectBillWorkFlow businessKey={}, curNode={}, auditNode={}", new Object[]{rejectBillId, curNode, auditNode});
        if (!Objects.equals(auditNode, curNode)) {
            return;
        }
        rejectBill.set("billstatus", (Object)ApproveBillStatus.AUDIT.getNumber());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{rejectBill});
        try {
            WorkFlowUtil.stopWorkFlowProcess(Collections.singleton(rejectBillId.toString()));
        }
        catch (Exception ex) {
            log.error("stopRejectBillWorkFlow rejectBillId={}, stopWorkFlowProcess error: {}", (Object)rejectBillId, (Object)ex);
        }
        Map<Long, Long> srcBillMap = this.getSrcApproveBillIds(Collections.singleton(rejectBillId));
        if (CollectionUtils.isEmpty(srcBillMap)) {
            return;
        }
        Map<Long, Set<Long>> rejectRptMap = this.getApproveBillRptMap(Collections.singleton(rejectBillId), null, false);
        if (CollectionUtils.isEmpty(rejectRptMap)) {
            return;
        }
        this.updateRejectStatus2FinishWithMsg(srcBillMap.values(), (Collection<Long>)rejectRptMap.get(rejectBillId));
        this.updateReportProcessForAudit(Collections.singleton(rejectBillId), srcBillMap);
        log.info("stopRejectBillWorkFlow finished, businessKey={}", (Object)rejectBillId);
    }

    public void auditSelfRejectBill(Set<Long> rejectBillIds) {
        if (CollectionUtils.isEmpty(rejectBillIds)) {
            return;
        }
        Map<Long, Set<Long>> rejectRptMap = this.getApproveBillRptMap(rejectBillIds, null, false);
        if (CollectionUtils.isEmpty(rejectRptMap)) {
            return;
        }
        HashSet<Long> rejectRptIds = new HashSet<Long>(16);
        rejectRptMap.values().forEach(ids -> rejectRptIds.addAll((Collection<Long>)ids));
        Map<Long, Long> srcBillMap = this.getSrcApproveBillIds(rejectBillIds);
        if (CollectionUtils.isEmpty(srcBillMap)) {
            return;
        }
        this.updateReportProcessForAudit(rejectBillIds, srcBillMap);
        this.updateRejectStatus2FinishWithMsg(srcBillMap.values(), rejectRptIds);
        log.info("auditSelfRejectBill finished, rejectBillIds={}", rejectBillIds);
    }

    public void deleteRefRejectBills(Set<Long> approveBillIds) {
        QFilter qFilter = new QFilter("rootbillid", "in", approveBillIds);
        DynamicObjectCollection rejectBills = QueryServiceHelper.query((String)"eb_rejectapprovebill", (String)"approvebill,rootbillid", (QFilter[])qFilter.toArray());
        HashSet<Long> rejectBillIds = new HashSet<Long>(16);
        for (DynamicObject rejectBill : rejectBills) {
            Long rejectBillId = rejectBill.getLong("approvebill");
            rejectBillIds.add(rejectBillId);
        }
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"eb_approvebill"), (Object[])rejectBillIds.toArray());
        DeleteServiceHelper.delete((String)"eb_rejectapprovebill", (QFilter[])new QFilter[]{new QFilter("approvebill", "in", rejectBillIds)});
        ApproveUtils.getInstance().deleteReportStatusRecord(rejectBillIds);
    }

    public void discardRefRejectBills(Set<Long> approveBillIds) {
        DynamicObject[] rejectBills;
        QFilter qFilter = new QFilter("rootbillid", "in", approveBillIds);
        DynamicObjectCollection rejectBillList = QueryServiceHelper.query((String)"eb_rejectapprovebill", (String)"approvebill,rootbillid", (QFilter[])qFilter.toArray());
        HashSet<Long> rejectBillIds = new HashSet<Long>(16);
        for (DynamicObject rejectBill : rejectBillList) {
            Long rejectBillId = rejectBill.getLong("approvebill");
            rejectBillIds.add(rejectBillId);
        }
        if (CollectionUtils.isEmpty(rejectBillIds)) {
            return;
        }
        QFilter qFilterV = new QFilter("id", "in", rejectBillIds);
        qFilterV.and(new QFilter("billstatus", "!=", (Object)ApproveBillStatus.DISCARD.getNumber()));
        for (DynamicObject rejectBill : rejectBills = BusinessDataServiceHelper.load((String)"eb_approvebill", (String)"id,billstatus", (QFilter[])qFilterV.toArray())) {
            rejectBill.set("billstatus", (Object)ApproveBillStatus.DISCARD.getNumber());
        }
        SaveServiceHelper.save((DynamicObject[])rejectBills);
    }

    public Map<Long, String> getSrcBillNo(Set<Long> approveBillIds) {
        HashMap<Long, String> srcBillNo = new HashMap<Long, String>(16);
        QFilter qFilter = new QFilter("approvebill", "in", approveBillIds);
        DynamicObjectCollection rejectBills = QueryServiceHelper.query((String)"eb_rejectapprovebill", (String)"approvebill,srcbillno", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isEmpty((Collection)rejectBills)) {
            return srcBillNo;
        }
        for (DynamicObject rejectBill : rejectBills) {
            srcBillNo.put(rejectBill.getLong("approvebill"), rejectBill.getString("srcbillno"));
        }
        return srcBillNo;
    }

    public boolean isOpenRejectOnReport(Long modelId) {
        return ParamQueryServiceHelper.getBoolean((long)modelId, (ParamEnum)ParamEnum.BG034);
    }

    public boolean isMatchNewWorkFlow(Long modelId) {
        boolean isRejectOnReport = ParamQueryServiceHelper.getBoolean((long)modelId, (ParamEnum)ParamEnum.BG034);
        boolean isNewWorkFlow = ParamQueryServiceHelper.getBoolean((long)modelId, (ParamEnum)ParamEnum.BG050);
        return isRejectOnReport && isNewWorkFlow;
    }

    public Map<Long, Set<Long>> getRejectReportProcessIds(Set<Long> approveBillIds) {
        HashMap<Long, Set<Long>> billRejectRptMap = new HashMap<Long, Set<Long>>(approveBillIds.size());
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fapprovebillid, fprocessid from t_eb_approverejectstatus where fisreject in('1','2') and fprocessid != 0 and ", new Object[0]);
        sqlBuilder.appendIn("fapprovebillid", approveBillIds.toArray());
        try (DataSet ds = DB.queryDataSet((String)"getRejectReportProcessIds", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sqlBuilder);){
            while (ds.hasNext()) {
                Row row = ds.next();
                Long billId = row.getLong("fapprovebillid");
                Long processId = row.getLong("fprocessid");
                Set processIds = billRejectRptMap.computeIfAbsent(billId, v -> new HashSet(16));
                processIds.add(processId);
            }
        }
        return billRejectRptMap;
    }

    public Set<String> getRejectBillNos(Set<Long> approveBillIds) {
        QFilter qFilter = new QFilter("id", "in", approveBillIds);
        qFilter.and(new QFilter("splitbilltype", "=", (Object)CentralBillType.Reject.getNumber()));
        qFilter.and("billstatus", "!=", (Object)ApproveBillStatus.DISCARD.getNumber());
        DynamicObjectCollection approveBills = QueryServiceHelper.query((String)"eb_approvebill", (String)"id,billno", (QFilter[])qFilter.toArray());
        HashSet<String> rejectBillNos = new HashSet<String>(approveBills.size());
        for (DynamicObject approveBill : approveBills) {
            rejectBillNos.add(approveBill.getString("billno"));
        }
        return rejectBillNos;
    }

    private Map<RejectOnReport, Set<Long>> getRejectOnReportMap(Set<Long> approveBillIds, Set<Long> rejectRptIds) {
        LinkedHashMap<RejectOnReport, Set<Long>> approveBillMap = new LinkedHashMap<RejectOnReport, Set<Long>>(16);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fprocessid,fapprovebillid,fauditnode,frejectnode from t_eb_approverejectopinion where fdiscard = '0' and fiscurinstance = '1' and ", new Object[0]);
        sqlBuilder.appendIn("fprocessid", rejectRptIds.toArray());
        sqlBuilder.append(" and ", new Object[0]).appendIn("fapprovebillid", approveBillIds.toArray());
        sqlBuilder.append(" order by frejecttime desc", new Object[0]);
        try (DataSet ds = DB.queryDataSet((String)"getRejectReportMap", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sqlBuilder);){
            while (ds.hasNext()) {
                Row row = ds.next();
                Long approveBillId = row.getLong("fapprovebillid");
                String auditNode = row.getString("fauditnode");
                String rejectNode = row.getString("frejectnode");
                if (StringUtils.isNotEmpty((String)rejectNode) && rejectNode.contains("#")) {
                    rejectNode = rejectNode.split("#")[0];
                }
                Long processId = row.getLong("fprocessid");
                RejectOnReport rejectOnReport = new RejectOnReport(approveBillId, auditNode, rejectNode);
                Set processIds = approveBillMap.computeIfAbsent(rejectOnReport, v -> new HashSet(16));
                processIds.add(processId);
            }
        }
        return approveBillMap;
    }

    private Map<Long, Long> getRptTempMap(Set<Long> rejectRptIds) {
        HashMap<Long, Long> rptTempMap = new HashMap<Long, Long>(rejectRptIds.size());
        DynamicObjectCollection reportProcessList = ReportProcessAggService.getInstance().queryReportProcessDynamicList(rejectRptIds, "id,template");
        for (DynamicObject reportProcess : reportProcessList) {
            Long rptId = reportProcess.getLong("id");
            Long tempId = reportProcess.getLong("template");
            rptTempMap.put(rptId, tempId);
        }
        return rptTempMap;
    }

    private Map<Long, Set<Long>> getSrcSubBillMap(Set<Long> approveBillIds) {
        HashMap<Long, Set<Long>> srcSubBillMap = new HashMap<Long, Set<Long>>(approveBillIds.size());
        QFilter qFilter = new QFilter("parentbillid", "in", approveBillIds);
        DynamicObjectCollection rejectBills = QueryServiceHelper.query((String)"eb_approvebill", (String)"id,parentbillid", (QFilter[])qFilter.toArray());
        for (DynamicObject rejectBill : rejectBills) {
            Long subBillId = rejectBill.getLong("id");
            Long srcBillId = rejectBill.getLong("parentbillid");
            Set rejectBillIds = srcSubBillMap.computeIfAbsent(srcBillId, v -> new HashSet(16));
            rejectBillIds.add(subBillId);
        }
        return srcSubBillMap;
    }

    private Set<Long> getTempIds(Set<Long> rejectRptIds, Map<Long, Long> rptTempMap) {
        HashSet<Long> tempIds = new HashSet<Long>(rejectRptIds.size());
        for (Long rptId : rejectRptIds) {
            Long tempId = rptTempMap.get(rptId);
            if (IDUtils.isNull((Long)tempId)) continue;
            tempIds.add(tempId);
        }
        return tempIds;
    }

    private Set<Long> saveAndSubmitBills(Set<Long> approveBillIds, Set<Long> rejectRptIds, Map<RejectOnReport, Set<Long>> rejectReportMap, String opType) {
        Map<Long, Long> rptTempMap = this.getRptTempMap(rejectRptIds);
        Map<Long, Set<Long>> srcSubBillMap = this.getSrcSubBillMap(approveBillIds);
        Map sourceApproveBillMap = BusinessDataServiceHelper.loadFromCache((Object[])approveBillIds.toArray(), (String)"eb_approvebill");
        HashSet<Long> srcBillIds = new HashSet<Long>(16);
        ArrayList<DynamicObject> approveBillList = new ArrayList<DynamicObject>(rejectReportMap.size());
        ArrayList<DynamicObject> rejectApproveBillList = new ArrayList<DynamicObject>(rejectReportMap.size());
        for (Map.Entry<RejectOnReport, Set<Long>> entry : rejectReportMap.entrySet()) {
            QFilter qFilter;
            DynamicObject rejectBill;
            DynamicObject sourceApproveBill;
            DynamicObject[] rejectReport = entry.getKey();
            Long srcBillId = rejectReport.getSrcBillId();
            Set<Long> rejectReportIds = entry.getValue();
            Set<Long> tempIds = this.getTempIds(rejectReportIds, rptTempMap);
            if (CollectionUtils.isEmpty(tempIds) || (sourceApproveBill = (DynamicObject)sourceApproveBillMap.get(srcBillId)) == null) continue;
            int seqNo = this.generateSeqNo(srcSubBillMap, srcBillId);
            if (!srcBillIds.add(srcBillId)) {
                AtomicInteger seqNoV = new AtomicInteger(seqNo);
                seqNoV.getAndIncrement();
                seqNo = seqNoV.get();
            }
            Long id = GlobalIdUtil.genGlobalLongId();
            DynamicObject approveBill = BusinessDataServiceHelper.newDynamicObject((String)"eb_approvebill");
            this.setBillHeadValue(id, approveBill, sourceApproveBill, rejectReport.getAuditNode(), seqNo);
            this.setBillEntryValue(approveBill, sourceApproveBill, tempIds);
            approveBillList.add(approveBill);
            DynamicObject rejectApproveBill = BusinessDataServiceHelper.newDynamicObject((String)"eb_rejectapprovebill");
            rejectApproveBill.set("approvebill", (Object)id);
            rejectApproveBill.set("rejecttype", (Object)("audit".equals(opType) ? "1" : "0"));
            rejectApproveBill.set("auditnode", (Object)rejectReport.getAuditNode());
            rejectApproveBill.set("rejectnode", (Object)rejectReport.getRejectNode());
            Long rootBillId = sourceApproveBill.getLong("id");
            String srcBillNo = sourceApproveBill.getString("billno");
            String srcBillType = sourceApproveBill.getString("splitbilltype");
            if (CentralBillType.Reject.getNumber().equals(srcBillType) && (rejectBill = QueryServiceHelper.queryOne((String)"eb_rejectapprovebill", (String)"srcbillno,rootbillid", (QFilter[])(qFilter = new QFilter("approvebill", "=", (Object)sourceApproveBill.getLong("id"))).toArray())) != null) {
                srcBillNo = rejectBill.getString("srcbillno") + ";" + srcBillNo;
                rootBillId = rejectBill.getLong("rootbillid");
            }
            rejectApproveBill.set("srcbillno", (Object)srcBillNo);
            rejectApproveBill.set("rootbillid", (Object)rootBillId);
            rejectApproveBillList.add(rejectApproveBill);
        }
        DynamicObject[] approveBillArr = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])approveBillList.toArray(new DynamicObject[0]));
        HashSet<Long> rejectBillIds = new HashSet<Long>(approveBillArr.length);
        if (approveBillArr != null && approveBillArr.length > 0) {
            for (DynamicObject approveBill : approveBillArr) {
                rejectBillIds.add(approveBill.getLong("id"));
            }
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"submit", (String)"eb_approvebill", (Object[])rejectBillIds.toArray(), (OperateOption)OperateOption.create());
            if (!operationResult.isSuccess()) {
                List errorInfoList;
                List validateResults;
                String errorMsg = operationResult.getMessage();
                ValidateResultCollection resultCollection = operationResult.getValidateResult();
                if (resultCollection != null && CollectionUtils.isNotEmpty((Collection)(validateResults = resultCollection.getValidateErrors())) && CollectionUtils.isNotEmpty((Collection)(errorInfoList = ((ValidateResult)validateResults.get(0)).getAllErrorInfo()))) {
                    errorMsg = ((OperateErrorInfo)errorInfoList.get(0)).getMessage();
                }
                throw new KDBizException(ResManager.loadResFormat((String)"\u9a73\u56de\u5ba1\u6279\u5355\u63d0\u4ea4\u5931\u8d25: %1", (String)"RejectOnReportService_1", (String)"epm-eb-business", (Object[])new Object[]{errorMsg}));
            }
            SaveServiceHelper.save((DynamicObject[])rejectApproveBillList.toArray(new DynamicObject[0]));
        }
        for (DynamicObject sourceApproveBill : sourceApproveBillMap.values()) {
            ApproveBillHelper.upSortVal4RejectBill((DynamicObject)sourceApproveBill);
        }
        return rejectBillIds;
    }

    private void setBillHeadValue(Long id, DynamicObject rejectApproveBill, DynamicObject sourceApproveBill, String auditNode, int seqNo) {
        rejectApproveBill.set("id", (Object)id);
        rejectApproveBill.set("modelid", (Object)sourceApproveBill.getLong("modelid.id"));
        rejectApproveBill.set("eborgid", (Object)sourceApproveBill.getLong("eborgid.id"));
        rejectApproveBill.set("createrid", (Object)UserUtils.getUserId());
        rejectApproveBill.set("createorgid", (Object)sourceApproveBill.getLong("createorgid.id"));
        rejectApproveBill.set("department", (Object)sourceApproveBill.getLong("department.id"));
        rejectApproveBill.set("position", (Object)sourceApproveBill.getString("position"));
        rejectApproveBill.set("eborgmasterid", (Object)sourceApproveBill.getLong("eborgmasterid"));
        rejectApproveBill.set("source", (Object)sourceApproveBill.getLong("source_id"));
        rejectApproveBill.set("bizmodelid", (Object)sourceApproveBill.getLong("bizmodelid.id"));
        rejectApproveBill.set("committype", (Object)sourceApproveBill.getString("committype"));
        rejectApproveBill.set("selectorg", (Object)sourceApproveBill.getString("selectorg"));
        rejectApproveBill.set("approvaltype", (Object)sourceApproveBill.getLong("approvaltype.id"));
        rejectApproveBill.set("approvetype", (Object)sourceApproveBill.getLong("approvetype.id"));
        rejectApproveBill.set("approvetypeversion", (Object)sourceApproveBill.getLong("approvetypeversion"));
        rejectApproveBill.set("orgviewid", (Object)sourceApproveBill.getLong("orgviewid.id"));
        rejectApproveBill.set("rptprocesstype", (Object)sourceApproveBill.getString("rptprocesstype"));
        rejectApproveBill.set("dim_period", (Object)sourceApproveBill.getLong("dim_period.id"));
        rejectApproveBill.set("dim_datatype", (Object)sourceApproveBill.getLong("dim_datatype.id"));
        rejectApproveBill.set("dim_version", (Object)sourceApproveBill.getLong("dim_version.id"));
        rejectApproveBill.set("billtype", (Object)"2");
        rejectApproveBill.set("billstatus", (Object)ApproveBillStatus.SAVE.getNumber());
        rejectApproveBill.set("createdate", (Object)TimeServiceHelper.now());
        rejectApproveBill.set("centralorg", (Object)sourceApproveBill.getLong("centralorg"));
        rejectApproveBill.set("centralbailorg", (Object)sourceApproveBill.getLong("centralbailorg"));
        rejectApproveBill.set("auditnode", (Object)auditNode);
        rejectApproveBill.set("parentbillid", sourceApproveBill.getPkValue());
        rejectApproveBill.set("centralbilltype", (Object)sourceApproveBill.getString("centralbilltype"));
        rejectApproveBill.set("audittype", (Object)AuditTypeEnum.WORKFLOW.getType());
        rejectApproveBill.set("approveinfo", (Object)sourceApproveBill.getString("approveinfo"));
        String number = sourceApproveBill.getString("billno") + "-" + (seqNo < 10 ? "00" + seqNo : "0" + seqNo);
        rejectApproveBill.set("billno", (Object)number);
        rejectApproveBill.set("splitbilltype", (Object)CentralBillType.Reject.getNumber());
    }

    private void setBillEntryValue(DynamicObject rejectApproveBill, DynamicObject sourceApproveBill, Set<Long> tempIds) {
        DynamicObjectCollection entryColl = rejectApproveBill.getDynamicObjectCollection("entryentity");
        for (Long tempId : tempIds) {
            DynamicObject entry = entryColl.addNew();
            entry.set("tempid", (Object)tempId);
        }
        DynamicObjectCollection bailOrgColl = rejectApproveBill.getDynamicObjectCollection("entryentity_bailorg");
        DynamicObjectCollection sourceBailOrgs = sourceApproveBill.getDynamicObjectCollection("entryentity_bailorg");
        for (DynamicObject sourceBailOrg : sourceBailOrgs) {
            DynamicObject bailOrg = bailOrgColl.addNew();
            bailOrg.set("bail_org", sourceBailOrg.get("bail_org.id"));
        }
    }

    private int generateSeqNo(Map<Long, Set<Long>> subBillMap, Long srcBillId) {
        int initVal = 0;
        Set<Long> rejectBillIds = subBillMap.get(srcBillId);
        if (CollectionUtils.isNotEmpty(rejectBillIds)) {
            initVal = rejectBillIds.size();
        }
        AtomicInteger seqNo = new AtomicInteger(initVal);
        seqNo.getAndIncrement();
        return seqNo.get();
    }

    private Map<Long, Long> getSrcApproveBillIds(Set<Long> rejectBillIds) {
        HashMap<Long, Long> srcBillMap = new HashMap<Long, Long>(16);
        QFilter qFilter = new QFilter("id", "in", rejectBillIds);
        DynamicObjectCollection rejectBillList = QueryServiceHelper.query((String)"eb_approvebill", (String)"id,parentbillid", (QFilter[])qFilter.toArray());
        for (DynamicObject rejectBill : rejectBillList) {
            Long rejectBillId = rejectBill.getLong("id");
            Long srcBillId = rejectBill.getLong("parentbillid");
            srcBillMap.put(rejectBillId, srcBillId);
        }
        return srcBillMap;
    }

    private void updateReportProcessForCreate(Map<Long, Set<Long>> billRptMap, String rptStatus) {
        if (CollectionUtils.isEmpty(billRptMap)) {
            return;
        }
        ArrayList<Object[]> updateParams = new ArrayList<Object[]>(16);
        for (Map.Entry<Long, Set<Long>> entry : billRptMap.entrySet()) {
            Long billId = entry.getKey();
            Set<Long> rptIds = entry.getValue();
            for (Long rptId : rptIds) {
                updateParams.add(new Object[]{rptStatus, billId, rptId});
            }
        }
        String updateSql = "update t_eb_reportprocess set fstatus = ?, fapprovebill = ? where fid = ?";
        DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)updateSql, updateParams);
        UpgradesTaskUtil.getInstance().clearDataEntityCache("eb_reportprocess");
    }

    private void updateReportProcessForAudit(Set<Long> rejectBillIds, Map<Long, Long> srcBillMap) {
        Map<Long, Set<Long>> rejectRptMap = this.getApproveBillRptMap(rejectBillIds, null, true);
        if (CollectionUtils.isEmpty(rejectRptMap)) {
            return;
        }
        ArrayList<Object[]> updateParams = new ArrayList<Object[]>(16);
        for (Map.Entry<Long, Set<Long>> entry : rejectRptMap.entrySet()) {
            Long rejectBillId = entry.getKey();
            Set<Long> reportIds = entry.getValue();
            Long srcBillId = srcBillMap.get(rejectBillId);
            for (Long rptId : reportIds) {
                updateParams.add(new Object[]{srcBillId, rptId});
            }
        }
        String updateSql = "update t_eb_reportprocess set fapprovebill = ? where fid = ?";
        DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)updateSql, updateParams);
        UpgradesTaskUtil.getInstance().clearDataEntityCache("eb_reportprocess");
    }

    private void updateRejectStatus2Submit(Collection<Long> approveBillIds, Collection<Long> processIds) {
        if (processIds.size() == 0 || approveBillIds.size() == 0) {
            return;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("update t_eb_approverejectstatus set fisreject = '2' where ", new Object[0]);
        sqlBuilder.appendIn("fprocessid", processIds.toArray());
        sqlBuilder.append(" and ", new Object[0]).appendIn("fapprovebillid", approveBillIds.toArray());
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
    }

    public Map<Long, Set<Long>> getSrcBillRptIds(Set<Long> approveBillIds, Set<Long> rejectRptIds) {
        QFilter qFilter = new QFilter("id", "in", rejectRptIds);
        DynamicObjectCollection reportList = QueryServiceHelper.query((String)"eb_reportprocess", (String)"id,template", (QFilter[])qFilter.toArray());
        HashSet<Long> tempIds = new HashSet<Long>(reportList.size());
        for (DynamicObject report : reportList) {
            Long tempId = report.getLong("template");
            tempIds.add(tempId);
        }
        return this.getApproveBillRptMap(approveBillIds, tempIds, true);
    }

    private Map<Long, Set<Long>> getApproveBillRptMap(Set<Long> approveBillIds, Set<Long> rptTempIds, boolean includePassive) {
        Object[] approveBills = BusinessDataServiceHelper.load((Object[])approveBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"eb_approvebill"));
        if (CollectionUtils.isEmpty((Object[])approveBills)) {
            return null;
        }
        Long modelId = approveBills[0].getLong("modelid.id");
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        HashSet<Long> periodIds = new HashSet<Long>(16);
        HashSet<Long> versionIds = new HashSet<Long>(16);
        HashSet<Long> datatypeIds = new HashSet<Long>(16);
        HashSet entityIds = new HashSet(16);
        HashSet<Long> tempIds = new HashSet<Long>(16);
        HashMap<String, Set> dimBillIdMap = new HashMap<String, Set>(approveBills.length);
        StringBuilder dimStr = new StringBuilder(16);
        for (Object approveBill : approveBills) {
            Set orgIds;
            Long billId = approveBill.getLong("id");
            Long orgId = approveBill.getLong("eborgid.id");
            Long orgViewId = approveBill.getLong("orgviewid.id");
            if (includePassive) {
                orgIds = MemberHelper.getEntityIdSetByView((IModelCacheHelper)modelCacheHelper, (Long)orgViewId, (Long)orgId, (Integer)RangeEnum.VALUE_50.getValue());
            } else {
                orgIds = new HashSet<Long>(1);
                orgIds.add(orgId);
            }
            entityIds.addAll(orgIds);
            Long periodId = approveBill.getLong("dim_period.id");
            Long versionId = approveBill.getLong("dim_version.id");
            Long datatypeId = approveBill.getLong("dim_datatype.id");
            periodIds.add(periodId);
            versionIds.add(versionId);
            datatypeIds.add(datatypeId);
            DynamicObjectCollection tempColl = approveBill.getDynamicObjectCollection("entryentity");
            for (DynamicObject tempObj : tempColl) {
                Long tempId = tempObj.getLong("tempid.id");
                if (CollectionUtils.isNotEmpty(rptTempIds) && !rptTempIds.contains(tempId)) continue;
                tempIds.add(tempId);
                for (Long budgetOrgId : orgIds) {
                    dimStr.append(periodId).append('!').append(versionId).append('!').append(datatypeId).append('!').append(budgetOrgId).append('!').append(tempId);
                    Set billIds = dimBillIdMap.computeIfAbsent(dimStr.toString(), v -> new HashSet(16));
                    billIds.add(billId);
                    dimStr.setLength(0);
                }
            }
        }
        QFilter reportFilter = new QFilter("model", "=", (Object)modelId);
        reportFilter.and("period", "in", periodIds);
        reportFilter.and("version", "in", versionIds);
        reportFilter.and("datatype", "in", datatypeIds);
        reportFilter.and("entity", "in", entityIds);
        reportFilter.and("template", "in", tempIds);
        DynamicObjectCollection reportProcessList = QueryServiceHelper.query((String)"eb_reportprocess", (String)"id,approvebill,period,version,datatype,entity,template", (QFilter[])reportFilter.toArray());
        HashMap<Long, Set<Long>> billReportMap = new HashMap<Long, Set<Long>>(16);
        for (DynamicObject reportProcess : reportProcessList) {
            Long rptId = reportProcess.getLong("id");
            Long billId = reportProcess.getLong("approvebill");
            Long periodId = reportProcess.getLong("period");
            Long versionId = reportProcess.getLong("version");
            Long datatypeId = reportProcess.getLong("datatype");
            Long entityId = reportProcess.getLong("entity");
            Long tempId = reportProcess.getLong("template");
            dimStr.append(periodId).append('!').append(versionId).append('!').append(datatypeId).append('!').append(entityId).append('!').append(tempId);
            Set billIds = (Set)dimBillIdMap.get(dimStr.toString());
            if (CollectionUtils.isNotEmpty((Collection)billIds) && billIds.contains(billId)) {
                Set rptIds = billReportMap.computeIfAbsent(billId, v -> new HashSet(16));
                rptIds.add(rptId);
            }
            dimStr.setLength(0);
        }
        return billReportMap;
    }

    private Map<Long, Set<Long>> getRejectBillRptMapForCreate(Set<Long> rejectBillIds) {
        Object[] rejectBills = BusinessDataServiceHelper.load((Object[])rejectBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"eb_approvebill"));
        if (CollectionUtils.isEmpty((Object[])rejectBills)) {
            return null;
        }
        Long modelId = rejectBills[0].getLong("modelid.id");
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        HashSet<Long> periodIds = new HashSet<Long>(16);
        HashSet<Long> versionIds = new HashSet<Long>(16);
        HashSet<Long> datatypeIds = new HashSet<Long>(16);
        HashSet entityIds = new HashSet(16);
        HashSet<Long> tempIds = new HashSet<Long>(16);
        HashMap<String, Set> dimRejectBillIdMap = new HashMap<String, Set>(rejectBills.length);
        HashMap<String, Set> dimSrcBillIdMap = new HashMap<String, Set>(rejectBills.length);
        StringBuilder dimStr = new StringBuilder(16);
        for (Object approveBill : rejectBills) {
            Long billId = approveBill.getLong("id");
            Long srcBillId = approveBill.getLong("parentbillid");
            Long orgId = approveBill.getLong("eborgid.id");
            Long orgViewId = approveBill.getLong("orgviewid.id");
            Set orgIds = MemberHelper.getEntityIdSetByView((IModelCacheHelper)modelCacheHelper, (Long)orgViewId, (Long)orgId, (Integer)RangeEnum.VALUE_50.getValue());
            entityIds.addAll(orgIds);
            Long periodId = approveBill.getLong("dim_period.id");
            Long versionId = approveBill.getLong("dim_version.id");
            Long datatypeId = approveBill.getLong("dim_datatype.id");
            periodIds.add(periodId);
            versionIds.add(versionId);
            datatypeIds.add(datatypeId);
            DynamicObjectCollection tempColl = approveBill.getDynamicObjectCollection("entryentity");
            for (DynamicObject tempObj : tempColl) {
                Long tempId = tempObj.getLong("tempid.id");
                tempIds.add(tempId);
                for (Long budgetOrgId : orgIds) {
                    dimStr.append(periodId).append('!').append(versionId).append('!').append(datatypeId).append('!').append(budgetOrgId).append('!').append(tempId);
                    Set billIds = dimRejectBillIdMap.computeIfAbsent(dimStr.toString(), v -> new HashSet(16));
                    billIds.add(billId);
                    Set srcBillIds = dimSrcBillIdMap.computeIfAbsent(dimStr.toString(), v -> new HashSet(16));
                    srcBillIds.add(srcBillId);
                    dimStr.setLength(0);
                }
            }
        }
        QFilter reportFilter = new QFilter("model", "=", (Object)modelId);
        reportFilter.and("period", "in", periodIds);
        reportFilter.and("version", "in", versionIds);
        reportFilter.and("datatype", "in", datatypeIds);
        reportFilter.and("entity", "in", entityIds);
        reportFilter.and("template", "in", tempIds);
        DynamicObjectCollection reportProcessList = QueryServiceHelper.query((String)"eb_reportprocess", (String)"id,approvebill,period,version,datatype,entity,template", (QFilter[])reportFilter.toArray());
        HashMap<Long, Set<Long>> billReportMap = new HashMap<Long, Set<Long>>(16);
        for (DynamicObject reportProcess : reportProcessList) {
            Long rptId = reportProcess.getLong("id");
            Long billId = reportProcess.getLong("approvebill");
            Long periodId = reportProcess.getLong("period");
            Long versionId = reportProcess.getLong("version");
            Long datatypeId = reportProcess.getLong("datatype");
            Long entityId = reportProcess.getLong("entity");
            Long tempId = reportProcess.getLong("template");
            dimStr.append(periodId).append('!').append(versionId).append('!').append(datatypeId).append('!').append(entityId).append('!').append(tempId);
            Set billIds = (Set)dimRejectBillIdMap.get(dimStr.toString());
            Set srcBillIds = (Set)dimSrcBillIdMap.get(dimStr.toString());
            if (CollectionUtils.isNotEmpty((Collection)billIds) && (billIds.contains(billId) || srcBillIds.contains(billId))) {
                for (Long rejectBillId : billIds) {
                    Set rptIds = billReportMap.computeIfAbsent(rejectBillId, v -> new HashSet(16));
                    rptIds.add(rptId);
                }
            }
            dimStr.setLength(0);
        }
        return billReportMap;
    }

    private void sendMessage(Long srcBillId) {
        Object row;
        if (IDUtils.isNull((Long)srcBillId)) {
            return;
        }
        List auditors = WorkflowServiceHelper.getApproverByBusinessKey((String)srcBillId.toString());
        if (CollectionUtils.isEmpty((Collection)auditors)) {
            return;
        }
        HashSet<Long> processIds = new HashSet<Long>(16);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fapprovebillid, fprocessid from t_eb_approverejectstatus where fisreject in ('1','2') and fprocessid != 0 and ", new Object[0]);
        sqlBuilder.append("fapprovebillid = ?", new Object[]{srcBillId});
        try (DataSet ds = DB.queryDataSet((String)"queryRejectedApproveBill", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sqlBuilder);){
            while (ds.hasNext()) {
                row = ds.next();
                Long processId = row.getLong("fprocessid");
                if (processId == 0L) continue;
                processIds.add(processId);
            }
        }
        log.info("sendMessage srcBillId={}, processIds={}", (Object)srcBillId, processIds);
        if (!processIds.isEmpty()) {
            return;
        }
        HashSet<Long> rejectRptIds = new HashSet<Long>(16);
        sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fapprovebillid, fprocessid from t_eb_approverejectopinion where fdiscard = '1' and ", new Object[0]);
        sqlBuilder.append("fapprovebillid = ?", new Object[]{srcBillId});
        DataSet ds = DB.queryDataSet((String)"queryRejectedApproveBill", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sqlBuilder);
        row = null;
        try {
            while (ds.hasNext()) {
                Row row2 = ds.next();
                Long processId = row2.getLong("fprocessid");
                if (processId == 0L) continue;
                rejectRptIds.add(processId);
            }
        }
        catch (Throwable row2) {
            row = row2;
            throw row2;
        }
        finally {
            if (ds != null) {
                if (row != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable row2) {
                        ((Throwable)row).addSuppressed(row2);
                    }
                } else {
                    ds.close();
                }
            }
        }
        HashSet<String> tempNames = new HashSet<String>(16);
        QFilter qFilter = new QFilter("id", "in", rejectRptIds);
        DynamicObjectCollection reportList = QueryServiceHelper.query((String)"eb_reportprocess", (String)"id,template.name", (QFilter[])qFilter.toArray());
        for (DynamicObject report : reportList) {
            String tempName = report.getString("template.name");
            tempNames.add(tempName);
        }
        String reportNames = tempNames.stream().collect(Collectors.joining(","));
        Long userId = UserUtils.getUserId();
        String messageTitle = ResManager.loadKDString((String)"\u9a73\u56de\u7684\u62a5\u8868\u5df2\u5904\u7406\u5b8c\u6210", (String)"RejectOnReportService_2", (String)"epm-eb-business", (Object[])new Object[0]);
        String messageContent = ResManager.loadResFormat((String)"\u9884\u7b97\u5ba1\u6838\u4efb\u52a1\u9a73\u56de\u7684\u201c%1\u201d\u62a5\u8868\u5df2\u5904\u7406\uff0c\u8bf7\u91cd\u65b0\u5ba1\u6838\uff01", (String)"RejectOnReportService_3", (String)"epm-eb-business", (Object[])new Object[]{reportNames});
        MessageUtils.get().sendMessageWithSender("eb_approvebill", messageTitle, messageContent, auditors, MessageUtils.MessageType.YUNZHIJIA, userId, ResManager.loadKDString((String)"\u9884\u7b97\u5ba1\u6838", (String)"ApproveOperationConfirmPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    public void updateRejectStatus2Finish(Collection<Long> approveBillIds, Collection<Long> processIds) {
        if (CollectionUtils.isEmpty(approveBillIds) || CollectionUtils.isEmpty(processIds)) {
            return;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("update t_eb_approverejectstatus set fisreject = '0' where ", new Object[0]);
        sqlBuilder.appendIn("fprocessid", processIds.toArray());
        sqlBuilder.append(" and ", new Object[0]).appendIn("fapprovebillid", approveBillIds.toArray());
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
        sqlBuilder = new SqlBuilder();
        sqlBuilder.append("update t_eb_approverejectopinion set fdiscard = '1' where fdiscard = '0' and fiscurinstance = '1' and ", new Object[0]);
        sqlBuilder.appendIn("fprocessid", processIds.toArray());
        sqlBuilder.append(" and ", new Object[0]).appendIn("fapprovebillid", approveBillIds.toArray());
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
    }

    public void updateRejectStatus2FinishWithMsg(Collection<Long> approveBillIds, Collection<Long> processIds) {
        EpmThreadPools.CommPools.execute(() -> {
            this.updateRejectStatus2Finish(approveBillIds, processIds);
            for (Long srcBillId : approveBillIds) {
                this.sendMessage(srcBillId);
            }
        });
    }

    public void handleWorkFlowForceStop(Long approveBillId) {
        DynamicObject approveBill = QueryServiceHelper.queryOne((String)"eb_approvebill", (String)"id,splitbilltype,billstatus", (QFilter[])new QFilter("id", "=", (Object)approveBillId).toArray());
        if (approveBill == null) {
            return;
        }
        String billType = approveBill.getString("splitbilltype");
        if (CentralBillType.Reject.getNumber().equals(billType)) {
            String billStatus = approveBill.getString("billstatus");
            if (ApproveBillStatus.AUDIT.getNumber().equals(billStatus)) {
                return;
            }
            Long rejectBillId = approveBill.getLong("id");
            Map<Long, Long> srcBillMap = this.getSrcApproveBillIds(Collections.singleton(rejectBillId));
            if (CollectionUtils.isEmpty(srcBillMap)) {
                return;
            }
            Map<Long, Set<Long>> rejectRptMap = this.getApproveBillRptMap(Collections.singleton(rejectBillId), null, false);
            if (CollectionUtils.isEmpty(rejectRptMap)) {
                return;
            }
            this.updateRejectStatus2FinishWithMsg(srcBillMap.values(), (Collection<Long>)rejectRptMap.get(rejectBillId));
            this.updateReportProcessForAudit(Collections.singleton(rejectBillId), srcBillMap);
        } else {
            this.discardAllRejectBills(approveBillId);
        }
    }

    public void handleWorkFlowJump(Long approveBillId) {
        DynamicObject approveBill = QueryServiceHelper.queryOne((String)"eb_approvebill", (String)"id,splitbilltype", (QFilter[])new QFilter("id", "=", (Object)approveBillId).toArray());
        if (approveBill == null) {
            return;
        }
        String billType = approveBill.getString("splitbilltype");
        if (CentralBillType.Reject.getNumber().equals(billType)) {
            return;
        }
        this.discardAllRejectBills(approveBillId);
    }

    private void discardAllRejectBills(Long approveBillId) {
        QFilter qFilter = new QFilter("rootbillid", "=", (Object)approveBillId);
        DynamicObjectCollection rejectBillList = QueryServiceHelper.query((String)"eb_rejectapprovebill", (String)"approvebill,rootbillid", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isEmpty((Collection)rejectBillList)) {
            this.updateRejectReportStatus(approveBillId);
            return;
        }
        HashSet<Long> rejectBillIds = new HashSet<Long>(16);
        for (DynamicObject rejectBill : rejectBillList) {
            rejectBillIds.add(rejectBill.getLong("approvebill"));
        }
        QFilter qFilterV = new QFilter("id", "in", rejectBillIds);
        qFilterV.and(new QFilter("billstatus", "!=", (Object)ApproveBillStatus.DISCARD.getNumber()));
        Object[] rejectBills = BusinessDataServiceHelper.load((String)"eb_approvebill", (String)"id,billstatus", (QFilter[])qFilterV.toArray());
        if (!CollectionUtils.isEmpty((Object[])rejectBills)) {
            HashSet<String> businessKeys = new HashSet<String>(rejectBills.length);
            for (Object rejectBill : rejectBills) {
                businessKeys.add(rejectBill.getString("id"));
                rejectBill.set("billstatus", (Object)ApproveBillStatus.DISCARD.getNumber());
            }
            SaveServiceHelper.save((DynamicObject[])rejectBills);
            try {
                WorkFlowUtil.stopWorkFlowProcess(businessKeys);
            }
            catch (Exception ex) {
                log.error("discardAllRejectBills businessKeys={}, stopWorkFlowProcess error: {}", businessKeys, (Object)ex);
            }
        }
        HashSet<Long> rejectRptIds = new HashSet<Long>(16);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fprocessid, fapprovebillid from t_eb_approverejectstatus where fisreject in ('1','2') and fprocessid != 0 and ", new Object[0]);
        sqlBuilder.append("fapprovebillid = ?", new Object[]{approveBillId});
        try (DataSet ds = DB.queryDataSet((String)"queryRejectStatus", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);){
            while (ds.hasNext()) {
                Row row = ds.next();
                Long processId = row.getLong("fprocessid");
                rejectRptIds.add(processId);
            }
        }
        if (rejectRptIds.isEmpty()) {
            return;
        }
        this.updateRejectReportStatus(approveBillId);
        sqlBuilder = new SqlBuilder();
        sqlBuilder.append("update t_eb_reportprocess set ", new Object[0]);
        sqlBuilder.append("fstatus = ?", new Object[]{BgTaskStateEnum.UNDERWAY.getNumber()});
        sqlBuilder.append(",", new Object[0]);
        sqlBuilder.append("fapprovebill = ?", new Object[]{approveBillId});
        sqlBuilder.append(" where ", new Object[0]);
        sqlBuilder.appendIn("fid ", rejectRptIds.toArray());
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
        UpgradesTaskUtil.getInstance().clearDataEntityCache("eb_reportprocess");
    }

    private void updateRejectReportStatus(Long approveBillId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("update t_eb_approverejectstatus set fisreject = '0' where ", new Object[0]);
        sqlBuilder.append("fapprovebillid = ?", new Object[]{approveBillId});
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
        sqlBuilder = new SqlBuilder();
        sqlBuilder.append("update t_eb_approverejectopinion set fdiscard = '1' where fdiscard='0' and fiscurinstance = '1' and ", new Object[0]);
        sqlBuilder.append("fapprovebillid = ?", new Object[]{approveBillId});
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
    }

    public boolean handleRejectOnReportForAudit(Set<Long> approveBillIds, Set<Long> processIds) {
        Long approveBillId;
        if (CollectionUtils.isEmpty(approveBillIds) || CollectionUtils.isEmpty(processIds)) {
            return false;
        }
        HashMap<Long, Set> billReportMap = new HashMap<Long, Set>(16);
        HashSet<Long> inRejectProcessIds = new HashSet<Long>(16);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fprocessid, fapprovebillid from t_eb_approverejectstatus where fisreject in ('1','2') and ", new Object[0]);
        sqlBuilder.appendIn("fprocessid", processIds.toArray());
        sqlBuilder.append(" and ", new Object[0]).appendIn("fapprovebillid", approveBillIds.toArray());
        DataSet ds = DB.queryDataSet((String)"queryRejectStatus", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
        Object object = null;
        try {
            while (ds.hasNext()) {
                Row row = ds.next();
                approveBillId = row.getLong("fapprovebillid");
                Long processId = row.getLong("fprocessid");
                inRejectProcessIds.add(processId);
                Set rptIds = billReportMap.computeIfAbsent(approveBillId, v -> new HashSet(16));
                rptIds.add(processId);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        if (!inRejectProcessIds.containsAll(processIds)) {
            return false;
        }
        if (!this.canHandleRejectReport(processIds)) {
            return false;
        }
        ArrayList<Object[]> updateParams = new ArrayList<Object[]>(16);
        for (Map.Entry entry : billReportMap.entrySet()) {
            approveBillId = (Long)entry.getKey();
            Set rejectRptIds = (Set)entry.getValue();
            for (Long rejectRptId : rejectRptIds) {
                updateParams.add(new Object[]{rejectRptId, approveBillId});
            }
        }
        String updateRejectStatusSql = "update t_eb_approverejectstatus set fisreject = '0' where fprocessid = ? and fapprovebillid = ?";
        DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)updateRejectStatusSql, updateParams);
        String string = "update t_eb_approverejectopinion set fdiscard = '1' where fdiscard = '0' and fiscurinstance = '1' and fprocessid = ? and fapprovebillid = ?";
        DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)string, updateParams);
        for (Long approveBillId2 : billReportMap.keySet()) {
            this.sendMessage(approveBillId2);
        }
        return true;
    }

    public boolean handleRejectOnReportForSubmit(IFormView view, Long modelId, String formType, boolean isBatch) {
        HashSet<Long> approveBillIds = new HashSet<Long>(16);
        HashSet<Long> processIds = new HashSet<Long>(16);
        if (isBatch) {
            DynamicObject entryRowEntity;
            int[] selectRows;
            EntryGrid entryGrid;
            if ("schema".equals(formType)) {
                entryGrid = (EntryGrid)view.getControl("billlist_entity");
                selectRows = entryGrid.getSelectRows();
                for (int selectRow : selectRows) {
                    entryRowEntity = view.getModel().getEntryRowEntity("billlist_entity", selectRow);
                    long processId = entryRowEntity.getLong("process.id");
                    if (IDUtils.isNull((long)processId)) continue;
                    processIds.add(processId);
                }
            } else {
                entryGrid = (EntryGrid)view.getControl("entryentity");
                selectRows = entryGrid.getSelectRows();
                for (int selectRow : selectRows) {
                    entryRowEntity = view.getModel().getEntryRowEntity("entryentity", selectRow);
                    Long processId = entryRowEntity.getLong("reportprocess.id");
                    if (IDUtils.isNull((Long)processId)) continue;
                    processIds.add(processId);
                }
            }
            Map<Long, Long> billRptMap = ApproveUtils.getInstance().getProcessRefMainApproveBillIds(processIds);
            approveBillIds.addAll(billRptMap.values());
        } else {
            Long currentProcessId = IDUtils.toLong((Object)view.getPageCache().get("current_report_id"));
            processIds.add(currentProcessId);
            Long approveBillId = ApproveUtils.getInstance().getProcessRefMainApproveBillId(currentProcessId);
            approveBillIds.add(approveBillId);
        }
        approveBillIds.remove(0L);
        if (approveBillIds.size() == 0) {
            return false;
        }
        QFilter qFilter = new QFilter("id", "in", processIds);
        DynamicObjectCollection reportList = QueryServiceHelper.query((String)"eb_reportprocess", (String)"id,status", (QFilter[])qFilter.toArray());
        Object object = reportList.iterator();
        while (object.hasNext()) {
            DynamicObject report = (DynamicObject)object.next();
            String reportStatus = report.getString("status");
            if (!BgTaskStateEnum.UNDERWAY.getNumber().equals(reportStatus)) continue;
            return false;
        }
        HashSet<Long> inRejectProcessIds = new HashSet<Long>(16);
        ApproveUtils.getInstance().getInRejectApproveBills(approveBillIds, inRejectProcessIds);
        if (!inRejectProcessIds.containsAll(processIds)) {
            return false;
        }
        boolean isMatchNewWorkFlow = this.isMatchNewWorkFlow(modelId);
        if (isMatchNewWorkFlow) {
            this.createRejectBill(approveBillIds, processIds, "submit");
        } else {
            this.updateRejectStatus2FinishWithMsg(approveBillIds, processIds);
            Map<Long, Set<Long>> billRptMap = this.getSrcBillRptIds(approveBillIds, processIds);
            if (billRptMap != null && !billRptMap.isEmpty()) {
                billRptMap.values().stream().forEach(rptIds -> processIds.addAll((Collection<Long>)rptIds));
            }
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("update t_eb_reportprocess set fstatus = ? ", new Object[]{BgTaskStateEnum.UNDERWAY.getNumber()});
            sqlBuilder.append(" where ", new Object[0]);
            sqlBuilder.appendIn("fid", processIds.toArray());
            DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
            UpgradesTaskUtil.getInstance().clearDataEntityCache("eb_reportprocess");
        }
        view.showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f", (String)"ApproveOptimization_35", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        return true;
    }

    public boolean isRejectApproveBill(Long billId) {
        QFilter qFilter = new QFilter("id", "=", (Object)billId);
        qFilter.and("parentbillid", "!=", (Object)0L);
        qFilter.and("splitbilltype", "=", (Object)CentralBillType.Reject.getNumber());
        return QueryServiceHelper.exists((String)"eb_approvebill", (QFilter[])qFilter.toArray());
    }

    private boolean canHandleRejectReport(Set<Long> processIds) {
        QFilter qFilterV = new QFilter("id", "in", processIds);
        DynamicObjectCollection reportList = QueryServiceHelper.query((String)"eb_reportprocess", (String)"id,model,period,version,datatype,entity,template", (QFilter[])qFilterV.toArray());
        HashSet<Long> periodIds = new HashSet<Long>(16);
        HashSet<Long> versionIds = new HashSet<Long>(16);
        HashSet<Long> dataTypeIds = new HashSet<Long>(16);
        HashSet<Long> templateIds = new HashSet<Long>(16);
        HashSet<Long> entityIds = new HashSet<Long>(16);
        Long modelId = 0L;
        for (DynamicObject report : reportList) {
            modelId = report.getLong("model");
            periodIds.add(report.getLong("period"));
            versionIds.add(report.getLong("version"));
            dataTypeIds.add(report.getLong("datatype"));
            templateIds.add(report.getLong("template"));
            entityIds.add(report.getLong("entity"));
        }
        QFilter qFilter = new QFilter("modelid", "=", (Object)modelId);
        qFilter.and("dim_period", "in", periodIds);
        qFilter.and("dim_version", "in", versionIds);
        qFilter.and("dim_datatype", "in", dataTypeIds);
        qFilter.and("entryentity.tempid", "in", templateIds);
        qFilter.and("eborgid", "in", entityIds);
        qFilter.and("billstatus", "not in", (Object)new Object[]{ApproveBillStatus.DISCARD.getNumber(), ApproveBillStatus.AUDIT.getNumber()});
        DynamicObjectCollection approveBills = QueryServiceHelper.query((String)"eb_approvebill", (String)"id,splitbilltype", (QFilter[])qFilter.toArray());
        for (DynamicObject approveBill : approveBills) {
            String billType = approveBill.getString("splitbilltype");
            if (!CentralBillType.Reject.getNumber().equals(billType)) continue;
            return false;
        }
        return true;
    }

    public Set<Long> getRejectOnReports(Set<Long> processIds) {
        HashSet<Long> rejectRptIds = new HashSet<Long>(16);
        if (processIds.isEmpty()) {
            return rejectRptIds;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fprocessid, fapprovebillid from t_eb_approverejectstatus where fisreject in ('1','2') and ", new Object[0]);
        sqlBuilder.appendIn("fprocessid", processIds.toArray());
        try (DataSet ds = DB.queryDataSet((String)"queryRejectStatus", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);){
            while (ds.hasNext()) {
                Row row = ds.next();
                Long processId = row.getLong("fprocessid");
                rejectRptIds.add(processId);
            }
        }
        return rejectRptIds;
    }

    public Set<String> getRejectReportNames(Set<Long> processIds) {
        QFilter qFilter = new QFilter("id", "in", processIds);
        DynamicObjectCollection reportList = QueryServiceHelper.query((String)"eb_reportprocess", (String)"id,template.number as tempnumber,template.name as tempname", (QFilter[])qFilter.toArray());
        HashSet<String> tempMap = new HashSet<String>(16);
        for (DynamicObject report : reportList) {
            String tempNumber = report.getString("tempnumber");
            String tempName = report.getString("tempname");
            tempMap.add(tempNumber + " " + tempName);
        }
        return tempMap;
    }

    /*
     * WARNING - void declaration
     */
    public void createAndSubmitBills(Set<Long> processIds) {
        HashMap<Long, Long> reportTempMap = new HashMap<Long, Long>(16);
        QFilter qFilterV = new QFilter("id", "in", processIds);
        DynamicObjectCollection reportList = QueryServiceHelper.query((String)"eb_reportprocess", (String)"id,model,period,version,datatype,entity,template", (QFilter[])qFilterV.toArray());
        HashSet<Long> periodIds = new HashSet<Long>(16);
        HashSet<Long> versionIds = new HashSet<Long>(16);
        HashSet<Long> dataTypeIds = new HashSet<Long>(16);
        HashSet<Long> templateIds = new HashSet<Long>(16);
        HashSet<Long> entityIds = new HashSet<Long>(16);
        Long modelId = 0L;
        HashMap<String, Long> dimReportMap = new HashMap<String, Long>(16);
        StringBuilder dimStr = new StringBuilder();
        for (DynamicObject report : reportList) {
            Long reportId = report.getLong("id");
            modelId = report.getLong("model");
            Long periodId = report.getLong("period");
            Long versionId = report.getLong("version");
            Long datatypeId = report.getLong("datatype");
            Long templateId2 = report.getLong("template");
            Long entityId = report.getLong("entity");
            reportTempMap.put(reportId, templateId2);
            periodIds.add(periodId);
            versionIds.add(versionId);
            dataTypeIds.add(datatypeId);
            templateIds.add(templateId2);
            entityIds.add(entityId);
            dimStr.append(periodId).append('!').append(versionId).append('!').append(datatypeId).append('!').append(templateId2).append('!').append(entityId);
            dimReportMap.put(dimStr.toString(), reportId);
            dimStr.setLength(0);
        }
        QFilter qFilter = new QFilter("modelid", "=", (Object)modelId);
        qFilter.and("dim_period", "in", periodIds);
        qFilter.and("dim_version", "in", versionIds);
        qFilter.and("dim_datatype", "in", dataTypeIds);
        qFilter.and("entryentity.tempid", "in", templateIds);
        qFilter.and("eborgid", "in", entityIds);
        qFilter.and("splitbilltype", "=", (Object)CentralBillType.Reject.getNumber());
        qFilter.and("billstatus", "not in", (Object)new Object[]{ApproveBillStatus.DISCARD.getNumber(), ApproveBillStatus.AUDIT.getNumber()});
        String fields = "id, dim_datatype, dim_period, dim_version, eborgid, entryentity.tempid as tempid";
        DynamicObjectCollection approveBills = QueryServiceHelper.query((String)"eb_approvebill", (String)fields, (QFilter[])qFilter.toArray(), (String)"createdate desc");
        LinkedHashMap<Long, Set> billReportMap = new LinkedHashMap<Long, Set>(16);
        HashSet<String> signKeys = new HashSet<String>(16);
        for (DynamicObject approveBill : approveBills) {
            Long approveBillId = approveBill.getLong("id");
            Long periodId = approveBill.getLong("dim_period");
            Long versionId = approveBill.getLong("dim_version");
            Long datatypeId = approveBill.getLong("dim_datatype");
            Long l = approveBill.getLong("tempid");
            Long entityId = approveBill.getLong("eborgid");
            String signKey = periodId + "!" + versionId + "!" + datatypeId + "!" + l + "!" + entityId;
            if (!signKeys.add(signKey)) continue;
            Long reportId = (Long)dimReportMap.get(signKey);
            Set set = billReportMap.computeIfAbsent(approveBillId, v -> new HashSet(16));
            set.add(reportId);
        }
        LinkedHashMap<Long, Set> billTempMap = new LinkedHashMap<Long, Set>(16);
        QFilter billFilter = new QFilter("id", "in", billReportMap.keySet());
        DynamicObjectCollection approveBillColl = QueryServiceHelper.query((String)"eb_approvebill", (String)"id, entryentity.tempid as tempid", (QFilter[])billFilter.toArray());
        for (DynamicObject approveBill : approveBillColl) {
            Long approveBillId = approveBill.getLong("id");
            Long l = approveBill.getLong("tempid");
            Set tempIds = billTempMap.computeIfAbsent(approveBillId, v -> new HashSet(16));
            tempIds.add(l);
        }
        HashSet<DynamicObject[]> modifyBills = new HashSet<DynamicObject[]>(16);
        HashSet newReportIds = new HashSet(16);
        for (Map.Entry entry : billReportMap.entrySet()) {
            DynamicObject[] approveBillId = (DynamicObject[])entry.getKey();
            Set reportIds = (Set)entry.getValue();
            Set tempIds = (Set)billTempMap.get(approveBillId);
            if (reportIds.size() == tempIds.size()) {
                modifyBills.add(approveBillId);
                continue;
            }
            newReportIds.addAll(reportIds);
        }
        if (!modifyBills.isEmpty()) {
            DynamicObject[] modifyApproveBills = BusinessDataServiceHelper.load((Object[])modifyBills.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"eb_approvebill"));
            HashSet<Long> hashSet = new HashSet<Long>(16);
            for (DynamicObject dynamicObject : modifyApproveBills) {
                hashSet.add(dynamicObject.getLong("id"));
            }
            OperationServiceHelper.executeOperate((String)"submit", (String)"eb_approvebill", (Object[])hashSet.toArray(), (OperateOption)OperateOption.create());
        }
        if (!newReportIds.isEmpty()) {
            QFilter rejectFilter;
            DynamicObject rejectBill;
            void var24_33;
            Long srcBillId = 0L;
            String string = "";
            String rejectNode = "";
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("select fprocessid, fapprovebillid from t_eb_approverejectstatus where fisreject in ('1','2') and ", new Object[0]);
            sqlBuilder.appendIn("fprocessid", processIds.toArray());
            Throwable throwable = null;
            try (DataSet ds = DB.queryDataSet((String)"queryRejectStatus", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);){
                if (ds.hasNext()) {
                    Row row2 = ds.next();
                    srcBillId = row2.getLong("fapprovebillid");
                }
            }
            catch (Throwable row2) {
                Throwable throwable2 = row2;
                throw row2;
            }
            sqlBuilder = new SqlBuilder();
            sqlBuilder.append("select fprocessid,fapprovebillid,fauditnode,frejectnode from t_eb_approverejectopinion where fdiscard = '0' and fiscurinstance = '1' and ", new Object[0]);
            sqlBuilder.appendIn("fprocessid", newReportIds.toArray());
            sqlBuilder.append(" and fapprovebillid = ?", new Object[]{srcBillId});
            sqlBuilder.append(" order by frejecttime desc", new Object[0]);
            ds = DB.queryDataSet((String)"queryRejectStatus", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
            Throwable throwable3 = null;
            try {
                if (ds.hasNext()) {
                    Row row3 = ds.next();
                    String string2 = row3.getString("fauditnode");
                    rejectNode = row3.getString("frejectnode");
                    if (StringUtils.isNotEmpty((String)rejectNode) && rejectNode.contains("#")) {
                        rejectNode = rejectNode.split("#")[0];
                    }
                }
            }
            catch (Throwable row3) {
                Throwable throwable4 = row3;
                throw row3;
            }
            finally {
                if (ds != null) {
                    if (throwable3 != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable row3) {
                            throwable3.addSuppressed(row3);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
            Map<Long, Set<Long>> srcSubBillMap = this.getSrcSubBillMap(Collections.singleton(srcBillId));
            int n = this.generateSeqNo(srcSubBillMap, srcBillId);
            HashSet<Long> tempIds = new HashSet<Long>(reportTempMap.values());
            DynamicObject srcApproveBill = BusinessDataServiceHelper.loadSingle((Object)srcBillId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"eb_approvebill"));
            Long id = GlobalIdUtil.genGlobalLongId();
            DynamicObject approveBill2 = BusinessDataServiceHelper.newDynamicObject((String)"eb_approvebill");
            this.setBillHeadValue(id, approveBill2, srcApproveBill, (String)var24_33, n);
            this.setBillEntryValue(approveBill2, srcApproveBill, tempIds);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{approveBill2});
            OperationServiceHelper.executeOperate((String)"submit", (String)"eb_approvebill", (Object[])new Object[]{id}, (OperateOption)OperateOption.create());
            DynamicObject rejectApproveBill = BusinessDataServiceHelper.newDynamicObject((String)"eb_rejectapprovebill");
            rejectApproveBill.set("approvebill", (Object)id);
            rejectApproveBill.set("rejecttype", (Object)"0");
            rejectApproveBill.set("auditnode", (Object)var24_33);
            rejectApproveBill.set("rejectnode", (Object)rejectNode);
            Long rootBillId = srcApproveBill.getLong("id");
            String srcBillNo = srcApproveBill.getString("billno");
            String srcBillType = srcApproveBill.getString("splitbilltype");
            if (CentralBillType.Reject.getNumber().equals(srcBillType) && (rejectBill = QueryServiceHelper.queryOne((String)"eb_rejectapprovebill", (String)"srcbillno,rootbillid", (QFilter[])(rejectFilter = new QFilter("approvebill", "=", (Object)srcApproveBill.getLong("id"))).toArray())) != null) {
                srcBillNo = rejectBill.getString("srcbillno") + ";" + srcBillNo;
                rootBillId = rejectBill.getLong("rootbillid");
            }
            rejectApproveBill.set("srcbillno", (Object)srcBillNo);
            rejectApproveBill.set("rootbillid", (Object)rootBillId);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{rejectApproveBill});
            ApproveBillHelper.upSortVal4RejectBill((DynamicObject)srcApproveBill);
        }
    }
}

