/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.approveBill.filter;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.epm.eb.business.approveBill.filter.ApproveBillFilterService;
import kd.epm.eb.common.approveBill.Entity.ApproveBillStatus;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.model.permission.MemberPermHelper;

public abstract class AbstractApproveBillFilterService
implements ApproveBillFilterService {
    protected static final int BATCH_SIZE = 500;

    protected Set<Long> getBillIdsForMyPending(Long modelId, List<String> billIds) {
        Set<Long> pendingIds = this.getBillIdsForLocalPending(modelId, billIds);
        Set<Long> workIds = this.getBillIdsForWorkflowPending(billIds);
        pendingIds.addAll(workIds);
        return pendingIds;
    }

    protected Set<Long> getBillIdsForLocalPending(Long modelId, List<String> billIds) {
        HashSet<Long> localBillIds = new HashSet<Long>(16);
        Map<Long, String> billOrgMap = this.getLocalBillOrgMap(billIds);
        if (billOrgMap.isEmpty()) {
            return localBillIds;
        }
        boolean isModelManage = MemberPermHelper.getLimitedModelListByUser().contains(modelId);
        if (isModelManage) {
            localBillIds.addAll(billOrgMap.keySet());
        } else {
            HashSet<String> billOrgSet = new HashSet<String>(billOrgMap.values());
            HashSet permOrgIds = new HashSet(16);
            for (String string : billOrgSet) {
                String[] valArr = string.split("!");
                Long bizModelId = IDUtils.toLong((Object)valArr[0]);
                Long orgViewId = IDUtils.toLong((Object)valArr[1]);
                Set permIds = DimMembPermHelper.getReadPermMembIds((String)SysDimensionEnum.Entity.getNumber(), (Long)modelId, (Long)bizModelId, (Long)orgViewId, (boolean)true);
                if (!CollectionUtils.isNotEmpty((Collection)permIds)) continue;
                permOrgIds.addAll(permIds);
            }
            if (CollectionUtils.isNotEmpty(permOrgIds)) {
                for (Map.Entry entry : billOrgMap.entrySet()) {
                    Long billId = (Long)entry.getKey();
                    String value = (String)entry.getValue();
                    String[] valArr = value.split("!");
                    Long orgId = IDUtils.toLong((Object)valArr[2]);
                    if (!permOrgIds.contains(orgId)) continue;
                    localBillIds.add(billId);
                }
            }
        }
        return localBillIds;
    }

    protected Set<Long> getBillIdsForMySubmit(List<String> billIds) {
        HashSet<Long> ids = new HashSet<Long>(16);
        Set<Long> localIds = this.getBillIdsForLocalSubmit(billIds);
        Set<Long> sIds = this.getBillIdsForWorkflowSubmit(billIds);
        ids.addAll(localIds);
        ids.addAll(sIds);
        return ids;
    }

    protected Set<Long> getBillIdsForWorkflowPending(List<String> billIds) {
        HashSet<Long> workflowBillIds = new HashSet<Long>(16);
        Map billApproveMap = WorkflowServiceHelper.getApproversMapByBusinessKeys((String[])billIds.toArray(new String[billIds.size()]));
        if (CollectionUtils.isNotEmpty((Map)billApproveMap)) {
            LinkedHashSet userIds = Sets.newLinkedHashSet();
            for (Map.Entry entry : billApproveMap.entrySet()) {
                userIds.clear();
                userIds.addAll((Collection)entry.getValue());
                if (!userIds.contains(UserUtils.getUserId())) continue;
                workflowBillIds.add(IDUtils.toLong(entry.getKey()));
            }
        }
        return workflowBillIds;
    }

    protected Set<Long> getBillIdsForLocalSubmit(List<String> billIds) {
        HashSet<String> workflowBillIds = new HashSet<String>(billIds.size());
        List partitionList = Lists.partition(billIds, (int)500);
        for (List partitionIds : partitionList) {
            QFilter recordFilter = new QFilter("businesskey", "in", (Object)partitionIds);
            DynamicObjectCollection recordList = QueryServiceHelper.query((String)"wf_hicomment", (String)"businesskey", (QFilter[])recordFilter.toArray());
            for (DynamicObject record : recordList) {
                workflowBillIds.add(record.getString("businesskey"));
            }
        }
        HashSet<String> copyBillIds = new HashSet<String>(billIds);
        copyBillIds.removeAll(workflowBillIds);
        if (CollectionUtils.isEmpty(copyBillIds)) {
            return Sets.newHashSet();
        }
        HashSet ids = new HashSet(16);
        copyBillIds.stream().forEach(id -> ids.add(IDUtils.toLong((Object)id)));
        HashSet<Long> localBillIds = new HashSet<Long>(16);
        QFilter qFilter = new QFilter("id", "in", ids);
        qFilter.and(new QFilter("billstatus", "=", (Object)ApproveBillStatus.SUBMIT.getNumber()));
        qFilter.and(new QFilter("createrid.id", "=", (Object)UserUtils.getUserId()));
        DynamicObjectCollection approveBills = QueryServiceHelper.query((String)"eb_approvebill", (String)"id,eborgid.id", (QFilter[])qFilter.toArray());
        for (DynamicObject approveBill : approveBills) {
            Long billId = approveBill.getLong("id");
            localBillIds.add(billId);
        }
        return localBillIds;
    }

    protected Set<Long> getBillIdsForWorkflowSubmit(List<String> billIds) {
        HashSet<Long> filterBillIds = new HashSet<Long>(16);
        List partitionList = Lists.partition(billIds, (int)500);
        for (List partitionIds : partitionList) {
            QFilter recordFilter = new QFilter("businesskey", "in", (Object)partitionIds);
            recordFilter.and(new QFilter("userid", "=", (Object)UserUtils.getUserId()));
            recordFilter.and(new QFilter("resultnumber", "=", (Object)"submit"));
            DynamicObjectCollection recordList = QueryServiceHelper.query((String)"wf_hicomment", (String)"businesskey", (QFilter[])recordFilter.toArray());
            for (DynamicObject record : recordList) {
                filterBillIds.add(record.getLong("businesskey"));
            }
        }
        return filterBillIds;
    }

    protected Set<Long> getBillIdsForMyProcessed(List<String> billIds) {
        HashSet<Long> filterBillIds = new HashSet<Long>(16);
        Long curUserId = UserUtils.getUserId();
        List partitionList = Lists.partition(billIds, (int)500);
        for (List partitionIds : partitionList) {
            QFilter recordFilter = new QFilter("businesskey", "in", (Object)partitionIds);
            recordFilter.and(new QFilter("userid", "=", (Object)curUserId));
            recordFilter.and(new QFilter("resultnumber", "=", (Object)"submit").or(new QFilter("decisiontype", "in", (Object)Sets.newHashSet((Object[])new String[]{"approve", "reject"}))));
            DynamicObjectCollection recordList = QueryServiceHelper.query((String)"wf_hicomment", (String)"businesskey", (QFilter[])recordFilter.toArray());
            for (DynamicObject record : recordList) {
                filterBillIds.add(record.getLong("businesskey"));
            }
        }
        return filterBillIds;
    }

    protected Set<Long> getBillIdsForMyAudit(List<String> billIds) {
        HashSet<Long> filterBillIds = new HashSet<Long>(16);
        Long curUserId = UserUtils.getUserId();
        List partitionList = Lists.partition(billIds, (int)500);
        for (List partitionIds : partitionList) {
            QFilter recordFilter = new QFilter("businesskey", "in", (Object)partitionIds);
            recordFilter.and(new QFilter("userid", "=", (Object)curUserId));
            recordFilter.and(new QFilter("decisiontype", "in", (Object)Sets.newHashSet((Object[])new String[]{"approve", "reject"})));
            DynamicObjectCollection recordList = QueryServiceHelper.query((String)"wf_hicomment", (String)"businesskey", (QFilter[])recordFilter.toArray());
            for (DynamicObject record : recordList) {
                filterBillIds.add(record.getLong("businesskey"));
            }
        }
        return filterBillIds;
    }

    private Map<Long, String> getLocalBillOrgMap(List<String> billIds) {
        HashSet<String> workflowBillIds = new HashSet<String>(billIds.size());
        List partitionList = Lists.partition(billIds, (int)500);
        for (List partitionIds : partitionList) {
            QFilter recordFilter = new QFilter("businesskey", "in", (Object)partitionIds);
            DynamicObjectCollection recordList = QueryServiceHelper.query((String)"wf_hicomment", (String)"businesskey", (QFilter[])recordFilter.toArray());
            for (DynamicObject record : recordList) {
                workflowBillIds.add(record.getString("businesskey"));
            }
        }
        HashSet<String> copyBillIds = new HashSet<String>(billIds);
        copyBillIds.removeAll(workflowBillIds);
        if (CollectionUtils.isEmpty(copyBillIds)) {
            return Maps.newHashMap();
        }
        HashSet localBillIds = new HashSet(16);
        copyBillIds.stream().forEach(id -> localBillIds.add(IDUtils.toLong((Object)id)));
        QFilter qFilter = new QFilter("id", "in", localBillIds);
        qFilter.and(new QFilter("billstatus", "=", (Object)ApproveBillStatus.SUBMIT.getNumber()));
        DynamicObjectCollection approveBills = QueryServiceHelper.query((String)"eb_approvebill", (String)"id,bizmodelid.id,orgviewid.id,eborgid.id", (QFilter[])qFilter.toArray());
        HashMap<Long, String> billOrgMap = new HashMap<Long, String>(approveBills.size());
        for (DynamicObject approveBill : approveBills) {
            Long billId = approveBill.getLong("id");
            Long bizModelId = approveBill.getLong("bizmodelid.id");
            Long orgViewId = approveBill.getLong("orgviewid.id");
            Long orgId = approveBill.getLong("eborgid.id");
            billOrgMap.put(billId, bizModelId + "!" + orgViewId + "!" + orgId);
        }
        return billOrgMap;
    }
}

