/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.approveBill.filter;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.approveBill.filter.AbstractApproveBillFilterService;
import kd.epm.eb.common.approveBill.Entity.ApproveBillStatus;

public class MyAuditAndAllFilterService
extends AbstractApproveBillFilterService {
    @Override
    public QFilter getQFilter(Long modelId, List<String> billIds) {
        Set<Long> pendingIds = this.getBillIdsForMyPending(modelId, billIds);
        Set<Long> auditIds = this.getBillIdsForMyAudit(billIds);
        Set exIds = pendingIds.stream().filter(id -> !auditIds.contains(id)).collect(Collectors.toSet());
        if (!exIds.isEmpty()) {
            HashSet<Long> rejectIds = new HashSet<Long>(16);
            QFilter qFilter = new QFilter("id", "in", exIds);
            DynamicObjectCollection approveBills = QueryServiceHelper.query((String)"eb_approvebill", (String)"id,billstatus", (QFilter[])qFilter.toArray());
            for (DynamicObject approveBill : approveBills) {
                String billStatus = approveBill.getString("billstatus");
                if (!ApproveBillStatus.REJECT.getNumber().equals(billStatus)) continue;
                rejectIds.add(approveBill.getLong("id"));
            }
            if (!rejectIds.isEmpty()) {
                auditIds.removeAll(rejectIds);
            }
        }
        HashSet<Long> ids = new HashSet<Long>(16);
        ids.addAll(pendingIds);
        ids.addAll(auditIds);
        return new QFilter("id", "in", ids);
    }
}

