/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.approveBill.helper;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.epm.eb.business.approvetype.ApproveUtils;
import kd.epm.eb.business.bailorg.BailOrgService;
import kd.epm.eb.business.centralrelation.CentralRelationShotService;
import kd.epm.eb.business.ebupgrades.utils.UpgradesTaskUtil;
import kd.epm.eb.business.examinev2.service.ExamineCheckServiceImpl;
import kd.epm.eb.common.approveBill.ApproveBillQuery;
import kd.epm.eb.common.approveBill.Entity.ApproveBillSubMitDim;
import kd.epm.eb.common.approveBill.dto.SubmitBillToWorkFlowResult;
import kd.epm.eb.common.bgmddatalock.v2.DataLockService;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.enums.BgTaskStateEnum;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.TriggerEventEnum;
import kd.epm.eb.common.examine.domain.report.ExamineCheckReport;
import kd.epm.eb.common.examine.request.MultiExamineCheckRequest;
import kd.epm.eb.common.examine.request.ReportCheckRange;
import kd.epm.eb.common.examine.request.ReportCheckRangeRequest;
import kd.epm.eb.common.examine.request.SchemeOrTaskReqeust;
import kd.epm.eb.common.params.ParamEnum;
import kd.epm.eb.common.params.ParamQueryServiceHelper;
import kd.epm.eb.common.reportprocess.entity.request.UpdateRptProcessStatusRequest;
import kd.epm.eb.common.reportprocess.helper.ApproveBillHelper;
import kd.epm.eb.common.reportprocess.service.impl.ReportProcessAggService;
import kd.epm.eb.common.thread.EpmThreadPools;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.cache.Cache;
import kd.epm.eb.spread.utils.ReportVar.ReportVarUtil;
import org.apache.commons.collections4.CollectionUtils;

public class ApproveBillSubmitHelper {
    private static final ApproveBillSubmitHelper instance = new ApproveBillSubmitHelper();
    private static final String CON_BILLSTATUS = "billstatus";
    private static final Log log = LogFactory.getLog(ApproveBillSubmitHelper.class);

    public static ApproveBillSubmitHelper getInstance() {
        return instance;
    }

    public OperationResult submitApproveBillWithShowMessage(IFormView formView, String appId, String formId, Long modelId, Set<Long> approveBillIdSet, OperateOption operateOption) {
        BillList billList;
        String viewFormId;
        SubmitBillToWorkFlowResult submitBillToWorkFlowResult = this.submitApproveBill(appId, formId, approveBillIdSet, operateOption);
        if (formView != null && StringUtils.isNotEmpty((CharSequence)(viewFormId = formView.getFormShowParameter().getFormId())) && (billList = (BillList)formView.getControl("billlistap")) != null) {
            billList.refresh();
        }
        return submitBillToWorkFlowResult.getOperationResult();
    }

    public void autoAddBailOrg(Set<Long> submitSuccessBillIds, Long modelId) {
        HashMap approveMemberMap = new HashMap(16);
        DynamicObjectCollection approveBillInfos = QueryServiceHelper.query((String)"eb_approvebill", (String)"id, eborgid.number", (QFilter[])new QFilter[]{new QFilter("id", "in", submitSuccessBillIds)});
        approveBillInfos.forEach(e -> approveMemberMap.computeIfAbsent(e.getString("eborgid.number"), k -> new ArrayList(16)).add(e.getLong("id")));
        Map<String, Long> defaultBailOrgIds = BailOrgService.getInstance().getDefaultBailOrgIds(modelId, approveMemberMap.keySet());
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("delete from t_eb_approvebailorg where ", new Object[0]);
        sqlBuilder.appendIn("fid", submitSuccessBillIds.toArray());
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
        String sql = "insert into t_eb_approvebailorg(fpkid,fid,fbasedataid) values (?,?,?)";
        ArrayList<Object[]> params = new ArrayList<Object[]>(16);
        for (Map.Entry entry : approveMemberMap.entrySet()) {
            String memberNumber = (String)entry.getKey();
            Long defaultBailOrg = defaultBailOrgIds.get(memberNumber);
            if (defaultBailOrg == null) continue;
            List approveBillIds = (List)entry.getValue();
            for (Long approveBillId : approveBillIds) {
                params.add(new Object[]{0L, approveBillId, defaultBailOrg});
            }
        }
        if (params.size() != 0) {
            long[] pkIds = DB.genGlobalLongIds((int)params.size());
            for (int i = 0; i < params.size(); ++i) {
                Object[] param = (Object[])params.get(i);
                param[0] = pkIds[i];
            }
            DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql, params);
        }
        UpgradesTaskUtil.getInstance().clearDataEntityCache("eb_approvebill");
    }

    public SubmitBillToWorkFlowResult submitApproveBill(String appId, String formId, Set<Long> approveBillIdSet, OperateOption operateOption) {
        SubmitBillToWorkFlowResult result = new SubmitBillToWorkFlowResult();
        if (CollectionUtils.isEmpty(approveBillIdSet)) {
            return result;
        }
        try (TXHandle txHandle = TX.requiresNew((String)"epm-eb-submitApproveBill");){
            try {
                log.info("begin submitApproveBill.");
                result = this.submitBillToWorkFlow(appId, formId, approveBillIdSet, operateOption);
                if (result.isSuccess()) {
                    this.updateRptProcess(result.getSubmitSuccessApproveBillIds(), BgTaskStateEnum.UNDERWAY, operateOption, result.getOperationResult());
                    this.updateBillStatus(result.getSubmitSuccessApproveBillIds(), "B");
                    Set<Long> approveReportProcessIds = ApproveUtils.getInstance().getApproveReportProcessIds(result.getSubmitSuccessApproveBillIds());
                    ApproveUtils.getInstance().updateRejectBillStatus(approveBillIdSet, approveReportProcessIds);
                }
            }
            catch (Exception exception) {
                log.info("exception submitApproveBill.");
                log.error((Throwable)exception);
                txHandle.markRollback();
                throw exception;
            }
        }
        log.info("end submitApproveBill.");
        return result;
    }

    private SubmitBillToWorkFlowResult submitBillToWorkFlow(String appId, String formId, Set<Long> approveBillIdSet, OperateOption operateOption) {
        SubmitBillToWorkFlowResult result = new SubmitBillToWorkFlowResult();
        if (CollectionUtils.isEmpty(approveBillIdSet)) {
            return result;
        }
        if (operateOption == null) {
            operateOption = OperateOption.create();
        }
        operateOption.setVariableValue("loopSubmit", "true");
        operateOption.setVariableValue("currbizappid", appId);
        CountDownLatch countDownLatch = new CountDownLatch(approveBillIdSet.size());
        for (Long approveBillId : approveBillIdSet) {
            Object[] ids = new Object[]{approveBillId};
            EpmThreadPools.CommPools.submit((Callable)new SubmitCallable(formId, countDownLatch, ids, operateOption, result));
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            log.error((Throwable)e);
            throw new KDBizException("submit thread throw interrupted.");
        }
        Set submitSuccessApproveBillIds = result.getSubmitSuccessApproveBillIds();
        if (CollectionUtils.isNotEmpty((Collection)submitSuccessApproveBillIds)) {
            result.setSuccess(true);
            List pkIds = submitSuccessApproveBillIds.stream().collect(Collectors.toList());
            result.getOperationResult().setSuccessPkIds(pkIds);
            result.getOperationResult().setMessage(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\u3002", (String)"ApproveBillList_001", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            result.setSuccess(false);
            result.getOperationResult().setMessage(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\u3002", (String)"ApproveBillList_002", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return result;
    }

    public void updateRptProcess(Set<Long> approveBillIdSet, BgTaskStateEnum bgTaskStateEnum, OperateOption operateOption, OperationResult operationResult) {
        if (CollectionUtils.isEmpty(approveBillIdSet)) {
            return;
        }
        this.updateReportStatus(approveBillIdSet, bgTaskStateEnum, operateOption, operationResult);
    }

    private boolean isForwardUpdate(BgTaskStateEnum taskState) {
        switch (taskState) {
            case UNDERWAY: 
            case COMPLETED: {
                return true;
            }
        }
        return false;
    }

    protected void updateReportStatus(Set<Long> canDoBills, BgTaskStateEnum enumStatus, OperateOption option, OperationResult operationResult) {
        log.info("begin_updateReportStatus!");
        if (canDoBills == null || canDoBills.size() == 0) {
            log.info("updateReportStatus_null!");
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u80fd\u64cd\u4f5c\u7684\u5408\u6cd5\u5ba1\u6279\u5355\u636e\u3002", (String)"CommitCancel_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        try {
            this.arrangeAndUpdateData(canDoBills, enumStatus, operationResult, option);
            ApproveUtils.getInstance().deleteApproveBillReadRecord(canDoBills);
        }
        catch (Exception e) {
            log.info(StringUtils.join((Object[])new String[]{"submitReport_updateReportStatus_fail!", e.getMessage(), Arrays.toString(e.getStackTrace())}));
            throw new KDException(new ErrorCode("AuditOp.updateReportStatus", e.getMessage()), "AuditOp.updateReportStatus", (Throwable)e);
        }
        log.info("submitReport_updateReportStatus_end");
    }

    protected void arrangeAndUpdateData(Set<Long> canDoBills, BgTaskStateEnum enumStatus, OperationResult operationResult, OperateOption operateOption) {
        log.info("submitReport_arrangeAndUpdateData");
        if (canDoBills == null || canDoBills.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u80fd\u64cd\u4f5c\u7684\u5408\u6cd5\u5ba1\u6279\u5355\u636e\u3002", (String)"CommitCancel_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Map<Long, ApproveBillSubMitDim> submitDims = this.getSubMitDims(canDoBills, enumStatus);
        if (submitDims == null) {
            log.info("submitReport_submitDims==null");
            return;
        }
        this.saveApproveDesc(submitDims, operateOption);
        log.info("submitReport_getStatusRequest");
        ArrayList<UpdateRptProcessStatusRequest> list = new ArrayList<UpdateRptProcessStatusRequest>(16);
        for (Map.Entry<Long, ApproveBillSubMitDim> submitDim : submitDims.entrySet()) {
            Long aLong = submitDim.getKey();
            log.info("submitReport_getStatusRequest1");
            UpdateRptProcessStatusRequest statusRequest = this.getStatusRequest(aLong, submitDim.getValue(), enumStatus);
            statusRequest.setApproveBillId(aLong);
            list.add(statusRequest);
        }
        log.info("submitReport_updateReportProcessStatus");
        ReportProcessAggService.getInstance().updateReportProcessStatus(list);
        Set centralBillIds = ApproveBillHelper.filterCentralBill(canDoBills);
        log.info("submitReport_doDatalock");
        for (UpdateRptProcessStatusRequest updateRptProcessStatusRequest : list) {
            if (!BgTaskStateEnum.UNDERWAY.getNumber().equals(enumStatus.getNumber()) || centralBillIds.contains(updateRptProcessStatusRequest.getApproveBillId())) continue;
            log.info("submitReport_doDatalock1");
            this.doDatalock(submitDims.get(updateRptProcessStatusRequest.getApproveBillId()), updateRptProcessStatusRequest.getApproveBillId(), operationResult);
        }
        log.info("submitReport_doUnDatalock");
        if (BgTaskStateEnum.INCOMPLETE.getNumber().equals(enumStatus.getNumber()) || BgTaskStateEnum.TEMPSAVE.getNumber().equals(enumStatus.getNumber())) {
            log.info("submitReport_doUnDatalock2");
            this.doUnDatalock(submitDims, centralBillIds, operationResult);
        }
        log.info("submitReport_arrangeAndUpdateData_end");
    }

    private void saveApproveDesc(Map<Long, ApproveBillSubMitDim> submitDims, OperateOption option) {
        if (submitDims.size() == 0) {
            return;
        }
        if (!option.containsVariable("descInfo")) {
            return;
        }
        ApproveUtils.getInstance().saveApproveDesc(submitDims.keySet(), option.getVariables());
    }

    private void doDatalock(ApproveBillSubMitDim submitDims, Long approveBillId, OperationResult operationResult) {
        JSONObject paramMap;
        if (StringUtils.isEmpty((CharSequence)submitDims.getSelectOrg())) {
            return;
        }
        if (submitDims.getCommitType().equals("2") && Objects.nonNull(paramMap = ParamQueryServiceHelper.getJSON((long)submitDims.getModelId(), (ParamEnum)ParamEnum.BG011)) && paramMap.getBoolean("datalockswitch").booleanValue()) {
            Long auditTrailId = paramMap.getLong("audittrail");
            DataLockService.getInstance().lock(operationResult, submitDims.getModelId(), submitDims.getBizModelId(), submitDims.getViewId(), submitDims.getVersionId(), submitDims.getDataTypeId(), auditTrailId, submitDims.getSelectOrg(), submitDims.getYearPeriodId());
            Cache.get().set("approve_datalock_audittrail:" + approveBillId, String.valueOf(auditTrailId));
        }
    }

    private void doUnDatalock(Map<Long, ApproveBillSubMitDim> submitDims, Set<Long> centralBillIds, OperationResult operationResult) {
        for (Map.Entry<Long, ApproveBillSubMitDim> submitDim : submitDims.entrySet()) {
            String audittrail;
            if (centralBillIds.contains(submitDim.getKey()) || !submitDim.getValue().getCommitType().equals("2")) continue;
            DynamicObject[] billInfsByIds = ApproveBillQuery.getInstance().queryBillInfs(submitDim.getValue());
            ArrayList<Long> allIdByDim = null;
            if (billInfsByIds != null) {
                allIdByDim = new ArrayList<Long>(billInfsByIds.length);
                for (DynamicObject dynamicObject : billInfsByIds) {
                    allIdByDim.add(dynamicObject.getLong("id"));
                }
            }
            if (!StringUtils.isNotEmpty((CharSequence)(audittrail = Cache.get().get("approve_datalock_audittrail:" + submitDim.getKey())))) continue;
            if (allIdByDim != null) {
                allIdByDim.remove(submitDim.getKey());
                if (!allIdByDim.isEmpty()) {
                    Cache.get().remove("approve_datalock_audittrail:" + submitDim.getKey());
                    continue;
                }
            }
            DataLockService.getInstance().unLock(operationResult, submitDim.getValue().getModelId(), submitDim.getValue().getBizModelId(), submitDim.getValue().getViewId(), submitDim.getValue().getVersionId(), submitDim.getValue().getDataTypeId(), Long.valueOf(Long.parseLong(audittrail)), submitDim.getValue().getSelectOrg(), submitDim.getValue().getYearPeriodId());
            Cache.get().remove("approve_datalock_audittrail:" + submitDim.getKey());
        }
    }

    private Map<Long, ApproveBillSubMitDim> getSubMitDims(Set<Long> canDoBills, BgTaskStateEnum enumStatus) {
        ApproveBillQuery queryObj = ApproveBillQuery.getInstance();
        DynamicObject[] billInfsByIds = queryObj.queryBillInfsByIds(canDoBills);
        if (billInfsByIds == null || billInfsByIds.length == 0) {
            return null;
        }
        Long modelId = billInfsByIds[0].getLong("modelid.id");
        if (IDUtils.isNull((Long)modelId)) {
            return null;
        }
        boolean forwardFlag = this.isForwardUpdate(enumStatus);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        List<DynamicObject> billInfsSet = this.loadBillInfoSort(forwardFlag, modelCacheHelper, billInfsByIds);
        return queryObj.getApproveBillSubMitDims(billInfsSet);
    }

    private List<DynamicObject> loadBillInfoSort(final boolean forwardFlag, final IModelCacheHelper modelCacheHelper, DynamicObject[] billInfsByIds) {
        List<DynamicObject> objectList = Arrays.asList(billInfsByIds);
        objectList.sort(new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                if (o1 == null || o2 == null) {
                    return 0;
                }
                Long orgId1 = o1.getLong("eborgid.id");
                Long orgId2 = o2.getLong("eborgid.id");
                Long viewId1 = o1.getLong("orgviewid.id");
                Long viewId2 = o2.getLong("orgviewid.id");
                if (IDUtils.isNull((Long)orgId1) || IDUtils.isNull((Long)orgId2)) {
                    return 0;
                }
                Member member1 = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), viewId1, orgId1);
                Member member2 = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), viewId2, orgId2);
                if (member1 == null || member2 == null) {
                    return 0;
                }
                if (forwardFlag) {
                    return Integer.compare(member2.getLevel(), member1.getLevel());
                }
                return Integer.compare(member1.getLevel(), member2.getLevel());
            }
        });
        return objectList;
    }

    private UpdateRptProcessStatusRequest getStatusRequest(Long approveBillId, ApproveBillSubMitDim submitDim, BgTaskStateEnum enumStatus) {
        if (this.isForwardUpdate(enumStatus)) {
            return new UpdateRptProcessStatusRequest(submitDim.getModelId(), submitDim.getViewId(), submitDim.getTempIds(), submitDim.getOrgId(), submitDim.getYearPeriodId(), submitDim.getDataTypeId(), submitDim.getVersionId(), approveBillId, enumStatus);
        }
        return new UpdateRptProcessStatusRequest(submitDim.getModelId(), submitDim.getViewId(), submitDim.getTempIds(), submitDim.getOrgId(), submitDim.getYearPeriodId(), submitDim.getDataTypeId(), submitDim.getVersionId(), enumStatus, false);
    }

    public void updateBillStatus(Set<Long> fids, String status) {
        if (CollectionUtils.isEmpty(fids)) {
            return;
        }
        try {
            DynamicObject[] bills;
            for (DynamicObject dynamicObject : bills = BusinessDataServiceHelper.load((String)"eb_approvebill", (String)CON_BILLSTATUS, (QFilter[])new QFilter[]{new QFilter("id", "in", fids)})) {
                dynamicObject.set(CON_BILLSTATUS, (Object)status);
            }
            SaveServiceHelper.save((DynamicObject[])bills);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        log.info("submitReport_updateBillStatus_end");
    }

    public List<ExamineCheckReport> batCheckExamine(Collection<DynamicObject> billObjs, Map<Long, List<Long>> reportProcessIdsByBill) {
        Long modelId = null;
        HashSet<Long> billIds = new HashSet<Long>(billObjs.size());
        for (DynamicObject object : billObjs) {
            billIds.add(object.getLong("id"));
            modelId = object.getLong("modelid.id");
        }
        Set centralBillIds = ApproveBillHelper.filterCentralBill(billIds);
        HashMap allCentralBillRange = new HashMap(centralBillIds.size());
        centralBillIds.forEach(billId -> {
            List<Map<String, List<MemberCondition>>> centralRelShotDimMemberInfo = CentralRelationShotService.getInstance().getCentralRelShotDimMemberInfo((Long)billId);
            if (centralRelShotDimMemberInfo != null && centralRelShotDimMemberInfo.size() > 0) {
                allCentralBillRange.put(billId, centralRelShotDimMemberInfo);
            }
        });
        if (reportProcessIdsByBill == null) {
            reportProcessIdsByBill = ApproveUtils.getInstance().getReportProcessIdsByBill(billObjs);
        }
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        ArrayList<ExamineCheckReport> reportList = new ArrayList<ExamineCheckReport>(16);
        for (DynamicObject billObj : billObjs) {
            ProcessTypeEnum processTypeEnum;
            boolean fromTask;
            ArrayList<SchemeOrTaskReqeust> reportRequestList = new ArrayList<SchemeOrTaskReqeust>(16);
            SchemeOrTaskReqeust schemeOrTaskReqeust = new SchemeOrTaskReqeust();
            schemeOrTaskReqeust.setReportProcessType(Integer.valueOf(billObj.getInt("rptprocesstype")));
            boolean bl = fromTask = ProcessTypeEnum.REPORT.getIndex() != billObj.getInt("rptprocesstype");
            if (fromTask) {
                schemeOrTaskReqeust.setTaskProcessId(Long.valueOf(billObj.getLong("source_id")));
                processTypeEnum = ProcessTypeEnum.TASK;
            } else {
                QFilter filter = new QFilter("model", "=", (Object)modelId);
                filter.and("scheme", "=", (Object)billObj.getLong("source.id"));
                filter.and("year", "=", (Object)billObj.getLong("dim_period.id"));
                filter.and("datatype", "=", (Object)billObj.getLong("dim_datatype.id"));
                filter.and("version", "=", (Object)billObj.getLong("dim_version.id"));
                DynamicObject schemeAssign = QueryServiceHelper.queryOne((String)"eb_schemeassign", (String)"id", (QFilter[])filter.toArray());
                if (schemeAssign == null) continue;
                schemeOrTaskReqeust.setTaskProcessId(Long.valueOf(schemeAssign.getLong("id")));
                processTypeEnum = ProcessTypeEnum.REPORT;
            }
            schemeOrTaskReqeust.setApproveBillId(Long.valueOf(billObj.getLong("id")));
            schemeOrTaskReqeust.setReportProcessId(reportProcessIdsByBill.get(billObj.getLong("id")));
            reportRequestList.add(schemeOrTaskReqeust);
            ReportCheckRangeRequest reportCheckRangeRequest = new ReportCheckRangeRequest();
            reportCheckRangeRequest.setModel(modelId);
            reportCheckRangeRequest.setReportList(reportRequestList);
            List<ReportCheckRange> reportCheckRanges = ExamineCheckServiceImpl.getInstance().getReportCheckRange(reportCheckRangeRequest);
            reportCheckRanges.forEach(range -> {
                List rangeFilter = (List)allCentralBillRange.get(range.getApproveBillId());
                if (rangeFilter != null) {
                    ApproveUtils.getInstance().filterExamineRangeByBillRange((ReportCheckRange)range, rangeFilter, modelCache);
                }
            });
            MultiExamineCheckRequest multiExamineCheckRequest = new MultiExamineCheckRequest();
            multiExamineCheckRequest.setExecutorId(UserUtils.getUserId());
            multiExamineCheckRequest.setModelId(modelId);
            multiExamineCheckRequest.setTriggerEvent(TriggerEventEnum.BUDGET_TABLE_SUBMIT);
            multiExamineCheckRequest.setReportCheckRangeList(reportCheckRanges);
            multiExamineCheckRequest.setProcessTypeEnum(processTypeEnum);
            multiExamineCheckRequest.setVarValues(ReportVarUtil.getVarValues((Integer)processTypeEnum.getIndex(), (Long)modelId, (Long)schemeOrTaskReqeust.getTaskProcessId()));
            reportList.addAll(ExamineCheckServiceImpl.getInstance().multiCheck(multiExamineCheckRequest));
        }
        return reportList;
    }

    static class SubmitCallable
    implements Callable<String> {
        private final Object[] billIds;
        private final OperateOption operateOption;
        private final SubmitBillToWorkFlowResult result;
        private final String formId;
        private final CountDownLatch countDownLatch;

        public SubmitCallable(String formId, CountDownLatch countDownLatch, Object[] billIds, OperateOption operateOption, SubmitBillToWorkFlowResult result) {
            this.formId = formId;
            this.countDownLatch = countDownLatch;
            this.billIds = billIds;
            this.operateOption = operateOption;
            this.result = result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String call() {
            try {
                Long approveBillId = IDUtils.toLong((Object)this.billIds[0]);
                Map variablesTemp = this.operateOption.getVariables();
                HashMap variables = new HashMap(16);
                if (variablesTemp != null) {
                    variables.putAll(variablesTemp);
                }
                WorkflowServiceHelper.tryTriggerProcess((String)(approveBillId + ""), (String)"submit", (String)this.formId, variables);
                this.result.getSubmitSuccessApproveBillIds().add(approveBillId);
            }
            catch (Exception exception) {
                log.error((Throwable)exception);
            }
            finally {
                this.countDownLatch.countDown();
            }
            return null;
        }
    }
}

