/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.approvetype;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.approvetype.aproveAuditType.ApproveBaseType;
import kd.epm.eb.business.approvetype.aproveAuditType.ApproveTempType;
import kd.epm.eb.business.centralrelation.CentralRelationService;
import kd.epm.eb.common.applyTemplate.helper.ExcelHelper;
import kd.epm.eb.common.approveBill.Entity.AllocateDetailRecord;
import kd.epm.eb.common.approveBill.Entity.AllocateRecord;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.pojo.TemplateEntryPojo;
import kd.epm.eb.common.templateperm.TemplateTypeEnum;
import kd.epm.eb.common.utils.CollectionUtils;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFDataValidationHelper;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ApproveTypeUtils {
    private static final ApproveTypeUtils instance = new ApproveTypeUtils();

    public static ApproveTypeUtils getInstance() {
        return instance;
    }

    public AllocateRecord buildAllocatedRecordFromDB(QFilter qFilter) {
        DynamicObjectCollection allocatedRecords = QueryServiceHelper.query((String)"eb_approvaltypeentity", (String)"id, name, audit_type, entryentity.template as template, entryentity.applytemplate as applytemplate, entryentity.templatetype as templatetype,entryentity.entity as entity, entryentity.entity_range as range, curdataversion, entryentity.dataversion as dataversion, entryentity.audittype as audittype", (QFilter[])new QFilter[]{qFilter});
        HashMap<Long, AllocateDetailRecord> recordMap = new HashMap<Long, AllocateDetailRecord>(16);
        AllocateRecord allocateRecord = new AllocateRecord();
        HashMap<String, ApproveBaseType> approveTypeMap = new HashMap<String, ApproveBaseType>(16);
        for (DynamicObject allocatedRecord : allocatedRecords) {
            long curDataVersion = allocatedRecord.getLong("curdataversion");
            long dataVersion = allocatedRecord.getLong("dataversion");
            String auditType = allocatedRecord.getString("audit_type");
            String audittype = allocatedRecord.getString("audittype");
            if (curDataVersion != dataVersion || !auditType.equals(audittype)) continue;
            long pkId = allocatedRecord.getLong("id");
            String templateType = allocatedRecord.getString("templatetype");
            long templateId = TemplateTypeEnum.APPLY.getCode().equals(templateType) ? allocatedRecord.getLong("applytemplate") : allocatedRecord.getLong("template");
            long entityId = allocatedRecord.getLong("entity");
            String range = allocatedRecord.getString("range");
            String name = allocatedRecord.getString("name");
            ApproveBaseType approveType = approveTypeMap.computeIfAbsent(auditType, k -> this.getApproveType(auditType, null, null));
            approveType.buildAllocatedRecordFromDB(recordMap, allocateRecord, pkId, templateId, templateType, entityId, range, name, dataVersion);
        }
        return allocateRecord;
    }

    public boolean checkRecordConflict(AllocateRecord toAllocateRecord, AllocateRecord allocatedRecord, Set<String> conflictTypeNames, Long modelId, Long viewId) {
        if (allocatedRecord == null) {
            return false;
        }
        List entityRecords = allocatedRecord.getEntityRecords();
        List templateRecords = allocatedRecord.getTemplateRecords();
        List mixRecords = allocatedRecord.getMixRecords();
        List toAllocateTemplateRecords = toAllocateRecord.getTemplateRecords();
        if (toAllocateTemplateRecords.size() != 0) {
            AllocateDetailRecord allocateDetailRecord = (AllocateDetailRecord)toAllocateTemplateRecords.get(0);
            if (entityRecords.size() != 0) {
                entityRecords.forEach(e -> conflictTypeNames.add(e.getRecordName()));
            } else {
                List templates = allocateDetailRecord.getTemplates();
                for (AllocateDetailRecord templateRecord : templateRecords) {
                    List compareTemplates = templateRecord.getTemplates();
                    compareTemplates.retainAll(templates);
                    if (compareTemplates.size() == 0) continue;
                    conflictTypeNames.add(templateRecord.getRecordName());
                }
                Set templateIds = templates.stream().map(TemplateEntryPojo::getId).collect(Collectors.toSet());
                for (AllocateDetailRecord mixRecord : mixRecords) {
                    Long template = mixRecord.getTemplate();
                    if (!templateIds.contains(template)) continue;
                    conflictTypeNames.add(mixRecord.getRecordName());
                }
            }
        }
        return conflictTypeNames.size() != 0;
    }

    public List<AllocateDetailRecord> matchingAllocateRecords(List<AllocateDetailRecord> toAllocateMixRecords, AllocateRecord allocatedRecord, Long modelId, Long viewId) {
        ArrayList<AllocateDetailRecord> matchingAllocateRecords = new ArrayList<AllocateDetailRecord>(16);
        List templateRecords = allocatedRecord.getTemplateRecords();
        HashMap templateTypeNameMap = new HashMap(16);
        for (AllocateDetailRecord templateRecord : templateRecords) {
            List compareTemplates = templateRecord.getTemplates();
            if (CollectionUtils.isEmpty((Collection)compareTemplates)) continue;
            compareTemplates.forEach(e -> templateTypeNameMap.put(e.getId(), templateRecord));
        }
        for (AllocateDetailRecord toAllocateMixRecord : toAllocateMixRecords) {
            Long template = toAllocateMixRecord.getTemplate();
            AllocateDetailRecord type = (AllocateDetailRecord)templateTypeNameMap.get(template);
            if (type == null) continue;
            matchingAllocateRecords.add(type);
        }
        return matchingAllocateRecords;
    }

    public ApproveBaseType getApproveType(String auditType, IFormView view, IDataModel model) {
        if ("0".equals(auditType)) {
            return new ApproveTempType(view, model);
        }
        return new ApproveBaseType(view, model);
    }

    public Long getDefaultApproveType() {
        long defaultApproveType;
        QFilter qFilter = new QFilter("model", "=", (Object)0);
        qFilter.and("bizmodel", "=", (Object)0);
        qFilter.and("number", "=", (Object)"default");
        qFilter.and("status", "=", (Object)"1");
        DynamicObject approveType = QueryServiceHelper.queryOne((String)"eb_approvaltypeentity", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (approveType == null) {
            defaultApproveType = DB.genGlobalLongId();
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"eb_approvaltypeentity");
            dynamicObject.set("id", (Object)defaultApproveType);
            dynamicObject.set("number", (Object)"default");
            dynamicObject.set("name", (Object)ResManager.getLocaleString((String)"\u9ed8\u8ba4\u5ba1\u6279\u7c7b\u578b", (String)"ApproveTypeUtils_1", (String)"epm-eb-business"));
            dynamicObject.set("desc", (Object)ResManager.getLocaleString((String)"\u7cfb\u7edf\u9884\u7f6e\u5ba1\u6279\u7c7b\u578b\uff0c\u9002\u7528\u4e8e\u5ba1\u6838\u6240\u6709\u672a\u5173\u8054\u5ba1\u6279\u7c7b\u578b\u7684\u6a21\u677f\u5bf9\u5e94\u7684\u62a5\u8868\uff1b\u5373\uff0c\u8be5\u7c7b\u62a5\u8868\u5bf9\u5e94\u7684\u5ba1\u6279\u5355\u4e0a\u90fd\u9884\u7f6e\u4e0a\u8be5\u5ba1\u6279\u7c7b\u578b\u5c5e\u6027\u3002", (String)"ApproveTypeUtils_0", (String)"epm-eb-business"));
            dynamicObject.set("status", (Object)"1");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        } else {
            defaultApproveType = approveType.getLong("id");
        }
        return defaultApproveType;
    }

    public List<DynamicObject> filterCurVersionData(DynamicObjectCollection records, long curDataVersion, String type) {
        ArrayList<DynamicObject> curVersionRecords = new ArrayList<DynamicObject>(16);
        for (DynamicObject record : records) {
            long dataVersion = record.getLong("dataversion");
            String audittype = record.getString("audittype");
            if (curDataVersion != dataVersion || !type.equals(audittype)) continue;
            curVersionRecords.add(record);
        }
        return curVersionRecords;
    }

    public Map<Long, String> getCentralOrgMap(Long modelId, Set<Long> centralSchemaIds) {
        Map<Long, Set<Member>> centralRelationMap = CentralRelationService.getInstance().getCentralRelationEntities(modelId, centralSchemaIds);
        HashMap<Long, String> centralOrgMap = new HashMap<Long, String>(centralRelationMap.size());
        for (Map.Entry<Long, Set<Member>> entry : centralRelationMap.entrySet()) {
            String showNameStr;
            Long schemaId = entry.getKey();
            StringBuilder showName = new StringBuilder();
            for (Member member : entry.getValue()) {
                showName.append(member.getName()).append(";");
            }
            if (showName.length() > 0) {
                showName.deleteCharAt(showName.length() - 1);
            }
            if ((showNameStr = showName.toString()).length() > 75) {
                showNameStr = showNameStr.substring(0, 75) + "...";
            }
            centralOrgMap.put(schemaId, showNameStr);
        }
        return centralOrgMap;
    }

    public Set<Long> getCentralSchemaIds(IModelCacheHelper modelCacheHelper, Long approveTypeId, Long submitOrgId, Long orgViewId) {
        DynamicObject approveType = BusinessDataServiceHelper.loadSingleFromCache((Object)approveTypeId, (String)"eb_approvaltypeentity");
        if (approveType == null) {
            return null;
        }
        DynamicObjectCollection centralRelationColl = approveType.getDynamicObjectCollection("entryentity_relation");
        if (CollectionUtils.isEmpty((Collection)centralRelationColl)) {
            return null;
        }
        HashMap<Long, Set> budgetOrgSchemaMap = new HashMap<Long, Set>(centralRelationColl.size());
        HashSet<Long> centralSchemaIds = new HashSet<Long>(centralRelationColl.size());
        for (DynamicObject centralRelation : centralRelationColl) {
            Long budgetOrgId = centralRelation.getLong("budgetorg.id");
            Long schemaId = centralRelation.getLong("centralschema.id");
            boolean isValid = centralRelation.getBoolean("validstatus");
            if (!isValid) continue;
            Set schemaIds = budgetOrgSchemaMap.computeIfAbsent(budgetOrgId, v -> new HashSet(16));
            schemaIds.add(schemaId);
            if (!submitOrgId.equals(budgetOrgId)) continue;
            centralSchemaIds.add(schemaId);
        }
        if (CollectionUtils.isNotEmpty(budgetOrgSchemaMap) && CollectionUtils.isEmpty(centralSchemaIds)) {
            Member member = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), orgViewId, submitOrgId);
            List parentOrgList = modelCacheHelper.getParents(orgViewId, member, false);
            for (Member parentOrg : parentOrgList) {
                Long parentOrgId = parentOrg.getId();
                if (!budgetOrgSchemaMap.containsKey(parentOrgId)) continue;
                centralSchemaIds.addAll((Collection)budgetOrgSchemaMap.get(parentOrgId));
                break;
            }
        }
        return centralSchemaIds;
    }

    public Set<String> getApproveTypeNameByCentralSchema(Set<Long> centralSchemaIds) {
        QFilter qFilter = new QFilter("entryentity_relation.centralschema.id", "in", centralSchemaIds);
        DynamicObjectCollection approveTypeColl = QueryServiceHelper.query((String)"eb_approvaltypeentity", (String)"id,name", (QFilter[])qFilter.toArray());
        HashSet<String> resultSet = new HashSet<String>(approveTypeColl.size());
        for (DynamicObject approveTypeEntry : approveTypeColl) {
            String approveTypeName = approveTypeEntry.getString("name");
            resultSet.add(approveTypeName);
        }
        return resultSet;
    }

    public void deleteCentralRelation(Set<Long> centralSchemaIds) {
        if (CollectionUtils.isEmpty(centralSchemaIds)) {
            return;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("delete from t_eb_approvalrelation where ", new Object[0]);
        sqlBuilder.appendIn("fcentralschema", centralSchemaIds.toArray());
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
    }

    public void updateCentralRelationStatus(Set<Long> centralSchemaIds, boolean isEnable) {
        if (CollectionUtils.isEmpty(centralSchemaIds)) {
            return;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("update t_eb_approvalrelation set fvalidstatus = ? ", new Object[]{isEnable ? "1" : "0"});
        sqlBuilder.append("where ", new Object[0]);
        sqlBuilder.appendIn("fcentralschema", centralSchemaIds.toArray());
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
    }

    public void supportMultiLangForTitle(XSSFWorkbook workBook, boolean isNewEB) {
        workBook.setSheetName(0, ResManager.loadKDString((String)"\u5ba1\u6279\u7c7b\u578b", (String)"ApproveTypeUtils_19", (String)"epm-eb-business", (Object[])new Object[0]));
        XSSFSheet sheet = workBook.getSheetAt(0);
        ExcelHelper.setCellValue((XSSFSheet)sheet, null, (Integer)0, (Integer)0, (String)ResManager.loadKDString((String)"\u5ba1\u6279\u7c7b\u578b\u5f15\u5165\u6a21\u677f", (String)"ApproveTypeUtils_2", (String)"epm-eb-business", (Object[])new Object[0]));
        ExcelHelper.setCellValue((XSSFSheet)sheet, null, (Integer)1, (Integer)0, (String)ResManager.loadKDString((String)"\u7ea2\u8272*\u5fc5\u586b", (String)"ApproveTypeUtils_3", (String)"epm-eb-business", (Object[])new Object[0]));
        ExcelHelper.setCellValue((XSSFSheet)sheet, null, (Integer)2, (Integer)0, (String)ResManager.loadKDString((String)"*\u5ba1\u6279\u7c7b\u578b\u7f16\u7801", (String)"ApproveTypeUtils_4", (String)"epm-eb-business", (Object[])new Object[0]));
        ExcelHelper.setCellValue((XSSFSheet)sheet, null, (Integer)2, (Integer)1, (String)ResManager.loadKDString((String)"*\u5ba1\u6279\u7c7b\u578b\u540d\u79f0", (String)"ApproveTypeUtils_5", (String)"epm-eb-business", (Object[])new Object[0]));
        if (isNewEB) {
            ExcelHelper.setCellValue((XSSFSheet)sheet, null, (Integer)2, (Integer)2, (String)ResManager.loadKDString((String)"*\u9884\u7b97\u6a21\u677f\u7f16\u7801", (String)"ApproveTypeUtils_8", (String)"epm-eb-business", (Object[])new Object[0]));
            ExcelHelper.setCellValue((XSSFSheet)sheet, null, (Integer)2, (Integer)3, (String)ResManager.loadKDString((String)"\u9884\u7b97\u6a21\u677f\u540d\u79f0", (String)"ApproveTypeUtils_9", (String)"epm-eb-business", (Object[])new Object[0]));
            ExcelHelper.setCellValue((XSSFSheet)sheet, null, (Integer)2, (Integer)4, (String)ResManager.loadKDString((String)"*\u72b6\u6001", (String)"ApproveTypeUtils_10", (String)"epm-eb-business", (Object[])new Object[0]));
            ExcelHelper.setCellValue((XSSFSheet)sheet, null, (Integer)2, (Integer)5, (String)ResManager.loadKDString((String)"\u5f52\u53e3\u62c6\u5206\u6d41\u7a0b", (String)"ApproveTypeUtils_11", (String)"epm-eb-business", (Object[])new Object[0]));
            ExcelHelper.setCellValue((XSSFSheet)sheet, null, (Integer)2, (Integer)6, (String)ResManager.loadKDString((String)"\u5f52\u53e3\u65b9\u6848\u7f16\u7801", (String)"ApproveTypeUtils_12", (String)"epm-eb-business", (Object[])new Object[0]));
            ExcelHelper.setCellValue((XSSFSheet)sheet, null, (Integer)2, (Integer)7, (String)ResManager.loadKDString((String)"\u5f52\u53e3\u65b9\u6848\u540d\u79f0", (String)"ApproveTypeUtils_13", (String)"epm-eb-business", (Object[])new Object[0]));
        } else {
            ExcelHelper.setCellValue((XSSFSheet)sheet, null, (Integer)2, (Integer)2, (String)ResManager.loadKDString((String)"*\u4e1a\u52a1\u6a21\u578b\u7f16\u7801", (String)"ApproveTypeUtils_6", (String)"epm-eb-business", (Object[])new Object[0]));
            ExcelHelper.setCellValue((XSSFSheet)sheet, null, (Integer)2, (Integer)3, (String)ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u578b\u540d\u79f0", (String)"ApproveTypeUtils_7", (String)"epm-eb-business", (Object[])new Object[0]));
            ExcelHelper.setCellValue((XSSFSheet)sheet, null, (Integer)2, (Integer)4, (String)ResManager.loadKDString((String)"*\u9884\u7b97\u6a21\u677f\u7f16\u7801", (String)"ApproveTypeUtils_8", (String)"epm-eb-business", (Object[])new Object[0]));
            ExcelHelper.setCellValue((XSSFSheet)sheet, null, (Integer)2, (Integer)5, (String)ResManager.loadKDString((String)"\u9884\u7b97\u6a21\u677f\u540d\u79f0", (String)"ApproveTypeUtils_9", (String)"epm-eb-business", (Object[])new Object[0]));
            ExcelHelper.setCellValue((XSSFSheet)sheet, null, (Integer)2, (Integer)6, (String)ResManager.loadKDString((String)"*\u72b6\u6001", (String)"ApproveTypeUtils_10", (String)"epm-eb-business", (Object[])new Object[0]));
            ExcelHelper.setCellValue((XSSFSheet)sheet, null, (Integer)2, (Integer)7, (String)ResManager.loadKDString((String)"\u5f52\u53e3\u62c6\u5206\u6d41\u7a0b", (String)"ApproveTypeUtils_11", (String)"epm-eb-business", (Object[])new Object[0]));
            ExcelHelper.setCellValue((XSSFSheet)sheet, null, (Integer)2, (Integer)8, (String)ResManager.loadKDString((String)"\u5f52\u53e3\u65b9\u6848\u7f16\u7801", (String)"ApproveTypeUtils_12", (String)"epm-eb-business", (Object[])new Object[0]));
            ExcelHelper.setCellValue((XSSFSheet)sheet, null, (Integer)2, (Integer)9, (String)ResManager.loadKDString((String)"\u5f52\u53e3\u65b9\u6848\u540d\u79f0", (String)"ApproveTypeUtils_13", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        workBook.setSheetName(1, ResManager.loadKDString((String)"\u9884\u7b97\u6a21\u677f\u8303\u56f4", (String)"ApproveTypeUtils_20", (String)"epm-eb-business", (Object[])new Object[0]));
        XSSFSheet sheet1 = workBook.getSheetAt(1);
        ExcelHelper.setCellValue((XSSFSheet)sheet1, null, (Integer)0, (Integer)0, (String)ResManager.loadKDString((String)"\u6a21\u677f\u8303\u56f4", (String)"ApproveTypeUtils_14", (String)"epm-eb-business", (Object[])new Object[0]));
        ExcelHelper.setCellValue((XSSFSheet)sheet1, null, (Integer)0, (Integer)2, (String)ResManager.loadKDString((String)"\u6a21\u677f\u7f16\u7801", (String)"ApproveTypeUtils_15", (String)"epm-eb-business", (Object[])new Object[0]));
        ExcelHelper.setCellValue((XSSFSheet)sheet1, null, (Integer)0, (Integer)3, (String)ResManager.loadKDString((String)"\u6a21\u677f\u540d\u79f0", (String)"ApproveTypeUtils_16", (String)"epm-eb-business", (Object[])new Object[0]));
        workBook.setSheetName(2, ResManager.loadKDString((String)"\u6a21\u677f\u4f7f\u7528\u8bf4\u660e", (String)"ApproveTypeUtils_21", (String)"epm-eb-business", (Object[])new Object[0]));
        XSSFSheet sheet2 = workBook.getSheetAt(2);
        ExcelHelper.setCellValue((XSSFSheet)sheet2, null, (Integer)0, (Integer)0, (String)ResManager.loadKDString((String)"\u6a21\u677f\u4f7f\u7528\u8bf4\u660e\u4fe1\u606f", (String)"ApproveTypeUtils_17", (String)"epm-eb-business", (Object[])new Object[0]));
        ExcelHelper.setCellValue((XSSFSheet)sheet2, null, (Integer)1, (Integer)0, (String)ResManager.loadKDString((String)"1. \u5ba1\u6279\u7c7b\u578b\u7f16\u7801\u76f8\u540c\uff0c\u89c6\u4e3a\u540c\u4e00\u5ba1\u6279\u7c7b\u578b\u5bfc\u5165\uff0c\u7f16\u7801\u4e0d\u540c\u89c6\u4e3a\u4e0d\u540c\u5ba1\u6279\u7c7b\u578b\u636e\u5bfc\u5165", (String)"ApproveTypeUtils_18", (String)"epm-eb-business", (Object[])new Object[0]));
    }

    public void addDropDown(XSSFWorkbook workBook, String[] values, Integer firstRow, Integer lastRow, Integer firstCol, Integer lastCol) {
        XSSFSheet sheet0 = workBook.getSheetAt(0);
        XSSFDataValidationHelper helper = new XSSFDataValidationHelper(sheet0);
        DataValidationConstraint dvConstraint = helper.createExplicitListConstraint(values);
        CellRangeAddressList addressList = new CellRangeAddressList(firstRow.intValue(), lastRow.intValue(), firstCol.intValue(), lastCol.intValue());
        DataValidation validation = helper.createValidation(dvConstraint, addressList);
        validation.setSuppressDropDownArrow(true);
        validation.setShowErrorBox(true);
        sheet0.addValidationData(validation);
    }
}

