/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.approvetype.aproveAuditType;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.control.TreeView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.approvetype.aproveAuditType.ApproveBaseType;
import kd.epm.eb.common.approveBill.Entity.AllocateDetailRecord;
import kd.epm.eb.common.approveBill.Entity.AllocateRecord;
import kd.epm.eb.common.pojo.BasedataPojo;
import kd.epm.eb.common.pojo.TemplateEntryPojo;
import kd.epm.eb.common.templateperm.TemplateTypeEnum;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.StringUtils;

public class ApproveMixType
extends ApproveBaseType {
    public ApproveMixType(IFormView view, IDataModel model) {
        super(view, model);
    }

    @Override
    public void fillAllocateEntry(AllocateRecord allocateRecord, DynamicObjectCollection records, long curDataVersion, String type) {
    }

    @Override
    public AllocateRecord buildToAllocateRecordAndFilter(QFilter qFilter, Map<Long, TemplateEntryPojo> templateBaseInfo) {
        AllocateRecord record = new AllocateRecord();
        return record;
    }

    @Override
    protected void buildDetailRecords(AllocateRecord record, Set<Long> toQueryTemplates, Set<Long> toQueryEntities, QFilter qFilter, Long templateId, String templateType, Long entityId, String entityRange) {
    }

    @Override
    protected void setPanelVisible(List<String> unVisiblePanels, List<String> visiblePanels) {
    }

    @Override
    public void loadTree(Long bizModelId) {
        this.loadTemplateTree(bizModelId);
        this.loadOtherTree(bizModelId);
    }

    protected void loadOtherTree(Long bizModelId) {
    }

    @Override
    public void buildAllocatedRecordFromDB(Map<Long, AllocateDetailRecord> recordMap, AllocateRecord allocateRecord, long pkId, long templateId, String templateType, long entityId, String range, String name, long dataVersion) {
    }

    @Override
    public void addToHasAllocateRecordEntry(AllocateRecord toAllocateRecord, Map<Long, TemplateEntryPojo> templateBaseInfo, Long viewId) {
    }

    @Override
    public void bindAllocateRecord(List<DynamicObject> entryEntity, Long modelId) {
        if (entryEntity == null || entryEntity.size() == 0) {
            return;
        }
        this.getModel().deleteEntryData("entryentity_allocate");
        for (DynamicObject entry : entryEntity) {
            int row;
            TemplateEntryPojo temp = this.bindTemplateCols(entry, row = this.getModel().createNewEntryRow("entryentity_allocate"));
            if (temp == null) continue;
            Long entityId = this.bindEntityCols(entry, modelId, row);
            this.getModel().setValue("allocatesign", (Object)(temp.getId() + "!" + temp.getType() + "!" + entityId), row);
        }
    }

    @Override
    public boolean isRecordEmpty(AllocateRecord allocateRecord) {
        return allocateRecord.getMixRecords().size() == 0;
    }

    @Override
    public boolean checkDetailDataChanged(List<DynamicObject> curVersionRecords, AllocateRecord allocateRecord) {
        return false;
    }

    protected TemplateEntryPojo bindTemplateCols(DynamicObject entry, int row) {
        String templateType = StringUtils.isEmpty((String)entry.getString("templatetype")) ? TemplateTypeEnum.BUDGET.getCode() : entry.getString("templatetype");
        DynamicObject template = TemplateTypeEnum.APPLY.getCode().equals(templateType) ? entry.getDynamicObject("applytemplate") : entry.getDynamicObject("template");
        if (template == null) {
            return null;
        }
        this.getModel().setValue("tempnumber", (Object)template.getString("number"), row);
        this.getModel().setValue("tempname", (Object)template.getString("name"), row);
        this.getModel().setValue("temptype", (Object)templateType, row);
        return new TemplateEntryPojo(Long.valueOf(template.getLong("id")), templateType);
    }

    protected Long bindEntityCols(DynamicObject entry, Long modelId, int row) {
        return 0L;
    }

    protected void loadTemplateTree(Long bizModelId) {
        List rootRelates;
        if (((Boolean)this.getCache("hasLoad_temp", Boolean.class, () -> false)).booleanValue()) {
            return;
        }
        Long modelId = this.getModelId();
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        DynamicObjectCollection templateCatalogs = QueryServiceHelper.query((String)"eb_templatecatalog", (String)"id, number, name, parent, sequence", (QFilter[])new QFilter[]{qFilter});
        HashMap<Long, List<Long>> relateMap = new HashMap<Long, List<Long>>(16);
        HashMap<Long, BasedataPojo> catalogInfos = new HashMap<Long, BasedataPojo>(16);
        ArrayList topCatalogs = new ArrayList(16);
        ArrayList<Long> catalogs = new ArrayList<Long>(16);
        HashMap<Long, Integer> catalogSeq = new HashMap<Long, Integer>(16);
        long rootCatalog = 0L;
        for (DynamicObject templateCatalog : templateCatalogs) {
            long pkId = templateCatalog.getLong("id");
            long parentId = templateCatalog.getLong("parent");
            String number = templateCatalog.getString("number");
            if (parentId == 0L && "root".equals(number)) {
                rootCatalog = pkId;
                continue;
            }
            List childCatalogs = relateMap.computeIfAbsent(parentId, k -> new ArrayList(16));
            if (!childCatalogs.contains(pkId)) {
                childCatalogs.add(pkId);
            }
            catalogInfos.put(pkId, new BasedataPojo(Long.valueOf(pkId), templateCatalog.getString("name"), number));
            catalogs.add(pkId);
            catalogSeq.put(pkId, templateCatalog.getInt("sequence"));
        }
        QFilter qFilter1 = new QFilter("businessmodel", "=", (Object)bizModelId);
        DynamicObjectCollection datasets = QueryServiceHelper.query((String)"eb_dataset", (String)"id", (QFilter[])new QFilter[]{qFilter, qFilter1});
        Set datasetIds = datasets.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        QFilter qFilter2 = new QFilter("dataset", "in", datasetIds);
        qFilter2.and("templatestatus", "in", Arrays.asList("B", ""));
        DynamicObjectCollection templates = QueryServiceHelper.query((String)"eb_templateentity", (String)"id, number, name, templatecatalog, templatestatus", (QFilter[])new QFilter[]{qFilter, qFilter2}, (String)"number");
        HashMap<Long, BasedataPojo> templateInfos = new HashMap<Long, BasedataPojo>(16);
        templates.forEach(e -> {
            long pkId = e.getLong("id");
            long catalogId = e.getLong("templatecatalog");
            List containTemplates = relateMap.computeIfAbsent(catalogId, k -> new ArrayList(16));
            if (!containTemplates.contains(pkId)) {
                containTemplates.add(pkId);
            }
            templateInfos.put(pkId, new BasedataPojo(Long.valueOf(pkId), e.getString("name"), e.getString("number")));
        });
        if (rootCatalog != 0L && (rootRelates = (List)relateMap.get(rootCatalog)) != null) {
            topCatalogs.addAll(rootRelates);
        }
        int count = 0;
        TreeNode root = new TreeNode();
        root.setId("0");
        root.setParentid("");
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"ExecuteAnalyseUtil_2", (String)"epm-eb-business", (Object[])new Object[0]));
        ArrayList<TreeNode> children = new ArrayList<TreeNode>(2);
        TreeNode budgetTreeNode = new TreeNode();
        budgetTreeNode.setId("1");
        budgetTreeNode.setText(ResManager.loadKDString((String)"\u9884\u7b97\u6a21\u677f", (String)"ReportSchemeEditPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        children.add(budgetTreeNode);
        TreeNode applyTreeNode = this.getApplyTemplateNode(modelId, bizModelId);
        int applyTempCount = 0;
        if (applyTreeNode == null) {
            applyTreeNode = new TreeNode();
            applyTreeNode.setId("2");
        } else {
            Map data = (Map)applyTreeNode.getData();
            applyTempCount = Integer.parseInt((String)data.get("templateCount"));
        }
        applyTreeNode.setText(ResManager.loadKDString((String)"\u7533\u62a5\u6a21\u677f", (String)"ReportSchemeEditPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        children.add(applyTreeNode);
        root.setChildren(children);
        List _catalogs = catalogs.stream().filter(topCatalogs::contains).sorted((o1, o2) -> {
            Integer seq1 = (Integer)catalogSeq.get(o1);
            Integer seq2 = (Integer)catalogSeq.get(o2);
            if (seq1 == null) {
                if (seq2 == null) {
                    return 0;
                }
                return -1;
            }
            if (seq2 == null) {
                return 1;
            }
            return seq1.compareTo(seq2);
        }).collect(Collectors.toList());
        topCatalogs.removeAll(_catalogs);
        topCatalogs.addAll(_catalogs);
        ArrayList<TreeNode> budgetChildren = new ArrayList<TreeNode>(16);
        for (Long catalog : topCatalogs) {
            count += this.buildTreeNodes(budgetChildren, relateMap, catalogInfos, templateInfos, "0", catalog);
        }
        if (budgetChildren.size() != 0) {
            budgetTreeNode.setChildren(budgetChildren);
        }
        TreeView tempTree = (TreeView)this.getControl("temp_tree");
        tempTree.deleteAllNodes();
        tempTree.addNode(root);
        tempTree.expand("0");
        this.updateLabelValue("label_temp_all", count + applyTempCount);
        this.updateLabelValue("label_temp_focus", 0);
        this.putCache("temp_tree", root);
    }

    private int buildTreeNodes(List<TreeNode> children, Map<Long, List<Long>> relateMap, Map<Long, BasedataPojo> catalogInfos, Map<Long, BasedataPojo> templateInfos, String parentId, Long curNodeId) {
        TreeNode treeNode = new TreeNode();
        BasedataPojo basedataPojo = catalogInfos.get(curNodeId);
        if (basedataPojo != null) {
            treeNode.setId(String.valueOf(curNodeId));
            treeNode.setParentid(parentId);
            treeNode.setText(basedataPojo.getNumber() + " " + basedataPojo.getName());
            treeNode.setLeaf(false);
            HashMap<String, String> data = new HashMap<String, String>(16);
            data.put("name", basedataPojo.getName());
            data.put("number", basedataPojo.getNumber());
            data.put("templatetype", "0");
            treeNode.setData(data);
            int count = 0;
            ArrayList<TreeNode> children_new = new ArrayList<TreeNode>(16);
            List<Long> relates = relateMap.get(curNodeId);
            if (relates != null) {
                for (Long relate : relates) {
                    count += this.buildTreeNodes(children_new, relateMap, catalogInfos, templateInfos, String.valueOf(curNodeId), relate);
                }
            }
            if (count != 0) {
                treeNode.setChildren(children_new);
                children.add(treeNode);
            }
            return count;
        }
        basedataPojo = templateInfos.get(curNodeId);
        if (basedataPojo != null) {
            treeNode.setId(String.valueOf(curNodeId));
            treeNode.setParentid(parentId);
            treeNode.setText(basedataPojo.getNumber() + " " + basedataPojo.getName());
            treeNode.setLeaf(true);
            HashMap<String, String> data = new HashMap<String, String>(16);
            data.put("name", basedataPojo.getName());
            data.put("number", basedataPojo.getNumber());
            data.put("templatetype", "0");
            treeNode.setData(data);
            children.add(treeNode);
            return 1;
        }
        return 0;
    }

    private TreeNode getApplyTemplateNode(Long modelId, Long bizRangeId) {
        int templateCount = 0;
        List datasetIds = BusinessModelServiceHelper.getInstance().queryDataSetIds(bizRangeId);
        QFilter modelQf = new QFilter("model", "=", (Object)modelId);
        QFilter tempStatusQf = new QFilter("templatestatus", "=", (Object)"1");
        QFilter datasetQf = new QFilter("dataset", "in", (Object)datasetIds);
        HashMap<String, ArrayList<TreeNode>> map = new HashMap<String, ArrayList<TreeNode>>(16);
        try (DataSet templateDataSet = QueryServiceHelper.queryDataSet((String)"queryApplyTemplate", (String)"eb_applytemplate", (String)"id,name,number,templatetype as templatecatalog,templatestatus", (QFilter[])new QFilter[]{modelQf, tempStatusQf, datasetQf}, (String)"number");){
            while (templateDataSet.hasNext()) {
                Row next = templateDataSet.next();
                TreeNode treeNode = new TreeNode();
                treeNode.setId(next.getString("id"));
                treeNode.setLongNumber(next.getString("number"));
                treeNode.setText(next.getString("number") + " " + next.getString("name"));
                HashMap<String, String> dataMap = new HashMap<String, String>(3);
                dataMap.put("number", next.getString("number"));
                dataMap.put("name", next.getString("name"));
                dataMap.put("templatetype", "1");
                treeNode.setData(dataMap);
                ArrayList<TreeNode> treeNodes = (ArrayList<TreeNode>)map.get(next.getString("templatecatalog"));
                treeNode.setParentid(next.getString("templatecatalog"));
                if (treeNodes == null) {
                    treeNodes = new ArrayList<TreeNode>(16);
                    map.put(next.getString("templatecatalog"), treeNodes);
                }
                treeNodes.add(treeNode);
                ++templateCount;
            }
        }
        TreeNode rootNode = null;
        HashMap<String, TreeNode> catalogMap = new HashMap<String, TreeNode>(16);
        try (DataSet catalogDataSet = QueryServiceHelper.queryDataSet((String)"queryApplyTemplateCatalog", (String)"eb_applytemplatelog", (String)"id,name,number,parent", (QFilter[])modelQf.toArray(), (String)"level,sequence");){
            while (catalogDataSet.hasNext()) {
                Row next = catalogDataSet.next();
                TreeNode treeNode = new TreeNode();
                treeNode.setId(next.getString("id"));
                treeNode.setLongNumber(next.getString("number"));
                treeNode.setText(next.getString("name"));
                HashMap<String, String> dataMap = new HashMap<String, String>(16);
                dataMap.put("number", next.getString("number"));
                dataMap.put("name", next.getString("name"));
                dataMap.put("templatetype", "1");
                dataMap.put("noDetail", "true");
                treeNode.setData(dataMap);
                catalogMap.put(next.getString("id"), treeNode);
                String parent = next.getString("parent");
                if (StringUtils.isEmpty((String)parent) || "0".equals(parent)) {
                    rootNode = treeNode;
                } else {
                    treeNode.setParentid(parent);
                    TreeNode treeNode1 = (TreeNode)catalogMap.get(parent);
                    ArrayList<TreeNode> children = treeNode1.getChildren();
                    if (children == null) {
                        children = new ArrayList<TreeNode>(16);
                        treeNode1.setChildren(children);
                    }
                    children.add(treeNode);
                }
                if (!map.containsKey(next.getString("id"))) continue;
                List treeNodes = (List)map.get(next.getString("id"));
                treeNode.setChildren(treeNodes);
            }
        }
        if (rootNode != null) {
            Map data = (Map)rootNode.getData();
            data.put("templateCount", String.valueOf(templateCount));
        }
        return rootNode;
    }
}

