/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.approvetype.aproveAuditType;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.business.approvetype.aproveAuditType.ApproveMixType;
import kd.epm.eb.common.approveBill.Entity.AllocateDetailRecord;
import kd.epm.eb.common.approveBill.Entity.AllocateRecord;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.common.pojo.TemplateEntryPojo;
import kd.epm.eb.common.templateperm.TemplateTypeEnum;
import kd.epm.eb.common.utils.ConvertUtils;

public class ApproveTempType
extends ApproveMixType {
    public ApproveTempType(IFormView view, IDataModel model) {
        super(view, model);
    }

    @Override
    public void fillAllocateEntry(AllocateRecord allocateRecord, DynamicObjectCollection records, long curDataVersion, String type) {
        List detailRecords = allocateRecord.getTemplateRecords();
        AllocateDetailRecord detailRecord = (AllocateDetailRecord)detailRecords.get(0);
        List templates = detailRecord.getTemplates();
        for (TemplateEntryPojo template : templates) {
            DynamicObject newRow = records.addNew();
            String templateType = template.getType();
            if (TemplateTypeEnum.APPLY.getCode().equals(templateType)) {
                newRow.set("applytemplate", (Object)template.getId());
            } else {
                newRow.set("template", (Object)template.getId());
            }
            newRow.set("templatetype", (Object)templateType);
            newRow.set("audittype", (Object)type);
            newRow.set("dataversion", (Object)curDataVersion);
        }
    }

    @Override
    public AllocateRecord buildToAllocateRecordAndFilter(QFilter qFilter, Map<Long, TemplateEntryPojo> templateBaseInfo) {
        AllocateRecord record = new AllocateRecord();
        AllocateDetailRecord detailRecord = new AllocateDetailRecord();
        List<TemplateEntryPojo> templates = this.getSelectedTemplates(templateBaseInfo);
        detailRecord.setTemplates(templates);
        record.addTemplateRecord(detailRecord);
        this.addTemplateQFilter(qFilter, templates.stream().map(template -> template.getId()).collect(Collectors.toList()));
        return record;
    }

    @Override
    protected void buildDetailRecords(AllocateRecord record, Set<Long> toQueryTemplates, Set<Long> toQueryEntities, QFilter qFilter, Long templateId, String templateType, Long entityId, String entityRange) {
        AllocateDetailRecord detailRecord;
        List templateRecords = record.getTemplateRecords();
        if (templateRecords.size() == 0) {
            detailRecord = new AllocateDetailRecord();
            record.addTemplateRecord(detailRecord);
        } else {
            detailRecord = (AllocateDetailRecord)templateRecords.get(0);
        }
        ArrayList<TemplateEntryPojo> templates = detailRecord.getTemplates();
        if (templates == null) {
            templates = new ArrayList<TemplateEntryPojo>(16);
            detailRecord.setTemplates(templates);
        }
        templates.add(new TemplateEntryPojo(templateId, templateType));
        if (qFilter != null) {
            toQueryTemplates.add(templateId);
        }
    }

    @Override
    protected void setPanelVisible(List<String> unVisiblePanels, List<String> visiblePanels) {
        this.changeVisible(unVisiblePanels, visiblePanels, "temp_panel");
        this.changeVisible(unVisiblePanels, visiblePanels, "tempnumber");
        this.changeVisible(unVisiblePanels, visiblePanels, "tempname");
        this.changeVisible(unVisiblePanels, visiblePanels, "tabap1");
    }

    @Override
    protected void loadOtherTree(Long bizModelId) {
    }

    @Override
    public void buildAllocatedRecordFromDB(Map<Long, AllocateDetailRecord> recordMap, AllocateRecord allocateRecord, long pkId, long templateId, String templateType, long entityId, String range, String name, long dataVersion) {
        ArrayList<TemplateEntryPojo> templates;
        AllocateDetailRecord detailRecord = recordMap.get(pkId);
        if (detailRecord == null) {
            detailRecord = new AllocateDetailRecord();
            recordMap.put(pkId, detailRecord);
            allocateRecord.addTemplateRecord(detailRecord);
            detailRecord.setRecordId(Long.valueOf(pkId));
            detailRecord.setRecordName(name);
            detailRecord.setRecordVersion(Long.valueOf(dataVersion));
        }
        if ((templates = detailRecord.getTemplates()) == null) {
            templates = new ArrayList<TemplateEntryPojo>(16);
            detailRecord.setTemplates(templates);
        }
        templates.add(new TemplateEntryPojo(Long.valueOf(templateId), templateType));
    }

    @Override
    public void addToHasAllocateRecordEntry(AllocateRecord toAllocateRecord, Map<Long, TemplateEntryPojo> templateBaseInfo, Long viewId) {
        List templateRecords = toAllocateRecord.getTemplateRecords();
        if (templateRecords.size() != 0) {
            AllocateDetailRecord allocateDetailRecord = (AllocateDetailRecord)templateRecords.get(0);
            List templates = allocateDetailRecord.getTemplates();
            if (templates == null) {
                return;
            }
            for (TemplateEntryPojo template : templates) {
                int newEntryRow = this.getModel().createNewEntryRow("entryentity_allocate");
                TemplateEntryPojo templateInfo = templateBaseInfo.get(template.getId());
                this.getModel().setValue("tempname", (Object)templateInfo.getName(), newEntryRow);
                this.getModel().setValue("tempnumber", (Object)templateInfo.getNumber(), newEntryRow);
                this.getModel().setValue("temptype", (Object)templateInfo.getType(), newEntryRow);
                this.getModel().setValue("allocatesign", (Object)(template.getId() + "!" + template.getType() + "!0"), newEntryRow);
            }
        }
    }

    @Override
    protected Long bindEntityCols(DynamicObject entry, Long modelId, int row) {
        return 0L;
    }

    @Override
    public boolean isRecordEmpty(AllocateRecord allocateRecord) {
        return allocateRecord.getTemplateRecords().size() == 0;
    }

    @Override
    public boolean checkDetailDataChanged(List<DynamicObject> curVersionRecords, AllocateRecord allocateRecord) {
        List detailRecords = allocateRecord.getTemplateRecords();
        if (detailRecords == null || detailRecords.size() == 0) {
            return curVersionRecords.size() != 0;
        }
        AllocateDetailRecord detailRecord = (AllocateDetailRecord)detailRecords.get(0);
        List templates = detailRecord.getTemplates();
        List templateIds = templates.stream().map(template -> template.getId()).collect(Collectors.toList());
        if (curVersionRecords.size() != templates.size()) {
            return true;
        }
        for (DynamicObject curVersionRecord : curVersionRecords) {
            long template2 = curVersionRecord.getLong("template.id");
            if (templateIds.contains(template2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<MemberQuoteDao> getMemberQuotes(DynamicObjectCollection records, Long pkId, Long modelId) {
        ArrayList<MemberQuoteDao> memberQuotes = new ArrayList<MemberQuoteDao>(16);
        for (DynamicObject record : records) {
            MemberTypeEnum memberTypeEnum;
            Object template;
            String templateType = record.getString("templatetype");
            if (TemplateTypeEnum.APPLY.getCode().equals(templateType)) {
                template = record.get("applytemplate");
                memberTypeEnum = MemberTypeEnum.APPLYTEMPLATE;
            } else {
                template = record.get("template");
                memberTypeEnum = MemberTypeEnum.TEMPLATE;
            }
            long templateId = 0L;
            if (template instanceof DynamicObject) {
                templateId = ((DynamicObject)template).getLong("id");
            } else {
                if (!(template instanceof Long)) continue;
                templateId = ConvertUtils.toLong((Object)template);
            }
            memberQuotes.add(new MemberQuoteDao(modelId, Long.valueOf(0L), Long.valueOf(0L), Long.valueOf(templateId), memberTypeEnum, MemberQuoteResourceEnum.APPROVE_TYPE, pkId));
        }
        return memberQuotes;
    }

    @Override
    public void removeHasAllocateRecords(AllocateRecord toAllocateRecord) {
        if (toAllocateRecord == null) {
            return;
        }
        List templateRecords = toAllocateRecord.getTemplateRecords();
        if (templateRecords == null || templateRecords.size() == 0) {
            return;
        }
        AllocateDetailRecord detailRecord = (AllocateDetailRecord)templateRecords.get(0);
        List templates = detailRecord.getTemplates();
        if (templates == null) {
            return;
        }
        AllocateRecord record = this.buildHasAllocateRecords(null);
        if (record == null) {
            return;
        }
        List _templateRecords = record.getTemplateRecords();
        if (_templateRecords == null || _templateRecords.size() == 0) {
            return;
        }
        AllocateDetailRecord _detailRecord = (AllocateDetailRecord)_templateRecords.get(0);
        List _templates = _detailRecord.getTemplates();
        if (_templates == null) {
            return;
        }
        templates.removeAll(_templates);
    }
}

