/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.bailorg;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.epm.eb.business.bailorg.entity.SimpleObject;
import kd.epm.eb.business.bailorg.pojo.BailOrgRelation;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.DynamicObjectUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;

public class BailOrgService {
    private static final BailOrgService instance = new BailOrgService();

    public static BailOrgService getInstance() {
        return instance;
    }

    public Map<String, Long> getDefaultBailOrgIds(Long modelId, Set<String> entityNumbers) {
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue() || CollectionUtils.isEmpty(entityNumbers)) {
            return new HashMap<String, Long>(0);
        }
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("entity.number", "in", entityNumbers);
        qFilter.and("entryentity.default", "=", (Object)true);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_bailorg_entity", (String)"entity.number,entryentity.bailorg.id", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isEmpty((Collection)query)) {
            return new HashMap<String, Long>(0);
        }
        return query.stream().collect(Collectors.toMap(e -> e.getString("entity.number"), e -> e.getLong("entryentity.bailorg.id")));
    }

    public BailOrgRelation getBailOrgRelation(Long modelId, String entityNumber) {
        DynamicObjectCollection entryEntity = QueryServiceHelper.query((String)"eb_bailorg_entity", (String)"entity.id,entryentity.bailorg.id as bailOrgId, entryentity.bailorg.name as bailOrgName, entryentity.bailorg.number as bailOrgNumber, entryentity.default as default", (QFilter[])new QFilter("model", "=", (Object)modelId).and("entity.number", "=", (Object)entityNumber).toArray());
        if (entryEntity == null || entryEntity.size() == 0) {
            return null;
        }
        BailOrgRelation bailOrgRelation = new BailOrgRelation();
        bailOrgRelation.setEntityId(((DynamicObject)entryEntity.get(0)).getLong("entity.id"));
        bailOrgRelation.setEntityNumber(entityNumber);
        for (DynamicObject entry : entryEntity) {
            bailOrgRelation.addBailOrg(new SimpleObject(entry.getLong("bailOrgId"), entry.getString("bailOrgName"), entry.getString("bailOrgNumber")));
            if (!entry.getBoolean("default")) continue;
            bailOrgRelation.setDefaultBailId(entry.getLong("bailOrgId"));
        }
        return bailOrgRelation;
    }

    public Map<Long, BailOrgRelation> getBailOrgRelationMap(Long modelId, Set<String> entityNumberSet) {
        HashMap<Long, BailOrgRelation> result = new HashMap<Long, BailOrgRelation>(16);
        DynamicObjectCollection entryEntity = QueryServiceHelper.query((String)"eb_bailorg_entity", (String)"entity.id,entryentity.bailorg.id as bailOrgId, entryentity.bailorg.name as bailOrgName,entity.number, entryentity.bailorg.number as bailOrgNumber, entryentity.default as default", (QFilter[])new QFilter("model", "=", (Object)modelId).and("entity.number", "in", entityNumberSet).toArray());
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return result;
        }
        HashMap<String, DynamicObjectCollection> entityEntryEntityMap = new HashMap<String, DynamicObjectCollection>(16);
        for (DynamicObject dynamicObject : entryEntity) {
            DynamicObjectCollection dynamicObjects = entityEntryEntityMap.computeIfAbsent(dynamicObject.getString("entity.number"), t -> new DynamicObjectCollection());
            dynamicObjects.add((Object)dynamicObject);
        }
        for (Map.Entry entry : entityEntryEntityMap.entrySet()) {
            BailOrgRelation bailOrgRelation = new BailOrgRelation();
            bailOrgRelation.setEntityId(((DynamicObject)entryEntity.get(0)).getLong("entity.id"));
            bailOrgRelation.setEntityNumber((String)entry.getKey());
            DynamicObjectCollection value = (DynamicObjectCollection)entry.getValue();
            for (DynamicObject dynamicObject : value) {
                bailOrgRelation.addBailOrg(new SimpleObject(dynamicObject.getLong("bailOrgId"), dynamicObject.getString("bailOrgName"), dynamicObject.getString("bailOrgNumber")));
                if (!dynamicObject.getBoolean("default")) continue;
                bailOrgRelation.setDefaultBailId(dynamicObject.getLong("bailOrgId"));
            }
            result.put(((DynamicObject)entryEntity.get(0)).getLong("entity.id"), bailOrgRelation);
        }
        return result;
    }

    public Map<String, BailOrgRelation> getModelBailOrgRelation(Long modelId, Set<String> entityNumbers) {
        DynamicObject[] bailOrgRelationObjects;
        LinkedHashMap<String, BailOrgRelation> bailOrgRelationHashMap = new LinkedHashMap<String, BailOrgRelation>(16);
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        if (entityNumbers != null) {
            qFilter.and("entity.number", "in", entityNumbers);
        }
        if ((bailOrgRelationObjects = BusinessDataServiceHelper.load((String)"eb_bailorg_entity", (String)"entity,entryentity.bailorg,entryentity.default", (QFilter[])qFilter.toArray())) == null || bailOrgRelationObjects.length == 0) {
            return bailOrgRelationHashMap;
        }
        HashMap<String, DynamicObject> entityToBailInfoMap = new HashMap<String, DynamicObject>(bailOrgRelationObjects.length);
        for (DynamicObject object : bailOrgRelationObjects) {
            if (object.getString("entity.number") == null) continue;
            entityToBailInfoMap.put(object.getString("entity.number"), object);
        }
        for (Map.Entry bailInfoEntry : entityToBailInfoMap.entrySet()) {
            String entityNumber = (String)bailInfoEntry.getKey();
            DynamicObject object = (DynamicObject)bailInfoEntry.getValue();
            BailOrgRelation bailOrgRelation = new BailOrgRelation();
            bailOrgRelationHashMap.put(entityNumber, bailOrgRelation);
            bailOrgRelation.setEntityNumber(entityNumber);
            bailOrgRelation.setEntityId(object.getLong("entity.id"));
            DynamicObjectCollection entryentity = object.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryentity) {
                bailOrgRelation.addBailOrg(new SimpleObject(entry.getLong("bailorg.id"), entry.getString("bailorg.name"), entry.getString("bailorg.number")));
                if (!entry.getBoolean("default")) continue;
                bailOrgRelation.setDefaultBailId(entry.getLong("bailorg.id"));
            }
        }
        return bailOrgRelationHashMap;
    }

    public void saveBailOrgRelation(Long modelId, Map<String, BailOrgRelation> allEntityBailOrgRelation) {
        if (allEntityBailOrgRelation == null) {
            return;
        }
        DeleteServiceHelper.delete((String)"eb_bailorg_entity", (QFilter[])new QFilter("model", "=", (Object)modelId).toArray());
        ArrayList<DynamicObject> objects = new ArrayList<DynamicObject>(allEntityBailOrgRelation.size());
        for (Map.Entry<String, BailOrgRelation> entry : allEntityBailOrgRelation.entrySet()) {
            String entityNumber = entry.getKey();
            BailOrgRelation bailOrgRelation = entry.getValue();
            List<SimpleObject> bailOrgs = bailOrgRelation.getBailOrgs();
            if (StringUtils.isEmpty((CharSequence)entityNumber) || CollectionUtils.isEmpty(bailOrgs)) continue;
            DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"eb_bailorg_entity");
            objects.add(object);
            object.set("model", (Object)modelId);
            object.set("entity", (Object)bailOrgRelation.getEntityId());
            DynamicObjectCollection entryEntity = object.getDynamicObjectCollection("entryentity");
            for (SimpleObject bailOrg : bailOrgs) {
                DynamicObject bailOrgRow = entryEntity.addNew();
                bailOrgRow.set("bailorg", (Object)bailOrg.getId());
                bailOrgRow.set("default", (Object)bailOrg.getId().equals(bailOrgRelation.getDefaultBailId()));
            }
        }
        if (objects.size() > 0) {
            DynamicObjectUtils.save(objects);
        }
    }

    public DynamicObjectCollection getEntityMemberObjects(Long modelId, String selectField, long viewId, String entityViewNumber, boolean isFilterManagePerm, Set<String> numberLimitRange) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        QFBuilder orgBuilder = this.getOrgBuilder(modelId, viewId, entityViewNumber, isFilterManagePerm, numberLimitRange, modelCache.getModelobj().isModelByEB());
        String entityName = this.getEntityName(entityViewNumber, modelCache.getModelobj().isModelByEB());
        return QueryServiceHelper.query((String)entityName, (String)selectField, (QFilter[])orgBuilder.toArray(), (String)"level,dseq,number");
    }

    public List<String> getBaseViewEntityMemberContainAnalyse(Long modelId, boolean isFilterManagePerm, Set<String> numberLimitRange) {
        DynamicObjectCollection manageEntityObjects = this.getEntityMemberObjects(modelId, "number", 0L, null, isFilterManagePerm, numberLimitRange);
        if (CollectionUtils.isNotEmpty((Collection)manageEntityObjects)) {
            return manageEntityObjects.stream().map(e -> e.getString("number")).collect(Collectors.toList());
        }
        return new ArrayList<String>(0);
    }

    public Set<String> getEntityMemberNumberSet(Long modelId, String entityViewNumber, boolean isFilterManagePerm, Set<String> numberLimitRange) {
        DynamicObjectCollection manageEntityObjects;
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Dimension dimension = modelCache.getDimension(SysDimensionEnum.Entity.getNumber());
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model", "=", (Object)modelId));
        builder.add(new QFilter("dimension", "=", (Object)dimension.getId()));
        builder.add(new QFilter("number", "=", (Object)entityViewNumber));
        DynamicObject viewDy = QueryServiceHelper.queryOne((String)"eb_dimensionview", (String)"id", (QFilter[])builder.toArray());
        long viewId = 0L;
        if (viewDy != null) {
            viewId = viewDy.getLong("id");
        }
        if (CollectionUtils.isNotEmpty((Collection)(manageEntityObjects = this.getEntityMemberObjects(modelId, "number", viewId, entityViewNumber, isFilterManagePerm, numberLimitRange)))) {
            return manageEntityObjects.stream().map(e -> e.getString("number")).collect(Collectors.toSet());
        }
        return new HashSet<String>(0);
    }

    public TreeNode buildEntityMemberTree(Long modelId, long viewId, String entityViewNumber, boolean isFilterManagePerm, Set<String> numberLimitRange) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        QFBuilder orgBuilder = this.getOrgBuilder(modelId, viewId, entityViewNumber, isFilterManagePerm, numberLimitRange, modelCache.getModelobj().isModelByEB());
        String entityName = this.getEntityName(entityViewNumber, modelCache.getModelobj().isModelByEB());
        return this.buildOrgTreeByFilters(entityName, orgBuilder.toFilter());
    }

    public TreeNode buildOrgTreeByFilters(String entityName, QFilter qFilter) {
        TreeNode rootNode = new TreeNode();
        if (qFilter == null) {
            return rootNode;
        }
        HashMap<String, TreeNode> longNumberMap = new HashMap<String, TreeNode>(16);
        try (DataSet epmOrgDataSet = QueryServiceHelper.queryDataSet((String)"buildOrgTreeByFilters", (String)entityName, (String)"id,name,number,longnumber,parent", (QFilter[])qFilter.toArray(), (String)"level,dseq,number");){
            while (epmOrgDataSet.hasNext()) {
                int i;
                Row next = epmOrgDataSet.next();
                Long orgId = next.getLong("id");
                String longNumber = next.getString("longnumber");
                TreeNode node = new TreeNode();
                String nodeId = String.valueOf(orgId);
                node.setId(nodeId);
                node.setLongNumber(next.getString("number"));
                node.setText(next.getString("name"));
                longNumberMap.put(longNumber, node);
                String parentLongNumber = "";
                if (longNumber.lastIndexOf("!") != -1) {
                    parentLongNumber = longNumber.substring(0, longNumber.lastIndexOf("!"));
                }
                while (!longNumberMap.containsKey(parentLongNumber) && StringUtils.isNotEmpty((CharSequence)parentLongNumber) && (i = parentLongNumber.lastIndexOf("!")) != -1) {
                    parentLongNumber = parentLongNumber.substring(0, i);
                }
                if (StringUtils.isEmpty((CharSequence)parentLongNumber)) {
                    rootNode = node;
                    continue;
                }
                if (!longNumberMap.containsKey(parentLongNumber)) continue;
                TreeNode parentNode = (TreeNode)longNumberMap.get(parentLongNumber);
                node.setParentid(parentNode.getId());
                parentNode.addChild(node);
            }
        }
        return rootNode;
    }

    public QFBuilder getOrgBuilder(Long modelId, long viewId, String entityViewNumber, boolean isFilterManagePerm, Set<String> numberLimitRange, boolean isEb) {
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", (Object)modelId);
        if (CollectionUtils.isNotEmpty(numberLimitRange)) {
            builder.add("number", "in", numberLimitRange);
        }
        builder.add("dimension.number", "=", (Object)"Entity");
        if (StringUtils.isNotBlank((CharSequence)entityViewNumber) && !isEb) {
            builder.add("view", "=", (Object)viewId);
        }
        if (isFilterManagePerm) {
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
            Member rootMember = modelCache.getRootMember(SysDimensionEnum.Entity.getNumber(), Long.valueOf(viewId));
            Set permMembNumbers = DimMembPermHelper.getPermMembNumbers((String)"Entity", (Long)modelId, (Long)0L, (Long)viewId, (DimMembPermType)DimMembPermType.MANAGER, (boolean)true);
            if (permMembNumbers != null) {
                QFilter qFilter = new QFilter("number", "in", (Object)permMembNumbers);
                qFilter.or("number", "=", (Object)rootMember.getNumber());
                builder.add(qFilter);
            }
        }
        return builder;
    }

    public String getEntityName(String entityViewNumber, boolean isEb) {
        if (StringUtils.isBlank((CharSequence)entityViewNumber) || isEb) {
            return SysDimensionEnum.Entity.getMemberTreemodel();
        }
        return "eb_viewmember";
    }

    public Map<String, SimpleObject> getAdminOrgInfoMap(Collection<String> numbers) {
        HashMap<String, SimpleObject> adminOrgInfoMap = new HashMap<String, SimpleObject>(16);
        if (CollectionUtils.isEmpty(numbers)) {
            return adminOrgInfoMap;
        }
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        qFilter.and("enable", "=", (Object)true);
        qFilter.and("number", "in", numbers);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bos_adminorg", (String)"id,name,number", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isNotEmpty((Collection)query)) {
            for (DynamicObject object : query) {
                adminOrgInfoMap.put(object.getString("number"), new SimpleObject(object.getLong("id"), object.getString("name"), object.getString("number")));
            }
        }
        return adminOrgInfoMap;
    }

    public Set<String> getViewNumberSet(Long modelId, String dimNumber, Set<String> numbers) {
        DynamicObjectCollection query;
        if (ApplicationTypeEnum.EB.getIndex().equals(ModelCacheContext.getOrCreate((Long)modelId).getModelobj().getReportType())) {
            return Sets.newHashSet((Object[])new String[]{"E001"});
        }
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("dimension.number", "=", (Object)dimNumber);
        if (numbers != null) {
            qFilter.and("number", "in", numbers);
        }
        if (CollectionUtils.isNotEmpty((Collection)(query = QueryServiceHelper.query((String)"eb_dimensionview", (String)"number", (QFilter[])qFilter.toArray())))) {
            return query.stream().map(e -> e.getString("number")).collect(Collectors.toSet());
        }
        return new HashSet<String>(0);
    }

    public Map<String, BailOrgRelation> allocateBailOrgRelation(Long modelId, List<DynamicObject> toSaveMembers) {
        if (CollectionUtils.isEmpty(toSaveMembers)) {
            return null;
        }
        Map<String, Long> numberToIdMap = toSaveMembers.stream().collect(Collectors.toMap(e -> e.getString("number"), e -> e.getLong("id")));
        Map<String, SimpleObject> adminOrgInfoMap = this.getAdminOrgInfoMap(numberToIdMap.keySet());
        Map<String, BailOrgRelation> modelBailOrgRelation = this.getModelBailOrgRelation(modelId, null);
        Map<String, Set<String>> orgRelEntities = this.getOrgRelEntities(modelBailOrgRelation, adminOrgInfoMap.keySet());
        for (Map.Entry<String, Long> entry : numberToIdMap.entrySet()) {
            String memNumber = entry.getKey();
            Long memId = entry.getValue();
            SimpleObject simpleObject = adminOrgInfoMap.get(memNumber);
            if (simpleObject == null || this.checkMoreToMore(memNumber, orgRelEntities, modelBailOrgRelation)) continue;
            BailOrgRelation bailOrgRelation = new BailOrgRelation();
            modelBailOrgRelation.put(memNumber, bailOrgRelation);
            bailOrgRelation.setEntityId(memId);
            bailOrgRelation.setEntityNumber(memNumber);
            bailOrgRelation.addBailOrg(simpleObject);
            bailOrgRelation.setDefaultBailId(simpleObject.getId());
        }
        return modelBailOrgRelation;
    }

    private boolean checkMoreToMore(String memNumber, Map<String, Set<String>> orgRelEntities, Map<String, BailOrgRelation> modelBailOrgRelation) {
        Set<String> entityNumbers = orgRelEntities.get(memNumber);
        if (entityNumbers != null) {
            for (String entityNumber : orgRelEntities.get(memNumber)) {
                if (modelBailOrgRelation.get(entityNumber) == null || modelBailOrgRelation.get(entityNumber).getBailOrgSize() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public Map<String, Set<String>> getOrgRelEntities(Map<String, BailOrgRelation> modelBailOrgRelation, Set<String> orgNumbers) {
        if (modelBailOrgRelation == null || modelBailOrgRelation.size() == 0) {
            return new HashMap<String, Set<String>>(0);
        }
        HashMap<String, Set<String>> orgRelEntities = new HashMap<String, Set<String>>(modelBailOrgRelation.size());
        for (Map.Entry<String, BailOrgRelation> entry : modelBailOrgRelation.entrySet()) {
            BailOrgRelation bailOrgRelation = entry.getValue();
            for (SimpleObject bailOrg : bailOrgRelation.getBailOrgs()) {
                if (orgNumbers != null && !orgNumbers.contains(bailOrg.getNumber())) continue;
                Set entityNumbers = orgRelEntities.computeIfAbsent(bailOrg.getNumber(), e -> new HashSet(2));
                entityNumbers.add(bailOrgRelation.getEntityNumber());
            }
        }
        return orgRelEntities;
    }

    public Map<String, Long> getEntityBaseViewMemberId(Long modelId, Collection<String> entityNumbers) {
        DynamicObjectCollection query;
        HashMap<String, Long> memNumToIdMap = new HashMap<String, Long>(16);
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        if (entityNumbers != null) {
            qFilter.and("number", "in", entityNumbers);
        }
        if (CollectionUtils.isNotEmpty((Collection)(query = QueryServiceHelper.query((String)SysDimensionEnum.Entity.getMemberTreemodel(), (String)"id,number", (QFilter[])qFilter.toArray())))) {
            return query.stream().collect(Collectors.toMap(e -> e.getString("number"), e -> e.getLong("id")));
        }
        return memNumToIdMap;
    }

    public Map<String, Map<String, Long>> getEntityViewMemberId(Long modelId, Collection<String> viewNumbers, Collection<String> entityNumbers, boolean isEbModel) {
        HashMap<String, Map<String, Long>> viewMap = new HashMap<String, Map<String, Long>>(16);
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        if (isEbModel) {
            DynamicObjectCollection query = QueryServiceHelper.query((String)SysDimensionEnum.Entity.getMemberTreemodel(), (String)"id,number", (QFilter[])qFilter.toArray());
            if (CollectionUtils.isNotEmpty((Collection)query)) {
                Map<String, Long> memMap = query.stream().collect(Collectors.toMap(e -> e.getString("number"), e -> e.getLong("id")));
                viewMap.put("E001", memMap);
            }
        } else {
            DynamicObjectCollection query;
            if (CollectionUtils.isNotEmpty(viewNumbers)) {
                qFilter.and("view.number", "in", viewNumbers);
            }
            if (entityNumbers != null) {
                qFilter.and("shownumber", "in", entityNumbers);
            }
            if (CollectionUtils.isNotEmpty((Collection)(query = QueryServiceHelper.query((String)"eb_viewmember", (String)"id,shownumber,memberid,view.number", (QFilter[])qFilter.toArray())))) {
                for (DynamicObject object : query) {
                    Map memberMap = viewMap.computeIfAbsent(object.getString("view.number"), f -> Maps.newLinkedHashMap());
                    memberMap.put(object.getString("shownumber"), object.getLong("memberid"));
                }
            }
        }
        return viewMap;
    }

    public List<Object[]> getDimensionViews(Long modelId, String dimNumber) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("dimension.number", "=", (Object)dimNumber);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_dimensionview", (String)"name,number,usage", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isNotEmpty((Collection)query)) {
            ArrayList<Object[]> viewInfo = new ArrayList<Object[]>(query.size());
            for (DynamicObject object : query) {
                viewInfo.add(new Object[]{object.getString("number"), object.getString("name"), object.getString("usage")});
            }
            return viewInfo;
        }
        return new ArrayList<Object[]>(0);
    }

    public Map<String, Long> getEntityViewIdMap(Long modelId) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("dimension.number", "=", (Object)SysDimensionEnum.Entity.getNumber());
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_dimensionview", (String)"id,name,number", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isNotEmpty((Collection)query)) {
            return query.stream().collect(Collectors.toMap(e -> e.getString("number"), e -> e.getLong("id")));
        }
        return new HashMap<String, Long>(0);
    }
}

