/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.bailorg.graph;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.epm.eb.business.bailorg.graph.ForwardLine;
import kd.epm.eb.business.bailorg.graph.Graph;

public class GraphHouse<K, V> {
    Set<Graph<K, V>> graphs = new HashSet<Graph<K, V>>();
    Map<Object, Graph<K, V>> nodeToGraphMap = new HashMap<Object, Graph<K, V>>(16);

    public void addLine(K source, V target) {
        Graph<K, V> graph;
        Graph<K, V> sourceRelGraph = this.nodeToGraphMap.get(source);
        Graph<K, V> targetRelGraph = this.nodeToGraphMap.get(target);
        if (sourceRelGraph != null && targetRelGraph != null) {
            this.graphs.remove(sourceRelGraph);
            this.graphs.remove(targetRelGraph);
            graph = this.combineGraph(sourceRelGraph, targetRelGraph, this.nodeToGraphMap);
        } else {
            graph = sourceRelGraph != null ? sourceRelGraph : (targetRelGraph != null ? targetRelGraph : new Graph());
        }
        this.graphs.add(graph);
        graph.addLine(new ForwardLine<K, V>(source, target));
        this.nodeToGraphMap.put(source, graph);
        this.nodeToGraphMap.put(target, graph);
    }

    private Graph<K, V> combineGraph(Graph<K, V> sourceRelGraph, Graph<K, V> targetRelGraph, Map<Object, Graph<K, V>> nodeToGraphMap) {
        sourceRelGraph.addLines(targetRelGraph.lines);
        for (ForwardLine line : targetRelGraph.lines) {
            nodeToGraphMap.put(line.source, sourceRelGraph);
            nodeToGraphMap.put(line.target, sourceRelGraph);
        }
        return sourceRelGraph;
    }

    public ForwardLine<K, V> isExistMoreToMore() {
        if (this.graphs != null) {
            for (Graph<K, V> graph : this.graphs) {
                ForwardLine<K, V> line = graph.isExistMoreToMore();
                if (line == null) continue;
                return line;
            }
        }
        return null;
    }
}

