/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.billimpexp;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.epm.eb.business.billimpexp.BillColGroup;
import kd.epm.eb.business.billimpexp.col.BaseDataCol;
import kd.epm.eb.business.billimpexp.col.BooleanCol;
import kd.epm.eb.business.billimpexp.col.ComboCol;
import kd.epm.eb.business.billimpexp.col.DateCol;
import kd.epm.eb.business.billimpexp.col.DecimalCol;
import kd.epm.eb.business.billimpexp.col.ExcelCol;
import kd.epm.eb.business.billimpexp.col.ItemClassCol;
import kd.epm.eb.business.billimpexp.col.ItemClassTypeCol;
import kd.epm.eb.business.billimpexp.col.MulBaseDataCol;
import kd.epm.eb.business.billimpexp.col.NumberCol;
import kd.epm.eb.business.billimpexp.col.TextCol;
import kd.epm.eb.common.applybill.Count;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.excel.WriteExcelUtil;
import kd.epm.eb.common.utils.excelImport.POIUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jetbrains.annotations.NotNull;

public class BillImpExpUtils {
    public static Workbook buildXFileWithHead(BillColGroup colGroup) {
        XSSFWorkbook workBook = new XSSFWorkbook();
        XSSFSheet sheet = workBook.createSheet("sheet1");
        boolean showColGroup = colGroup.isShowEntryColGroup();
        int rowIndex = 0;
        XSSFRow entryKeyRow = sheet.createRow(rowIndex++);
        XSSFRow tipRow = sheet.createRow(rowIndex++);
        XSSFRow groupTitleRow = showColGroup ? sheet.createRow(rowIndex++) : null;
        XSSFRow fieldNumberRow = sheet.createRow(rowIndex++);
        XSSFRow fieldNameRow = sheet.createRow(rowIndex);
        CellStyle titleCellStyle = WriteExcelUtil.createCellStyle((Workbook)workBook, (short)IndexedColors.GREY_25_PERCENT.getIndex(), (short)IndexedColors.BLACK.getIndex(), (int)210, (BorderStyle)BorderStyle.THIN);
        CellStyle titleCellStyleRed = WriteExcelUtil.createCellStyle((Workbook)workBook, (short)IndexedColors.GREY_25_PERCENT.getIndex(), (short)10, (int)210, (BorderStyle)BorderStyle.THIN);
        titleCellStyle.setAlignment(HorizontalAlignment.CENTER);
        titleCellStyleRed.setAlignment(HorizontalAlignment.CENTER);
        titleCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        titleCellStyleRed.setVerticalAlignment(VerticalAlignment.CENTER);
        CellStyle redStyle = POIUtils.getErrorStyle((Workbook)workBook);
        HashMap<Integer, Integer> maxColWidth = new HashMap<Integer, Integer>(16);
        XSSFCell secondRowCell = tipRow.createCell(0);
        secondRowCell.setCellValue(ResManager.loadKDString((String)"1\u3001\u8bf7\u5c06\u9f20\u6807\u79fb\u5230\u7070\u8272\u6807\u9898\u884c\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42\n2\u3001\u7ea2\u8272\u7684\u5b57\u6bb5\u4e3a\u5fc5\u5f55\u5b57\u6bb5", (String)"BillImpExpUtils_1", (String)"epm-eb-business", (Object[])new Object[0]));
        secondRowCell.setCellStyle(redStyle);
        BillImpExpUtils.addWidth(maxColWidth, 0, 40);
        XSSFCellStyle stringStyle = workBook.createCellStyle();
        stringStyle.setDataFormat(workBook.createDataFormat().getFormat("@"));
        LinkedList<BillColGroup> groupList = new LinkedList<BillColGroup>();
        groupList.add(colGroup);
        while (!groupList.isEmpty()) {
            BillColGroup billColGroup = (BillColGroup)groupList.poll();
            XSSFCell cell = entryKeyRow.createCell(billColGroup.getBeginIndex());
            String entryShowName = billColGroup.getTitle() + "#" + billColGroup.getGroupKey();
            cell.setCellValue(entryShowName);
            BillImpExpUtils.addWidth(maxColWidth, billColGroup.getBeginIndex(), BillImpExpUtils.getStrLength(entryShowName));
            if (billColGroup.isMustInput()) {
                cell.setCellStyle(redStyle);
            }
            billColGroup.getBaseCols().values().forEach(arg_0 -> BillImpExpUtils.lambda$buildXFileWithHead$0(titleCellStyleRed, titleCellStyle, fieldNumberRow, fieldNameRow, maxColWidth, groupTitleRow, colGroup, sheet, (CellStyle)stringStyle, arg_0));
            groupList.addAll(billColGroup.getChildEntrys().values());
        }
        if (groupTitleRow != null) {
            String preVal = null;
            int beginIndex = 0;
            int endIndex = groupTitleRow.getLastCellNum();
            int preLastIndex = endIndex - 1;
            for (int col = 0; col < endIndex; ++col) {
                XSSFCell cell = groupTitleRow.getCell(col);
                String currentVal = cell.getStringCellValue();
                if (!StringUtils.equals(preVal, (String)currentVal) || col == preLastIndex) {
                    if (preVal != null) {
                        if (StringUtils.equals((String)preVal, (String)fieldNumberRow.getCell(beginIndex).getStringCellValue())) {
                            sheet.addMergedRegion(new CellRangeAddress(groupTitleRow.getRowNum(), fieldNumberRow.getRowNum(), beginIndex, col - 1));
                        } else {
                            sheet.addMergedRegion(new CellRangeAddress(groupTitleRow.getRowNum(), groupTitleRow.getRowNum(), beginIndex, col - 1));
                        }
                    }
                    preVal = currentVal;
                    beginIndex = col;
                }
                if (col != preLastIndex) continue;
                if (StringUtils.equals((String)currentVal, (String)fieldNumberRow.getCell(col).getStringCellValue())) {
                    sheet.addMergedRegion(new CellRangeAddress(groupTitleRow.getRowNum(), fieldNumberRow.getRowNum(), col, col));
                    continue;
                }
                sheet.addMergedRegion(new CellRangeAddress(groupTitleRow.getRowNum(), groupTitleRow.getRowNum(), col, col));
            }
        }
        maxColWidth.forEach((colIndex, width) -> sheet.setColumnWidth(colIndex.intValue(), width * 255));
        return workBook;
    }

    private static void addColGroupInfo(XSSFRow groupRow, XSSFRow numberRow, ExcelCol col, BillColGroup colInfo, CellStyle titleCellStyle, int colIndex) {
        if (groupRow != null) {
            String colGroupTitle = colInfo.getColGroupInfo().get(col.getColGroupKey());
            XSSFCell cell = groupRow.createCell(colIndex);
            cell.setCellStyle(titleCellStyle);
            if (StringUtils.isEmpty((String)colGroupTitle) && numberRow != null) {
                XSSFCell numberCell = numberRow.getCell(colIndex);
                if (numberCell != null) {
                    cell.setCellValue(numberCell.getStringCellValue());
                }
            } else {
                cell.setCellValue(colGroupTitle);
            }
        }
    }

    private static void addColCell(XSSFRow numberRow, XSSFRow nameRow, int colIndex, Map<Integer, Integer> maxColWidth, String key, String title, CellStyle titleCellStyle, IDataEntityProperty property) {
        if (numberRow != null) {
            XSSFCell keyCell = numberRow.createCell(colIndex);
            keyCell.setCellValue(key);
            BillImpExpUtils.addWidth(maxColWidth, colIndex, BillImpExpUtils.getStrLength(key));
            if (titleCellStyle != null) {
                keyCell.setCellStyle(titleCellStyle);
            }
        }
        if (nameRow != null) {
            XSSFCell titleCell = nameRow.createCell(colIndex);
            titleCell.setCellValue(title);
            BillImpExpUtils.addWidth(maxColWidth, colIndex, BillImpExpUtils.getStrLength(title));
            if (titleCellStyle != null) {
                titleCell.setCellStyle(titleCellStyle);
            }
            if (property != null) {
                Comment cellComment = BillImpExpUtils.createCellComment((Sheet)nameRow.getSheet(), property);
                titleCell.setCellComment(cellComment);
            }
        }
    }

    public static Comment createCellComment(Sheet sheet, IDataEntityProperty property) {
        Drawing drawing = sheet.createDrawingPatriarch();
        Comment comment = drawing.createCellComment((ClientAnchor)new XSSFClientAnchor());
        String commentText = null;
        if (property instanceof BasedataProp) {
            commentText = ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\uff0c\u6587\u672c\u683c\u5f0f", (String)"BillImpExpUtils_2", (String)"epm-eb-business", (Object[])new Object[0]);
        } else if (property instanceof MulBasedataProp) {
            commentText = ResManager.loadKDString((String)"\u591a\u9009\u57fa\u7840\u8d44\u6599\uff0c\u6587\u672c\u683c\u5f0f\uff0c\u591a\u4e2a\u503c\u7528\u9017\u53f7\u5206\u9694", (String)"BillImpExpUtils_3", (String)"epm-eb-business", (Object[])new Object[0]);
        } else if (property instanceof ComboProp) {
            StringBuilder sb = new StringBuilder();
            sb.append(ResManager.loadKDString((String)"\u679a\u4e3e\u9879\uff0c\u6587\u672c\u683c\u5f0f\uff0c\u503c\u6620\u5c04\uff1a\n", (String)"BillImpExpUtils_4", (String)"epm-eb-business", (Object[])new Object[0]));
            ComboProp comboProp = (ComboProp)property;
            for (ValueMapItem valueMapItem : comboProp.getComboItems()) {
                sb.append(valueMapItem.getValue()).append('=').append(valueMapItem.getName().getLocaleValue()).append('\n');
            }
            commentText = sb.toString();
        } else if (property instanceof IntegerProp) {
            StringBuilder sb = new StringBuilder();
            IntegerProp integerProp = (IntegerProp)property;
            String dataScope = integerProp.getDataScope();
            if (dataScope != null) {
                sb.append(ResManager.loadResFormat((String)"\u6574\u6570,\u6570\u503c\u8303\u56f4%1", (String)"BillImpExpUtils_15", (String)"epm-eb-business", (Object[])new Object[]{dataScope}));
            } else {
                sb.append(ResManager.loadKDString((String)"\u6574\u6570", (String)"BillImpExpUtils_5", (String)"epm-eb-business", (Object[])new Object[0]));
            }
            commentText = sb.toString();
        } else if (property instanceof DecimalProp) {
            StringBuilder sb = new StringBuilder();
            DecimalProp decimalProp = (DecimalProp)property;
            String dataScope = decimalProp.getDataScope();
            if (dataScope != null) {
                sb.append(ResManager.loadResFormat((String)"\u6d6e\u70b9\u6570\uff0c\u6574\u4f53\u7cbe\u5ea6\uff1a%1 ,\u5c0f\u6570\u7cbe\u5ea6\uff1a%2,\u6570\u503c\u8303\u56f4%3", (String)"BillImpExpUtils_6", (String)"epm-eb-business", (Object[])new Object[]{decimalProp.getPrecision(), decimalProp.getScale(), dataScope}));
            } else {
                sb.append(ResManager.loadResFormat((String)"\u6d6e\u70b9\u6570\uff0c\u6574\u4f53\u7cbe\u5ea6\uff1a%1 \uff0c\u5c0f\u6570\u7cbe\u5ea6\uff1a%2\u3002", (String)"BillImpExpUtils_7", (String)"epm-eb-business", (Object[])new Object[]{decimalProp.getPrecision(), decimalProp.getScale()}));
            }
            commentText = sb.toString();
        } else if (property instanceof TextProp) {
            StringBuilder sb = new StringBuilder();
            TextProp textProp = (TextProp)property;
            sb.append(ResManager.loadResFormat((String)"\u6587\u672c\uff0c\u957f\u5ea6\u8303\u56f4[%1,%2]", (String)"BillImpExpUtils_8", (String)"epm-eb-business", (Object[])new Object[]{textProp.getMinLenth(), textProp.getMaxLenth()}));
            commentText = sb.toString();
        } else if (property instanceof BooleanProp) {
            commentText = ResManager.loadKDString((String)"\u5e03\u5c14\u503c\uff0c\u6587\u672c\u683c\u5f0f\uff0c\u503c\u6620\u5c04\uff1a\n1 = \u662f\n0 = \u5426", (String)"BillImpExpUtils_9", (String)"epm-eb-business", (Object[])new Object[0]);
        } else if (property instanceof DateProp) {
            commentText = ResManager.loadKDString((String)"\u65e5\u671f", (String)"BillImpExpUtils_10", (String)"epm-eb-business", (Object[])new Object[0]);
        }
        comment.setString((RichTextString)new XSSFRichTextString(commentText));
        return comment;
    }

    private static void addWidth(Map<Integer, Integer> maxWidth, int colIndex, int newWidth) {
        Integer width = maxWidth.get(colIndex);
        if (width == null || width < newWidth) {
            maxWidth.put(colIndex, newWidth);
        }
    }

    public static int getStrLength(String showStr) {
        int count = 1;
        if (showStr != null) {
            for (int index = 0; index < showStr.length(); ++index) {
                char c = showStr.charAt(index);
                if (Character.isLowerCase(c) || Character.isDigit(c)) {
                    ++count;
                    continue;
                }
                count += 2;
            }
        }
        return count;
    }

    public static String getNumberProp(IDataEntityProperty prop) {
        return BillImpExpUtils.getNumberProp(prop, false);
    }

    public static String getNumberProp(IDataEntityProperty prop, boolean needDisplaceName) {
        return BillImpExpUtils.getPropInfo(prop, needDisplaceName, true);
    }

    public static String getNameProp(IDataEntityProperty prop, boolean needDisplaceName) {
        return BillImpExpUtils.getPropInfo(prop, needDisplaceName, false);
    }

    public static String getPropInfo(IDataEntityProperty prop, boolean needDisplaceName, boolean isNumber) {
        BasedataProp basedataProp = null;
        if (prop instanceof BasedataProp) {
            basedataProp = (BasedataProp)prop;
        } else if (prop instanceof MulBasedataProp) {
            basedataProp = (BasedataProp)((MulBasedataProp)prop).getRefBaseProp();
        }
        if (basedataProp != null) {
            IDataEntityProperty property;
            IDataEntityProperty iDataEntityProperty = property = isNumber ? basedataProp.getNumbProp() : basedataProp.getDispProp();
            if (property == null) {
                if (needDisplaceName) {
                    return isNumber ? ResManager.loadKDString((String)"\u7f16\u7801", (String)"BillImpExpUtils_11", (String)"epm-eb-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u540d\u79f0", (String)"BillImpExpUtils_12", (String)"epm-eb-business", (Object[])new Object[0]);
                }
                return isNumber ? basedataProp.getNumberProp() : basedataProp.getDisplayProp();
            }
            if (needDisplaceName) {
                return property.getDisplayName().getLocaleValue();
            }
            return property.getName();
        }
        return null;
    }

    public static BasedataProp getBaseDataProp(IDataEntityProperty property) {
        if (property != null) {
            if (property instanceof BasedataProp) {
                return (BasedataProp)property;
            }
            if (property instanceof MulBasedataProp) {
                MulBasedataProp mulBasedataProp = (MulBasedataProp)property;
                return (BasedataProp)mulBasedataProp.getRefBaseProp();
            }
        }
        return null;
    }

    public static void openImportPage(IFormView currFormView, String targetEntityKey, String entityName, Map<String, Object> params, CloseCallBack closeCallBack) {
        if (currFormView == null || StringUtils.isEmpty((String)targetEntityKey)) {
            return;
        }
        if (StringUtils.isEmpty((String)entityName)) {
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)targetEntityKey);
            if (dataEntityType == null) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u83b7\u53d6%1\u5143\u6570\u636e\u4fe1\u606f\u5931\u8d25", (String)"BillImpExpUtils_13", (String)"epm-eb-business", (Object[])new Object[]{targetEntityKey}));
            }
            entityName = dataEntityType.getDisplayName().getLocaleValue();
        }
        HashMap<String, Object> customParam = new HashMap<String, Object>(16);
        String title = ResManager.loadResFormat((String)"%1\u5bfc\u5165", (String)"BillImpExpUtils_14", (String)"epm-eb-business", (Object[])new Object[]{entityName});
        if (params != null) {
            customParam.put("IMPPARAMSKEY", params);
        }
        customParam.put("IMPENTITYKEY", targetEntityKey);
        String cusPluginName = "kd.epm.eb.formplugin.billimpexp.BillImportTempPlugin";
        BillImpExpUtils.openImportTempPage(currFormView, customParam, null, title, cusPluginName, closeCallBack);
    }

    public static void openImportTempPage(IFormView currFormView, Map<String, Object> customParam, String tempFormKey, String title, String cusPluginName, CloseCallBack closeCallBack) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setCaption(title);
        if (CollectionUtils.isNotEmpty(customParam)) {
            formShowParameter.getCustomParams().putAll(customParam);
        }
        if (tempFormKey == null) {
            tempFormKey = "eb_billimport";
        }
        formShowParameter.setFormId(tempFormKey);
        if (closeCallBack != null) {
            formShowParameter.setCloseCallBack(closeCallBack);
        }
        if (cusPluginName == null) {
            cusPluginName = "kd.epm.eb.formplugin.billimpexp.AbstractImportTempPlugin";
        }
        formShowParameter.addCustPlugin(cusPluginName);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        currFormView.showForm(formShowParameter);
    }

    public static BillColGroup getColConfig(String entryKey, IDataEntityType entityType, boolean ignoreSeqColumn, IFormView formView, boolean sortByMetaData, boolean selColGroupInfo, Set<String> ignoreCols) {
        Control control;
        BillColGroup colGroup = new BillColGroup();
        colGroup.setGroupKey(entryKey);
        colGroup.setMustInput(true);
        colGroup.setTitle(entityType.getDisplayName().getLocaleValue());
        DataEntityPropertyCollection properties = entityType.getProperties();
        Object propertyList = null;
        HashMap<String, String> colGroupInfo = new HashMap<String, String>(16);
        HashMap<String, String> colMapGroupInfo = new HashMap<String, String>(16);
        if (formView != null && (sortByMetaData || selColGroupInfo) && (control = formView.getControl(entryKey)) instanceof EntryGrid) {
            EntryGrid grid = (EntryGrid)control;
            HashMap<String, Integer> sortIndex = new HashMap<String, Integer>(16);
            for (Control item : grid.getItems()) {
                if (item instanceof Container) {
                    for (Control col : ((Container)item).getItems()) {
                        sortIndex.put(col.getKey(), sortIndex.size());
                        colMapGroupInfo.put(col.getKey(), item.getKey());
                    }
                    colGroupInfo.put(item.getKey(), item.getKey());
                    continue;
                }
                sortIndex.put(item.getKey(), sortIndex.size());
            }
            if (sortByMetaData && sortIndex.size() > 0) {
                propertyList = new ArrayList(properties);
                propertyList.sort(Comparator.comparingInt(e -> sortIndex.getOrDefault(e.getName(), 0)));
            }
        }
        if (propertyList == null) {
            propertyList = properties;
        }
        propertyList.forEach(prop -> {
            if (ignoreCols == null || !ignoreCols.contains(prop.getName())) {
                ExcelCol col;
                if (prop instanceof EntryProp) {
                    BillColGroup entryConfig = BillImpExpUtils.getColConfig(prop.getName(), ((EntryProp)prop).getItemType(), ignoreSeqColumn);
                    entryConfig.setMustInput(((EntryProp)prop).isEntryMustInput());
                    colGroup.getChildEntrys().put(prop.getName(), entryConfig);
                } else if (!(prop instanceof PKFieldProp || ignoreSeqColumn && "seq".equals(prop.getName()) || prop instanceof ItemClassTypeProp || (col = BillImpExpUtils.buildCol(prop)) == null)) {
                    String refColGroupKey = (String)colMapGroupInfo.get(col.getKey());
                    col.setColGroupKey(refColGroupKey);
                    if (col instanceof ItemClassCol) {
                        ItemClassCol itemClassCol = (ItemClassCol)col;
                        ExcelCol typeCol = BillImpExpUtils.checkAndBuildItemClassType(itemClassCol, properties);
                        if (typeCol != null) {
                            typeCol.setColGroupKey(refColGroupKey);
                            colGroup.getBaseCols().put(typeCol.getKey(), typeCol);
                            colGroup.getBaseCols().put(itemClassCol.getKey(), itemClassCol);
                        }
                    } else {
                        colGroup.getBaseCols().put(col.getKey(), col);
                    }
                }
            }
        });
        if (selColGroupInfo && colGroupInfo.size() > 0) {
            colGroup.getColGroupInfo().putAll(colGroupInfo);
            colGroup.setShowEntryColGroup(true);
        }
        return colGroup;
    }

    public static BillColGroup getColConfig(String entryKey, IDataEntityType entityType, boolean ignoreSeqColumn) {
        return BillImpExpUtils.getColConfig(entryKey, entityType, ignoreSeqColumn, null, false, false, null);
    }

    private static ExcelCol checkAndBuildItemClassType(ItemClassCol itemClassCol, DataEntityPropertyCollection properties) {
        IDataEntityProperty typeProp;
        ExcelCol result = null;
        String itemClassTypeName = itemClassCol.getItemClassTypeName();
        if (itemClassTypeName != null && (typeProp = (IDataEntityProperty)properties.get((Object)itemClassTypeName)) instanceof ItemClassTypeProp) {
            result = BillImpExpUtils.buildCol(typeProp);
        }
        return result;
    }

    public static void updateColIndex(BillColGroup billColGroup, Count colCount) {
        billColGroup.setBeginIndex(colCount.getCount());
        billColGroup.getBaseCols().values().forEach(col -> {
            col.setColIndex(colCount.getCount());
            colCount.addOne();
            if (col instanceof BaseDataCol) {
                colCount.addOne();
            }
        });
        billColGroup.setEndIndex(colCount.getCount());
        billColGroup.getChildEntrys().values().forEach(entry -> BillImpExpUtils.updateColIndex(entry, colCount));
    }

    public static ExcelCol buildCol(@NotNull IDataEntityProperty fieldProp) {
        ExcelCol col = fieldProp instanceof ItemClassProp ? new ItemClassCol() : (fieldProp instanceof ItemClassTypeProp ? new ItemClassTypeCol() : (fieldProp instanceof BasedataProp ? new BaseDataCol() : (fieldProp instanceof MulBasedataProp ? new MulBaseDataCol() : (fieldProp instanceof ComboProp ? new ComboCol() : (fieldProp instanceof DateProp ? new DateCol() : (fieldProp instanceof TextProp ? new TextCol() : (fieldProp instanceof IntegerProp ? new NumberCol() : (fieldProp instanceof DecimalProp ? new DecimalCol() : (fieldProp instanceof BooleanProp ? new BooleanCol() : new ExcelCol())))))))));
        String key = fieldProp.getName();
        String numberProp = BillImpExpUtils.getNumberProp(fieldProp);
        if (numberProp != null) {
            key = key + "." + numberProp;
        }
        col.setKey(key);
        col.setColIndex(-1);
        boolean ok = col.initConfig(fieldProp);
        if (!ok) {
            col = null;
        }
        return col;
    }

    private static /* synthetic */ void lambda$buildXFileWithHead$0(CellStyle titleCellStyleRed, CellStyle titleCellStyle, XSSFRow fieldNumberRow, XSSFRow fieldNameRow, Map maxColWidth, XSSFRow groupTitleRow, BillColGroup colGroup, XSSFSheet sheet, CellStyle stringStyle, ExcelCol col) {
        CellStyle cellStyle = col.isMustInput() ? titleCellStyleRed : titleCellStyle;
        int colIndex = col.getColIndex();
        if (col instanceof BaseDataCol) {
            BaseDataCol baseDataCol = (BaseDataCol)col;
            String numKey = col.getKey();
            String numDisplay = col.getTitle() + "." + baseDataCol.getNumberPropText();
            String nameKey = numKey.replace("." + baseDataCol.getNumberProp(), "." + baseDataCol.getNameProp());
            String nameDisplay = col.getTitle() + "." + baseDataCol.getNamePropText();
            BillImpExpUtils.addColCell(fieldNumberRow, fieldNameRow, colIndex, maxColWidth, numKey, numDisplay, cellStyle, col.getProp());
            BillImpExpUtils.addColGroupInfo(groupTitleRow, fieldNumberRow, col, colGroup, titleCellStyle, colIndex);
            BillImpExpUtils.addColCell(fieldNumberRow, fieldNameRow, colIndex + 1, maxColWidth, nameKey, nameDisplay, titleCellStyle, null);
            BillImpExpUtils.addColGroupInfo(groupTitleRow, fieldNumberRow, col, colGroup, titleCellStyle, colIndex + 1);
            if (StringUtils.isNotEmpty((String)baseDataCol.getNumberFormat())) {
                sheet.setDefaultColumnStyle(colIndex, stringStyle);
            }
            if (StringUtils.isNotEmpty((String)baseDataCol.getNameFormat())) {
                sheet.setDefaultColumnStyle(colIndex + 1, stringStyle);
            }
        } else {
            BillImpExpUtils.addColCell(fieldNumberRow, fieldNameRow, colIndex, maxColWidth, col.getKey(), col.getTitle(), cellStyle, col.getProp());
            BillImpExpUtils.addColGroupInfo(groupTitleRow, fieldNumberRow, col, colGroup, titleCellStyle, colIndex);
        }
    }
}

