/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.billimpexp;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.epm.eb.business.billimpexp.BillColGroup;
import kd.epm.eb.business.billimpexp.ImportLogger;
import kd.epm.eb.business.billimpexp.col.ExcelCol;

public class ImportContext {
    private String fileUrl;
    private ImportLogger importLogger = new ImportLogger();
    private BillColGroup colGroup;
    private boolean currentBillHasError;
    private Map<Long, Integer> rowIndexIdMap;
    private Set<Integer> errorBillSeqs = new HashSet<Integer>(16);
    private Map<String, ExcelCol> allColInfo;
    private Map<String, String> allColGroupName;

    public ImportContext() {
    }

    public ImportContext(String fileUrl) {
        this.fileUrl = fileUrl;
    }

    public String getFileUrl() {
        return this.fileUrl;
    }

    public boolean isCurrentBillHasError() {
        return this.currentBillHasError;
    }

    public void setCurrentBillHasError(boolean currentBillHasError) {
        this.currentBillHasError = currentBillHasError;
    }

    public void setAllColInfo(Map<String, ExcelCol> allColInfo) {
        this.allColInfo = allColInfo;
    }

    public void setAllColGroupName(Map<String, String> allColGroupName) {
        this.allColGroupName = allColGroupName;
    }

    public ImportLogger getImportLogger() {
        return this.importLogger;
    }

    public void setImportLogger(ImportLogger importLogger) {
        this.importLogger = importLogger;
    }

    public Map<Long, Integer> getRowIndexIdMap() {
        if (this.rowIndexIdMap == null) {
            this.rowIndexIdMap = new HashMap<Long, Integer>(16);
        }
        return this.rowIndexIdMap;
    }

    public void setRowIndexIdMap(Map<Long, Integer> rowIndexIdMap) {
        this.rowIndexIdMap = rowIndexIdMap;
    }

    public BillColGroup getColGroup() {
        return this.colGroup;
    }

    public void setColGroup(BillColGroup colGroup) {
        this.colGroup = colGroup;
    }

    public Set<Integer> getErrorBillSeqs() {
        return this.errorBillSeqs;
    }

    public void addErrorInfo(String colKey, String errorInfo, Long rowId) {
        Integer index = this.getRowIndexIdMap().get(rowId);
        if (index != null) {
            this.addErrorInfo(colKey, errorInfo, index);
        }
    }

    public void addErrorInfo(String colKey, String errorInfo, int rowIndex) {
        ExcelCol col;
        if (colKey != null && this.allColInfo != null && (col = this.allColInfo.get(colKey)) != null) {
            String colGroupKey = col.getColGroupKey();
            String colTitle = colGroupKey != null && this.allColGroupName != null ? this.allColGroupName.get(colGroupKey) + "." + col.getTitle() : col.getTitle();
            errorInfo = "\u3010" + colTitle + "\u3011" + errorInfo;
        }
        this.setCurrentBillHasError(true);
        this.getImportLogger().addLog(rowIndex, errorInfo);
    }
}

