/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.billimpexp;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.epm.eb.common.utils.excel.WriteExcelUtil;
import kd.epm.eb.common.utils.excelImport.POIUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ImportLogger {
    private Map<Integer, List<String>> logInfos = new HashMap<Integer, List<String>>(16);
    private static final int maxInfoSize = 1000;

    public void addLog(int rowIndex, String logInfo) {
        List infos = this.logInfos.computeIfAbsent(rowIndex, key -> new LinkedList());
        infos.add(logInfo);
    }

    public void writeLog2Sheet(Sheet sheet) {
        if (!this.logInfos.isEmpty()) {
            int lastRowNum = sheet.getLastRowNum();
            if (lastRowNum < 0 || sheet.getRow(0) == null) {
                sheet.createRow(0);
            }
            CellStyle redStyle = POIUtils.getErrorStyle((Workbook)sheet.getWorkbook());
            redStyle.setWrapText(false);
            WriteExcelUtil.moveColumns((Sheet)sheet, (int)0, (int)1);
            sheet.setColumnWidth(0, 8000);
            Cell firstCell = sheet.getRow(0).createCell(0);
            firstCell.setCellValue(ResManager.loadKDString((String)"\u9519\u8bef\u4fe1\u606f", (String)"ImportLogger_1", (String)"epm-eb-business", (Object[])new Object[0]));
            int endRowIndex = sheet.getLastRowNum();
            StringBuilder sb = new StringBuilder();
            this.logInfos.forEach((rowIndex, infos) -> {
                if (rowIndex >= 0 && rowIndex <= endRowIndex) {
                    Cell cell;
                    infos.forEach(infoStr -> sb.append((String)infoStr).append('\n'));
                    String errorInfo = sb.length() > 1000 ? sb.substring(0, 1000) : sb.toString();
                    Row row = sheet.getRow(rowIndex.intValue());
                    if (row != null && (cell = row.createCell(0)) != null) {
                        cell.setCellStyle(redStyle);
                        cell.setCellValue(errorInfo);
                    }
                    sb.setLength(0);
                }
            });
        }
    }

    public boolean hasLogInfo() {
        return this.logInfos.size() > 0;
    }

    public Map<Integer, List<String>> getLogInfos() {
        return this.logInfos;
    }
}

