/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.billimpexp.col;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.DecimalProp;
import kd.epm.eb.business.billimpexp.col.ExcelCol;
import org.jetbrains.annotations.NotNull;

public class DecimalCol
extends ExcelCol {
    @Override
    public Object checkAndConverData(Object val) {
        DecimalProp decimalProp;
        if ((val = super.checkAndConverData(val)) != null && !this.isNumericStr(val) && !(val instanceof Number)) {
            this.throwError(ResManager.loadKDString((String)"\u683c\u5f0f\u9519\u8bef", (String)"ExcelCol_2", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        if ((decimalProp = (DecimalProp)this.getProp()) != null) {
            BigDecimal bigDecimal;
            if (!decimalProp.checkScope(val)) {
                this.throwError(ResManager.loadResFormat((String)"\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4%1\u3002", (String)"DecimalCol_1", (String)"epm-eb-business", (Object[])new Object[]{decimalProp.getDataScope()}));
            } else if (val != null && (bigDecimal = new BigDecimal(val.toString())).scale() > decimalProp.getScale()) {
                val = bigDecimal.setScale(decimalProp.getScale(), RoundingMode.HALF_DOWN);
            }
        }
        return val;
    }

    private boolean isNumericStr(Object str) {
        if (str instanceof String) {
            Pattern pattern = Pattern.compile("^-?(([1-9]\\d*\\.\\d+)|(0\\.\\d+)|(\\d+))$");
            return pattern.matcher((String)str).matches();
        }
        return false;
    }

    @Override
    protected Object getVal2Show(@NotNull Object val) {
        if (val instanceof BigDecimal) {
            BigDecimal decimal = (BigDecimal)val;
            DecimalProp decimalProp = (DecimalProp)this.getProp();
            if (decimalProp != null) {
                decimal = decimal.setScale(decimalProp.getScale(), RoundingMode.HALF_DOWN);
            }
            return decimal.toPlainString();
        }
        return super.getVal2Show(val);
    }
}

